# Overview
This is a "plugin" for the Video Disk Recorder (VDR).

Written by:
* Joachim Wilke [vdr (at) joachim (minus) wilke (dot) de]
* Matthias Becker [becker (dot) matthias (at) gmail (dot) com]

Project's homepage:          https://github.com/jowi24/vdr-fritz

Latest version available at: https://github.com/jowi24/vdr-fritz/releases

See the file COPYING for license information.

** Note: The HISTORY file may contain information on new features, which are
not yet documented in this README. For up to date information also have a look 
in that file. **

---

# Installation

The Fritz plugin is not very different from other plugins for VDR, most of the 
common installation procedure for plugins, documented in VDR's core 
documentation applies. However, the following build dependecies are required:
  - GCrypt library (libgcrypt)
  - Asio (>= 1.4.1)
  - Boost (>= 1.54.0)

## Cloning the GIT repository

Use `git clone --recursive` to clone submodules, as well.

---

# Description

## Call notification

The Fritz!Box Plugin connects to the Fritz!Box to inform you about
incoming and outgoing calls. As an option, the plugin can automatically mute
VDR and pause replays when a call comes in or goes out.

To enable this feature you have to dial `#96*5*` once with a telephone
connected to the Fritz!Box. This works for all firmware versions >= xx.03.99

You may experience problems when trying to dial `#96*5*` with an ISDN 
telephone. In such a case try to activate "auto keypad", "dial * and #" 
or some similar setting in your ISDN telephone. If your ISDN telephone 
contains no keypad support simply use an analogue telephone instead.

If you do not want to be notified by every call, you can specify a list of
MSNs you are interested on in the plugin's setup. Max. 22 monitored MSNs 
are supported.

Configuration regarding call notification, muting and pausing is done
in the plugin setup menu in VDR.

## Phone book support

The plugin supports multiple phonebooks. In the plugin's setup, you can 
choose which phonebooks are used. The order matters with respect to number
lookup. When a call comes in, the plugin tries to resolve the number using 
the first configured phonebook. If that fails, it tries the second one, and 
so on. 

Only one phonebook can be shown in the plugin's main menu. It is the
first configured phonebook, that has displayable entries. Via VDR's main 
menu you can browse this phone book and initiate calls out of it via the 
[OK]-button. This function uses the telephone you have configures in 
Fritz!Box web interface for this purpose. (In German the menu path is: 
Telefonie > Anrufliste > Wählhilfe) 

### Fritz!Box phone book

This accesses the Fritz!Box phonebook stored on the box itself.

### das-oertliche.de phone book

This tries to resolve any number via the german website das-oertliche.de.
As this is a lookup-only phonebook, it's entries cannot be displayed 
in the main menu... ;-)

### nummerzoeker phone book / tel.local.ch phone book

Same as das-oertliche.de, but for numbers from the Netherlands and Switzerland.

## Fritz!Box call list

Via the colour buttons you can access three different call lists.
Press `[Green]` to see the history of incoming calls. Use `[Yellow]` for the
list of missed calls. Finally `[Blue]` gives you an overview on whom you 
called yourself.

Pressing `[OK]` shows a separate page with details to the selected call.
In this menu you can initiate calls, as in the phone book menu, by pressing
`[Red]`.

---

# Command line options

## Privacy

This plugin logs status and debug information to system log (syslog). By default, 
no sensitive information, like phone numbers or similar are logged. However, for
debugging purposes, this can be enabled, by the `-p` parameter.

### Running custom commands on call events

Using the `-c cmd` parameter, a command or script 'cmd' can be specified, that
is called when an incoming or outgoing call is initiated or finished. The plugin
calls cmd with additional parameters depending on the type of event.
* On incoming or outgoing calls:
  - `cmd CALL [OUT|IN] <connection_id> <remote_number> <remote_name> <local_party> <medium> <medium_name>`
* On call connect:
  - `cmd CONNECT <connection_id>`
* On call disconnect:
  - `cmd DISCONNECT <connection_id> <duration>`
* When all ongoing calls have been finished:
  - `cmd FINISHED`
A sample script is provided in template/on-call.sh.

---

# Screenshots

[![Screenshot 1](https://jowi24.github.io/vdr-fritz/screenshot-fritz1.jpg)](https://jowi24.github.io/vdr-fritz/screenshot-fritz1.jpg)
[![Screenshot 2](https://jowi24.github.io/vdr-fritz/screenshot-fritz2.jpg)](https://jowi24.github.io/vdr-fritz/screenshot-fritz2.jpg)
[![Screenshot 1](https://jowi24.github.io/vdr-fritz/screenshot-fritz3.jpg)](https://jowi24.github.io/vdr-fritz/screenshot-fritz3.jpg)
[![Screenshot 2](https://jowi24.github.io/vdr-fritz/screenshot-fritz4.jpg)](https://jowi24.github.io/vdr-fritz/screenshot-fritz4.jpg)
[![Screenshot 1](https://jowi24.github.io/vdr-fritz/screenshot-fritz5.jpg)](https://jowi24.github.io/vdr-fritz/screenshot-fritz5.jpg)
[![Screenshot 2](https://jowi24.github.io/vdr-fritz/screenshot-fritz6.jpg)](https://jowi24.github.io/vdr-fritz/screenshot-fritz6.jpg)
[![Screenshot 1](https://jowi24.github.io/vdr-fritz/screenshot-fritz7.jpg)](https://jowi24.github.io/vdr-fritz/screenshot-fritz7.jpg)

---

Note: This Plugin has been tested with Fritz!Box Fon WLAN 7390 FW 06.20
However it may also work for other models or firmware versions. For a detailed
list see the plugin's homepage. If you have another model, either positive or 
negative feedback is appreciated. 
 
