/*
 * API for Kerberos Login and Logout Notification plugins
 */
 
#ifndef KLLoginLogoutNotification_h_
#define KLLoginLogoutNotification_h_

#include <KerberosLogin/KerberosLogin.h>

/* API Versions */

enum {
	kKLN_APIVersion_1				= 1,
	kKLN_APIVersion_Current			= kKLN_APIVersion_1
};

/* File types */

const OSType kKLN_PluginFileType = FOUR_CHAR_CODE ('LNot');

/* Login types */

enum {
	kKLN_DialogLogin				= 1,
	kKLN_PasswordLogin				= 2
};

/* Types */

typedef UInt32 KLN_APIVersion;
typedef UInt32 KLN_LoginType;

/* Function prototypes */

#ifdef __cplusplus
extern "C" {
#endif

#pragma export on

KLStatus KerberosLoginNotification_InitializePlugin (
	KLN_APIVersion		inAPIVersion);

KLStatus KerberosLoginNotification_Login (
	KLN_LoginType		inLoginType,
	const char*			inCredentialsCache);

void KerberosLoginNotification_Logout (
	const char*			inCredentialsCache);

#ifdef __cplusplus
}
#endif

#endif /* KLLoginLogoutNotification_h_ */
