/* unrolledlinkedlist.c generated by valac 0.56.3, the Vala compiler
 * generated from unrolledlinkedlist.vala, do not modify */

/* unrolledlinkedlist.vala
 *
 * Copyright (C) 2013-2014  Maciej Piechotka
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Maciej Piechotka <uzytkownik2@gmail.com>
 */

#include "gee.h"
#include <glib.h>
#include <glib-object.h>
#include <string.h>

#define GEE_UNROLLED_LINKED_LIST_NODE_SIZE 29
#define GEE_UNROLLED_LINKED_LIST_SPLIT_POS (((GEE_UNROLLED_LINKED_LIST_NODE_SIZE - 1) / 2) + 1)
#define GEE_UNROLLED_LINKED_LIST_MERGE_THRESHOLD ((GEE_UNROLLED_LINKED_LIST_NODE_SIZE * 4) / 5)

typedef struct _GeeUnrolledLinkedListNode GeeUnrolledLinkedListNode;

#define GEE_FUNCTIONS_TYPE_EQUAL_DATA_FUNC_CLOSURE (gee_functions_equal_data_func_closure_get_type ())
#define GEE_FUNCTIONS_EQUAL_DATA_FUNC_CLOSURE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_FUNCTIONS_TYPE_EQUAL_DATA_FUNC_CLOSURE, GeeFunctionsEqualDataFuncClosure))
#define GEE_FUNCTIONS_EQUAL_DATA_FUNC_CLOSURE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_FUNCTIONS_TYPE_EQUAL_DATA_FUNC_CLOSURE, GeeFunctionsEqualDataFuncClosureClass))
#define GEE_FUNCTIONS_IS_EQUAL_DATA_FUNC_CLOSURE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_FUNCTIONS_TYPE_EQUAL_DATA_FUNC_CLOSURE))
#define GEE_FUNCTIONS_IS_EQUAL_DATA_FUNC_CLOSURE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_FUNCTIONS_TYPE_EQUAL_DATA_FUNC_CLOSURE))
#define GEE_FUNCTIONS_EQUAL_DATA_FUNC_CLOSURE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_FUNCTIONS_TYPE_EQUAL_DATA_FUNC_CLOSURE, GeeFunctionsEqualDataFuncClosureClass))

typedef struct _GeeFunctionsEqualDataFuncClosure GeeFunctionsEqualDataFuncClosure;
typedef struct _GeeFunctionsEqualDataFuncClosureClass GeeFunctionsEqualDataFuncClosureClass;
enum  {
	GEE_UNROLLED_LINKED_LIST_0_PROPERTY,
	GEE_UNROLLED_LINKED_LIST_G_TYPE,
	GEE_UNROLLED_LINKED_LIST_G_DUP_FUNC,
	GEE_UNROLLED_LINKED_LIST_G_DESTROY_FUNC,
	GEE_UNROLLED_LINKED_LIST_SIZE_PROPERTY,
	GEE_UNROLLED_LINKED_LIST_READ_ONLY_PROPERTY,
	GEE_UNROLLED_LINKED_LIST_CAPACITY_PROPERTY,
	GEE_UNROLLED_LINKED_LIST_REMAINING_CAPACITY_PROPERTY,
	GEE_UNROLLED_LINKED_LIST_IS_FULL_PROPERTY,
	GEE_UNROLLED_LINKED_LIST_NUM_PROPERTIES
};
static GParamSpec* gee_unrolled_linked_list_properties[GEE_UNROLLED_LINKED_LIST_NUM_PROPERTIES];
#define _gee_unrolled_linked_list_node_free0(var) ((var == NULL) ? NULL : (var = (gee_unrolled_linked_list_node_free (var), NULL)))
#define _gee_functions_equal_data_func_closure_unref0(var) ((var == NULL) ? NULL : (var = (gee_functions_equal_data_func_closure_unref (var), NULL)))

#define GEE_UNROLLED_LINKED_LIST_TYPE_ITERATOR (gee_unrolled_linked_list_iterator_get_type ())
#define GEE_UNROLLED_LINKED_LIST_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_UNROLLED_LINKED_LIST_TYPE_ITERATOR, GeeUnrolledLinkedListIterator))
#define GEE_UNROLLED_LINKED_LIST_ITERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_UNROLLED_LINKED_LIST_TYPE_ITERATOR, GeeUnrolledLinkedListIteratorClass))
#define GEE_UNROLLED_LINKED_LIST_IS_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_UNROLLED_LINKED_LIST_TYPE_ITERATOR))
#define GEE_UNROLLED_LINKED_LIST_IS_ITERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_UNROLLED_LINKED_LIST_TYPE_ITERATOR))
#define GEE_UNROLLED_LINKED_LIST_ITERATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_UNROLLED_LINKED_LIST_TYPE_ITERATOR, GeeUnrolledLinkedListIteratorClass))

typedef struct _GeeUnrolledLinkedListIterator GeeUnrolledLinkedListIterator;
typedef struct _GeeUnrolledLinkedListIteratorClass GeeUnrolledLinkedListIteratorClass;
#define _g_free0(var) ((var == NULL) ? NULL : (var = (g_free (var), NULL)))
typedef struct _GeeFunctionsEqualDataFuncClosurePrivate GeeFunctionsEqualDataFuncClosurePrivate;
typedef struct _GeeUnrolledLinkedListIteratorPrivate GeeUnrolledLinkedListIteratorPrivate;
enum  {
	GEE_UNROLLED_LINKED_LIST_ITERATOR_0_PROPERTY,
	GEE_UNROLLED_LINKED_LIST_ITERATOR_G_TYPE,
	GEE_UNROLLED_LINKED_LIST_ITERATOR_G_DUP_FUNC,
	GEE_UNROLLED_LINKED_LIST_ITERATOR_G_DESTROY_FUNC,
	GEE_UNROLLED_LINKED_LIST_ITERATOR_VALID_PROPERTY,
	GEE_UNROLLED_LINKED_LIST_ITERATOR_READ_ONLY_PROPERTY,
	GEE_UNROLLED_LINKED_LIST_ITERATOR_NUM_PROPERTIES
};
static GParamSpec* gee_unrolled_linked_list_iterator_properties[GEE_UNROLLED_LINKED_LIST_ITERATOR_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _GeeUnrolledLinkedListPrivate {
	GType g_type;
	GBoxedCopyFunc g_dup_func;
	GDestroyNotify g_destroy_func;
	gint _size;
	gint _stamp;
	GeeUnrolledLinkedListNode* _head;
	GeeUnrolledLinkedListNode* _tail;
	GeeFunctionsEqualDataFuncClosure* _equal_func;
};

struct _GeeUnrolledLinkedListNode {
	GeeUnrolledLinkedListNode* _prev;
	GeeUnrolledLinkedListNode* _next;
	gint _size;
	gpointer _data[29];
};

struct _GeeFunctionsEqualDataFuncClosure {
	GTypeInstance parent_instance;
	volatile int ref_count;
	GeeFunctionsEqualDataFuncClosurePrivate * priv;
	GeeEqualDataFunc func;
	gpointer func_target;
	GDestroyNotify func_target_destroy_notify;
};

struct _GeeFunctionsEqualDataFuncClosureClass {
	GTypeClass parent_class;
	void (*finalize) (GeeFunctionsEqualDataFuncClosure *self);
};

struct _GeeUnrolledLinkedListIterator {
	GObject parent_instance;
	GeeUnrolledLinkedListIteratorPrivate * priv;
};

struct _GeeUnrolledLinkedListIteratorClass {
	GObjectClass parent_class;
};

struct _GeeUnrolledLinkedListIteratorPrivate {
	GType g_type;
	GBoxedCopyFunc g_dup_func;
	GDestroyNotify g_destroy_func;
	GeeUnrolledLinkedList* _list;
	gint _stamp;
	GeeUnrolledLinkedListNode* _current;
	gint _pos;
	gboolean _deleted;
	gint _index;
};

static gint GeeUnrolledLinkedList_private_offset;
static gpointer gee_unrolled_linked_list_parent_class = NULL;
static gint GeeUnrolledLinkedListIterator_private_offset;
static gpointer gee_unrolled_linked_list_iterator_parent_class = NULL;
static GeeTraversableIface * gee_unrolled_linked_list_iterator_gee_traversable_parent_iface = NULL;
static GeeIteratorIface * gee_unrolled_linked_list_iterator_gee_iterator_parent_iface = NULL;
static GeeListIteratorIface * gee_unrolled_linked_list_iterator_gee_list_iterator_parent_iface = NULL;
static GeeBidirIteratorIface * gee_unrolled_linked_list_iterator_gee_bidir_iterator_parent_iface = NULL;
static GeeBidirListIteratorIface * gee_unrolled_linked_list_iterator_gee_bidir_list_iterator_parent_iface = NULL;
static GeeQueueIface * gee_unrolled_linked_list_gee_queue_parent_iface = NULL;
static GeeDequeIface * gee_unrolled_linked_list_gee_deque_parent_iface = NULL;

static void gee_unrolled_linked_list_node_free (GeeUnrolledLinkedListNode * self);
 G_GNUC_INTERNAL gpointer gee_functions_equal_data_func_closure_ref (gpointer instance);
 G_GNUC_INTERNAL void gee_functions_equal_data_func_closure_unref (gpointer instance);
 G_GNUC_INTERNAL GParamSpec* gee_functions_param_spec_equal_data_func_closure (const gchar* name,
                                                              const gchar* nick,
                                                              const gchar* blurb,
                                                              GType object_type,
                                                              GParamFlags flags);
 G_GNUC_INTERNAL void gee_functions_value_set_equal_data_func_closure (GValue* value,
                                                      gpointer v_object) G_GNUC_UNUSED ;
 G_GNUC_INTERNAL void gee_functions_value_take_equal_data_func_closure (GValue* value,
                                                       gpointer v_object);
 G_GNUC_INTERNAL gpointer gee_functions_value_get_equal_data_func_closure (const GValue* value) G_GNUC_UNUSED ;
 G_GNUC_INTERNAL GType gee_functions_equal_data_func_closure_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
 G_GNUC_INTERNAL GeeFunctionsEqualDataFuncClosure* gee_functions_equal_data_func_closure_new (GType g_type,
                                                                             GBoxedCopyFunc g_dup_func,
                                                                             GDestroyNotify g_destroy_func,
                                                                             GeeEqualDataFunc func,
                                                                             gpointer func_target,
                                                                             GDestroyNotify func_target_destroy_notify);
 G_GNUC_INTERNAL GeeFunctionsEqualDataFuncClosure* gee_functions_equal_data_func_closure_construct (GType object_type,
                                                                                   GType g_type,
                                                                                   GBoxedCopyFunc g_dup_func,
                                                                                   GDestroyNotify g_destroy_func,
                                                                                   GeeEqualDataFunc func,
                                                                                   gpointer func_target,
                                                                                   GDestroyNotify func_target_destroy_notify);
static GeeUnrolledLinkedList* gee_unrolled_linked_list_new_with_closures (GType g_type,
                                                                   GBoxedCopyFunc g_dup_func,
                                                                   GDestroyNotify g_destroy_func,
                                                                   GeeFunctionsEqualDataFuncClosure* equal_func);
static GeeUnrolledLinkedList* gee_unrolled_linked_list_construct_with_closures (GType object_type,
                                                                         GType g_type,
                                                                         GBoxedCopyFunc g_dup_func,
                                                                         GDestroyNotify g_destroy_func,
                                                                         GeeFunctionsEqualDataFuncClosure* equal_func);
static gboolean gee_unrolled_linked_list_real_foreach (GeeAbstractCollection* base,
                                                GeeForallFunc f,
                                                gpointer f_target);
static GeeIterator* gee_unrolled_linked_list_real_iterator (GeeAbstractCollection* base);
static GeeUnrolledLinkedListIterator* gee_unrolled_linked_list_iterator_new (GType g_type,
                                                                      GBoxedCopyFunc g_dup_func,
                                                                      GDestroyNotify g_destroy_func,
                                                                      GeeUnrolledLinkedList* list);
static GeeUnrolledLinkedListIterator* gee_unrolled_linked_list_iterator_construct (GType object_type,
                                                                            GType g_type,
                                                                            GBoxedCopyFunc g_dup_func,
                                                                            GDestroyNotify g_destroy_func,
                                                                            GeeUnrolledLinkedList* list);
static GType gee_unrolled_linked_list_iterator_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static gboolean gee_unrolled_linked_list_real_contains (GeeAbstractCollection* base,
                                                 gconstpointer item);
static GeeUnrolledLinkedListNode* gee_unrolled_linked_list_find_node (GeeUnrolledLinkedList* self,
                                                               gconstpointer item,
                                                               gint* pos,
                                                               gint* idx);
static gboolean gee_unrolled_linked_list_real_add (GeeAbstractCollection* base,
                                            gconstpointer item);
static GeeUnrolledLinkedListNode* gee_unrolled_linked_list_node_new (void);
static void gee_unrolled_linked_list_add_to_node (GeeUnrolledLinkedList* self,
                                           GeeUnrolledLinkedListNode* node,
                                           gconstpointer item,
                                           gint pos,
                                           GeeUnrolledLinkedListNode** new_node,
                                           gint* new_pos);
static gboolean gee_unrolled_linked_list_real_remove (GeeAbstractCollection* base,
                                               gconstpointer item);
static gpointer gee_unrolled_linked_list_remove_from_node (GeeUnrolledLinkedList* self,
                                                    GeeUnrolledLinkedListNode* node,
                                                    gint pos,
                                                    GeeUnrolledLinkedListNode** new_node,
                                                    gint* new_pos);
static void gee_unrolled_linked_list_real_clear (GeeAbstractCollection* base);
static GeeListIterator* gee_unrolled_linked_list_real_list_iterator (GeeAbstractList* base);
static gpointer gee_unrolled_linked_list_real_get (GeeAbstractList* base,
                                            gint index);
static GeeUnrolledLinkedListNode* gee_unrolled_linked_list_find_node_by_idx (GeeUnrolledLinkedList* self,
                                                                      gint idx,
                                                                      gint** pos);
static void gee_unrolled_linked_list_real_set (GeeAbstractList* base,
                                        gint index,
                                        gconstpointer item);
static gint gee_unrolled_linked_list_real_index_of (GeeAbstractList* base,
                                             gconstpointer item);
static void gee_unrolled_linked_list_real_insert (GeeAbstractList* base,
                                           gint index,
                                           gconstpointer item);
static gpointer gee_unrolled_linked_list_real_remove_at (GeeAbstractList* base,
                                                  gint index);
static GeeList* gee_unrolled_linked_list_real_slice (GeeAbstractList* base,
                                              gint start,
                                              gint stop);
static GeeBidirListIterator* gee_unrolled_linked_list_real_bidir_list_iterator (GeeAbstractBidirList* base);
static gboolean gee_unrolled_linked_list_real_offer (GeeQueue* base,
                                              gconstpointer element);
static gpointer gee_unrolled_linked_list_real_peek (GeeQueue* base);
static gpointer gee_unrolled_linked_list_real_poll (GeeQueue* base);
static gint gee_unrolled_linked_list_real_drain (GeeQueue* base,
                                          GeeCollection* recipient,
                                          gint amount);
static void gee_unrolled_linked_list_merge_with_next (GeeUnrolledLinkedList* self,
                                               GeeUnrolledLinkedListNode* node);
static gboolean gee_unrolled_linked_list_real_offer_head (GeeDeque* base,
                                                   gconstpointer element);
static gpointer gee_unrolled_linked_list_real_peek_head (GeeDeque* base);
static gpointer gee_unrolled_linked_list_real_poll_head (GeeDeque* base);
static gint gee_unrolled_linked_list_real_drain_head (GeeDeque* base,
                                               GeeCollection* recipient,
                                               gint amount);
static gboolean gee_unrolled_linked_list_real_offer_tail (GeeDeque* base,
                                                   gconstpointer element);
static gpointer gee_unrolled_linked_list_real_peek_tail (GeeDeque* base);
static gpointer gee_unrolled_linked_list_real_poll_tail (GeeDeque* base);
static gint gee_unrolled_linked_list_real_drain_tail (GeeDeque* base,
                                               GeeCollection* recipient,
                                               gint amount);
static gint* _int_dup (gint* self);
static void gee_unrolled_linked_list_delete_node (GeeUnrolledLinkedList* self,
                                           GeeUnrolledLinkedListNode* node);
static void gee_unrolled_linked_list_set_equal_func (GeeUnrolledLinkedList* self,
                                              GeeEqualDataFunc value,
                                              gpointer value_target);
static GeeUnrolledLinkedListIterator* gee_unrolled_linked_list_iterator_new_from_iterator (GType g_type,
                                                                                    GBoxedCopyFunc g_dup_func,
                                                                                    GDestroyNotify g_destroy_func,
                                                                                    GeeUnrolledLinkedListIterator* iter);
static GeeUnrolledLinkedListIterator* gee_unrolled_linked_list_iterator_construct_from_iterator (GType object_type,
                                                                                          GType g_type,
                                                                                          GBoxedCopyFunc g_dup_func,
                                                                                          GDestroyNotify g_destroy_func,
                                                                                          GeeUnrolledLinkedListIterator* iter);
static gboolean gee_unrolled_linked_list_iterator_real_foreach (GeeTraversable* base,
                                                         GeeForallFunc f,
                                                         gpointer f_target);
static GeeIterator** gee_unrolled_linked_list_iterator_real_tee (GeeTraversable* base,
                                                          guint forks,
                                                          gint* result_length1);
static gboolean gee_unrolled_linked_list_iterator_real_next (GeeIterator* base);
static gboolean gee_unrolled_linked_list_iterator_real_has_next (GeeIterator* base);
static gpointer gee_unrolled_linked_list_iterator_real_get (GeeIterator* base);
static void gee_unrolled_linked_list_iterator_real_remove (GeeIterator* base);
static gboolean gee_unrolled_linked_list_iterator_real_previous (GeeBidirIterator* base);
static gboolean gee_unrolled_linked_list_iterator_real_has_previous (GeeBidirIterator* base);
static gboolean gee_unrolled_linked_list_iterator_real_first (GeeBidirIterator* base);
static gboolean gee_unrolled_linked_list_iterator_real_last (GeeBidirIterator* base);
static void gee_unrolled_linked_list_iterator_real_set (GeeListIterator* base,
                                                 gconstpointer item);
static void gee_unrolled_linked_list_iterator_real_add (GeeListIterator* base,
                                                 gconstpointer item);
static gint gee_unrolled_linked_list_iterator_real_index (GeeListIterator* base);
static void gee_unrolled_linked_list_iterator_real_insert (GeeBidirListIterator* base,
                                                    gconstpointer item);
static void gee_unrolled_linked_list_iterator_finalize (GObject * obj);
static GType gee_unrolled_linked_list_iterator_get_type_once (void);
static void _vala_gee_unrolled_linked_list_iterator_get_property (GObject * object,
                                                           guint property_id,
                                                           GValue * value,
                                                           GParamSpec * pspec);
static void _vala_gee_unrolled_linked_list_iterator_set_property (GObject * object,
                                                           guint property_id,
                                                           const GValue * value,
                                                           GParamSpec * pspec);
static void gee_unrolled_linked_list_node_instance_init (GeeUnrolledLinkedListNode * self);
static void gee_unrolled_linked_list_finalize (GObject * obj);
static GType gee_unrolled_linked_list_get_type_once (void);
static void _vala_gee_unrolled_linked_list_get_property (GObject * object,
                                                  guint property_id,
                                                  GValue * value,
                                                  GParamSpec * pspec);
static void _vala_gee_unrolled_linked_list_set_property (GObject * object,
                                                  guint property_id,
                                                  const GValue * value,
                                                  GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
gee_unrolled_linked_list_get_instance_private (GeeUnrolledLinkedList* self)
{
	return G_STRUCT_MEMBER_P (self, GeeUnrolledLinkedList_private_offset);
}

/**
 * Constructs a new, empty linked list.
 *
 * If not provided, the function parameter is requested to the
 * {@link Functions} function factory methods.
 *
 * @param equal_func an optional element equality testing function
 */
GeeUnrolledLinkedList*
gee_unrolled_linked_list_construct (GType object_type,
                                    GType g_type,
                                    GBoxedCopyFunc g_dup_func,
                                    GDestroyNotify g_destroy_func,
                                    GeeEqualDataFunc equal_func,
                                    gpointer equal_func_target,
                                    GDestroyNotify equal_func_target_destroy_notify)
{
	GeeUnrolledLinkedList * self = NULL;
	GeeEqualDataFunc _tmp3_;
	gpointer _tmp3__target;
	GDestroyNotify _tmp3__target_destroy_notify;
	GeeFunctionsEqualDataFuncClosure* _tmp4_;
	self = (GeeUnrolledLinkedList*) gee_abstract_bidir_list_construct (object_type, g_type, (GBoxedCopyFunc) g_dup_func, (GDestroyNotify) g_destroy_func);
	self->priv->g_type = g_type;
	self->priv->g_dup_func = g_dup_func;
	self->priv->g_destroy_func = g_destroy_func;
	if (equal_func == NULL) {
		gpointer _tmp0_ = NULL;
		GDestroyNotify _tmp1_ = NULL;
		GeeEqualDataFunc _tmp2_;
		_tmp2_ = gee_functions_get_equal_func_for (g_type, &_tmp0_, &_tmp1_);
		(equal_func_target_destroy_notify == NULL) ? NULL : (equal_func_target_destroy_notify (equal_func_target), NULL);
		equal_func = NULL;
		equal_func_target = NULL;
		equal_func_target_destroy_notify = NULL;
		equal_func = _tmp2_;
		equal_func_target = _tmp0_;
		equal_func_target_destroy_notify = _tmp1_;
	}
	_tmp3_ = equal_func;
	_tmp3__target = equal_func_target;
	_tmp3__target_destroy_notify = equal_func_target_destroy_notify;
	equal_func = NULL;
	equal_func_target = NULL;
	equal_func_target_destroy_notify = NULL;
	_tmp4_ = gee_functions_equal_data_func_closure_new (g_type, (GBoxedCopyFunc) g_dup_func, (GDestroyNotify) g_destroy_func, _tmp3_, _tmp3__target, _tmp3__target_destroy_notify);
	_gee_functions_equal_data_func_closure_unref0 (self->priv->_equal_func);
	self->priv->_equal_func = _tmp4_;
	(equal_func_target_destroy_notify == NULL) ? NULL : (equal_func_target_destroy_notify (equal_func_target), NULL);
	equal_func = NULL;
	equal_func_target = NULL;
	equal_func_target_destroy_notify = NULL;
	return self;
}

GeeUnrolledLinkedList*
gee_unrolled_linked_list_new (GType g_type,
                              GBoxedCopyFunc g_dup_func,
                              GDestroyNotify g_destroy_func,
                              GeeEqualDataFunc equal_func,
                              gpointer equal_func_target,
                              GDestroyNotify equal_func_target_destroy_notify)
{
	return gee_unrolled_linked_list_construct (GEE_TYPE_UNROLLED_LINKED_LIST, g_type, g_dup_func, g_destroy_func, equal_func, equal_func_target, equal_func_target_destroy_notify);
}

static gpointer
_gee_functions_equal_data_func_closure_ref0 (gpointer self)
{
	return self ? gee_functions_equal_data_func_closure_ref (self) : NULL;
}

static GeeUnrolledLinkedList*
gee_unrolled_linked_list_construct_with_closures (GType object_type,
                                                  GType g_type,
                                                  GBoxedCopyFunc g_dup_func,
                                                  GDestroyNotify g_destroy_func,
                                                  GeeFunctionsEqualDataFuncClosure* equal_func)
{
	GeeUnrolledLinkedList * self = NULL;
	GeeFunctionsEqualDataFuncClosure* _tmp0_;
	g_return_val_if_fail (equal_func != NULL, NULL);
	self = (GeeUnrolledLinkedList*) gee_abstract_bidir_list_construct (object_type, g_type, (GBoxedCopyFunc) g_dup_func, (GDestroyNotify) g_destroy_func);
	self->priv->g_type = g_type;
	self->priv->g_dup_func = g_dup_func;
	self->priv->g_destroy_func = g_destroy_func;
	_tmp0_ = _gee_functions_equal_data_func_closure_ref0 (equal_func);
	_gee_functions_equal_data_func_closure_unref0 (self->priv->_equal_func);
	self->priv->_equal_func = _tmp0_;
	_gee_functions_equal_data_func_closure_unref0 (equal_func);
	return self;
}

static GeeUnrolledLinkedList*
gee_unrolled_linked_list_new_with_closures (GType g_type,
                                            GBoxedCopyFunc g_dup_func,
                                            GDestroyNotify g_destroy_func,
                                            GeeFunctionsEqualDataFuncClosure* equal_func)
{
	return gee_unrolled_linked_list_construct_with_closures (GEE_TYPE_UNROLLED_LINKED_LIST, g_type, g_dup_func, g_destroy_func, equal_func);
}

static gboolean
gee_unrolled_linked_list_real_foreach (GeeAbstractCollection* base,
                                       GeeForallFunc f,
                                       gpointer f_target)
{
	GeeUnrolledLinkedList * self;
	gboolean result;
	self = (GeeUnrolledLinkedList*) base;
	{
		GeeUnrolledLinkedListNode* node = NULL;
		GeeUnrolledLinkedListNode* _tmp0_;
		_tmp0_ = self->priv->_head;
		node = _tmp0_;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				GeeUnrolledLinkedListNode* _tmp4_;
				if (!_tmp1_) {
					GeeUnrolledLinkedListNode* _tmp2_;
					GeeUnrolledLinkedListNode* _tmp3_;
					_tmp2_ = node;
					_tmp3_ = _tmp2_->_next;
					node = _tmp3_;
				}
				_tmp1_ = FALSE;
				_tmp4_ = node;
				if (!(_tmp4_ != NULL)) {
					break;
				}
				{
					gint pos = 0;
					pos = 0;
					{
						gboolean _tmp5_ = FALSE;
						_tmp5_ = TRUE;
						while (TRUE) {
							GeeUnrolledLinkedListNode* _tmp7_;
							GeeUnrolledLinkedListNode* _tmp8_;
							gconstpointer _tmp9_;
							gpointer _tmp10_;
							if (!_tmp5_) {
								gint _tmp6_;
								_tmp6_ = pos;
								pos = _tmp6_ + 1;
							}
							_tmp5_ = FALSE;
							_tmp7_ = node;
							if (!(pos < _tmp7_->_size)) {
								break;
							}
							_tmp8_ = node;
							_tmp9_ = _tmp8_->_data[pos];
							_tmp10_ = ((_tmp9_ != NULL) && (self->priv->g_dup_func != NULL)) ? self->priv->g_dup_func ((gpointer) _tmp9_) : ((gpointer) _tmp9_);
							if (!f (_tmp10_, f_target)) {
								result = FALSE;
								return result;
							}
						}
					}
				}
			}
		}
	}
	result = TRUE;
	return result;
}

static GeeIterator*
gee_unrolled_linked_list_real_iterator (GeeAbstractCollection* base)
{
	GeeUnrolledLinkedList * self;
	GeeUnrolledLinkedListIterator* _tmp0_;
	GeeIterator* result;
	self = (GeeUnrolledLinkedList*) base;
	_tmp0_ = gee_unrolled_linked_list_iterator_new (self->priv->g_type, (GBoxedCopyFunc) self->priv->g_dup_func, (GDestroyNotify) self->priv->g_destroy_func, self);
	result = (GeeIterator*) _tmp0_;
	return result;
}

static gboolean
gee_unrolled_linked_list_real_contains (GeeAbstractCollection* base,
                                        gconstpointer item)
{
	GeeUnrolledLinkedList * self;
	GeeUnrolledLinkedListNode* _tmp0_;
	gboolean result;
	self = (GeeUnrolledLinkedList*) base;
	_tmp0_ = gee_unrolled_linked_list_find_node (self, item, NULL, NULL);
	result = _tmp0_ != NULL;
	return result;
}

static gboolean
gee_unrolled_linked_list_real_add (GeeAbstractCollection* base,
                                   gconstpointer item)
{
	GeeUnrolledLinkedList * self;
	GeeUnrolledLinkedListNode* _tmp0_;
	GeeUnrolledLinkedListNode* _tmp4_;
	GeeUnrolledLinkedListNode* _tmp5_;
	gboolean result;
	self = (GeeUnrolledLinkedList*) base;
	_tmp0_ = self->priv->_tail;
	if (_tmp0_ == NULL) {
		GeeUnrolledLinkedListNode* _tmp1_;
		GeeUnrolledLinkedListNode* _tmp2_;
		GeeUnrolledLinkedListNode* _tmp3_;
		_tmp1_ = self->priv->_head;
		_vala_assert (_tmp1_ == NULL, "_head == null");
		_tmp2_ = gee_unrolled_linked_list_node_new ();
		_gee_unrolled_linked_list_node_free0 (self->priv->_head);
		self->priv->_head = _tmp2_;
		_tmp3_ = self->priv->_head;
		self->priv->_tail = _tmp3_;
	}
	_tmp4_ = self->priv->_tail;
	_tmp5_ = self->priv->_tail;
	gee_unrolled_linked_list_add_to_node (self, _tmp4_, item, _tmp5_->_size, NULL, NULL);
	result = TRUE;
	return result;
}

static gboolean
gee_unrolled_linked_list_real_remove (GeeAbstractCollection* base,
                                      gconstpointer item)
{
	GeeUnrolledLinkedList * self;
	gint pos = 0;
	GeeUnrolledLinkedListNode* node = NULL;
	gint _tmp0_ = 0;
	GeeUnrolledLinkedListNode* _tmp1_;
	GeeUnrolledLinkedListNode* _tmp2_;
	GeeUnrolledLinkedListNode* _tmp6_;
	gboolean result;
	self = (GeeUnrolledLinkedList*) base;
	_tmp1_ = gee_unrolled_linked_list_find_node (self, item, &_tmp0_, NULL);
	pos = _tmp0_;
	node = _tmp1_;
	_tmp2_ = node;
	if (_tmp2_ != NULL) {
		GeeUnrolledLinkedListNode* _tmp3_;
		gpointer _tmp4_;
		gpointer _tmp5_;
		_tmp3_ = node;
		_tmp4_ = gee_unrolled_linked_list_remove_from_node (self, _tmp3_, pos, NULL, NULL);
		_tmp5_ = _tmp4_;
		((_tmp5_ == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (_tmp5_ = (self->priv->g_destroy_func (_tmp5_), NULL));
	}
	_tmp6_ = node;
	result = _tmp6_ != NULL;
	return result;
}

static void
gee_unrolled_linked_list_real_clear (GeeAbstractCollection* base)
{
	GeeUnrolledLinkedList * self;
	gint _tmp9_;
	self = (GeeUnrolledLinkedList*) base;
	{
		GeeUnrolledLinkedListNode* node = NULL;
		GeeUnrolledLinkedListNode* _tmp0_;
		_tmp0_ = self->priv->_head;
		self->priv->_head = NULL;
		node = _tmp0_;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				GeeUnrolledLinkedListNode* _tmp4_;
				if (!_tmp1_) {
					GeeUnrolledLinkedListNode* _tmp2_;
					GeeUnrolledLinkedListNode* _tmp3_;
					_tmp2_ = node;
					_tmp3_ = _tmp2_->_next;
					_tmp2_->_next = NULL;
					_gee_unrolled_linked_list_node_free0 (node);
					node = _tmp3_;
				}
				_tmp1_ = FALSE;
				_tmp4_ = node;
				if (!(_tmp4_ != NULL)) {
					break;
				}
				{
					guint pos = 0U;
					pos = (guint) 0;
					{
						gboolean _tmp5_ = FALSE;
						_tmp5_ = TRUE;
						while (TRUE) {
							GeeUnrolledLinkedListNode* _tmp7_;
							GeeUnrolledLinkedListNode* _tmp8_;
							if (!_tmp5_) {
								guint _tmp6_;
								_tmp6_ = pos;
								pos = _tmp6_ + 1;
							}
							_tmp5_ = FALSE;
							_tmp7_ = node;
							if (!(pos < ((guint) _tmp7_->_size))) {
								break;
							}
							_tmp8_ = node;
							((_tmp8_->_data[pos] == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (_tmp8_->_data[pos] = (self->priv->g_destroy_func (_tmp8_->_data[pos]), NULL));
							_tmp8_->_data[pos] = NULL;
						}
					}
				}
			}
		}
		_gee_unrolled_linked_list_node_free0 (node);
	}
	_gee_unrolled_linked_list_node_free0 (self->priv->_head);
	self->priv->_head = NULL;
	self->priv->_tail = NULL;
	_tmp9_ = self->priv->_stamp;
	self->priv->_stamp = _tmp9_ + 1;
	self->priv->_size = 0;
}

static GeeListIterator*
gee_unrolled_linked_list_real_list_iterator (GeeAbstractList* base)
{
	GeeUnrolledLinkedList * self;
	GeeUnrolledLinkedListIterator* _tmp0_;
	GeeListIterator* result;
	self = (GeeUnrolledLinkedList*) base;
	_tmp0_ = gee_unrolled_linked_list_iterator_new (self->priv->g_type, (GBoxedCopyFunc) self->priv->g_dup_func, (GDestroyNotify) self->priv->g_destroy_func, self);
	result = (GeeListIterator*) _tmp0_;
	return result;
}

static gpointer
gee_unrolled_linked_list_real_get (GeeAbstractList* base,
                                   gint index)
{
	GeeUnrolledLinkedList * self;
	gint pos = 0;
	GeeUnrolledLinkedListNode* node = NULL;
	gint* _tmp0_ = NULL;
	GeeUnrolledLinkedListNode* _tmp1_;
	gint* _tmp2_;
	GeeUnrolledLinkedListNode* _tmp3_;
	gconstpointer _tmp4_;
	gpointer _tmp5_;
	gpointer result;
	self = (GeeUnrolledLinkedList*) base;
	_vala_assert (index >= 0, "index >= 0");
	_vala_assert (index < self->priv->_size, "index < this._size");
	_tmp1_ = gee_unrolled_linked_list_find_node_by_idx (self, index, &_tmp0_);
	_tmp2_ = _tmp0_;
	pos = *_tmp2_;
	_tmp3_ = _tmp1_;
	_g_free0 (_tmp2_);
	node = _tmp3_;
	_vala_assert (node != NULL, "node != null");
	_tmp4_ = node->_data[pos];
	_tmp5_ = ((_tmp4_ != NULL) && (self->priv->g_dup_func != NULL)) ? self->priv->g_dup_func ((gpointer) _tmp4_) : ((gpointer) _tmp4_);
	result = _tmp5_;
	return result;
}

static void
gee_unrolled_linked_list_real_set (GeeAbstractList* base,
                                   gint index,
                                   gconstpointer item)
{
	GeeUnrolledLinkedList * self;
	gint pos = 0;
	GeeUnrolledLinkedListNode* node = NULL;
	gint* _tmp0_ = NULL;
	GeeUnrolledLinkedListNode* _tmp1_;
	gint* _tmp2_;
	GeeUnrolledLinkedListNode* _tmp3_;
	gpointer _tmp4_;
	self = (GeeUnrolledLinkedList*) base;
	_vala_assert (index >= 0, "index >= 0");
	_vala_assert (index < self->priv->_size, "index < this._size");
	_tmp1_ = gee_unrolled_linked_list_find_node_by_idx (self, index, &_tmp0_);
	_tmp2_ = _tmp0_;
	pos = *_tmp2_;
	_tmp3_ = _tmp1_;
	_g_free0 (_tmp2_);
	node = _tmp3_;
	_vala_assert (node != NULL, "node != null");
	_tmp4_ = ((item != NULL) && (self->priv->g_dup_func != NULL)) ? self->priv->g_dup_func ((gpointer) item) : ((gpointer) item);
	((node->_data[pos] == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (node->_data[pos] = (self->priv->g_destroy_func (node->_data[pos]), NULL));
	node->_data[pos] = _tmp4_;
}

static gint
gee_unrolled_linked_list_real_index_of (GeeAbstractList* base,
                                        gconstpointer item)
{
	GeeUnrolledLinkedList * self;
	gint idx = 0;
	gint _tmp0_ = 0;
	GeeUnrolledLinkedListNode* _tmp1_;
	gint result;
	self = (GeeUnrolledLinkedList*) base;
	_tmp1_ = gee_unrolled_linked_list_find_node (self, item, NULL, &_tmp0_);
	idx = _tmp0_;
	if (_tmp1_ != NULL) {
		result = idx;
		return result;
	} else {
		result = -1;
		return result;
	}
}

static void
gee_unrolled_linked_list_real_insert (GeeAbstractList* base,
                                      gint index,
                                      gconstpointer item)
{
	GeeUnrolledLinkedList * self;
	self = (GeeUnrolledLinkedList*) base;
	_vala_assert (index >= 0, "index >= 0");
	_vala_assert (index <= self->priv->_size, "index <= this._size");
	if (index != self->priv->_size) {
		gint pos = 0;
		GeeUnrolledLinkedListNode* node = NULL;
		gint* _tmp0_ = NULL;
		GeeUnrolledLinkedListNode* _tmp1_;
		gint* _tmp2_;
		GeeUnrolledLinkedListNode* _tmp3_;
		GeeUnrolledLinkedListNode* _tmp4_;
		GeeUnrolledLinkedListNode* _tmp5_;
		_tmp1_ = gee_unrolled_linked_list_find_node_by_idx (self, index, &_tmp0_);
		_tmp2_ = _tmp0_;
		pos = *_tmp2_;
		_tmp3_ = _tmp1_;
		_g_free0 (_tmp2_);
		node = _tmp3_;
		_tmp4_ = node;
		_vala_assert (_tmp4_ != NULL, "node != null");
		_tmp5_ = node;
		gee_unrolled_linked_list_add_to_node (self, _tmp5_, item, pos, NULL, NULL);
	} else {
		GeeUnrolledLinkedListNode* _tmp11_;
		GeeUnrolledLinkedListNode* _tmp12_;
		if (index == 0) {
			gboolean _tmp6_ = FALSE;
			GeeUnrolledLinkedListNode* _tmp7_;
			GeeUnrolledLinkedListNode* _tmp9_;
			GeeUnrolledLinkedListNode* _tmp10_;
			_tmp7_ = self->priv->_head;
			if (_tmp7_ == NULL) {
				GeeUnrolledLinkedListNode* _tmp8_;
				_tmp8_ = self->priv->_tail;
				_tmp6_ = _tmp8_ == NULL;
			} else {
				_tmp6_ = FALSE;
			}
			_vala_assert (_tmp6_, "_head == null && _tail == null");
			_tmp9_ = gee_unrolled_linked_list_node_new ();
			_gee_unrolled_linked_list_node_free0 (self->priv->_head);
			self->priv->_head = _tmp9_;
			_tmp10_ = self->priv->_head;
			self->priv->_tail = _tmp10_;
		}
		_tmp11_ = self->priv->_tail;
		_tmp12_ = self->priv->_tail;
		gee_unrolled_linked_list_add_to_node (self, _tmp11_, item, _tmp12_->_size, NULL, NULL);
	}
}

static gpointer
gee_unrolled_linked_list_real_remove_at (GeeAbstractList* base,
                                         gint index)
{
	GeeUnrolledLinkedList * self;
	gint pos = 0;
	GeeUnrolledLinkedListNode* node = NULL;
	gint* _tmp0_ = NULL;
	GeeUnrolledLinkedListNode* _tmp1_;
	gint* _tmp2_;
	GeeUnrolledLinkedListNode* _tmp3_;
	gpointer _tmp4_;
	gpointer result;
	self = (GeeUnrolledLinkedList*) base;
	_vala_assert (index >= 0, "index >= 0");
	_vala_assert (index < self->priv->_size, "index < this._size");
	_tmp1_ = gee_unrolled_linked_list_find_node_by_idx (self, index, &_tmp0_);
	_tmp2_ = _tmp0_;
	pos = *_tmp2_;
	_tmp3_ = _tmp1_;
	_g_free0 (_tmp2_);
	node = _tmp3_;
	_vala_assert (node != NULL, "node != null");
	_tmp4_ = gee_unrolled_linked_list_remove_from_node (self, node, pos, NULL, NULL);
	result = _tmp4_;
	return result;
}

static GeeList*
gee_unrolled_linked_list_real_slice (GeeAbstractList* base,
                                     gint start,
                                     gint stop)
{
	GeeUnrolledLinkedList * self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GeeUnrolledLinkedList* slice = NULL;
	GeeFunctionsEqualDataFuncClosure* _tmp2_;
	GeeFunctionsEqualDataFuncClosure* _tmp3_;
	GeeUnrolledLinkedList* _tmp4_;
	GeeUnrolledLinkedList* _tmp5_;
	GeeUnrolledLinkedListNode* copy = NULL;
	GeeUnrolledLinkedList* _tmp6_;
	GeeUnrolledLinkedListNode* _tmp7_;
	GeeUnrolledLinkedListNode* _tmp8_;
	gint orig_pos = 0;
	GeeUnrolledLinkedListNode* orig = NULL;
	gint* _tmp9_ = NULL;
	GeeUnrolledLinkedListNode* _tmp10_;
	gint* _tmp11_;
	GeeUnrolledLinkedListNode* _tmp12_;
	GeeUnrolledLinkedListNode* _tmp13_;
	gint i = 0;
	GeeUnrolledLinkedList* _tmp33_;
	GeeUnrolledLinkedListNode* _tmp34_;
	GeeList* result;
	self = (GeeUnrolledLinkedList*) base;
	if (0 <= start) {
		_tmp1_ = start <= stop;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		_tmp0_ = stop <= self->priv->_size;
	} else {
		_tmp0_ = FALSE;
	}
	_vala_assert (_tmp0_, "0 <= start && start <= stop && stop <= _size");
	_tmp2_ = self->priv->_equal_func;
	_tmp3_ = _gee_functions_equal_data_func_closure_ref0 (_tmp2_);
	_tmp4_ = gee_unrolled_linked_list_new_with_closures (self->priv->g_type, (GBoxedCopyFunc) self->priv->g_dup_func, (GDestroyNotify) self->priv->g_destroy_func, _tmp3_);
	slice = _tmp4_;
	_tmp5_ = slice;
	_tmp5_->priv->_size = stop - start;
	_tmp6_ = slice;
	_tmp7_ = gee_unrolled_linked_list_node_new ();
	_gee_unrolled_linked_list_node_free0 (_tmp6_->priv->_head);
	_tmp6_->priv->_head = _tmp7_;
	_tmp8_ = _tmp6_->priv->_head;
	copy = _tmp8_;
	_tmp10_ = gee_unrolled_linked_list_find_node_by_idx (self, start, &_tmp9_);
	_tmp11_ = _tmp9_;
	orig_pos = *_tmp11_;
	_tmp12_ = _tmp10_;
	_g_free0 (_tmp11_);
	orig = _tmp12_;
	_tmp13_ = orig;
	_vala_assert (_tmp13_ != NULL, "orig != null");
	i = 0;
	while (TRUE) {
		gint j = 0;
		GeeUnrolledLinkedListNode* _tmp25_;
		GeeUnrolledLinkedListNode* _tmp26_;
		GeeUnrolledLinkedListNode* _tmp27_;
		GeeUnrolledLinkedListNode* _tmp28_;
		GeeUnrolledLinkedListNode* _tmp29_;
		GeeUnrolledLinkedListNode* _tmp30_;
		GeeUnrolledLinkedListNode* _tmp31_;
		GeeUnrolledLinkedListNode* _tmp32_;
		j = 0;
		while (TRUE) {
			gboolean _tmp14_ = FALSE;
			GeeUnrolledLinkedListNode* _tmp15_;
			GeeUnrolledLinkedListNode* _tmp16_;
			gconstpointer _tmp17_;
			gpointer _tmp18_;
			gint _tmp19_;
			gint _tmp20_;
			gint _tmp21_;
			GeeUnrolledLinkedListNode* _tmp22_;
			if (j < GEE_UNROLLED_LINKED_LIST_NODE_SIZE) {
				_tmp14_ = i < (stop - start);
			} else {
				_tmp14_ = FALSE;
			}
			if (!_tmp14_) {
				break;
			}
			_tmp15_ = copy;
			_tmp16_ = orig;
			_tmp17_ = _tmp16_->_data[orig_pos];
			_tmp18_ = ((_tmp17_ != NULL) && (self->priv->g_dup_func != NULL)) ? self->priv->g_dup_func ((gpointer) _tmp17_) : ((gpointer) _tmp17_);
			((_tmp15_->_data[j] == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (_tmp15_->_data[j] = (self->priv->g_destroy_func (_tmp15_->_data[j]), NULL));
			_tmp15_->_data[j] = _tmp18_;
			_tmp19_ = i;
			i = _tmp19_ + 1;
			_tmp20_ = j;
			j = _tmp20_ + 1;
			_tmp21_ = orig_pos;
			orig_pos = _tmp21_ + 1;
			_tmp22_ = orig;
			if (G_UNLIKELY (orig_pos == _tmp22_->_size)) {
				GeeUnrolledLinkedListNode* _tmp23_;
				GeeUnrolledLinkedListNode* _tmp24_;
				_tmp23_ = orig;
				_tmp24_ = _tmp23_->_next;
				orig = _tmp24_;
				orig_pos = 0;
			}
		}
		_tmp25_ = copy;
		_tmp25_->_size = j;
		if (G_UNLIKELY (!(i < (stop - start)))) {
			break;
		}
		_tmp26_ = copy;
		_tmp27_ = gee_unrolled_linked_list_node_new ();
		_gee_unrolled_linked_list_node_free0 (_tmp26_->_next);
		_tmp26_->_next = _tmp27_;
		_tmp28_ = copy;
		_tmp29_ = _tmp28_->_next;
		_tmp30_ = copy;
		_tmp29_->_prev = _tmp30_;
		_tmp31_ = copy;
		_tmp32_ = _tmp31_->_next;
		copy = _tmp32_;
	}
	_tmp33_ = slice;
	_tmp34_ = copy;
	_tmp33_->priv->_tail = _tmp34_;
	result = (GeeList*) slice;
	return result;
}

static GeeBidirListIterator*
gee_unrolled_linked_list_real_bidir_list_iterator (GeeAbstractBidirList* base)
{
	GeeUnrolledLinkedList * self;
	GeeUnrolledLinkedListIterator* _tmp0_;
	GeeBidirListIterator* result;
	self = (GeeUnrolledLinkedList*) base;
	_tmp0_ = gee_unrolled_linked_list_iterator_new (self->priv->g_type, (GBoxedCopyFunc) self->priv->g_dup_func, (GDestroyNotify) self->priv->g_destroy_func, self);
	result = (GeeBidirListIterator*) _tmp0_;
	return result;
}

static gboolean
gee_unrolled_linked_list_real_offer (GeeQueue* base,
                                     gconstpointer element)
{
	GeeUnrolledLinkedList * self;
	GeeUnrolledLinkedListNode* _tmp0_;
	gboolean _tmp4_ = FALSE;
	GeeUnrolledLinkedListNode* _tmp5_;
	GeeUnrolledLinkedListNode* _tmp7_;
	GeeUnrolledLinkedListNode* _tmp8_;
	gboolean result;
	self = (GeeUnrolledLinkedList*) base;
	_tmp0_ = self->priv->_tail;
	if (_tmp0_ == NULL) {
		GeeUnrolledLinkedListNode* _tmp1_;
		GeeUnrolledLinkedListNode* _tmp2_;
		GeeUnrolledLinkedListNode* _tmp3_;
		_tmp1_ = self->priv->_head;
		_vala_assert (_tmp1_ == NULL, "_head == null");
		_tmp2_ = gee_unrolled_linked_list_node_new ();
		_gee_unrolled_linked_list_node_free0 (self->priv->_head);
		self->priv->_head = _tmp2_;
		_tmp3_ = self->priv->_head;
		self->priv->_tail = _tmp3_;
	}
	_tmp5_ = self->priv->_head;
	if (_tmp5_ != NULL) {
		GeeUnrolledLinkedListNode* _tmp6_;
		_tmp6_ = self->priv->_tail;
		_tmp4_ = _tmp6_ != NULL;
	} else {
		_tmp4_ = FALSE;
	}
	_vala_assert (_tmp4_, "_head != null && _tail != null");
	_tmp7_ = self->priv->_tail;
	_tmp8_ = self->priv->_tail;
	gee_unrolled_linked_list_add_to_node (self, _tmp7_, element, _tmp8_->_size, NULL, NULL);
	result = TRUE;
	return result;
}

static gpointer
gee_unrolled_linked_list_real_peek (GeeQueue* base)
{
	GeeUnrolledLinkedList * self;
	GeeUnrolledLinkedListNode* _tmp0_;
	gpointer result;
	self = (GeeUnrolledLinkedList*) base;
	_tmp0_ = self->priv->_head;
	if (_tmp0_ != NULL) {
		GeeUnrolledLinkedListNode* _tmp1_;
		gconstpointer _tmp2_;
		gpointer _tmp3_;
		_tmp1_ = self->priv->_head;
		_tmp2_ = _tmp1_->_data[0];
		_tmp3_ = ((_tmp2_ != NULL) && (self->priv->g_dup_func != NULL)) ? self->priv->g_dup_func ((gpointer) _tmp2_) : ((gpointer) _tmp2_);
		result = _tmp3_;
		return result;
	} else {
		result = NULL;
		return result;
	}
}

static gpointer
gee_unrolled_linked_list_real_poll (GeeQueue* base)
{
	GeeUnrolledLinkedList * self;
	GeeUnrolledLinkedListNode* _tmp0_;
	gpointer result;
	self = (GeeUnrolledLinkedList*) base;
	_tmp0_ = self->priv->_head;
	if (_tmp0_ != NULL) {
		GeeUnrolledLinkedListNode* _tmp1_;
		gpointer _tmp2_;
		_tmp1_ = self->priv->_head;
		_tmp2_ = gee_unrolled_linked_list_remove_from_node (self, _tmp1_, 0, NULL, NULL);
		result = _tmp2_;
		return result;
	} else {
		result = NULL;
		return result;
	}
}

static gint
gee_unrolled_linked_list_real_drain (GeeQueue* base,
                                     GeeCollection* recipient,
                                     gint amount)
{
	GeeUnrolledLinkedList * self;
	gint drained = 0;
	gint result;
	self = (GeeUnrolledLinkedList*) base;
	g_return_val_if_fail (recipient != NULL, 0);
	drained = 0;
	if (amount < 0) {
		gint _tmp11_;
		{
			GeeUnrolledLinkedListNode* node = NULL;
			GeeUnrolledLinkedListNode* _tmp0_;
			_tmp0_ = self->priv->_head;
			self->priv->_head = NULL;
			node = _tmp0_;
			{
				gboolean _tmp1_ = FALSE;
				_tmp1_ = TRUE;
				while (TRUE) {
					GeeUnrolledLinkedListNode* _tmp4_;
					if (!_tmp1_) {
						GeeUnrolledLinkedListNode* _tmp2_;
						GeeUnrolledLinkedListNode* _tmp3_;
						_tmp2_ = node;
						_tmp3_ = _tmp2_->_next;
						_tmp2_->_next = NULL;
						_gee_unrolled_linked_list_node_free0 (node);
						node = _tmp3_;
					}
					_tmp1_ = FALSE;
					_tmp4_ = node;
					if (!(_tmp4_ != NULL)) {
						break;
					}
					{
						gint i = 0;
						i = 0;
						{
							gboolean _tmp5_ = FALSE;
							_tmp5_ = TRUE;
							while (TRUE) {
								GeeUnrolledLinkedListNode* _tmp7_;
								gpointer data = NULL;
								GeeUnrolledLinkedListNode* _tmp8_;
								gpointer _tmp9_;
								gconstpointer _tmp10_;
								if (!_tmp5_) {
									gint _tmp6_;
									_tmp6_ = i;
									i = _tmp6_ + 1;
								}
								_tmp5_ = FALSE;
								_tmp7_ = node;
								if (!(i < _tmp7_->_size)) {
									break;
								}
								_tmp8_ = node;
								_tmp9_ = _tmp8_->_data[i];
								_tmp8_->_data[i] = NULL;
								data = _tmp9_;
								_tmp10_ = data;
								gee_collection_add (recipient, _tmp10_);
								((data == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (data = (self->priv->g_destroy_func (data), NULL));
							}
						}
					}
				}
			}
			_gee_unrolled_linked_list_node_free0 (node);
		}
		drained = self->priv->_size;
		self->priv->_tail = NULL;
		self->priv->_size = 0;
		_tmp11_ = self->priv->_stamp;
		self->priv->_stamp = _tmp11_ + 1;
		result = drained;
		return result;
	} else {
		GeeUnrolledLinkedListNode* node = NULL;
		gint _tmp47_;
		{
			GeeUnrolledLinkedListNode* _tmp12_;
			gboolean _tmp13_ = FALSE;
			_tmp12_ = self->priv->_head;
			self->priv->_head = NULL;
			_gee_unrolled_linked_list_node_free0 (node);
			node = _tmp12_;
			_tmp13_ = TRUE;
			while (TRUE) {
				GeeUnrolledLinkedListNode* _tmp16_;
				GeeUnrolledLinkedListNode* _tmp17_;
				if (!_tmp13_) {
					GeeUnrolledLinkedListNode* _tmp14_;
					GeeUnrolledLinkedListNode* _tmp15_;
					_tmp14_ = node;
					_tmp15_ = _tmp14_->_next;
					_tmp14_->_next = NULL;
					_gee_unrolled_linked_list_node_free0 (node);
					node = _tmp15_;
				}
				_tmp13_ = FALSE;
				_tmp16_ = node;
				if (!(_tmp16_ != NULL)) {
					break;
				}
				_tmp17_ = node;
				if (G_LIKELY (_tmp17_->_size <= amount)) {
					GeeUnrolledLinkedListNode* _tmp24_;
					GeeUnrolledLinkedListNode* _tmp25_;
					GeeUnrolledLinkedListNode* _tmp26_;
					{
						gint i = 0;
						i = 0;
						{
							gboolean _tmp18_ = FALSE;
							_tmp18_ = TRUE;
							while (TRUE) {
								GeeUnrolledLinkedListNode* _tmp20_;
								gpointer data = NULL;
								GeeUnrolledLinkedListNode* _tmp21_;
								gpointer _tmp22_;
								gconstpointer _tmp23_;
								if (!_tmp18_) {
									gint _tmp19_;
									_tmp19_ = i;
									i = _tmp19_ + 1;
								}
								_tmp18_ = FALSE;
								_tmp20_ = node;
								if (!(i < _tmp20_->_size)) {
									break;
								}
								_tmp21_ = node;
								_tmp22_ = _tmp21_->_data[i];
								_tmp21_->_data[i] = NULL;
								data = _tmp22_;
								_tmp23_ = data;
								gee_collection_add (recipient, _tmp23_);
								((data == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (data = (self->priv->g_destroy_func (data), NULL));
							}
						}
					}
					_tmp24_ = node;
					amount = amount - _tmp24_->_size;
					_tmp25_ = node;
					drained += _tmp25_->_size;
					_tmp26_ = node;
					self->priv->_size = self->priv->_size - _tmp26_->_size;
				} else {
					GeeUnrolledLinkedListNode* _tmp32_;
					GeeUnrolledLinkedListNode* _tmp33_;
					GeeUnrolledLinkedListNode* _tmp34_;
					GeeUnrolledLinkedListNode* _tmp35_;
					GeeUnrolledLinkedListNode* _tmp36_;
					GeeUnrolledLinkedListNode* n = NULL;
					GeeUnrolledLinkedListNode* _tmp37_;
					GeeUnrolledLinkedListNode* _tmp38_;
					gboolean _tmp39_ = FALSE;
					GeeUnrolledLinkedListNode* _tmp40_;
					GeeUnrolledLinkedListNode* _tmp41_;
					gint _tmp46_;
					{
						gint i = 0;
						i = 0;
						{
							gboolean _tmp27_ = FALSE;
							_tmp27_ = TRUE;
							while (TRUE) {
								gpointer data = NULL;
								GeeUnrolledLinkedListNode* _tmp29_;
								gpointer _tmp30_;
								gconstpointer _tmp31_;
								if (!_tmp27_) {
									gint _tmp28_;
									_tmp28_ = i;
									i = _tmp28_ + 1;
								}
								_tmp27_ = FALSE;
								if (!(i < amount)) {
									break;
								}
								_tmp29_ = node;
								_tmp30_ = _tmp29_->_data[i];
								_tmp29_->_data[i] = NULL;
								data = _tmp30_;
								_tmp31_ = data;
								gee_collection_add (recipient, _tmp31_);
								((data == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (data = (self->priv->g_destroy_func (data), NULL));
							}
						}
					}
					_tmp32_ = node;
					_tmp33_ = node;
					_tmp34_ = node;
					memmove (_tmp32_->_data, &_tmp33_->_data[amount], (gsize) (sizeof (gpointer) * (_tmp34_->_size - amount)));
					drained += amount;
					self->priv->_size = self->priv->_size - amount;
					_tmp35_ = node;
					_tmp36_ = node;
					_tmp36_->_size = _tmp36_->_size - amount;
					_tmp37_ = node;
					n = _tmp37_;
					_tmp38_ = node;
					node = NULL;
					_gee_unrolled_linked_list_node_free0 (self->priv->_head);
					self->priv->_head = _tmp38_;
					_tmp40_ = n;
					_tmp41_ = _tmp40_->_next;
					if (G_LIKELY (_tmp41_ != NULL)) {
						GeeUnrolledLinkedListNode* _tmp42_;
						GeeUnrolledLinkedListNode* _tmp43_;
						GeeUnrolledLinkedListNode* _tmp44_;
						_tmp42_ = n;
						_tmp43_ = n;
						_tmp44_ = _tmp43_->_next;
						_tmp39_ = G_UNLIKELY ((_tmp42_->_size + _tmp44_->_size) < GEE_UNROLLED_LINKED_LIST_MERGE_THRESHOLD);
					} else {
						_tmp39_ = FALSE;
					}
					if (_tmp39_) {
						GeeUnrolledLinkedListNode* _tmp45_;
						_tmp45_ = node;
						gee_unrolled_linked_list_merge_with_next (self, _tmp45_);
					}
					_tmp46_ = self->priv->_stamp;
					self->priv->_stamp = _tmp46_ + 1;
					result = drained;
					_gee_unrolled_linked_list_node_free0 (node);
					return result;
				}
			}
		}
		self->priv->_tail = NULL;
		_tmp47_ = self->priv->_stamp;
		self->priv->_stamp = _tmp47_ + 1;
		result = drained;
		_gee_unrolled_linked_list_node_free0 (node);
		return result;
	}
}

static gboolean
gee_unrolled_linked_list_real_offer_head (GeeDeque* base,
                                          gconstpointer element)
{
	GeeUnrolledLinkedList * self;
	GeeUnrolledLinkedListNode* _tmp0_;
	GeeUnrolledLinkedListNode* _tmp4_;
	gboolean result;
	self = (GeeUnrolledLinkedList*) base;
	_tmp0_ = self->priv->_head;
	if (_tmp0_ == NULL) {
		GeeUnrolledLinkedListNode* _tmp1_;
		GeeUnrolledLinkedListNode* _tmp2_;
		GeeUnrolledLinkedListNode* _tmp3_;
		_tmp1_ = self->priv->_tail;
		_vala_assert (_tmp1_ == NULL, "_tail == null");
		_tmp2_ = gee_unrolled_linked_list_node_new ();
		_gee_unrolled_linked_list_node_free0 (self->priv->_head);
		self->priv->_head = _tmp2_;
		_tmp3_ = self->priv->_head;
		self->priv->_tail = _tmp3_;
	}
	_tmp4_ = self->priv->_head;
	gee_unrolled_linked_list_add_to_node (self, _tmp4_, element, 0, NULL, NULL);
	result = TRUE;
	return result;
}

static gpointer
gee_unrolled_linked_list_real_peek_head (GeeDeque* base)
{
	GeeUnrolledLinkedList * self;
	gpointer _tmp0_;
	gpointer result;
	self = (GeeUnrolledLinkedList*) base;
	_tmp0_ = gee_queue_peek ((GeeQueue*) self);
	result = _tmp0_;
	return result;
}

static gpointer
gee_unrolled_linked_list_real_poll_head (GeeDeque* base)
{
	GeeUnrolledLinkedList * self;
	gpointer _tmp0_;
	gpointer result;
	self = (GeeUnrolledLinkedList*) base;
	_tmp0_ = gee_queue_poll ((GeeQueue*) self);
	result = _tmp0_;
	return result;
}

static gint
gee_unrolled_linked_list_real_drain_head (GeeDeque* base,
                                          GeeCollection* recipient,
                                          gint amount)
{
	GeeUnrolledLinkedList * self;
	gint result;
	self = (GeeUnrolledLinkedList*) base;
	g_return_val_if_fail (recipient != NULL, 0);
	result = gee_queue_drain ((GeeQueue*) self, recipient, amount);
	return result;
}

static gboolean
gee_unrolled_linked_list_real_offer_tail (GeeDeque* base,
                                          gconstpointer element)
{
	GeeUnrolledLinkedList * self;
	gboolean result;
	self = (GeeUnrolledLinkedList*) base;
	result = gee_queue_offer ((GeeQueue*) self, element);
	return result;
}

static gpointer
gee_unrolled_linked_list_real_peek_tail (GeeDeque* base)
{
	GeeUnrolledLinkedList * self;
	GeeUnrolledLinkedListNode* _tmp0_;
	gpointer result;
	self = (GeeUnrolledLinkedList*) base;
	_tmp0_ = self->priv->_tail;
	if (_tmp0_ != NULL) {
		GeeUnrolledLinkedListNode* _tmp1_;
		GeeUnrolledLinkedListNode* _tmp2_;
		gconstpointer _tmp3_;
		gpointer _tmp4_;
		_tmp1_ = self->priv->_tail;
		_tmp2_ = self->priv->_tail;
		_tmp3_ = _tmp1_->_data[_tmp2_->_size - 1];
		_tmp4_ = ((_tmp3_ != NULL) && (self->priv->g_dup_func != NULL)) ? self->priv->g_dup_func ((gpointer) _tmp3_) : ((gpointer) _tmp3_);
		result = _tmp4_;
		return result;
	} else {
		result = NULL;
		return result;
	}
}

static gpointer
gee_unrolled_linked_list_real_poll_tail (GeeDeque* base)
{
	GeeUnrolledLinkedList * self;
	GeeUnrolledLinkedListNode* _tmp0_;
	gpointer result;
	self = (GeeUnrolledLinkedList*) base;
	_tmp0_ = self->priv->_head;
	if (_tmp0_ != NULL) {
		GeeUnrolledLinkedListNode* _tmp1_;
		GeeUnrolledLinkedListNode* _tmp2_;
		gpointer _tmp3_;
		_tmp1_ = self->priv->_tail;
		_tmp2_ = self->priv->_tail;
		_tmp3_ = gee_unrolled_linked_list_remove_from_node (self, _tmp1_, _tmp2_->_size - 1, NULL, NULL);
		result = _tmp3_;
		return result;
	} else {
		result = NULL;
		return result;
	}
}

static gint
gee_unrolled_linked_list_real_drain_tail (GeeDeque* base,
                                          GeeCollection* recipient,
                                          gint amount)
{
	GeeUnrolledLinkedList * self;
	gint drained = 0;
	gint result;
	self = (GeeUnrolledLinkedList*) base;
	g_return_val_if_fail (recipient != NULL, 0);
	drained = 0;
	if (amount < 0) {
		gint _tmp12_;
		{
			GeeUnrolledLinkedListNode* node = NULL;
			GeeUnrolledLinkedListNode* _tmp0_;
			_tmp0_ = self->priv->_tail;
			node = _tmp0_;
			{
				gboolean _tmp1_ = FALSE;
				_tmp1_ = TRUE;
				while (TRUE) {
					GeeUnrolledLinkedListNode* _tmp4_;
					GeeUnrolledLinkedListNode* _tmp11_;
					if (!_tmp1_) {
						GeeUnrolledLinkedListNode* _tmp2_;
						GeeUnrolledLinkedListNode* _tmp3_;
						_tmp2_ = node;
						_tmp3_ = _tmp2_->_prev;
						node = _tmp3_;
					}
					_tmp1_ = FALSE;
					_tmp4_ = node;
					if (!(_tmp4_ != NULL)) {
						break;
					}
					{
						gint i = 0;
						GeeUnrolledLinkedListNode* _tmp5_;
						_tmp5_ = node;
						i = _tmp5_->_size;
						{
							gboolean _tmp6_ = FALSE;
							_tmp6_ = TRUE;
							while (TRUE) {
								gint _tmp7_;
								gpointer data = NULL;
								GeeUnrolledLinkedListNode* _tmp8_;
								gpointer _tmp9_;
								gconstpointer _tmp10_;
								if (!_tmp6_) {
								}
								_tmp6_ = FALSE;
								_tmp7_ = i;
								i = _tmp7_ - 1;
								if (!(_tmp7_ > 0)) {
									break;
								}
								_tmp8_ = node;
								_tmp9_ = _tmp8_->_data[i];
								_tmp8_->_data[i] = NULL;
								data = _tmp9_;
								_tmp10_ = data;
								gee_collection_add (recipient, _tmp10_);
								((data == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (data = (self->priv->g_destroy_func (data), NULL));
							}
						}
					}
					_tmp11_ = node;
					_gee_unrolled_linked_list_node_free0 (_tmp11_->_next);
					_tmp11_->_next = NULL;
				}
			}
		}
		drained = self->priv->_size;
		_gee_unrolled_linked_list_node_free0 (self->priv->_head);
		self->priv->_head = NULL;
		self->priv->_tail = NULL;
		self->priv->_size = 0;
		_tmp12_ = self->priv->_stamp;
		self->priv->_stamp = _tmp12_ + 1;
		result = drained;
		return result;
	} else {
		gint _tmp48_;
		{
			GeeUnrolledLinkedListNode* node = NULL;
			GeeUnrolledLinkedListNode* _tmp13_;
			_tmp13_ = self->priv->_tail;
			node = _tmp13_;
			{
				gboolean _tmp14_ = FALSE;
				_tmp14_ = TRUE;
				while (TRUE) {
					GeeUnrolledLinkedListNode* _tmp15_;
					GeeUnrolledLinkedListNode* _tmp16_;
					if (!_tmp14_) {
					}
					_tmp14_ = FALSE;
					_tmp15_ = node;
					if (!(_tmp15_ != NULL)) {
						break;
					}
					_tmp16_ = node;
					if (_tmp16_->_size <= amount) {
						GeeUnrolledLinkedListNode* _tmp23_;
						GeeUnrolledLinkedListNode* _tmp24_;
						GeeUnrolledLinkedListNode* _tmp25_;
						GeeUnrolledLinkedListNode* _tmp26_;
						GeeUnrolledLinkedListNode* _tmp27_;
						GeeUnrolledLinkedListNode* _tmp28_;
						{
							gint i = 0;
							GeeUnrolledLinkedListNode* _tmp17_;
							_tmp17_ = node;
							i = _tmp17_->_size;
							{
								gboolean _tmp18_ = FALSE;
								_tmp18_ = TRUE;
								while (TRUE) {
									gint _tmp19_;
									gpointer data = NULL;
									GeeUnrolledLinkedListNode* _tmp20_;
									gpointer _tmp21_;
									gconstpointer _tmp22_;
									if (!_tmp18_) {
									}
									_tmp18_ = FALSE;
									_tmp19_ = i;
									i = _tmp19_ - 1;
									if (!(_tmp19_ > 0)) {
										break;
									}
									_tmp20_ = node;
									_tmp21_ = _tmp20_->_data[i];
									_tmp20_->_data[i] = NULL;
									data = _tmp21_;
									_tmp22_ = data;
									gee_collection_add (recipient, _tmp22_);
									((data == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (data = (self->priv->g_destroy_func (data), NULL));
								}
							}
						}
						_tmp23_ = node;
						amount = amount - _tmp23_->_size;
						_tmp24_ = node;
						drained += _tmp24_->_size;
						_tmp25_ = node;
						self->priv->_size = self->priv->_size - _tmp25_->_size;
						_tmp26_ = node;
						_tmp27_ = _tmp26_->_prev;
						node = _tmp27_;
						_tmp28_ = node;
						if (_tmp28_ != NULL) {
							GeeUnrolledLinkedListNode* _tmp29_;
							_tmp29_ = node;
							_gee_unrolled_linked_list_node_free0 (_tmp29_->_next);
							_tmp29_->_next = NULL;
						}
					} else {
						GeeUnrolledLinkedListNode* _tmp36_;
						GeeUnrolledLinkedListNode* _tmp37_;
						GeeUnrolledLinkedListNode* _tmp38_;
						gboolean _tmp39_ = FALSE;
						GeeUnrolledLinkedListNode* _tmp40_;
						GeeUnrolledLinkedListNode* _tmp41_;
						gint _tmp47_;
						{
							gint i = 0;
							i = 0;
							{
								gboolean _tmp30_ = FALSE;
								_tmp30_ = TRUE;
								while (TRUE) {
									gpointer data = NULL;
									GeeUnrolledLinkedListNode* _tmp32_;
									GeeUnrolledLinkedListNode* _tmp33_;
									gpointer _tmp34_;
									gconstpointer _tmp35_;
									if (!_tmp30_) {
										gint _tmp31_;
										_tmp31_ = i;
										i = _tmp31_ + 1;
									}
									_tmp30_ = FALSE;
									if (!(i < amount)) {
										break;
									}
									_tmp32_ = node;
									_tmp33_ = node;
									_tmp34_ = _tmp32_->_data[(_tmp33_->_size - i) - 1];
									_tmp32_->_data[(_tmp33_->_size - i) - 1] = NULL;
									data = _tmp34_;
									_tmp35_ = data;
									gee_collection_add (recipient, _tmp35_);
									((data == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (data = (self->priv->g_destroy_func (data), NULL));
								}
							}
						}
						drained += amount;
						self->priv->_size = self->priv->_size - amount;
						_tmp36_ = node;
						_tmp37_ = node;
						_tmp37_->_size = _tmp37_->_size - amount;
						_tmp38_ = node;
						self->priv->_tail = _tmp38_;
						_tmp40_ = node;
						_tmp41_ = _tmp40_->_prev;
						if (G_LIKELY (_tmp41_ != NULL)) {
							GeeUnrolledLinkedListNode* _tmp42_;
							GeeUnrolledLinkedListNode* _tmp43_;
							GeeUnrolledLinkedListNode* _tmp44_;
							_tmp42_ = node;
							_tmp43_ = node;
							_tmp44_ = _tmp43_->_prev;
							_tmp39_ = G_UNLIKELY ((_tmp42_->_size + _tmp44_->_size) < GEE_UNROLLED_LINKED_LIST_MERGE_THRESHOLD);
						} else {
							_tmp39_ = FALSE;
						}
						if (_tmp39_) {
							GeeUnrolledLinkedListNode* _tmp45_;
							GeeUnrolledLinkedListNode* _tmp46_;
							_tmp45_ = node;
							_tmp46_ = _tmp45_->_prev;
							gee_unrolled_linked_list_merge_with_next (self, _tmp46_);
						}
						_tmp47_ = self->priv->_stamp;
						self->priv->_stamp = _tmp47_ + 1;
						result = drained;
						return result;
					}
				}
			}
		}
		_gee_unrolled_linked_list_node_free0 (self->priv->_head);
		self->priv->_head = NULL;
		self->priv->_tail = NULL;
		_tmp48_ = self->priv->_stamp;
		self->priv->_stamp = _tmp48_ + 1;
		result = drained;
		return result;
	}
}

static GeeUnrolledLinkedListNode*
gee_unrolled_linked_list_find_node (GeeUnrolledLinkedList* self,
                                    gconstpointer item,
                                    gint* pos,
                                    gint* idx)
{
	gint _vala_pos = 0;
	gint _vala_idx = 0;
	GeeUnrolledLinkedListNode* result;
	g_return_val_if_fail (self != NULL, NULL);
	_vala_idx = 0;
	{
		GeeUnrolledLinkedListNode* node = NULL;
		GeeUnrolledLinkedListNode* _tmp0_;
		_tmp0_ = self->priv->_head;
		node = _tmp0_;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				GeeUnrolledLinkedListNode* _tmp4_;
				if (!_tmp1_) {
					GeeUnrolledLinkedListNode* _tmp2_;
					GeeUnrolledLinkedListNode* _tmp3_;
					_tmp2_ = node;
					_tmp3_ = _tmp2_->_next;
					node = _tmp3_;
				}
				_tmp1_ = FALSE;
				_tmp4_ = node;
				if (!(_tmp4_ != NULL)) {
					break;
				}
				{
					gboolean _tmp5_ = FALSE;
					_vala_pos = 0;
					_tmp5_ = TRUE;
					while (TRUE) {
						GeeUnrolledLinkedListNode* _tmp8_;
						GeeEqualDataFunc _tmp9_ = NULL;
						gpointer _tmp9__target = NULL;
						GeeEqualDataFunc _tmp10_;
						gpointer _tmp10__target;
						GeeUnrolledLinkedListNode* _tmp11_;
						gconstpointer _tmp12_;
						if (!_tmp5_) {
							gint _tmp6_;
							gint _tmp7_;
							_tmp6_ = _vala_pos;
							_vala_pos = _tmp6_ + 1;
							_tmp7_ = _vala_idx;
							_vala_idx = _tmp7_ + 1;
						}
						_tmp5_ = FALSE;
						_tmp8_ = node;
						if (!(_vala_pos < _tmp8_->_size)) {
							break;
						}
						_tmp9_ = gee_unrolled_linked_list_get_equal_func (self, &_tmp9__target);
						_tmp10_ = _tmp9_;
						_tmp10__target = _tmp9__target;
						_tmp11_ = node;
						_tmp12_ = _tmp11_->_data[_vala_pos];
						if (_tmp10_ (item, _tmp12_, _tmp10__target)) {
							GeeUnrolledLinkedListNode* _tmp13_;
							_tmp13_ = node;
							result = _tmp13_;
							if (pos) {
								*pos = _vala_pos;
							}
							if (idx) {
								*idx = _vala_idx;
							}
							return result;
						}
					}
				}
			}
		}
	}
	_vala_pos = -1;
	result = NULL;
	if (pos) {
		*pos = _vala_pos;
	}
	if (idx) {
		*idx = _vala_idx;
	}
	return result;
}

static gint*
_int_dup (gint* self)
{
	gint* dup;
	dup = g_new0 (gint, 1);
	memcpy (dup, self, sizeof (gint));
	return dup;
}

static gpointer
__int_dup0 (gpointer self)
{
	return self ? _int_dup (self) : NULL;
}

static GeeUnrolledLinkedListNode*
gee_unrolled_linked_list_find_node_by_idx (GeeUnrolledLinkedList* self,
                                           gint idx,
                                           gint** pos)
{
	gint* _vala_pos = NULL;
	gboolean _tmp0_ = FALSE;
	gint _tmp1_;
	gint _tmp2_;
	GeeUnrolledLinkedListNode* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (0 <= idx) {
		_tmp0_ = idx < self->priv->_size;
	} else {
		_tmp0_ = FALSE;
	}
	_vala_assert (_tmp0_, "0 <= idx && idx < _size");
	_tmp1_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) self);
	_tmp2_ = _tmp1_;
	if (idx <= (_tmp2_ / 2)) {
		{
			GeeUnrolledLinkedListNode* node = NULL;
			GeeUnrolledLinkedListNode* _tmp3_;
			_tmp3_ = self->priv->_head;
			node = _tmp3_;
			{
				gboolean _tmp4_ = FALSE;
				_tmp4_ = TRUE;
				while (TRUE) {
					GeeUnrolledLinkedListNode* _tmp7_;
					GeeUnrolledLinkedListNode* _tmp8_;
					GeeUnrolledLinkedListNode* _tmp11_;
					if (!_tmp4_) {
						GeeUnrolledLinkedListNode* _tmp5_;
						GeeUnrolledLinkedListNode* _tmp6_;
						_tmp5_ = node;
						_tmp6_ = _tmp5_->_next;
						node = _tmp6_;
					}
					_tmp4_ = FALSE;
					_tmp7_ = node;
					if (!(_tmp7_ != NULL)) {
						break;
					}
					_tmp8_ = node;
					if (idx < _tmp8_->_size) {
						gint* _tmp9_;
						GeeUnrolledLinkedListNode* _tmp10_;
						_tmp9_ = __int_dup0 (&idx);
						_g_free0 (_vala_pos);
						_vala_pos = _tmp9_;
						_tmp10_ = node;
						result = _tmp10_;
						if (pos) {
							*pos = _vala_pos;
						} else {
							_g_free0 (_vala_pos);
						}
						return result;
					}
					_tmp11_ = node;
					idx = idx - _tmp11_->_size;
				}
			}
		}
	} else {
		gint start_of_node = 0;
		gint count = 0;
		start_of_node = self->priv->_size;
		count = 0;
		{
			GeeUnrolledLinkedListNode* node = NULL;
			GeeUnrolledLinkedListNode* _tmp12_;
			_tmp12_ = self->priv->_tail;
			node = _tmp12_;
			{
				gboolean _tmp13_ = FALSE;
				_tmp13_ = TRUE;
				while (TRUE) {
					GeeUnrolledLinkedListNode* _tmp16_;
					GeeUnrolledLinkedListNode* _tmp17_;
					GeeUnrolledLinkedListNode* _tmp18_;
					if (!_tmp13_) {
						GeeUnrolledLinkedListNode* _tmp14_;
						GeeUnrolledLinkedListNode* _tmp15_;
						_tmp14_ = node;
						_tmp15_ = _tmp14_->_prev;
						node = _tmp15_;
					}
					_tmp13_ = FALSE;
					_tmp16_ = node;
					if (!(_tmp16_ != NULL)) {
						break;
					}
					_tmp17_ = node;
					start_of_node -= _tmp17_->_size;
					_tmp18_ = node;
					count += _tmp18_->_size;
					if (idx >= start_of_node) {
						gint _tmp19_;
						gint* _tmp20_;
						gboolean _tmp21_ = FALSE;
						gint* _tmp22_;
						GeeUnrolledLinkedListNode* _tmp25_;
						_tmp19_ = idx - start_of_node;
						_tmp20_ = __int_dup0 (&_tmp19_);
						_g_free0 (_vala_pos);
						_vala_pos = _tmp20_;
						_tmp22_ = _vala_pos;
						if (0 <= (*_tmp22_)) {
							gint* _tmp23_;
							GeeUnrolledLinkedListNode* _tmp24_;
							_tmp23_ = _vala_pos;
							_tmp24_ = node;
							_tmp21_ = (*_tmp23_) < _tmp24_->_size;
						} else {
							_tmp21_ = FALSE;
						}
						_vala_assert (_tmp21_, "0 <= pos && pos < node._size");
						_tmp25_ = node;
						result = _tmp25_;
						if (pos) {
							*pos = _vala_pos;
						} else {
							_g_free0 (_vala_pos);
						}
						return result;
					}
				}
			}
		}
		_vala_assert (start_of_node == 0, "start_of_node == 0");
	}
	g_assert_not_reached ();
}

static void
gee_unrolled_linked_list_add_to_node (GeeUnrolledLinkedList* self,
                                      GeeUnrolledLinkedListNode* node,
                                      gconstpointer item,
                                      gint pos,
                                      GeeUnrolledLinkedListNode** new_node,
                                      gint* new_pos)
{
	GeeUnrolledLinkedListNode* _vala_new_node = NULL;
	gint _vala_new_pos = 0;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp16_ = FALSE;
	gboolean _tmp17_ = FALSE;
	gpointer _tmp18_;
	gint _tmp19_;
	gint _tmp20_;
	gint _tmp21_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	if (0 <= pos) {
		_tmp1_ = pos <= node->_size;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		_tmp0_ = node->_size <= GEE_UNROLLED_LINKED_LIST_NODE_SIZE;
	} else {
		_tmp0_ = FALSE;
	}
	_vala_assert (_tmp0_, "0 <= pos && pos <= node._size && node._size <= NODE_SIZE");
	if (node->_size == GEE_UNROLLED_LINKED_LIST_NODE_SIZE) {
		GeeUnrolledLinkedListNode* next = NULL;
		GeeUnrolledLinkedListNode* _tmp2_;
		GeeUnrolledLinkedListNode* _tmp3_;
		GeeUnrolledLinkedListNode* _tmp4_;
		GeeUnrolledLinkedListNode* _tmp5_;
		GeeUnrolledLinkedListNode* _tmp6_;
		GeeUnrolledLinkedListNode* _tmp7_;
		GeeUnrolledLinkedListNode* _tmp12_;
		GeeUnrolledLinkedListNode* _tmp13_;
		GeeUnrolledLinkedListNode* _tmp14_;
		_tmp2_ = gee_unrolled_linked_list_node_new ();
		next = _tmp2_;
		_tmp3_ = next;
		_tmp4_ = node->_next;
		node->_next = NULL;
		_gee_unrolled_linked_list_node_free0 (_tmp3_->_next);
		_tmp3_->_next = _tmp4_;
		_tmp5_ = next;
		_tmp5_->_prev = node;
		_tmp6_ = next;
		_tmp7_ = _tmp6_->_next;
		if (G_UNLIKELY (_tmp7_ == NULL)) {
			GeeUnrolledLinkedListNode* _tmp8_;
			_tmp8_ = next;
			self->priv->_tail = _tmp8_;
		} else {
			GeeUnrolledLinkedListNode* _tmp9_;
			GeeUnrolledLinkedListNode* _tmp10_;
			GeeUnrolledLinkedListNode* _tmp11_;
			_tmp9_ = next;
			_tmp10_ = _tmp9_->_next;
			_tmp11_ = next;
			_tmp10_->_prev = _tmp11_;
		}
		_tmp12_ = next;
		memcpy (_tmp12_->_data, &node->_data[GEE_UNROLLED_LINKED_LIST_SPLIT_POS], (gsize) (sizeof (gpointer) * (GEE_UNROLLED_LINKED_LIST_NODE_SIZE - GEE_UNROLLED_LINKED_LIST_SPLIT_POS)));
		node->_size = GEE_UNROLLED_LINKED_LIST_SPLIT_POS;
		_tmp13_ = next;
		_tmp13_->_size = GEE_UNROLLED_LINKED_LIST_NODE_SIZE - GEE_UNROLLED_LINKED_LIST_SPLIT_POS;
		_tmp14_ = next;
		next = NULL;
		_gee_unrolled_linked_list_node_free0 (node->_next);
		node->_next = _tmp14_;
		if (pos > GEE_UNROLLED_LINKED_LIST_SPLIT_POS) {
			GeeUnrolledLinkedListNode* _tmp15_;
			_tmp15_ = node->_next;
			node = _tmp15_;
			pos = pos - GEE_UNROLLED_LINKED_LIST_SPLIT_POS;
		}
		_gee_unrolled_linked_list_node_free0 (next);
	}
	if (0 <= pos) {
		_tmp17_ = pos <= node->_size;
	} else {
		_tmp17_ = FALSE;
	}
	if (_tmp17_) {
		_tmp16_ = node->_size < GEE_UNROLLED_LINKED_LIST_NODE_SIZE;
	} else {
		_tmp16_ = FALSE;
	}
	_vala_assert (_tmp16_, "0 <= pos && pos <= node._size && node._size < NODE_SIZE");
	memmove (&node->_data[pos + 1], &node->_data[pos], (gsize) (sizeof (gpointer) * (node->_size - pos)));
	memset (&node->_data[pos], 0, sizeof (gpointer));
	_tmp18_ = ((item != NULL) && (self->priv->g_dup_func != NULL)) ? self->priv->g_dup_func ((gpointer) item) : ((gpointer) item);
	((node->_data[pos] == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (node->_data[pos] = (self->priv->g_destroy_func (node->_data[pos]), NULL));
	node->_data[pos] = _tmp18_;
	_tmp19_ = node->_size;
	node->_size = _tmp19_ + 1;
	_tmp20_ = self->priv->_size;
	self->priv->_size = _tmp20_ + 1;
	_tmp21_ = self->priv->_stamp;
	self->priv->_stamp = _tmp21_ + 1;
	_vala_assert (node->_size <= GEE_UNROLLED_LINKED_LIST_NODE_SIZE, "node._size <= NODE_SIZE");
	_vala_new_node = node;
	_vala_new_pos = pos;
	if (new_node) {
		*new_node = _vala_new_node;
	}
	if (new_pos) {
		*new_pos = _vala_new_pos;
	}
}

static gpointer
gee_unrolled_linked_list_remove_from_node (GeeUnrolledLinkedList* self,
                                           GeeUnrolledLinkedListNode* node,
                                           gint pos,
                                           GeeUnrolledLinkedListNode** new_node,
                                           gint* new_pos)
{
	GeeUnrolledLinkedListNode* _vala_new_node = NULL;
	gint _vala_new_pos = 0;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gpointer item = NULL;
	gpointer _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	gpointer result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (node != NULL, NULL);
	if (0 <= pos) {
		_tmp1_ = pos <= node->_size;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		_tmp0_ = pos <= GEE_UNROLLED_LINKED_LIST_NODE_SIZE;
	} else {
		_tmp0_ = FALSE;
	}
	_vala_assert (_tmp0_, "(0 <= pos && pos <= node._size) && pos <= NODE_SIZE");
	_tmp2_ = node->_data[pos];
	node->_data[pos] = NULL;
	item = _tmp2_;
	memmove (&node->_data[pos], &node->_data[pos + 1], (gsize) (sizeof (gpointer) * (node->_size - (pos + 1))));
	_tmp3_ = node->_size;
	node->_size = _tmp3_ - 1;
	_tmp4_ = self->priv->_size;
	self->priv->_size = _tmp4_ - 1;
	_tmp5_ = self->priv->_stamp;
	self->priv->_stamp = _tmp5_ + 1;
	_vala_assert (node->_size >= 0, "node._size >= 0");
	_vala_assert (self->priv->_size >= 0, "_size >= 0");
	if (G_UNLIKELY (node->_size == 0)) {
		GeeUnrolledLinkedListNode* _tmp6_;
		GeeUnrolledLinkedListNode* _tmp7_;
		_tmp6_ = node->_prev;
		_vala_new_node = _tmp6_;
		_tmp7_ = node->_prev;
		if (G_LIKELY (_tmp7_ != NULL)) {
			GeeUnrolledLinkedListNode* _tmp8_;
			_tmp8_ = node->_prev;
			_vala_new_pos = _tmp8_->_size - 1;
		} else {
			_vala_new_pos = -1;
		}
		gee_unrolled_linked_list_delete_node (self, node);
	} else {
		gboolean _tmp9_ = FALSE;
		GeeUnrolledLinkedListNode* _tmp10_;
		_tmp10_ = node->_prev;
		if (G_LIKELY (_tmp10_ != NULL)) {
			GeeUnrolledLinkedListNode* _tmp11_;
			_tmp11_ = node->_prev;
			_tmp9_ = G_UNLIKELY ((node->_size + _tmp11_->_size) < GEE_UNROLLED_LINKED_LIST_MERGE_THRESHOLD);
		} else {
			_tmp9_ = FALSE;
		}
		if (_tmp9_) {
			GeeUnrolledLinkedListNode* _tmp12_;
			GeeUnrolledLinkedListNode* _tmp13_;
			GeeUnrolledLinkedListNode* _tmp14_;
			_tmp12_ = node->_prev;
			_vala_new_node = _tmp12_;
			_tmp13_ = node->_prev;
			_vala_new_pos = (_tmp13_->_size + pos) - 1;
			_tmp14_ = node->_prev;
			gee_unrolled_linked_list_merge_with_next (self, _tmp14_);
		} else {
			gboolean _tmp15_ = FALSE;
			GeeUnrolledLinkedListNode* _tmp16_;
			_tmp16_ = node->_next;
			if (G_LIKELY (_tmp16_ != NULL)) {
				GeeUnrolledLinkedListNode* _tmp17_;
				_tmp17_ = node->_next;
				_tmp15_ = G_UNLIKELY ((node->_size + _tmp17_->_size) < GEE_UNROLLED_LINKED_LIST_MERGE_THRESHOLD);
			} else {
				_tmp15_ = FALSE;
			}
			if (_tmp15_) {
				gee_unrolled_linked_list_merge_with_next (self, node);
				_vala_new_node = node;
				_vala_new_pos = pos - 1;
			} else {
				if (pos != 0) {
					_vala_new_node = node;
					_vala_new_pos = pos - 1;
				} else {
					GeeUnrolledLinkedListNode* _tmp18_;
					GeeUnrolledLinkedListNode* _tmp19_;
					_tmp18_ = node->_prev;
					_vala_new_node = _tmp18_;
					_tmp19_ = node->_prev;
					if (G_LIKELY (_tmp19_ != NULL)) {
						GeeUnrolledLinkedListNode* _tmp20_;
						_tmp20_ = node->_prev;
						_vala_new_pos = _tmp20_->_size - 1;
					} else {
						_vala_new_pos = -1;
					}
				}
			}
		}
	}
	result = item;
	if (new_node) {
		*new_node = _vala_new_node;
	}
	if (new_pos) {
		*new_pos = _vala_new_pos;
	}
	return result;
}

static void
gee_unrolled_linked_list_merge_with_next (GeeUnrolledLinkedList* self,
                                          GeeUnrolledLinkedListNode* node)
{
	GeeUnrolledLinkedListNode* _tmp0_;
	GeeUnrolledLinkedListNode* _tmp1_;
	GeeUnrolledLinkedListNode* next = NULL;
	GeeUnrolledLinkedListNode* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = node->_next;
	_vala_assert (_tmp0_ != NULL, "node._next != null");
	_tmp1_ = node->_next;
	_vala_assert ((node->_size + _tmp1_->_size) <= GEE_UNROLLED_LINKED_LIST_NODE_SIZE, "node._size + node._next._size <= NODE_SIZE");
	_tmp2_ = node->_next;
	next = _tmp2_;
	memcpy (&node->_data[node->_size], next->_data, (gsize) (sizeof (gpointer) * next->_size));
	node->_size = node->_size + next->_size;
	_vala_assert (node->_size <= GEE_UNROLLED_LINKED_LIST_NODE_SIZE, "node._size <= NODE_SIZE");
	gee_unrolled_linked_list_delete_node (self, next);
}

static void
gee_unrolled_linked_list_delete_node (GeeUnrolledLinkedList* self,
                                      GeeUnrolledLinkedListNode* node)
{
	GeeUnrolledLinkedListNode* _tmp0_;
	GeeUnrolledLinkedListNode* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = node->_next;
	if (G_LIKELY (_tmp0_ != NULL)) {
		GeeUnrolledLinkedListNode* _tmp1_;
		GeeUnrolledLinkedListNode* _tmp2_;
		_tmp1_ = node->_next;
		_tmp2_ = node->_prev;
		_tmp1_->_prev = _tmp2_;
	} else {
		GeeUnrolledLinkedListNode* _tmp3_;
		_tmp3_ = node->_prev;
		self->priv->_tail = _tmp3_;
	}
	_tmp4_ = node->_prev;
	if (G_LIKELY (_tmp4_ != NULL)) {
		GeeUnrolledLinkedListNode* _tmp5_;
		GeeUnrolledLinkedListNode* _tmp6_;
		_tmp5_ = node->_prev;
		_tmp6_ = node->_next;
		node->_next = NULL;
		_gee_unrolled_linked_list_node_free0 (_tmp5_->_next);
		_tmp5_->_next = _tmp6_;
	} else {
		GeeUnrolledLinkedListNode* _tmp7_;
		_tmp7_ = node->_next;
		node->_next = NULL;
		_gee_unrolled_linked_list_node_free0 (self->priv->_head);
		self->priv->_head = _tmp7_;
	}
}

GeeEqualDataFunc
gee_unrolled_linked_list_get_equal_func (GeeUnrolledLinkedList* self,
                                         gpointer* result_target)
{
	GeeEqualDataFunc result;
	GeeFunctionsEqualDataFuncClosure* _tmp0_;
	GeeEqualDataFunc _tmp1_;
	gpointer _tmp1__target;
	GeeEqualDataFunc _tmp2_;
	gpointer _tmp2__target;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_equal_func;
	_tmp1_ = _tmp0_->func;
	_tmp1__target = _tmp0_->func_target;
	_tmp2_ = _tmp1_;
	_tmp2__target = _tmp1__target;
	*result_target = _tmp2__target;
	result = _tmp2_;
	return result;
}

static void
gee_unrolled_linked_list_set_equal_func (GeeUnrolledLinkedList* self,
                                         GeeEqualDataFunc value,
                                         gpointer value_target)
{
	g_return_if_fail (self != NULL);
}

static gint
gee_unrolled_linked_list_real_get_size (GeeAbstractCollection* base)
{
	gint result;
	GeeUnrolledLinkedList* self;
	self = (GeeUnrolledLinkedList*) base;
	result = self->priv->_size;
	return result;
}

static gboolean
gee_unrolled_linked_list_real_get_read_only (GeeAbstractCollection* base)
{
	gboolean result;
	GeeUnrolledLinkedList* self;
	self = (GeeUnrolledLinkedList*) base;
	result = FALSE;
	return result;
}

static gint
gee_unrolled_linked_list_real_get_capacity (GeeQueue* base)
{
	gint result;
	GeeUnrolledLinkedList* self;
	self = (GeeUnrolledLinkedList*) base;
	result = GEE_QUEUE_UNBOUNDED_CAPACITY;
	return result;
}

static gint
gee_unrolled_linked_list_real_get_remaining_capacity (GeeQueue* base)
{
	gint result;
	GeeUnrolledLinkedList* self;
	self = (GeeUnrolledLinkedList*) base;
	result = GEE_QUEUE_UNBOUNDED_CAPACITY;
	return result;
}

static gboolean
gee_unrolled_linked_list_real_get_is_full (GeeQueue* base)
{
	gboolean result;
	GeeUnrolledLinkedList* self;
	self = (GeeUnrolledLinkedList*) base;
	result = FALSE;
	return result;
}

static inline gpointer
gee_unrolled_linked_list_iterator_get_instance_private (GeeUnrolledLinkedListIterator* self)
{
	return G_STRUCT_MEMBER_P (self, GeeUnrolledLinkedListIterator_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static GeeUnrolledLinkedListIterator*
gee_unrolled_linked_list_iterator_construct (GType object_type,
                                             GType g_type,
                                             GBoxedCopyFunc g_dup_func,
                                             GDestroyNotify g_destroy_func,
                                             GeeUnrolledLinkedList* list)
{
	GeeUnrolledLinkedListIterator * self = NULL;
	GeeUnrolledLinkedList* _tmp0_;
	g_return_val_if_fail (list != NULL, NULL);
	self = (GeeUnrolledLinkedListIterator*) g_object_new (object_type, "g-type", g_type, "g-dup-func", g_dup_func, "g-destroy-func", g_destroy_func, NULL);
	self->priv->g_type = g_type;
	self->priv->g_dup_func = g_dup_func;
	self->priv->g_destroy_func = g_destroy_func;
	_tmp0_ = _g_object_ref0 (list);
	_g_object_unref0 (self->priv->_list);
	self->priv->_list = _tmp0_;
	self->priv->_stamp = list->priv->_stamp;
	return self;
}

static GeeUnrolledLinkedListIterator*
gee_unrolled_linked_list_iterator_new (GType g_type,
                                       GBoxedCopyFunc g_dup_func,
                                       GDestroyNotify g_destroy_func,
                                       GeeUnrolledLinkedList* list)
{
	return gee_unrolled_linked_list_iterator_construct (GEE_UNROLLED_LINKED_LIST_TYPE_ITERATOR, g_type, g_dup_func, g_destroy_func, list);
}

static GeeUnrolledLinkedListIterator*
gee_unrolled_linked_list_iterator_construct_from_iterator (GType object_type,
                                                           GType g_type,
                                                           GBoxedCopyFunc g_dup_func,
                                                           GDestroyNotify g_destroy_func,
                                                           GeeUnrolledLinkedListIterator* iter)
{
	GeeUnrolledLinkedListIterator * self = NULL;
	GeeUnrolledLinkedList* _tmp0_;
	GeeUnrolledLinkedList* _tmp1_;
	GeeUnrolledLinkedListNode* _tmp2_;
	g_return_val_if_fail (iter != NULL, NULL);
	self = (GeeUnrolledLinkedListIterator*) g_object_new (object_type, "g-type", g_type, "g-dup-func", g_dup_func, "g-destroy-func", g_destroy_func, NULL);
	self->priv->g_type = g_type;
	self->priv->g_dup_func = g_dup_func;
	self->priv->g_destroy_func = g_destroy_func;
	_tmp0_ = iter->priv->_list;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_list);
	self->priv->_list = _tmp1_;
	self->priv->_stamp = iter->priv->_stamp;
	_tmp2_ = iter->priv->_current;
	self->priv->_current = _tmp2_;
	self->priv->_pos = iter->priv->_pos;
	self->priv->_deleted = iter->priv->_deleted;
	self->priv->_index = iter->priv->_index;
	return self;
}

static GeeUnrolledLinkedListIterator*
gee_unrolled_linked_list_iterator_new_from_iterator (GType g_type,
                                                     GBoxedCopyFunc g_dup_func,
                                                     GDestroyNotify g_destroy_func,
                                                     GeeUnrolledLinkedListIterator* iter)
{
	return gee_unrolled_linked_list_iterator_construct_from_iterator (GEE_UNROLLED_LINKED_LIST_TYPE_ITERATOR, g_type, g_dup_func, g_destroy_func, iter);
}

static gboolean
gee_unrolled_linked_list_iterator_real_foreach (GeeTraversable* base,
                                                GeeForallFunc f,
                                                gpointer f_target)
{
	GeeUnrolledLinkedListIterator * self;
	GeeUnrolledLinkedList* _tmp0_;
	gboolean _tmp1_ = FALSE;
	GeeUnrolledLinkedListNode* _tmp2_;
	gboolean _tmp3_ = FALSE;
	GeeUnrolledLinkedListNode* _tmp4_;
	GeeUnrolledLinkedListNode* current = NULL;
	GeeUnrolledLinkedListNode* _tmp7_;
	GeeUnrolledLinkedListNode* prev = NULL;
	gint pos = 0;
	gint prev_pos = 0;
	gint index = 0;
	gint prev_index = 0;
	gboolean deleted = FALSE;
	GeeUnrolledLinkedListNode* _tmp8_;
	GeeUnrolledLinkedListNode* _tmp36_;
	gboolean result;
	self = (GeeUnrolledLinkedListIterator*) base;
	_tmp0_ = self->priv->_list;
	_vala_assert (_tmp0_->priv->_stamp == self->priv->_stamp, "_list._stamp == _stamp");
	_tmp2_ = self->priv->_current;
	if (!(_tmp2_ == NULL)) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = self->priv->_pos == -1;
	}
	_vala_assert (_tmp1_, "!(_current == null) || _pos == -1");
	_tmp4_ = self->priv->_current;
	if (!(_tmp4_ != NULL)) {
		_tmp3_ = TRUE;
	} else {
		gboolean _tmp5_ = FALSE;
		if (0 <= self->priv->_pos) {
			GeeUnrolledLinkedListNode* _tmp6_;
			_tmp6_ = self->priv->_current;
			_tmp5_ = self->priv->_pos <= _tmp6_->_size;
		} else {
			_tmp5_ = FALSE;
		}
		_tmp3_ = _tmp5_;
	}
	_vala_assert (_tmp3_, "!(_current != null) || (0 <= _pos && _pos <= _current._size)");
	_tmp7_ = self->priv->_current;
	current = _tmp7_;
	prev = NULL;
	pos = self->priv->_pos;
	prev_pos = -1;
	index = self->priv->_index;
	prev_index = -1;
	deleted = self->priv->_deleted;
	_tmp8_ = current;
	if (_tmp8_ == NULL) {
		GeeUnrolledLinkedList* _tmp9_;
		GeeUnrolledLinkedListNode* _tmp10_;
		GeeUnrolledLinkedListNode* _tmp11_;
		_tmp9_ = self->priv->_list;
		_tmp10_ = _tmp9_->priv->_head;
		current = _tmp10_;
		pos = 0;
		deleted = FALSE;
		index = 0;
		_tmp11_ = current;
		if (G_UNLIKELY (_tmp11_ == NULL)) {
			result = TRUE;
			return result;
		}
	} else {
		if (G_UNLIKELY (deleted)) {
			GeeUnrolledLinkedListNode* _tmp12_;
			_tmp12_ = self->priv->_current;
			if (G_UNLIKELY (_tmp12_->_size == (self->priv->_pos + 1))) {
				GeeUnrolledLinkedListNode* _tmp13_;
				GeeUnrolledLinkedListNode* _tmp14_;
				GeeUnrolledLinkedListNode* _tmp15_;
				GeeUnrolledLinkedListNode* _tmp16_;
				GeeUnrolledLinkedListNode* _tmp17_;
				gint _tmp18_;
				_tmp13_ = self->priv->_current;
				_tmp14_ = _tmp13_->_next;
				if (G_UNLIKELY (_tmp14_ != NULL)) {
					result = TRUE;
					return result;
				}
				_tmp15_ = current;
				prev = _tmp15_;
				_tmp16_ = self->priv->_current;
				_tmp17_ = _tmp16_->_next;
				current = _tmp17_;
				prev_pos = pos;
				pos = 0;
				deleted = FALSE;
				_tmp18_ = index;
				index = _tmp18_ + 1;
				prev_index = _tmp18_;
			} else {
				GeeUnrolledLinkedListNode* _tmp19_;
				gint _tmp20_;
				gint _tmp21_;
				_tmp19_ = current;
				prev = _tmp19_;
				_tmp20_ = pos;
				pos = _tmp20_ + 1;
				prev_pos = _tmp20_;
				deleted = FALSE;
				_tmp21_ = index;
				index = _tmp21_ + 1;
				prev_index = _tmp21_;
			}
		}
	}
	{
		gboolean _tmp22_ = FALSE;
		_tmp22_ = TRUE;
		while (TRUE) {
			GeeUnrolledLinkedListNode* _tmp26_;
			gint size = 0;
			GeeUnrolledLinkedListNode* _tmp27_;
			if (!_tmp22_) {
				GeeUnrolledLinkedListNode* _tmp23_;
				GeeUnrolledLinkedListNode* _tmp24_;
				GeeUnrolledLinkedListNode* _tmp25_;
				_tmp23_ = current;
				prev = _tmp23_;
				_tmp24_ = current;
				_tmp25_ = _tmp24_->_next;
				current = _tmp25_;
				pos = 0;
			}
			_tmp22_ = FALSE;
			_tmp26_ = current;
			if (!(_tmp26_ != NULL)) {
				break;
			}
			_tmp27_ = current;
			size = _tmp27_->_size;
			{
				gboolean _tmp28_ = FALSE;
				_tmp28_ = TRUE;
				while (TRUE) {
					GeeUnrolledLinkedListNode* _tmp32_;
					gconstpointer _tmp33_;
					gpointer _tmp34_;
					if (!_tmp28_) {
						GeeUnrolledLinkedListNode* _tmp29_;
						gint _tmp30_;
						gint _tmp31_;
						_tmp29_ = current;
						prev = _tmp29_;
						_tmp30_ = pos;
						pos = _tmp30_ + 1;
						prev_pos = _tmp30_;
						_tmp31_ = index;
						index = _tmp31_ + 1;
						prev_index = _tmp31_;
					}
					_tmp28_ = FALSE;
					if (!(pos < size)) {
						break;
					}
					deleted = FALSE;
					_tmp32_ = current;
					_tmp33_ = _tmp32_->_data[pos];
					_tmp34_ = ((_tmp33_ != NULL) && (self->priv->g_dup_func != NULL)) ? self->priv->g_dup_func ((gpointer) _tmp33_) : ((gpointer) _tmp33_);
					if (!f (_tmp34_, f_target)) {
						GeeUnrolledLinkedListNode* _tmp35_;
						_tmp35_ = current;
						self->priv->_current = _tmp35_;
						self->priv->_pos = pos;
						self->priv->_deleted = deleted;
						self->priv->_index = index;
						result = FALSE;
						return result;
					}
				}
			}
		}
	}
	_tmp36_ = prev;
	self->priv->_current = _tmp36_;
	self->priv->_pos = prev_pos;
	self->priv->_deleted = deleted;
	self->priv->_index = prev_index;
	result = TRUE;
	return result;
}

static GeeIterator**
gee_unrolled_linked_list_iterator_real_tee (GeeTraversable* base,
                                            guint forks,
                                            gint* result_length1)
{
	GeeUnrolledLinkedListIterator * self;
	GeeIterator** result;
	self = (GeeUnrolledLinkedListIterator*) base;
	if (forks == ((guint) 0)) {
		GeeIterator** _tmp0_;
		GeeIterator** _tmp1_;
		gint _tmp1__length1;
		_tmp0_ = g_new0 (GeeIterator*, 0 + 1);
		_tmp1_ = _tmp0_;
		_tmp1__length1 = 0;
		if (result_length1) {
			*result_length1 = _tmp1__length1;
		}
		result = _tmp1_;
		return result;
	} else {
		GeeIterator** _result_ = NULL;
		GeeIterator** _tmp2_;
		gint _result__length1;
		gint __result__size_;
		GeeIterator** _tmp3_;
		gint _tmp3__length1;
		GeeIterator* _tmp4_;
		GeeIterator** _tmp9_;
		gint _tmp9__length1;
		_tmp2_ = g_new0 (GeeIterator*, forks + 1);
		_result_ = _tmp2_;
		_result__length1 = forks;
		__result__size_ = _result__length1;
		_tmp3_ = _result_;
		_tmp3__length1 = _result__length1;
		_tmp4_ = _g_object_ref0 ((GeeIterator*) self);
		_g_object_unref0 (_tmp3_[0]);
		_tmp3_[0] = _tmp4_;
		{
			guint i = 0U;
			i = (guint) 1;
			{
				gboolean _tmp5_ = FALSE;
				_tmp5_ = TRUE;
				while (TRUE) {
					GeeIterator** _tmp7_;
					gint _tmp7__length1;
					GeeUnrolledLinkedListIterator* _tmp8_;
					if (!_tmp5_) {
						guint _tmp6_;
						_tmp6_ = i;
						i = _tmp6_ + 1;
					}
					_tmp5_ = FALSE;
					if (!(i < forks)) {
						break;
					}
					_tmp7_ = _result_;
					_tmp7__length1 = _result__length1;
					_tmp8_ = gee_unrolled_linked_list_iterator_new_from_iterator (self->priv->g_type, (GBoxedCopyFunc) self->priv->g_dup_func, (GDestroyNotify) self->priv->g_destroy_func, self);
					_g_object_unref0 (_tmp7_[i]);
					_tmp7_[i] = (GeeIterator*) _tmp8_;
				}
			}
		}
		_tmp9_ = _result_;
		_tmp9__length1 = _result__length1;
		if (result_length1) {
			*result_length1 = _tmp9__length1;
		}
		result = _tmp9_;
		return result;
	}
}

static gboolean
gee_unrolled_linked_list_iterator_real_next (GeeIterator* base)
{
	GeeUnrolledLinkedListIterator * self;
	GeeUnrolledLinkedList* _tmp0_;
	gboolean _tmp1_ = FALSE;
	GeeUnrolledLinkedListNode* _tmp2_;
	gboolean _tmp3_ = FALSE;
	GeeUnrolledLinkedListNode* _tmp4_;
	GeeUnrolledLinkedListNode* _tmp7_;
	gboolean result;
	self = (GeeUnrolledLinkedListIterator*) base;
	_tmp0_ = self->priv->_list;
	_vala_assert (_tmp0_->priv->_stamp == self->priv->_stamp, "_list._stamp == _stamp");
	_tmp2_ = self->priv->_current;
	if (!(_tmp2_ == NULL)) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = self->priv->_pos == -1;
	}
	_vala_assert (_tmp1_, "!(_current == null) || _pos == -1");
	_tmp4_ = self->priv->_current;
	if (!(_tmp4_ != NULL)) {
		_tmp3_ = TRUE;
	} else {
		gboolean _tmp5_ = FALSE;
		if (0 <= self->priv->_pos) {
			GeeUnrolledLinkedListNode* _tmp6_;
			_tmp6_ = self->priv->_current;
			_tmp5_ = self->priv->_pos <= _tmp6_->_size;
		} else {
			_tmp5_ = FALSE;
		}
		_tmp3_ = _tmp5_;
	}
	_vala_assert (_tmp3_, "!(_current != null) || (0 <= _pos && _pos <= _current._size)");
	_tmp7_ = self->priv->_current;
	if (G_UNLIKELY (_tmp7_ == NULL)) {
		GeeUnrolledLinkedList* _tmp8_;
		GeeUnrolledLinkedListNode* _tmp9_;
		GeeUnrolledLinkedListNode* _tmp10_;
		GeeUnrolledLinkedListNode* _tmp11_;
		_tmp8_ = self->priv->_list;
		_tmp9_ = _tmp8_->priv->_head;
		self->priv->_current = _tmp9_;
		_tmp10_ = self->priv->_current;
		if (_tmp10_ != NULL) {
			self->priv->_pos = 0;
			self->priv->_deleted = FALSE;
			self->priv->_index = 0;
		}
		_tmp11_ = self->priv->_current;
		result = _tmp11_ != NULL;
		return result;
	} else {
		GeeUnrolledLinkedListNode* _tmp12_;
		_tmp12_ = self->priv->_current;
		if (G_UNLIKELY (_tmp12_->_size == (self->priv->_pos + 1))) {
			GeeUnrolledLinkedListNode* _tmp13_;
			GeeUnrolledLinkedListNode* _tmp14_;
			_tmp13_ = self->priv->_current;
			_tmp14_ = _tmp13_->_next;
			if (G_LIKELY (_tmp14_ != NULL)) {
				GeeUnrolledLinkedListNode* _tmp15_;
				GeeUnrolledLinkedListNode* _tmp16_;
				gint _tmp17_;
				_tmp15_ = self->priv->_current;
				_tmp16_ = _tmp15_->_next;
				self->priv->_current = _tmp16_;
				self->priv->_pos = 0;
				self->priv->_deleted = FALSE;
				_tmp17_ = self->priv->_index;
				self->priv->_index = _tmp17_ + 1;
				result = TRUE;
				return result;
			} else {
				result = FALSE;
				return result;
			}
		} else {
			gint _tmp18_;
			gint _tmp19_;
			_tmp18_ = self->priv->_pos;
			self->priv->_pos = _tmp18_ + 1;
			self->priv->_deleted = FALSE;
			_tmp19_ = self->priv->_index;
			self->priv->_index = _tmp19_ + 1;
			result = TRUE;
			return result;
		}
	}
}

static gboolean
gee_unrolled_linked_list_iterator_real_has_next (GeeIterator* base)
{
	GeeUnrolledLinkedListIterator * self;
	GeeUnrolledLinkedList* _tmp0_;
	gboolean _tmp1_ = FALSE;
	GeeUnrolledLinkedListNode* _tmp2_;
	gboolean _tmp3_ = FALSE;
	GeeUnrolledLinkedListNode* _tmp4_;
	GeeUnrolledLinkedListNode* _tmp7_;
	gboolean result;
	self = (GeeUnrolledLinkedListIterator*) base;
	_tmp0_ = self->priv->_list;
	_vala_assert (_tmp0_->priv->_stamp == self->priv->_stamp, "_list._stamp == _stamp");
	_tmp2_ = self->priv->_current;
	if (!(_tmp2_ == NULL)) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = self->priv->_pos == -1;
	}
	_vala_assert (_tmp1_, "!(_current == null) || _pos == -1");
	_tmp4_ = self->priv->_current;
	if (!(_tmp4_ != NULL)) {
		_tmp3_ = TRUE;
	} else {
		gboolean _tmp5_ = FALSE;
		if (0 <= self->priv->_pos) {
			GeeUnrolledLinkedListNode* _tmp6_;
			_tmp6_ = self->priv->_current;
			_tmp5_ = self->priv->_pos <= _tmp6_->_size;
		} else {
			_tmp5_ = FALSE;
		}
		_tmp3_ = _tmp5_;
	}
	_vala_assert (_tmp3_, "!(_current != null) || (0 <= _pos && _pos <= _current._size)");
	_tmp7_ = self->priv->_current;
	if (G_UNLIKELY (_tmp7_ == NULL)) {
		GeeUnrolledLinkedList* _tmp8_;
		GeeUnrolledLinkedListNode* _tmp9_;
		_tmp8_ = self->priv->_list;
		_tmp9_ = _tmp8_->priv->_head;
		result = _tmp9_ != NULL;
		return result;
	} else {
		GeeUnrolledLinkedListNode* _tmp10_;
		_tmp10_ = self->priv->_current;
		if (G_UNLIKELY (_tmp10_->_size == (self->priv->_pos + 1))) {
			GeeUnrolledLinkedListNode* _tmp11_;
			GeeUnrolledLinkedListNode* _tmp12_;
			_tmp11_ = self->priv->_current;
			_tmp12_ = _tmp11_->_next;
			result = _tmp12_ != NULL;
			return result;
		} else {
			result = TRUE;
			return result;
		}
	}
}

static gpointer
gee_unrolled_linked_list_iterator_real_get (GeeIterator* base)
{
	GeeUnrolledLinkedListIterator * self;
	GeeUnrolledLinkedList* _tmp0_;
	gboolean _tmp1_ = FALSE;
	GeeUnrolledLinkedListNode* _tmp2_;
	gboolean _tmp3_ = FALSE;
	GeeUnrolledLinkedListNode* _tmp5_;
	gconstpointer _tmp6_;
	gpointer _tmp7_;
	gpointer result;
	self = (GeeUnrolledLinkedListIterator*) base;
	_tmp0_ = self->priv->_list;
	_vala_assert (_tmp0_->priv->_stamp == self->priv->_stamp, "_list._stamp == _stamp");
	_tmp2_ = self->priv->_current;
	if (_tmp2_ != NULL) {
		_tmp1_ = !self->priv->_deleted;
	} else {
		_tmp1_ = FALSE;
	}
	_vala_assert (_tmp1_, "_current != null && !_deleted");
	if (0 <= self->priv->_pos) {
		GeeUnrolledLinkedListNode* _tmp4_;
		_tmp4_ = self->priv->_current;
		_tmp3_ = self->priv->_pos < _tmp4_->_size;
	} else {
		_tmp3_ = FALSE;
	}
	_vala_assert (_tmp3_, "0 <= _pos && _pos < _current._size");
	_tmp5_ = self->priv->_current;
	_tmp6_ = _tmp5_->_data[self->priv->_pos];
	_tmp7_ = ((_tmp6_ != NULL) && (self->priv->g_dup_func != NULL)) ? self->priv->g_dup_func ((gpointer) _tmp6_) : ((gpointer) _tmp6_);
	result = _tmp7_;
	return result;
}

static void
gee_unrolled_linked_list_iterator_real_remove (GeeIterator* base)
{
	GeeUnrolledLinkedListIterator * self;
	GeeUnrolledLinkedList* _tmp0_;
	gboolean _tmp1_ = FALSE;
	GeeUnrolledLinkedListNode* _tmp2_;
	gboolean _tmp3_ = FALSE;
	GeeUnrolledLinkedList* _tmp5_;
	GeeUnrolledLinkedListNode* _tmp6_;
	GeeUnrolledLinkedListNode* _tmp7_ = NULL;
	gint _tmp8_ = 0;
	gpointer _tmp9_;
	gpointer _tmp10_;
	gint _tmp11_;
	gint _tmp12_;
	self = (GeeUnrolledLinkedListIterator*) base;
	_tmp0_ = self->priv->_list;
	_vala_assert (_tmp0_->priv->_stamp == self->priv->_stamp, "_list._stamp == _stamp");
	_tmp2_ = self->priv->_current;
	if (_tmp2_ != NULL) {
		_tmp1_ = !self->priv->_deleted;
	} else {
		_tmp1_ = FALSE;
	}
	_vala_assert (_tmp1_, "_current != null && !_deleted");
	if (0 <= self->priv->_pos) {
		GeeUnrolledLinkedListNode* _tmp4_;
		_tmp4_ = self->priv->_current;
		_tmp3_ = self->priv->_pos <= _tmp4_->_size;
	} else {
		_tmp3_ = FALSE;
	}
	_vala_assert (_tmp3_, "0 <= _pos && _pos <= _current._size");
	_tmp5_ = self->priv->_list;
	_tmp6_ = self->priv->_current;
	_tmp9_ = gee_unrolled_linked_list_remove_from_node (_tmp5_, _tmp6_, self->priv->_pos, &_tmp7_, &_tmp8_);
	self->priv->_current = _tmp7_;
	self->priv->_pos = _tmp8_;
	_tmp10_ = _tmp9_;
	((_tmp10_ == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (_tmp10_ = (self->priv->g_destroy_func (_tmp10_), NULL));
	self->priv->_deleted = TRUE;
	_tmp11_ = self->priv->_index;
	self->priv->_index = _tmp11_ - 1;
	_tmp12_ = self->priv->_stamp;
	self->priv->_stamp = _tmp12_ + 1;
}

static gboolean
gee_unrolled_linked_list_iterator_real_previous (GeeBidirIterator* base)
{
	GeeUnrolledLinkedListIterator * self;
	GeeUnrolledLinkedList* _tmp0_;
	gboolean _tmp1_ = FALSE;
	GeeUnrolledLinkedListNode* _tmp2_;
	gboolean _tmp3_ = FALSE;
	GeeUnrolledLinkedListNode* _tmp4_;
	gboolean result;
	self = (GeeUnrolledLinkedListIterator*) base;
	_tmp0_ = self->priv->_list;
	_vala_assert (_tmp0_->priv->_stamp == self->priv->_stamp, "_list._stamp == _stamp");
	_tmp2_ = self->priv->_current;
	if (!(_tmp2_ == NULL)) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = self->priv->_pos == -1;
	}
	_vala_assert (_tmp1_, "!(_current == null) || _pos == -1");
	_tmp4_ = self->priv->_current;
	if (!(_tmp4_ != NULL)) {
		_tmp3_ = TRUE;
	} else {
		gboolean _tmp5_ = FALSE;
		if (0 <= self->priv->_pos) {
			GeeUnrolledLinkedListNode* _tmp6_;
			_tmp6_ = self->priv->_current;
			_tmp5_ = self->priv->_pos <= _tmp6_->_size;
		} else {
			_tmp5_ = FALSE;
		}
		_tmp3_ = _tmp5_;
	}
	_vala_assert (_tmp3_, "!(_current != null) || (0 <= _pos && _pos <= _current._size)");
	if (G_UNLIKELY (self->priv->_deleted)) {
		GeeUnrolledLinkedListNode* _tmp7_;
		self->priv->_deleted = FALSE;
		_tmp7_ = self->priv->_current;
		result = _tmp7_ != NULL;
		return result;
	} else {
		GeeUnrolledLinkedListNode* _tmp8_;
		_tmp8_ = self->priv->_current;
		if (G_UNLIKELY (_tmp8_ == NULL)) {
			result = FALSE;
			return result;
		} else {
			if (G_UNLIKELY (self->priv->_pos == 0)) {
				GeeUnrolledLinkedListNode* _tmp9_;
				GeeUnrolledLinkedListNode* _tmp10_;
				_tmp9_ = self->priv->_current;
				_tmp10_ = _tmp9_->_prev;
				if (G_LIKELY (_tmp10_ != NULL)) {
					GeeUnrolledLinkedListNode* _tmp11_;
					GeeUnrolledLinkedListNode* _tmp12_;
					GeeUnrolledLinkedListNode* _tmp13_;
					gint _tmp14_;
					_tmp11_ = self->priv->_current;
					_tmp12_ = _tmp11_->_prev;
					self->priv->_current = _tmp12_;
					_tmp13_ = self->priv->_current;
					self->priv->_pos = _tmp13_->_size - 1;
					_tmp14_ = self->priv->_index;
					self->priv->_index = _tmp14_ - 1;
					result = TRUE;
					return result;
				} else {
					result = FALSE;
					return result;
				}
			} else {
				gint _tmp15_;
				gint _tmp16_;
				_tmp15_ = self->priv->_pos;
				self->priv->_pos = _tmp15_ - 1;
				_tmp16_ = self->priv->_index;
				self->priv->_index = _tmp16_ - 1;
				result = TRUE;
				return result;
			}
		}
	}
}

static gboolean
gee_unrolled_linked_list_iterator_real_has_previous (GeeBidirIterator* base)
{
	GeeUnrolledLinkedListIterator * self;
	GeeUnrolledLinkedList* _tmp0_;
	gboolean _tmp1_ = FALSE;
	GeeUnrolledLinkedListNode* _tmp2_;
	gboolean _tmp3_ = FALSE;
	GeeUnrolledLinkedListNode* _tmp4_;
	gboolean result;
	self = (GeeUnrolledLinkedListIterator*) base;
	_tmp0_ = self->priv->_list;
	_vala_assert (_tmp0_->priv->_stamp == self->priv->_stamp, "_list._stamp == _stamp");
	_tmp2_ = self->priv->_current;
	if (!(_tmp2_ == NULL)) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = self->priv->_pos == -1;
	}
	_vala_assert (_tmp1_, "!(_current == null) || _pos == -1");
	_tmp4_ = self->priv->_current;
	if (!(_tmp4_ != NULL)) {
		_tmp3_ = TRUE;
	} else {
		gboolean _tmp5_ = FALSE;
		if (0 <= self->priv->_pos) {
			GeeUnrolledLinkedListNode* _tmp6_;
			_tmp6_ = self->priv->_current;
			_tmp5_ = self->priv->_pos <= _tmp6_->_size;
		} else {
			_tmp5_ = FALSE;
		}
		_tmp3_ = _tmp5_;
	}
	_vala_assert (_tmp3_, "!(_current != null) || (0 <= _pos && _pos <= _current._size)");
	if (G_UNLIKELY (self->priv->_deleted)) {
		GeeUnrolledLinkedListNode* _tmp7_;
		_tmp7_ = self->priv->_current;
		result = _tmp7_ != NULL;
		return result;
	} else {
		GeeUnrolledLinkedListNode* _tmp8_;
		_tmp8_ = self->priv->_current;
		if (G_UNLIKELY (_tmp8_ == NULL)) {
			result = FALSE;
			return result;
		} else {
			if (G_UNLIKELY (self->priv->_pos == 0)) {
				GeeUnrolledLinkedListNode* _tmp9_;
				GeeUnrolledLinkedListNode* _tmp10_;
				_tmp9_ = self->priv->_current;
				_tmp10_ = _tmp9_->_prev;
				result = _tmp10_ != NULL;
				return result;
			} else {
				result = TRUE;
				return result;
			}
		}
	}
}

static gboolean
gee_unrolled_linked_list_iterator_real_first (GeeBidirIterator* base)
{
	GeeUnrolledLinkedListIterator * self;
	GeeUnrolledLinkedList* _tmp0_;
	gboolean _tmp1_ = FALSE;
	GeeUnrolledLinkedListNode* _tmp2_;
	gboolean _tmp3_ = FALSE;
	GeeUnrolledLinkedListNode* _tmp4_;
	GeeUnrolledLinkedList* _tmp7_;
	GeeUnrolledLinkedListNode* _tmp8_;
	GeeUnrolledLinkedListNode* _tmp9_;
	GeeUnrolledLinkedListNode* _tmp10_;
	gboolean result;
	self = (GeeUnrolledLinkedListIterator*) base;
	_tmp0_ = self->priv->_list;
	_vala_assert (_tmp0_->priv->_stamp == self->priv->_stamp, "_list._stamp == _stamp");
	_tmp2_ = self->priv->_current;
	if (!(_tmp2_ == NULL)) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = self->priv->_pos == -1;
	}
	_vala_assert (_tmp1_, "!(_current == null) || _pos == -1");
	_tmp4_ = self->priv->_current;
	if (!(_tmp4_ != NULL)) {
		_tmp3_ = TRUE;
	} else {
		gboolean _tmp5_ = FALSE;
		if (0 <= self->priv->_pos) {
			GeeUnrolledLinkedListNode* _tmp6_;
			_tmp6_ = self->priv->_current;
			_tmp5_ = self->priv->_pos <= _tmp6_->_size;
		} else {
			_tmp5_ = FALSE;
		}
		_tmp3_ = _tmp5_;
	}
	_vala_assert (_tmp3_, "!(_current != null) || (0 <= _pos && _pos <= _current._size)");
	_tmp7_ = self->priv->_list;
	_tmp8_ = _tmp7_->priv->_head;
	self->priv->_current = _tmp8_;
	self->priv->_deleted = FALSE;
	_tmp9_ = self->priv->_current;
	if (_tmp9_ != NULL) {
		self->priv->_pos = 0;
	} else {
		self->priv->_pos = -1;
	}
	self->priv->_index = 0;
	_tmp10_ = self->priv->_current;
	result = _tmp10_ != NULL;
	return result;
}

static gboolean
gee_unrolled_linked_list_iterator_real_last (GeeBidirIterator* base)
{
	GeeUnrolledLinkedListIterator * self;
	GeeUnrolledLinkedList* _tmp0_;
	gboolean _tmp1_ = FALSE;
	GeeUnrolledLinkedListNode* _tmp2_;
	gboolean _tmp3_ = FALSE;
	GeeUnrolledLinkedListNode* _tmp4_;
	GeeUnrolledLinkedList* _tmp7_;
	GeeUnrolledLinkedListNode* _tmp8_;
	GeeUnrolledLinkedListNode* _tmp9_;
	GeeUnrolledLinkedList* _tmp11_;
	GeeUnrolledLinkedListNode* _tmp12_;
	gboolean result;
	self = (GeeUnrolledLinkedListIterator*) base;
	_tmp0_ = self->priv->_list;
	_vala_assert (_tmp0_->priv->_stamp == self->priv->_stamp, "_list._stamp == _stamp");
	_tmp2_ = self->priv->_current;
	if (!(_tmp2_ == NULL)) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = self->priv->_pos == -1;
	}
	_vala_assert (_tmp1_, "!(_current == null) || _pos == -1");
	_tmp4_ = self->priv->_current;
	if (!(_tmp4_ != NULL)) {
		_tmp3_ = TRUE;
	} else {
		gboolean _tmp5_ = FALSE;
		if (0 <= self->priv->_pos) {
			GeeUnrolledLinkedListNode* _tmp6_;
			_tmp6_ = self->priv->_current;
			_tmp5_ = self->priv->_pos <= _tmp6_->_size;
		} else {
			_tmp5_ = FALSE;
		}
		_tmp3_ = _tmp5_;
	}
	_vala_assert (_tmp3_, "!(_current != null) || (0 <= _pos && _pos <= _current._size)");
	_tmp7_ = self->priv->_list;
	_tmp8_ = _tmp7_->priv->_tail;
	self->priv->_current = _tmp8_;
	self->priv->_deleted = FALSE;
	_tmp9_ = self->priv->_current;
	if (_tmp9_ != NULL) {
		GeeUnrolledLinkedListNode* _tmp10_;
		_tmp10_ = self->priv->_current;
		self->priv->_pos = _tmp10_->_size - 1;
	} else {
		self->priv->_pos = -1;
	}
	_tmp11_ = self->priv->_list;
	self->priv->_index = _tmp11_->priv->_size - 1;
	_tmp12_ = self->priv->_current;
	result = _tmp12_ != NULL;
	return result;
}

static void
gee_unrolled_linked_list_iterator_real_set (GeeListIterator* base,
                                            gconstpointer item)
{
	GeeUnrolledLinkedListIterator * self;
	GeeUnrolledLinkedList* _tmp0_;
	gboolean _tmp1_ = FALSE;
	GeeUnrolledLinkedListNode* _tmp2_;
	gboolean _tmp3_ = FALSE;
	GeeUnrolledLinkedListNode* _tmp4_;
	GeeUnrolledLinkedListNode* _tmp7_;
	gpointer _tmp8_;
	GeeUnrolledLinkedList* _tmp9_;
	gint _tmp10_;
	gint _tmp11_;
	self = (GeeUnrolledLinkedListIterator*) base;
	_tmp0_ = self->priv->_list;
	_vala_assert (_tmp0_->priv->_stamp == self->priv->_stamp, "_list._stamp == _stamp");
	_tmp2_ = self->priv->_current;
	if (!(_tmp2_ == NULL)) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = self->priv->_pos == -1;
	}
	_vala_assert (_tmp1_, "!(_current == null) || _pos == -1");
	_tmp4_ = self->priv->_current;
	if (!(_tmp4_ != NULL)) {
		_tmp3_ = TRUE;
	} else {
		gboolean _tmp5_ = FALSE;
		if (0 <= self->priv->_pos) {
			GeeUnrolledLinkedListNode* _tmp6_;
			_tmp6_ = self->priv->_current;
			_tmp5_ = self->priv->_pos <= _tmp6_->_size;
		} else {
			_tmp5_ = FALSE;
		}
		_tmp3_ = _tmp5_;
	}
	_vala_assert (_tmp3_, "!(_current != null) || (0 <= _pos && _pos <= _current._size)");
	_tmp7_ = self->priv->_current;
	_tmp8_ = ((item != NULL) && (self->priv->g_dup_func != NULL)) ? self->priv->g_dup_func ((gpointer) item) : ((gpointer) item);
	((_tmp7_->_data[self->priv->_pos] == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (_tmp7_->_data[self->priv->_pos] = (self->priv->g_destroy_func (_tmp7_->_data[self->priv->_pos]), NULL));
	_tmp7_->_data[self->priv->_pos] = _tmp8_;
	_tmp9_ = self->priv->_list;
	_tmp10_ = _tmp9_->priv->_stamp;
	_tmp9_->priv->_stamp = _tmp10_ + 1;
	_tmp11_ = self->priv->_stamp;
	self->priv->_stamp = _tmp11_ + 1;
}

static void
gee_unrolled_linked_list_iterator_real_add (GeeListIterator* base,
                                            gconstpointer item)
{
	GeeUnrolledLinkedListIterator * self;
	GeeUnrolledLinkedList* _tmp0_;
	gboolean _tmp1_ = FALSE;
	GeeUnrolledLinkedListNode* _tmp2_;
	gboolean _tmp3_ = FALSE;
	GeeUnrolledLinkedListNode* _tmp4_;
	GeeUnrolledLinkedListNode* _tmp7_;
	gint _tmp23_;
	gint _tmp24_;
	self = (GeeUnrolledLinkedListIterator*) base;
	_tmp0_ = self->priv->_list;
	_vala_assert (_tmp0_->priv->_stamp == self->priv->_stamp, "_list._stamp == _stamp");
	_tmp2_ = self->priv->_current;
	if (!(_tmp2_ == NULL)) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = self->priv->_pos == -1;
	}
	_vala_assert (_tmp1_, "!(_current == null) || _pos == -1");
	_tmp4_ = self->priv->_current;
	if (!(_tmp4_ != NULL)) {
		_tmp3_ = TRUE;
	} else {
		gboolean _tmp5_ = FALSE;
		if (0 <= self->priv->_pos) {
			GeeUnrolledLinkedListNode* _tmp6_;
			_tmp6_ = self->priv->_current;
			_tmp5_ = self->priv->_pos <= _tmp6_->_size;
		} else {
			_tmp5_ = FALSE;
		}
		_tmp3_ = _tmp5_;
	}
	_vala_assert (_tmp3_, "!(_current != null) || (0 <= _pos && _pos <= _current._size)");
	_tmp7_ = self->priv->_current;
	if (G_LIKELY (_tmp7_ != NULL)) {
		GeeUnrolledLinkedList* _tmp8_;
		GeeUnrolledLinkedListNode* _tmp9_;
		GeeUnrolledLinkedListNode* _tmp10_ = NULL;
		gint _tmp11_ = 0;
		_tmp8_ = self->priv->_list;
		_tmp9_ = self->priv->_current;
		gee_unrolled_linked_list_add_to_node (_tmp8_, _tmp9_, item, self->priv->_pos + 1, &_tmp10_, &_tmp11_);
		self->priv->_current = _tmp10_;
		self->priv->_pos = _tmp11_;
	} else {
		GeeUnrolledLinkedList* _tmp12_;
		GeeUnrolledLinkedListNode* _tmp13_;
		GeeUnrolledLinkedList* _tmp21_;
		GeeUnrolledLinkedListNode* _tmp22_;
		_tmp12_ = self->priv->_list;
		_tmp13_ = _tmp12_->priv->_head;
		if (G_LIKELY (_tmp13_ != NULL)) {
			GeeUnrolledLinkedList* _tmp14_;
			GeeUnrolledLinkedListNode* _tmp15_;
			_tmp14_ = self->priv->_list;
			_tmp15_ = _tmp14_->priv->_head;
			self->priv->_current = _tmp15_;
		} else {
			GeeUnrolledLinkedList* _tmp16_;
			GeeUnrolledLinkedList* _tmp17_;
			GeeUnrolledLinkedListNode* _tmp18_;
			GeeUnrolledLinkedListNode* _tmp19_;
			GeeUnrolledLinkedListNode* _tmp20_;
			_tmp16_ = self->priv->_list;
			_tmp17_ = self->priv->_list;
			_tmp18_ = gee_unrolled_linked_list_node_new ();
			_gee_unrolled_linked_list_node_free0 (_tmp17_->priv->_head);
			_tmp17_->priv->_head = _tmp18_;
			_tmp19_ = _tmp17_->priv->_head;
			_tmp16_->priv->_tail = _tmp19_;
			_tmp20_ = _tmp16_->priv->_tail;
			self->priv->_current = _tmp20_;
		}
		_tmp21_ = self->priv->_list;
		_tmp22_ = self->priv->_current;
		gee_unrolled_linked_list_add_to_node (_tmp21_, _tmp22_, item, 0, NULL, NULL);
		self->priv->_pos = 0;
	}
	_tmp23_ = self->priv->_stamp;
	self->priv->_stamp = _tmp23_ + 1;
	_tmp24_ = self->priv->_index;
	self->priv->_index = _tmp24_ + 1;
	self->priv->_deleted = FALSE;
}

static gint
gee_unrolled_linked_list_iterator_real_index (GeeListIterator* base)
{
	GeeUnrolledLinkedListIterator * self;
	GeeUnrolledLinkedList* _tmp0_;
	GeeUnrolledLinkedListNode* _tmp1_;
	gboolean _tmp2_ = FALSE;
	gint result;
	self = (GeeUnrolledLinkedListIterator*) base;
	_tmp0_ = self->priv->_list;
	_vala_assert (_tmp0_->priv->_stamp == self->priv->_stamp, "_list._stamp == _stamp");
	_tmp1_ = self->priv->_current;
	_vala_assert (_tmp1_ != NULL, "_current != null");
	if (0 <= self->priv->_pos) {
		GeeUnrolledLinkedListNode* _tmp3_;
		_tmp3_ = self->priv->_current;
		_tmp2_ = self->priv->_pos <= _tmp3_->_size;
	} else {
		_tmp2_ = FALSE;
	}
	_vala_assert (_tmp2_, "0 <= _pos && _pos <= _current._size");
	result = self->priv->_index;
	return result;
}

static void
gee_unrolled_linked_list_iterator_real_insert (GeeBidirListIterator* base,
                                               gconstpointer item)
{
	GeeUnrolledLinkedListIterator * self;
	GeeUnrolledLinkedList* _tmp0_;
	gint _tmp32_;
	gint _tmp33_;
	self = (GeeUnrolledLinkedListIterator*) base;
	_tmp0_ = self->priv->_list;
	_vala_assert (_tmp0_->priv->_stamp == self->priv->_stamp, "_list._stamp == _stamp");
	if (G_UNLIKELY (self->priv->_deleted)) {
		GeeUnrolledLinkedListNode* _tmp1_;
		GeeUnrolledLinkedList* _tmp11_;
		GeeUnrolledLinkedListNode* _tmp12_;
		GeeUnrolledLinkedListNode* _tmp13_ = NULL;
		gint _tmp14_ = 0;
		_tmp1_ = self->priv->_current;
		if (G_UNLIKELY (_tmp1_ == NULL)) {
			GeeUnrolledLinkedList* _tmp2_;
			GeeUnrolledLinkedListNode* _tmp3_;
			_tmp2_ = self->priv->_list;
			_tmp3_ = _tmp2_->priv->_head;
			if (G_LIKELY (_tmp3_ != NULL)) {
				GeeUnrolledLinkedList* _tmp4_;
				GeeUnrolledLinkedListNode* _tmp5_;
				_tmp4_ = self->priv->_list;
				_tmp5_ = _tmp4_->priv->_head;
				self->priv->_current = _tmp5_;
				self->priv->_pos = -1;
			} else {
				GeeUnrolledLinkedList* _tmp6_;
				GeeUnrolledLinkedList* _tmp7_;
				GeeUnrolledLinkedListNode* _tmp8_;
				GeeUnrolledLinkedListNode* _tmp9_;
				GeeUnrolledLinkedListNode* _tmp10_;
				_tmp6_ = self->priv->_list;
				_tmp7_ = self->priv->_list;
				_tmp8_ = gee_unrolled_linked_list_node_new ();
				_gee_unrolled_linked_list_node_free0 (_tmp7_->priv->_head);
				_tmp7_->priv->_head = _tmp8_;
				_tmp9_ = _tmp7_->priv->_head;
				_tmp6_->priv->_tail = _tmp9_;
				_tmp10_ = _tmp6_->priv->_tail;
				self->priv->_current = _tmp10_;
				self->priv->_pos = -1;
			}
		}
		_tmp11_ = self->priv->_list;
		_tmp12_ = self->priv->_current;
		gee_unrolled_linked_list_add_to_node (_tmp11_, _tmp12_, item, self->priv->_pos + 1, &_tmp13_, &_tmp14_);
		self->priv->_current = _tmp13_;
		self->priv->_pos = _tmp14_;
		if (G_UNLIKELY (self->priv->_pos == 0)) {
			GeeUnrolledLinkedListNode* _tmp15_;
			GeeUnrolledLinkedListNode* _tmp16_;
			GeeUnrolledLinkedListNode* _tmp17_;
			GeeUnrolledLinkedListNode* _tmp18_;
			GeeUnrolledLinkedListNode* _tmp19_;
			GeeUnrolledLinkedListNode* _tmp20_;
			_tmp15_ = self->priv->_current;
			_tmp16_ = _tmp15_->_prev;
			_vala_assert (_tmp16_ != NULL, "_current._prev != null");
			_tmp17_ = self->priv->_current;
			_tmp18_ = _tmp17_->_prev;
			self->priv->_current = _tmp18_;
			_tmp19_ = self->priv->_current;
			_tmp20_ = _tmp19_->_prev;
			self->priv->_pos = _tmp20_->_size - 1;
		} else {
			gint _tmp21_;
			_tmp21_ = self->priv->_pos;
			self->priv->_pos = _tmp21_ - 1;
		}
	} else {
		GeeUnrolledLinkedList* _tmp22_;
		GeeUnrolledLinkedListNode* _tmp23_;
		GeeUnrolledLinkedListNode* _tmp24_ = NULL;
		gint _tmp25_ = 0;
		GeeUnrolledLinkedListNode* _tmp26_;
		_tmp22_ = self->priv->_list;
		_tmp23_ = self->priv->_current;
		gee_unrolled_linked_list_add_to_node (_tmp22_, _tmp23_, item, self->priv->_pos, &_tmp24_, &_tmp25_);
		self->priv->_current = _tmp24_;
		self->priv->_pos = _tmp25_;
		_tmp26_ = self->priv->_current;
		if (G_UNLIKELY ((self->priv->_pos + 1) == _tmp26_->_size)) {
			GeeUnrolledLinkedListNode* _tmp27_;
			GeeUnrolledLinkedListNode* _tmp28_;
			GeeUnrolledLinkedListNode* _tmp29_;
			GeeUnrolledLinkedListNode* _tmp30_;
			_tmp27_ = self->priv->_current;
			_tmp28_ = _tmp27_->_next;
			_vala_assert (_tmp28_ != NULL, "_current._next != null");
			_tmp29_ = self->priv->_current;
			_tmp30_ = _tmp29_->_next;
			self->priv->_current = _tmp30_;
			self->priv->_pos = 0;
		} else {
			gint _tmp31_;
			_tmp31_ = self->priv->_pos;
			self->priv->_pos = _tmp31_ + 1;
		}
	}
	_tmp32_ = self->priv->_stamp;
	self->priv->_stamp = _tmp32_ + 1;
	_tmp33_ = self->priv->_index;
	self->priv->_index = _tmp33_ + 1;
}

static gboolean
gee_unrolled_linked_list_iterator_real_get_valid (GeeIterator* base)
{
	gboolean result;
	GeeUnrolledLinkedListIterator* self;
	GeeUnrolledLinkedList* _tmp0_;
	gboolean _tmp1_ = FALSE;
	GeeUnrolledLinkedListNode* _tmp2_;
	gboolean _tmp3_ = FALSE;
	GeeUnrolledLinkedListNode* _tmp4_;
	gboolean _tmp7_ = FALSE;
	GeeUnrolledLinkedListNode* _tmp8_;
	self = (GeeUnrolledLinkedListIterator*) base;
	_tmp0_ = self->priv->_list;
	_vala_assert (_tmp0_->priv->_stamp == self->priv->_stamp, "_list._stamp == _stamp");
	_tmp2_ = self->priv->_current;
	if (!(_tmp2_ == NULL)) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = self->priv->_pos == -1;
	}
	_vala_assert (_tmp1_, "!(_current == null) || _pos == -1");
	_tmp4_ = self->priv->_current;
	if (!(_tmp4_ != NULL)) {
		_tmp3_ = TRUE;
	} else {
		gboolean _tmp5_ = FALSE;
		if (0 <= self->priv->_pos) {
			GeeUnrolledLinkedListNode* _tmp6_;
			_tmp6_ = self->priv->_current;
			_tmp5_ = self->priv->_pos <= _tmp6_->_size;
		} else {
			_tmp5_ = FALSE;
		}
		_tmp3_ = _tmp5_;
	}
	_vala_assert (_tmp3_, "!(_current != null) || (0 <= _pos && _pos <= _current._size)");
	_tmp8_ = self->priv->_current;
	if (_tmp8_ != NULL) {
		_tmp7_ = !self->priv->_deleted;
	} else {
		_tmp7_ = FALSE;
	}
	result = _tmp7_;
	return result;
}

static gboolean
gee_unrolled_linked_list_iterator_real_get_read_only (GeeIterator* base)
{
	gboolean result;
	GeeUnrolledLinkedListIterator* self;
	self = (GeeUnrolledLinkedListIterator*) base;
	result = FALSE;
	return result;
}

static void
gee_unrolled_linked_list_iterator_class_init (GeeUnrolledLinkedListIteratorClass * klass,
                                              gpointer klass_data)
{
	gee_unrolled_linked_list_iterator_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GeeUnrolledLinkedListIterator_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_gee_unrolled_linked_list_iterator_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gee_unrolled_linked_list_iterator_set_property;
	G_OBJECT_CLASS (klass)->finalize = gee_unrolled_linked_list_iterator_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_UNROLLED_LINKED_LIST_ITERATOR_G_TYPE, g_param_spec_gtype ("g-type", "type", "type", G_TYPE_NONE, G_PARAM_STATIC_STRINGS | G_PARAM_READWRITE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_UNROLLED_LINKED_LIST_ITERATOR_G_DUP_FUNC, g_param_spec_pointer ("g-dup-func", "dup func", "dup func", G_PARAM_STATIC_STRINGS | G_PARAM_READWRITE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_UNROLLED_LINKED_LIST_ITERATOR_G_DESTROY_FUNC, g_param_spec_pointer ("g-destroy-func", "destroy func", "destroy func", G_PARAM_STATIC_STRINGS | G_PARAM_READWRITE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_UNROLLED_LINKED_LIST_ITERATOR_VALID_PROPERTY, gee_unrolled_linked_list_iterator_properties[GEE_UNROLLED_LINKED_LIST_ITERATOR_VALID_PROPERTY] = g_param_spec_boolean ("valid", "valid", "valid", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_UNROLLED_LINKED_LIST_ITERATOR_READ_ONLY_PROPERTY, gee_unrolled_linked_list_iterator_properties[GEE_UNROLLED_LINKED_LIST_ITERATOR_READ_ONLY_PROPERTY] = g_param_spec_boolean ("read-only", "read-only", "read-only", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static GType
gee_unrolled_linked_list_iterator_gee_traversable_get_g_type (GeeUnrolledLinkedListIterator* self)
{
	return self->priv->g_type;
}

static GBoxedCopyFunc
gee_unrolled_linked_list_iterator_gee_traversable_get_g_dup_func (GeeUnrolledLinkedListIterator* self)
{
	return self->priv->g_dup_func;
}

static GDestroyNotify
gee_unrolled_linked_list_iterator_gee_traversable_get_g_destroy_func (GeeUnrolledLinkedListIterator* self)
{
	return self->priv->g_destroy_func;
}

static void
gee_unrolled_linked_list_iterator_gee_traversable_interface_init (GeeTraversableIface * iface,
                                                                  gpointer iface_data)
{
	gee_unrolled_linked_list_iterator_gee_traversable_parent_iface = g_type_interface_peek_parent (iface);
	iface->foreach = (gboolean (*) (GeeTraversable*, GeeForallFunc, gpointer)) gee_unrolled_linked_list_iterator_real_foreach;
	iface->tee = (GeeIterator** (*) (GeeTraversable*, guint, gint*)) gee_unrolled_linked_list_iterator_real_tee;
	iface->get_g_type = (GType (*) (GeeTraversable *)) gee_unrolled_linked_list_iterator_gee_traversable_get_g_type;
	iface->get_g_dup_func = (GBoxedCopyFunc (*) (GeeTraversable *)) gee_unrolled_linked_list_iterator_gee_traversable_get_g_dup_func;
	iface->get_g_destroy_func = (GDestroyNotify (*) (GeeTraversable *)) gee_unrolled_linked_list_iterator_gee_traversable_get_g_destroy_func;
}

static void
gee_unrolled_linked_list_iterator_gee_iterator_interface_init (GeeIteratorIface * iface,
                                                               gpointer iface_data)
{
	gee_unrolled_linked_list_iterator_gee_iterator_parent_iface = g_type_interface_peek_parent (iface);
	iface->next = (gboolean (*) (GeeIterator*)) gee_unrolled_linked_list_iterator_real_next;
	iface->has_next = (gboolean (*) (GeeIterator*)) gee_unrolled_linked_list_iterator_real_has_next;
	iface->get = (gpointer (*) (GeeIterator*)) gee_unrolled_linked_list_iterator_real_get;
	iface->remove = (void (*) (GeeIterator*)) gee_unrolled_linked_list_iterator_real_remove;
	iface->get_valid = gee_unrolled_linked_list_iterator_real_get_valid;
	iface->get_read_only = gee_unrolled_linked_list_iterator_real_get_read_only;
}

static void
gee_unrolled_linked_list_iterator_gee_list_iterator_interface_init (GeeListIteratorIface * iface,
                                                                    gpointer iface_data)
{
	gee_unrolled_linked_list_iterator_gee_list_iterator_parent_iface = g_type_interface_peek_parent (iface);
	iface->set = (void (*) (GeeListIterator*, gconstpointer)) gee_unrolled_linked_list_iterator_real_set;
	iface->add = (void (*) (GeeListIterator*, gconstpointer)) gee_unrolled_linked_list_iterator_real_add;
	iface->index = (gint (*) (GeeListIterator*)) gee_unrolled_linked_list_iterator_real_index;
}

static GType
gee_unrolled_linked_list_iterator_gee_bidir_iterator_get_g_type (GeeUnrolledLinkedListIterator* self)
{
	return self->priv->g_type;
}

static GBoxedCopyFunc
gee_unrolled_linked_list_iterator_gee_bidir_iterator_get_g_dup_func (GeeUnrolledLinkedListIterator* self)
{
	return self->priv->g_dup_func;
}

static GDestroyNotify
gee_unrolled_linked_list_iterator_gee_bidir_iterator_get_g_destroy_func (GeeUnrolledLinkedListIterator* self)
{
	return self->priv->g_destroy_func;
}

static void
gee_unrolled_linked_list_iterator_gee_bidir_iterator_interface_init (GeeBidirIteratorIface * iface,
                                                                     gpointer iface_data)
{
	gee_unrolled_linked_list_iterator_gee_bidir_iterator_parent_iface = g_type_interface_peek_parent (iface);
	iface->previous = (gboolean (*) (GeeBidirIterator*)) gee_unrolled_linked_list_iterator_real_previous;
	iface->has_previous = (gboolean (*) (GeeBidirIterator*)) gee_unrolled_linked_list_iterator_real_has_previous;
	iface->first = (gboolean (*) (GeeBidirIterator*)) gee_unrolled_linked_list_iterator_real_first;
	iface->last = (gboolean (*) (GeeBidirIterator*)) gee_unrolled_linked_list_iterator_real_last;
	iface->get_g_type = (GType (*) (GeeBidirIterator *)) gee_unrolled_linked_list_iterator_gee_bidir_iterator_get_g_type;
	iface->get_g_dup_func = (GBoxedCopyFunc (*) (GeeBidirIterator *)) gee_unrolled_linked_list_iterator_gee_bidir_iterator_get_g_dup_func;
	iface->get_g_destroy_func = (GDestroyNotify (*) (GeeBidirIterator *)) gee_unrolled_linked_list_iterator_gee_bidir_iterator_get_g_destroy_func;
}

static GType
gee_unrolled_linked_list_iterator_gee_bidir_list_iterator_get_g_type (GeeUnrolledLinkedListIterator* self)
{
	return self->priv->g_type;
}

static GBoxedCopyFunc
gee_unrolled_linked_list_iterator_gee_bidir_list_iterator_get_g_dup_func (GeeUnrolledLinkedListIterator* self)
{
	return self->priv->g_dup_func;
}

static GDestroyNotify
gee_unrolled_linked_list_iterator_gee_bidir_list_iterator_get_g_destroy_func (GeeUnrolledLinkedListIterator* self)
{
	return self->priv->g_destroy_func;
}

static void
gee_unrolled_linked_list_iterator_gee_bidir_list_iterator_interface_init (GeeBidirListIteratorIface * iface,
                                                                          gpointer iface_data)
{
	gee_unrolled_linked_list_iterator_gee_bidir_list_iterator_parent_iface = g_type_interface_peek_parent (iface);
	iface->insert = (void (*) (GeeBidirListIterator*, gconstpointer)) gee_unrolled_linked_list_iterator_real_insert;
	iface->get_g_type = (GType (*) (GeeBidirListIterator *)) gee_unrolled_linked_list_iterator_gee_bidir_list_iterator_get_g_type;
	iface->get_g_dup_func = (GBoxedCopyFunc (*) (GeeBidirListIterator *)) gee_unrolled_linked_list_iterator_gee_bidir_list_iterator_get_g_dup_func;
	iface->get_g_destroy_func = (GDestroyNotify (*) (GeeBidirListIterator *)) gee_unrolled_linked_list_iterator_gee_bidir_list_iterator_get_g_destroy_func;
}

static void
gee_unrolled_linked_list_iterator_instance_init (GeeUnrolledLinkedListIterator * self,
                                                 gpointer klass)
{
	self->priv = gee_unrolled_linked_list_iterator_get_instance_private (self);
	self->priv->_current = NULL;
	self->priv->_pos = -1;
	self->priv->_deleted = FALSE;
	self->priv->_index = -1;
}

static void
gee_unrolled_linked_list_iterator_finalize (GObject * obj)
{
	GeeUnrolledLinkedListIterator * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GEE_UNROLLED_LINKED_LIST_TYPE_ITERATOR, GeeUnrolledLinkedListIterator);
	_g_object_unref0 (self->priv->_list);
	G_OBJECT_CLASS (gee_unrolled_linked_list_iterator_parent_class)->finalize (obj);
}

static GType
gee_unrolled_linked_list_iterator_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GeeUnrolledLinkedListIteratorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gee_unrolled_linked_list_iterator_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GeeUnrolledLinkedListIterator), 0, (GInstanceInitFunc) gee_unrolled_linked_list_iterator_instance_init, NULL };
	static const GInterfaceInfo gee_traversable_info = { (GInterfaceInitFunc) gee_unrolled_linked_list_iterator_gee_traversable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	static const GInterfaceInfo gee_iterator_info = { (GInterfaceInitFunc) gee_unrolled_linked_list_iterator_gee_iterator_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	static const GInterfaceInfo gee_list_iterator_info = { (GInterfaceInitFunc) gee_unrolled_linked_list_iterator_gee_list_iterator_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	static const GInterfaceInfo gee_bidir_iterator_info = { (GInterfaceInitFunc) gee_unrolled_linked_list_iterator_gee_bidir_iterator_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	static const GInterfaceInfo gee_bidir_list_iterator_info = { (GInterfaceInitFunc) gee_unrolled_linked_list_iterator_gee_bidir_list_iterator_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType gee_unrolled_linked_list_iterator_type_id;
	gee_unrolled_linked_list_iterator_type_id = g_type_register_static (G_TYPE_OBJECT, "GeeUnrolledLinkedListIterator", &g_define_type_info, 0);
	g_type_add_interface_static (gee_unrolled_linked_list_iterator_type_id, GEE_TYPE_TRAVERSABLE, &gee_traversable_info);
	g_type_add_interface_static (gee_unrolled_linked_list_iterator_type_id, GEE_TYPE_ITERATOR, &gee_iterator_info);
	g_type_add_interface_static (gee_unrolled_linked_list_iterator_type_id, GEE_TYPE_LIST_ITERATOR, &gee_list_iterator_info);
	g_type_add_interface_static (gee_unrolled_linked_list_iterator_type_id, GEE_TYPE_BIDIR_ITERATOR, &gee_bidir_iterator_info);
	g_type_add_interface_static (gee_unrolled_linked_list_iterator_type_id, GEE_TYPE_BIDIR_LIST_ITERATOR, &gee_bidir_list_iterator_info);
	GeeUnrolledLinkedListIterator_private_offset = g_type_add_instance_private (gee_unrolled_linked_list_iterator_type_id, sizeof (GeeUnrolledLinkedListIteratorPrivate));
	return gee_unrolled_linked_list_iterator_type_id;
}

static GType
gee_unrolled_linked_list_iterator_get_type (void)
{
	static volatile gsize gee_unrolled_linked_list_iterator_type_id__once = 0;
	if (g_once_init_enter (&gee_unrolled_linked_list_iterator_type_id__once)) {
		GType gee_unrolled_linked_list_iterator_type_id;
		gee_unrolled_linked_list_iterator_type_id = gee_unrolled_linked_list_iterator_get_type_once ();
		g_once_init_leave (&gee_unrolled_linked_list_iterator_type_id__once, gee_unrolled_linked_list_iterator_type_id);
	}
	return gee_unrolled_linked_list_iterator_type_id__once;
}

static void
_vala_gee_unrolled_linked_list_iterator_get_property (GObject * object,
                                                      guint property_id,
                                                      GValue * value,
                                                      GParamSpec * pspec)
{
	GeeUnrolledLinkedListIterator * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEE_UNROLLED_LINKED_LIST_TYPE_ITERATOR, GeeUnrolledLinkedListIterator);
	switch (property_id) {
		case GEE_UNROLLED_LINKED_LIST_ITERATOR_VALID_PROPERTY:
		g_value_set_boolean (value, gee_iterator_get_valid ((GeeIterator*) self));
		break;
		case GEE_UNROLLED_LINKED_LIST_ITERATOR_READ_ONLY_PROPERTY:
		g_value_set_boolean (value, gee_iterator_get_read_only ((GeeIterator*) self));
		break;
		case GEE_UNROLLED_LINKED_LIST_ITERATOR_G_TYPE:
		g_value_set_gtype (value, self->priv->g_type);
		break;
		case GEE_UNROLLED_LINKED_LIST_ITERATOR_G_DUP_FUNC:
		g_value_set_pointer (value, self->priv->g_dup_func);
		break;
		case GEE_UNROLLED_LINKED_LIST_ITERATOR_G_DESTROY_FUNC:
		g_value_set_pointer (value, self->priv->g_destroy_func);
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_gee_unrolled_linked_list_iterator_set_property (GObject * object,
                                                      guint property_id,
                                                      const GValue * value,
                                                      GParamSpec * pspec)
{
	GeeUnrolledLinkedListIterator * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEE_UNROLLED_LINKED_LIST_TYPE_ITERATOR, GeeUnrolledLinkedListIterator);
	switch (property_id) {
		case GEE_UNROLLED_LINKED_LIST_ITERATOR_G_TYPE:
		self->priv->g_type = g_value_get_gtype (value);
		break;
		case GEE_UNROLLED_LINKED_LIST_ITERATOR_G_DUP_FUNC:
		self->priv->g_dup_func = g_value_get_pointer (value);
		break;
		case GEE_UNROLLED_LINKED_LIST_ITERATOR_G_DESTROY_FUNC:
		self->priv->g_destroy_func = g_value_get_pointer (value);
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static GeeUnrolledLinkedListNode*
gee_unrolled_linked_list_node_new (void)
{
	GeeUnrolledLinkedListNode* self;
	self = g_slice_new0 (GeeUnrolledLinkedListNode);
	gee_unrolled_linked_list_node_instance_init (self);
	return self;
}

static void
gee_unrolled_linked_list_node_instance_init (GeeUnrolledLinkedListNode * self)
{
	self->_prev = NULL;
	self->_next = NULL;
	self->_size = 0;
}

static void
gee_unrolled_linked_list_node_free (GeeUnrolledLinkedListNode * self)
{
	_gee_unrolled_linked_list_node_free0 (self->_next);
	g_slice_free (GeeUnrolledLinkedListNode, self);
}

static void
gee_unrolled_linked_list_class_init (GeeUnrolledLinkedListClass * klass,
                                     gpointer klass_data)
{
	gee_unrolled_linked_list_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GeeUnrolledLinkedList_private_offset);
	((GeeAbstractCollectionClass *) klass)->foreach = (gboolean (*) (GeeAbstractCollection*, GeeForallFunc, gpointer)) gee_unrolled_linked_list_real_foreach;
	((GeeAbstractCollectionClass *) klass)->iterator = (GeeIterator* (*) (GeeAbstractCollection*)) gee_unrolled_linked_list_real_iterator;
	((GeeAbstractCollectionClass *) klass)->contains = (gboolean (*) (GeeAbstractCollection*, gconstpointer)) gee_unrolled_linked_list_real_contains;
	((GeeAbstractCollectionClass *) klass)->add = (gboolean (*) (GeeAbstractCollection*, gconstpointer)) gee_unrolled_linked_list_real_add;
	((GeeAbstractCollectionClass *) klass)->remove = (gboolean (*) (GeeAbstractCollection*, gconstpointer)) gee_unrolled_linked_list_real_remove;
	((GeeAbstractCollectionClass *) klass)->clear = (void (*) (GeeAbstractCollection*)) gee_unrolled_linked_list_real_clear;
	((GeeAbstractListClass *) klass)->list_iterator = (GeeListIterator* (*) (GeeAbstractList*)) gee_unrolled_linked_list_real_list_iterator;
	((GeeAbstractListClass *) klass)->get = (gpointer (*) (GeeAbstractList*, gint)) gee_unrolled_linked_list_real_get;
	((GeeAbstractListClass *) klass)->set = (void (*) (GeeAbstractList*, gint, gconstpointer)) gee_unrolled_linked_list_real_set;
	((GeeAbstractListClass *) klass)->index_of = (gint (*) (GeeAbstractList*, gconstpointer)) gee_unrolled_linked_list_real_index_of;
	((GeeAbstractListClass *) klass)->insert = (void (*) (GeeAbstractList*, gint, gconstpointer)) gee_unrolled_linked_list_real_insert;
	((GeeAbstractListClass *) klass)->remove_at = (gpointer (*) (GeeAbstractList*, gint)) gee_unrolled_linked_list_real_remove_at;
	((GeeAbstractListClass *) klass)->slice = (GeeList* (*) (GeeAbstractList*, gint, gint)) gee_unrolled_linked_list_real_slice;
	((GeeAbstractBidirListClass *) klass)->bidir_list_iterator = (GeeBidirListIterator* (*) (GeeAbstractBidirList*)) gee_unrolled_linked_list_real_bidir_list_iterator;
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->get_size = gee_unrolled_linked_list_real_get_size;
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->get_read_only = gee_unrolled_linked_list_real_get_read_only;
	G_OBJECT_CLASS (klass)->get_property = _vala_gee_unrolled_linked_list_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gee_unrolled_linked_list_set_property;
	G_OBJECT_CLASS (klass)->finalize = gee_unrolled_linked_list_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_UNROLLED_LINKED_LIST_G_TYPE, g_param_spec_gtype ("g-type", "type", "type", G_TYPE_NONE, G_PARAM_STATIC_STRINGS | G_PARAM_READWRITE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_UNROLLED_LINKED_LIST_G_DUP_FUNC, g_param_spec_pointer ("g-dup-func", "dup func", "dup func", G_PARAM_STATIC_STRINGS | G_PARAM_READWRITE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_UNROLLED_LINKED_LIST_G_DESTROY_FUNC, g_param_spec_pointer ("g-destroy-func", "destroy func", "destroy func", G_PARAM_STATIC_STRINGS | G_PARAM_READWRITE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_UNROLLED_LINKED_LIST_SIZE_PROPERTY, gee_unrolled_linked_list_properties[GEE_UNROLLED_LINKED_LIST_SIZE_PROPERTY] = g_param_spec_int ("size", "size", "size", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_UNROLLED_LINKED_LIST_READ_ONLY_PROPERTY, gee_unrolled_linked_list_properties[GEE_UNROLLED_LINKED_LIST_READ_ONLY_PROPERTY] = g_param_spec_boolean ("read-only", "read-only", "read-only", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_UNROLLED_LINKED_LIST_CAPACITY_PROPERTY, gee_unrolled_linked_list_properties[GEE_UNROLLED_LINKED_LIST_CAPACITY_PROPERTY] = g_param_spec_int ("capacity", "capacity", "capacity", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_UNROLLED_LINKED_LIST_REMAINING_CAPACITY_PROPERTY, gee_unrolled_linked_list_properties[GEE_UNROLLED_LINKED_LIST_REMAINING_CAPACITY_PROPERTY] = g_param_spec_int ("remaining-capacity", "remaining-capacity", "remaining-capacity", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_UNROLLED_LINKED_LIST_IS_FULL_PROPERTY, gee_unrolled_linked_list_properties[GEE_UNROLLED_LINKED_LIST_IS_FULL_PROPERTY] = g_param_spec_boolean ("is-full", "is-full", "is-full", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static GType
gee_unrolled_linked_list_gee_queue_get_g_type (GeeUnrolledLinkedList* self)
{
	return self->priv->g_type;
}

static GBoxedCopyFunc
gee_unrolled_linked_list_gee_queue_get_g_dup_func (GeeUnrolledLinkedList* self)
{
	return self->priv->g_dup_func;
}

static GDestroyNotify
gee_unrolled_linked_list_gee_queue_get_g_destroy_func (GeeUnrolledLinkedList* self)
{
	return self->priv->g_destroy_func;
}

static void
gee_unrolled_linked_list_gee_queue_interface_init (GeeQueueIface * iface,
                                                   gpointer iface_data)
{
	gee_unrolled_linked_list_gee_queue_parent_iface = g_type_interface_peek_parent (iface);
	iface->offer = (gboolean (*) (GeeQueue*, gconstpointer)) gee_unrolled_linked_list_real_offer;
	iface->peek = (gpointer (*) (GeeQueue*)) gee_unrolled_linked_list_real_peek;
	iface->poll = (gpointer (*) (GeeQueue*)) gee_unrolled_linked_list_real_poll;
	iface->drain = (gint (*) (GeeQueue*, GeeCollection*, gint)) gee_unrolled_linked_list_real_drain;
	iface->get_g_type = (GType (*) (GeeQueue *)) gee_unrolled_linked_list_gee_queue_get_g_type;
	iface->get_g_dup_func = (GBoxedCopyFunc (*) (GeeQueue *)) gee_unrolled_linked_list_gee_queue_get_g_dup_func;
	iface->get_g_destroy_func = (GDestroyNotify (*) (GeeQueue *)) gee_unrolled_linked_list_gee_queue_get_g_destroy_func;
	iface->get_capacity = gee_unrolled_linked_list_real_get_capacity;
	iface->get_remaining_capacity = gee_unrolled_linked_list_real_get_remaining_capacity;
	iface->get_is_full = gee_unrolled_linked_list_real_get_is_full;
}

static GType
gee_unrolled_linked_list_gee_deque_get_g_type (GeeUnrolledLinkedList* self)
{
	return self->priv->g_type;
}

static GBoxedCopyFunc
gee_unrolled_linked_list_gee_deque_get_g_dup_func (GeeUnrolledLinkedList* self)
{
	return self->priv->g_dup_func;
}

static GDestroyNotify
gee_unrolled_linked_list_gee_deque_get_g_destroy_func (GeeUnrolledLinkedList* self)
{
	return self->priv->g_destroy_func;
}

static void
gee_unrolled_linked_list_gee_deque_interface_init (GeeDequeIface * iface,
                                                   gpointer iface_data)
{
	gee_unrolled_linked_list_gee_deque_parent_iface = g_type_interface_peek_parent (iface);
	iface->offer_head = (gboolean (*) (GeeDeque*, gconstpointer)) gee_unrolled_linked_list_real_offer_head;
	iface->peek_head = (gpointer (*) (GeeDeque*)) gee_unrolled_linked_list_real_peek_head;
	iface->poll_head = (gpointer (*) (GeeDeque*)) gee_unrolled_linked_list_real_poll_head;
	iface->drain_head = (gint (*) (GeeDeque*, GeeCollection*, gint)) gee_unrolled_linked_list_real_drain_head;
	iface->offer_tail = (gboolean (*) (GeeDeque*, gconstpointer)) gee_unrolled_linked_list_real_offer_tail;
	iface->peek_tail = (gpointer (*) (GeeDeque*)) gee_unrolled_linked_list_real_peek_tail;
	iface->poll_tail = (gpointer (*) (GeeDeque*)) gee_unrolled_linked_list_real_poll_tail;
	iface->drain_tail = (gint (*) (GeeDeque*, GeeCollection*, gint)) gee_unrolled_linked_list_real_drain_tail;
	iface->get_g_type = (GType (*) (GeeDeque *)) gee_unrolled_linked_list_gee_deque_get_g_type;
	iface->get_g_dup_func = (GBoxedCopyFunc (*) (GeeDeque *)) gee_unrolled_linked_list_gee_deque_get_g_dup_func;
	iface->get_g_destroy_func = (GDestroyNotify (*) (GeeDeque *)) gee_unrolled_linked_list_gee_deque_get_g_destroy_func;
}

static void
gee_unrolled_linked_list_instance_init (GeeUnrolledLinkedList * self,
                                        gpointer klass)
{
	self->priv = gee_unrolled_linked_list_get_instance_private (self);
	self->priv->_size = 0;
	self->priv->_stamp = 0;
	self->priv->_head = NULL;
	self->priv->_tail = NULL;
}

static void
gee_unrolled_linked_list_finalize (GObject * obj)
{
	GeeUnrolledLinkedList * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GEE_TYPE_UNROLLED_LINKED_LIST, GeeUnrolledLinkedList);
	gee_abstract_collection_clear ((GeeAbstractCollection*) self);
	_gee_unrolled_linked_list_node_free0 (self->priv->_head);
	_gee_functions_equal_data_func_closure_unref0 (self->priv->_equal_func);
	G_OBJECT_CLASS (gee_unrolled_linked_list_parent_class)->finalize (obj);
}

/**
 * Unrolled doubly-linked list implementation of the {@link List} interface.
 *
 * The unrolled doubly-linked list combines the advantages and disadvantages
 * of the {@link ArrayList} and {@link LinkedList} and is usually suitable when
 * modifications and read operations are balanced.
 *
 * Please note that in our benchmarks the speed of most operations (insertion,
 * deletion, sequential read) was on par or better then {@link ArrayList} and
 * {@link LinkedList} except the prepending operation.
 *
 * @see ArrayList
 * @see LinkedList
 */
static GType
gee_unrolled_linked_list_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GeeUnrolledLinkedListClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gee_unrolled_linked_list_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GeeUnrolledLinkedList), 0, (GInstanceInitFunc) gee_unrolled_linked_list_instance_init, NULL };
	static const GInterfaceInfo gee_queue_info = { (GInterfaceInitFunc) gee_unrolled_linked_list_gee_queue_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	static const GInterfaceInfo gee_deque_info = { (GInterfaceInitFunc) gee_unrolled_linked_list_gee_deque_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType gee_unrolled_linked_list_type_id;
	gee_unrolled_linked_list_type_id = g_type_register_static (GEE_TYPE_ABSTRACT_BIDIR_LIST, "GeeUnrolledLinkedList", &g_define_type_info, 0);
	g_type_add_interface_static (gee_unrolled_linked_list_type_id, GEE_TYPE_QUEUE, &gee_queue_info);
	g_type_add_interface_static (gee_unrolled_linked_list_type_id, GEE_TYPE_DEQUE, &gee_deque_info);
	GeeUnrolledLinkedList_private_offset = g_type_add_instance_private (gee_unrolled_linked_list_type_id, sizeof (GeeUnrolledLinkedListPrivate));
	return gee_unrolled_linked_list_type_id;
}

GType
gee_unrolled_linked_list_get_type (void)
{
	static volatile gsize gee_unrolled_linked_list_type_id__once = 0;
	if (g_once_init_enter (&gee_unrolled_linked_list_type_id__once)) {
		GType gee_unrolled_linked_list_type_id;
		gee_unrolled_linked_list_type_id = gee_unrolled_linked_list_get_type_once ();
		g_once_init_leave (&gee_unrolled_linked_list_type_id__once, gee_unrolled_linked_list_type_id);
	}
	return gee_unrolled_linked_list_type_id__once;
}

static void
_vala_gee_unrolled_linked_list_get_property (GObject * object,
                                             guint property_id,
                                             GValue * value,
                                             GParamSpec * pspec)
{
	GeeUnrolledLinkedList * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEE_TYPE_UNROLLED_LINKED_LIST, GeeUnrolledLinkedList);
	switch (property_id) {
		case GEE_UNROLLED_LINKED_LIST_SIZE_PROPERTY:
		g_value_set_int (value, gee_abstract_collection_get_size ((GeeAbstractCollection*) self));
		break;
		case GEE_UNROLLED_LINKED_LIST_READ_ONLY_PROPERTY:
		g_value_set_boolean (value, gee_abstract_collection_get_read_only ((GeeAbstractCollection*) self));
		break;
		case GEE_UNROLLED_LINKED_LIST_CAPACITY_PROPERTY:
		g_value_set_int (value, gee_queue_get_capacity ((GeeQueue*) self));
		break;
		case GEE_UNROLLED_LINKED_LIST_REMAINING_CAPACITY_PROPERTY:
		g_value_set_int (value, gee_queue_get_remaining_capacity ((GeeQueue*) self));
		break;
		case GEE_UNROLLED_LINKED_LIST_IS_FULL_PROPERTY:
		g_value_set_boolean (value, gee_queue_get_is_full ((GeeQueue*) self));
		break;
		case GEE_UNROLLED_LINKED_LIST_G_TYPE:
		g_value_set_gtype (value, self->priv->g_type);
		break;
		case GEE_UNROLLED_LINKED_LIST_G_DUP_FUNC:
		g_value_set_pointer (value, self->priv->g_dup_func);
		break;
		case GEE_UNROLLED_LINKED_LIST_G_DESTROY_FUNC:
		g_value_set_pointer (value, self->priv->g_destroy_func);
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_gee_unrolled_linked_list_set_property (GObject * object,
                                             guint property_id,
                                             const GValue * value,
                                             GParamSpec * pspec)
{
	GeeUnrolledLinkedList * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEE_TYPE_UNROLLED_LINKED_LIST, GeeUnrolledLinkedList);
	switch (property_id) {
		case GEE_UNROLLED_LINKED_LIST_G_TYPE:
		self->priv->g_type = g_value_get_gtype (value);
		break;
		case GEE_UNROLLED_LINKED_LIST_G_DUP_FUNC:
		self->priv->g_dup_func = g_value_get_pointer (value);
		break;
		case GEE_UNROLLED_LINKED_LIST_G_DESTROY_FUNC:
		self->priv->g_destroy_func = g_value_get_pointer (value);
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

