'\" t
.\" Copyright (c) 1999, Oracle and/or its affiliates.
.\"
.\" Permission is hereby granted, free of charge, to any person obtaining a
.\" copy of this software and associated documentation files (the "Software"),
.\" to deal in the Software without restriction, including without limitation
.\" the rights to use, copy, modify, merge, publish, distribute, sublicense,
.\" and/or sell copies of the Software, and to permit persons to whom the
.\" Software is furnished to do so, subject to the following conditions:
.\"
.\" The above copyright notice and this permission notice (including the next
.\" paragraph) shall be included in all copies or substantial portions of the
.\" Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
.\" IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
.\" FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
.\" THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
.\" LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
.\" FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
.\" DEALINGS IN THE SOFTWARE.
.\"
.TH XkbDeviceBell __libmansuffix__ __xorgversion__ "XKB FUNCTIONS"
.SH NAME
XkbDeviceBell \- Rings the bell on an X input extension device or the default keyboard
.SH SYNOPSIS
.HP
.B Bool XkbDeviceBell
.BI "(\^Display *" "display" "\^,"
.BI "Window " "window" "\^,"
.BI "unsigned int " "device_spec" "\^,"
.BI "unsigned int " "bell_class" "\^,"
.BI "unsigned int " "bell_id" "\^,"
.BI "int " "percent" "\^,"
.BI "Atom " "name" "\^);"
.if n .ti +5n
.if t .ti +.5i
.SH ARGUMENTS
.TP
.I display
connection to the X server
.TP
.I window
window for which the bell is generated, or None
.TP
.I device_spec
device ID, or XkbUseCoreKbd
.TP
.I bell_class
X input extension bell class of the bell to be rung
.TP
.I bell_id
X input extension bell ID of the bell to be rung
.TP
.I percent
bell volume, from -100 to 100 inclusive
.TP
.I name
a name for the bell, or NULL
.SH DESCRIPTION
.LP
The core X protocol allows only applications to explicitly sound the system bell with a 
given duration, pitch, and volume. Xkb extends this capability by allowing clients to 
attach symbolic names to bells, disable audible bells, and receive an event whenever the 
keyboard bell is rung. For the purposes of this document, the 
.I audible 
bell is defined to be the system bell, or the default keyboard bell, as opposed to any 
other audible sound generated elsewhere in the system. 
You can ask to receive XkbBellNotify events when any client rings any one of the 
following:

.IP \(bu 5
The default bell
.IP \(bu 5
Any bell on an input device that can be specified by a bell_class and bell_id pair
.IP \(bu 5
Any bell specified only by an arbitrary name. (This is, from the server's point of view, 
merely a name, and not connected with any physical sound-generating device. Some client 
application must generate the sound, or visual feedback, if any, that is associated with 
the name.)

You can also ask to receive XkbBellNotify events when the server rings the default bell 
or if any client has requested events only (without the bell sounding) for any of the 
bell types previously listed.

You can disable audible bells on a global basis. For example, a client that replaces the 
keyboard bell with some other audible cue might want to turn off the AudibleBell control 
to prevent the server from also generating a sound and avoid cacophony. If you disable 
audible bells and request to receive XkbBellNotify events, you can generate feedback 
different from the default bell.

You can, however, override the AudibleBell control by calling one of the functions that 
force the ringing of a bell in spite of the setting of the AudibleBell control - 
.I XkbForceDeviceBell 
or 
.I XkbForceBell. 
In this case the server does not generate a bell event.

Just as some keyboards can produce keyclicks to indicate when a key is pressed or 
repeating, Xkb can provide feedback for the controls by using special beep codes. The 
AccessXFeedback control is used to configure the specific types of operations that 
generate feedback.

Bell Names

You can associate a name to an act of ringing a bell by converting the name to an Atom 
and then using this name when you call the functions listed in this chapter. If an event 
is generated as a result, the name is then passed to all other clients interested in 
receiving XkbBellNotify events. Note that these are arbitrary names and that there is no 
binding to any sounds. Any sounds or other effects (such as visual bells on the screen) 
must be generated by a client application upon receipt of the bell event containing the 
name. There is no default name for the default keyboard bell. The server does generate 
some predefined bells for the AccessX controls. These named bells are shown in the Table 1
; the name is included in any bell event sent to clients that have requested to 
receive XkbBellNotify events.

.TS
c s
l l
lW(4i) l.
Table 1 Predefined Bells
_
Action	Named Bell
_
Indicator turned on	AX_IndicatorOn
Indicator turned off	AX_IndicatorOff
More than one indicator changed state	AX_IndicatorChange
Control turned on	AX_FeatureOn
Control turned off	AX_FeatureOff
More than one control changed state	AX_FeatureChange
T{
SlowKeys and BounceKeys about to be turned on or off
T}	AX_SlowKeysWarning
SlowKeys key pressed	AX_SlowKeyPress
SlowKeys key accepted	AX_SlowKeyAccept
SlowKeys key rejected	AX_SlowKeyReject
Accepted SlowKeys key released	AX_SlowKeyRelease
BounceKeys key rejected	AX_BounceKeyReject
StickyKeys key latched	AX_StickyLatch
StickyKeys key locked	AX_StickyLock
StickyKeys key unlocked	AX_StickyUnlock
.TE

Audible Bells

Using Xkb you can generate bell events that do not necessarily ring the system bell. This 
is useful if you need to use an audio server instead of the system beep. For example, 
when an audio client starts, it could disable the audible bell (the system bell) and then 
listen for XkbBellNotify events. When it receives a XkbBellNotify event, the audio client 
could then send a request to an audio server to play a sound.

You can control the audible bells feature by passing the XkbAudibleBellMask to
.I XkbChangeEnabledControls. 
If you set XkbAudibleBellMask on, the server rings the system bell when a bell event 
occurs. This is the default. If you set XkbAudibleBellMask off and a bell event occurs, 
the server does not ring the system bell unless you call 
.I XkbForceDeviceBell 
or 
.I XkbForceBell.

Audible bells are also part of the per-client auto-reset controls.

Bell Functions

Use the functions described in this section to ring bells and to generate bell events. 

The input extension has two types of feedbacks that can generate bells - bell feedback 
and keyboard feedback. Some of the functions in this section have
.I bell_class 
and 
.I bell_id 
parameters; set them as follows: Set 
.I bell_class 
to BellFeedbackClass or KbdFeedbackClass. A device can have more than one feedback of 
each type; set 
.I bell_id 
to the particular bell feedback of 
.I bell_class 
type.

The Table 2 shows the conditions that cause a bell to sound or an XkbBellNotifyEvent 
to be generated when a bell function is called.

.TS
c s s s
l l l l
l l l l.
Table 2 Bell Sounding and Bell Event Generating
_
Function called	AudibleBell	Server sounds a bell	Server sends an 
XkbBellNotifyEvent
_
XkbDeviceBell	On	Yes	Yes
XkbDeviceBell	Off	No	Yes
XkbBell	On	Yes	Yes
XkbBell	Off	No	Yes
XkbDeviceBellEvent	On or Off	No	Yes
XkbBellEvent	On or Off	No	Yes
XkbDeviceForceBell	On or Off	Yes	No
XkbForceBell	On or Off	Yes	No
.TE

Set 
.I percent 
to be the volume relative to the base volume for the keyboard as described for .I XBell.

Note that 
.I bell_class 
and 
.I bell_id 
indicate the bell to physically ring. 
.I name 
is simply an arbitrary moniker for the client application's use.

To determine the current feedback settings of an extension input device, use 
.I XGetFeedbackControl. 
See the X input extension documentation for more information on
.I XGetFeedbackControl 
and related data structures.

If a compatible keyboard extension is not present in the X server, 
.I XkbDeviceBell 
immediately returns False. Otherwise, 
.I XkbDeviceBell 
rings the bell as specified for the display and keyboard device and returns True. If you have disabled the audible bell, the server does not ring the system bell, although it does generate a 
.I XkbBellNotify 
event.

You can call 
.I XkbDeviceBell 
without first initializing the keyboard extension.
.SH STRUCTURES
Xkb generates XkbBellNotify events for all bells except for those resulting from calls to 
.I XkbForceDeviceBell 
and 
.I XkbForceBell. 
To receive XkbBellNotify events under all possible conditions, pass XkbBellNotifyMask in 
both the 
.I bits_to_change 
and 
.I values_for_bits 
parameters to 
.I XkbSelectEvents.

The XkbBellNotify event has no event details. It is either selected or it is not. 
However, you can call 
.I XkbSelectEventDetails 
using XkbBellNotify as the 
.I event_type 
and specifying XkbAllBellEventsMask in
.I bits_to_change 
and 
.I values_for_bits. 
This has the same effect as a call to 
.I XkbSelectEvents.

The structure for the XkbBellNotify event type contains:
.nf

   typedef struct _XkbBellNotify {
       int            type;        /\&* Xkb extension base event code */
       unsigned long  serial;      /\&* X server serial number for event */
       Bool           send_event;  /\&* True => synthetically generated */
       Display *      display;     /\&* server connection where event generated */
       Time           time;        /\&* server time when event generated */
       int            xkb_type;    /\&* XkbBellNotify */
       unsigned int   device;      /\&* Xkb device ID, will not be XkbUseCoreKbd */
       int            percent;     /\&* requested volume as % of max */
       int            pitch;       /\&* requested pitch in Hz */
       int            duration;    /\&* requested duration in microseconds */
       unsigned int   bell_class;  /\&* X input extension feedback class */
       unsigned int   bell_id;     /\&* X input extension feedback ID */
       Atom           name;        /\&* "name" of requested bell */
       Window         window;      /\&* window associated with event */
       Bool           event_only;  /\&* False -> the server did not produce a beep */
   } XkbBellNotifyEvent;
   
.fi   
If your application needs to generate visual bell feedback on the screen when it receives 
a bell event, use the window ID in the XkbBellNotifyEvent, if present.

.SH "SEE ALSO"
.BR XBell (__libmansuffix__),
.BR XkbBellNotify (__libmansuffix__),
.BR XkbChangeEnabledControls (__libmansuffix__),
.BR XkbDeviceBell (__libmansuffix__),
.BR XkbForceBell (__libmansuffix__),
.BR XkbForceDeviceBell (__libmansuffix__),
.BR XGetFeedbackControl (__libmansuffix__),
.BR XkbSelectEvents (__libmansuffix__)

