.TH sane\-teco2 5 "14 Jul 2008" "@PACKAGEVERSION@" "SANE Scanner Access Now Easy"
.IX sane\-teco2
.SH NAME
sane\-teco2 \- SANE backend for TECO / RELISYS scanners
.SH DESCRIPTION
The
.B sane\-teco2
library implements a SANE (Scanner Access Now Easy) backend that
provides access to some TECO SCSI flatbed scanners. This backend
should be considered
.B beta-quality
software! TECO scanners are sold under
various brands like Mustek, Relisys, Piotech, Primax, TRUST.
This backend may or may not support yours.
.PP
The scanners that should work with this backend are:
.PP
.RS
.ft CR
.nf
   Vendor Model           TECO model       status
----------------------  --------------  -----------
  Mustek ScanMagic 4830S   VM3575        untested
  Primax Jewel 4800        VM356A         good
  Primax Profi 9600        VM6575         basic
  Primax Profi 19200       VM6586         good
  Relisys APOLLO Express 3 VM356A         basic
  Relisys APOLLO Express 6 VM6565         good
  Relisys APOLLO Express 12   ?          untested
  Relisys AVEC II S3       VM3564         good
  Relisys AVEC Super 3     VM3575         basic
  Relisys SCORPIO Pro      VM6575         good
  Relisys SCORPIO Pro-S    VM6586        untested
  Relisys SCORPIO Super 3  VM3575         good
.fi
.ft R
.RE

For all these scanners, lineart and gray mode work
well. However, most of them do not support more than a handful of
resolutions in color mode. See the backend home page (under AUTHOR)
for the exact status of each scanner.

Note that the untested scanner will not be directly supported. You
should contact the author for that.

The TECO VM number can usually be found at the back of the
scanner. It is also part of the FCC ID. 

The options the backend supports can either be selected through
command line options to programs like scanimage or through GUI
elements in xscanimage, xsane, quiteinsane or kooka.

.br
If you have any success with a scanner not listed here, or if you have
any strange behavior, please report to the backend maintainer or to
the SANE mailing list.

Valid command line options and their syntax can be listed by using 
.RS
scanimage \-\-help \-d teco2
.RE

.TP
.B Scan Mode

.TP
.B \-\-mode
selects the basic mode of operation of the scanner valid choices are 
.I Lineart
,
.I Gray
and
.I Color
The Lineart mode is black and white only (1 bit). Gray mode
will produce 256 levels of gray (8 bits). Color will produce a 24 bits
color image.

.TP
.B \-\-resolution
Lineart and Gray
selects the resolution for a scan. The scanner can do all resolutions
between 1 and 600, in increments of 1.


Color
selects the resolution for a scan. The scanner can do only the 
resolutions listed.

All values with ydpi > 300 (300 x 600) or 600 (600 x 1200) result in 
a wrong proportion for the scan. The proportion can be adjusted with 
the following imagemagick command: 
convert \-geometry (dpi/max_xdpi * 100%)x100% 
max_xdpi is for the vm3575 constant with 300 dpi      
e.g. 600dpi adjust with: convert \-geometry 200%x100%  

.TP
.B Geometry options

.TP
.B \-l \-t \-x \-y 
control the scan area: \-l sets the top left x coordinate, \-t the top
left y coordinate, \-x selects the width and \-y the height of the scan
area. All parameters are specified in millimeters by default.


.TP
.B Enhancement options

.TP
.B \-\-custom\-gamma (no custom gamma option for the VM3564 and VM356A)
(color mode only) allows the user to specify a gamma table (see the
next 3 parameters).

.TP 
.B \-\-red\-gamma\-table 
(color mode only) can be used to download a user defined
gamma table for the red channel. The table must be 256 bytes long.

.TP 
.B \-\-green\-gamma\-table 
(color mode only) can be used to download a user defined
gamma table for the green channel. The table must be 256 bytes long.

.TP
.B \-\-blue\-gamma\-table 
(color mode only) can be used to download a user defined gamma table
for the blue channel. The table must be 256 bytes long.

.TP
.B \-\-white\-level\-r
(VM3564, VM356A, VM3575 and VM6575 only) Selects what red radiance level should be
considered "white", when scanning some sheets by changing the calibration 
value loaded into the scanner. Scale 0..64 in steps of 1.

.TP
.B \-\-white\-level\-g
(VM3564, VM356A, VM3575 and VM6575 only) Selects what green radiance level should be
considered "white", when scanning some sheets by changing the calibration i
value loaded into the scanner. Scale 0..64 in steps of 1.

.TP
.B \-\-white\-level\-b
(VM3564, VM356A, VM3575 and VM6575 only) Selects what blue radiance level should be
considered "white", when scanning some sheets by changing the calibration
value loaded into the scanner. Scale 0..64 in steps of 1.

.TP 
.B \-\-preview
requests a preview scan. The resolution used for that scan is 50  dpi
(for VM356A and VM6575 75 dpi) and the scan area is the maximum allowed. 
The scan mode is user selected. The default is "no".


.SH CONFIGURATION FILE
The configuration file @CONFIGDIR@/teco2.conf supports only one
information: the device name to use (eg /dev/scanner).


.SH FILES
.TP
.I @LIBDIR@/libsane\-teco2.a
The static library implementing this backend.
.TP
.I @LIBDIR@/libsane\-teco2.so
The shared library implementing this backend (present on systems that
support dynamic loading).


.SH ENVIRONMENT
.TP
.B SANE_DEBUG_TECO2
If the library was compiled with debug support enabled, this
environment variable controls the debug level for this backend. E.g.,
a value of 128 requests all debug output to be printed. Smaller levels
reduce verbosity.
.TP
.B SANE_TECO2_CAL_ALGO
Either 0 or 1. Selects the algorithm for the calibration. A
value of 1 seems to give better scans on the VM356A, VM3575.
Feedback on it is welcome.
For VM3564, VM356A, VM3575, VM6575 default 1.
For other supported types default 0.


.SH LIMITATIONS
The windows TWAIN driver has many more options than this SANE
backend. However they are only software adjustments. This backend only
implements what the scanner can support.


.SH BUGS

Plenty. Parts of this backend are still under development.


.SH "SEE ALSO"

sane\-scsi(5), scanimage(1), xscanimage(1), xsane(1), sane(7)


.SH AUTHORS
.TP
Frank Zago
.I http://www.zago.net/sane/#teco2
.TP
The package is actively maintained by Gerard Klaver.
.I http://gkall.hobby.nl/teco2.html




.SH CREDITS

Thanks to:
.TP
Gerard Klaver for his relentless VM3575 testings and contributed a patch to support the VM3564 and VM356A.
.TP
Mark Plowman for providing the first SCSI traces from a VM3575.
.TP
Andreas Klaedtke for providing the first SCSI traces from a VM6586 and for his testing, and to Stefan von Dombrowski for his testing.
.TP
Nicolas Peyresaubes for providing the first SCSI traces from a VM656A and for his testing.
.TP
Dave Parker for testing the support for the VM6575.
.TP
Michael Hoeller for testing the support for the VM356A.
.TP
Christoph.Hoeffner for testing the support for the VM3564 (Relisys AVEC II S3 firmware 1.09).
