/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aes.webservices.client.blockdevicelib.vhd;

import com.amazon.aes.webservices.client.blockdevicelib.DiskImage;
import com.amazon.aes.webservices.client.blockdevicelib.FileDiskImage;
import com.amazon.aes.webservices.client.blockdevicelib.ImageVerificationException;
import com.amazon.aes.webservices.client.blockdevicelib.vhd.DynamicDiskHeader;
import com.amazon.aes.webservices.client.blockdevicelib.vhd.HardDiskFooter;
import java.nio.ByteBuffer;

public class DynamicVHD
extends DiskImage {
    protected FileDiskImage image;
    private HardDiskFooter hardDiskFooter;
    private DynamicDiskHeader dynamicDiskHeader;
    private long[] blockAllocationTable;

    DynamicVHD(HardDiskFooter hardDiskFooter, DynamicDiskHeader diskHeader, long[] blockAllocationTable) {
        this.hardDiskFooter = hardDiskFooter;
        this.dynamicDiskHeader = diskHeader;
        this.blockAllocationTable = blockAllocationTable;
    }

    public DynamicVHD(FileDiskImage diskImage) throws ImageVerificationException {
        this.image = diskImage;
        this.hardDiskFooter = this.parseHardDiskFooterMirror();
        this.hardDiskFooter.verifyFooter();
        this.dynamicDiskHeader = this.parseDynamicDiskHeader();
        this.dynamicDiskHeader.verifyHeader();
        this.blockAllocationTable = this.loadBlockAllocationTable();
    }

    @Override
    public long size() {
        return this.hardDiskFooter.currentSize;
    }

    @Override
    public byte[] read(long offset, int length) throws ImageVerificationException {
        byte[] bytes = new byte[length];
        long startOffset = offset;
        long endOffset = offset + (long)bytes.length - 1L;
        int startBATIndex = this.findCorrespondingBATIndex(startOffset);
        int endBATIndex = this.findCorrespondingBATIndex(endOffset);
        int dataBlockBitmapSize = this.computeDataBlockBitmapSize();
        int bytesFilled = 0;
        for (int i = startBATIndex; i <= endBATIndex; ++i) {
            long dataBlockLoc;
            byte[] dataBlock;
            long dataBlockStartOffset;
            if (this.blockAllocationTable[i] == 0xFFFFFFFFL || !DiskImage.rangesOverlap(dataBlockStartOffset = (long)(i * this.dynamicDiskHeader.blockSize), (dataBlock = this.image.read(dataBlockLoc = this.blockAllocationTable[i] * 512L + (long)dataBlockBitmapSize, this.dynamicDiskHeader.blockSize)).length, startOffset, bytes.length)) continue;
            bytesFilled += DiskImage.copyBytes(dataBlock, dataBlockStartOffset, dataBlock.length, bytes, startOffset);
        }
        return bytes;
    }

    protected int findCorrespondingBATIndex(long offset) throws ImageVerificationException {
        int index = (int)(offset / (long)this.dynamicDiskHeader.blockSize);
        if (index < 0 || index >= this.blockAllocationTable.length) {
            throw new ImageVerificationException("Failed to find BAT index corresponding to " + offset);
        }
        return index;
    }

    protected int computeDataBlockBitmapSize() {
        int bitmapSize = this.dynamicDiskHeader.blockSize / 512 / 8;
        return (bitmapSize + 512 - 1) / 512 * 512;
    }

    protected HardDiskFooter parseHardDiskFooterMirror() throws ImageVerificationException {
        ByteBuffer buff = this.image.readAsBuffer(0L, 512);
        return new HardDiskFooter(buff);
    }

    protected DynamicDiskHeader parseDynamicDiskHeader() throws ImageVerificationException {
        ByteBuffer buff = this.image.readAsBuffer(this.hardDiskFooter.dataOffset, 1024);
        return new DynamicDiskHeader(buff);
    }

    protected long[] loadBlockAllocationTable() throws ImageVerificationException {
        int BATLength = this.dynamicDiskHeader.maxTableEntries * 4;
        ByteBuffer buff = this.image.readAsBuffer(this.dynamicDiskHeader.tableOffset, BATLength);
        long[] table = new long[this.dynamicDiskHeader.maxTableEntries];
        for (int i = 0; i < table.length; ++i) {
            table[i] = DiskImage.getUnsignedInt(buff.getInt());
        }
        return table;
    }
}

