static char rcsid[] = "$Id: genome_sites.c 153955 2014-11-24 17:54:45Z twu $";
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#ifndef HAVE_MEMCPY
# define memcpy(d,s,n) bcopy((s),(d),(n))
#endif
#ifndef HAVE_MEMMOVE
# define memmove(d,s,n) bcopy((s),(d),(n))
#endif

#include "genome_sites.h"

#include <stdio.h>
#include <stddef.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>		/* For tolower() */

#include "assert.h"
#include "except.h"
#include "cmet.h"
#include "atoi.h"
#include "maxent_hr.h"
#include "popcount.h"


#ifdef WORDS_BIGENDIAN
#include "bigendian.h"
#else
#include "littleendian.h"
#endif


/* Splice sites */
#ifdef DEBUG2
#define debug2(x) x
#else
#define debug2(x)
#endif

/* last_dinucleotide_positions */
#ifdef DEBUG3
#define debug3(x) x
#else
#define debug3(x)
#endif

/* prev_dinucleotide_position */
#ifdef DEBUG3A
#define debug3a(x) x
#else
#define debug3a(x)
#endif

/* prev_dinucleotide_positions_rev */
#ifdef DEBUG3B
#define debug3b(x) x
#else
#define debug3b(x)
#endif

/* canonicalp */
#ifdef DEBUG4
#define debug4(x) x
#else
#define debug4(x)
#endif




static const Genomecomp_T donor_gt_bits[] =
{0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x00A,0x009,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x00A,0x009,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x00A,0x009,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x012,0x011,
 0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x012,0x011,
 0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x012,0x011,
 0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x014,0x014,0x014,0x015,0x010,0x010,0x012,0x011,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x00A,0x009,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x00A,0x009,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x00A,0x009,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x00A,0x009,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x012,0x011,
 0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x012,0x011,
 0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x012,0x011,
 0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x014,0x014,0x014,0x015,0x010,0x010,0x012,0x011,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x00A,0x009,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x00A,0x009,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x00A,0x009,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x00A,0x009,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x012,0x011,
 0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x012,0x011,
 0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x012,0x011,
 0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x014,0x014,0x014,0x015,0x010,0x010,0x012,0x011,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x00A,0x009,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x00A,0x009,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x00A,0x009,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x022,0x021,
 0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x022,0x021,
 0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x022,0x021,
 0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x024,0x024,0x024,0x025,0x020,0x020,0x022,0x021,
 0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x022,0x021,
 0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x022,0x021,
 0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x022,0x021,
 0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x024,0x024,0x024,0x025,0x020,0x020,0x022,0x021,
 0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x022,0x021,
 0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x022,0x021,
 0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x022,0x021,
 0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x024,0x024,0x024,0x025,0x020,0x020,0x022,0x021,
 0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x022,0x021,
 0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x022,0x021,
 0x028,0x028,0x028,0x029,0x028,0x028,0x028,0x029,0x028,0x028,0x028,0x029,0x028,0x028,0x02A,0x029,
 0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x024,0x024,0x024,0x025,0x020,0x020,0x022,0x021,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x012,0x011,
 0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x012,0x011,
 0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x012,0x011,
 0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x014,0x014,0x014,0x015,0x010,0x010,0x012,0x011,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x00A,0x009,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x00A,0x009,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x00A,0x009,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x00A,0x009,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x012,0x011,
 0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x012,0x011,
 0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x012,0x011,
 0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x014,0x014,0x014,0x015,0x010,0x010,0x012,0x011,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x00A,0x009,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x00A,0x009,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x00A,0x009,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x00A,0x009,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x012,0x011,
 0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x012,0x011,
 0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x012,0x011,
 0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x014,0x014,0x014,0x015,0x010,0x010,0x012,0x011,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x00A,0x009,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x00A,0x009,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x00A,0x009,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x00A,0x009,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x012,0x011,
 0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x012,0x011,
 0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x012,0x011,
 0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x014,0x014,0x014,0x015,0x010,0x010,0x012,0x011,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x00A,0x009,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x00A,0x009,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x00A,0x009,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x022,0x021,
 0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x022,0x021,
 0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x022,0x021,
 0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x024,0x024,0x024,0x025,0x020,0x020,0x022,0x021,
 0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x022,0x021,
 0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x022,0x021,
 0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x022,0x021,
 0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x024,0x024,0x024,0x025,0x020,0x020,0x022,0x021,
 0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x022,0x021,
 0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x022,0x021,
 0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x022,0x021,
 0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x024,0x024,0x024,0x025,0x020,0x020,0x022,0x021,
 0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x022,0x021,
 0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x022,0x021,
 0x028,0x028,0x028,0x029,0x028,0x028,0x028,0x029,0x028,0x028,0x028,0x029,0x028,0x028,0x02A,0x029,
 0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x024,0x024,0x024,0x025,0x020,0x020,0x022,0x021,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x012,0x011,
 0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x012,0x011,
 0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x012,0x011,
 0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x014,0x014,0x014,0x015,0x010,0x010,0x012,0x011,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x00A,0x009,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x00A,0x009,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x00A,0x009,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x00A,0x009,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x012,0x011,
 0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x012,0x011,
 0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x012,0x011,
 0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x014,0x014,0x014,0x015,0x010,0x010,0x012,0x011,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x00A,0x009,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x00A,0x009,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x00A,0x009,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x00A,0x009,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x012,0x011,
 0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x012,0x011,
 0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x012,0x011,
 0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x014,0x014,0x014,0x015,0x010,0x010,0x012,0x011,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x00A,0x009,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x00A,0x009,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x00A,0x009,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x00A,0x009,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x012,0x011,
 0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x012,0x011,
 0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x012,0x011,
 0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x014,0x014,0x014,0x015,0x010,0x010,0x012,0x011,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x00A,0x009,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x00A,0x009,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x00A,0x009,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x022,0x021,
 0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x022,0x021,
 0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x022,0x021,
 0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x024,0x024,0x024,0x025,0x020,0x020,0x022,0x021,
 0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x022,0x021,
 0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x022,0x021,
 0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x022,0x021,
 0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x024,0x024,0x024,0x025,0x020,0x020,0x022,0x021,
 0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x022,0x021,
 0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x022,0x021,
 0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x022,0x021,
 0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x024,0x024,0x024,0x025,0x020,0x020,0x022,0x021,
 0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x022,0x021,
 0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x022,0x021,
 0x028,0x028,0x028,0x029,0x028,0x028,0x028,0x029,0x028,0x028,0x028,0x029,0x028,0x028,0x02A,0x029,
 0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x024,0x024,0x024,0x025,0x020,0x020,0x022,0x021,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x012,0x011,
 0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x012,0x011,
 0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x012,0x011,
 0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x014,0x014,0x014,0x015,0x010,0x010,0x012,0x011,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x00A,0x009,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x00A,0x009,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x00A,0x009,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x00A,0x009,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x012,0x011,
 0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x012,0x011,
 0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x012,0x011,
 0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x014,0x014,0x014,0x015,0x010,0x010,0x012,0x011,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x00A,0x009,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x00A,0x009,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x00A,0x009,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x00A,0x009,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x012,0x011,
 0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x012,0x011,
 0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x012,0x011,
 0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x014,0x014,0x014,0x015,0x010,0x010,0x012,0x011,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x00A,0x009,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x042,0x041,
 0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x042,0x041,
 0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x042,0x041,
 0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x044,0x044,0x044,0x045,0x040,0x040,0x042,0x041,
 0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x042,0x041,
 0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x042,0x041,
 0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x042,0x041,
 0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x044,0x044,0x044,0x045,0x040,0x040,0x042,0x041,
 0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x042,0x041,
 0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x042,0x041,
 0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x042,0x041,
 0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x044,0x044,0x044,0x045,0x040,0x040,0x042,0x041,
 0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x042,0x041,
 0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x042,0x041,
 0x048,0x048,0x048,0x049,0x048,0x048,0x048,0x049,0x048,0x048,0x048,0x049,0x048,0x048,0x04A,0x049,
 0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x044,0x044,0x044,0x045,0x040,0x040,0x042,0x041,
 0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x042,0x041,
 0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x042,0x041,
 0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x042,0x041,
 0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x044,0x044,0x044,0x045,0x040,0x040,0x042,0x041,
 0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x042,0x041,
 0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x042,0x041,
 0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x042,0x041,
 0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x044,0x044,0x044,0x045,0x040,0x040,0x042,0x041,
 0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x042,0x041,
 0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x042,0x041,
 0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x042,0x041,
 0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x044,0x044,0x044,0x045,0x040,0x040,0x042,0x041,
 0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x042,0x041,
 0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x042,0x041,
 0x048,0x048,0x048,0x049,0x048,0x048,0x048,0x049,0x048,0x048,0x048,0x049,0x048,0x048,0x04A,0x049,
 0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x044,0x044,0x044,0x045,0x040,0x040,0x042,0x041,
 0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x042,0x041,
 0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x042,0x041,
 0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x042,0x041,
 0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x044,0x044,0x044,0x045,0x040,0x040,0x042,0x041,
 0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x042,0x041,
 0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x042,0x041,
 0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x042,0x041,
 0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x044,0x044,0x044,0x045,0x040,0x040,0x042,0x041,
 0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x042,0x041,
 0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x042,0x041,
 0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x042,0x041,
 0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x044,0x044,0x044,0x045,0x040,0x040,0x042,0x041,
 0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x042,0x041,
 0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x042,0x041,
 0x048,0x048,0x048,0x049,0x048,0x048,0x048,0x049,0x048,0x048,0x048,0x049,0x048,0x048,0x04A,0x049,
 0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x044,0x044,0x044,0x045,0x040,0x040,0x042,0x041,
 0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x042,0x041,
 0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x042,0x041,
 0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x042,0x041,
 0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x044,0x044,0x044,0x045,0x040,0x040,0x042,0x041,
 0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x042,0x041,
 0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x042,0x041,
 0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x042,0x041,
 0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x044,0x044,0x044,0x045,0x040,0x040,0x042,0x041,
 0x050,0x050,0x050,0x051,0x050,0x050,0x050,0x051,0x050,0x050,0x050,0x051,0x050,0x050,0x052,0x051,
 0x050,0x050,0x050,0x051,0x050,0x050,0x050,0x051,0x050,0x050,0x050,0x051,0x050,0x050,0x052,0x051,
 0x050,0x050,0x050,0x051,0x050,0x050,0x050,0x051,0x050,0x050,0x050,0x051,0x050,0x050,0x052,0x051,
 0x050,0x050,0x050,0x051,0x050,0x050,0x050,0x051,0x054,0x054,0x054,0x055,0x050,0x050,0x052,0x051,
 0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x042,0x041,
 0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x042,0x041,
 0x048,0x048,0x048,0x049,0x048,0x048,0x048,0x049,0x048,0x048,0x048,0x049,0x048,0x048,0x04A,0x049,
 0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x044,0x044,0x044,0x045,0x040,0x040,0x042,0x041,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x00A,0x009,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x00A,0x009,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x022,0x021,
 0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x022,0x021,
 0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x022,0x021,
 0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x024,0x024,0x024,0x025,0x020,0x020,0x022,0x021,
 0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x022,0x021,
 0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x022,0x021,
 0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x022,0x021,
 0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x024,0x024,0x024,0x025,0x020,0x020,0x022,0x021,
 0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x022,0x021,
 0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x022,0x021,
 0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x022,0x021,
 0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x024,0x024,0x024,0x025,0x020,0x020,0x022,0x021,
 0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x022,0x021,
 0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x022,0x021,
 0x028,0x028,0x028,0x029,0x028,0x028,0x028,0x029,0x028,0x028,0x028,0x029,0x028,0x028,0x02A,0x029,
 0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x024,0x024,0x024,0x025,0x020,0x020,0x022,0x021,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x012,0x011,
 0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x012,0x011,
 0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x012,0x011,
 0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x014,0x014,0x014,0x015,0x010,0x010,0x012,0x011,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x00A,0x009,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x00A,0x009,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x00A,0x009,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x00A,0x009,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x012,0x011,
 0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x012,0x011,
 0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x012,0x011,
 0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x014,0x014,0x014,0x015,0x010,0x010,0x012,0x011,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x00A,0x009,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x00A,0x009,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x00A,0x009,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x00A,0x009,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x012,0x011,
 0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x012,0x011,
 0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x012,0x011,
 0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x014,0x014,0x014,0x015,0x010,0x010,0x012,0x011,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x00A,0x009,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x00A,0x009,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x00A,0x009,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x00A,0x009,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x012,0x011,
 0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x012,0x011,
 0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x012,0x011,
 0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x014,0x014,0x014,0x015,0x010,0x010,0x012,0x011,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x00A,0x009,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x00A,0x009,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x00A,0x009,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x022,0x021,
 0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x022,0x021,
 0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x022,0x021,
 0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x024,0x024,0x024,0x025,0x020,0x020,0x022,0x021,
 0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x022,0x021,
 0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x022,0x021,
 0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x022,0x021,
 0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x024,0x024,0x024,0x025,0x020,0x020,0x022,0x021,
 0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x022,0x021,
 0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x022,0x021,
 0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x022,0x021,
 0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x024,0x024,0x024,0x025,0x020,0x020,0x022,0x021,
 0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x022,0x021,
 0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x022,0x021,
 0x028,0x028,0x028,0x029,0x028,0x028,0x028,0x029,0x028,0x028,0x028,0x029,0x028,0x028,0x02A,0x029,
 0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x024,0x024,0x024,0x025,0x020,0x020,0x022,0x021,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x012,0x011,
 0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x012,0x011,
 0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x012,0x011,
 0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x014,0x014,0x014,0x015,0x010,0x010,0x012,0x011,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x00A,0x009,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x00A,0x009,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x00A,0x009,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x00A,0x009,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x012,0x011,
 0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x012,0x011,
 0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x012,0x011,
 0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x014,0x014,0x014,0x015,0x010,0x010,0x012,0x011,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x00A,0x009,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x00A,0x009,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x00A,0x009,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x00A,0x009,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x012,0x011,
 0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x012,0x011,
 0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x012,0x011,
 0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x014,0x014,0x014,0x015,0x010,0x010,0x012,0x011,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x00A,0x009,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x00A,0x009,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x00A,0x009,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x00A,0x009,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x012,0x011,
 0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x012,0x011,
 0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x012,0x011,
 0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x014,0x014,0x014,0x015,0x010,0x010,0x012,0x011,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x00A,0x009,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x00A,0x009,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x00A,0x009,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x022,0x021,
 0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x022,0x021,
 0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x022,0x021,
 0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x024,0x024,0x024,0x025,0x020,0x020,0x022,0x021,
 0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x022,0x021,
 0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x022,0x021,
 0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x022,0x021,
 0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x024,0x024,0x024,0x025,0x020,0x020,0x022,0x021,
 0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x022,0x021,
 0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x022,0x021,
 0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x022,0x021,
 0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x024,0x024,0x024,0x025,0x020,0x020,0x022,0x021,
 0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x022,0x021,
 0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x022,0x021,
 0x028,0x028,0x028,0x029,0x028,0x028,0x028,0x029,0x028,0x028,0x028,0x029,0x028,0x028,0x02A,0x029,
 0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x024,0x024,0x024,0x025,0x020,0x020,0x022,0x021,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x012,0x011,
 0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x012,0x011,
 0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x012,0x011,
 0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x014,0x014,0x014,0x015,0x010,0x010,0x012,0x011,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x00A,0x009,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x00A,0x009,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x00A,0x009,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x00A,0x009,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x012,0x011,
 0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x012,0x011,
 0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x012,0x011,
 0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x014,0x014,0x014,0x015,0x010,0x010,0x012,0x011,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x00A,0x009,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x00A,0x009,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x00A,0x009,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x00A,0x009,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x012,0x011,
 0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x012,0x011,
 0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x012,0x011,
 0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x014,0x014,0x014,0x015,0x010,0x010,0x012,0x011,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x00A,0x009,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x00A,0x009,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x00A,0x009,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x00A,0x009,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x012,0x011,
 0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x012,0x011,
 0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x012,0x011,
 0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x014,0x014,0x014,0x015,0x010,0x010,0x012,0x011,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x00A,0x009,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x00A,0x009,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x00A,0x009,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x022,0x021,
 0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x022,0x021,
 0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x022,0x021,
 0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x024,0x024,0x024,0x025,0x020,0x020,0x022,0x021,
 0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x022,0x021,
 0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x022,0x021,
 0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x022,0x021,
 0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x024,0x024,0x024,0x025,0x020,0x020,0x022,0x021,
 0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x022,0x021,
 0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x022,0x021,
 0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x022,0x021,
 0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x024,0x024,0x024,0x025,0x020,0x020,0x022,0x021,
 0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x022,0x021,
 0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x022,0x021,
 0x028,0x028,0x028,0x029,0x028,0x028,0x028,0x029,0x028,0x028,0x028,0x029,0x028,0x028,0x02A,0x029,
 0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x024,0x024,0x024,0x025,0x020,0x020,0x022,0x021,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x012,0x011,
 0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x012,0x011,
 0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x012,0x011,
 0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x014,0x014,0x014,0x015,0x010,0x010,0x012,0x011,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x00A,0x009,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x00A,0x009,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x00A,0x009,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x00A,0x009,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x012,0x011,
 0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x012,0x011,
 0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x012,0x011,
 0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x014,0x014,0x014,0x015,0x010,0x010,0x012,0x011,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x00A,0x009,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x00A,0x009,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x00A,0x009,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x00A,0x009,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x012,0x011,
 0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x012,0x011,
 0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x012,0x011,
 0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x014,0x014,0x014,0x015,0x010,0x010,0x012,0x011,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x00A,0x009,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x042,0x041,
 0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x042,0x041,
 0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x042,0x041,
 0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x044,0x044,0x044,0x045,0x040,0x040,0x042,0x041,
 0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x042,0x041,
 0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x042,0x041,
 0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x042,0x041,
 0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x044,0x044,0x044,0x045,0x040,0x040,0x042,0x041,
 0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x042,0x041,
 0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x042,0x041,
 0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x042,0x041,
 0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x044,0x044,0x044,0x045,0x040,0x040,0x042,0x041,
 0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x042,0x041,
 0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x042,0x041,
 0x048,0x048,0x048,0x049,0x048,0x048,0x048,0x049,0x048,0x048,0x048,0x049,0x048,0x048,0x04A,0x049,
 0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x044,0x044,0x044,0x045,0x040,0x040,0x042,0x041,
 0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x042,0x041,
 0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x042,0x041,
 0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x042,0x041,
 0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x044,0x044,0x044,0x045,0x040,0x040,0x042,0x041,
 0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x042,0x041,
 0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x042,0x041,
 0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x042,0x041,
 0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x044,0x044,0x044,0x045,0x040,0x040,0x042,0x041,
 0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x042,0x041,
 0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x042,0x041,
 0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x042,0x041,
 0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x044,0x044,0x044,0x045,0x040,0x040,0x042,0x041,
 0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x042,0x041,
 0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x042,0x041,
 0x048,0x048,0x048,0x049,0x048,0x048,0x048,0x049,0x048,0x048,0x048,0x049,0x048,0x048,0x04A,0x049,
 0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x044,0x044,0x044,0x045,0x040,0x040,0x042,0x041,
 0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x042,0x041,
 0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x042,0x041,
 0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x042,0x041,
 0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x044,0x044,0x044,0x045,0x040,0x040,0x042,0x041,
 0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x042,0x041,
 0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x042,0x041,
 0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x042,0x041,
 0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x044,0x044,0x044,0x045,0x040,0x040,0x042,0x041,
 0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x042,0x041,
 0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x042,0x041,
 0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x042,0x041,
 0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x044,0x044,0x044,0x045,0x040,0x040,0x042,0x041,
 0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x042,0x041,
 0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x042,0x041,
 0x048,0x048,0x048,0x049,0x048,0x048,0x048,0x049,0x048,0x048,0x048,0x049,0x048,0x048,0x04A,0x049,
 0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x044,0x044,0x044,0x045,0x040,0x040,0x042,0x041,
 0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x042,0x041,
 0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x042,0x041,
 0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x042,0x041,
 0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x044,0x044,0x044,0x045,0x040,0x040,0x042,0x041,
 0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x042,0x041,
 0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x042,0x041,
 0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x042,0x041,
 0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x044,0x044,0x044,0x045,0x040,0x040,0x042,0x041,
 0x050,0x050,0x050,0x051,0x050,0x050,0x050,0x051,0x050,0x050,0x050,0x051,0x050,0x050,0x052,0x051,
 0x050,0x050,0x050,0x051,0x050,0x050,0x050,0x051,0x050,0x050,0x050,0x051,0x050,0x050,0x052,0x051,
 0x050,0x050,0x050,0x051,0x050,0x050,0x050,0x051,0x050,0x050,0x050,0x051,0x050,0x050,0x052,0x051,
 0x050,0x050,0x050,0x051,0x050,0x050,0x050,0x051,0x054,0x054,0x054,0x055,0x050,0x050,0x052,0x051,
 0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x042,0x041,
 0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x042,0x041,
 0x048,0x048,0x048,0x049,0x048,0x048,0x048,0x049,0x048,0x048,0x048,0x049,0x048,0x048,0x04A,0x049,
 0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x044,0x044,0x044,0x045,0x040,0x040,0x042,0x041,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x00A,0x009,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x00A,0x009,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x022,0x021,
 0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x022,0x021,
 0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x022,0x021,
 0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x024,0x024,0x024,0x025,0x020,0x020,0x022,0x021,
 0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x022,0x021,
 0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x022,0x021,
 0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x022,0x021,
 0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x024,0x024,0x024,0x025,0x020,0x020,0x022,0x021,
 0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x022,0x021,
 0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x022,0x021,
 0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x022,0x021,
 0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x024,0x024,0x024,0x025,0x020,0x020,0x022,0x021,
 0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x022,0x021,
 0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x022,0x021,
 0x028,0x028,0x028,0x029,0x028,0x028,0x028,0x029,0x028,0x028,0x028,0x029,0x028,0x028,0x02A,0x029,
 0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x024,0x024,0x024,0x025,0x020,0x020,0x022,0x021,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x012,0x011,
 0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x012,0x011,
 0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x012,0x011,
 0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x014,0x014,0x014,0x015,0x010,0x010,0x012,0x011,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x00A,0x009,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x104,0x104,0x104,0x105,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x104,0x104,0x104,0x105,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x104,0x104,0x104,0x105,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x108,0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x108,0x10A,0x109,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x104,0x104,0x104,0x105,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x104,0x104,0x104,0x105,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x104,0x104,0x104,0x105,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x104,0x104,0x104,0x105,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x108,0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x108,0x10A,0x109,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x104,0x104,0x104,0x105,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x104,0x104,0x104,0x105,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x104,0x104,0x104,0x105,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x104,0x104,0x104,0x105,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x108,0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x108,0x10A,0x109,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x104,0x104,0x104,0x105,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x104,0x104,0x104,0x105,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x104,0x104,0x104,0x105,0x100,0x100,0x102,0x101,
 0x110,0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x110,0x110,0x112,0x111,
 0x110,0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x110,0x110,0x112,0x111,
 0x110,0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x110,0x110,0x112,0x111,
 0x110,0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x114,0x114,0x114,0x115,0x110,0x110,0x112,0x111,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x108,0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x108,0x10A,0x109,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x104,0x104,0x104,0x105,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x104,0x104,0x104,0x105,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x104,0x104,0x104,0x105,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x104,0x104,0x104,0x105,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x108,0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x108,0x10A,0x109,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x104,0x104,0x104,0x105,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x104,0x104,0x104,0x105,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x104,0x104,0x104,0x105,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x104,0x104,0x104,0x105,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x108,0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x108,0x10A,0x109,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x104,0x104,0x104,0x105,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x104,0x104,0x104,0x105,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x104,0x104,0x104,0x105,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x104,0x104,0x104,0x105,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x108,0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x108,0x10A,0x109,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x104,0x104,0x104,0x105,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x104,0x104,0x104,0x105,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x104,0x104,0x104,0x105,0x100,0x100,0x102,0x101,
 0x110,0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x110,0x110,0x112,0x111,
 0x110,0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x110,0x110,0x112,0x111,
 0x110,0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x110,0x110,0x112,0x111,
 0x110,0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x114,0x114,0x114,0x115,0x110,0x110,0x112,0x111,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x108,0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x108,0x10A,0x109,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x104,0x104,0x104,0x105,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x104,0x104,0x104,0x105,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x104,0x104,0x104,0x105,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x104,0x104,0x104,0x105,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x108,0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x108,0x10A,0x109,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x104,0x104,0x104,0x105,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x104,0x104,0x104,0x105,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x104,0x104,0x104,0x105,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x104,0x104,0x104,0x105,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x108,0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x108,0x10A,0x109,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x104,0x104,0x104,0x105,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x104,0x104,0x104,0x105,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x104,0x104,0x104,0x105,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x104,0x104,0x104,0x105,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x108,0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x108,0x10A,0x109,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x104,0x104,0x104,0x105,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x104,0x104,0x104,0x105,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x104,0x104,0x104,0x105,0x100,0x100,0x102,0x101,
 0x110,0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x110,0x110,0x112,0x111,
 0x110,0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x110,0x110,0x112,0x111,
 0x110,0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x110,0x110,0x112,0x111,
 0x110,0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x114,0x114,0x114,0x115,0x110,0x110,0x112,0x111,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x108,0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x108,0x10A,0x109,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x104,0x104,0x104,0x105,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x104,0x104,0x104,0x105,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x104,0x104,0x104,0x105,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x104,0x104,0x104,0x105,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x108,0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x108,0x10A,0x109,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x104,0x104,0x104,0x105,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x104,0x104,0x104,0x105,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x104,0x104,0x104,0x105,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x104,0x104,0x104,0x105,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x108,0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x108,0x10A,0x109,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x104,0x104,0x104,0x105,0x100,0x100,0x102,0x101,
 0x120,0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x120,0x120,0x122,0x121,
 0x120,0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x120,0x120,0x122,0x121,
 0x120,0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x120,0x120,0x122,0x121,
 0x120,0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x124,0x124,0x124,0x125,0x120,0x120,0x122,0x121,
 0x120,0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x120,0x120,0x122,0x121,
 0x120,0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x120,0x120,0x122,0x121,
 0x120,0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x120,0x120,0x122,0x121,
 0x120,0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x124,0x124,0x124,0x125,0x120,0x120,0x122,0x121,
 0x120,0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x120,0x120,0x122,0x121,
 0x120,0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x120,0x120,0x122,0x121,
 0x120,0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x120,0x120,0x122,0x121,
 0x120,0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x124,0x124,0x124,0x125,0x120,0x120,0x122,0x121,
 0x120,0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x120,0x120,0x122,0x121,
 0x120,0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x120,0x120,0x122,0x121,
 0x128,0x128,0x128,0x129,0x128,0x128,0x128,0x129,0x128,0x128,0x128,0x129,0x128,0x128,0x12A,0x129,
 0x120,0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x124,0x124,0x124,0x125,0x120,0x120,0x122,0x121,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x104,0x104,0x104,0x105,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x104,0x104,0x104,0x105,0x100,0x100,0x102,0x101,
 0x110,0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x110,0x110,0x112,0x111,
 0x110,0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x110,0x110,0x112,0x111,
 0x110,0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x110,0x110,0x112,0x111,
 0x110,0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x114,0x114,0x114,0x115,0x110,0x110,0x112,0x111,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x108,0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x108,0x10A,0x109,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x104,0x104,0x104,0x105,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x104,0x104,0x104,0x105,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x104,0x104,0x104,0x105,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x104,0x104,0x104,0x105,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x108,0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x108,0x10A,0x109,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x104,0x104,0x104,0x105,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x104,0x104,0x104,0x105,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x104,0x104,0x104,0x105,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x104,0x104,0x104,0x105,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x108,0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x108,0x10A,0x109,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x104,0x104,0x104,0x105,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x104,0x104,0x104,0x105,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x104,0x104,0x104,0x105,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x104,0x104,0x104,0x105,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x108,0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x108,0x10A,0x109,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x104,0x104,0x104,0x105,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x104,0x104,0x104,0x105,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x104,0x104,0x104,0x105,0x100,0x100,0x102,0x101,
 0x110,0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x110,0x110,0x112,0x111,
 0x110,0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x110,0x110,0x112,0x111,
 0x110,0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x110,0x110,0x112,0x111,
 0x110,0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x114,0x114,0x114,0x115,0x110,0x110,0x112,0x111,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x108,0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x108,0x10A,0x109,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x104,0x104,0x104,0x105,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x104,0x104,0x104,0x105,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x104,0x104,0x104,0x105,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x104,0x104,0x104,0x105,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x108,0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x108,0x10A,0x109,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x104,0x104,0x104,0x105,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x104,0x104,0x104,0x105,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x104,0x104,0x104,0x105,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x104,0x104,0x104,0x105,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x108,0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x108,0x10A,0x109,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x104,0x104,0x104,0x105,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x104,0x104,0x104,0x105,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x104,0x104,0x104,0x105,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x104,0x104,0x104,0x105,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x108,0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x108,0x10A,0x109,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x104,0x104,0x104,0x105,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x104,0x104,0x104,0x105,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x104,0x104,0x104,0x105,0x100,0x100,0x102,0x101,
 0x110,0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x110,0x110,0x112,0x111,
 0x110,0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x110,0x110,0x112,0x111,
 0x110,0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x110,0x110,0x112,0x111,
 0x110,0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x114,0x114,0x114,0x115,0x110,0x110,0x112,0x111,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x108,0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x108,0x10A,0x109,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x104,0x104,0x104,0x105,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x104,0x104,0x104,0x105,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x104,0x104,0x104,0x105,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x104,0x104,0x104,0x105,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x108,0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x108,0x10A,0x109,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x104,0x104,0x104,0x105,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x104,0x104,0x104,0x105,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x104,0x104,0x104,0x105,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x104,0x104,0x104,0x105,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x108,0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x108,0x10A,0x109,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x104,0x104,0x104,0x105,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x104,0x104,0x104,0x105,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x104,0x104,0x104,0x105,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x104,0x104,0x104,0x105,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x108,0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x108,0x10A,0x109,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x104,0x104,0x104,0x105,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x104,0x104,0x104,0x105,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x104,0x104,0x104,0x105,0x100,0x100,0x102,0x101,
 0x110,0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x110,0x110,0x112,0x111,
 0x110,0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x110,0x110,0x112,0x111,
 0x110,0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x110,0x110,0x112,0x111,
 0x110,0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x114,0x114,0x114,0x115,0x110,0x110,0x112,0x111,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x108,0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x108,0x10A,0x109,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x104,0x104,0x104,0x105,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x104,0x104,0x104,0x105,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x104,0x104,0x104,0x105,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x104,0x104,0x104,0x105,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x108,0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x108,0x10A,0x109,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x104,0x104,0x104,0x105,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x104,0x104,0x104,0x105,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x104,0x104,0x104,0x105,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x104,0x104,0x104,0x105,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x108,0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x108,0x10A,0x109,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x104,0x104,0x104,0x105,0x100,0x100,0x102,0x101,
 0x120,0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x120,0x120,0x122,0x121,
 0x120,0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x120,0x120,0x122,0x121,
 0x120,0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x120,0x120,0x122,0x121,
 0x120,0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x124,0x124,0x124,0x125,0x120,0x120,0x122,0x121,
 0x120,0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x120,0x120,0x122,0x121,
 0x120,0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x120,0x120,0x122,0x121,
 0x120,0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x120,0x120,0x122,0x121,
 0x120,0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x124,0x124,0x124,0x125,0x120,0x120,0x122,0x121,
 0x120,0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x120,0x120,0x122,0x121,
 0x120,0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x120,0x120,0x122,0x121,
 0x120,0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x120,0x120,0x122,0x121,
 0x120,0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x124,0x124,0x124,0x125,0x120,0x120,0x122,0x121,
 0x120,0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x120,0x120,0x122,0x121,
 0x120,0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x120,0x120,0x122,0x121,
 0x128,0x128,0x128,0x129,0x128,0x128,0x128,0x129,0x128,0x128,0x128,0x129,0x128,0x128,0x12A,0x129,
 0x120,0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x124,0x124,0x124,0x125,0x120,0x120,0x122,0x121,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x104,0x104,0x104,0x105,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x104,0x104,0x104,0x105,0x100,0x100,0x102,0x101,
 0x110,0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x110,0x110,0x112,0x111,
 0x110,0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x110,0x110,0x112,0x111,
 0x110,0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x110,0x110,0x112,0x111,
 0x110,0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x114,0x114,0x114,0x115,0x110,0x110,0x112,0x111,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x108,0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x108,0x10A,0x109,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x104,0x104,0x104,0x105,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x104,0x104,0x104,0x105,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x104,0x104,0x104,0x105,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x104,0x104,0x104,0x105,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x108,0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x108,0x10A,0x109,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x104,0x104,0x104,0x105,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x104,0x104,0x104,0x105,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x104,0x104,0x104,0x105,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x104,0x104,0x104,0x105,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x108,0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x108,0x10A,0x109,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x104,0x104,0x104,0x105,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x104,0x104,0x104,0x105,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x104,0x104,0x104,0x105,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x104,0x104,0x104,0x105,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x108,0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x108,0x10A,0x109,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x104,0x104,0x104,0x105,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x104,0x104,0x104,0x105,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x104,0x104,0x104,0x105,0x100,0x100,0x102,0x101,
 0x110,0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x110,0x110,0x112,0x111,
 0x110,0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x110,0x110,0x112,0x111,
 0x110,0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x110,0x110,0x112,0x111,
 0x110,0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x114,0x114,0x114,0x115,0x110,0x110,0x112,0x111,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x108,0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x108,0x10A,0x109,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x104,0x104,0x104,0x105,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x104,0x104,0x104,0x105,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x104,0x104,0x104,0x105,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x104,0x104,0x104,0x105,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x108,0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x108,0x10A,0x109,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x104,0x104,0x104,0x105,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x104,0x104,0x104,0x105,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x104,0x104,0x104,0x105,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x104,0x104,0x104,0x105,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x108,0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x108,0x10A,0x109,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x104,0x104,0x104,0x105,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x104,0x104,0x104,0x105,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x104,0x104,0x104,0x105,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x104,0x104,0x104,0x105,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x108,0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x108,0x10A,0x109,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x104,0x104,0x104,0x105,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x104,0x104,0x104,0x105,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x104,0x104,0x104,0x105,0x100,0x100,0x102,0x101,
 0x110,0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x110,0x110,0x112,0x111,
 0x110,0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x110,0x110,0x112,0x111,
 0x110,0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x110,0x110,0x112,0x111,
 0x110,0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x114,0x114,0x114,0x115,0x110,0x110,0x112,0x111,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x108,0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x108,0x10A,0x109,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x104,0x104,0x104,0x105,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x104,0x104,0x104,0x105,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x104,0x104,0x104,0x105,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x104,0x104,0x104,0x105,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x108,0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x108,0x10A,0x109,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x104,0x104,0x104,0x105,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x104,0x104,0x104,0x105,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x104,0x104,0x104,0x105,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x104,0x104,0x104,0x105,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x108,0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x108,0x10A,0x109,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x104,0x104,0x104,0x105,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x104,0x104,0x104,0x105,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x104,0x104,0x104,0x105,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x104,0x104,0x104,0x105,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x108,0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x108,0x10A,0x109,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x104,0x104,0x104,0x105,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x104,0x104,0x104,0x105,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x104,0x104,0x104,0x105,0x100,0x100,0x102,0x101,
 0x110,0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x110,0x110,0x112,0x111,
 0x110,0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x110,0x110,0x112,0x111,
 0x110,0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x110,0x110,0x112,0x111,
 0x110,0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x114,0x114,0x114,0x115,0x110,0x110,0x112,0x111,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x108,0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x108,0x10A,0x109,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x104,0x104,0x104,0x105,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x104,0x104,0x104,0x105,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x104,0x104,0x104,0x105,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x104,0x104,0x104,0x105,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x108,0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x108,0x10A,0x109,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x104,0x104,0x104,0x105,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x104,0x104,0x104,0x105,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x104,0x104,0x104,0x105,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x104,0x104,0x104,0x105,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x108,0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x108,0x10A,0x109,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x104,0x104,0x104,0x105,0x100,0x100,0x102,0x101,
 0x120,0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x120,0x120,0x122,0x121,
 0x120,0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x120,0x120,0x122,0x121,
 0x120,0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x120,0x120,0x122,0x121,
 0x120,0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x124,0x124,0x124,0x125,0x120,0x120,0x122,0x121,
 0x120,0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x120,0x120,0x122,0x121,
 0x120,0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x120,0x120,0x122,0x121,
 0x120,0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x120,0x120,0x122,0x121,
 0x120,0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x124,0x124,0x124,0x125,0x120,0x120,0x122,0x121,
 0x120,0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x120,0x120,0x122,0x121,
 0x120,0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x120,0x120,0x122,0x121,
 0x120,0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x120,0x120,0x122,0x121,
 0x120,0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x124,0x124,0x124,0x125,0x120,0x120,0x122,0x121,
 0x120,0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x120,0x120,0x122,0x121,
 0x120,0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x120,0x120,0x122,0x121,
 0x128,0x128,0x128,0x129,0x128,0x128,0x128,0x129,0x128,0x128,0x128,0x129,0x128,0x128,0x12A,0x129,
 0x120,0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x124,0x124,0x124,0x125,0x120,0x120,0x122,0x121,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x104,0x104,0x104,0x105,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x104,0x104,0x104,0x105,0x100,0x100,0x102,0x101,
 0x110,0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x110,0x110,0x112,0x111,
 0x110,0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x110,0x110,0x112,0x111,
 0x110,0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x110,0x110,0x112,0x111,
 0x110,0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x114,0x114,0x114,0x115,0x110,0x110,0x112,0x111,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x108,0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x108,0x10A,0x109,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x104,0x104,0x104,0x105,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x104,0x104,0x104,0x105,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x104,0x104,0x104,0x105,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x104,0x104,0x104,0x105,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x108,0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x108,0x10A,0x109,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x104,0x104,0x104,0x105,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x104,0x104,0x104,0x105,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x104,0x104,0x104,0x105,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x104,0x104,0x104,0x105,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x108,0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x108,0x10A,0x109,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x104,0x104,0x104,0x105,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x104,0x104,0x104,0x105,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x104,0x104,0x104,0x105,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x104,0x104,0x104,0x105,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x108,0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x108,0x10A,0x109,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x104,0x104,0x104,0x105,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x104,0x104,0x104,0x105,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x104,0x104,0x104,0x105,0x100,0x100,0x102,0x101,
 0x110,0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x110,0x110,0x112,0x111,
 0x110,0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x110,0x110,0x112,0x111,
 0x110,0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x110,0x110,0x112,0x111,
 0x110,0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x114,0x114,0x114,0x115,0x110,0x110,0x112,0x111,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x108,0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x108,0x10A,0x109,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x104,0x104,0x104,0x105,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x104,0x104,0x104,0x105,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x104,0x104,0x104,0x105,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x104,0x104,0x104,0x105,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x108,0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x108,0x10A,0x109,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x104,0x104,0x104,0x105,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x104,0x104,0x104,0x105,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x104,0x104,0x104,0x105,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x104,0x104,0x104,0x105,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x108,0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x108,0x10A,0x109,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x104,0x104,0x104,0x105,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x104,0x104,0x104,0x105,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x104,0x104,0x104,0x105,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x104,0x104,0x104,0x105,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x108,0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x108,0x10A,0x109,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x104,0x104,0x104,0x105,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x104,0x104,0x104,0x105,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x104,0x104,0x104,0x105,0x100,0x100,0x102,0x101,
 0x110,0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x110,0x110,0x112,0x111,
 0x110,0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x110,0x110,0x112,0x111,
 0x110,0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x110,0x110,0x112,0x111,
 0x110,0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x114,0x114,0x114,0x115,0x110,0x110,0x112,0x111,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x108,0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x108,0x10A,0x109,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x104,0x104,0x104,0x105,0x100,0x100,0x102,0x101,
 0x140,0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x140,0x140,0x142,0x141,
 0x140,0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x140,0x140,0x142,0x141,
 0x140,0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x140,0x140,0x142,0x141,
 0x140,0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x144,0x144,0x144,0x145,0x140,0x140,0x142,0x141,
 0x140,0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x140,0x140,0x142,0x141,
 0x140,0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x140,0x140,0x142,0x141,
 0x140,0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x140,0x140,0x142,0x141,
 0x140,0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x144,0x144,0x144,0x145,0x140,0x140,0x142,0x141,
 0x140,0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x140,0x140,0x142,0x141,
 0x140,0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x140,0x140,0x142,0x141,
 0x140,0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x140,0x140,0x142,0x141,
 0x140,0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x144,0x144,0x144,0x145,0x140,0x140,0x142,0x141,
 0x140,0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x140,0x140,0x142,0x141,
 0x140,0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x140,0x140,0x142,0x141,
 0x148,0x148,0x148,0x149,0x148,0x148,0x148,0x149,0x148,0x148,0x148,0x149,0x148,0x148,0x14A,0x149,
 0x140,0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x144,0x144,0x144,0x145,0x140,0x140,0x142,0x141,
 0x140,0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x140,0x140,0x142,0x141,
 0x140,0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x140,0x140,0x142,0x141,
 0x140,0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x140,0x140,0x142,0x141,
 0x140,0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x144,0x144,0x144,0x145,0x140,0x140,0x142,0x141,
 0x140,0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x140,0x140,0x142,0x141,
 0x140,0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x140,0x140,0x142,0x141,
 0x140,0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x140,0x140,0x142,0x141,
 0x140,0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x144,0x144,0x144,0x145,0x140,0x140,0x142,0x141,
 0x140,0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x140,0x140,0x142,0x141,
 0x140,0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x140,0x140,0x142,0x141,
 0x140,0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x140,0x140,0x142,0x141,
 0x140,0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x144,0x144,0x144,0x145,0x140,0x140,0x142,0x141,
 0x140,0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x140,0x140,0x142,0x141,
 0x140,0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x140,0x140,0x142,0x141,
 0x148,0x148,0x148,0x149,0x148,0x148,0x148,0x149,0x148,0x148,0x148,0x149,0x148,0x148,0x14A,0x149,
 0x140,0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x144,0x144,0x144,0x145,0x140,0x140,0x142,0x141,
 0x140,0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x140,0x140,0x142,0x141,
 0x140,0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x140,0x140,0x142,0x141,
 0x140,0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x140,0x140,0x142,0x141,
 0x140,0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x144,0x144,0x144,0x145,0x140,0x140,0x142,0x141,
 0x140,0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x140,0x140,0x142,0x141,
 0x140,0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x140,0x140,0x142,0x141,
 0x140,0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x140,0x140,0x142,0x141,
 0x140,0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x144,0x144,0x144,0x145,0x140,0x140,0x142,0x141,
 0x140,0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x140,0x140,0x142,0x141,
 0x140,0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x140,0x140,0x142,0x141,
 0x140,0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x140,0x140,0x142,0x141,
 0x140,0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x144,0x144,0x144,0x145,0x140,0x140,0x142,0x141,
 0x140,0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x140,0x140,0x142,0x141,
 0x140,0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x140,0x140,0x142,0x141,
 0x148,0x148,0x148,0x149,0x148,0x148,0x148,0x149,0x148,0x148,0x148,0x149,0x148,0x148,0x14A,0x149,
 0x140,0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x144,0x144,0x144,0x145,0x140,0x140,0x142,0x141,
 0x140,0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x140,0x140,0x142,0x141,
 0x140,0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x140,0x140,0x142,0x141,
 0x140,0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x140,0x140,0x142,0x141,
 0x140,0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x144,0x144,0x144,0x145,0x140,0x140,0x142,0x141,
 0x140,0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x140,0x140,0x142,0x141,
 0x140,0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x140,0x140,0x142,0x141,
 0x140,0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x140,0x140,0x142,0x141,
 0x140,0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x144,0x144,0x144,0x145,0x140,0x140,0x142,0x141,
 0x150,0x150,0x150,0x151,0x150,0x150,0x150,0x151,0x150,0x150,0x150,0x151,0x150,0x150,0x152,0x151,
 0x150,0x150,0x150,0x151,0x150,0x150,0x150,0x151,0x150,0x150,0x150,0x151,0x150,0x150,0x152,0x151,
 0x150,0x150,0x150,0x151,0x150,0x150,0x150,0x151,0x150,0x150,0x150,0x151,0x150,0x150,0x152,0x151,
 0x150,0x150,0x150,0x151,0x150,0x150,0x150,0x151,0x154,0x154,0x154,0x155,0x150,0x150,0x152,0x151,
 0x140,0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x140,0x140,0x142,0x141,
 0x140,0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x140,0x140,0x142,0x141,
 0x148,0x148,0x148,0x149,0x148,0x148,0x148,0x149,0x148,0x148,0x148,0x149,0x148,0x148,0x14A,0x149,
 0x140,0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x144,0x144,0x144,0x145,0x140,0x140,0x142,0x141,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x104,0x104,0x104,0x105,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x104,0x104,0x104,0x105,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x104,0x104,0x104,0x105,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x108,0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x108,0x10A,0x109,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x104,0x104,0x104,0x105,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x104,0x104,0x104,0x105,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x104,0x104,0x104,0x105,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x104,0x104,0x104,0x105,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x108,0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x108,0x10A,0x109,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x104,0x104,0x104,0x105,0x100,0x100,0x102,0x101,
 0x120,0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x120,0x120,0x122,0x121,
 0x120,0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x120,0x120,0x122,0x121,
 0x120,0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x120,0x120,0x122,0x121,
 0x120,0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x124,0x124,0x124,0x125,0x120,0x120,0x122,0x121,
 0x120,0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x120,0x120,0x122,0x121,
 0x120,0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x120,0x120,0x122,0x121,
 0x120,0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x120,0x120,0x122,0x121,
 0x120,0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x124,0x124,0x124,0x125,0x120,0x120,0x122,0x121,
 0x120,0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x120,0x120,0x122,0x121,
 0x120,0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x120,0x120,0x122,0x121,
 0x120,0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x120,0x120,0x122,0x121,
 0x120,0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x124,0x124,0x124,0x125,0x120,0x120,0x122,0x121,
 0x120,0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x120,0x120,0x122,0x121,
 0x120,0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x120,0x120,0x122,0x121,
 0x128,0x128,0x128,0x129,0x128,0x128,0x128,0x129,0x128,0x128,0x128,0x129,0x128,0x128,0x12A,0x129,
 0x120,0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x124,0x124,0x124,0x125,0x120,0x120,0x122,0x121,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x104,0x104,0x104,0x105,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x104,0x104,0x104,0x105,0x100,0x100,0x102,0x101,
 0x110,0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x110,0x110,0x112,0x111,
 0x110,0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x110,0x110,0x112,0x111,
 0x110,0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x110,0x110,0x112,0x111,
 0x110,0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x114,0x114,0x114,0x115,0x110,0x110,0x112,0x111,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x100,0x102,0x101,
 0x108,0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x108,0x10A,0x109,
 0x100,0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x104,0x104,0x104,0x105,0x100,0x100,0x102,0x101,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x00A,0x009,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x00A,0x009,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x00A,0x009,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x012,0x011,
 0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x012,0x011,
 0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x012,0x011,
 0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x014,0x014,0x014,0x015,0x010,0x010,0x012,0x011,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x00A,0x009,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x00A,0x009,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x00A,0x009,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x00A,0x009,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x012,0x011,
 0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x012,0x011,
 0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x012,0x011,
 0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x014,0x014,0x014,0x015,0x010,0x010,0x012,0x011,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x00A,0x009,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x00A,0x009,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x00A,0x009,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x00A,0x009,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x012,0x011,
 0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x012,0x011,
 0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x012,0x011,
 0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x014,0x014,0x014,0x015,0x010,0x010,0x012,0x011,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x00A,0x009,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x00A,0x009,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x00A,0x009,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x022,0x021,
 0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x022,0x021,
 0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x022,0x021,
 0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x024,0x024,0x024,0x025,0x020,0x020,0x022,0x021,
 0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x022,0x021,
 0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x022,0x021,
 0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x022,0x021,
 0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x024,0x024,0x024,0x025,0x020,0x020,0x022,0x021,
 0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x022,0x021,
 0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x022,0x021,
 0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x022,0x021,
 0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x024,0x024,0x024,0x025,0x020,0x020,0x022,0x021,
 0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x022,0x021,
 0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x022,0x021,
 0x028,0x028,0x028,0x029,0x028,0x028,0x028,0x029,0x028,0x028,0x028,0x029,0x028,0x028,0x02A,0x029,
 0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x024,0x024,0x024,0x025,0x020,0x020,0x022,0x021,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x012,0x011,
 0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x012,0x011,
 0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x012,0x011,
 0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x014,0x014,0x014,0x015,0x010,0x010,0x012,0x011,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x00A,0x009,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x00A,0x009,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x00A,0x009,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x00A,0x009,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x012,0x011,
 0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x012,0x011,
 0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x012,0x011,
 0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x014,0x014,0x014,0x015,0x010,0x010,0x012,0x011,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x00A,0x009,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x00A,0x009,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x00A,0x009,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x00A,0x009,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x012,0x011,
 0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x012,0x011,
 0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x012,0x011,
 0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x014,0x014,0x014,0x015,0x010,0x010,0x012,0x011,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x00A,0x009,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x00A,0x009,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x00A,0x009,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x00A,0x009,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x012,0x011,
 0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x012,0x011,
 0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x012,0x011,
 0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x014,0x014,0x014,0x015,0x010,0x010,0x012,0x011,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x00A,0x009,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x00A,0x009,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x00A,0x009,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x022,0x021,
 0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x022,0x021,
 0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x022,0x021,
 0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x024,0x024,0x024,0x025,0x020,0x020,0x022,0x021,
 0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x022,0x021,
 0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x022,0x021,
 0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x022,0x021,
 0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x024,0x024,0x024,0x025,0x020,0x020,0x022,0x021,
 0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x022,0x021,
 0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x022,0x021,
 0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x022,0x021,
 0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x024,0x024,0x024,0x025,0x020,0x020,0x022,0x021,
 0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x022,0x021,
 0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x022,0x021,
 0x028,0x028,0x028,0x029,0x028,0x028,0x028,0x029,0x028,0x028,0x028,0x029,0x028,0x028,0x02A,0x029,
 0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x024,0x024,0x024,0x025,0x020,0x020,0x022,0x021,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x012,0x011,
 0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x012,0x011,
 0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x012,0x011,
 0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x014,0x014,0x014,0x015,0x010,0x010,0x012,0x011,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x00A,0x009,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x082,0x081,
 0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x082,0x081,
 0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x082,0x081,
 0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x084,0x084,0x084,0x085,0x080,0x080,0x082,0x081,
 0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x082,0x081,
 0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x082,0x081,
 0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x082,0x081,
 0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x084,0x084,0x084,0x085,0x080,0x080,0x082,0x081,
 0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x082,0x081,
 0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x082,0x081,
 0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x082,0x081,
 0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x084,0x084,0x084,0x085,0x080,0x080,0x082,0x081,
 0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x082,0x081,
 0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x082,0x081,
 0x088,0x088,0x088,0x089,0x088,0x088,0x088,0x089,0x088,0x088,0x088,0x089,0x088,0x088,0x08A,0x089,
 0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x084,0x084,0x084,0x085,0x080,0x080,0x082,0x081,
 0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x082,0x081,
 0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x082,0x081,
 0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x082,0x081,
 0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x084,0x084,0x084,0x085,0x080,0x080,0x082,0x081,
 0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x082,0x081,
 0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x082,0x081,
 0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x082,0x081,
 0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x084,0x084,0x084,0x085,0x080,0x080,0x082,0x081,
 0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x082,0x081,
 0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x082,0x081,
 0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x082,0x081,
 0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x084,0x084,0x084,0x085,0x080,0x080,0x082,0x081,
 0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x082,0x081,
 0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x082,0x081,
 0x088,0x088,0x088,0x089,0x088,0x088,0x088,0x089,0x088,0x088,0x088,0x089,0x088,0x088,0x08A,0x089,
 0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x084,0x084,0x084,0x085,0x080,0x080,0x082,0x081,
 0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x082,0x081,
 0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x082,0x081,
 0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x082,0x081,
 0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x084,0x084,0x084,0x085,0x080,0x080,0x082,0x081,
 0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x082,0x081,
 0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x082,0x081,
 0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x082,0x081,
 0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x084,0x084,0x084,0x085,0x080,0x080,0x082,0x081,
 0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x082,0x081,
 0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x082,0x081,
 0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x082,0x081,
 0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x084,0x084,0x084,0x085,0x080,0x080,0x082,0x081,
 0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x082,0x081,
 0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x082,0x081,
 0x088,0x088,0x088,0x089,0x088,0x088,0x088,0x089,0x088,0x088,0x088,0x089,0x088,0x088,0x08A,0x089,
 0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x084,0x084,0x084,0x085,0x080,0x080,0x082,0x081,
 0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x082,0x081,
 0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x082,0x081,
 0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x082,0x081,
 0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x084,0x084,0x084,0x085,0x080,0x080,0x082,0x081,
 0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x082,0x081,
 0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x082,0x081,
 0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x082,0x081,
 0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x084,0x084,0x084,0x085,0x080,0x080,0x082,0x081,
 0x090,0x090,0x090,0x091,0x090,0x090,0x090,0x091,0x090,0x090,0x090,0x091,0x090,0x090,0x092,0x091,
 0x090,0x090,0x090,0x091,0x090,0x090,0x090,0x091,0x090,0x090,0x090,0x091,0x090,0x090,0x092,0x091,
 0x090,0x090,0x090,0x091,0x090,0x090,0x090,0x091,0x090,0x090,0x090,0x091,0x090,0x090,0x092,0x091,
 0x090,0x090,0x090,0x091,0x090,0x090,0x090,0x091,0x094,0x094,0x094,0x095,0x090,0x090,0x092,0x091,
 0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x082,0x081,
 0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x082,0x081,
 0x088,0x088,0x088,0x089,0x088,0x088,0x088,0x089,0x088,0x088,0x088,0x089,0x088,0x088,0x08A,0x089,
 0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x084,0x084,0x084,0x085,0x080,0x080,0x082,0x081,
 0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x082,0x081,
 0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x082,0x081,
 0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x082,0x081,
 0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x084,0x084,0x084,0x085,0x080,0x080,0x082,0x081,
 0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x082,0x081,
 0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x082,0x081,
 0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x082,0x081,
 0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x084,0x084,0x084,0x085,0x080,0x080,0x082,0x081,
 0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x082,0x081,
 0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x082,0x081,
 0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x082,0x081,
 0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x084,0x084,0x084,0x085,0x080,0x080,0x082,0x081,
 0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x082,0x081,
 0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x082,0x081,
 0x088,0x088,0x088,0x089,0x088,0x088,0x088,0x089,0x088,0x088,0x088,0x089,0x088,0x088,0x08A,0x089,
 0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x084,0x084,0x084,0x085,0x080,0x080,0x082,0x081,
 0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x082,0x081,
 0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x082,0x081,
 0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x082,0x081,
 0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x084,0x084,0x084,0x085,0x080,0x080,0x082,0x081,
 0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x082,0x081,
 0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x082,0x081,
 0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x082,0x081,
 0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x084,0x084,0x084,0x085,0x080,0x080,0x082,0x081,
 0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x082,0x081,
 0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x082,0x081,
 0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x082,0x081,
 0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x084,0x084,0x084,0x085,0x080,0x080,0x082,0x081,
 0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x082,0x081,
 0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x082,0x081,
 0x088,0x088,0x088,0x089,0x088,0x088,0x088,0x089,0x088,0x088,0x088,0x089,0x088,0x088,0x08A,0x089,
 0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x084,0x084,0x084,0x085,0x080,0x080,0x082,0x081,
 0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x082,0x081,
 0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x082,0x081,
 0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x082,0x081,
 0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x084,0x084,0x084,0x085,0x080,0x080,0x082,0x081,
 0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x082,0x081,
 0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x082,0x081,
 0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x082,0x081,
 0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x084,0x084,0x084,0x085,0x080,0x080,0x082,0x081,
 0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x082,0x081,
 0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x082,0x081,
 0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x082,0x081,
 0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x084,0x084,0x084,0x085,0x080,0x080,0x082,0x081,
 0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x082,0x081,
 0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x082,0x081,
 0x088,0x088,0x088,0x089,0x088,0x088,0x088,0x089,0x088,0x088,0x088,0x089,0x088,0x088,0x08A,0x089,
 0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x084,0x084,0x084,0x085,0x080,0x080,0x082,0x081,
 0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x082,0x081,
 0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x082,0x081,
 0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x082,0x081,
 0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x084,0x084,0x084,0x085,0x080,0x080,0x082,0x081,
 0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x082,0x081,
 0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x082,0x081,
 0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x082,0x081,
 0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x084,0x084,0x084,0x085,0x080,0x080,0x082,0x081,
 0x090,0x090,0x090,0x091,0x090,0x090,0x090,0x091,0x090,0x090,0x090,0x091,0x090,0x090,0x092,0x091,
 0x090,0x090,0x090,0x091,0x090,0x090,0x090,0x091,0x090,0x090,0x090,0x091,0x090,0x090,0x092,0x091,
 0x090,0x090,0x090,0x091,0x090,0x090,0x090,0x091,0x090,0x090,0x090,0x091,0x090,0x090,0x092,0x091,
 0x090,0x090,0x090,0x091,0x090,0x090,0x090,0x091,0x094,0x094,0x094,0x095,0x090,0x090,0x092,0x091,
 0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x082,0x081,
 0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x082,0x081,
 0x088,0x088,0x088,0x089,0x088,0x088,0x088,0x089,0x088,0x088,0x088,0x089,0x088,0x088,0x08A,0x089,
 0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x084,0x084,0x084,0x085,0x080,0x080,0x082,0x081,
 0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x082,0x081,
 0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x082,0x081,
 0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x082,0x081,
 0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x084,0x084,0x084,0x085,0x080,0x080,0x082,0x081,
 0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x082,0x081,
 0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x082,0x081,
 0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x082,0x081,
 0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x084,0x084,0x084,0x085,0x080,0x080,0x082,0x081,
 0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x082,0x081,
 0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x082,0x081,
 0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x082,0x081,
 0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x084,0x084,0x084,0x085,0x080,0x080,0x082,0x081,
 0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x082,0x081,
 0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x082,0x081,
 0x088,0x088,0x088,0x089,0x088,0x088,0x088,0x089,0x088,0x088,0x088,0x089,0x088,0x088,0x08A,0x089,
 0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x084,0x084,0x084,0x085,0x080,0x080,0x082,0x081,
 0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x082,0x081,
 0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x082,0x081,
 0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x082,0x081,
 0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x084,0x084,0x084,0x085,0x080,0x080,0x082,0x081,
 0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x082,0x081,
 0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x082,0x081,
 0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x082,0x081,
 0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x084,0x084,0x084,0x085,0x080,0x080,0x082,0x081,
 0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x082,0x081,
 0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x082,0x081,
 0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x082,0x081,
 0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x084,0x084,0x084,0x085,0x080,0x080,0x082,0x081,
 0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x082,0x081,
 0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x082,0x081,
 0x088,0x088,0x088,0x089,0x088,0x088,0x088,0x089,0x088,0x088,0x088,0x089,0x088,0x088,0x08A,0x089,
 0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x084,0x084,0x084,0x085,0x080,0x080,0x082,0x081,
 0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x082,0x081,
 0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x082,0x081,
 0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x082,0x081,
 0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x084,0x084,0x084,0x085,0x080,0x080,0x082,0x081,
 0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x082,0x081,
 0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x082,0x081,
 0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x082,0x081,
 0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x084,0x084,0x084,0x085,0x080,0x080,0x082,0x081,
 0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x082,0x081,
 0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x082,0x081,
 0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x082,0x081,
 0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x084,0x084,0x084,0x085,0x080,0x080,0x082,0x081,
 0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x082,0x081,
 0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x082,0x081,
 0x088,0x088,0x088,0x089,0x088,0x088,0x088,0x089,0x088,0x088,0x088,0x089,0x088,0x088,0x08A,0x089,
 0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x084,0x084,0x084,0x085,0x080,0x080,0x082,0x081,
 0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x082,0x081,
 0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x082,0x081,
 0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x082,0x081,
 0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x084,0x084,0x084,0x085,0x080,0x080,0x082,0x081,
 0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x082,0x081,
 0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x082,0x081,
 0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x082,0x081,
 0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x084,0x084,0x084,0x085,0x080,0x080,0x082,0x081,
 0x090,0x090,0x090,0x091,0x090,0x090,0x090,0x091,0x090,0x090,0x090,0x091,0x090,0x090,0x092,0x091,
 0x090,0x090,0x090,0x091,0x090,0x090,0x090,0x091,0x090,0x090,0x090,0x091,0x090,0x090,0x092,0x091,
 0x090,0x090,0x090,0x091,0x090,0x090,0x090,0x091,0x090,0x090,0x090,0x091,0x090,0x090,0x092,0x091,
 0x090,0x090,0x090,0x091,0x090,0x090,0x090,0x091,0x094,0x094,0x094,0x095,0x090,0x090,0x092,0x091,
 0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x082,0x081,
 0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x082,0x081,
 0x088,0x088,0x088,0x089,0x088,0x088,0x088,0x089,0x088,0x088,0x088,0x089,0x088,0x088,0x08A,0x089,
 0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x084,0x084,0x084,0x085,0x080,0x080,0x082,0x081,
 0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x082,0x081,
 0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x082,0x081,
 0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x082,0x081,
 0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x084,0x084,0x084,0x085,0x080,0x080,0x082,0x081,
 0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x082,0x081,
 0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x082,0x081,
 0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x082,0x081,
 0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x084,0x084,0x084,0x085,0x080,0x080,0x082,0x081,
 0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x082,0x081,
 0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x082,0x081,
 0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x082,0x081,
 0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x084,0x084,0x084,0x085,0x080,0x080,0x082,0x081,
 0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x082,0x081,
 0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x082,0x081,
 0x088,0x088,0x088,0x089,0x088,0x088,0x088,0x089,0x088,0x088,0x088,0x089,0x088,0x088,0x08A,0x089,
 0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x084,0x084,0x084,0x085,0x080,0x080,0x082,0x081,
 0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x082,0x081,
 0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x082,0x081,
 0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x082,0x081,
 0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x084,0x084,0x084,0x085,0x080,0x080,0x082,0x081,
 0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x082,0x081,
 0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x082,0x081,
 0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x082,0x081,
 0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x084,0x084,0x084,0x085,0x080,0x080,0x082,0x081,
 0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x082,0x081,
 0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x082,0x081,
 0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x082,0x081,
 0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x084,0x084,0x084,0x085,0x080,0x080,0x082,0x081,
 0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x082,0x081,
 0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x082,0x081,
 0x088,0x088,0x088,0x089,0x088,0x088,0x088,0x089,0x088,0x088,0x088,0x089,0x088,0x088,0x08A,0x089,
 0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x084,0x084,0x084,0x085,0x080,0x080,0x082,0x081,
 0x0A0,0x0A0,0x0A0,0x0A1,0x0A0,0x0A0,0x0A0,0x0A1,0x0A0,0x0A0,0x0A0,0x0A1,0x0A0,0x0A0,0x0A2,0x0A1,
 0x0A0,0x0A0,0x0A0,0x0A1,0x0A0,0x0A0,0x0A0,0x0A1,0x0A0,0x0A0,0x0A0,0x0A1,0x0A0,0x0A0,0x0A2,0x0A1,
 0x0A0,0x0A0,0x0A0,0x0A1,0x0A0,0x0A0,0x0A0,0x0A1,0x0A0,0x0A0,0x0A0,0x0A1,0x0A0,0x0A0,0x0A2,0x0A1,
 0x0A0,0x0A0,0x0A0,0x0A1,0x0A0,0x0A0,0x0A0,0x0A1,0x0A4,0x0A4,0x0A4,0x0A5,0x0A0,0x0A0,0x0A2,0x0A1,
 0x0A0,0x0A0,0x0A0,0x0A1,0x0A0,0x0A0,0x0A0,0x0A1,0x0A0,0x0A0,0x0A0,0x0A1,0x0A0,0x0A0,0x0A2,0x0A1,
 0x0A0,0x0A0,0x0A0,0x0A1,0x0A0,0x0A0,0x0A0,0x0A1,0x0A0,0x0A0,0x0A0,0x0A1,0x0A0,0x0A0,0x0A2,0x0A1,
 0x0A0,0x0A0,0x0A0,0x0A1,0x0A0,0x0A0,0x0A0,0x0A1,0x0A0,0x0A0,0x0A0,0x0A1,0x0A0,0x0A0,0x0A2,0x0A1,
 0x0A0,0x0A0,0x0A0,0x0A1,0x0A0,0x0A0,0x0A0,0x0A1,0x0A4,0x0A4,0x0A4,0x0A5,0x0A0,0x0A0,0x0A2,0x0A1,
 0x0A0,0x0A0,0x0A0,0x0A1,0x0A0,0x0A0,0x0A0,0x0A1,0x0A0,0x0A0,0x0A0,0x0A1,0x0A0,0x0A0,0x0A2,0x0A1,
 0x0A0,0x0A0,0x0A0,0x0A1,0x0A0,0x0A0,0x0A0,0x0A1,0x0A0,0x0A0,0x0A0,0x0A1,0x0A0,0x0A0,0x0A2,0x0A1,
 0x0A0,0x0A0,0x0A0,0x0A1,0x0A0,0x0A0,0x0A0,0x0A1,0x0A0,0x0A0,0x0A0,0x0A1,0x0A0,0x0A0,0x0A2,0x0A1,
 0x0A0,0x0A0,0x0A0,0x0A1,0x0A0,0x0A0,0x0A0,0x0A1,0x0A4,0x0A4,0x0A4,0x0A5,0x0A0,0x0A0,0x0A2,0x0A1,
 0x0A0,0x0A0,0x0A0,0x0A1,0x0A0,0x0A0,0x0A0,0x0A1,0x0A0,0x0A0,0x0A0,0x0A1,0x0A0,0x0A0,0x0A2,0x0A1,
 0x0A0,0x0A0,0x0A0,0x0A1,0x0A0,0x0A0,0x0A0,0x0A1,0x0A0,0x0A0,0x0A0,0x0A1,0x0A0,0x0A0,0x0A2,0x0A1,
 0x0A8,0x0A8,0x0A8,0x0A9,0x0A8,0x0A8,0x0A8,0x0A9,0x0A8,0x0A8,0x0A8,0x0A9,0x0A8,0x0A8,0x0AA,0x0A9,
 0x0A0,0x0A0,0x0A0,0x0A1,0x0A0,0x0A0,0x0A0,0x0A1,0x0A4,0x0A4,0x0A4,0x0A5,0x0A0,0x0A0,0x0A2,0x0A1,
 0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x082,0x081,
 0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x082,0x081,
 0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x082,0x081,
 0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x084,0x084,0x084,0x085,0x080,0x080,0x082,0x081,
 0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x082,0x081,
 0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x082,0x081,
 0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x082,0x081,
 0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x084,0x084,0x084,0x085,0x080,0x080,0x082,0x081,
 0x090,0x090,0x090,0x091,0x090,0x090,0x090,0x091,0x090,0x090,0x090,0x091,0x090,0x090,0x092,0x091,
 0x090,0x090,0x090,0x091,0x090,0x090,0x090,0x091,0x090,0x090,0x090,0x091,0x090,0x090,0x092,0x091,
 0x090,0x090,0x090,0x091,0x090,0x090,0x090,0x091,0x090,0x090,0x090,0x091,0x090,0x090,0x092,0x091,
 0x090,0x090,0x090,0x091,0x090,0x090,0x090,0x091,0x094,0x094,0x094,0x095,0x090,0x090,0x092,0x091,
 0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x082,0x081,
 0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x080,0x080,0x082,0x081,
 0x088,0x088,0x088,0x089,0x088,0x088,0x088,0x089,0x088,0x088,0x088,0x089,0x088,0x088,0x08A,0x089,
 0x080,0x080,0x080,0x081,0x080,0x080,0x080,0x081,0x084,0x084,0x084,0x085,0x080,0x080,0x082,0x081,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x00A,0x009,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x00A,0x009,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x00A,0x009,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x012,0x011,
 0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x012,0x011,
 0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x012,0x011,
 0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x014,0x014,0x014,0x015,0x010,0x010,0x012,0x011,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x00A,0x009,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x00A,0x009,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x00A,0x009,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x00A,0x009,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x012,0x011,
 0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x012,0x011,
 0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x012,0x011,
 0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x014,0x014,0x014,0x015,0x010,0x010,0x012,0x011,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x00A,0x009,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x042,0x041,
 0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x042,0x041,
 0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x042,0x041,
 0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x044,0x044,0x044,0x045,0x040,0x040,0x042,0x041,
 0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x042,0x041,
 0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x042,0x041,
 0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x042,0x041,
 0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x044,0x044,0x044,0x045,0x040,0x040,0x042,0x041,
 0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x042,0x041,
 0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x042,0x041,
 0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x042,0x041,
 0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x044,0x044,0x044,0x045,0x040,0x040,0x042,0x041,
 0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x042,0x041,
 0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x042,0x041,
 0x048,0x048,0x048,0x049,0x048,0x048,0x048,0x049,0x048,0x048,0x048,0x049,0x048,0x048,0x04A,0x049,
 0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x044,0x044,0x044,0x045,0x040,0x040,0x042,0x041,
 0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x042,0x041,
 0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x042,0x041,
 0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x042,0x041,
 0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x044,0x044,0x044,0x045,0x040,0x040,0x042,0x041,
 0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x042,0x041,
 0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x042,0x041,
 0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x042,0x041,
 0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x044,0x044,0x044,0x045,0x040,0x040,0x042,0x041,
 0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x042,0x041,
 0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x042,0x041,
 0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x042,0x041,
 0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x044,0x044,0x044,0x045,0x040,0x040,0x042,0x041,
 0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x042,0x041,
 0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x042,0x041,
 0x048,0x048,0x048,0x049,0x048,0x048,0x048,0x049,0x048,0x048,0x048,0x049,0x048,0x048,0x04A,0x049,
 0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x044,0x044,0x044,0x045,0x040,0x040,0x042,0x041,
 0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x042,0x041,
 0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x042,0x041,
 0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x042,0x041,
 0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x044,0x044,0x044,0x045,0x040,0x040,0x042,0x041,
 0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x042,0x041,
 0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x042,0x041,
 0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x042,0x041,
 0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x044,0x044,0x044,0x045,0x040,0x040,0x042,0x041,
 0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x042,0x041,
 0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x042,0x041,
 0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x042,0x041,
 0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x044,0x044,0x044,0x045,0x040,0x040,0x042,0x041,
 0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x042,0x041,
 0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x042,0x041,
 0x048,0x048,0x048,0x049,0x048,0x048,0x048,0x049,0x048,0x048,0x048,0x049,0x048,0x048,0x04A,0x049,
 0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x044,0x044,0x044,0x045,0x040,0x040,0x042,0x041,
 0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x042,0x041,
 0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x042,0x041,
 0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x042,0x041,
 0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x044,0x044,0x044,0x045,0x040,0x040,0x042,0x041,
 0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x042,0x041,
 0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x042,0x041,
 0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x042,0x041,
 0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x044,0x044,0x044,0x045,0x040,0x040,0x042,0x041,
 0x050,0x050,0x050,0x051,0x050,0x050,0x050,0x051,0x050,0x050,0x050,0x051,0x050,0x050,0x052,0x051,
 0x050,0x050,0x050,0x051,0x050,0x050,0x050,0x051,0x050,0x050,0x050,0x051,0x050,0x050,0x052,0x051,
 0x050,0x050,0x050,0x051,0x050,0x050,0x050,0x051,0x050,0x050,0x050,0x051,0x050,0x050,0x052,0x051,
 0x050,0x050,0x050,0x051,0x050,0x050,0x050,0x051,0x054,0x054,0x054,0x055,0x050,0x050,0x052,0x051,
 0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x042,0x041,
 0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x040,0x042,0x041,
 0x048,0x048,0x048,0x049,0x048,0x048,0x048,0x049,0x048,0x048,0x048,0x049,0x048,0x048,0x04A,0x049,
 0x040,0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x044,0x044,0x044,0x045,0x040,0x040,0x042,0x041,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x00A,0x009,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x00A,0x009,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x022,0x021,
 0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x022,0x021,
 0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x022,0x021,
 0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x024,0x024,0x024,0x025,0x020,0x020,0x022,0x021,
 0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x022,0x021,
 0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x022,0x021,
 0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x022,0x021,
 0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x024,0x024,0x024,0x025,0x020,0x020,0x022,0x021,
 0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x022,0x021,
 0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x022,0x021,
 0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x022,0x021,
 0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x024,0x024,0x024,0x025,0x020,0x020,0x022,0x021,
 0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x022,0x021,
 0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x020,0x022,0x021,
 0x028,0x028,0x028,0x029,0x028,0x028,0x028,0x029,0x028,0x028,0x028,0x029,0x028,0x028,0x02A,0x029,
 0x020,0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x024,0x024,0x024,0x025,0x020,0x020,0x022,0x021,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
 0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x012,0x011,
 0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x012,0x011,
 0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x010,0x012,0x011,
 0x010,0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x014,0x014,0x014,0x015,0x010,0x010,0x012,0x011,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x000,0x002,0x001,
 0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x008,0x00A,0x009,
 0x000,0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x004,0x004,0x004,0x005,0x000,0x000,0x002,0x001,
};


static const Genomecomp_T donor_gtgc_bits[] =
{0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x028,0x029,0x028,0x029,0x028,0x029,0x02A,0x029,0x028,0x029,0x028,0x029,0x028,0x029,0x02A,0x029,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x028,0x029,0x028,0x029,0x028,0x029,0x02A,0x029,0x028,0x029,0x028,0x029,0x028,0x029,0x02A,0x029,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x028,0x029,0x028,0x029,0x028,0x029,0x02A,0x029,0x028,0x029,0x028,0x029,0x028,0x029,0x02A,0x029,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x028,0x029,0x028,0x029,0x028,0x029,0x02A,0x029,0x028,0x029,0x028,0x029,0x028,0x029,0x02A,0x029,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x028,0x029,0x028,0x029,0x028,0x029,0x02A,0x029,0x028,0x029,0x028,0x029,0x028,0x029,0x02A,0x029,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x028,0x029,0x028,0x029,0x028,0x029,0x02A,0x029,0x028,0x029,0x028,0x029,0x028,0x029,0x02A,0x029,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x048,0x049,0x048,0x049,0x048,0x049,0x04A,0x049,0x048,0x049,0x048,0x049,0x048,0x049,0x04A,0x049,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x048,0x049,0x048,0x049,0x048,0x049,0x04A,0x049,0x048,0x049,0x048,0x049,0x048,0x049,0x04A,0x049,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x048,0x049,0x048,0x049,0x048,0x049,0x04A,0x049,0x048,0x049,0x048,0x049,0x048,0x049,0x04A,0x049,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x050,0x051,0x050,0x051,0x050,0x051,0x052,0x051,0x050,0x051,0x050,0x051,0x050,0x051,0x052,0x051,
 0x050,0x051,0x050,0x051,0x050,0x051,0x052,0x051,0x054,0x055,0x054,0x055,0x050,0x051,0x052,0x051,
 0x050,0x051,0x050,0x051,0x050,0x051,0x052,0x051,0x050,0x051,0x050,0x051,0x050,0x051,0x052,0x051,
 0x050,0x051,0x050,0x051,0x050,0x051,0x052,0x051,0x054,0x055,0x054,0x055,0x050,0x051,0x052,0x051,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x048,0x049,0x048,0x049,0x048,0x049,0x04A,0x049,0x048,0x049,0x048,0x049,0x048,0x049,0x04A,0x049,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x048,0x049,0x048,0x049,0x048,0x049,0x04A,0x049,0x048,0x049,0x048,0x049,0x048,0x049,0x04A,0x049,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x048,0x049,0x048,0x049,0x048,0x049,0x04A,0x049,0x048,0x049,0x048,0x049,0x048,0x049,0x04A,0x049,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x048,0x049,0x048,0x049,0x048,0x049,0x04A,0x049,0x048,0x049,0x048,0x049,0x048,0x049,0x04A,0x049,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x050,0x051,0x050,0x051,0x050,0x051,0x052,0x051,0x050,0x051,0x050,0x051,0x050,0x051,0x052,0x051,
 0x050,0x051,0x050,0x051,0x050,0x051,0x052,0x051,0x054,0x055,0x054,0x055,0x050,0x051,0x052,0x051,
 0x050,0x051,0x050,0x051,0x050,0x051,0x052,0x051,0x050,0x051,0x050,0x051,0x050,0x051,0x052,0x051,
 0x050,0x051,0x050,0x051,0x050,0x051,0x052,0x051,0x054,0x055,0x054,0x055,0x050,0x051,0x052,0x051,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x048,0x049,0x048,0x049,0x048,0x049,0x04A,0x049,0x048,0x049,0x048,0x049,0x048,0x049,0x04A,0x049,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x028,0x029,0x028,0x029,0x028,0x029,0x02A,0x029,0x028,0x029,0x028,0x029,0x028,0x029,0x02A,0x029,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x028,0x029,0x028,0x029,0x028,0x029,0x02A,0x029,0x028,0x029,0x028,0x029,0x028,0x029,0x02A,0x029,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x028,0x029,0x028,0x029,0x028,0x029,0x02A,0x029,0x028,0x029,0x028,0x029,0x028,0x029,0x02A,0x029,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x028,0x029,0x028,0x029,0x028,0x029,0x02A,0x029,0x028,0x029,0x028,0x029,0x028,0x029,0x02A,0x029,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x028,0x029,0x028,0x029,0x028,0x029,0x02A,0x029,0x028,0x029,0x028,0x029,0x028,0x029,0x02A,0x029,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x028,0x029,0x028,0x029,0x028,0x029,0x02A,0x029,0x028,0x029,0x028,0x029,0x028,0x029,0x02A,0x029,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x028,0x029,0x028,0x029,0x028,0x029,0x02A,0x029,0x028,0x029,0x028,0x029,0x028,0x029,0x02A,0x029,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x028,0x029,0x028,0x029,0x028,0x029,0x02A,0x029,0x028,0x029,0x028,0x029,0x028,0x029,0x02A,0x029,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x048,0x049,0x048,0x049,0x048,0x049,0x04A,0x049,0x048,0x049,0x048,0x049,0x048,0x049,0x04A,0x049,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x048,0x049,0x048,0x049,0x048,0x049,0x04A,0x049,0x048,0x049,0x048,0x049,0x048,0x049,0x04A,0x049,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x048,0x049,0x048,0x049,0x048,0x049,0x04A,0x049,0x048,0x049,0x048,0x049,0x048,0x049,0x04A,0x049,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x050,0x051,0x050,0x051,0x050,0x051,0x052,0x051,0x050,0x051,0x050,0x051,0x050,0x051,0x052,0x051,
 0x050,0x051,0x050,0x051,0x050,0x051,0x052,0x051,0x054,0x055,0x054,0x055,0x050,0x051,0x052,0x051,
 0x050,0x051,0x050,0x051,0x050,0x051,0x052,0x051,0x050,0x051,0x050,0x051,0x050,0x051,0x052,0x051,
 0x050,0x051,0x050,0x051,0x050,0x051,0x052,0x051,0x054,0x055,0x054,0x055,0x050,0x051,0x052,0x051,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x048,0x049,0x048,0x049,0x048,0x049,0x04A,0x049,0x048,0x049,0x048,0x049,0x048,0x049,0x04A,0x049,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x048,0x049,0x048,0x049,0x048,0x049,0x04A,0x049,0x048,0x049,0x048,0x049,0x048,0x049,0x04A,0x049,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x048,0x049,0x048,0x049,0x048,0x049,0x04A,0x049,0x048,0x049,0x048,0x049,0x048,0x049,0x04A,0x049,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x048,0x049,0x048,0x049,0x048,0x049,0x04A,0x049,0x048,0x049,0x048,0x049,0x048,0x049,0x04A,0x049,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x050,0x051,0x050,0x051,0x050,0x051,0x052,0x051,0x050,0x051,0x050,0x051,0x050,0x051,0x052,0x051,
 0x050,0x051,0x050,0x051,0x050,0x051,0x052,0x051,0x054,0x055,0x054,0x055,0x050,0x051,0x052,0x051,
 0x050,0x051,0x050,0x051,0x050,0x051,0x052,0x051,0x050,0x051,0x050,0x051,0x050,0x051,0x052,0x051,
 0x050,0x051,0x050,0x051,0x050,0x051,0x052,0x051,0x054,0x055,0x054,0x055,0x050,0x051,0x052,0x051,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x048,0x049,0x048,0x049,0x048,0x049,0x04A,0x049,0x048,0x049,0x048,0x049,0x048,0x049,0x04A,0x049,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x028,0x029,0x028,0x029,0x028,0x029,0x02A,0x029,0x028,0x029,0x028,0x029,0x028,0x029,0x02A,0x029,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x028,0x029,0x028,0x029,0x028,0x029,0x02A,0x029,0x028,0x029,0x028,0x029,0x028,0x029,0x02A,0x029,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x028,0x029,0x028,0x029,0x028,0x029,0x02A,0x029,0x028,0x029,0x028,0x029,0x028,0x029,0x02A,0x029,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x028,0x029,0x028,0x029,0x028,0x029,0x02A,0x029,0x028,0x029,0x028,0x029,0x028,0x029,0x02A,0x029,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x028,0x029,0x028,0x029,0x028,0x029,0x02A,0x029,0x028,0x029,0x028,0x029,0x028,0x029,0x02A,0x029,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x028,0x029,0x028,0x029,0x028,0x029,0x02A,0x029,0x028,0x029,0x028,0x029,0x028,0x029,0x02A,0x029,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x028,0x029,0x028,0x029,0x028,0x029,0x02A,0x029,0x028,0x029,0x028,0x029,0x028,0x029,0x02A,0x029,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x028,0x029,0x028,0x029,0x028,0x029,0x02A,0x029,0x028,0x029,0x028,0x029,0x028,0x029,0x02A,0x029,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x048,0x049,0x048,0x049,0x048,0x049,0x04A,0x049,0x048,0x049,0x048,0x049,0x048,0x049,0x04A,0x049,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x048,0x049,0x048,0x049,0x048,0x049,0x04A,0x049,0x048,0x049,0x048,0x049,0x048,0x049,0x04A,0x049,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x048,0x049,0x048,0x049,0x048,0x049,0x04A,0x049,0x048,0x049,0x048,0x049,0x048,0x049,0x04A,0x049,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x050,0x051,0x050,0x051,0x050,0x051,0x052,0x051,0x050,0x051,0x050,0x051,0x050,0x051,0x052,0x051,
 0x050,0x051,0x050,0x051,0x050,0x051,0x052,0x051,0x054,0x055,0x054,0x055,0x050,0x051,0x052,0x051,
 0x050,0x051,0x050,0x051,0x050,0x051,0x052,0x051,0x050,0x051,0x050,0x051,0x050,0x051,0x052,0x051,
 0x050,0x051,0x050,0x051,0x050,0x051,0x052,0x051,0x054,0x055,0x054,0x055,0x050,0x051,0x052,0x051,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x048,0x049,0x048,0x049,0x048,0x049,0x04A,0x049,0x048,0x049,0x048,0x049,0x048,0x049,0x04A,0x049,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x048,0x049,0x048,0x049,0x048,0x049,0x04A,0x049,0x048,0x049,0x048,0x049,0x048,0x049,0x04A,0x049,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x048,0x049,0x048,0x049,0x048,0x049,0x04A,0x049,0x048,0x049,0x048,0x049,0x048,0x049,0x04A,0x049,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x048,0x049,0x048,0x049,0x048,0x049,0x04A,0x049,0x048,0x049,0x048,0x049,0x048,0x049,0x04A,0x049,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x050,0x051,0x050,0x051,0x050,0x051,0x052,0x051,0x050,0x051,0x050,0x051,0x050,0x051,0x052,0x051,
 0x050,0x051,0x050,0x051,0x050,0x051,0x052,0x051,0x054,0x055,0x054,0x055,0x050,0x051,0x052,0x051,
 0x050,0x051,0x050,0x051,0x050,0x051,0x052,0x051,0x050,0x051,0x050,0x051,0x050,0x051,0x052,0x051,
 0x050,0x051,0x050,0x051,0x050,0x051,0x052,0x051,0x054,0x055,0x054,0x055,0x050,0x051,0x052,0x051,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x048,0x049,0x048,0x049,0x048,0x049,0x04A,0x049,0x048,0x049,0x048,0x049,0x048,0x049,0x04A,0x049,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x028,0x029,0x028,0x029,0x028,0x029,0x02A,0x029,0x028,0x029,0x028,0x029,0x028,0x029,0x02A,0x029,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x028,0x029,0x028,0x029,0x028,0x029,0x02A,0x029,0x028,0x029,0x028,0x029,0x028,0x029,0x02A,0x029,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x088,0x089,0x088,0x089,0x088,0x089,0x08A,0x089,0x088,0x089,0x088,0x089,0x088,0x089,0x08A,0x089,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x088,0x089,0x088,0x089,0x088,0x089,0x08A,0x089,0x088,0x089,0x088,0x089,0x088,0x089,0x08A,0x089,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x088,0x089,0x088,0x089,0x088,0x089,0x08A,0x089,0x088,0x089,0x088,0x089,0x088,0x089,0x08A,0x089,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x090,0x091,0x090,0x091,0x090,0x091,0x092,0x091,0x090,0x091,0x090,0x091,0x090,0x091,0x092,0x091,
 0x090,0x091,0x090,0x091,0x090,0x091,0x092,0x091,0x094,0x095,0x094,0x095,0x090,0x091,0x092,0x091,
 0x090,0x091,0x090,0x091,0x090,0x091,0x092,0x091,0x090,0x091,0x090,0x091,0x090,0x091,0x092,0x091,
 0x090,0x091,0x090,0x091,0x090,0x091,0x092,0x091,0x094,0x095,0x094,0x095,0x090,0x091,0x092,0x091,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x088,0x089,0x088,0x089,0x088,0x089,0x08A,0x089,0x088,0x089,0x088,0x089,0x088,0x089,0x08A,0x089,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x088,0x089,0x088,0x089,0x088,0x089,0x08A,0x089,0x088,0x089,0x088,0x089,0x088,0x089,0x08A,0x089,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x088,0x089,0x088,0x089,0x088,0x089,0x08A,0x089,0x088,0x089,0x088,0x089,0x088,0x089,0x08A,0x089,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x088,0x089,0x088,0x089,0x088,0x089,0x08A,0x089,0x088,0x089,0x088,0x089,0x088,0x089,0x08A,0x089,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x090,0x091,0x090,0x091,0x090,0x091,0x092,0x091,0x090,0x091,0x090,0x091,0x090,0x091,0x092,0x091,
 0x090,0x091,0x090,0x091,0x090,0x091,0x092,0x091,0x094,0x095,0x094,0x095,0x090,0x091,0x092,0x091,
 0x090,0x091,0x090,0x091,0x090,0x091,0x092,0x091,0x090,0x091,0x090,0x091,0x090,0x091,0x092,0x091,
 0x090,0x091,0x090,0x091,0x090,0x091,0x092,0x091,0x094,0x095,0x094,0x095,0x090,0x091,0x092,0x091,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x088,0x089,0x088,0x089,0x088,0x089,0x08A,0x089,0x088,0x089,0x088,0x089,0x088,0x089,0x08A,0x089,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x088,0x089,0x088,0x089,0x088,0x089,0x08A,0x089,0x088,0x089,0x088,0x089,0x088,0x089,0x08A,0x089,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x088,0x089,0x088,0x089,0x088,0x089,0x08A,0x089,0x088,0x089,0x088,0x089,0x088,0x089,0x08A,0x089,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x088,0x089,0x088,0x089,0x088,0x089,0x08A,0x089,0x088,0x089,0x088,0x089,0x088,0x089,0x08A,0x089,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x090,0x091,0x090,0x091,0x090,0x091,0x092,0x091,0x090,0x091,0x090,0x091,0x090,0x091,0x092,0x091,
 0x090,0x091,0x090,0x091,0x090,0x091,0x092,0x091,0x094,0x095,0x094,0x095,0x090,0x091,0x092,0x091,
 0x090,0x091,0x090,0x091,0x090,0x091,0x092,0x091,0x090,0x091,0x090,0x091,0x090,0x091,0x092,0x091,
 0x090,0x091,0x090,0x091,0x090,0x091,0x092,0x091,0x094,0x095,0x094,0x095,0x090,0x091,0x092,0x091,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x088,0x089,0x088,0x089,0x088,0x089,0x08A,0x089,0x088,0x089,0x088,0x089,0x088,0x089,0x08A,0x089,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x0A0,0x0A1,0x0A0,0x0A1,0x0A0,0x0A1,0x0A2,0x0A1,0x0A0,0x0A1,0x0A0,0x0A1,0x0A0,0x0A1,0x0A2,0x0A1,
 0x0A0,0x0A1,0x0A0,0x0A1,0x0A0,0x0A1,0x0A2,0x0A1,0x0A4,0x0A5,0x0A4,0x0A5,0x0A0,0x0A1,0x0A2,0x0A1,
 0x0A0,0x0A1,0x0A0,0x0A1,0x0A0,0x0A1,0x0A2,0x0A1,0x0A0,0x0A1,0x0A0,0x0A1,0x0A0,0x0A1,0x0A2,0x0A1,
 0x0A0,0x0A1,0x0A0,0x0A1,0x0A0,0x0A1,0x0A2,0x0A1,0x0A4,0x0A5,0x0A4,0x0A5,0x0A0,0x0A1,0x0A2,0x0A1,
 0x0A0,0x0A1,0x0A0,0x0A1,0x0A0,0x0A1,0x0A2,0x0A1,0x0A0,0x0A1,0x0A0,0x0A1,0x0A0,0x0A1,0x0A2,0x0A1,
 0x0A0,0x0A1,0x0A0,0x0A1,0x0A0,0x0A1,0x0A2,0x0A1,0x0A4,0x0A5,0x0A4,0x0A5,0x0A0,0x0A1,0x0A2,0x0A1,
 0x0A8,0x0A9,0x0A8,0x0A9,0x0A8,0x0A9,0x0AA,0x0A9,0x0A8,0x0A9,0x0A8,0x0A9,0x0A8,0x0A9,0x0AA,0x0A9,
 0x0A0,0x0A1,0x0A0,0x0A1,0x0A0,0x0A1,0x0A2,0x0A1,0x0A4,0x0A5,0x0A4,0x0A5,0x0A0,0x0A1,0x0A2,0x0A1,
 0x0A0,0x0A1,0x0A0,0x0A1,0x0A0,0x0A1,0x0A2,0x0A1,0x0A0,0x0A1,0x0A0,0x0A1,0x0A0,0x0A1,0x0A2,0x0A1,
 0x0A0,0x0A1,0x0A0,0x0A1,0x0A0,0x0A1,0x0A2,0x0A1,0x0A4,0x0A5,0x0A4,0x0A5,0x0A0,0x0A1,0x0A2,0x0A1,
 0x0A0,0x0A1,0x0A0,0x0A1,0x0A0,0x0A1,0x0A2,0x0A1,0x0A0,0x0A1,0x0A0,0x0A1,0x0A0,0x0A1,0x0A2,0x0A1,
 0x0A0,0x0A1,0x0A0,0x0A1,0x0A0,0x0A1,0x0A2,0x0A1,0x0A4,0x0A5,0x0A4,0x0A5,0x0A0,0x0A1,0x0A2,0x0A1,
 0x0A0,0x0A1,0x0A0,0x0A1,0x0A0,0x0A1,0x0A2,0x0A1,0x0A0,0x0A1,0x0A0,0x0A1,0x0A0,0x0A1,0x0A2,0x0A1,
 0x0A0,0x0A1,0x0A0,0x0A1,0x0A0,0x0A1,0x0A2,0x0A1,0x0A4,0x0A5,0x0A4,0x0A5,0x0A0,0x0A1,0x0A2,0x0A1,
 0x0A8,0x0A9,0x0A8,0x0A9,0x0A8,0x0A9,0x0AA,0x0A9,0x0A8,0x0A9,0x0A8,0x0A9,0x0A8,0x0A9,0x0AA,0x0A9,
 0x0A0,0x0A1,0x0A0,0x0A1,0x0A0,0x0A1,0x0A2,0x0A1,0x0A4,0x0A5,0x0A4,0x0A5,0x0A0,0x0A1,0x0A2,0x0A1,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x088,0x089,0x088,0x089,0x088,0x089,0x08A,0x089,0x088,0x089,0x088,0x089,0x088,0x089,0x08A,0x089,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x090,0x091,0x090,0x091,0x090,0x091,0x092,0x091,0x090,0x091,0x090,0x091,0x090,0x091,0x092,0x091,
 0x090,0x091,0x090,0x091,0x090,0x091,0x092,0x091,0x094,0x095,0x094,0x095,0x090,0x091,0x092,0x091,
 0x090,0x091,0x090,0x091,0x090,0x091,0x092,0x091,0x090,0x091,0x090,0x091,0x090,0x091,0x092,0x091,
 0x090,0x091,0x090,0x091,0x090,0x091,0x092,0x091,0x094,0x095,0x094,0x095,0x090,0x091,0x092,0x091,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x088,0x089,0x088,0x089,0x088,0x089,0x08A,0x089,0x088,0x089,0x088,0x089,0x088,0x089,0x08A,0x089,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x088,0x089,0x088,0x089,0x088,0x089,0x08A,0x089,0x088,0x089,0x088,0x089,0x088,0x089,0x08A,0x089,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x088,0x089,0x088,0x089,0x088,0x089,0x08A,0x089,0x088,0x089,0x088,0x089,0x088,0x089,0x08A,0x089,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x088,0x089,0x088,0x089,0x088,0x089,0x08A,0x089,0x088,0x089,0x088,0x089,0x088,0x089,0x08A,0x089,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x090,0x091,0x090,0x091,0x090,0x091,0x092,0x091,0x090,0x091,0x090,0x091,0x090,0x091,0x092,0x091,
 0x090,0x091,0x090,0x091,0x090,0x091,0x092,0x091,0x094,0x095,0x094,0x095,0x090,0x091,0x092,0x091,
 0x090,0x091,0x090,0x091,0x090,0x091,0x092,0x091,0x090,0x091,0x090,0x091,0x090,0x091,0x092,0x091,
 0x090,0x091,0x090,0x091,0x090,0x091,0x092,0x091,0x094,0x095,0x094,0x095,0x090,0x091,0x092,0x091,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x088,0x089,0x088,0x089,0x088,0x089,0x08A,0x089,0x088,0x089,0x088,0x089,0x088,0x089,0x08A,0x089,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x088,0x089,0x088,0x089,0x088,0x089,0x08A,0x089,0x088,0x089,0x088,0x089,0x088,0x089,0x08A,0x089,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x088,0x089,0x088,0x089,0x088,0x089,0x08A,0x089,0x088,0x089,0x088,0x089,0x088,0x089,0x08A,0x089,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x088,0x089,0x088,0x089,0x088,0x089,0x08A,0x089,0x088,0x089,0x088,0x089,0x088,0x089,0x08A,0x089,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x090,0x091,0x090,0x091,0x090,0x091,0x092,0x091,0x090,0x091,0x090,0x091,0x090,0x091,0x092,0x091,
 0x090,0x091,0x090,0x091,0x090,0x091,0x092,0x091,0x094,0x095,0x094,0x095,0x090,0x091,0x092,0x091,
 0x090,0x091,0x090,0x091,0x090,0x091,0x092,0x091,0x090,0x091,0x090,0x091,0x090,0x091,0x092,0x091,
 0x090,0x091,0x090,0x091,0x090,0x091,0x092,0x091,0x094,0x095,0x094,0x095,0x090,0x091,0x092,0x091,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x088,0x089,0x088,0x089,0x088,0x089,0x08A,0x089,0x088,0x089,0x088,0x089,0x088,0x089,0x08A,0x089,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x088,0x089,0x088,0x089,0x088,0x089,0x08A,0x089,0x088,0x089,0x088,0x089,0x088,0x089,0x08A,0x089,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x088,0x089,0x088,0x089,0x088,0x089,0x08A,0x089,0x088,0x089,0x088,0x089,0x088,0x089,0x08A,0x089,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x088,0x089,0x088,0x089,0x088,0x089,0x08A,0x089,0x088,0x089,0x088,0x089,0x088,0x089,0x08A,0x089,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x090,0x091,0x090,0x091,0x090,0x091,0x092,0x091,0x090,0x091,0x090,0x091,0x090,0x091,0x092,0x091,
 0x090,0x091,0x090,0x091,0x090,0x091,0x092,0x091,0x094,0x095,0x094,0x095,0x090,0x091,0x092,0x091,
 0x090,0x091,0x090,0x091,0x090,0x091,0x092,0x091,0x090,0x091,0x090,0x091,0x090,0x091,0x092,0x091,
 0x090,0x091,0x090,0x091,0x090,0x091,0x092,0x091,0x094,0x095,0x094,0x095,0x090,0x091,0x092,0x091,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x088,0x089,0x088,0x089,0x088,0x089,0x08A,0x089,0x088,0x089,0x088,0x089,0x088,0x089,0x08A,0x089,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x0A0,0x0A1,0x0A0,0x0A1,0x0A0,0x0A1,0x0A2,0x0A1,0x0A0,0x0A1,0x0A0,0x0A1,0x0A0,0x0A1,0x0A2,0x0A1,
 0x0A0,0x0A1,0x0A0,0x0A1,0x0A0,0x0A1,0x0A2,0x0A1,0x0A4,0x0A5,0x0A4,0x0A5,0x0A0,0x0A1,0x0A2,0x0A1,
 0x0A0,0x0A1,0x0A0,0x0A1,0x0A0,0x0A1,0x0A2,0x0A1,0x0A0,0x0A1,0x0A0,0x0A1,0x0A0,0x0A1,0x0A2,0x0A1,
 0x0A0,0x0A1,0x0A0,0x0A1,0x0A0,0x0A1,0x0A2,0x0A1,0x0A4,0x0A5,0x0A4,0x0A5,0x0A0,0x0A1,0x0A2,0x0A1,
 0x0A0,0x0A1,0x0A0,0x0A1,0x0A0,0x0A1,0x0A2,0x0A1,0x0A0,0x0A1,0x0A0,0x0A1,0x0A0,0x0A1,0x0A2,0x0A1,
 0x0A0,0x0A1,0x0A0,0x0A1,0x0A0,0x0A1,0x0A2,0x0A1,0x0A4,0x0A5,0x0A4,0x0A5,0x0A0,0x0A1,0x0A2,0x0A1,
 0x0A8,0x0A9,0x0A8,0x0A9,0x0A8,0x0A9,0x0AA,0x0A9,0x0A8,0x0A9,0x0A8,0x0A9,0x0A8,0x0A9,0x0AA,0x0A9,
 0x0A0,0x0A1,0x0A0,0x0A1,0x0A0,0x0A1,0x0A2,0x0A1,0x0A4,0x0A5,0x0A4,0x0A5,0x0A0,0x0A1,0x0A2,0x0A1,
 0x0A0,0x0A1,0x0A0,0x0A1,0x0A0,0x0A1,0x0A2,0x0A1,0x0A0,0x0A1,0x0A0,0x0A1,0x0A0,0x0A1,0x0A2,0x0A1,
 0x0A0,0x0A1,0x0A0,0x0A1,0x0A0,0x0A1,0x0A2,0x0A1,0x0A4,0x0A5,0x0A4,0x0A5,0x0A0,0x0A1,0x0A2,0x0A1,
 0x0A0,0x0A1,0x0A0,0x0A1,0x0A0,0x0A1,0x0A2,0x0A1,0x0A0,0x0A1,0x0A0,0x0A1,0x0A0,0x0A1,0x0A2,0x0A1,
 0x0A0,0x0A1,0x0A0,0x0A1,0x0A0,0x0A1,0x0A2,0x0A1,0x0A4,0x0A5,0x0A4,0x0A5,0x0A0,0x0A1,0x0A2,0x0A1,
 0x0A0,0x0A1,0x0A0,0x0A1,0x0A0,0x0A1,0x0A2,0x0A1,0x0A0,0x0A1,0x0A0,0x0A1,0x0A0,0x0A1,0x0A2,0x0A1,
 0x0A0,0x0A1,0x0A0,0x0A1,0x0A0,0x0A1,0x0A2,0x0A1,0x0A4,0x0A5,0x0A4,0x0A5,0x0A0,0x0A1,0x0A2,0x0A1,
 0x0A8,0x0A9,0x0A8,0x0A9,0x0A8,0x0A9,0x0AA,0x0A9,0x0A8,0x0A9,0x0A8,0x0A9,0x0A8,0x0A9,0x0AA,0x0A9,
 0x0A0,0x0A1,0x0A0,0x0A1,0x0A0,0x0A1,0x0A2,0x0A1,0x0A4,0x0A5,0x0A4,0x0A5,0x0A0,0x0A1,0x0A2,0x0A1,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x088,0x089,0x088,0x089,0x088,0x089,0x08A,0x089,0x088,0x089,0x088,0x089,0x088,0x089,0x08A,0x089,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x090,0x091,0x090,0x091,0x090,0x091,0x092,0x091,0x090,0x091,0x090,0x091,0x090,0x091,0x092,0x091,
 0x090,0x091,0x090,0x091,0x090,0x091,0x092,0x091,0x094,0x095,0x094,0x095,0x090,0x091,0x092,0x091,
 0x090,0x091,0x090,0x091,0x090,0x091,0x092,0x091,0x090,0x091,0x090,0x091,0x090,0x091,0x092,0x091,
 0x090,0x091,0x090,0x091,0x090,0x091,0x092,0x091,0x094,0x095,0x094,0x095,0x090,0x091,0x092,0x091,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x088,0x089,0x088,0x089,0x088,0x089,0x08A,0x089,0x088,0x089,0x088,0x089,0x088,0x089,0x08A,0x089,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x028,0x029,0x028,0x029,0x028,0x029,0x02A,0x029,0x028,0x029,0x028,0x029,0x028,0x029,0x02A,0x029,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x028,0x029,0x028,0x029,0x028,0x029,0x02A,0x029,0x028,0x029,0x028,0x029,0x028,0x029,0x02A,0x029,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x048,0x049,0x048,0x049,0x048,0x049,0x04A,0x049,0x048,0x049,0x048,0x049,0x048,0x049,0x04A,0x049,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x048,0x049,0x048,0x049,0x048,0x049,0x04A,0x049,0x048,0x049,0x048,0x049,0x048,0x049,0x04A,0x049,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x048,0x049,0x048,0x049,0x048,0x049,0x04A,0x049,0x048,0x049,0x048,0x049,0x048,0x049,0x04A,0x049,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x050,0x051,0x050,0x051,0x050,0x051,0x052,0x051,0x050,0x051,0x050,0x051,0x050,0x051,0x052,0x051,
 0x050,0x051,0x050,0x051,0x050,0x051,0x052,0x051,0x054,0x055,0x054,0x055,0x050,0x051,0x052,0x051,
 0x050,0x051,0x050,0x051,0x050,0x051,0x052,0x051,0x050,0x051,0x050,0x051,0x050,0x051,0x052,0x051,
 0x050,0x051,0x050,0x051,0x050,0x051,0x052,0x051,0x054,0x055,0x054,0x055,0x050,0x051,0x052,0x051,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x048,0x049,0x048,0x049,0x048,0x049,0x04A,0x049,0x048,0x049,0x048,0x049,0x048,0x049,0x04A,0x049,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x048,0x049,0x048,0x049,0x048,0x049,0x04A,0x049,0x048,0x049,0x048,0x049,0x048,0x049,0x04A,0x049,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x048,0x049,0x048,0x049,0x048,0x049,0x04A,0x049,0x048,0x049,0x048,0x049,0x048,0x049,0x04A,0x049,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x048,0x049,0x048,0x049,0x048,0x049,0x04A,0x049,0x048,0x049,0x048,0x049,0x048,0x049,0x04A,0x049,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x050,0x051,0x050,0x051,0x050,0x051,0x052,0x051,0x050,0x051,0x050,0x051,0x050,0x051,0x052,0x051,
 0x050,0x051,0x050,0x051,0x050,0x051,0x052,0x051,0x054,0x055,0x054,0x055,0x050,0x051,0x052,0x051,
 0x050,0x051,0x050,0x051,0x050,0x051,0x052,0x051,0x050,0x051,0x050,0x051,0x050,0x051,0x052,0x051,
 0x050,0x051,0x050,0x051,0x050,0x051,0x052,0x051,0x054,0x055,0x054,0x055,0x050,0x051,0x052,0x051,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x048,0x049,0x048,0x049,0x048,0x049,0x04A,0x049,0x048,0x049,0x048,0x049,0x048,0x049,0x04A,0x049,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x028,0x029,0x028,0x029,0x028,0x029,0x02A,0x029,0x028,0x029,0x028,0x029,0x028,0x029,0x02A,0x029,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x028,0x029,0x028,0x029,0x028,0x029,0x02A,0x029,0x028,0x029,0x028,0x029,0x028,0x029,0x02A,0x029,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,
 0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,0x114,0x115,0x114,0x115,0x110,0x111,0x112,0x111,
 0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,
 0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,0x114,0x115,0x114,0x115,0x110,0x111,0x112,0x111,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,
 0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,0x114,0x115,0x114,0x115,0x110,0x111,0x112,0x111,
 0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,
 0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,0x114,0x115,0x114,0x115,0x110,0x111,0x112,0x111,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,
 0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,0x114,0x115,0x114,0x115,0x110,0x111,0x112,0x111,
 0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,
 0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,0x114,0x115,0x114,0x115,0x110,0x111,0x112,0x111,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,
 0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,0x124,0x125,0x124,0x125,0x120,0x121,0x122,0x121,
 0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,
 0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,0x124,0x125,0x124,0x125,0x120,0x121,0x122,0x121,
 0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,
 0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,0x124,0x125,0x124,0x125,0x120,0x121,0x122,0x121,
 0x128,0x129,0x128,0x129,0x128,0x129,0x12A,0x129,0x128,0x129,0x128,0x129,0x128,0x129,0x12A,0x129,
 0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,0x124,0x125,0x124,0x125,0x120,0x121,0x122,0x121,
 0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,
 0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,0x124,0x125,0x124,0x125,0x120,0x121,0x122,0x121,
 0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,
 0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,0x124,0x125,0x124,0x125,0x120,0x121,0x122,0x121,
 0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,
 0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,0x124,0x125,0x124,0x125,0x120,0x121,0x122,0x121,
 0x128,0x129,0x128,0x129,0x128,0x129,0x12A,0x129,0x128,0x129,0x128,0x129,0x128,0x129,0x12A,0x129,
 0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,0x124,0x125,0x124,0x125,0x120,0x121,0x122,0x121,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,
 0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,0x114,0x115,0x114,0x115,0x110,0x111,0x112,0x111,
 0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,
 0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,0x114,0x115,0x114,0x115,0x110,0x111,0x112,0x111,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,
 0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,0x114,0x115,0x114,0x115,0x110,0x111,0x112,0x111,
 0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,
 0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,0x114,0x115,0x114,0x115,0x110,0x111,0x112,0x111,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,
 0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,0x114,0x115,0x114,0x115,0x110,0x111,0x112,0x111,
 0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,
 0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,0x114,0x115,0x114,0x115,0x110,0x111,0x112,0x111,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,
 0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,0x114,0x115,0x114,0x115,0x110,0x111,0x112,0x111,
 0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,
 0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,0x114,0x115,0x114,0x115,0x110,0x111,0x112,0x111,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,
 0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,0x124,0x125,0x124,0x125,0x120,0x121,0x122,0x121,
 0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,
 0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,0x124,0x125,0x124,0x125,0x120,0x121,0x122,0x121,
 0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,
 0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,0x124,0x125,0x124,0x125,0x120,0x121,0x122,0x121,
 0x128,0x129,0x128,0x129,0x128,0x129,0x12A,0x129,0x128,0x129,0x128,0x129,0x128,0x129,0x12A,0x129,
 0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,0x124,0x125,0x124,0x125,0x120,0x121,0x122,0x121,
 0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,
 0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,0x124,0x125,0x124,0x125,0x120,0x121,0x122,0x121,
 0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,
 0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,0x124,0x125,0x124,0x125,0x120,0x121,0x122,0x121,
 0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,
 0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,0x124,0x125,0x124,0x125,0x120,0x121,0x122,0x121,
 0x128,0x129,0x128,0x129,0x128,0x129,0x12A,0x129,0x128,0x129,0x128,0x129,0x128,0x129,0x12A,0x129,
 0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,0x124,0x125,0x124,0x125,0x120,0x121,0x122,0x121,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,
 0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,0x114,0x115,0x114,0x115,0x110,0x111,0x112,0x111,
 0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,
 0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,0x114,0x115,0x114,0x115,0x110,0x111,0x112,0x111,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,
 0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,0x114,0x115,0x114,0x115,0x110,0x111,0x112,0x111,
 0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,
 0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,0x114,0x115,0x114,0x115,0x110,0x111,0x112,0x111,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,
 0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,0x114,0x115,0x114,0x115,0x110,0x111,0x112,0x111,
 0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,
 0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,0x114,0x115,0x114,0x115,0x110,0x111,0x112,0x111,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,
 0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,0x114,0x115,0x114,0x115,0x110,0x111,0x112,0x111,
 0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,
 0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,0x114,0x115,0x114,0x115,0x110,0x111,0x112,0x111,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,
 0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,0x124,0x125,0x124,0x125,0x120,0x121,0x122,0x121,
 0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,
 0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,0x124,0x125,0x124,0x125,0x120,0x121,0x122,0x121,
 0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,
 0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,0x124,0x125,0x124,0x125,0x120,0x121,0x122,0x121,
 0x128,0x129,0x128,0x129,0x128,0x129,0x12A,0x129,0x128,0x129,0x128,0x129,0x128,0x129,0x12A,0x129,
 0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,0x124,0x125,0x124,0x125,0x120,0x121,0x122,0x121,
 0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,
 0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,0x124,0x125,0x124,0x125,0x120,0x121,0x122,0x121,
 0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,
 0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,0x124,0x125,0x124,0x125,0x120,0x121,0x122,0x121,
 0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,
 0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,0x124,0x125,0x124,0x125,0x120,0x121,0x122,0x121,
 0x128,0x129,0x128,0x129,0x128,0x129,0x12A,0x129,0x128,0x129,0x128,0x129,0x128,0x129,0x12A,0x129,
 0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,0x124,0x125,0x124,0x125,0x120,0x121,0x122,0x121,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,
 0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,0x114,0x115,0x114,0x115,0x110,0x111,0x112,0x111,
 0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,
 0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,0x114,0x115,0x114,0x115,0x110,0x111,0x112,0x111,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,
 0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,0x144,0x145,0x144,0x145,0x140,0x141,0x142,0x141,
 0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,
 0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,0x144,0x145,0x144,0x145,0x140,0x141,0x142,0x141,
 0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,
 0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,0x144,0x145,0x144,0x145,0x140,0x141,0x142,0x141,
 0x148,0x149,0x148,0x149,0x148,0x149,0x14A,0x149,0x148,0x149,0x148,0x149,0x148,0x149,0x14A,0x149,
 0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,0x144,0x145,0x144,0x145,0x140,0x141,0x142,0x141,
 0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,
 0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,0x144,0x145,0x144,0x145,0x140,0x141,0x142,0x141,
 0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,
 0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,0x144,0x145,0x144,0x145,0x140,0x141,0x142,0x141,
 0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,
 0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,0x144,0x145,0x144,0x145,0x140,0x141,0x142,0x141,
 0x148,0x149,0x148,0x149,0x148,0x149,0x14A,0x149,0x148,0x149,0x148,0x149,0x148,0x149,0x14A,0x149,
 0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,0x144,0x145,0x144,0x145,0x140,0x141,0x142,0x141,
 0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,
 0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,0x144,0x145,0x144,0x145,0x140,0x141,0x142,0x141,
 0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,
 0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,0x144,0x145,0x144,0x145,0x140,0x141,0x142,0x141,
 0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,
 0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,0x144,0x145,0x144,0x145,0x140,0x141,0x142,0x141,
 0x148,0x149,0x148,0x149,0x148,0x149,0x14A,0x149,0x148,0x149,0x148,0x149,0x148,0x149,0x14A,0x149,
 0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,0x144,0x145,0x144,0x145,0x140,0x141,0x142,0x141,
 0x150,0x151,0x150,0x151,0x150,0x151,0x152,0x151,0x150,0x151,0x150,0x151,0x150,0x151,0x152,0x151,
 0x150,0x151,0x150,0x151,0x150,0x151,0x152,0x151,0x154,0x155,0x154,0x155,0x150,0x151,0x152,0x151,
 0x150,0x151,0x150,0x151,0x150,0x151,0x152,0x151,0x150,0x151,0x150,0x151,0x150,0x151,0x152,0x151,
 0x150,0x151,0x150,0x151,0x150,0x151,0x152,0x151,0x154,0x155,0x154,0x155,0x150,0x151,0x152,0x151,
 0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,
 0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,0x144,0x145,0x144,0x145,0x140,0x141,0x142,0x141,
 0x148,0x149,0x148,0x149,0x148,0x149,0x14A,0x149,0x148,0x149,0x148,0x149,0x148,0x149,0x14A,0x149,
 0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,0x144,0x145,0x144,0x145,0x140,0x141,0x142,0x141,
 0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,
 0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,0x144,0x145,0x144,0x145,0x140,0x141,0x142,0x141,
 0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,
 0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,0x144,0x145,0x144,0x145,0x140,0x141,0x142,0x141,
 0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,
 0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,0x144,0x145,0x144,0x145,0x140,0x141,0x142,0x141,
 0x148,0x149,0x148,0x149,0x148,0x149,0x14A,0x149,0x148,0x149,0x148,0x149,0x148,0x149,0x14A,0x149,
 0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,0x144,0x145,0x144,0x145,0x140,0x141,0x142,0x141,
 0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,
 0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,0x144,0x145,0x144,0x145,0x140,0x141,0x142,0x141,
 0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,
 0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,0x144,0x145,0x144,0x145,0x140,0x141,0x142,0x141,
 0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,
 0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,0x144,0x145,0x144,0x145,0x140,0x141,0x142,0x141,
 0x148,0x149,0x148,0x149,0x148,0x149,0x14A,0x149,0x148,0x149,0x148,0x149,0x148,0x149,0x14A,0x149,
 0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,0x144,0x145,0x144,0x145,0x140,0x141,0x142,0x141,
 0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,
 0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,0x144,0x145,0x144,0x145,0x140,0x141,0x142,0x141,
 0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,
 0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,0x144,0x145,0x144,0x145,0x140,0x141,0x142,0x141,
 0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,
 0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,0x144,0x145,0x144,0x145,0x140,0x141,0x142,0x141,
 0x148,0x149,0x148,0x149,0x148,0x149,0x14A,0x149,0x148,0x149,0x148,0x149,0x148,0x149,0x14A,0x149,
 0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,0x144,0x145,0x144,0x145,0x140,0x141,0x142,0x141,
 0x150,0x151,0x150,0x151,0x150,0x151,0x152,0x151,0x150,0x151,0x150,0x151,0x150,0x151,0x152,0x151,
 0x150,0x151,0x150,0x151,0x150,0x151,0x152,0x151,0x154,0x155,0x154,0x155,0x150,0x151,0x152,0x151,
 0x150,0x151,0x150,0x151,0x150,0x151,0x152,0x151,0x150,0x151,0x150,0x151,0x150,0x151,0x152,0x151,
 0x150,0x151,0x150,0x151,0x150,0x151,0x152,0x151,0x154,0x155,0x154,0x155,0x150,0x151,0x152,0x151,
 0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,
 0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,0x144,0x145,0x144,0x145,0x140,0x141,0x142,0x141,
 0x148,0x149,0x148,0x149,0x148,0x149,0x14A,0x149,0x148,0x149,0x148,0x149,0x148,0x149,0x14A,0x149,
 0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,0x144,0x145,0x144,0x145,0x140,0x141,0x142,0x141,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,
 0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,0x114,0x115,0x114,0x115,0x110,0x111,0x112,0x111,
 0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,
 0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,0x114,0x115,0x114,0x115,0x110,0x111,0x112,0x111,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,
 0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,0x124,0x125,0x124,0x125,0x120,0x121,0x122,0x121,
 0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,
 0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,0x124,0x125,0x124,0x125,0x120,0x121,0x122,0x121,
 0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,
 0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,0x124,0x125,0x124,0x125,0x120,0x121,0x122,0x121,
 0x128,0x129,0x128,0x129,0x128,0x129,0x12A,0x129,0x128,0x129,0x128,0x129,0x128,0x129,0x12A,0x129,
 0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,0x124,0x125,0x124,0x125,0x120,0x121,0x122,0x121,
 0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,
 0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,0x124,0x125,0x124,0x125,0x120,0x121,0x122,0x121,
 0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,
 0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,0x124,0x125,0x124,0x125,0x120,0x121,0x122,0x121,
 0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,
 0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,0x124,0x125,0x124,0x125,0x120,0x121,0x122,0x121,
 0x128,0x129,0x128,0x129,0x128,0x129,0x12A,0x129,0x128,0x129,0x128,0x129,0x128,0x129,0x12A,0x129,
 0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,0x124,0x125,0x124,0x125,0x120,0x121,0x122,0x121,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,
 0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,0x114,0x115,0x114,0x115,0x110,0x111,0x112,0x111,
 0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,
 0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,0x114,0x115,0x114,0x115,0x110,0x111,0x112,0x111,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,
 0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,0x114,0x115,0x114,0x115,0x110,0x111,0x112,0x111,
 0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,
 0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,0x114,0x115,0x114,0x115,0x110,0x111,0x112,0x111,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,
 0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,0x114,0x115,0x114,0x115,0x110,0x111,0x112,0x111,
 0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,
 0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,0x114,0x115,0x114,0x115,0x110,0x111,0x112,0x111,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,
 0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,0x114,0x115,0x114,0x115,0x110,0x111,0x112,0x111,
 0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,
 0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,0x114,0x115,0x114,0x115,0x110,0x111,0x112,0x111,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,
 0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,0x124,0x125,0x124,0x125,0x120,0x121,0x122,0x121,
 0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,
 0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,0x124,0x125,0x124,0x125,0x120,0x121,0x122,0x121,
 0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,
 0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,0x124,0x125,0x124,0x125,0x120,0x121,0x122,0x121,
 0x128,0x129,0x128,0x129,0x128,0x129,0x12A,0x129,0x128,0x129,0x128,0x129,0x128,0x129,0x12A,0x129,
 0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,0x124,0x125,0x124,0x125,0x120,0x121,0x122,0x121,
 0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,
 0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,0x124,0x125,0x124,0x125,0x120,0x121,0x122,0x121,
 0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,
 0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,0x124,0x125,0x124,0x125,0x120,0x121,0x122,0x121,
 0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,
 0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,0x124,0x125,0x124,0x125,0x120,0x121,0x122,0x121,
 0x128,0x129,0x128,0x129,0x128,0x129,0x12A,0x129,0x128,0x129,0x128,0x129,0x128,0x129,0x12A,0x129,
 0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,0x124,0x125,0x124,0x125,0x120,0x121,0x122,0x121,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,
 0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,0x114,0x115,0x114,0x115,0x110,0x111,0x112,0x111,
 0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,
 0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,0x114,0x115,0x114,0x115,0x110,0x111,0x112,0x111,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,
 0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,0x114,0x115,0x114,0x115,0x110,0x111,0x112,0x111,
 0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,
 0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,0x114,0x115,0x114,0x115,0x110,0x111,0x112,0x111,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,
 0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,0x114,0x115,0x114,0x115,0x110,0x111,0x112,0x111,
 0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,
 0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,0x114,0x115,0x114,0x115,0x110,0x111,0x112,0x111,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,
 0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,0x114,0x115,0x114,0x115,0x110,0x111,0x112,0x111,
 0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,
 0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,0x114,0x115,0x114,0x115,0x110,0x111,0x112,0x111,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,
 0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,0x124,0x125,0x124,0x125,0x120,0x121,0x122,0x121,
 0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,
 0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,0x124,0x125,0x124,0x125,0x120,0x121,0x122,0x121,
 0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,
 0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,0x124,0x125,0x124,0x125,0x120,0x121,0x122,0x121,
 0x128,0x129,0x128,0x129,0x128,0x129,0x12A,0x129,0x128,0x129,0x128,0x129,0x128,0x129,0x12A,0x129,
 0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,0x124,0x125,0x124,0x125,0x120,0x121,0x122,0x121,
 0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,
 0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,0x124,0x125,0x124,0x125,0x120,0x121,0x122,0x121,
 0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,
 0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,0x124,0x125,0x124,0x125,0x120,0x121,0x122,0x121,
 0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,
 0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,0x124,0x125,0x124,0x125,0x120,0x121,0x122,0x121,
 0x128,0x129,0x128,0x129,0x128,0x129,0x12A,0x129,0x128,0x129,0x128,0x129,0x128,0x129,0x12A,0x129,
 0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,0x124,0x125,0x124,0x125,0x120,0x121,0x122,0x121,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,
 0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,0x114,0x115,0x114,0x115,0x110,0x111,0x112,0x111,
 0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,
 0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,0x114,0x115,0x114,0x115,0x110,0x111,0x112,0x111,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,
 0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,0x114,0x115,0x114,0x115,0x110,0x111,0x112,0x111,
 0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,
 0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,0x114,0x115,0x114,0x115,0x110,0x111,0x112,0x111,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,
 0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,0x114,0x115,0x114,0x115,0x110,0x111,0x112,0x111,
 0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,
 0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,0x114,0x115,0x114,0x115,0x110,0x111,0x112,0x111,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,
 0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,0x114,0x115,0x114,0x115,0x110,0x111,0x112,0x111,
 0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,
 0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,0x114,0x115,0x114,0x115,0x110,0x111,0x112,0x111,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,
 0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,0x124,0x125,0x124,0x125,0x120,0x121,0x122,0x121,
 0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,
 0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,0x124,0x125,0x124,0x125,0x120,0x121,0x122,0x121,
 0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,
 0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,0x124,0x125,0x124,0x125,0x120,0x121,0x122,0x121,
 0x128,0x129,0x128,0x129,0x128,0x129,0x12A,0x129,0x128,0x129,0x128,0x129,0x128,0x129,0x12A,0x129,
 0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,0x124,0x125,0x124,0x125,0x120,0x121,0x122,0x121,
 0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,
 0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,0x124,0x125,0x124,0x125,0x120,0x121,0x122,0x121,
 0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,
 0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,0x124,0x125,0x124,0x125,0x120,0x121,0x122,0x121,
 0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,
 0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,0x124,0x125,0x124,0x125,0x120,0x121,0x122,0x121,
 0x128,0x129,0x128,0x129,0x128,0x129,0x12A,0x129,0x128,0x129,0x128,0x129,0x128,0x129,0x12A,0x129,
 0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,0x124,0x125,0x124,0x125,0x120,0x121,0x122,0x121,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,
 0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,0x114,0x115,0x114,0x115,0x110,0x111,0x112,0x111,
 0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,
 0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,0x114,0x115,0x114,0x115,0x110,0x111,0x112,0x111,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,
 0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,0x144,0x145,0x144,0x145,0x140,0x141,0x142,0x141,
 0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,
 0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,0x144,0x145,0x144,0x145,0x140,0x141,0x142,0x141,
 0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,
 0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,0x144,0x145,0x144,0x145,0x140,0x141,0x142,0x141,
 0x148,0x149,0x148,0x149,0x148,0x149,0x14A,0x149,0x148,0x149,0x148,0x149,0x148,0x149,0x14A,0x149,
 0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,0x144,0x145,0x144,0x145,0x140,0x141,0x142,0x141,
 0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,
 0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,0x144,0x145,0x144,0x145,0x140,0x141,0x142,0x141,
 0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,
 0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,0x144,0x145,0x144,0x145,0x140,0x141,0x142,0x141,
 0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,
 0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,0x144,0x145,0x144,0x145,0x140,0x141,0x142,0x141,
 0x148,0x149,0x148,0x149,0x148,0x149,0x14A,0x149,0x148,0x149,0x148,0x149,0x148,0x149,0x14A,0x149,
 0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,0x144,0x145,0x144,0x145,0x140,0x141,0x142,0x141,
 0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,
 0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,0x144,0x145,0x144,0x145,0x140,0x141,0x142,0x141,
 0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,
 0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,0x144,0x145,0x144,0x145,0x140,0x141,0x142,0x141,
 0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,
 0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,0x144,0x145,0x144,0x145,0x140,0x141,0x142,0x141,
 0x148,0x149,0x148,0x149,0x148,0x149,0x14A,0x149,0x148,0x149,0x148,0x149,0x148,0x149,0x14A,0x149,
 0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,0x144,0x145,0x144,0x145,0x140,0x141,0x142,0x141,
 0x150,0x151,0x150,0x151,0x150,0x151,0x152,0x151,0x150,0x151,0x150,0x151,0x150,0x151,0x152,0x151,
 0x150,0x151,0x150,0x151,0x150,0x151,0x152,0x151,0x154,0x155,0x154,0x155,0x150,0x151,0x152,0x151,
 0x150,0x151,0x150,0x151,0x150,0x151,0x152,0x151,0x150,0x151,0x150,0x151,0x150,0x151,0x152,0x151,
 0x150,0x151,0x150,0x151,0x150,0x151,0x152,0x151,0x154,0x155,0x154,0x155,0x150,0x151,0x152,0x151,
 0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,
 0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,0x144,0x145,0x144,0x145,0x140,0x141,0x142,0x141,
 0x148,0x149,0x148,0x149,0x148,0x149,0x14A,0x149,0x148,0x149,0x148,0x149,0x148,0x149,0x14A,0x149,
 0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,0x144,0x145,0x144,0x145,0x140,0x141,0x142,0x141,
 0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,
 0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,0x144,0x145,0x144,0x145,0x140,0x141,0x142,0x141,
 0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,
 0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,0x144,0x145,0x144,0x145,0x140,0x141,0x142,0x141,
 0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,
 0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,0x144,0x145,0x144,0x145,0x140,0x141,0x142,0x141,
 0x148,0x149,0x148,0x149,0x148,0x149,0x14A,0x149,0x148,0x149,0x148,0x149,0x148,0x149,0x14A,0x149,
 0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,0x144,0x145,0x144,0x145,0x140,0x141,0x142,0x141,
 0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,
 0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,0x144,0x145,0x144,0x145,0x140,0x141,0x142,0x141,
 0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,
 0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,0x144,0x145,0x144,0x145,0x140,0x141,0x142,0x141,
 0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,
 0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,0x144,0x145,0x144,0x145,0x140,0x141,0x142,0x141,
 0x148,0x149,0x148,0x149,0x148,0x149,0x14A,0x149,0x148,0x149,0x148,0x149,0x148,0x149,0x14A,0x149,
 0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,0x144,0x145,0x144,0x145,0x140,0x141,0x142,0x141,
 0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,
 0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,0x144,0x145,0x144,0x145,0x140,0x141,0x142,0x141,
 0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,
 0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,0x144,0x145,0x144,0x145,0x140,0x141,0x142,0x141,
 0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,
 0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,0x144,0x145,0x144,0x145,0x140,0x141,0x142,0x141,
 0x148,0x149,0x148,0x149,0x148,0x149,0x14A,0x149,0x148,0x149,0x148,0x149,0x148,0x149,0x14A,0x149,
 0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,0x144,0x145,0x144,0x145,0x140,0x141,0x142,0x141,
 0x150,0x151,0x150,0x151,0x150,0x151,0x152,0x151,0x150,0x151,0x150,0x151,0x150,0x151,0x152,0x151,
 0x150,0x151,0x150,0x151,0x150,0x151,0x152,0x151,0x154,0x155,0x154,0x155,0x150,0x151,0x152,0x151,
 0x150,0x151,0x150,0x151,0x150,0x151,0x152,0x151,0x150,0x151,0x150,0x151,0x150,0x151,0x152,0x151,
 0x150,0x151,0x150,0x151,0x150,0x151,0x152,0x151,0x154,0x155,0x154,0x155,0x150,0x151,0x152,0x151,
 0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,
 0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,0x144,0x145,0x144,0x145,0x140,0x141,0x142,0x141,
 0x148,0x149,0x148,0x149,0x148,0x149,0x14A,0x149,0x148,0x149,0x148,0x149,0x148,0x149,0x14A,0x149,
 0x140,0x141,0x140,0x141,0x140,0x141,0x142,0x141,0x144,0x145,0x144,0x145,0x140,0x141,0x142,0x141,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,
 0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,0x114,0x115,0x114,0x115,0x110,0x111,0x112,0x111,
 0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,
 0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,0x114,0x115,0x114,0x115,0x110,0x111,0x112,0x111,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,
 0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,0x124,0x125,0x124,0x125,0x120,0x121,0x122,0x121,
 0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,
 0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,0x124,0x125,0x124,0x125,0x120,0x121,0x122,0x121,
 0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,
 0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,0x124,0x125,0x124,0x125,0x120,0x121,0x122,0x121,
 0x128,0x129,0x128,0x129,0x128,0x129,0x12A,0x129,0x128,0x129,0x128,0x129,0x128,0x129,0x12A,0x129,
 0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,0x124,0x125,0x124,0x125,0x120,0x121,0x122,0x121,
 0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,
 0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,0x124,0x125,0x124,0x125,0x120,0x121,0x122,0x121,
 0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,
 0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,0x124,0x125,0x124,0x125,0x120,0x121,0x122,0x121,
 0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,
 0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,0x124,0x125,0x124,0x125,0x120,0x121,0x122,0x121,
 0x128,0x129,0x128,0x129,0x128,0x129,0x12A,0x129,0x128,0x129,0x128,0x129,0x128,0x129,0x12A,0x129,
 0x120,0x121,0x120,0x121,0x120,0x121,0x122,0x121,0x124,0x125,0x124,0x125,0x120,0x121,0x122,0x121,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,
 0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,0x114,0x115,0x114,0x115,0x110,0x111,0x112,0x111,
 0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,
 0x110,0x111,0x110,0x111,0x110,0x111,0x112,0x111,0x114,0x115,0x114,0x115,0x110,0x111,0x112,0x111,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,0x108,0x109,0x108,0x109,0x108,0x109,0x10A,0x109,
 0x100,0x101,0x100,0x101,0x100,0x101,0x102,0x101,0x104,0x105,0x104,0x105,0x100,0x101,0x102,0x101,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x028,0x029,0x028,0x029,0x028,0x029,0x02A,0x029,0x028,0x029,0x028,0x029,0x028,0x029,0x02A,0x029,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x028,0x029,0x028,0x029,0x028,0x029,0x02A,0x029,0x028,0x029,0x028,0x029,0x028,0x029,0x02A,0x029,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x028,0x029,0x028,0x029,0x028,0x029,0x02A,0x029,0x028,0x029,0x028,0x029,0x028,0x029,0x02A,0x029,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x028,0x029,0x028,0x029,0x028,0x029,0x02A,0x029,0x028,0x029,0x028,0x029,0x028,0x029,0x02A,0x029,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x028,0x029,0x028,0x029,0x028,0x029,0x02A,0x029,0x028,0x029,0x028,0x029,0x028,0x029,0x02A,0x029,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x028,0x029,0x028,0x029,0x028,0x029,0x02A,0x029,0x028,0x029,0x028,0x029,0x028,0x029,0x02A,0x029,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x048,0x049,0x048,0x049,0x048,0x049,0x04A,0x049,0x048,0x049,0x048,0x049,0x048,0x049,0x04A,0x049,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x048,0x049,0x048,0x049,0x048,0x049,0x04A,0x049,0x048,0x049,0x048,0x049,0x048,0x049,0x04A,0x049,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x048,0x049,0x048,0x049,0x048,0x049,0x04A,0x049,0x048,0x049,0x048,0x049,0x048,0x049,0x04A,0x049,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x050,0x051,0x050,0x051,0x050,0x051,0x052,0x051,0x050,0x051,0x050,0x051,0x050,0x051,0x052,0x051,
 0x050,0x051,0x050,0x051,0x050,0x051,0x052,0x051,0x054,0x055,0x054,0x055,0x050,0x051,0x052,0x051,
 0x050,0x051,0x050,0x051,0x050,0x051,0x052,0x051,0x050,0x051,0x050,0x051,0x050,0x051,0x052,0x051,
 0x050,0x051,0x050,0x051,0x050,0x051,0x052,0x051,0x054,0x055,0x054,0x055,0x050,0x051,0x052,0x051,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x048,0x049,0x048,0x049,0x048,0x049,0x04A,0x049,0x048,0x049,0x048,0x049,0x048,0x049,0x04A,0x049,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x048,0x049,0x048,0x049,0x048,0x049,0x04A,0x049,0x048,0x049,0x048,0x049,0x048,0x049,0x04A,0x049,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x048,0x049,0x048,0x049,0x048,0x049,0x04A,0x049,0x048,0x049,0x048,0x049,0x048,0x049,0x04A,0x049,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x048,0x049,0x048,0x049,0x048,0x049,0x04A,0x049,0x048,0x049,0x048,0x049,0x048,0x049,0x04A,0x049,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x050,0x051,0x050,0x051,0x050,0x051,0x052,0x051,0x050,0x051,0x050,0x051,0x050,0x051,0x052,0x051,
 0x050,0x051,0x050,0x051,0x050,0x051,0x052,0x051,0x054,0x055,0x054,0x055,0x050,0x051,0x052,0x051,
 0x050,0x051,0x050,0x051,0x050,0x051,0x052,0x051,0x050,0x051,0x050,0x051,0x050,0x051,0x052,0x051,
 0x050,0x051,0x050,0x051,0x050,0x051,0x052,0x051,0x054,0x055,0x054,0x055,0x050,0x051,0x052,0x051,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x048,0x049,0x048,0x049,0x048,0x049,0x04A,0x049,0x048,0x049,0x048,0x049,0x048,0x049,0x04A,0x049,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x028,0x029,0x028,0x029,0x028,0x029,0x02A,0x029,0x028,0x029,0x028,0x029,0x028,0x029,0x02A,0x029,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x028,0x029,0x028,0x029,0x028,0x029,0x02A,0x029,0x028,0x029,0x028,0x029,0x028,0x029,0x02A,0x029,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x088,0x089,0x088,0x089,0x088,0x089,0x08A,0x089,0x088,0x089,0x088,0x089,0x088,0x089,0x08A,0x089,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x088,0x089,0x088,0x089,0x088,0x089,0x08A,0x089,0x088,0x089,0x088,0x089,0x088,0x089,0x08A,0x089,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x088,0x089,0x088,0x089,0x088,0x089,0x08A,0x089,0x088,0x089,0x088,0x089,0x088,0x089,0x08A,0x089,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x090,0x091,0x090,0x091,0x090,0x091,0x092,0x091,0x090,0x091,0x090,0x091,0x090,0x091,0x092,0x091,
 0x090,0x091,0x090,0x091,0x090,0x091,0x092,0x091,0x094,0x095,0x094,0x095,0x090,0x091,0x092,0x091,
 0x090,0x091,0x090,0x091,0x090,0x091,0x092,0x091,0x090,0x091,0x090,0x091,0x090,0x091,0x092,0x091,
 0x090,0x091,0x090,0x091,0x090,0x091,0x092,0x091,0x094,0x095,0x094,0x095,0x090,0x091,0x092,0x091,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x088,0x089,0x088,0x089,0x088,0x089,0x08A,0x089,0x088,0x089,0x088,0x089,0x088,0x089,0x08A,0x089,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x088,0x089,0x088,0x089,0x088,0x089,0x08A,0x089,0x088,0x089,0x088,0x089,0x088,0x089,0x08A,0x089,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x088,0x089,0x088,0x089,0x088,0x089,0x08A,0x089,0x088,0x089,0x088,0x089,0x088,0x089,0x08A,0x089,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x088,0x089,0x088,0x089,0x088,0x089,0x08A,0x089,0x088,0x089,0x088,0x089,0x088,0x089,0x08A,0x089,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x090,0x091,0x090,0x091,0x090,0x091,0x092,0x091,0x090,0x091,0x090,0x091,0x090,0x091,0x092,0x091,
 0x090,0x091,0x090,0x091,0x090,0x091,0x092,0x091,0x094,0x095,0x094,0x095,0x090,0x091,0x092,0x091,
 0x090,0x091,0x090,0x091,0x090,0x091,0x092,0x091,0x090,0x091,0x090,0x091,0x090,0x091,0x092,0x091,
 0x090,0x091,0x090,0x091,0x090,0x091,0x092,0x091,0x094,0x095,0x094,0x095,0x090,0x091,0x092,0x091,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x088,0x089,0x088,0x089,0x088,0x089,0x08A,0x089,0x088,0x089,0x088,0x089,0x088,0x089,0x08A,0x089,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x088,0x089,0x088,0x089,0x088,0x089,0x08A,0x089,0x088,0x089,0x088,0x089,0x088,0x089,0x08A,0x089,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x088,0x089,0x088,0x089,0x088,0x089,0x08A,0x089,0x088,0x089,0x088,0x089,0x088,0x089,0x08A,0x089,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x088,0x089,0x088,0x089,0x088,0x089,0x08A,0x089,0x088,0x089,0x088,0x089,0x088,0x089,0x08A,0x089,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x090,0x091,0x090,0x091,0x090,0x091,0x092,0x091,0x090,0x091,0x090,0x091,0x090,0x091,0x092,0x091,
 0x090,0x091,0x090,0x091,0x090,0x091,0x092,0x091,0x094,0x095,0x094,0x095,0x090,0x091,0x092,0x091,
 0x090,0x091,0x090,0x091,0x090,0x091,0x092,0x091,0x090,0x091,0x090,0x091,0x090,0x091,0x092,0x091,
 0x090,0x091,0x090,0x091,0x090,0x091,0x092,0x091,0x094,0x095,0x094,0x095,0x090,0x091,0x092,0x091,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x088,0x089,0x088,0x089,0x088,0x089,0x08A,0x089,0x088,0x089,0x088,0x089,0x088,0x089,0x08A,0x089,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x0A0,0x0A1,0x0A0,0x0A1,0x0A0,0x0A1,0x0A2,0x0A1,0x0A0,0x0A1,0x0A0,0x0A1,0x0A0,0x0A1,0x0A2,0x0A1,
 0x0A0,0x0A1,0x0A0,0x0A1,0x0A0,0x0A1,0x0A2,0x0A1,0x0A4,0x0A5,0x0A4,0x0A5,0x0A0,0x0A1,0x0A2,0x0A1,
 0x0A0,0x0A1,0x0A0,0x0A1,0x0A0,0x0A1,0x0A2,0x0A1,0x0A0,0x0A1,0x0A0,0x0A1,0x0A0,0x0A1,0x0A2,0x0A1,
 0x0A0,0x0A1,0x0A0,0x0A1,0x0A0,0x0A1,0x0A2,0x0A1,0x0A4,0x0A5,0x0A4,0x0A5,0x0A0,0x0A1,0x0A2,0x0A1,
 0x0A0,0x0A1,0x0A0,0x0A1,0x0A0,0x0A1,0x0A2,0x0A1,0x0A0,0x0A1,0x0A0,0x0A1,0x0A0,0x0A1,0x0A2,0x0A1,
 0x0A0,0x0A1,0x0A0,0x0A1,0x0A0,0x0A1,0x0A2,0x0A1,0x0A4,0x0A5,0x0A4,0x0A5,0x0A0,0x0A1,0x0A2,0x0A1,
 0x0A8,0x0A9,0x0A8,0x0A9,0x0A8,0x0A9,0x0AA,0x0A9,0x0A8,0x0A9,0x0A8,0x0A9,0x0A8,0x0A9,0x0AA,0x0A9,
 0x0A0,0x0A1,0x0A0,0x0A1,0x0A0,0x0A1,0x0A2,0x0A1,0x0A4,0x0A5,0x0A4,0x0A5,0x0A0,0x0A1,0x0A2,0x0A1,
 0x0A0,0x0A1,0x0A0,0x0A1,0x0A0,0x0A1,0x0A2,0x0A1,0x0A0,0x0A1,0x0A0,0x0A1,0x0A0,0x0A1,0x0A2,0x0A1,
 0x0A0,0x0A1,0x0A0,0x0A1,0x0A0,0x0A1,0x0A2,0x0A1,0x0A4,0x0A5,0x0A4,0x0A5,0x0A0,0x0A1,0x0A2,0x0A1,
 0x0A0,0x0A1,0x0A0,0x0A1,0x0A0,0x0A1,0x0A2,0x0A1,0x0A0,0x0A1,0x0A0,0x0A1,0x0A0,0x0A1,0x0A2,0x0A1,
 0x0A0,0x0A1,0x0A0,0x0A1,0x0A0,0x0A1,0x0A2,0x0A1,0x0A4,0x0A5,0x0A4,0x0A5,0x0A0,0x0A1,0x0A2,0x0A1,
 0x0A0,0x0A1,0x0A0,0x0A1,0x0A0,0x0A1,0x0A2,0x0A1,0x0A0,0x0A1,0x0A0,0x0A1,0x0A0,0x0A1,0x0A2,0x0A1,
 0x0A0,0x0A1,0x0A0,0x0A1,0x0A0,0x0A1,0x0A2,0x0A1,0x0A4,0x0A5,0x0A4,0x0A5,0x0A0,0x0A1,0x0A2,0x0A1,
 0x0A8,0x0A9,0x0A8,0x0A9,0x0A8,0x0A9,0x0AA,0x0A9,0x0A8,0x0A9,0x0A8,0x0A9,0x0A8,0x0A9,0x0AA,0x0A9,
 0x0A0,0x0A1,0x0A0,0x0A1,0x0A0,0x0A1,0x0A2,0x0A1,0x0A4,0x0A5,0x0A4,0x0A5,0x0A0,0x0A1,0x0A2,0x0A1,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x088,0x089,0x088,0x089,0x088,0x089,0x08A,0x089,0x088,0x089,0x088,0x089,0x088,0x089,0x08A,0x089,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x090,0x091,0x090,0x091,0x090,0x091,0x092,0x091,0x090,0x091,0x090,0x091,0x090,0x091,0x092,0x091,
 0x090,0x091,0x090,0x091,0x090,0x091,0x092,0x091,0x094,0x095,0x094,0x095,0x090,0x091,0x092,0x091,
 0x090,0x091,0x090,0x091,0x090,0x091,0x092,0x091,0x090,0x091,0x090,0x091,0x090,0x091,0x092,0x091,
 0x090,0x091,0x090,0x091,0x090,0x091,0x092,0x091,0x094,0x095,0x094,0x095,0x090,0x091,0x092,0x091,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x088,0x089,0x088,0x089,0x088,0x089,0x08A,0x089,0x088,0x089,0x088,0x089,0x088,0x089,0x08A,0x089,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x088,0x089,0x088,0x089,0x088,0x089,0x08A,0x089,0x088,0x089,0x088,0x089,0x088,0x089,0x08A,0x089,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x088,0x089,0x088,0x089,0x088,0x089,0x08A,0x089,0x088,0x089,0x088,0x089,0x088,0x089,0x08A,0x089,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x088,0x089,0x088,0x089,0x088,0x089,0x08A,0x089,0x088,0x089,0x088,0x089,0x088,0x089,0x08A,0x089,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x090,0x091,0x090,0x091,0x090,0x091,0x092,0x091,0x090,0x091,0x090,0x091,0x090,0x091,0x092,0x091,
 0x090,0x091,0x090,0x091,0x090,0x091,0x092,0x091,0x094,0x095,0x094,0x095,0x090,0x091,0x092,0x091,
 0x090,0x091,0x090,0x091,0x090,0x091,0x092,0x091,0x090,0x091,0x090,0x091,0x090,0x091,0x092,0x091,
 0x090,0x091,0x090,0x091,0x090,0x091,0x092,0x091,0x094,0x095,0x094,0x095,0x090,0x091,0x092,0x091,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x088,0x089,0x088,0x089,0x088,0x089,0x08A,0x089,0x088,0x089,0x088,0x089,0x088,0x089,0x08A,0x089,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x088,0x089,0x088,0x089,0x088,0x089,0x08A,0x089,0x088,0x089,0x088,0x089,0x088,0x089,0x08A,0x089,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x088,0x089,0x088,0x089,0x088,0x089,0x08A,0x089,0x088,0x089,0x088,0x089,0x088,0x089,0x08A,0x089,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x088,0x089,0x088,0x089,0x088,0x089,0x08A,0x089,0x088,0x089,0x088,0x089,0x088,0x089,0x08A,0x089,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x090,0x091,0x090,0x091,0x090,0x091,0x092,0x091,0x090,0x091,0x090,0x091,0x090,0x091,0x092,0x091,
 0x090,0x091,0x090,0x091,0x090,0x091,0x092,0x091,0x094,0x095,0x094,0x095,0x090,0x091,0x092,0x091,
 0x090,0x091,0x090,0x091,0x090,0x091,0x092,0x091,0x090,0x091,0x090,0x091,0x090,0x091,0x092,0x091,
 0x090,0x091,0x090,0x091,0x090,0x091,0x092,0x091,0x094,0x095,0x094,0x095,0x090,0x091,0x092,0x091,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x088,0x089,0x088,0x089,0x088,0x089,0x08A,0x089,0x088,0x089,0x088,0x089,0x088,0x089,0x08A,0x089,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x088,0x089,0x088,0x089,0x088,0x089,0x08A,0x089,0x088,0x089,0x088,0x089,0x088,0x089,0x08A,0x089,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x088,0x089,0x088,0x089,0x088,0x089,0x08A,0x089,0x088,0x089,0x088,0x089,0x088,0x089,0x08A,0x089,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x088,0x089,0x088,0x089,0x088,0x089,0x08A,0x089,0x088,0x089,0x088,0x089,0x088,0x089,0x08A,0x089,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x090,0x091,0x090,0x091,0x090,0x091,0x092,0x091,0x090,0x091,0x090,0x091,0x090,0x091,0x092,0x091,
 0x090,0x091,0x090,0x091,0x090,0x091,0x092,0x091,0x094,0x095,0x094,0x095,0x090,0x091,0x092,0x091,
 0x090,0x091,0x090,0x091,0x090,0x091,0x092,0x091,0x090,0x091,0x090,0x091,0x090,0x091,0x092,0x091,
 0x090,0x091,0x090,0x091,0x090,0x091,0x092,0x091,0x094,0x095,0x094,0x095,0x090,0x091,0x092,0x091,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x088,0x089,0x088,0x089,0x088,0x089,0x08A,0x089,0x088,0x089,0x088,0x089,0x088,0x089,0x08A,0x089,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x0A0,0x0A1,0x0A0,0x0A1,0x0A0,0x0A1,0x0A2,0x0A1,0x0A0,0x0A1,0x0A0,0x0A1,0x0A0,0x0A1,0x0A2,0x0A1,
 0x0A0,0x0A1,0x0A0,0x0A1,0x0A0,0x0A1,0x0A2,0x0A1,0x0A4,0x0A5,0x0A4,0x0A5,0x0A0,0x0A1,0x0A2,0x0A1,
 0x0A0,0x0A1,0x0A0,0x0A1,0x0A0,0x0A1,0x0A2,0x0A1,0x0A0,0x0A1,0x0A0,0x0A1,0x0A0,0x0A1,0x0A2,0x0A1,
 0x0A0,0x0A1,0x0A0,0x0A1,0x0A0,0x0A1,0x0A2,0x0A1,0x0A4,0x0A5,0x0A4,0x0A5,0x0A0,0x0A1,0x0A2,0x0A1,
 0x0A0,0x0A1,0x0A0,0x0A1,0x0A0,0x0A1,0x0A2,0x0A1,0x0A0,0x0A1,0x0A0,0x0A1,0x0A0,0x0A1,0x0A2,0x0A1,
 0x0A0,0x0A1,0x0A0,0x0A1,0x0A0,0x0A1,0x0A2,0x0A1,0x0A4,0x0A5,0x0A4,0x0A5,0x0A0,0x0A1,0x0A2,0x0A1,
 0x0A8,0x0A9,0x0A8,0x0A9,0x0A8,0x0A9,0x0AA,0x0A9,0x0A8,0x0A9,0x0A8,0x0A9,0x0A8,0x0A9,0x0AA,0x0A9,
 0x0A0,0x0A1,0x0A0,0x0A1,0x0A0,0x0A1,0x0A2,0x0A1,0x0A4,0x0A5,0x0A4,0x0A5,0x0A0,0x0A1,0x0A2,0x0A1,
 0x0A0,0x0A1,0x0A0,0x0A1,0x0A0,0x0A1,0x0A2,0x0A1,0x0A0,0x0A1,0x0A0,0x0A1,0x0A0,0x0A1,0x0A2,0x0A1,
 0x0A0,0x0A1,0x0A0,0x0A1,0x0A0,0x0A1,0x0A2,0x0A1,0x0A4,0x0A5,0x0A4,0x0A5,0x0A0,0x0A1,0x0A2,0x0A1,
 0x0A0,0x0A1,0x0A0,0x0A1,0x0A0,0x0A1,0x0A2,0x0A1,0x0A0,0x0A1,0x0A0,0x0A1,0x0A0,0x0A1,0x0A2,0x0A1,
 0x0A0,0x0A1,0x0A0,0x0A1,0x0A0,0x0A1,0x0A2,0x0A1,0x0A4,0x0A5,0x0A4,0x0A5,0x0A0,0x0A1,0x0A2,0x0A1,
 0x0A0,0x0A1,0x0A0,0x0A1,0x0A0,0x0A1,0x0A2,0x0A1,0x0A0,0x0A1,0x0A0,0x0A1,0x0A0,0x0A1,0x0A2,0x0A1,
 0x0A0,0x0A1,0x0A0,0x0A1,0x0A0,0x0A1,0x0A2,0x0A1,0x0A4,0x0A5,0x0A4,0x0A5,0x0A0,0x0A1,0x0A2,0x0A1,
 0x0A8,0x0A9,0x0A8,0x0A9,0x0A8,0x0A9,0x0AA,0x0A9,0x0A8,0x0A9,0x0A8,0x0A9,0x0A8,0x0A9,0x0AA,0x0A9,
 0x0A0,0x0A1,0x0A0,0x0A1,0x0A0,0x0A1,0x0A2,0x0A1,0x0A4,0x0A5,0x0A4,0x0A5,0x0A0,0x0A1,0x0A2,0x0A1,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x088,0x089,0x088,0x089,0x088,0x089,0x08A,0x089,0x088,0x089,0x088,0x089,0x088,0x089,0x08A,0x089,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x090,0x091,0x090,0x091,0x090,0x091,0x092,0x091,0x090,0x091,0x090,0x091,0x090,0x091,0x092,0x091,
 0x090,0x091,0x090,0x091,0x090,0x091,0x092,0x091,0x094,0x095,0x094,0x095,0x090,0x091,0x092,0x091,
 0x090,0x091,0x090,0x091,0x090,0x091,0x092,0x091,0x090,0x091,0x090,0x091,0x090,0x091,0x092,0x091,
 0x090,0x091,0x090,0x091,0x090,0x091,0x092,0x091,0x094,0x095,0x094,0x095,0x090,0x091,0x092,0x091,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x088,0x089,0x088,0x089,0x088,0x089,0x08A,0x089,0x088,0x089,0x088,0x089,0x088,0x089,0x08A,0x089,
 0x080,0x081,0x080,0x081,0x080,0x081,0x082,0x081,0x084,0x085,0x084,0x085,0x080,0x081,0x082,0x081,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x028,0x029,0x028,0x029,0x028,0x029,0x02A,0x029,0x028,0x029,0x028,0x029,0x028,0x029,0x02A,0x029,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x028,0x029,0x028,0x029,0x028,0x029,0x02A,0x029,0x028,0x029,0x028,0x029,0x028,0x029,0x02A,0x029,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x048,0x049,0x048,0x049,0x048,0x049,0x04A,0x049,0x048,0x049,0x048,0x049,0x048,0x049,0x04A,0x049,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x048,0x049,0x048,0x049,0x048,0x049,0x04A,0x049,0x048,0x049,0x048,0x049,0x048,0x049,0x04A,0x049,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x048,0x049,0x048,0x049,0x048,0x049,0x04A,0x049,0x048,0x049,0x048,0x049,0x048,0x049,0x04A,0x049,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x050,0x051,0x050,0x051,0x050,0x051,0x052,0x051,0x050,0x051,0x050,0x051,0x050,0x051,0x052,0x051,
 0x050,0x051,0x050,0x051,0x050,0x051,0x052,0x051,0x054,0x055,0x054,0x055,0x050,0x051,0x052,0x051,
 0x050,0x051,0x050,0x051,0x050,0x051,0x052,0x051,0x050,0x051,0x050,0x051,0x050,0x051,0x052,0x051,
 0x050,0x051,0x050,0x051,0x050,0x051,0x052,0x051,0x054,0x055,0x054,0x055,0x050,0x051,0x052,0x051,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x048,0x049,0x048,0x049,0x048,0x049,0x04A,0x049,0x048,0x049,0x048,0x049,0x048,0x049,0x04A,0x049,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x048,0x049,0x048,0x049,0x048,0x049,0x04A,0x049,0x048,0x049,0x048,0x049,0x048,0x049,0x04A,0x049,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x048,0x049,0x048,0x049,0x048,0x049,0x04A,0x049,0x048,0x049,0x048,0x049,0x048,0x049,0x04A,0x049,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x048,0x049,0x048,0x049,0x048,0x049,0x04A,0x049,0x048,0x049,0x048,0x049,0x048,0x049,0x04A,0x049,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x050,0x051,0x050,0x051,0x050,0x051,0x052,0x051,0x050,0x051,0x050,0x051,0x050,0x051,0x052,0x051,
 0x050,0x051,0x050,0x051,0x050,0x051,0x052,0x051,0x054,0x055,0x054,0x055,0x050,0x051,0x052,0x051,
 0x050,0x051,0x050,0x051,0x050,0x051,0x052,0x051,0x050,0x051,0x050,0x051,0x050,0x051,0x052,0x051,
 0x050,0x051,0x050,0x051,0x050,0x051,0x052,0x051,0x054,0x055,0x054,0x055,0x050,0x051,0x052,0x051,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x048,0x049,0x048,0x049,0x048,0x049,0x04A,0x049,0x048,0x049,0x048,0x049,0x048,0x049,0x04A,0x049,
 0x040,0x041,0x040,0x041,0x040,0x041,0x042,0x041,0x044,0x045,0x044,0x045,0x040,0x041,0x042,0x041,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x028,0x029,0x028,0x029,0x028,0x029,0x02A,0x029,0x028,0x029,0x028,0x029,0x028,0x029,0x02A,0x029,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x028,0x029,0x028,0x029,0x028,0x029,0x02A,0x029,0x028,0x029,0x028,0x029,0x028,0x029,0x02A,0x029,
 0x020,0x021,0x020,0x021,0x020,0x021,0x022,0x021,0x024,0x025,0x024,0x025,0x020,0x021,0x022,0x021,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,
 0x010,0x011,0x010,0x011,0x010,0x011,0x012,0x011,0x014,0x015,0x014,0x015,0x010,0x011,0x012,0x011,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
 0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,0x008,0x009,0x008,0x009,0x008,0x009,0x00A,0x009,
 0x000,0x001,0x000,0x001,0x000,0x001,0x002,0x001,0x004,0x005,0x004,0x005,0x000,0x001,0x002,0x001,
};

static const Genomecomp_T acceptor_bits[] =
{0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x10A,0x108,0x109,0x108,0x108,0x108,0x109,0x108,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x10A,0x108,0x109,0x108,0x108,0x108,0x109,0x108,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x110,0x112,0x110,0x111,0x110,0x110,0x110,0x111,0x110,
 0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x110,0x112,0x110,0x111,0x110,0x110,0x110,0x111,0x110,
 0x114,0x114,0x115,0x114,0x110,0x110,0x111,0x110,0x112,0x110,0x111,0x110,0x110,0x110,0x111,0x110,
 0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x110,0x112,0x110,0x111,0x110,0x110,0x110,0x111,0x110,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x10A,0x108,0x109,0x108,0x108,0x108,0x109,0x108,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x10A,0x108,0x109,0x108,0x108,0x108,0x109,0x108,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x10A,0x108,0x109,0x108,0x108,0x108,0x109,0x108,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x10A,0x108,0x109,0x108,0x108,0x108,0x109,0x108,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x110,0x112,0x110,0x111,0x110,0x110,0x110,0x111,0x110,
 0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x110,0x112,0x110,0x111,0x110,0x110,0x110,0x111,0x110,
 0x114,0x114,0x115,0x114,0x110,0x110,0x111,0x110,0x112,0x110,0x111,0x110,0x110,0x110,0x111,0x110,
 0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x110,0x112,0x110,0x111,0x110,0x110,0x110,0x111,0x110,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x10A,0x108,0x109,0x108,0x108,0x108,0x109,0x108,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x10A,0x108,0x109,0x108,0x108,0x108,0x109,0x108,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x120,0x122,0x120,0x121,0x120,0x120,0x120,0x121,0x120,
 0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x120,0x122,0x120,0x121,0x120,0x120,0x120,0x121,0x120,
 0x124,0x124,0x125,0x124,0x120,0x120,0x121,0x120,0x122,0x120,0x121,0x120,0x120,0x120,0x121,0x120,
 0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x120,0x122,0x120,0x121,0x120,0x120,0x120,0x121,0x120,
 0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x120,0x122,0x120,0x121,0x120,0x120,0x120,0x121,0x120,
 0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x120,0x122,0x120,0x121,0x120,0x120,0x120,0x121,0x120,
 0x124,0x124,0x125,0x124,0x120,0x120,0x121,0x120,0x122,0x120,0x121,0x120,0x120,0x120,0x121,0x120,
 0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x120,0x122,0x120,0x121,0x120,0x120,0x120,0x121,0x120,
 0x128,0x128,0x129,0x128,0x128,0x128,0x129,0x128,0x12A,0x128,0x129,0x128,0x128,0x128,0x129,0x128,
 0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x120,0x122,0x120,0x121,0x120,0x120,0x120,0x121,0x120,
 0x124,0x124,0x125,0x124,0x120,0x120,0x121,0x120,0x122,0x120,0x121,0x120,0x120,0x120,0x121,0x120,
 0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x120,0x122,0x120,0x121,0x120,0x120,0x120,0x121,0x120,
 0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x120,0x122,0x120,0x121,0x120,0x120,0x120,0x121,0x120,
 0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x120,0x122,0x120,0x121,0x120,0x120,0x120,0x121,0x120,
 0x124,0x124,0x125,0x124,0x120,0x120,0x121,0x120,0x122,0x120,0x121,0x120,0x120,0x120,0x121,0x120,
 0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x120,0x122,0x120,0x121,0x120,0x120,0x120,0x121,0x120,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x10A,0x108,0x109,0x108,0x108,0x108,0x109,0x108,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x110,0x112,0x110,0x111,0x110,0x110,0x110,0x111,0x110,
 0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x110,0x112,0x110,0x111,0x110,0x110,0x110,0x111,0x110,
 0x114,0x114,0x115,0x114,0x110,0x110,0x111,0x110,0x112,0x110,0x111,0x110,0x110,0x110,0x111,0x110,
 0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x110,0x112,0x110,0x111,0x110,0x110,0x110,0x111,0x110,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x10A,0x108,0x109,0x108,0x108,0x108,0x109,0x108,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x10A,0x108,0x109,0x108,0x108,0x108,0x109,0x108,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x10A,0x108,0x109,0x108,0x108,0x108,0x109,0x108,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x10A,0x108,0x109,0x108,0x108,0x108,0x109,0x108,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x110,0x112,0x110,0x111,0x110,0x110,0x110,0x111,0x110,
 0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x110,0x112,0x110,0x111,0x110,0x110,0x110,0x111,0x110,
 0x114,0x114,0x115,0x114,0x110,0x110,0x111,0x110,0x112,0x110,0x111,0x110,0x110,0x110,0x111,0x110,
 0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x110,0x112,0x110,0x111,0x110,0x110,0x110,0x111,0x110,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x10A,0x108,0x109,0x108,0x108,0x108,0x109,0x108,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x10A,0x108,0x109,0x108,0x108,0x108,0x109,0x108,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x10A,0x108,0x109,0x108,0x108,0x108,0x109,0x108,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x10A,0x108,0x109,0x108,0x108,0x108,0x109,0x108,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x110,0x112,0x110,0x111,0x110,0x110,0x110,0x111,0x110,
 0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x110,0x112,0x110,0x111,0x110,0x110,0x110,0x111,0x110,
 0x114,0x114,0x115,0x114,0x110,0x110,0x111,0x110,0x112,0x110,0x111,0x110,0x110,0x110,0x111,0x110,
 0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x110,0x112,0x110,0x111,0x110,0x110,0x110,0x111,0x110,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x10A,0x108,0x109,0x108,0x108,0x108,0x109,0x108,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x10A,0x108,0x109,0x108,0x108,0x108,0x109,0x108,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x10A,0x108,0x109,0x108,0x108,0x108,0x109,0x108,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x10A,0x108,0x109,0x108,0x108,0x108,0x109,0x108,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x110,0x112,0x110,0x111,0x110,0x110,0x110,0x111,0x110,
 0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x110,0x112,0x110,0x111,0x110,0x110,0x110,0x111,0x110,
 0x114,0x114,0x115,0x114,0x110,0x110,0x111,0x110,0x112,0x110,0x111,0x110,0x110,0x110,0x111,0x110,
 0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x110,0x112,0x110,0x111,0x110,0x110,0x110,0x111,0x110,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x10A,0x108,0x109,0x108,0x108,0x108,0x109,0x108,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x10A,0x108,0x109,0x108,0x108,0x108,0x109,0x108,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x120,0x122,0x120,0x121,0x120,0x120,0x120,0x121,0x120,
 0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x120,0x122,0x120,0x121,0x120,0x120,0x120,0x121,0x120,
 0x124,0x124,0x125,0x124,0x120,0x120,0x121,0x120,0x122,0x120,0x121,0x120,0x120,0x120,0x121,0x120,
 0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x120,0x122,0x120,0x121,0x120,0x120,0x120,0x121,0x120,
 0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x120,0x122,0x120,0x121,0x120,0x120,0x120,0x121,0x120,
 0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x120,0x122,0x120,0x121,0x120,0x120,0x120,0x121,0x120,
 0x124,0x124,0x125,0x124,0x120,0x120,0x121,0x120,0x122,0x120,0x121,0x120,0x120,0x120,0x121,0x120,
 0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x120,0x122,0x120,0x121,0x120,0x120,0x120,0x121,0x120,
 0x128,0x128,0x129,0x128,0x128,0x128,0x129,0x128,0x12A,0x128,0x129,0x128,0x128,0x128,0x129,0x128,
 0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x120,0x122,0x120,0x121,0x120,0x120,0x120,0x121,0x120,
 0x124,0x124,0x125,0x124,0x120,0x120,0x121,0x120,0x122,0x120,0x121,0x120,0x120,0x120,0x121,0x120,
 0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x120,0x122,0x120,0x121,0x120,0x120,0x120,0x121,0x120,
 0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x120,0x122,0x120,0x121,0x120,0x120,0x120,0x121,0x120,
 0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x120,0x122,0x120,0x121,0x120,0x120,0x120,0x121,0x120,
 0x124,0x124,0x125,0x124,0x120,0x120,0x121,0x120,0x122,0x120,0x121,0x120,0x120,0x120,0x121,0x120,
 0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x120,0x122,0x120,0x121,0x120,0x120,0x120,0x121,0x120,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x10A,0x108,0x109,0x108,0x108,0x108,0x109,0x108,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x110,0x112,0x110,0x111,0x110,0x110,0x110,0x111,0x110,
 0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x110,0x112,0x110,0x111,0x110,0x110,0x110,0x111,0x110,
 0x114,0x114,0x115,0x114,0x110,0x110,0x111,0x110,0x112,0x110,0x111,0x110,0x110,0x110,0x111,0x110,
 0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x110,0x112,0x110,0x111,0x110,0x110,0x110,0x111,0x110,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x10A,0x108,0x109,0x108,0x108,0x108,0x109,0x108,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x10A,0x108,0x109,0x108,0x108,0x108,0x109,0x108,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x10A,0x108,0x109,0x108,0x108,0x108,0x109,0x108,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x10A,0x108,0x109,0x108,0x108,0x108,0x109,0x108,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x110,0x112,0x110,0x111,0x110,0x110,0x110,0x111,0x110,
 0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x110,0x112,0x110,0x111,0x110,0x110,0x110,0x111,0x110,
 0x114,0x114,0x115,0x114,0x110,0x110,0x111,0x110,0x112,0x110,0x111,0x110,0x110,0x110,0x111,0x110,
 0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x110,0x112,0x110,0x111,0x110,0x110,0x110,0x111,0x110,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x10A,0x108,0x109,0x108,0x108,0x108,0x109,0x108,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x10A,0x108,0x109,0x108,0x108,0x108,0x109,0x108,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x140,0x142,0x140,0x141,0x140,0x140,0x140,0x141,0x140,
 0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x140,0x142,0x140,0x141,0x140,0x140,0x140,0x141,0x140,
 0x144,0x144,0x145,0x144,0x140,0x140,0x141,0x140,0x142,0x140,0x141,0x140,0x140,0x140,0x141,0x140,
 0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x140,0x142,0x140,0x141,0x140,0x140,0x140,0x141,0x140,
 0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x140,0x142,0x140,0x141,0x140,0x140,0x140,0x141,0x140,
 0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x140,0x142,0x140,0x141,0x140,0x140,0x140,0x141,0x140,
 0x144,0x144,0x145,0x144,0x140,0x140,0x141,0x140,0x142,0x140,0x141,0x140,0x140,0x140,0x141,0x140,
 0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x140,0x142,0x140,0x141,0x140,0x140,0x140,0x141,0x140,
 0x148,0x148,0x149,0x148,0x148,0x148,0x149,0x148,0x14A,0x148,0x149,0x148,0x148,0x148,0x149,0x148,
 0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x140,0x142,0x140,0x141,0x140,0x140,0x140,0x141,0x140,
 0x144,0x144,0x145,0x144,0x140,0x140,0x141,0x140,0x142,0x140,0x141,0x140,0x140,0x140,0x141,0x140,
 0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x140,0x142,0x140,0x141,0x140,0x140,0x140,0x141,0x140,
 0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x140,0x142,0x140,0x141,0x140,0x140,0x140,0x141,0x140,
 0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x140,0x142,0x140,0x141,0x140,0x140,0x140,0x141,0x140,
 0x144,0x144,0x145,0x144,0x140,0x140,0x141,0x140,0x142,0x140,0x141,0x140,0x140,0x140,0x141,0x140,
 0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x140,0x142,0x140,0x141,0x140,0x140,0x140,0x141,0x140,
 0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x140,0x142,0x140,0x141,0x140,0x140,0x140,0x141,0x140,
 0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x140,0x142,0x140,0x141,0x140,0x140,0x140,0x141,0x140,
 0x144,0x144,0x145,0x144,0x140,0x140,0x141,0x140,0x142,0x140,0x141,0x140,0x140,0x140,0x141,0x140,
 0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x140,0x142,0x140,0x141,0x140,0x140,0x140,0x141,0x140,
 0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x140,0x142,0x140,0x141,0x140,0x140,0x140,0x141,0x140,
 0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x140,0x142,0x140,0x141,0x140,0x140,0x140,0x141,0x140,
 0x144,0x144,0x145,0x144,0x140,0x140,0x141,0x140,0x142,0x140,0x141,0x140,0x140,0x140,0x141,0x140,
 0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x140,0x142,0x140,0x141,0x140,0x140,0x140,0x141,0x140,
 0x148,0x148,0x149,0x148,0x148,0x148,0x149,0x148,0x14A,0x148,0x149,0x148,0x148,0x148,0x149,0x148,
 0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x140,0x142,0x140,0x141,0x140,0x140,0x140,0x141,0x140,
 0x144,0x144,0x145,0x144,0x140,0x140,0x141,0x140,0x142,0x140,0x141,0x140,0x140,0x140,0x141,0x140,
 0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x140,0x142,0x140,0x141,0x140,0x140,0x140,0x141,0x140,
 0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x140,0x142,0x140,0x141,0x140,0x140,0x140,0x141,0x140,
 0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x140,0x142,0x140,0x141,0x140,0x140,0x140,0x141,0x140,
 0x144,0x144,0x145,0x144,0x140,0x140,0x141,0x140,0x142,0x140,0x141,0x140,0x140,0x140,0x141,0x140,
 0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x140,0x142,0x140,0x141,0x140,0x140,0x140,0x141,0x140,
 0x150,0x150,0x151,0x150,0x150,0x150,0x151,0x150,0x152,0x150,0x151,0x150,0x150,0x150,0x151,0x150,
 0x150,0x150,0x151,0x150,0x150,0x150,0x151,0x150,0x152,0x150,0x151,0x150,0x150,0x150,0x151,0x150,
 0x154,0x154,0x155,0x154,0x150,0x150,0x151,0x150,0x152,0x150,0x151,0x150,0x150,0x150,0x151,0x150,
 0x150,0x150,0x151,0x150,0x150,0x150,0x151,0x150,0x152,0x150,0x151,0x150,0x150,0x150,0x151,0x150,
 0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x140,0x142,0x140,0x141,0x140,0x140,0x140,0x141,0x140,
 0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x140,0x142,0x140,0x141,0x140,0x140,0x140,0x141,0x140,
 0x144,0x144,0x145,0x144,0x140,0x140,0x141,0x140,0x142,0x140,0x141,0x140,0x140,0x140,0x141,0x140,
 0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x140,0x142,0x140,0x141,0x140,0x140,0x140,0x141,0x140,
 0x148,0x148,0x149,0x148,0x148,0x148,0x149,0x148,0x14A,0x148,0x149,0x148,0x148,0x148,0x149,0x148,
 0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x140,0x142,0x140,0x141,0x140,0x140,0x140,0x141,0x140,
 0x144,0x144,0x145,0x144,0x140,0x140,0x141,0x140,0x142,0x140,0x141,0x140,0x140,0x140,0x141,0x140,
 0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x140,0x142,0x140,0x141,0x140,0x140,0x140,0x141,0x140,
 0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x140,0x142,0x140,0x141,0x140,0x140,0x140,0x141,0x140,
 0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x140,0x142,0x140,0x141,0x140,0x140,0x140,0x141,0x140,
 0x144,0x144,0x145,0x144,0x140,0x140,0x141,0x140,0x142,0x140,0x141,0x140,0x140,0x140,0x141,0x140,
 0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x140,0x142,0x140,0x141,0x140,0x140,0x140,0x141,0x140,
 0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x140,0x142,0x140,0x141,0x140,0x140,0x140,0x141,0x140,
 0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x140,0x142,0x140,0x141,0x140,0x140,0x140,0x141,0x140,
 0x144,0x144,0x145,0x144,0x140,0x140,0x141,0x140,0x142,0x140,0x141,0x140,0x140,0x140,0x141,0x140,
 0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x140,0x142,0x140,0x141,0x140,0x140,0x140,0x141,0x140,
 0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x140,0x142,0x140,0x141,0x140,0x140,0x140,0x141,0x140,
 0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x140,0x142,0x140,0x141,0x140,0x140,0x140,0x141,0x140,
 0x144,0x144,0x145,0x144,0x140,0x140,0x141,0x140,0x142,0x140,0x141,0x140,0x140,0x140,0x141,0x140,
 0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x140,0x142,0x140,0x141,0x140,0x140,0x140,0x141,0x140,
 0x148,0x148,0x149,0x148,0x148,0x148,0x149,0x148,0x14A,0x148,0x149,0x148,0x148,0x148,0x149,0x148,
 0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x140,0x142,0x140,0x141,0x140,0x140,0x140,0x141,0x140,
 0x144,0x144,0x145,0x144,0x140,0x140,0x141,0x140,0x142,0x140,0x141,0x140,0x140,0x140,0x141,0x140,
 0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x140,0x142,0x140,0x141,0x140,0x140,0x140,0x141,0x140,
 0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x140,0x142,0x140,0x141,0x140,0x140,0x140,0x141,0x140,
 0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x140,0x142,0x140,0x141,0x140,0x140,0x140,0x141,0x140,
 0x144,0x144,0x145,0x144,0x140,0x140,0x141,0x140,0x142,0x140,0x141,0x140,0x140,0x140,0x141,0x140,
 0x140,0x140,0x141,0x140,0x140,0x140,0x141,0x140,0x142,0x140,0x141,0x140,0x140,0x140,0x141,0x140,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x10A,0x108,0x109,0x108,0x108,0x108,0x109,0x108,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x10A,0x108,0x109,0x108,0x108,0x108,0x109,0x108,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x110,0x112,0x110,0x111,0x110,0x110,0x110,0x111,0x110,
 0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x110,0x112,0x110,0x111,0x110,0x110,0x110,0x111,0x110,
 0x114,0x114,0x115,0x114,0x110,0x110,0x111,0x110,0x112,0x110,0x111,0x110,0x110,0x110,0x111,0x110,
 0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x110,0x112,0x110,0x111,0x110,0x110,0x110,0x111,0x110,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x10A,0x108,0x109,0x108,0x108,0x108,0x109,0x108,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x10A,0x108,0x109,0x108,0x108,0x108,0x109,0x108,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x120,0x122,0x120,0x121,0x120,0x120,0x120,0x121,0x120,
 0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x120,0x122,0x120,0x121,0x120,0x120,0x120,0x121,0x120,
 0x124,0x124,0x125,0x124,0x120,0x120,0x121,0x120,0x122,0x120,0x121,0x120,0x120,0x120,0x121,0x120,
 0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x120,0x122,0x120,0x121,0x120,0x120,0x120,0x121,0x120,
 0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x120,0x122,0x120,0x121,0x120,0x120,0x120,0x121,0x120,
 0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x120,0x122,0x120,0x121,0x120,0x120,0x120,0x121,0x120,
 0x124,0x124,0x125,0x124,0x120,0x120,0x121,0x120,0x122,0x120,0x121,0x120,0x120,0x120,0x121,0x120,
 0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x120,0x122,0x120,0x121,0x120,0x120,0x120,0x121,0x120,
 0x128,0x128,0x129,0x128,0x128,0x128,0x129,0x128,0x12A,0x128,0x129,0x128,0x128,0x128,0x129,0x128,
 0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x120,0x122,0x120,0x121,0x120,0x120,0x120,0x121,0x120,
 0x124,0x124,0x125,0x124,0x120,0x120,0x121,0x120,0x122,0x120,0x121,0x120,0x120,0x120,0x121,0x120,
 0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x120,0x122,0x120,0x121,0x120,0x120,0x120,0x121,0x120,
 0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x120,0x122,0x120,0x121,0x120,0x120,0x120,0x121,0x120,
 0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x120,0x122,0x120,0x121,0x120,0x120,0x120,0x121,0x120,
 0x124,0x124,0x125,0x124,0x120,0x120,0x121,0x120,0x122,0x120,0x121,0x120,0x120,0x120,0x121,0x120,
 0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x120,0x122,0x120,0x121,0x120,0x120,0x120,0x121,0x120,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x10A,0x108,0x109,0x108,0x108,0x108,0x109,0x108,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x110,0x112,0x110,0x111,0x110,0x110,0x110,0x111,0x110,
 0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x110,0x112,0x110,0x111,0x110,0x110,0x110,0x111,0x110,
 0x114,0x114,0x115,0x114,0x110,0x110,0x111,0x110,0x112,0x110,0x111,0x110,0x110,0x110,0x111,0x110,
 0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x110,0x112,0x110,0x111,0x110,0x110,0x110,0x111,0x110,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x10A,0x108,0x109,0x108,0x108,0x108,0x109,0x108,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x10A,0x108,0x109,0x108,0x108,0x108,0x109,0x108,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x10A,0x108,0x109,0x108,0x108,0x108,0x109,0x108,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x10A,0x108,0x109,0x108,0x108,0x108,0x109,0x108,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x110,0x112,0x110,0x111,0x110,0x110,0x110,0x111,0x110,
 0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x110,0x112,0x110,0x111,0x110,0x110,0x110,0x111,0x110,
 0x114,0x114,0x115,0x114,0x110,0x110,0x111,0x110,0x112,0x110,0x111,0x110,0x110,0x110,0x111,0x110,
 0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x110,0x112,0x110,0x111,0x110,0x110,0x110,0x111,0x110,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x10A,0x108,0x109,0x108,0x108,0x108,0x109,0x108,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x10A,0x108,0x109,0x108,0x108,0x108,0x109,0x108,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x10A,0x108,0x109,0x108,0x108,0x108,0x109,0x108,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x10A,0x108,0x109,0x108,0x108,0x108,0x109,0x108,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x110,0x112,0x110,0x111,0x110,0x110,0x110,0x111,0x110,
 0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x110,0x112,0x110,0x111,0x110,0x110,0x110,0x111,0x110,
 0x114,0x114,0x115,0x114,0x110,0x110,0x111,0x110,0x112,0x110,0x111,0x110,0x110,0x110,0x111,0x110,
 0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x110,0x112,0x110,0x111,0x110,0x110,0x110,0x111,0x110,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x10A,0x108,0x109,0x108,0x108,0x108,0x109,0x108,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x10A,0x108,0x109,0x108,0x108,0x108,0x109,0x108,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x10A,0x108,0x109,0x108,0x108,0x108,0x109,0x108,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x10A,0x108,0x109,0x108,0x108,0x108,0x109,0x108,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x110,0x112,0x110,0x111,0x110,0x110,0x110,0x111,0x110,
 0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x110,0x112,0x110,0x111,0x110,0x110,0x110,0x111,0x110,
 0x114,0x114,0x115,0x114,0x110,0x110,0x111,0x110,0x112,0x110,0x111,0x110,0x110,0x110,0x111,0x110,
 0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x110,0x112,0x110,0x111,0x110,0x110,0x110,0x111,0x110,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x10A,0x108,0x109,0x108,0x108,0x108,0x109,0x108,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x10A,0x108,0x109,0x108,0x108,0x108,0x109,0x108,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x120,0x122,0x120,0x121,0x120,0x120,0x120,0x121,0x120,
 0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x120,0x122,0x120,0x121,0x120,0x120,0x120,0x121,0x120,
 0x124,0x124,0x125,0x124,0x120,0x120,0x121,0x120,0x122,0x120,0x121,0x120,0x120,0x120,0x121,0x120,
 0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x120,0x122,0x120,0x121,0x120,0x120,0x120,0x121,0x120,
 0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x120,0x122,0x120,0x121,0x120,0x120,0x120,0x121,0x120,
 0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x120,0x122,0x120,0x121,0x120,0x120,0x120,0x121,0x120,
 0x124,0x124,0x125,0x124,0x120,0x120,0x121,0x120,0x122,0x120,0x121,0x120,0x120,0x120,0x121,0x120,
 0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x120,0x122,0x120,0x121,0x120,0x120,0x120,0x121,0x120,
 0x128,0x128,0x129,0x128,0x128,0x128,0x129,0x128,0x12A,0x128,0x129,0x128,0x128,0x128,0x129,0x128,
 0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x120,0x122,0x120,0x121,0x120,0x120,0x120,0x121,0x120,
 0x124,0x124,0x125,0x124,0x120,0x120,0x121,0x120,0x122,0x120,0x121,0x120,0x120,0x120,0x121,0x120,
 0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x120,0x122,0x120,0x121,0x120,0x120,0x120,0x121,0x120,
 0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x120,0x122,0x120,0x121,0x120,0x120,0x120,0x121,0x120,
 0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x120,0x122,0x120,0x121,0x120,0x120,0x120,0x121,0x120,
 0x124,0x124,0x125,0x124,0x120,0x120,0x121,0x120,0x122,0x120,0x121,0x120,0x120,0x120,0x121,0x120,
 0x120,0x120,0x121,0x120,0x120,0x120,0x121,0x120,0x122,0x120,0x121,0x120,0x120,0x120,0x121,0x120,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x10A,0x108,0x109,0x108,0x108,0x108,0x109,0x108,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x110,0x112,0x110,0x111,0x110,0x110,0x110,0x111,0x110,
 0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x110,0x112,0x110,0x111,0x110,0x110,0x110,0x111,0x110,
 0x114,0x114,0x115,0x114,0x110,0x110,0x111,0x110,0x112,0x110,0x111,0x110,0x110,0x110,0x111,0x110,
 0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x110,0x112,0x110,0x111,0x110,0x110,0x110,0x111,0x110,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x10A,0x108,0x109,0x108,0x108,0x108,0x109,0x108,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x10A,0x108,0x109,0x108,0x108,0x108,0x109,0x108,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x10A,0x108,0x109,0x108,0x108,0x108,0x109,0x108,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x10A,0x108,0x109,0x108,0x108,0x108,0x109,0x108,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x110,0x112,0x110,0x111,0x110,0x110,0x110,0x111,0x110,
 0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x110,0x112,0x110,0x111,0x110,0x110,0x110,0x111,0x110,
 0x114,0x114,0x115,0x114,0x110,0x110,0x111,0x110,0x112,0x110,0x111,0x110,0x110,0x110,0x111,0x110,
 0x110,0x110,0x111,0x110,0x110,0x110,0x111,0x110,0x112,0x110,0x111,0x110,0x110,0x110,0x111,0x110,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x10A,0x108,0x109,0x108,0x108,0x108,0x109,0x108,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x108,0x108,0x109,0x108,0x108,0x108,0x109,0x108,0x10A,0x108,0x109,0x108,0x108,0x108,0x109,0x108,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x104,0x104,0x105,0x104,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x100,0x100,0x101,0x100,0x100,0x100,0x101,0x100,0x102,0x100,0x101,0x100,0x100,0x100,0x101,0x100,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x00A,0x008,0x009,0x008,0x008,0x008,0x009,0x008,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x00A,0x008,0x009,0x008,0x008,0x008,0x009,0x008,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x012,0x010,0x011,0x010,0x010,0x010,0x011,0x010,
 0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x012,0x010,0x011,0x010,0x010,0x010,0x011,0x010,
 0x014,0x014,0x015,0x014,0x010,0x010,0x011,0x010,0x012,0x010,0x011,0x010,0x010,0x010,0x011,0x010,
 0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x012,0x010,0x011,0x010,0x010,0x010,0x011,0x010,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x00A,0x008,0x009,0x008,0x008,0x008,0x009,0x008,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x00A,0x008,0x009,0x008,0x008,0x008,0x009,0x008,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x00A,0x008,0x009,0x008,0x008,0x008,0x009,0x008,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x00A,0x008,0x009,0x008,0x008,0x008,0x009,0x008,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x012,0x010,0x011,0x010,0x010,0x010,0x011,0x010,
 0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x012,0x010,0x011,0x010,0x010,0x010,0x011,0x010,
 0x014,0x014,0x015,0x014,0x010,0x010,0x011,0x010,0x012,0x010,0x011,0x010,0x010,0x010,0x011,0x010,
 0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x012,0x010,0x011,0x010,0x010,0x010,0x011,0x010,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x00A,0x008,0x009,0x008,0x008,0x008,0x009,0x008,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x00A,0x008,0x009,0x008,0x008,0x008,0x009,0x008,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x022,0x020,0x021,0x020,0x020,0x020,0x021,0x020,
 0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x022,0x020,0x021,0x020,0x020,0x020,0x021,0x020,
 0x024,0x024,0x025,0x024,0x020,0x020,0x021,0x020,0x022,0x020,0x021,0x020,0x020,0x020,0x021,0x020,
 0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x022,0x020,0x021,0x020,0x020,0x020,0x021,0x020,
 0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x022,0x020,0x021,0x020,0x020,0x020,0x021,0x020,
 0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x022,0x020,0x021,0x020,0x020,0x020,0x021,0x020,
 0x024,0x024,0x025,0x024,0x020,0x020,0x021,0x020,0x022,0x020,0x021,0x020,0x020,0x020,0x021,0x020,
 0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x022,0x020,0x021,0x020,0x020,0x020,0x021,0x020,
 0x028,0x028,0x029,0x028,0x028,0x028,0x029,0x028,0x02A,0x028,0x029,0x028,0x028,0x028,0x029,0x028,
 0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x022,0x020,0x021,0x020,0x020,0x020,0x021,0x020,
 0x024,0x024,0x025,0x024,0x020,0x020,0x021,0x020,0x022,0x020,0x021,0x020,0x020,0x020,0x021,0x020,
 0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x022,0x020,0x021,0x020,0x020,0x020,0x021,0x020,
 0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x022,0x020,0x021,0x020,0x020,0x020,0x021,0x020,
 0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x022,0x020,0x021,0x020,0x020,0x020,0x021,0x020,
 0x024,0x024,0x025,0x024,0x020,0x020,0x021,0x020,0x022,0x020,0x021,0x020,0x020,0x020,0x021,0x020,
 0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x022,0x020,0x021,0x020,0x020,0x020,0x021,0x020,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x00A,0x008,0x009,0x008,0x008,0x008,0x009,0x008,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x012,0x010,0x011,0x010,0x010,0x010,0x011,0x010,
 0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x012,0x010,0x011,0x010,0x010,0x010,0x011,0x010,
 0x014,0x014,0x015,0x014,0x010,0x010,0x011,0x010,0x012,0x010,0x011,0x010,0x010,0x010,0x011,0x010,
 0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x012,0x010,0x011,0x010,0x010,0x010,0x011,0x010,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x00A,0x008,0x009,0x008,0x008,0x008,0x009,0x008,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x00A,0x008,0x009,0x008,0x008,0x008,0x009,0x008,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x00A,0x008,0x009,0x008,0x008,0x008,0x009,0x008,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x00A,0x008,0x009,0x008,0x008,0x008,0x009,0x008,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x012,0x010,0x011,0x010,0x010,0x010,0x011,0x010,
 0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x012,0x010,0x011,0x010,0x010,0x010,0x011,0x010,
 0x014,0x014,0x015,0x014,0x010,0x010,0x011,0x010,0x012,0x010,0x011,0x010,0x010,0x010,0x011,0x010,
 0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x012,0x010,0x011,0x010,0x010,0x010,0x011,0x010,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x00A,0x008,0x009,0x008,0x008,0x008,0x009,0x008,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x00A,0x008,0x009,0x008,0x008,0x008,0x009,0x008,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x00A,0x008,0x009,0x008,0x008,0x008,0x009,0x008,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x00A,0x008,0x009,0x008,0x008,0x008,0x009,0x008,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x012,0x010,0x011,0x010,0x010,0x010,0x011,0x010,
 0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x012,0x010,0x011,0x010,0x010,0x010,0x011,0x010,
 0x014,0x014,0x015,0x014,0x010,0x010,0x011,0x010,0x012,0x010,0x011,0x010,0x010,0x010,0x011,0x010,
 0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x012,0x010,0x011,0x010,0x010,0x010,0x011,0x010,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x00A,0x008,0x009,0x008,0x008,0x008,0x009,0x008,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x00A,0x008,0x009,0x008,0x008,0x008,0x009,0x008,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x00A,0x008,0x009,0x008,0x008,0x008,0x009,0x008,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x00A,0x008,0x009,0x008,0x008,0x008,0x009,0x008,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x012,0x010,0x011,0x010,0x010,0x010,0x011,0x010,
 0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x012,0x010,0x011,0x010,0x010,0x010,0x011,0x010,
 0x014,0x014,0x015,0x014,0x010,0x010,0x011,0x010,0x012,0x010,0x011,0x010,0x010,0x010,0x011,0x010,
 0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x012,0x010,0x011,0x010,0x010,0x010,0x011,0x010,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x00A,0x008,0x009,0x008,0x008,0x008,0x009,0x008,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x00A,0x008,0x009,0x008,0x008,0x008,0x009,0x008,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x022,0x020,0x021,0x020,0x020,0x020,0x021,0x020,
 0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x022,0x020,0x021,0x020,0x020,0x020,0x021,0x020,
 0x024,0x024,0x025,0x024,0x020,0x020,0x021,0x020,0x022,0x020,0x021,0x020,0x020,0x020,0x021,0x020,
 0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x022,0x020,0x021,0x020,0x020,0x020,0x021,0x020,
 0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x022,0x020,0x021,0x020,0x020,0x020,0x021,0x020,
 0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x022,0x020,0x021,0x020,0x020,0x020,0x021,0x020,
 0x024,0x024,0x025,0x024,0x020,0x020,0x021,0x020,0x022,0x020,0x021,0x020,0x020,0x020,0x021,0x020,
 0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x022,0x020,0x021,0x020,0x020,0x020,0x021,0x020,
 0x028,0x028,0x029,0x028,0x028,0x028,0x029,0x028,0x02A,0x028,0x029,0x028,0x028,0x028,0x029,0x028,
 0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x022,0x020,0x021,0x020,0x020,0x020,0x021,0x020,
 0x024,0x024,0x025,0x024,0x020,0x020,0x021,0x020,0x022,0x020,0x021,0x020,0x020,0x020,0x021,0x020,
 0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x022,0x020,0x021,0x020,0x020,0x020,0x021,0x020,
 0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x022,0x020,0x021,0x020,0x020,0x020,0x021,0x020,
 0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x022,0x020,0x021,0x020,0x020,0x020,0x021,0x020,
 0x024,0x024,0x025,0x024,0x020,0x020,0x021,0x020,0x022,0x020,0x021,0x020,0x020,0x020,0x021,0x020,
 0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x022,0x020,0x021,0x020,0x020,0x020,0x021,0x020,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x00A,0x008,0x009,0x008,0x008,0x008,0x009,0x008,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x012,0x010,0x011,0x010,0x010,0x010,0x011,0x010,
 0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x012,0x010,0x011,0x010,0x010,0x010,0x011,0x010,
 0x014,0x014,0x015,0x014,0x010,0x010,0x011,0x010,0x012,0x010,0x011,0x010,0x010,0x010,0x011,0x010,
 0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x012,0x010,0x011,0x010,0x010,0x010,0x011,0x010,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x00A,0x008,0x009,0x008,0x008,0x008,0x009,0x008,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x00A,0x008,0x009,0x008,0x008,0x008,0x009,0x008,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x00A,0x008,0x009,0x008,0x008,0x008,0x009,0x008,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x00A,0x008,0x009,0x008,0x008,0x008,0x009,0x008,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x012,0x010,0x011,0x010,0x010,0x010,0x011,0x010,
 0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x012,0x010,0x011,0x010,0x010,0x010,0x011,0x010,
 0x014,0x014,0x015,0x014,0x010,0x010,0x011,0x010,0x012,0x010,0x011,0x010,0x010,0x010,0x011,0x010,
 0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x012,0x010,0x011,0x010,0x010,0x010,0x011,0x010,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x00A,0x008,0x009,0x008,0x008,0x008,0x009,0x008,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x00A,0x008,0x009,0x008,0x008,0x008,0x009,0x008,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x042,0x040,0x041,0x040,0x040,0x040,0x041,0x040,
 0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x042,0x040,0x041,0x040,0x040,0x040,0x041,0x040,
 0x044,0x044,0x045,0x044,0x040,0x040,0x041,0x040,0x042,0x040,0x041,0x040,0x040,0x040,0x041,0x040,
 0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x042,0x040,0x041,0x040,0x040,0x040,0x041,0x040,
 0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x042,0x040,0x041,0x040,0x040,0x040,0x041,0x040,
 0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x042,0x040,0x041,0x040,0x040,0x040,0x041,0x040,
 0x044,0x044,0x045,0x044,0x040,0x040,0x041,0x040,0x042,0x040,0x041,0x040,0x040,0x040,0x041,0x040,
 0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x042,0x040,0x041,0x040,0x040,0x040,0x041,0x040,
 0x048,0x048,0x049,0x048,0x048,0x048,0x049,0x048,0x04A,0x048,0x049,0x048,0x048,0x048,0x049,0x048,
 0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x042,0x040,0x041,0x040,0x040,0x040,0x041,0x040,
 0x044,0x044,0x045,0x044,0x040,0x040,0x041,0x040,0x042,0x040,0x041,0x040,0x040,0x040,0x041,0x040,
 0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x042,0x040,0x041,0x040,0x040,0x040,0x041,0x040,
 0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x042,0x040,0x041,0x040,0x040,0x040,0x041,0x040,
 0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x042,0x040,0x041,0x040,0x040,0x040,0x041,0x040,
 0x044,0x044,0x045,0x044,0x040,0x040,0x041,0x040,0x042,0x040,0x041,0x040,0x040,0x040,0x041,0x040,
 0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x042,0x040,0x041,0x040,0x040,0x040,0x041,0x040,
 0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x042,0x040,0x041,0x040,0x040,0x040,0x041,0x040,
 0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x042,0x040,0x041,0x040,0x040,0x040,0x041,0x040,
 0x044,0x044,0x045,0x044,0x040,0x040,0x041,0x040,0x042,0x040,0x041,0x040,0x040,0x040,0x041,0x040,
 0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x042,0x040,0x041,0x040,0x040,0x040,0x041,0x040,
 0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x042,0x040,0x041,0x040,0x040,0x040,0x041,0x040,
 0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x042,0x040,0x041,0x040,0x040,0x040,0x041,0x040,
 0x044,0x044,0x045,0x044,0x040,0x040,0x041,0x040,0x042,0x040,0x041,0x040,0x040,0x040,0x041,0x040,
 0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x042,0x040,0x041,0x040,0x040,0x040,0x041,0x040,
 0x048,0x048,0x049,0x048,0x048,0x048,0x049,0x048,0x04A,0x048,0x049,0x048,0x048,0x048,0x049,0x048,
 0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x042,0x040,0x041,0x040,0x040,0x040,0x041,0x040,
 0x044,0x044,0x045,0x044,0x040,0x040,0x041,0x040,0x042,0x040,0x041,0x040,0x040,0x040,0x041,0x040,
 0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x042,0x040,0x041,0x040,0x040,0x040,0x041,0x040,
 0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x042,0x040,0x041,0x040,0x040,0x040,0x041,0x040,
 0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x042,0x040,0x041,0x040,0x040,0x040,0x041,0x040,
 0x044,0x044,0x045,0x044,0x040,0x040,0x041,0x040,0x042,0x040,0x041,0x040,0x040,0x040,0x041,0x040,
 0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x042,0x040,0x041,0x040,0x040,0x040,0x041,0x040,
 0x050,0x050,0x051,0x050,0x050,0x050,0x051,0x050,0x052,0x050,0x051,0x050,0x050,0x050,0x051,0x050,
 0x050,0x050,0x051,0x050,0x050,0x050,0x051,0x050,0x052,0x050,0x051,0x050,0x050,0x050,0x051,0x050,
 0x054,0x054,0x055,0x054,0x050,0x050,0x051,0x050,0x052,0x050,0x051,0x050,0x050,0x050,0x051,0x050,
 0x050,0x050,0x051,0x050,0x050,0x050,0x051,0x050,0x052,0x050,0x051,0x050,0x050,0x050,0x051,0x050,
 0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x042,0x040,0x041,0x040,0x040,0x040,0x041,0x040,
 0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x042,0x040,0x041,0x040,0x040,0x040,0x041,0x040,
 0x044,0x044,0x045,0x044,0x040,0x040,0x041,0x040,0x042,0x040,0x041,0x040,0x040,0x040,0x041,0x040,
 0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x042,0x040,0x041,0x040,0x040,0x040,0x041,0x040,
 0x048,0x048,0x049,0x048,0x048,0x048,0x049,0x048,0x04A,0x048,0x049,0x048,0x048,0x048,0x049,0x048,
 0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x042,0x040,0x041,0x040,0x040,0x040,0x041,0x040,
 0x044,0x044,0x045,0x044,0x040,0x040,0x041,0x040,0x042,0x040,0x041,0x040,0x040,0x040,0x041,0x040,
 0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x042,0x040,0x041,0x040,0x040,0x040,0x041,0x040,
 0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x042,0x040,0x041,0x040,0x040,0x040,0x041,0x040,
 0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x042,0x040,0x041,0x040,0x040,0x040,0x041,0x040,
 0x044,0x044,0x045,0x044,0x040,0x040,0x041,0x040,0x042,0x040,0x041,0x040,0x040,0x040,0x041,0x040,
 0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x042,0x040,0x041,0x040,0x040,0x040,0x041,0x040,
 0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x042,0x040,0x041,0x040,0x040,0x040,0x041,0x040,
 0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x042,0x040,0x041,0x040,0x040,0x040,0x041,0x040,
 0x044,0x044,0x045,0x044,0x040,0x040,0x041,0x040,0x042,0x040,0x041,0x040,0x040,0x040,0x041,0x040,
 0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x042,0x040,0x041,0x040,0x040,0x040,0x041,0x040,
 0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x042,0x040,0x041,0x040,0x040,0x040,0x041,0x040,
 0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x042,0x040,0x041,0x040,0x040,0x040,0x041,0x040,
 0x044,0x044,0x045,0x044,0x040,0x040,0x041,0x040,0x042,0x040,0x041,0x040,0x040,0x040,0x041,0x040,
 0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x042,0x040,0x041,0x040,0x040,0x040,0x041,0x040,
 0x048,0x048,0x049,0x048,0x048,0x048,0x049,0x048,0x04A,0x048,0x049,0x048,0x048,0x048,0x049,0x048,
 0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x042,0x040,0x041,0x040,0x040,0x040,0x041,0x040,
 0x044,0x044,0x045,0x044,0x040,0x040,0x041,0x040,0x042,0x040,0x041,0x040,0x040,0x040,0x041,0x040,
 0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x042,0x040,0x041,0x040,0x040,0x040,0x041,0x040,
 0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x042,0x040,0x041,0x040,0x040,0x040,0x041,0x040,
 0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x042,0x040,0x041,0x040,0x040,0x040,0x041,0x040,
 0x044,0x044,0x045,0x044,0x040,0x040,0x041,0x040,0x042,0x040,0x041,0x040,0x040,0x040,0x041,0x040,
 0x040,0x040,0x041,0x040,0x040,0x040,0x041,0x040,0x042,0x040,0x041,0x040,0x040,0x040,0x041,0x040,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x00A,0x008,0x009,0x008,0x008,0x008,0x009,0x008,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x00A,0x008,0x009,0x008,0x008,0x008,0x009,0x008,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x012,0x010,0x011,0x010,0x010,0x010,0x011,0x010,
 0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x012,0x010,0x011,0x010,0x010,0x010,0x011,0x010,
 0x014,0x014,0x015,0x014,0x010,0x010,0x011,0x010,0x012,0x010,0x011,0x010,0x010,0x010,0x011,0x010,
 0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x012,0x010,0x011,0x010,0x010,0x010,0x011,0x010,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x00A,0x008,0x009,0x008,0x008,0x008,0x009,0x008,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x00A,0x008,0x009,0x008,0x008,0x008,0x009,0x008,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x022,0x020,0x021,0x020,0x020,0x020,0x021,0x020,
 0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x022,0x020,0x021,0x020,0x020,0x020,0x021,0x020,
 0x024,0x024,0x025,0x024,0x020,0x020,0x021,0x020,0x022,0x020,0x021,0x020,0x020,0x020,0x021,0x020,
 0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x022,0x020,0x021,0x020,0x020,0x020,0x021,0x020,
 0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x022,0x020,0x021,0x020,0x020,0x020,0x021,0x020,
 0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x022,0x020,0x021,0x020,0x020,0x020,0x021,0x020,
 0x024,0x024,0x025,0x024,0x020,0x020,0x021,0x020,0x022,0x020,0x021,0x020,0x020,0x020,0x021,0x020,
 0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x022,0x020,0x021,0x020,0x020,0x020,0x021,0x020,
 0x028,0x028,0x029,0x028,0x028,0x028,0x029,0x028,0x02A,0x028,0x029,0x028,0x028,0x028,0x029,0x028,
 0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x022,0x020,0x021,0x020,0x020,0x020,0x021,0x020,
 0x024,0x024,0x025,0x024,0x020,0x020,0x021,0x020,0x022,0x020,0x021,0x020,0x020,0x020,0x021,0x020,
 0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x022,0x020,0x021,0x020,0x020,0x020,0x021,0x020,
 0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x022,0x020,0x021,0x020,0x020,0x020,0x021,0x020,
 0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x022,0x020,0x021,0x020,0x020,0x020,0x021,0x020,
 0x024,0x024,0x025,0x024,0x020,0x020,0x021,0x020,0x022,0x020,0x021,0x020,0x020,0x020,0x021,0x020,
 0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x022,0x020,0x021,0x020,0x020,0x020,0x021,0x020,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x00A,0x008,0x009,0x008,0x008,0x008,0x009,0x008,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x012,0x010,0x011,0x010,0x010,0x010,0x011,0x010,
 0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x012,0x010,0x011,0x010,0x010,0x010,0x011,0x010,
 0x014,0x014,0x015,0x014,0x010,0x010,0x011,0x010,0x012,0x010,0x011,0x010,0x010,0x010,0x011,0x010,
 0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x012,0x010,0x011,0x010,0x010,0x010,0x011,0x010,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x00A,0x008,0x009,0x008,0x008,0x008,0x009,0x008,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x00A,0x008,0x009,0x008,0x008,0x008,0x009,0x008,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x00A,0x008,0x009,0x008,0x008,0x008,0x009,0x008,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x00A,0x008,0x009,0x008,0x008,0x008,0x009,0x008,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x012,0x010,0x011,0x010,0x010,0x010,0x011,0x010,
 0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x012,0x010,0x011,0x010,0x010,0x010,0x011,0x010,
 0x014,0x014,0x015,0x014,0x010,0x010,0x011,0x010,0x012,0x010,0x011,0x010,0x010,0x010,0x011,0x010,
 0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x012,0x010,0x011,0x010,0x010,0x010,0x011,0x010,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x00A,0x008,0x009,0x008,0x008,0x008,0x009,0x008,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x00A,0x008,0x009,0x008,0x008,0x008,0x009,0x008,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x00A,0x008,0x009,0x008,0x008,0x008,0x009,0x008,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x00A,0x008,0x009,0x008,0x008,0x008,0x009,0x008,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x012,0x010,0x011,0x010,0x010,0x010,0x011,0x010,
 0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x012,0x010,0x011,0x010,0x010,0x010,0x011,0x010,
 0x014,0x014,0x015,0x014,0x010,0x010,0x011,0x010,0x012,0x010,0x011,0x010,0x010,0x010,0x011,0x010,
 0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x012,0x010,0x011,0x010,0x010,0x010,0x011,0x010,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x00A,0x008,0x009,0x008,0x008,0x008,0x009,0x008,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x00A,0x008,0x009,0x008,0x008,0x008,0x009,0x008,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x00A,0x008,0x009,0x008,0x008,0x008,0x009,0x008,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x00A,0x008,0x009,0x008,0x008,0x008,0x009,0x008,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x012,0x010,0x011,0x010,0x010,0x010,0x011,0x010,
 0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x012,0x010,0x011,0x010,0x010,0x010,0x011,0x010,
 0x014,0x014,0x015,0x014,0x010,0x010,0x011,0x010,0x012,0x010,0x011,0x010,0x010,0x010,0x011,0x010,
 0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x012,0x010,0x011,0x010,0x010,0x010,0x011,0x010,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x00A,0x008,0x009,0x008,0x008,0x008,0x009,0x008,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x00A,0x008,0x009,0x008,0x008,0x008,0x009,0x008,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x022,0x020,0x021,0x020,0x020,0x020,0x021,0x020,
 0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x022,0x020,0x021,0x020,0x020,0x020,0x021,0x020,
 0x024,0x024,0x025,0x024,0x020,0x020,0x021,0x020,0x022,0x020,0x021,0x020,0x020,0x020,0x021,0x020,
 0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x022,0x020,0x021,0x020,0x020,0x020,0x021,0x020,
 0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x022,0x020,0x021,0x020,0x020,0x020,0x021,0x020,
 0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x022,0x020,0x021,0x020,0x020,0x020,0x021,0x020,
 0x024,0x024,0x025,0x024,0x020,0x020,0x021,0x020,0x022,0x020,0x021,0x020,0x020,0x020,0x021,0x020,
 0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x022,0x020,0x021,0x020,0x020,0x020,0x021,0x020,
 0x028,0x028,0x029,0x028,0x028,0x028,0x029,0x028,0x02A,0x028,0x029,0x028,0x028,0x028,0x029,0x028,
 0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x022,0x020,0x021,0x020,0x020,0x020,0x021,0x020,
 0x024,0x024,0x025,0x024,0x020,0x020,0x021,0x020,0x022,0x020,0x021,0x020,0x020,0x020,0x021,0x020,
 0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x022,0x020,0x021,0x020,0x020,0x020,0x021,0x020,
 0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x022,0x020,0x021,0x020,0x020,0x020,0x021,0x020,
 0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x022,0x020,0x021,0x020,0x020,0x020,0x021,0x020,
 0x024,0x024,0x025,0x024,0x020,0x020,0x021,0x020,0x022,0x020,0x021,0x020,0x020,0x020,0x021,0x020,
 0x020,0x020,0x021,0x020,0x020,0x020,0x021,0x020,0x022,0x020,0x021,0x020,0x020,0x020,0x021,0x020,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x00A,0x008,0x009,0x008,0x008,0x008,0x009,0x008,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x012,0x010,0x011,0x010,0x010,0x010,0x011,0x010,
 0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x012,0x010,0x011,0x010,0x010,0x010,0x011,0x010,
 0x014,0x014,0x015,0x014,0x010,0x010,0x011,0x010,0x012,0x010,0x011,0x010,0x010,0x010,0x011,0x010,
 0x010,0x010,0x011,0x010,0x010,0x010,0x011,0x010,0x012,0x010,0x011,0x010,0x010,0x010,0x011,0x010,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x00A,0x008,0x009,0x008,0x008,0x008,0x009,0x008,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x00A,0x008,0x009,0x008,0x008,0x008,0x009,0x008,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x008,0x008,0x009,0x008,0x008,0x008,0x009,0x008,0x00A,0x008,0x009,0x008,0x008,0x008,0x009,0x008,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x004,0x004,0x005,0x004,0x000,0x000,0x001,0x000,0x002,0x000,0x001,0x000,0x000,0x000,0x001,0x000,
 0x000,0x000,0x001,0x000,0x000,0x0