/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.na12878kb.core.errors;

import com.mongodb.BasicDBObject;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import org.broadinstitute.sting.gatk.walkers.na12878kb.core.MongoVariantContext;
import org.broadinstitute.sting.gatk.walkers.na12878kb.core.errors.InvalidRecordsLogError;
import org.broadinstitute.sting.gatk.walkers.na12878kb.core.errors.MongoVariantContextException;

public class InvalidRecordsRemove<T extends MongoVariantContext>
extends InvalidRecordsLogError<T> {
    final DBCollection source;

    public InvalidRecordsRemove(DBCollection source) {
        if (source == null) {
            throw new IllegalArgumentException("source cannot be null");
        }
        this.source = source;
    }

    @Override
    public void handleFailedRecord(T record, MongoVariantContextException e) {
        super.handleFailedRecord(record, e);
        logger.warn((Object)("Removing invalid record " + record + " from " + this.source));
        this.source.remove((DBObject)new BasicDBObject("_id", record.get_id()));
    }
}

