########################################################################
#
#    Vision Network - Python source code - file generated by vision
#    Friday 13 April 2007 13:54:33 
#    
#       The Scripps Research Institute (TSRI)
#       Molecular Graphics Lab
#       La Jolla, CA 92037, USA
#
# Copyright: Daniel Stoffler, Michel Sanner and TSRI
#   
# revision: Guillaume Vareille
#  
#########################################################################
#
# $Header: /opt/cvs/python/packages/share1.5/Vision/doc/Examples/matplotlib/TablePlot_net.py,v 1.3 2007/08/29 20:37:16 vareille Exp $
#
# $Id: TablePlot_net.py,v 1.3 2007/08/29 20:37:16 vareille Exp $
#

from traceback import print_exc
## loading libraries ##
from Vision.matplotlibNodes import matplotliblib
masterNet.getEditor().addLibraryInstance(matplotliblib,"Vision.matplotlibNodes", "matplotliblib")

from Vision.StandardNodes import stdlib
masterNet.getEditor().addLibraryInstance(stdlib,"Vision.StandardNodes", "stdlib")

try:
    ## saving node TablePlot ##
    from Vision.matplotlibNodes import TablePlotNE
    TablePlot_154 = TablePlotNE(constrkw = {}, name='TablePlot', library=matplotliblib)
    masterNet.addNode(TablePlot_154,111,400)
except:
    print "WARNING: failed to restore TablePlotNE named TablePlot in network masterNet"
    print_exc()
    TablePlot_154=None

try:
    ## saving node ReadTable ##
    from Vision.StandardNodes import ReadTable
    ReadTable_155 = ReadTable(constrkw = {}, name='ReadTable', library=stdlib)
    masterNet.addNode(ReadTable_155,19,36)
    ReadTable_155.inputPortByName['filename'].widget.set("Data/table_data_values.dat", run=False)
    ReadTable_155.inputPortByName['sep'].widget.set(",", run=False)
    apply(ReadTable_155.configure, (), {'expanded': True})
except:
    print "WARNING: failed to restore ReadTable named ReadTable in network masterNet"
    print_exc()
    ReadTable_155=None

try:
    ## saving node Draw Area ##
    from Vision.matplotlibNodes import MPLDrawAreaNE
    Draw_Area_156 = MPLDrawAreaNE(constrkw = {}, name='Draw Area', library=matplotliblib)
    masterNet.addNode(Draw_Area_156,389,360)
    Draw_Area_156.inputPortByName['left'].widget.set(0.2, run=False)
    Draw_Area_156.inputPortByName['bottom'].widget.set(0.2, run=False)
    Draw_Area_156.inputPortByName['width'].widget.set(0.7, run=False)
    Draw_Area_156.inputPortByName['height'].widget.set(0.666666666667, run=False)
    Draw_Area_156.inputPortByName['title'].widget.set("", run=False)
    Draw_Area_156.inputPortByName['xlabel'].widget.set("", run=False)
    Draw_Area_156.inputPortByName['ylabel'].widget.set("", run=False)
except:
    print "WARNING: failed to restore MPLDrawAreaNE named Draw Area in network masterNet"
    print_exc()
    Draw_Area_156=None

try:
    ## saving node ReadTable ##
    from Vision.StandardNodes import ReadTable
    ReadTable_157 = ReadTable(constrkw = {}, name='ReadTable', library=stdlib)
    masterNet.addNode(ReadTable_157,253,35)
    ReadTable_157.inputPortByName['filename'].widget.set("Data/table_data_string.dat", run=False)
    ReadTable_157.inputPortByName['sep'].widget.set(",", run=False)
    apply(ReadTable_157.configure, (), {'expanded': True})
except:
    print "WARNING: failed to restore ReadTable named ReadTable in network masterNet"
    print_exc()
    ReadTable_157=None

try:
    ## saving node Index ##
    from Vision.StandardNodes import Index
    Index_158 = Index(constrkw = {}, name='Index', library=stdlib)
    masterNet.addNode(Index_158,146,200)
    apply(Index_158.configure, (), {'expanded': True})
except:
    print "WARNING: failed to restore Index named Index in network masterNet"
    print_exc()
    Index_158=None

try:
    ## saving node Index ##
    from Vision.StandardNodes import Index
    Index_159 = Index(constrkw = {}, name='Index', library=stdlib)
    masterNet.addNode(Index_159,295,202)
    apply(Index_159.inputPortByName['index'].widget.configure, (), {'max': 1})
    Index_159.inputPortByName['index'].widget.set(1, run=False)
    apply(Index_159.configure, (), {'expanded': True})
except:
    print "WARNING: failed to restore Index named Index in network masterNet"
    print_exc()
    Index_159=None

try:
    ## saving node ReadTable ##
    from Vision.StandardNodes import ReadTable
    ReadTable_160 = ReadTable(constrkw = {}, name='ReadTable', library=stdlib)
    masterNet.addNode(ReadTable_160,485,35)
    ReadTable_160.inputPortByName['filename'].widget.set("Data/table_data_colors.dat", run=False)
    ReadTable_160.inputPortByName['sep'].widget.set(",", run=False)
    ReadTable_160.inputPortByName['datatype'].widget.set("float", run=False)
    apply(ReadTable_160.configure, (), {'expanded': True})
except:
    print "WARNING: failed to restore ReadTable named ReadTable in network masterNet"
    print_exc()
    ReadTable_160=None

try:
    ## saving node As Type ##
    from Vision.StandardNodes import AsType
    As_Type_161 = AsType(constrkw = {}, name='As Type', library=stdlib)
    masterNet.addNode(As_Type_161,436,225)
except:
    print "WARNING: failed to restore AsType named As Type in network masterNet"
    print_exc()
    As_Type_161=None

masterNet.freeze()

## saving connections for network TablePlot ##
if Draw_Area_156 is not None and TablePlot_154 is not None:
    try:
        masterNet.connectNodes(
            Draw_Area_156, TablePlot_154, "drawAreaDef", "drawAreaDef", blocking=True)
    except:
        print "WARNING: failed to restore connection between Draw_Area_156 and TablePlot_154 in network masterNet"
if ReadTable_155 is not None and TablePlot_154 is not None:
    try:
        masterNet.connectNodes(
            ReadTable_155, TablePlot_154, "data", "values", blocking=True)
    except:
        print "WARNING: failed to restore connection between ReadTable_155 and TablePlot_154 in network masterNet"
if ReadTable_157 is not None and Index_158 is not None:
    try:
        masterNet.connectNodes(
            ReadTable_157, Index_158, "data", "data", blocking=True)
    except:
        print "WARNING: failed to restore connection between ReadTable_157 and Index_158 in network masterNet"
if ReadTable_157 is not None and Index_159 is not None:
    try:
        masterNet.connectNodes(
            ReadTable_157, Index_159, "data", "data", blocking=True)
    except:
        print "WARNING: failed to restore connection between ReadTable_157 and Index_159 in network masterNet"
if Index_158 is not None and TablePlot_154 is not None:
    try:
        masterNet.connectNodes(
            Index_158, TablePlot_154, "data", "rowlabels", blocking=True)
    except:
        print "WARNING: failed to restore connection between Index_158 and TablePlot_154 in network masterNet"
if Index_159 is not None and TablePlot_154 is not None:
    try:
        masterNet.connectNodes(
            Index_159, TablePlot_154, "data", "columnlabels", blocking=True)
    except:
        print "WARNING: failed to restore connection between Index_159 and TablePlot_154 in network masterNet"
if ReadTable_160 is not None and As_Type_161 is not None:
    try:
        masterNet.connectNodes(
            ReadTable_160, As_Type_161, "data", "inArrayList", blocking=True)
    except:
        print "WARNING: failed to restore connection between ReadTable_160 and As_Type_161 in network masterNet"
if As_Type_161 is not None and TablePlot_154 is not None:
    try:
        masterNet.connectNodes(
            As_Type_161, TablePlot_154, "outArray", "rowcolors", blocking=True)
    except:
        print "WARNING: failed to restore connection between As_Type_161 and TablePlot_154 in network masterNet"
masterNet.unfreeze()
#masterNet.run()

