/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.access;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.cache.ClassSize;
import org.apache.derby.iapi.services.io.ArrayInputStream;
import org.apache.derby.iapi.services.io.FormatIdUtil;
import org.apache.derby.iapi.types.DataType;
import org.apache.derby.iapi.types.DataValueDescriptor;

public class StorableFormatId
extends DataType {
    private int format_id;
    private static final int BASE_MEMORY_USAGE = ClassSize.estimateBaseFromCatalog(StorableFormatId.class);

    public int estimateMemoryUsage() {
        return BASE_MEMORY_USAGE;
    }

    public StorableFormatId() {
    }

    public StorableFormatId(int n) {
        this.format_id = n;
    }

    public int getValue() {
        return this.format_id;
    }

    public void setValue(int n) {
        this.format_id = n;
    }

    public int getTypeFormatId() {
        return 93;
    }

    public boolean isNull() {
        return false;
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        FormatIdUtil.writeFormatIdInteger(objectOutput, this.format_id);
    }

    public void readExternal(ObjectInput objectInput) throws IOException {
        this.format_id = FormatIdUtil.readFormatIdInteger(objectInput);
    }

    public void readExternalFromArray(ArrayInputStream arrayInputStream) throws IOException {
        this.format_id = FormatIdUtil.readFormatIdInteger(arrayInputStream);
    }

    public void restoreToNull() {
        this.format_id = 0;
    }

    public int getLength() throws StandardException {
        throw StandardException.newException("XSCH8.S");
    }

    public String getString() throws StandardException {
        throw StandardException.newException("XSCH8.S");
    }

    public Object getObject() throws StandardException {
        return this;
    }

    public DataValueDescriptor getClone() {
        return null;
    }

    public DataValueDescriptor getNewNull() {
        return null;
    }

    public void setValueFromResultSet(ResultSet resultSet, int n, boolean bl) throws StandardException, SQLException {
        throw StandardException.newException("XSCH8.S");
    }

    protected void setFrom(DataValueDescriptor dataValueDescriptor) throws StandardException {
        throw StandardException.newException("XSCH8.S");
    }

    public String getTypeName() {
        return null;
    }

    public int compare(DataValueDescriptor dataValueDescriptor) throws StandardException {
        throw StandardException.newException("XSCH8.S");
    }
}

