# J31x testing notes

## Foreword and abstract

_Please note that this section is outdated, and does not reflect the current_
_state of the J31x FIRs. It is included for posterity and transparency._

macOS does two very interesting things to the audio signal. Firstly, it EQs away
almost all of the real low end below ~80-100Hz. This is actually a great idea,
since doing so stops the machine vibrating, which under Linux gave me a headache
after about 5 minutes of playing around with FIRs in Carla. It also clarifies the
sound big time.

The second thing it does is significantly boost the low mids. This is a very
common trick in consumer sound equipment. Consumers "like" the illusion of
fullness and richness, but this all this does is make things muddier. The real
shame here is that it's not even needed, these speakers sound quite excellent with
nothing more than basic crossovers and per-driver volume tuning in a routing
matrix.

Given that whatever processing macOS applies to the speakers actually hinders
their performance, I recommend that we do not attempt to copy it. Rather,
whatever FIRs/IIRs we end up applying should be based on a series of parameters
I have experimentally determined to maximise the natural performance of this
extremely high quality speaker array. The quick version:

a) bandpass on drivers 4 and 5 of 80-400 Hz
b) bandpass on drivers 0 and 1 of 80-2000 Hz
c) high pass on drivers 2 and 3 set at 2000 Hz
d) linear coefficient of 0.75 applied to drivers 2 and 3
e) -3 dB at 550 Hz, Q = 2.75, applied directly to the stereo signal
f) no cross mixing for stereo separation, it's not needed

For the why and how of these values, read on.


## A science-adjacent experiment

_This section has been modified from the original, which is still available in the `chadmed/asound.conf` Gist._

I have experimentally determined that these parameters result in the most
natural-sounding audio direct from ALSA. /etc/asound.conf included in this
Gist for reference. I am a scientist by trade and I simply could not live
with myself if I did not publish my findings properly, so for your perusal
here is a vaguely scientific writeup on what I did.


### Sources

The source music used for this experiment consisted of:
* Kenny G - Breathless (whole album) \[CD :: 16/44.1 FLAC\]
* DALI - ムーンライト伝説 (track) \[CD :: 16/44.1 FLAC\]
* Sade - No Ordinary Love (track) \[24/192 ALAC\]
* Aqua - Doctor Jones (track) \[CD :: 16/44.1 FLAC\]
* Horii Katsumi Project - Sky Cruisin' (album) \[CD :: 16/44.1 FLAC\]
* George Gershwin (rec. Royal Phil. Orch.) - Rhapsody In Blue \[24/96 ALAC\]
* Michael Jackson - Off The Wall (album) \[LP :: 24/96 FLAC\]
* 花江夏樹 - 青春は残酷じゃない (track) \[YouTube (garbage)\]
* 角松敏生 - On The City Shore (album) \[LP :: 24/192 FLAC\]
* Kelly Bailey - Half-Life 2 Original Sountrack (album) \[CD :: 16/44.1 FLAC\]
* 菊池桃子 - Adventure (album) \[LP :: 24/192 FLAC\]
* ABBA - Arrival (album) \[LP :: 24/192 FLAC\]

These tracks and albums were chosen to ensure that whatever parameters were
applied preserved the experience intended by the artists/engineers across many
genres and styles. (I'm also not going to sit here all day listening to
music I don't like)

All music samples were played through my home HiFi as a reference. Physical
formats specified above indicate the source of the digital transfers used
on the J314s.

ALACs were sourced from Apple Music, and YouTube was sourced from
Google. As my digital rips were made on different equipment to what I have now,
I also used the physical copies as reference material to verify that the transfers
are of acceptable quality for this experiment. They are of marginally lower
quality than I would have liked, but any differences were noted and accounted
for.

### Reference Setup

* Speakers:
    * Richter Wizard S6 (3-way floorstanders)
* Amp:
    * Yamaha A-S2200
* Digital Signal Chain:
    * J314s MacBook Pro (CoreAudio) feeds
    * Schiit Hel 2 (24/192) line level output feeds
    * Yamaha amp line in
* Physical Sources:
    * LP: Denon DP-47F w/ Ortofon 2M Blue cartridge/stylus
    * CD: Onkyo 6-CD carousel (using builtin DAC)


### Test Setup

The test machine was a MacBook Pro 14-inch (J314s) running the Asahi Linux
reference distribution. The native audio server was JACK. EQ effects were
applied in Carla, using the standard LSP 16-filter stereo parametric EQ plugin.

For FIR measurement, the machine was placed on a Steelseries Qck XL to
isolate it acoustically from the desk it was on. The room itself was confirmed to
have no noticeable resonances. Soft, heavy furnishings were placed against all
hard walls. The floor of the room is thick carpet, with an extra thick underlay
specifically installed to deaden sound reflections.

### Methods
Testing was conducted in an A/B pattern. I would listen to the source material
for a while, mute it, then move over to the J314s under Linux and play the
corresponding audio file.

Crossover values were first determined by ear after isolating each driver with
a custom `asound.conf`. These crossover values were then confirmed and refined
if neccessary with frequency response measurements of each driver taken in REW.

The calibration microphone was placed exactly 30cm back from the machine's
keyboard, exactly 30cm above the surface of the keyboard, and was centred
on the machine's x-axis. It was also tilted down by 30 degrees. This position
was chosen to emulate the distance and angle a person's head would be from the
machine while seated at a desk. The screen of the machine was opened to 110
degrees.

Once these crossover values were determined, the parametric EQ was used to
develop a curve by ear. Goals for the EQ curve were:
* Linear response through the mids
* Clear, crisp and directional highs
* Diminished sub-bass (to prevent resonances in the mids and machine vibrations)
* Clear, but not overpowering bass
* Must sound good at all volume levels

Once a curve was determined, its parameters were transposed as filter parameters
in REW, mixed with the crossover parameters, and an FIR was generated for both
the woofers and the tweeters. These were then applied and tested using PipeWire's
convolver plugin.


### Results

The table below outlines the crossover network I landed on at the end of this
experiment.


| Frequency Range (Hz) | Drivers |
| -------------------- | ------- |
| 20-800               | 0 1 4 5 |
| 1200-20000           | 2 3     |

Crossovers were initially set to slightly overlap, however it was found that
this reulted in horribly overemphasised mids. These crossover figures seem to
do a good job of emulating the rolloff characteristics of a traditional RLC
filter network, while also matching the natural responses of the woofers and
tweeters.

The EQ curve for both the woofers and tweeters can be extracted by importing the
FIRs into REW.

Interestingly, the array in its natural state with no effects applied is fairly
linear in its response, with slight booming in the low mids and harsh spikes
at around 2k, 8k and 10k. It is a shame that Apple felt the need to apply such
aggressive correction to these speakers such that they sound more like consumer
gear than speakers you would actually want to use for professional purposes.


Additionally, stereo separation is quite fantastic even without any cross
mixing as done by macOS.
