<?php
/*
+--------------------------------------------------------------------+
| CiviCRM version 4.7                                                |
+--------------------------------------------------------------------+
| Copyright CiviCRM LLC (c) 2004-2017                                |
+--------------------------------------------------------------------+
| This file is a part of CiviCRM.                                    |
|                                                                    |
| CiviCRM is free software; you can copy, modify, and distribute it  |
| under the terms of the GNU Affero General Public License           |
| Version 3, 19 November 2007 and the CiviCRM Licensing Exception.   |
|                                                                    |
| CiviCRM is distributed in the hope that it will be useful, but     |
| WITHOUT ANY WARRANTY; without even the implied warranty of         |
| MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.               |
| See the GNU Affero General Public License for more details.        |
|                                                                    |
| You should have received a copy of the GNU Affero General Public   |
| License and the CiviCRM Licensing Exception along                  |
| with this program; if not, contact CiviCRM LLC                     |
| at info[AT]civicrm[DOT]org. If you have questions about the        |
| GNU Affero General Public License or the licensing of CiviCRM,     |
| see the CiviCRM license FAQ at http://civicrm.org/licensing        |
+--------------------------------------------------------------------+
*/
/**
 * @package CRM
 * @copyright CiviCRM LLC (c) 2004-2017
 *
 * Generated from xml/schema/CRM/Core/OpenID.xml
 * DO NOT EDIT.  Generated by CRM_Core_CodeGen
 * (GenCodeChecksum:cf502fe1aae4bbe85faa570c2c341336)
 */
require_once 'CRM/Core/DAO.php';
require_once 'CRM/Utils/Type.php';
/**
 * CRM_Core_DAO_OpenID constructor.
 */
class CRM_Core_DAO_OpenID extends CRM_Core_DAO {
  /**
   * Static instance to hold the table name.
   *
   * @var string
   */
  static $_tableName = 'civicrm_openid';
  /**
   * Should CiviCRM log any modifications to this table in the civicrm_log table.
   *
   * @var boolean
   */
  static $_log = false;
  /**
   * Unique OpenID ID
   *
   * @var int unsigned
   */
  public $id;
  /**
   * FK to Contact ID
   *
   * @var int unsigned
   */
  public $contact_id;
  /**
   * Which Location does this email belong to.
   *
   * @var int unsigned
   */
  public $location_type_id;
  /**
   * the OpenID (or OpenID-style http://username.domain/) unique identifier for this contact mainly used for logging in to CiviCRM
   *
   * @var string
   */
  public $openid;
  /**
   * Whether or not this user is allowed to login
   *
   * @var boolean
   */
  public $allowed_to_login;
  /**
   * Is this the primary email for this contact and location.
   *
   * @var boolean
   */
  public $is_primary;
  /**
   * Class constructor.
   */
  function __construct() {
    $this->__table = 'civicrm_openid';
    parent::__construct();
  }
  /**
   * Returns foreign keys and entity references.
   *
   * @return array
   *   [CRM_Core_Reference_Interface]
   */
  static function getReferenceColumns() {
    if (!isset(Civi::$statics[__CLASS__]['links'])) {
      Civi::$statics[__CLASS__]['links'] = static ::createReferenceColumns(__CLASS__);
      Civi::$statics[__CLASS__]['links'][] = new CRM_Core_Reference_Basic(self::getTableName() , 'contact_id', 'civicrm_contact', 'id');
      CRM_Core_DAO_AllCoreTables::invoke(__CLASS__, 'links_callback', Civi::$statics[__CLASS__]['links']);
    }
    return Civi::$statics[__CLASS__]['links'];
  }
  /**
   * Returns all the column names of this table
   *
   * @return array
   */
  static function &fields() {
    if (!isset(Civi::$statics[__CLASS__]['fields'])) {
      Civi::$statics[__CLASS__]['fields'] = array(
        'id' => array(
          'name' => 'id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Open ID identifier') ,
          'description' => 'Unique OpenID ID',
          'required' => true,
          'table_name' => 'civicrm_openid',
          'entity' => 'OpenID',
          'bao' => 'CRM_Core_BAO_OpenID',
          'localizable' => 0,
        ) ,
        'contact_id' => array(
          'name' => 'contact_id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('OpenID Contact') ,
          'description' => 'FK to Contact ID',
          'table_name' => 'civicrm_openid',
          'entity' => 'OpenID',
          'bao' => 'CRM_Core_BAO_OpenID',
          'localizable' => 0,
          'FKClassName' => 'CRM_Contact_DAO_Contact',
        ) ,
        'location_type_id' => array(
          'name' => 'location_type_id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('OpenID Location Type') ,
          'description' => 'Which Location does this email belong to.',
          'table_name' => 'civicrm_openid',
          'entity' => 'OpenID',
          'bao' => 'CRM_Core_BAO_OpenID',
          'localizable' => 0,
        ) ,
        'openid' => array(
          'name' => 'openid',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('OpenID') ,
          'description' => 'the OpenID (or OpenID-style http://username.domain/) unique identifier for this contact mainly used for logging in to CiviCRM',
          'maxlength' => 255,
          'size' => CRM_Utils_Type::HUGE,
          'import' => true,
          'where' => 'civicrm_openid.openid',
          'headerPattern' => '/^Open.?ID|u(niq\w*)?.?ID/i',
          'dataPattern' => '/^[\w\/\:\.]+$/',
          'export' => true,
          'rule' => 'url',
          'table_name' => 'civicrm_openid',
          'entity' => 'OpenID',
          'bao' => 'CRM_Core_BAO_OpenID',
          'localizable' => 0,
        ) ,
        'allowed_to_login' => array(
          'name' => 'allowed_to_login',
          'type' => CRM_Utils_Type::T_BOOLEAN,
          'title' => ts('Allowed to login?') ,
          'description' => 'Whether or not this user is allowed to login',
          'required' => true,
          'table_name' => 'civicrm_openid',
          'entity' => 'OpenID',
          'bao' => 'CRM_Core_BAO_OpenID',
          'localizable' => 0,
        ) ,
        'is_primary' => array(
          'name' => 'is_primary',
          'type' => CRM_Utils_Type::T_BOOLEAN,
          'title' => ts('Is OpenID Primary?') ,
          'description' => 'Is this the primary email for this contact and location.',
          'table_name' => 'civicrm_openid',
          'entity' => 'OpenID',
          'bao' => 'CRM_Core_BAO_OpenID',
          'localizable' => 0,
        ) ,
      );
      CRM_Core_DAO_AllCoreTables::invoke(__CLASS__, 'fields_callback', Civi::$statics[__CLASS__]['fields']);
    }
    return Civi::$statics[__CLASS__]['fields'];
  }
  /**
   * Return a mapping from field-name to the corresponding key (as used in fields()).
   *
   * @return array
   *   Array(string $name => string $uniqueName).
   */
  static function &fieldKeys() {
    if (!isset(Civi::$statics[__CLASS__]['fieldKeys'])) {
      Civi::$statics[__CLASS__]['fieldKeys'] = array_flip(CRM_Utils_Array::collect('name', self::fields()));
    }
    return Civi::$statics[__CLASS__]['fieldKeys'];
  }
  /**
   * Returns the names of this table
   *
   * @return string
   */
  static function getTableName() {
    return self::$_tableName;
  }
  /**
   * Returns if this table needs to be logged
   *
   * @return boolean
   */
  function getLog() {
    return self::$_log;
  }
  /**
   * Returns the list of fields that can be imported
   *
   * @param bool $prefix
   *
   * @return array
   */
  static function &import($prefix = false) {
    $r = CRM_Core_DAO_AllCoreTables::getImports(__CLASS__, 'openid', $prefix, array());
    return $r;
  }
  /**
   * Returns the list of fields that can be exported
   *
   * @param bool $prefix
   *
   * @return array
   */
  static function &export($prefix = false) {
    $r = CRM_Core_DAO_AllCoreTables::getExports(__CLASS__, 'openid', $prefix, array());
    return $r;
  }
  /**
   * Returns the list of indices
   */
  public static function indices($localize = TRUE) {
    $indices = array(
      'index_location_type' => array(
        'name' => 'index_location_type',
        'field' => array(
          0 => 'location_type_id',
        ) ,
        'localizable' => false,
        'sig' => 'civicrm_openid::0::location_type_id',
      ) ,
      'UI_openid' => array(
        'name' => 'UI_openid',
        'field' => array(
          0 => 'openid',
        ) ,
        'localizable' => false,
        'unique' => true,
        'sig' => 'civicrm_openid::1::openid',
      ) ,
    );
    return ($localize && !empty($indices)) ? CRM_Core_DAO_AllCoreTables::multilingualize(__CLASS__, $indices) : $indices;
  }
}
