/*
 *  dancer-XML parser
 *  Copyright (C) 2000,2002 Junichi Uekawa
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * example application for mikilab machine list parser
 * usage: ./mikilab.machines-list.parser < machines2002.xml | iconv -f utf-8 -t euc-jp
 *
 */

#include "dancer-xml.h"

const char * get_PCDATA_bysimplepath_i (dxml_element * e, const char * loc)
{
  const char * s = dxml_get_PCDATA_bysimplepath ( e, loc);
  if (s)
    return s;
  else
    return "";
}


static void
print_kanrisha_info(dxml_element * e)
{
  printf ("{");
  
  for (e = dxml_get_element_bysimplepath(e, "管理者リスト/管理者"); e; e=e->next)
    {
      printf ("%s $<$%s$>$ \\\\ ", 
	      get_PCDATA_bysimplepath_i(e->child, "管理者名"),
	      get_PCDATA_bysimplepath_i(e->child, "メール")
	      );
    }
  
  printf ("}");
  
}


static void
dump_one_info (dxml_element * e)
{
  printf ("\\machineinfo{%s}{%s}{%s}{%s}{%s}{%s}", 
	  get_PCDATA_bysimplepath_i(e, "名称"),
	  get_PCDATA_bysimplepath_i(e, "システム構成/CPU"),
	  get_PCDATA_bysimplepath_i(e, "システム構成/OS"),
	  get_PCDATA_bysimplepath_i(e, "システム構成/形態"),
	  get_PCDATA_bysimplepath_i(e, "システム構成/ノード数"),
	  get_PCDATA_bysimplepath_i(e, "システム用途")
	  );
  print_kanrisha_info (e);
  
  printf ("{%s}\n", 
	  get_PCDATA_bysimplepath_i(e, "配備場所")
	  );
  
}


int
main (int ac, char ** av)
{
  dxml_element * tmp ;
  
  tmp = dxml_read_xml(stdin);

  
  for (tmp = dxml_get_element_byname(tmp->child, "コンピュータ"); tmp ; tmp = tmp->next)
    {
      dump_one_info (tmp -> child);
    }  
  return 0;
}
