We're proud to announce the new feature release of darktable, 3.0.1!

The github release is here: [https://github.com/darktable-org/darktable/releases/tag/release-3.0.1](https://github.com/darktable-org/darktable/releases/tag/release-3.0.1).

As always, please don't use the autogenerated tarball provided by
github, but only our tar.xz. the checksums are:

```
$ sha256sum darktable-3.0.1.tar.xz
??? darktable-3.0.1.tar.xz
$ sha256sum darktable-3.0.1.dmg
??? darktable-3.0.1.dmg
$ sha256sum darktable-3.0.1.exe
??? darktable-3.0.1.exe
```

When updating from the currently stable 2.6.x series, please bear in
mind that your edits will be preserved during this process, but the new
library and configuration will not be usable with 2.6.x any more, so
making a backup is strongly advised.

#### Important note: to make sure that darktable can keep on supporting the raw file format for your camera, *please* read [this post](https://discuss.pixls.us/t/raw-samples-wanted/5420?u=lebedevri) on how/what raw samples you can contribute to ensure that we have the *full* raw sample set for your camera under CC0 license!

# Changes since 3.0.0

## The Big Ones

- A new color assessment mode is introduced into the darkroom. This
  mode is designed to ensure proper color perception based on
  ICC recommended (ISO 12646:2008) colour proofing conditions.

- It is now possible to resize the left and right panels directly with
  the mouse. The positions of each one is remembered for each views'
  layout.

- Add a focus peaking mode in the lighttable and darkroom. The default
  key to toggle this mode is <kbd>Ctrl+Shift+F</kbd>

- The wavelet denoise profile has a new Y0U0V0 mode. This new mode
  makes it possible to denoise the chroma and luma noise in a single
  instance.

## New Features And Changes

- Add darkroom loading screen.

- Make modules labels a bit smaller for better UI consistency.

- Add small rectangle around the angle display when using the
  straightening tool for better lisibility.

- Ensure the different views layout are recorded. Many views (and mode
  like lighttable's culling or darkroom's color assessment), can have
  the filmstrip or timeline bottom widgets, we record the exact layout
  for each layout.

- Add tool tips on module in history.

- Add support for applying back the last added key-word with a simple
  key short-cut. Default short-cut is <kbd>Alt+T</kbd>.

- Add wide-gamut HLG/PQ based color space P3 and Rec2020.

- Add custom borders support in framing module.

- Add standard variables support in watermark module.

- Allow the same short-cuts to be defined by different modules. This
  makes it possible to have the filmstrip using the same short-cuts to
  set stars than the lighttable.

- Add log editing support for the L, R, G, B, C, g blending modes.
  This gives more control on the dark pixels.

- Define many new accels for most of the sliders to allow more control
  using the keyboard.

- The images operations modules has been extended to support coping,
  replacing and merging metadata.

- Better visibility for the zoomed image part in the navigation widget.

- Revert to smooth mode (was default in 2.6) in color zone module.

- It is now possible to resize the collect module windows with
  <kbd>Ctrl+Scroll</kbd>.

- Add support for compressed Lut (.gmz) in the 3D Lut module.

- Use a more natural folder order in the collect module, the latest
  folder are now listed first.

- Module search in darkroom is now case-insensitive.

## Bug fixes

- All valid Lut files are displayed in file selector.

- Fix straightening in crop and rotate module when flip is applied.

- The ellipse and gradient masks can now be manipulated when the
  crop and rotate flip is activated.

- Fix style editing from lighttable. The modules list was empty due to
  an error in SQL statement.

- Make clicking on group icon easier. The active zone around the group
  icon was too small.

- Make sure no more than 64 spots are added in spot removal module and
  display a message when the limit is reached.

- Delay histogram display until the image is fully loaded and so the
  corresponding histogram is ready. Darktable was displaying the
  previously computed histogram for a short period of time.

- Properly update the XMP when doing undo/redo actions.

- Fix discrepancies between the SSE/OpenCL local Laplacian code paths.

- Better performance for tone equalizer's guided filter.

- Exports should now better respect the final dimensions requested.

- Fix issues with brush opacity handling.

- Better performance for computing the aspect ratio.

- Fix importing of duplicates on Windows.

- Better visibility of tone curve grid on Grey theme.

- Better accuracy for the keystone OSD lines.

- Better performance and accuracy improvements for the waveform histogram.

- Some HiDPI fixes in icons.

- The Facebook, Google Photo and Flickr export storage have been
  removed as not supported anymore due to deep changes in the provider
  making it very hard to fix.

- Fix brush OSD when in zoom mode. The brushes are now keeping thin
  lines.

- Fix watermark blurring when using rotation.

- Fix using apostrophe in meta-data.

- Fix time-line display reporting 61 minutes per hour.

- Remove wrong presets in RGB-curve module.

- Fix some duplicate pipe recomputation.

### White Balance Presets

- Canon EOS 77D
- Canon EOS 9000D
- Nikon COOLPIX P1000
- Panasonic DC-GH5

### Noise Profiles

- Canon EOS-1Ds
- Fujifilm X-H1
- Fujifilm X-T30
- Olympus E-510
- Panasonic DC-GH5
- Sony ILCE-6600
- Sony ILCE-7RM4
- Sony ILCE-9

# Changes since 2.6

- Almost 3 thousand commits to darktable+rawspeed since 2.6
- 553 pull requests handled
- 66 issues closed
- Updated user manual is coming soon™

## The Big Ones

- A full rework of the GUI. The whole GUI is now fully
  controlled by [GTK+ CSS rules](https://developer.gnome.org/gtk3/stable/chap-css-overview.html). There is
  no more size, color, position in Gtk C code, which makes the whole GUI themable. This version comes
  with several themes:

     - darktable                : the default theme
     - darktable-icons          : the default theme with icons

     - darktable-elegant-darker : more condensed fonts
                                  best experience with Roboto font installed

     - darktable-icons-darker   : as elegant, with module icons
                                  best experience with Roboto font installed

     - darktable-elegant-dark   : lighter version
     - darktable-elegant-grey   : even lighter version

     - darktable-icons-dark     : lighter version. with module icons
     - darktable-icons-grey     : even lighter version, with module icons

  New shortcuts have been introduced to quickly collapse borders, sidebars, histogram and
  navigation modules, allowing a new borderless editing experience.

  Note that the new GUI requires Gtk+ 3.22 or higher to work properly.

- It's now possible to associate dynamic key shortcuts to sliders, then
  use them with the mouse wheel or arrow keys to move the value up and down.
  For example, associating the <kbd>E</kbd> key to the exposure slider, you can press
  it and scroll to increase the exposure without having to open the module.
  You get fast heads-up access to all your favorite settings, as if you
  were using a dedicated multimedia console.

- The color picker on the 'tone curve', 'color zones' and 'fill light' modules,
  as well as the parametric mask controls, now allows you to select an
  area when enabled by using <kbd>Ctrl+click</kbd> on the button.

- Added undo/redo support in lighttable for tags, color labels, ratings,
  metadata, deleted history stack, pasted history stack and applied
  styles.

  IMPORTANT:
  The 'preview' and 'preview with focus detection' actions
  (previously <kbd>Z</kbd> and <kbd>Ctrl+Z</kbd> respectively) are now assigned to
  <kbd>W</kbd> and <kbd>Ctrl+W</kbd> in order to follow the convention of
  using <kbd>Ctrl+Z</kbd> for the "undo" function (<kbd>Ctrl+Y</kbd> for redo).

- A new timeline view has been introduced in the lighttable.

- A new 'culling' mode has been added to the lightable view. It
  displays a fixed number of consecutive images starting from the first
  selected, and allows you to pan & zoom them. The number of displayed images
  can be set by the user, and they can be navigated with the mouse wheel
  and keyboard.

- A quite extensive rewrite of the lighttable view (including the filmstrip in darkroom view)
  has been made to greatly improve the overall performance. The lighttable is now
  usable on 4K and 5K monitors.

- Added support for the new 'raster mask', a copy of a parametric mask
  which is stable during the whole pixel-pipe.

- The processing order of the pixel-pipe can now be changed by using
  <kbd>Ctrl+Shift+drag</kbd> on the module headers to arrange them relative
  to each other. It is VERY IMPORTANT to understand that this feature is NOT
  for creating a more convenient GUI layout, but for changing the actual
  processing of the image. DO NOT USE THIS FEATURE unless you understand the
  reason behind the default ordering, and have a specific reason for changing it.
  The default order is still the correct order for most purposes. Also note that
  styles will always apply the default ordering; creating a style based on modules
  which have had their order changed will NOT recreate this changed order when
  applied, and therefore may not give the expected result.

- The history stack will now always show mandatory modules which were previously
  hidden. They are always active as necessary for processing images, and are not
  removed by compressing history or by selecting one as a stating point for editing.
  These seven modules (some are RAW-only) have a specific icon to identify them easily:

          - raw black/white point
          - white balance
          - highlight reconstruction
          - demosaic
          - input color profile
          - output color profile
          - gamma

- The 'color zones' module now shows a histogram based on the chosen ‘select
  by’ channel, and if the color picker is in 'select area' mode, the range within
  the selected area will also be shown. By default, the spline adjustment is
  now similar to the curve controls, allowing you to add and delete nodes, but
  these nodes can still be moved with the old-style size control by selecting
  the 'edit by area' checkbox. There is also a new 'strong' processing option,
  and a new color picker which creates a curve based on selected image area.

- A new module 'filmic RGB' which, like the previous 'filmic', is designed
  to replace 'base curve', 'shadows and highlights' and other global tone-mapping modules.
  This new version replaces the one introduced in 2.6.2; it should be easier to use,
  and it will reduce color casts. The old 'filmic' module is now deprecated and
  is only available on images where it was already used for editing.

- A new module 'tone equalizer' is designed to merge the features of 'zone system',
  'shadows and highlights', and (local) 'tone mapping' modules in a scene-referred
  RGB space. It brings an easy and safe way to remap tones locally, performing a quick
  zone-based dodging and burning using Ansel Adam's zone system logic.
  The module provides an interface similar to audio graphic equalizers,
  with 9 bands (available as fixed sliders or nodes on a spline view),
  allowing you to selectively push or pull the exposure for each band in the
  range from blacks to specular highlights. It also features an interactive
  cursor that allows to push or pull the exposure gains directly from
  the image preview by simply hovering over an area and scrolling. It uses a guided filter
  internally to refine the dodging and burning mask, which preserves local contrast
  without producing halos along edges.

## New Features And Changes

- A new module for handling 3D RGB Lut transformations (PNG Hald-CLUT and
  Cube files are supported).

- Many improvements to the 'denoise (profiled)' module. The degree of shadow
  denoising can be controlled, including the correction of color casts
  (mainly improves high-ISO images). "Auto" modes which infer some parameters
  from the profile are available, allowing users to create presets
  which are adaptive to various ISO values. The default values of the sliders
  are also adapted dynamically on module activation, giving a good trade-off
  between noise smoothing and detail preservation.  The non-local means mode
  has 2 new options: one to coarse-grain denoising, and one to control the
  amount of fine detail to preserve. The controls now have soft boundaries,
  which means that users can use the keyboard to enter values outside the
  range of the sliders if they need to.

- Along with selecting the 'soft proof' color profile, users can now select an
  additional profile for the color space of the histogram, color picker and
  overexposed checker. When gamut or softproof checks are active the histogram
  and color picker use the softproof profile, otherwise they use the new
  histogram profile (which is always used for overexposure checking).

- A new setting for 'working profile' has been added to the input color profile
  module. This color space will be used by RGB modules between the input and
  output color profile modules.

- A new color picker has been added to the parametric masking controls which
  adjusts the range sliders based on the selected area from the image. Click the
  picker button to adjust the input image slider, <kbd>Ctrl+click</kbd> the
  button to adjust the output image slider.

- The 'picasa' target storage in the export module has been completely rewritten
  to support the new Google Photo API, and renamed 'google photos'. It is again
  possible to create albums directly from the export module.

- A new single-line image information display can be positioned at the top (left, right,
  or center) or bottom (center) of the darkroom view to replace the information previously
  overlaid on the histogram. The specific information shown can be configured in preferences.

- The 'tagging' module is faster, and can now display hierarchical tags in a
  tree view. Tags can now be designated as 'private' (not exported by default),
  'synonym' (to help search engines), and 'category' (not exported, for organizing
  the tag library). The metadata exported with images can now be configured in the
  'export selected' module, allowing you to choose which main types are exported,
  as well as define values for specific tags based on formulas.

- Many code optimizations for CPU and SSE paths. The tone equalizer module
  introduces a new optimization paradigm (GCC target clones), aimed toward users
  of pre-built Linux packages. The image-processing code will be cloned for several
  CPU generations (SSE2, SSE3, SSE4, AVX, AVX2) at compilation time, and the best-suited
  version of the code will be chosen by the system at run time. This experiment is
  to be generalized to other modules if proven successful, and will allow users of pre-built
  packages to get the same performance as if the program was specifically compiled for their
  computer. It needs GCC 9 compiler and does not yet work on Windows
  due to the lack of support of target clones on the OS side.

- A new preference to expand/collapse a darkroom module when it is
  activated/deactivated.

- The 'collect images' module has a new single-click option featuring range selection
  for date-time and numeric values.

- The orientation of drawn masks using the 'gradient' shape is now clearly displayed
  with an arrow.

- The 'graduated density' module has better accuracy when computing the
  rotation to avoid sporadic flipping of the gradient.

- Make sure the OpenCL kernel code is recompiled when the driver
  version is updated.

- Add color pickers for 'split toning', 'graduated density' and 'watermark' modules.

- The color picker positions are kept during editing within a module.

- The map view can zoom on the images of the selected collection.

- The slideshow will now start at the selected images if any, and supports
  changing the delay between images. It will also now be more responsive when
  manually moving backward and forward through the images.

- A new 'basic adjustments' module has been added. It allows to adjust
  the black level, exposure, highlight compression, contrast, middle grey,
  brightness and saturation. It also has an auto feature based on Rawtherapee's
  auto levels that can work on the entire image or a user selected area.

- A new 'rgb curve' module has been added. It has modes for linked and
  independent RGB channels. The curves and histogram can be displayed using
  the working profile or can be scaled to be 50% grey. A secondary color
  picker will add 4 nodes to the curve based on the area selected in the
  image: min, average, middle, and max.

- A new 'rgb levels' module has been added. It has linked and
  independent channels, preserve colors option and is native RGB.

- A new search box has been added to the module groups in the darkroom
  view, with configuration options to show only the module groups, only
  the search box, or both. Modules are searched for by (localized) name,
  and when displaying only the search box, the active modules are shown
  when the box is empty. A shortcut can be set for focusing the box.

- A preview window has been added to the darkroom that displays the edited image
  on a separate window.

- A new option 'skip' is added to the 'on conflict' setting on the export module
  which skips the exporting to existing destination files.

- Allow to switch between clone/heal and blur/color modes in 'retouch' module
  after creating a shape using <kbd>Ctrl+click</kbd> on corresponding mode icon.

- An accels window (<kbd>H</kbd>) has been added to summarize all
  available shortcuts and mouse actions available in the current
  context.

- A zoom & pan feature has been added to lighttable full preview.

- The base-curve module is now using luminance color preservation by
  default. This can give slightly less saturated pictures compared to
  the previous version where no color preservation was made. But it
  will generally avoid color shift.

## Bug fixes

- The color picker support has been fixed by a complete rewrite. It
  should now give correct values in all cases.

- Fix overexposed display.

- Do not disable SSL for storage modules.

- A long standing bug on mask distort in Liquify module has been
  fixed. This was visible when a liquify mask was used together with
  the perspective correction module activated.

- A bug on mask distort from crop & rotate when using flip and
  some angle has been fixed.

- Fix manual crop in perspective correction module when not in default
  orientation.

- The modification of date/time is now stored into the XMP. This
  ensures that removing the picture and reloading will keep the changes.

- Fix orientation to support all cases as exposed in these examples:
  https://github.com/recurser/exif-orientation-examples

- Store the panel states for each lighttable mode.

- Fix crop&rotate and orientation in the lightroom importer.

- Fix ProPhoto RGB profile.

- Fix exif lens metadata parsing containing comma.

## Lua

- The displayed image in darkroom view can now be changed.

- GUI panel visibility can now be queried and changed.

- Lighttable view toolbox (rating filter, rating comparator, sort
  field, and sort direction) can now be changed.

- Lighttable layout and zoom level can now be changed.

- All images containing a specific tag can be searched and returned.

## Changed Dependencies

- CMake 3.10 is now required.
- OpenMP 4.0 is now required (optional dependency).

## RawSpeed changes

### Changed Dependencies

- CMake 3.10 is now required.
- Pugixml 1.8 is now required.
- OpenMP 4.0 is now required (optional dependency).
- POSIX threads are no longer required.
- zlib 1.2.11 is now required (optional dependency).

### Changes

- Threading was migrated to OpenMP from POSIX threads.
- Phase One IIQ decompressor fixes (quadrant scaling, bad column).
- Large-scale code cleanup, hardening is ongoing still.
- A CMake infrastructure was added to allow integration of RawSpeed into LLVM LNT / Test-Suite.
- Widespread performance tuning, most affected decompressors:
  * Sony ARW2
  * Panasonic V5
  * Phase One
  * Nikon
  * Pentax
  * Canon
  * Samsung V1 (compression = '32772')
  * Samsung V2 (compression = '32773')
- Continuation of collaboration with LLVM Compiler Infrastructure Project.

## Camera support, compared to 2.6.0

### Base Support

- Epson R-D1s
- Epson R-D1x
- Fujifilm FinePix F770EXR
- Fujifilm FinePix S7000
- Fujifilm GFX 50R (compressed)
- Fujifilm X-A10
- Fujifilm X-T30 (compressed)
- Fujifilm XF10
- Kodak DCS Pro 14N
- Kodak EasyShare Z981
- Kodak EasyShare Z990
- Leica C (Typ 112) (4:3)
- Leica CL (dng)
- Leica Q (Typ 116) (dng)
- Leica Q2 (dng)
- Leica SL (Typ 601) (dng)
- Leica V-LUX (Typ 114) (3:2, 4:3, 16:9, 1:1)
- Nikon Z 6 (14bit-uncompressed, 12bit-uncompressed)
- Nikon Z 7 (14bit-uncompressed)
- Olympus E-M1X
- Olympus E-M5 Mark III
- Olympus TG-6
- Panasonic DC-G90 (4:3)
- Panasonic DC-G91 (4:3)
- Panasonic DC-G95 (4:3)
- Panasonic DC-G99 (4:3)
- Panasonic DC-ZS200 (3:2)
- Panasonic DMC-TX1 (3:2)
- Phase One P30
- Sony DSC-RX0M2
- Sony DSC-RX100M6
- Sony DSC-RX100M7
- Sony ILCE-6400
- Sony ILCE-6600
- Sony ILCE-7RM4

### White Balance Presets

- Leica Q2
- Nikon D500
- Nikon Z 7
- Olympus E-M5 Mark III
- Panasonic DC-LX100M2
- Sony ILCE-6400

### Noise Profiles

- Leica Q2
- Nikon D3
- Nikon D3500
- Nikon Z 6
- Nikon Z 7
- Olympus E-PL8
- Olympus E-PL9
- Panasonic DC-LX100M2
- Sony DSC-RX100M5A
- Sony ILCE-6400
- Sony SLT-A35

## Translations

- Catalan
- Czech
- Danish
- German
- European Spanish
- French
- Hebrew
- Hungarian
- Italian
- Japanese
- Norwegian Bokmål
- Dutch
- Polish
- Russian
- Slovenian
