;;;CadenzaTime
(let ((tag "CadenzaTime"))
 (if  (not (d-Directive-timesig? tag))
	 (GoToMeasureBeginning))
 (if  (d-Directive-timesig? tag)
        (d-InfoDialog (_ "Inserts a non-printing timesignature to indicate a cadenza follows. You must insert any barlines and beaming you require (otherwise none will typeset). End the cadenza by inserting an End Cadenza Time in a new Denemo bar."))
        (let ()
            (define (insert-timesig)
                (if  (Timesignature?)
                    (begin
                        (d-DirectivePut-timesig-postfix tag "\\cadenzaOn ")
                        (d-DirectivePut-timesig-override tag (logior DENEMO_OVERRIDE_GRAPHIC DENEMO_OVERRIDE_LILYPOND))
                        (d-DirectivePut-timesig-gy tag 35)
                        (d-DirectivePut-timesig-display tag (_ "Cadenza"))
                        (d-DirectivePut-timesig-graphic tag "\nT\nSerif\n40\nbold\nitalic"))))
            (d-InsertTimeSig "256/1")
            (d-MoveCursorLeft)               
            (d-PushPosition)
            (while (d-MoveToStaffUp))
            (insert-timesig)
            (while (d-MoveToStaffDown (insert-timesig)))
            (d-PopPosition)
            (d-MoveCursorRight)         
            (d-SetSaved #f))))