# -*- coding: utf-8 -*-
# Copyright (C) 2010 Anders Logg
#
# This file is part of DOLFIN.
#
# DOLFIN is free software: you can redistribute it and/or modify
# it under the terms of the GNU Lesser General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# DOLFIN is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public License
# along with DOLFIN. If not, see <http://www.gnu.org/licenses/>.
#
# First added:  2010-02-14
# Last changed: 2010-02-14

import os

__all__ = ["memory_usage"]

def memory_usage(as_string=True):
    """
    Return memory usage of current process. Note that this function
    only works on Linux systems. If the flag as_string is true, memory
    usage is returned as a string. Otherwise, a tuple of integers is
    returned with current memory usage and maximum memory usage in kB.
    """

    # Try reading /proc
    try:
        pid = os.getpid()
        status = open("/proc/%d/status" % pid).read()
    except:
        return "Failed to get memory usage, chances are you are not running GNU/Linux."

    # Parse values
    vmsize = int(status.split("VmSize:")[1].split("kB")[0])
    vmpeak = int(status.split("VmPeak:")[1].split("kB")[0])

    # Return values
    if as_string:
        return "Memory usage is %d kB (peak usage is %d kB)" % (vmsize, vmpeak)
    else:
        return (vmsize, vmpeak)
