// THIS FILE AUTOGENERATED FROM asm-nseel-x86-gcc.c by a2i.php

#if EEL_F_SIZE == 8
  #define EEL_ASM_TYPE qword ptr
#else
  #define EEL_ASM_TYPE dword ptr
#endif

#if defined(__APPLE__)
#define SAVE_STACK "pushl %ebp\nmovl %esp, %ebp\nandl $-16, %esp\n"
#define RESTORE_STACK "leave\n"
#else
#define SAVE_STACK
#define RESTORE_STACK
#endif

/* note: only EEL_F_SIZE=8 is now supported (no float EEL_F's) */

__declspec(naked) void nseel_asm_1pdd(void)
{
  __asm {
	  SAVE_STACK
#ifdef TARGET_X64
      movq xmm0, [eax];
	  sub rsp, 128;
     mov edi, 0xffffffff;
#ifdef AMD64ABI
     mov r15, rsi;
     call edi;
     mov rsi, r15;
     movq [r15], xmm0;
#else
     call edi;
     movq [esi], xmm0;
#endif
     add rsp, 128;
#else
              sub esp, 8; /* keep stack aligned */
					    push dword ptr [eax+4]; /* push parameter */
					    push dword ptr [eax];    /* push the rest of the parameter */
              mov edi, 0xffffffff;
					    call edi;
					    fstp qword ptr [esi]; /* store result */
					    add esp, 16;
#endif
					    mov eax, esi; /* set return value */
					    add esi, 8; /* advance worktab ptr */
  	RESTORE_STACK
_emit 0x89;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
  }
}
__declspec(naked) void nseel_asm_1pdd_end(void){}

__declspec(naked) void nseel_asm_2pdd(void)
{
  __asm {
	SAVE_STACK
#ifdef TARGET_X64
    movq xmm1, [eax];
    movq xmm0, [edi];
	sub rsp, 128;
    mov edi, 0xffffffff;
#ifdef AMD64ABI
    mov r15, rsi;
    call edi;
    mov rsi, r15;
    movq [r15], xmm0;
#else
    call edi;
    movq [esi], xmm0;
#endif
    add rsp, 128;
#else
					    push dword ptr [eax+4]; /* push parameter */
					    push dword ptr [eax];    /* push the rest of the parameter */
					    push dword ptr [edi+4]; /* push parameter */
					    push dword ptr [edi];    /* push the rest of the parameter */
              mov edi, 0xffffffff;
					    call edi;
					    fstp qword ptr [esi]; /* store result */
					    add esp, 16;
#endif
					    mov eax, esi; /* set return value */
					    add esi, 8; /* advance worktab ptr */
	RESTORE_STACK
_emit 0x89;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
  }
}
__declspec(naked) void nseel_asm_2pdd_end(void){}

__declspec(naked) void nseel_asm_2pdds(void)
{
  __asm {
	SAVE_STACK
#ifdef TARGET_X64
    movq xmm1, [eax];
    movq xmm0, [edi];
	sub rsp, 128;
    mov eax, 0xffffffff;
#ifdef AMD64ABI
    mov r15, rsi;
    mov r14, rdi;
    call eax;
    mov rsi, r15;
    movq [r14], xmm0;
    mov rax, r14; /* set return value */
#else
    call eax;
    movq [edi], xmm0;
    mov eax, edi; /* set return value */
#endif
    sub rsp, 128;
#else
					    push dword ptr [eax+4]; /* push parameter */
					    push dword ptr [eax];    /* push the rest of the parameter */
					    push dword ptr [edi+4]; /* push parameter */
					    push dword ptr [edi];    /* push the rest of the parameter */
              mov eax, 0xffffffff;
					    call eax;
					    fstp qword ptr [edi]; /* store result */
					    add esp, 16;
    mov eax, edi; /* set return value */
#endif
RESTORE_STACK
_emit 0x89;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
  }
}
__declspec(naked) void nseel_asm_2pdds_end(void){}

__declspec(naked) void nseel_asm_2pp(void)
{
    __asm {
SAVE_STACK
#ifdef TARGET_X64

#ifdef AMD64ABI
    mov r15, rsi;
    /* rdi is first parameter */
    mov rsi, rax;
    sub rsp, 128;
              mov eax, 0xffffffff;
					    call eax;
    mov rsi, r15;
    movq [r15], xmm0;
#else
              mov ecx, edi;
              mov edx, eax;
              sub rsp, 128;
    mov edi, 0xffffffff;
    call edi;
    movq [esi], xmm0;
#endif
    add rsp, 128;
#else
              sub esp, 8; /* keep stack aligned */
              push eax; /* push parameter */
					    push edi;    /* push second parameter */
              mov edi, 0xffffffff;
					    call edi;
					    fstp EEL_ASM_TYPE [esi]; /* store result */
					    add esp, 16;
#endif
					    mov eax, esi; /* set return value */
					    add esi, EEL_F_SIZE; /* advance worktab ptr */
RESTORE_STACK
_emit 0x89;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
  }
}
__declspec(naked) void nseel_asm_2pp_end(void) {}


__declspec(naked) void nseel_asm_1pp(void)
{
__asm {
SAVE_STACK
#ifdef TARGET_X64
#ifdef AMD64ABI
    mov r15, rsi;
    mov edi, eax;
    sub rsp, 128;
    mov rax, 0xffffffff;
    call rax;
    mov rsi, r15;
    movq [r15], xmm0;
#else
              mov ecx, eax;
              sub rsp, 128;
    mov edi, 0xffffffff;
    call edi;
    movq [esi], xmm0;
#endif
    add rsp, 128;
#else
              sub esp, 12; /* keep stack aligned */
					    push eax; /* push parameter */
              mov edi, 0xffffffff;
              call edi;
					    fstp EEL_ASM_TYPE [esi]; /* store result */
					    add esp, 16;
#endif
					    mov eax, esi; /* set return value */
					    add esi, EEL_F_SIZE; /* advance worktab ptr */
RESTORE_STACK
_emit 0x89;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
  }
}
__declspec(naked) void nseel_asm_1pp_end(void){}



//---------------------------------------------------------------------------------------------------------------


// do nothing, eh
__declspec(naked) void nseel_asm_exec2(void)
{
   __asm {
      
_emit 0x89;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
    }
}
__declspec(naked) void nseel_asm_exec2_end(void) { }



__declspec(naked) void nseel_asm_invsqrt(void)
{
  __asm {
    fld EEL_ASM_TYPE [eax];
    mov edx, 0x5f3759df;
    fst dword ptr [esi];
#ifdef TARGET_X64
    mov rax, 0xffffffff;
    sub ecx, ecx;
    fmul EEL_ASM_TYPE [rax];
#else
#if EEL_F_SIZE == 8
_emit 0xDC; // fmul qword ptr [0xffffffff]
_emit 0x0D;
_emit 0xFF;
_emit 0xFF;
_emit 0xFF;
_emit 0xFF;
#else
_emit 0xD8; // fmul dword ptr [0xffffffff]
_emit 0x0D;
_emit 0xFF;
_emit 0xFF;
_emit 0xFF;
_emit 0xFF;
#endif
#endif
    mov ecx, dword ptr [esi];
    sar ecx, 1;
    sub edx, ecx;
    mov dword ptr [esi], edx;
    fmul dword ptr [esi];
    fmul dword ptr [esi];
#ifdef TARGET_X64
    mov rax, 0xffffffff;
    fadd EEL_ASM_TYPE [rax];
#else
#if EEL_F_SIZE == 8
_emit 0xDC; // fadd qword ptr [0xffffffff]
_emit 0x05;
_emit 0xFF;
_emit 0xFF;
_emit 0xFF;
_emit 0xFF;
#else
_emit 0xD8; // fadd dword ptr [0xffffffff]
_emit 0x05;
_emit 0xFF;
_emit 0xFF;
_emit 0xFF;
_emit 0xFF;
#endif
#endif
    fmul dword ptr [esi];
    mov eax, esi;
    fstp EEL_ASM_TYPE [esi];
    add esi, EEL_F_SIZE;
_emit 0x89;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
  }
}
__declspec(naked) void nseel_asm_invsqrt_end(void) {}


//---------------------------------------------------------------------------------------------------------------
__declspec(naked) void nseel_asm_sin(void)
{
  __asm {
    fld EEL_ASM_TYPE [eax];
    fsin;
    mov eax, esi;
    fstp EEL_ASM_TYPE [esi];
    add esi, EEL_F_SIZE;
_emit 0x89;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
  }
}
__declspec(naked) void nseel_asm_sin_end(void) {}

//---------------------------------------------------------------------------------------------------------------
__declspec(naked) void nseel_asm_cos(void)
{
  __asm {
    fld EEL_ASM_TYPE [eax];
    fcos;
    mov eax, esi;
    fstp EEL_ASM_TYPE [esi];
    add esi, EEL_F_SIZE;
_emit 0x89;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
  }
}
__declspec(naked) void nseel_asm_cos_end(void) {}

//---------------------------------------------------------------------------------------------------------------
__declspec(naked) void nseel_asm_tan(void)
{
  __asm {
    fld EEL_ASM_TYPE [eax];
    fptan;
    mov eax, esi;
    fstp st(0);
    fstp EEL_ASM_TYPE [esi];
    add esi, EEL_F_SIZE;
_emit 0x89;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
  }
}
__declspec(naked) void nseel_asm_tan_end(void) {}

//---------------------------------------------------------------------------------------------------------------
__declspec(naked) void nseel_asm_sqr(void)
{
  __asm {
	fld EEL_ASM_TYPE [eax];
    fmul st(0), st(0);
    mov eax, esi;
    fstp EEL_ASM_TYPE [esi];
    add esi, EEL_F_SIZE;
_emit 0x89;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
  }
}
__declspec(naked) void nseel_asm_sqr_end(void) {}

//---------------------------------------------------------------------------------------------------------------
__declspec(naked) void nseel_asm_sqrt(void)
{
  __asm {
    fld EEL_ASM_TYPE [eax];
    fabs;
    fsqrt;
    mov eax, esi;
    fstp EEL_ASM_TYPE [esi];
    add esi, EEL_F_SIZE;
_emit 0x89;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
  }
}
__declspec(naked) void nseel_asm_sqrt_end(void) {}


//---------------------------------------------------------------------------------------------------------------
__declspec(naked) void nseel_asm_log(void)
{
  __asm {
    fldln2;
    fld EEL_ASM_TYPE [eax];
    mov eax, esi;
    fyl2x;
    fstp EEL_ASM_TYPE [esi];
    add esi, EEL_F_SIZE;

_emit 0x89;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
  }
}
__declspec(naked) void nseel_asm_log_end(void) {}

//---------------------------------------------------------------------------------------------------------------
__declspec(naked) void nseel_asm_log10(void)
{
  __asm {
    fldlg2;
    fld EEL_ASM_TYPE [eax];
    mov eax, esi;
    fyl2x;
    fstp EEL_ASM_TYPE [esi];
    add esi, EEL_F_SIZE;

_emit 0x89;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
  }
}
__declspec(naked) void nseel_asm_log10_end(void) {}

//---------------------------------------------------------------------------------------------------------------
__declspec(naked) void nseel_asm_abs(void)
{
  __asm {
    fld EEL_ASM_TYPE [eax];
    fabs;
    mov eax, esi;
    fstp EEL_ASM_TYPE [esi];
    add esi, EEL_F_SIZE;
_emit 0x89;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
  }
}
__declspec(naked) void nseel_asm_abs_end(void) {}


//---------------------------------------------------------------------------------------------------------------
__declspec(naked) void nseel_asm_assign(void)
{
#ifdef TARGET_X64

  __asm {
    mov rdx, qword ptr [rax];
    mov rcx, rdx;
    shr rdx, 32;
    and edx, 0x7FF00000;
    jz label_0;
    cmp edx, 0x7FF00000;
    je label_0;
    jmp label_1;
label_0:
    
    sub rcx, rcx;
label_1:
    
    mov qword ptr [edi], rcx;
_emit 0x89;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
    }

#else


#if EEL_F_SIZE == 8
  __asm {
    mov edx, dword ptr [eax+4];
    mov ecx, dword ptr [eax];
    and edx, 0x7ff00000;
    jz label_2;   // if exponent=zero, zero
    cmp edx, 0x7ff00000;
    je label_2; // if exponent=all 1s, zero
    mov edx, dword ptr [eax+4]; // reread
    jmp label_3;
label_2:
    
    sub ecx, ecx;
    sub edx, edx;
label_3:
    
    mov dword ptr [edi], ecx;
    mov dword ptr [edi+4], edx;
_emit 0x89;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
  }
#else
  __asm {
    mov ecx, dword ptr [eax];
    mov dword ptr [edi], ecx;
_emit 0x89;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
  }
#endif

#endif

}
__declspec(naked) void nseel_asm_assign_end(void) {}

//---------------------------------------------------------------------------------------------------------------
__declspec(naked) void nseel_asm_add(void)
{
  __asm {
    fld EEL_ASM_TYPE [eax];
    fadd EEL_ASM_TYPE [edi];
    mov eax, esi;
    fstp EEL_ASM_TYPE [esi];
    add esi, EEL_F_SIZE;
_emit 0x89;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
  }
}
__declspec(naked) void nseel_asm_add_end(void) {}

__declspec(naked) void nseel_asm_add_op(void)
{
  __asm {
    fld EEL_ASM_TYPE [eax];
    fadd EEL_ASM_TYPE [edi];
    mov eax, edi;
    fstp EEL_ASM_TYPE [edi];
_emit 0x89;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
  }
}
__declspec(naked) void nseel_asm_add_op_end(void) {}


//---------------------------------------------------------------------------------------------------------------
__declspec(naked) void nseel_asm_sub(void)
{
  __asm {
    fld EEL_ASM_TYPE [edi];
    fsub EEL_ASM_TYPE [eax];
    mov eax, esi;
    fstp EEL_ASM_TYPE [esi];
    add esi, EEL_F_SIZE;
_emit 0x89;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
  }
}
__declspec(naked) void nseel_asm_sub_end(void) {}

__declspec(naked) void nseel_asm_sub_op(void)
{
  __asm {
    fld EEL_ASM_TYPE [edi];
    fsub EEL_ASM_TYPE [eax];
    mov eax, edi;
    fstp EEL_ASM_TYPE [edi];
_emit 0x89;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
  }
}
__declspec(naked) void nseel_asm_sub_op_end(void) {}

//---------------------------------------------------------------------------------------------------------------
__declspec(naked) void nseel_asm_mul(void)
{
  __asm {
    fld EEL_ASM_TYPE [edi];
    fmul EEL_ASM_TYPE [eax];
    mov eax, esi;
    fstp EEL_ASM_TYPE [esi];
    add esi, EEL_F_SIZE;
_emit 0x89;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
  }
}
__declspec(naked) void nseel_asm_mul_end(void) {}

__declspec(naked) void nseel_asm_mul_op(void)
{
  __asm {
    fld EEL_ASM_TYPE [eax];
    fmul EEL_ASM_TYPE [edi];
    mov eax, edi;
    fstp EEL_ASM_TYPE [edi];
_emit 0x89;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
  }
}
__declspec(naked) void nseel_asm_mul_op_end(void) {}

//---------------------------------------------------------------------------------------------------------------
__declspec(naked) void nseel_asm_div(void)
{
  __asm {
    fld EEL_ASM_TYPE [edi];
    fdiv EEL_ASM_TYPE [eax];
    mov eax, esi;
    fstp EEL_ASM_TYPE [esi];
    add esi, EEL_F_SIZE;
_emit 0x89;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
  }
}
__declspec(naked) void nseel_asm_div_end(void) {}

__declspec(naked) void nseel_asm_div_op(void)
{
  __asm {
    fld EEL_ASM_TYPE [edi];
    fdiv EEL_ASM_TYPE [eax];
    mov eax, edi;
    fstp EEL_ASM_TYPE [edi];
_emit 0x89;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
  }
}
__declspec(naked) void nseel_asm_div_op_end(void) {}

//---------------------------------------------------------------------------------------------------------------
__declspec(naked) void nseel_asm_mod(void)
{
  __asm {
    fld EEL_ASM_TYPE [edi];
    fld EEL_ASM_TYPE [eax];
    fabs;
    fistp dword ptr [esi];
    fabs;
    fistp dword ptr [esi+4];
    xor edx, edx;
#ifdef TARGET_X64
    sub eax, eax;
#endif
    cmp dword ptr [esi], 0;
    je label_4; // skip devide, set return to 0
    mov eax, dword ptr [esi+4];
    div dword ptr [esi];
label_4:
    
    mov dword ptr [esi], edx;
    fild dword ptr [esi];
    mov eax, esi;
    fstp EEL_ASM_TYPE [esi];
    add esi, EEL_F_SIZE;
_emit 0x89;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
  }
}
__declspec(naked) void nseel_asm_mod_end(void) {}

__declspec(naked) void nseel_asm_mod_op(void)
{
  __asm {
    fld EEL_ASM_TYPE [edi];
    fld EEL_ASM_TYPE [eax];
    fabs;
    fistp dword ptr [edi];
    fabs;
    fistp dword ptr [esi];
#ifdef TARGET_X64
    sub eax, eax;
#endif
    xor edx, edx;
    cmp dword ptr [edi], 0;
    je label_5; // skip devide, set return to 0
    mov eax, dword ptr [esi];
    div dword ptr [edi];
label_5:
    
    mov dword ptr [edi], edx;
    fild dword ptr [edi];
    mov eax, edi;
    fstp EEL_ASM_TYPE [edi];
_emit 0x89;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
    }
}
__declspec(naked) void nseel_asm_mod_op_end(void) {}

//---------------------------------------------------------------------------------------------------------------
__declspec(naked) void nseel_asm_or(void)
{
  __asm {
    fld EEL_ASM_TYPE [edi];
    fld EEL_ASM_TYPE [eax];
    mov eax, esi;
    fistp qword ptr [esi];
    fistp qword ptr [esi+8];
#ifdef TARGET_X64
    mov rdi, qword ptr [rsi+8];
    or qword ptr [rsi], rdi;
#else
    mov edi, dword ptr [esi+8];
    mov ecx, dword ptr [esi+12];
    or dword ptr [esi], edi;
    or dword ptr [esi+4], ecx;
#endif
    fild qword ptr [esi];
    fstp EEL_ASM_TYPE [esi];
    add esi, EEL_F_SIZE;
_emit 0x89;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
  }
}
__declspec(naked) void nseel_asm_or_end(void) {}

__declspec(naked) void nseel_asm_or_op(void)
{
  __asm {
    fld EEL_ASM_TYPE [edi];
    fld EEL_ASM_TYPE [eax];
    fistp qword ptr [edi];
    fistp qword ptr [esi];
#ifdef TARGET_X64
    mov rax, qword ptr [rsi];
    or qword ptr [rdi], rax;
#else
    mov eax, dword ptr [esi];
    mov ecx, dword ptr [esi+4];
    or dword ptr [edi], eax;
    or dword ptr [edi+4], ecx;
#endif
    fild qword ptr [edi];
    mov eax, edi;
    fstp EEL_ASM_TYPE [edi];
_emit 0x89;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
  }
}
__declspec(naked) void nseel_asm_or_op_end(void) {}

//---------------------------------------------------------------------------------------------------------------
__declspec(naked) void nseel_asm_and(void)
{
  __asm {
    fld EEL_ASM_TYPE [edi];
    fld EEL_ASM_TYPE [eax];
    mov eax, esi;
    fistp qword ptr [esi];
    fistp qword ptr [esi+8];
#ifdef TARGET_X64
    mov rdi, qword ptr [rsi+8];
    and qword ptr [rsi], rdi;
#else
    mov edi, dword ptr [esi+8];
    mov ecx, dword ptr [esi+12];
    and dword ptr [esi], edi;
    and dword ptr [esi+4], ecx;
#endif
    fild qword ptr [esi];
    fstp EEL_ASM_TYPE [esi];
    add esi, EEL_F_SIZE;
_emit 0x89;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
  }
}
__declspec(naked) void nseel_asm_and_end(void) {}

__declspec(naked) void nseel_asm_and_op(void)
{
  __asm {
    fld EEL_ASM_TYPE [edi];
    fld EEL_ASM_TYPE [eax];
    fistp qword ptr [edi];
    fistp qword ptr [esi];
#ifdef TARGET_X64
    mov rax, qword ptr [rsi];
    and qword ptr [rdi], rax;
#else
    mov eax, dword ptr [esi];
    mov ecx, dword ptr [esi+4];
    and dword ptr [edi], eax;
    and dword ptr [edi+4], ecx;
#endif
    fild qword ptr [edi];
    mov eax, edi;
    fstp EEL_ASM_TYPE [edi];
_emit 0x89;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
  }
}
__declspec(naked) void nseel_asm_and_op_end(void) {}


//---------------------------------------------------------------------------------------------------------------
__declspec(naked) void nseel_asm_uplus(void) // this is the same as doing nothing, it seems
{
   __asm {
      
_emit 0x89;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
    }
}
__declspec(naked) void nseel_asm_uplus_end(void) {}

//---------------------------------------------------------------------------------------------------------------
__declspec(naked) void nseel_asm_uminus(void)
{
  __asm {
#if EEL_F_SIZE == 8
    mov ecx, dword ptr [eax];
    mov edi, dword ptr [eax+4];
    mov dword ptr [esi], ecx;
    xor edi, 0x80000000;
    mov eax, esi;
    mov dword ptr [esi+4], edi;
    add esi, 8;
#else
    mov ecx, dword ptr [eax];
    xor ecx, 0x80000000;
    mov eax, esi;
    mov dword ptr [esi], ecx;
    add esi, 4;
#endif
_emit 0x89;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
  }
}
__declspec(naked) void nseel_asm_uminus_end(void) {}



//---------------------------------------------------------------------------------------------------------------
__declspec(naked) void nseel_asm_sign(void)
{
  __asm {

#ifdef TARGET_X64


    mov rdi, 0xFFFFFFFF;
    mov rcx, qword ptr [rax];
    mov rdx, 0x7FFFFFFFFFFFFFFF;
    test rcx, rdx;
    jz label_6;
    shr rcx, 60;
    and rcx, 8;
    add rcx, rdi;
    mov rax, rsi;
    add rsi, 8;
    mov rdi, qword ptr [rcx];
    mov qword ptr [rax], rdi;
label_6:
	


#else

    mov edi, 0xFFFFFFFF;
#if EEL_F_SIZE == 8
    mov ecx, dword ptr [eax+4];
    mov edx, dword ptr [eax];
    test edx, 0xFFFFFFFF;
    jnz label_7;
#else
    mov ecx, dword ptr [eax];
#endif
    // high dword (minus sign bit) is zero
    test ecx, 0x7FFFFFFF;
    jz label_8; // zero zero, return the value passed directly
label_7:
    
#if EEL_F_SIZE == 8
	shr ecx, 28;
#else
	shr ecx, 29;
#endif

    and ecx, EEL_F_SIZE;
    add ecx, edi;

    mov eax, esi;
    add esi, EEL_F_SIZE;

    mov edi, dword ptr [ecx];
#if EEL_F_SIZE == 8
    mov edx, dword ptr [ecx+4];
#endif
    mov dword ptr [eax], edi;
#if EEL_F_SIZE == 8
    mov dword ptr [eax+4], edx;
#endif
label_8:
	

#endif
_emit 0x89;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
}
}
__declspec(naked) void nseel_asm_sign_end(void) {}



//---------------------------------------------------------------------------------------------------------------
__declspec(naked) void nseel_asm_bnot(void)
{
  __asm {
    fld EEL_ASM_TYPE [eax];
    fabs;
#ifdef TARGET_X64
    mov rax, 0xFFFFFFFF;
    fcomp EEL_ASM_TYPE [rax]; //[g_closefact]
#else
#if EEL_F_SIZE == 8
_emit 0xDC; // fcomp qword ptr [0xffffffff]
_emit 0x1D;
_emit 0xFF;
_emit 0xFF;
_emit 0xFF;
_emit 0xFF;
#else
_emit 0xD8; // fcomp dword ptr [0xffffffff]
_emit 0x1D;
_emit 0xFF;
_emit 0xFF;
_emit 0xFF;
_emit 0xFF;
#endif
#endif
    fstsw ax;
    test eax, 256;
    mov eax, esi;
    jz label_9;
    fld1;
    jmp label_10;
label_9:
    
    fldz;
label_10:
    
    fstp EEL_ASM_TYPE [esi];
    add esi, EEL_F_SIZE;
_emit 0x89;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
  }
}
__declspec(naked) void nseel_asm_bnot_end(void) {}

//---------------------------------------------------------------------------------------------------------------
__declspec(naked) void nseel_asm_if(void)
{
  __asm {
    fld EEL_ASM_TYPE [eax];
    fabs;
#ifdef TARGET_X64
    mov rax, 0xFFFFFFFF;
    fcomp EEL_ASM_TYPE [rax]; //[g_closefact]
    mov rax, 0xFFFFFFFF;
    mov qword ptr [esi], rax; // conversion script will extend these out to full len
    mov rax, 0xFFFFFFFF;
    mov qword ptr [esi+8], rax;
    fstsw ax;
    shr rax, 5;
    and rax, 8;
    mov rax, qword ptr [rax+rsi];
    sub rsp, 8;
#else
#if EEL_F_SIZE == 8
_emit 0xDC; // fcomp qword ptr [0xffffffff]
_emit 0x1D;
_emit 0xFF;
_emit 0xFF;
_emit 0xFF;
_emit 0xFF;
#else
_emit 0xD8; // fcomp dword ptr [0xffffffff]
_emit 0x1D;
_emit 0xFF;
_emit 0xFF;
_emit 0xFF;
_emit 0xFF;
#endif
    mov dword ptr [esi], 0xFFFFFFFF;
    mov dword ptr [esi+4], 0xFFFFFFFF;
    fstsw ax;
    shr eax, 6;
    and eax, 4;
    mov eax, dword ptr [eax+esi];
#endif
    call eax;
#ifdef TARGET_X64
    add rsp, 8;
#endif

_emit 0x89;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
  }
}
__declspec(naked) void nseel_asm_if_end(void) {}

//---------------------------------------------------------------------------------------------------------------
__declspec(naked) void nseel_asm_repeat(void)
{
  __asm {
    fld EEL_ASM_TYPE [eax];
    fistp dword ptr [esi];
#ifdef TARGET_X64 // safe not sure if movl ecx will zero the high word
    xor ecx, ecx;
#endif
    mov ecx, dword ptr [esi];
    cmp ecx, 1;
    jl label_11;
    cmp ecx, NSEEL_LOOPFUNC_SUPPORT_MAXLEN;
    jl label_12;
    mov ecx, NSEEL_LOOPFUNC_SUPPORT_MAXLEN;
label_12:

      mov edx, 0xFFFFFFFF;
      sub esp, 8; /* keep stack aligned -- note this is required on x64 too!*/
      push esi; // revert back to last temp workspace
      push ecx;
      call edx;
      pop ecx;
      pop esi;
      add esp, 8; /* keep stack aligned -- also required on x64*/
    dec ecx;
    jnz label_12;
label_11:

_emit 0x89;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
  }
}
__declspec(naked) void nseel_asm_repeat_end(void) {}

__declspec(naked) void nseel_asm_repeatwhile(void)
{
  __asm {
    mov ecx, NSEEL_LOOPFUNC_SUPPORT_MAXLEN;
label_13:

      mov edx, 0xFFFFFFFF;
      sub esp, 8; /* keep stack aligned -- required on x86 and x64*/
      push esi; // revert back to last temp workspace
      push ecx;
      call edx;
      pop ecx;
      pop esi;
      add esp, 8; /* keep stack aligned -- required on x86 and x64 */
      fld EEL_ASM_TYPE [eax];
	  fabs;
#ifdef TARGET_X64
    mov rax, 0xFFFFFFFF;
    fcomp EEL_ASM_TYPE [rax]; //[g_closefact]
#else
#if EEL_F_SIZE == 8
_emit 0xDC; // fcomp qword ptr [0xffffffff]
_emit 0x1D;
_emit 0xFF;
_emit 0xFF;
_emit 0xFF;
_emit 0xFF;
#else
_emit 0xD8; // fcomp dword ptr [0xffffffff]
_emit 0x1D;
_emit 0xFF;
_emit 0xFF;
_emit 0xFF;
_emit 0xFF;
#endif
#endif
      fstsw ax;
	  test eax, 256;
	  jnz label_14;
    dec ecx;
    jnz label_13;
label_14:
	
	mov eax, esi;
_emit 0x89;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
  }
}
__declspec(naked) void nseel_asm_repeatwhile_end(void) {}


__declspec(naked) void nseel_asm_band(void)
{
  __asm {
    fld EEL_ASM_TYPE [eax];
    fabs;
#ifdef TARGET_X64
    mov rax, 0xFFFFFFFF;
    fcomp EEL_ASM_TYPE [rax]; //[g_closefact]
#else
#if EEL_F_SIZE == 8
_emit 0xDC; // fcomp qword ptr [0xffffffff]
_emit 0x1D;
_emit 0xFF;
_emit 0xFF;
_emit 0xFF;
_emit 0xFF;
#else
_emit 0xD8; // fcomp dword ptr [0xffffffff]
_emit 0x1D;
_emit 0xFF;
_emit 0xFF;
_emit 0xFF;
_emit 0xFF;
#endif
#endif
    fstsw ax;
    test eax, 256;
    jnz label_15; // if Z, then we are nonzero

        mov ecx, 0xFFFFFFFF;
#ifdef TARGET_X64
    sub rsp, 8;
#endif
        call ecx;
#ifdef TARGET_X64
    add rsp, 8;
#endif
    	fld EEL_ASM_TYPE [eax];
    	fabs;
#ifdef TARGET_X64
    mov rax, 0xFFFFFFFF;
    fcomp EEL_ASM_TYPE [rax]; //[g_closefact]
#else
#if EEL_F_SIZE == 8
_emit 0xDC; // fcomp qword ptr [0xffffffff]
_emit 0x1D;
_emit 0xFF;
_emit 0xFF;
_emit 0xFF;
_emit 0xFF;
#else
_emit 0xD8; // fcomp dword ptr [0xffffffff]
_emit 0x1D;
_emit 0xFF;
_emit 0xFF;
_emit 0xFF;
_emit 0xFF;
#endif
#endif
    	fstsw ax;
        test eax, 256;
	jnz label_15;
	fld1;
	jmp label_16;

label_15:

    fldz;
label_16:


    mov eax, esi;
    fstp EEL_ASM_TYPE [esi];
    add esi, EEL_F_SIZE;
_emit 0x89;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
  }
}
__declspec(naked) void nseel_asm_band_end(void) {}

__declspec(naked) void nseel_asm_bor(void)
{
  __asm {
    fld EEL_ASM_TYPE [eax];
    fabs;
#ifdef TARGET_X64
    mov rax, 0xFFFFFFFF;
    fcomp EEL_ASM_TYPE [rax]; //[g_closefact]
#else
#if EEL_F_SIZE == 8
_emit 0xDC; // fcomp qword ptr [0xffffffff]
_emit 0x1D;
_emit 0xFF;
_emit 0xFF;
_emit 0xFF;
_emit 0xFF;
#else
_emit 0xD8; // fcomp dword ptr [0xffffffff]
_emit 0x1D;
_emit 0xFF;
_emit 0xFF;
_emit 0xFF;
_emit 0xFF;
#endif
#endif
    fstsw ax;
    test eax, 256;
    jz label_17; // if Z, then we are nonzero

        mov ecx, 0xFFFFFFFF;
#ifdef TARGET_X64
    sub rsp, 8;
#endif
        call ecx;
#ifdef TARGET_X64
    add rsp, 8;
#endif
    	fld EEL_ASM_TYPE [eax];
    	fabs;
#ifdef TARGET_X64
    mov rax, 0xFFFFFFFF;
    fcomp EEL_ASM_TYPE [rax]; //[g_closefact]
#else
#if EEL_F_SIZE == 8
_emit 0xDC; // fcomp qword ptr [0xffffffff]
_emit 0x1D;
_emit 0xFF;
_emit 0xFF;
_emit 0xFF;
_emit 0xFF;
#else
_emit 0xD8; // fcomp dword ptr [0xffffffff]
_emit 0x1D;
_emit 0xFF;
_emit 0xFF;
_emit 0xFF;
_emit 0xFF;
#endif
#endif
    	fstsw ax;
        test eax, 256;
	jz label_17;
	fldz;
	jmp label_18;

label_17:

    fld1;
label_18:


    mov eax, esi;
    fstp EEL_ASM_TYPE [esi];
    add esi, EEL_F_SIZE;
_emit 0x89;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
  }
}
__declspec(naked) void nseel_asm_bor_end(void) {}

//---------------------------------------------------------------------------------------------------------------
__declspec(naked) void nseel_asm_equal(void)
{
  __asm {
    fld EEL_ASM_TYPE [eax];
    fsub EEL_ASM_TYPE [edi];
    fabs;
#ifdef TARGET_X64
    mov rax, 0xFFFFFFFF;
    fcomp EEL_ASM_TYPE [rax]; //[g_closefact]
#else
#if EEL_F_SIZE == 8
_emit 0xDC; // fcomp qword ptr [0xffffffff]
_emit 0x1D;
_emit 0xFF;
_emit 0xFF;
_emit 0xFF;
_emit 0xFF;
#else
_emit 0xD8; // fcomp dword ptr [0xffffffff]
_emit 0x1D;
_emit 0xFF;
_emit 0xFF;
_emit 0xFF;
_emit 0xFF;
#endif
#endif
    fstsw ax;
    test eax, 256;
    mov eax, esi;
    jz label_19;
    fld1;
    jmp label_20;
label_19:
    
    fldz;
label_20:
    
    fstp EEL_ASM_TYPE [esi];
    add esi, EEL_F_SIZE;
_emit 0x89;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
  }
}
__declspec(naked) void nseel_asm_equal_end(void) {}
//
//---------------------------------------------------------------------------------------------------------------
__declspec(naked) void nseel_asm_notequal(void)
{
  __asm {
    fld EEL_ASM_TYPE [eax];
    fsub EEL_ASM_TYPE [edi];
    fabs;
#ifdef TARGET_X64
    mov rax, 0xFFFFFFFF;
    fcomp EEL_ASM_TYPE [rax]; //[g_closefact]
#else
#if EEL_F_SIZE == 8
_emit 0xDC; // fcomp qword ptr [0xffffffff]
_emit 0x1D;
_emit 0xFF;
_emit 0xFF;
_emit 0xFF;
_emit 0xFF;
#else
_emit 0xD8; // fcomp dword ptr [0xffffffff]
_emit 0x1D;
_emit 0xFF;
_emit 0xFF;
_emit 0xFF;
_emit 0xFF;
#endif
#endif
    fstsw ax;
    test eax, 256;
    mov eax, esi;
    jnz label_21;
    fld1;
    jmp label_22;
label_21:
    
    fldz;
label_22:
    
    fstp EEL_ASM_TYPE [esi];
    add esi, EEL_F_SIZE;
_emit 0x89;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
  }
}
__declspec(naked) void nseel_asm_notequal_end(void) {}


//---------------------------------------------------------------------------------------------------------------
__declspec(naked) void nseel_asm_below(void)
{
  __asm {
    fld EEL_ASM_TYPE [edi];
    fcomp EEL_ASM_TYPE [eax];
    fstsw ax;
    test eax, 256;
    mov eax, esi;
    jz label_23;
    fld1;
    jmp label_24;
label_23:
    
    fldz;
label_24:
    
    fstp EEL_ASM_TYPE [esi];
    add esi, EEL_F_SIZE;
_emit 0x89;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
  }
}
__declspec(naked) void nseel_asm_below_end(void) {}

//---------------------------------------------------------------------------------------------------------------
__declspec(naked) void nseel_asm_beloweq(void)
{
  __asm {
    fld EEL_ASM_TYPE [eax];
    fcomp EEL_ASM_TYPE [edi];
    fstsw ax;
    test eax, 256;
    mov eax, esi;
    jnz label_25;
    fld1;
    jmp label_26;
label_25:
    
    fldz;
label_26:
    
    fstp EEL_ASM_TYPE [esi];
    add esi, EEL_F_SIZE;
_emit 0x89;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
  }
}
__declspec(naked) void nseel_asm_beloweq_end(void) {}


//---------------------------------------------------------------------------------------------------------------
__declspec(naked) void nseel_asm_above(void)
{
  __asm {
    fld EEL_ASM_TYPE [eax];
    fcomp EEL_ASM_TYPE [edi];
    fstsw ax;
    test eax, 256;
    mov eax, esi;
    jz label_27;
    fld1;
    jmp label_28;
label_27:
    
    fldz;
label_28:
    
    fstp EEL_ASM_TYPE [esi];
    add esi, EEL_F_SIZE;
_emit 0x89;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
  }
}
__declspec(naked) void nseel_asm_above_end(void) {}

__declspec(naked) void nseel_asm_aboveeq(void)
{
  __asm {
    fld EEL_ASM_TYPE [edi];
    fcomp EEL_ASM_TYPE [eax];
    fstsw ax;
    test eax, 256;
    mov eax, esi;
    jnz label_29;
    fld1;
    jmp label_30;
label_29:
    
    fldz;
label_30:
    
    fstp EEL_ASM_TYPE [esi];
    add esi, EEL_F_SIZE;
_emit 0x89;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
  }
}
__declspec(naked) void nseel_asm_aboveeq_end(void) {}



__declspec(naked) void nseel_asm_min(void)
{
  __asm {
    fld EEL_ASM_TYPE [edi];
    fcomp EEL_ASM_TYPE [eax];
    push eax;
    fstsw ax;
    test eax, 256;
    pop eax;
    jz label_31;
    mov eax, edi;
label_31:
    
_emit 0x89;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
    }

}
__declspec(naked) void nseel_asm_min_end(void) {}

__declspec(naked) void nseel_asm_max(void)
{
  __asm {
    fld EEL_ASM_TYPE [edi];
    fcomp EEL_ASM_TYPE [eax];
    push eax;
    fstsw ax;
    test eax, 256;
    pop eax;
    jnz label_32;
    mov eax, edi;
label_32:
    
_emit 0x89;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
    }
}
__declspec(naked) void nseel_asm_max_end(void) {}





// just generic functions left, yay




__declspec(naked) void _asm_generic3parm(void)
{
  __asm {
#ifdef TARGET_X64

#ifdef AMD64ABI

    mov r15, rsi;
    mov rdx, rdi; // third parameter = parm
    mov rdi, 0xFFFFFFFF; // first parameter= context

    mov rsi, ecx; // second parameter = parm
    mov rcx, rax; // fourth parameter = parm
    mov rax, 0xffffffff; // call function
    sub rsp, 128;
    call rax;

    mov rsi, r15;
    add rsp, 128;

#else
    mov edx, ecx; // second parameter = parm
    mov ecx, 0xFFFFFFFF; // first parameter= context
    mov r8, rdi; // third parameter = parm
    mov r9, rax; // fourth parameter = parm
    mov edi, 0xffffffff; // call function
    sub rsp, 128;
    call edi;
    add rsp, 128;
#endif

#else
SAVE_STACK
    mov edx, 0xFFFFFFFF;
    push eax; // push parameter
    push edi; // push parameter
    push ecx; // push parameter
    push edx; // push context pointer
    mov edi, 0xffffffff;
    call edi;
    add esp, 16;
RESTORE_STACK
#endif
_emit 0x89;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
 }
}
__declspec(naked) void _asm_generic3parm_end(void) {}


__declspec(naked) void _asm_generic3parm_retd(void)
{
  __asm {
#ifdef TARGET_X64
#ifdef AMD64ABI
    mov r15, rsi;
    mov rdx, rdi; // third parameter = parm
    mov rdi, 0xFFFFFFFF; // first parameter= context
    mov rsi, ecx; // second parameter = parm
    mov rcx, rax; // fourth parameter = parm
    mov rax, 0xffffffff; // call function
    sub rsp, 128;
    call rax;
    add rsp, 128;
    mov rsi, r15;
    mov rax, r15;
    movq [r15], xmm0;
    add rsi, 8;
#else
    mov edx, ecx; // second parameter = parm
    mov ecx, 0xFFFFFFFF; // first parameter= context
    mov r8, rdi; // third parameter = parm
    mov r9, rax; // fourth parameter = parm
    mov edi, 0xffffffff; // call function
    sub rsp, 128;
    call edi;
    add rsp, 128;
    movq [rsi], xmm0;
    mov rax, rsi;
    add rsi, 8;
#endif
#else
SAVE_STACK
    mov edx, 0xFFFFFFFF;
    push eax; // push parameter
    push edi; // push parameter
    push ecx; // push parameter
    push edx; // push context pointer
    mov edi, 0xffffffff;
    call edi;
    mov eax, esi;
	  fstp EEL_ASM_TYPE [esi];
   	add esi, EEL_F_SIZE;
    add esp, 16;
RESTORE_STACK
#endif
_emit 0x89;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
 }
}
__declspec(naked) void _asm_generic3parm_retd_end(void) {}


__declspec(naked) void _asm_generic2parm(void) // this prob neds to be fixed for ppc
{
  __asm {
#ifdef TARGET_X64

#ifdef AMD64ABI
    mov r15, rsi;
    mov esi, edi; // second parameter = parm
    mov edi, 0xFFFFFFFF; // first parameter= context
    mov rdx, rax; // third parameter = parm
    mov rcx, 0xffffffff; // call function
    sub rsp, 128;
    call rcx;
    mov rsi, r15;
    add rsp, 128;
#else
    mov ecx, 0xFFFFFFFF; // first parameter= context
    mov edx, edi; // second parameter = parm
    mov r8, rax; // third parameter = parm
    mov edi, 0xffffffff; // call function
    sub rsp, 128;
    call edi;
    add rsp, 128;
#endif
#else
SAVE_STACK
    mov edx, 0xFFFFFFFF;
    sub esp, 4; // keep stack aligned
    push eax; // push parameter
    push edi; // push parameter
    push edx; // push context pointer
    mov edi, 0xffffffff;
    call edi;
    add esp, 16;
RESTORE_STACK
#endif
_emit 0x89;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
 }
}
__declspec(naked) void _asm_generic2parm_end(void) {}


__declspec(naked) void _asm_generic2parm_retd(void)
{
  __asm {
#ifdef TARGET_X64
#ifdef AMD64ABI
    mov r15, rsi;
    mov rsi, rdi; // second parameter = parm
    mov rdi, 0xFFFFFFFF; // first parameter= context
    mov rdx, rax; // third parameter = parm
    mov rcx, 0xffffffff; // call function
    sub rsp, 128;
    call rcx;
    mov rsi, r15;
    add rsp, 128;
    movq [r15], xmm0;
    mov rax, r15;
    add rsi, 8;
#else
    mov ecx, 0xFFFFFFFF; // first parameter= context
    mov edx, edi; // second parameter = parm
    mov r8, rax; // third parameter = parm
    mov edi, 0xffffffff; // call function
    sub rsp, 128;
    call edi;
    add rsp, 128;
    movq [rsi], xmm0;
    mov rax, rsi;
    add rsi, 8;
#endif
#else
SAVE_STACK
    mov edx, 0xFFFFFFFF;
    push eax; // push parameter
    push edi; // push parameter
    push ecx; // push parameter
    push edx; // push context pointer
    mov edi, 0xffffffff;
    call edi;
    mov eax, esi;
	  fstp EEL_ASM_TYPE [esi];
   	add esi, EEL_F_SIZE;
    add esp, 16;
RESTORE_STACK
#endif
_emit 0x89;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
 }
}
__declspec(naked) void _asm_generic2parm_retd_end(void) {}





__declspec(naked) void _asm_generic1parm(void) // this prob neds to be fixed for ppc
{
  __asm {
#ifdef TARGET_X64
#ifdef AMD64ABI
    mov rdi, 0xFFFFFFFF; // first parameter= context
    mov r15, rsi;
    mov rsi, eax; // second parameter = parm
    sub rsp, 128;
    mov rcx, 0xffffffff; // call function
    call rcx;
    mov rsi, r15;
    add rsp, 128;
#else
    mov ecx, 0xFFFFFFFF; // first parameter= context
    mov edx, eax; // second parameter = parm
    mov edi, 0xffffffff; // call function
    sub rsp, 128;
    call edi;
    add rsp, 128;
#endif
#else
SAVE_STACK
    mov edx, 0xFFFFFFFF;
    sub esp, 8; // keep stack aligned
    push eax; // push parameter
    push edx; // push context pointer
    mov edi, 0xffffffff;
    call edi;
    add esp, 16;
RESTORE_STACK
#endif

_emit 0x89;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
 }
}
__declspec(naked) void _asm_generic1parm_end(void) {}


__declspec(naked) void _asm_generic1parm_retd(void) // 1 parameter returning double
{
  __asm {
#ifdef TARGET_X64
#ifdef AMD64ABI
    mov r15, rsi;
    mov rdi, 0xFFFFFFFF; // first parameter= context
    mov rsi, rax; // second parameter = parm
    mov rcx, 0xffffffff; // call function
    sub rsp, 128;
    call rcx;
    mov rsi, r15;
    add rsp, 128;
    movq [r15], xmm0;
    mov rax, r15;
    add rsi, 8;
#else
    mov ecx, 0xFFFFFFFF; // first parameter= context
    mov edx, eax; // second parameter = parm
    mov edi, 0xffffffff; // call function
    sub rsp, 128;
    call edi;
    add rsp, 128;
    movq [rsi], xmm0;
    mov rax, rsi;
    add rsi, 8;
#endif
#else
SAVE_STACK
    mov edx, 0xFFFFFFFF;
    sub esp, 8; // keep stack aligned
    push eax; // push parameter
    push edx; // push context pointer
    mov edi, 0xffffffff;
    call edi;
	  mov eax, esi;
	  fstp EEL_ASM_TYPE [esi];
	  add esi, EEL_F_SIZE;
    add esp, 16;
RESTORE_STACK
#endif
_emit 0x89;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
 }
}
__declspec(naked) void _asm_generic1parm_retd_end(void) {}





// this gets its own stub because it's pretty crucial for performance :/

__declspec(naked) void _asm_megabuf(void)
{
  __asm {
SAVE_STACK

#ifdef TARGET_X64


#ifdef AMD64ABI

    mov r15, rsi;
    mov rdi, 0xFFFFFFFF; // first parameter = context pointer
    fld EEL_ASM_TYPE [eax];
    mov rdx, 0xFFFFFFFF;
    fadd EEL_ASM_TYPE [rdx];
    fistp dword ptr [r15];
    xor rsi, rsi;
    mov esi, dword ptr [r15]; // r15 = esi (from above)
    mov edx, 0xffffffff;
    sub rsp, 128;
    call edx;
    mov rsi, r15;
    add rsp, 128;
    and rax, rax;
    jnz label_33;
    mov rax, r15;
    mov qword ptr [esi], 0;
    add rsi, EEL_F_SIZE;
label_33:
    

#else
    mov ecx, 0xFFFFFFFF; // first parameter = context pointer
    fld EEL_ASM_TYPE [eax];
	mov edx, 0xFFFFFFFF;
    fadd EEL_ASM_TYPE [rdx];
    fistp dword ptr [esi];
    xor rdx, rdx;
    mov edx, dword ptr [esi];
    mov edi, 0xffffffff;
	sub rsp, 128;
    call edi;
	add rsp, 128;
    and rax, rax;
    jnz label_34;
    mov rax, rsi;
    mov qword ptr [esi], 0;
    add esi, EEL_F_SIZE;
label_34:
    
#endif


#else
    mov edx, 0xFFFFFFFF;
    fld EEL_ASM_TYPE [eax];
#if EEL_F_SIZE == 8
_emit 0xDC; // fadd qword ptr [0xffffffff]
_emit 0x05;
_emit 0xFF;
_emit 0xFF;
_emit 0xFF;
_emit 0xFF;
#else
_emit 0xD8; // fadd dword ptr [0xffffffff]
_emit 0x05;
_emit 0xFF;
_emit 0xFF;
_emit 0xFF;
_emit 0xFF;
#endif
    fistp dword ptr [esi];
    sub esp, 8; // keep stack aligned
    push dword ptr [esi]; // parameter
    push edx; // push context pointer
    mov edi, 0xffffffff;
    call edi;
    add esp, 16;
    and eax, eax;
    jnz label_35;
    mov eax, esi;
    mov dword ptr [esi], 0;
#if EEL_F_SIZE == 8
    mov dword ptr [esi+4], 0;
#endif
    add esi, EEL_F_SIZE;
label_35:
    


#endif

RESTORE_STACK

_emit 0x89;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
 }
}

__declspec(naked) void _asm_megabuf_end(void) {}


#ifdef TARGET_X64
__declspec(naked) void win64_callcode()
{
	__asm {
#ifdef AMD64ABI
		mov eax, edi;
#else
		mov eax, ecx;
#endif

		push rbx;
		push rbp;
#ifndef AMD64ABI
		push rdi;
		push rsi;
		push r12;
		push r13;
#endif
		push r14; // on AMD64ABI, we'll use r14/r15 to save edi/esi
		push r15;
		call eax;
		pop r15;
		pop r14;
#ifndef AMD64ABI
		pop r13;
		pop r12;
		pop rsi;
		pop rdi;
		fclex;
#endif
		pop rbp;
		pop rbx;
		ret;
_emit 0x89;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
_emit 0x90;
	}
}

#endif
