#!/bin/bash

set -euo pipefail
set -x

if  [ "${D_VERSION:-dmd}" == "gdc" ] ; then
    echo "GDC unrelated test failures to be fixed"
    exit 0

    # Use the dub-updating fork of the installer script until https://github.com/dlang/installer/pull/301 is merged
    wget https://raw.githubusercontent.com/wilzbach/installer-dub/master/script/install.sh -O install.dub.sh
    bash install.dub.sh -a dub
    dub_path_activate="$(find $HOME/dlang/*/activate | head -1)"
    rm "${dub_path_activate}"
    dub_path="$(dirname "$dub_path_activate")"
    sudo ln -s "${dub_path}/dub" /usr/bin/dub

    export DMD=gdmd
    export DC=gdc
    # It's technically ~"2.076", but Ternary doesn't seem to have been ported and Vibe.d seems to depend on this.
    # Ternary was added in 2.072: https://dlang.org/phobos/std_typecons.html#.Ternary
    # However, the nonet tests is done only for > 2.072
    export FRONTEND=2.072

    sudo add-apt-repository -y ppa:ubuntu-toolchain-r/test
    sudo apt-get update
    sudo apt-get install -y gdc-9
    # fetch the dmd-like wrapper
    sudo wget https://raw.githubusercontent.com/D-Programming-GDC/GDMD/master/dmd-script -O /usr/bin/gdmd
    sudo chmod +x /usr/bin/gdmd
    # DUB requires gdmd
    sudo ln -s /usr/bin/gdc-9 /usr/bin/gdc
    # fake install script and create a fake 'activate' script
    mkdir -p ~/dlang/gdc-9
    echo "deactivate(){ echo;}" > ~/dlang/gdc-9/activate

else
    curl --connect-timeout 5 --max-time 10 --retry 5 --retry-delay 1 --retry-max-time 60 https://dlang.org/install.sh | bash -s "$D_VERSION"
fi

./travis-ci.sh
