/* The following code was generated by JFlex 1.2.2 on 12/7/13 8:44 PM */

/*******************************************************************************
 * Copyright (c) 2004, 2013 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/

package org.eclipse.wst.xml.core.internal.tasks;

import java.io.CharArrayReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.eclipse.wst.sse.core.internal.ltk.parser.BlockMarker;
import org.eclipse.wst.sse.core.internal.ltk.parser.BlockTokenizer;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.util.Debug;
import org.eclipse.wst.sse.core.utils.StringUtils;
import org.eclipse.wst.xml.core.internal.Logger;
import org.eclipse.wst.xml.core.internal.parser.IntStack;
import org.eclipse.wst.xml.core.internal.parser.regions.XMLParserRegionFactory;
import org.eclipse.wst.xml.core.internal.regions.DOMRegionContext;


/**
 * This class is a scanner generated by 
 * <a href="http://www.informatik.tu-muenchen.de/~kleing/jflex/">JFlex</a> 1.2.2
 * on 12/7/13 8:44 PM from the specification file
 * <tt>file:/Users/nitin/git/webtools.sourceediting/bundles/org.eclipse.wst.sse.core/DevTimeSupport/SedModel/HTMLTokenizer/devel/XMLLineTokenizer.jflex</tt>
 */
class XMLLineTokenizer implements BlockTokenizer, DOMRegionContext {

  /** this character denotes the end of file */
  final public static int YYEOF = -1;

  /** lexical states */
  final public static int ST_XML_DOCTYPE_EXTERNAL_ID = 19;
  final public static int ST_XML_ELEMENT_DECLARATION_CONTENT = 23;
  final public static int ST_XML_PI_TAG_CLOSE = 11;
  final public static int ST_XML_DECLARATION_CLOSE = 17;
  final public static int ST_XML_PI_ATTRIBUTE_VALUE = 10;
  final public static int ST_XML_TAG_NAME = 12;
  final public static int ST_XML_ATTRIBUTE_VALUE = 15;
  final public static int ST_XML_DOCTYPE_ID_SYSTEM = 21;
  final public static int ST_XML_ATTRIBUTE_NAME = 13;
  final public static int ST_XML_ELEMENT_DECLARATION = 22;
  final public static int ST_XML_DOCTYPE_DECLARATION = 18;
  final public static int ST_XML_ATTLIST_DECLARATION = 24;
  final public static int ST_XML_COMMENT_END = 4;
  final public static int ST_CDATA_TEXT = 1;
  final public static int ST_XML_COMMENT = 3;
  final public static int ST_PI_CONTENT = 7;
  final public static int ST_PI_WS = 6;
  final public static int ST_CDATA_END = 2;
  final public static int ST_XML_ATTLIST_DECLARATION_CONTENT = 25;
  final public static int ST_BLOCK_TAG_SCAN = 26;
  final public static int ST_XML_PI_EQUALS = 9;
  final public static int ST_XML_DECLARATION = 16;
  final public static int YYINITIAL = 0;
  final public static int ST_XML_DOCTYPE_ID_PUBLIC = 20;
  final public static int ST_XML_EQUALS = 14;
  final public static int ST_PI = 5;
  final public static int ST_XML_PI_ATTRIBUTE_NAME = 8;

  /** 
   * Translates characters to character classes
   */
  final private static String yycmap_packed = 
    "\11\0\1\5\1\22\2\0\1\14\22\0\1\14\1\21\1\11\1\54"+
    "\1\16\1\17\1\12\1\13\1\16\1\16\1\16\1\16\1\16\1\7"+
    "\1\6\1\3\12\15\1\10\1\60\1\1\1\44\1\2\1\4\1\16"+
    "\1\34\1\61\1\32\1\33\1\47\1\56\1\36\1\36\1\41\1\36"+
    "\1\36\1\27\1\25\1\43\1\42\1\46\1\36\1\36\1\55\1\35"+
    "\1\57\2\36\1\23\1\45\1\36\1\31\1\0\1\20\1\0\1\10"+
    "\1\0\1\51\1\61\1\62\1\52\1\37\1\56\1\36\1\65\1\41"+
    "\2\36\1\30\1\26\1\43\1\42\1\46\1\36\1\36\1\40\1\50"+
    "\1\57\1\36\1\36\1\24\1\53\1\36\1\0\1\0\72\0\1\64"+
    "\10\0\27\63\1\0\37\63\1\0\72\63\2\0\13\63\2\0\10\63"+
    "\1\0\65\63\1\0\104\63\11\0\44\63\3\0\2\63\4\0\36\63"+
    "\70\0\131\63\22\0\7\63\16\0\2\64\56\0\106\64\32\0\2\64"+
    "\44\0\1\63\1\64\3\63\1\0\1\63\1\0\24\63\1\0\54\63"+
    "\1\0\7\63\3\0\1\63\1\0\1\63\1\0\1\63\1\0\1\63"+
    "\1\0\22\63\15\0\14\63\1\0\102\63\1\0\14\63\1\0\44\63"+
    "\1\0\4\64\11\0\65\63\2\0\2\63\2\0\2\63\3\0\34\63"+
    "\2\0\10\63\2\0\2\63\67\0\46\63\2\0\1\63\7\0\46\63"+
    "\12\0\21\64\1\0\27\64\1\0\3\64\1\0\1\64\1\0\2\64"+
    "\1\0\1\64\13\0\33\63\5\0\3\63\56\0\32\63\5\0\1\64"+
    "\12\63\10\64\15\0\12\64\6\0\1\64\107\63\2\0\5\63\1\0"+
    "\17\63\1\0\4\63\1\0\1\63\17\64\2\63\2\64\1\0\4\64"+
    "\2\0\12\64\u0207\0\3\64\1\0\65\63\2\0\1\64\1\63\20\64"+
    "\3\0\4\64\3\0\12\63\2\64\2\0\12\64\21\0\3\64\1\0"+
    "\10\63\2\0\2\63\2\0\26\63\1\0\7\63\1\0\1\63\3\0"+
    "\4\63\2\0\1\64\1\0\7\64\2\0\2\64\2\0\3\64\11\0"+
    "\1\64\4\0\2\63\1\0\3\63\2\64\2\0\12\64\2\63\20\0"+
    "\1\64\2\0\6\63\4\0\2\63\2\0\26\63\1\0\7\63\1\0"+
    "\2\63\1\0\2\63\1\0\2\63\2\0\1\64\1\0\5\64\4\0"+
    "\2\64\2\0\3\64\13\0\4\63\1\0\1\63\7\0\12\64\2\64"+
    "\3\63\14\0\3\64\1\0\7\63\1\0\1\63\1\0\3\63\1\0"+
    "\26\63\1\0\7\63\1\0\2\63\1\0\5\63\2\0\1\64\1\63"+
    "\10\64\1\0\3\64\1\0\3\64\22\0\1\63\5\0\12\64\21\0"+
    "\3\64\1\0\10\63\2\0\2\63\2\0\26\63\1\0\7\63\1\0"+
    "\2\63\2\0\4\63\2\0\1\64\1\63\6\64\3\0\2\64\2\0"+
    "\3\64\10\0\2\64\4\0\2\63\1\0\3\63\4\0\12\64\22\0"+
    "\2\64\1\0\6\63\3\0\3\63\1\0\4\63\3\0\2\63\1\0"+
    "\1\63\1\0\2\63\3\0\2\63\3\0\3\63\3\0\10\63\1\0"+
    "\3\63\4\0\5\64\3\0\3\64\1\0\4\64\11\0\1\64\17\0"+
    "\11\64\21\0\3\64\1\0\10\63\1\0\3\63\1\0\27\63\1\0"+
    "\12\63\1\0\5\63\4\0\7\64\1\0\3\64\1\0\4\64\7\0"+
    "\2\64\11\0\2\63\4\0\12\64\22\0\2\64\1\0\10\63\1\0"+
    "\3\63\1\0\27\63\1\0\12\63\1\0\5\63\4\0\7\64\1\0"+
    "\3\64\1\0\4\64\7\0\2\64\7\0\1\63\1\0\2\63\4\0"+
    "\12\64\22\0\2\64\1\0\10\63\1\0\3\63\1\0\27\63\1\0"+
    "\20\63\4\0\6\64\2\0\3\64\1\0\4\64\11\0\1\64\10\0"+
    "\2\63\4\0\12\64\221\0\56\63\1\0\1\63\1\64\2\63\7\64"+
    "\5\0\6\63\1\64\10\64\1\0\12\64\47\0\2\63\1\0\1\63"+
    "\2\0\2\63\1\0\1\63\2\0\1\63\6\0\4\63\1\0\7\63"+
    "\1\0\3\63\1\0\1\63\1\0\1\63\2\0\2\63\1\0\2\63"+
    "\1\0\1\63\1\64\2\63\6\64\1\0\2\64\1\63\2\0\5\63"+
    "\1\0\1\64\1\0\6\64\2\0\12\64\76\0\2\64\6\0\12\64"+
    "\13\0\1\64\1\0\1\64\1\0\1\64\4\0\2\64\10\63\1\0"+
    "\41\63\7\0\24\64\1\0\6\64\4\0\6\64\1\0\1\64\1\0"+
    "\25\64\3\0\7\64\1\0\1\64\346\0\46\63\12\0\47\63\11\0"+
    "\1\63\1\0\2\63\1\0\3\63\1\0\1\63\1\0\2\63\1\0"+
    "\5\63\51\0\1\63\1\0\1\63\1\0\1\63\13\0\1\63\1\0"+
    "\1\63\1\0\1\63\3\0\2\63\3\0\1\63\5\0\3\63\1\0"+
    "\1\63\1\0\1\63\1\0\1\63\1\0\1\63\3\0\2\63\3\0"+
    "\2\63\1\0\1\63\50\0\1\63\11\0\1\63\2\0\1\63\2\0"+
    "\2\63\7\0\2\63\1\0\1\63\1\0\7\63\50\0\1\63\4\0"+
    "\1\63\10\0\1\63\u0c06\0\234\63\4\0\132\63\6\0\26\63\2\0"+
    "\6\63\2\0\46\63\2\0\6\63\2\0\10\63\1\0\1\63\1\0"+
    "\1\63\1\0\1\63\1\0\37\63\2\0\65\63\1\0\7\63\1\0"+
    "\1\63\3\0\3\63\1\0\7\63\3\0\4\63\2\0\6\63\4\0"+
    "\15\63\5\0\3\63\1\0\7\63\323\0\15\64\4\0\1\64\104\0"+
    "\1\63\3\0\2\63\2\0\1\63\121\0\3\63\u0e82\0\1\64\1\0"+
    "\1\63\31\0\11\63\6\64\1\0\5\64\13\0\124\63\4\0\2\64"+
    "\2\0\2\64\2\0\132\63\1\0\3\64\6\0\50\63\u1cd3\0\u51a6\63"+
    "\u0c5a\0\u2ba4\63\134\0\u0800\0\u1ffe\0\2\0";

  /** 
   * Translates characters to character classes
   */
  final private static char [] yycmap = yy_unpack_cmap(yycmap_packed);

  /** 
   * Translates a state to a row index in the transition table
   */
  final private static int yy_rowMap [] = { 
        0,    54,   108,   162,   216,   270,   324,   378,   432,   486, 
      540,   594,   648,   702,   756,   810,   864,   918,   972,  1026, 
     1080,  1134,  1188,  1242,  1296,  1350,  1404,  1458,  1512,  1566, 
     1620,  1674,  1728,  1674,  1728,  1782,  1674,  1674,  1728,  1836, 
     1890,  1944,  1998,  2052,  2106,  2160,  1674,  1728,  2214,  2268, 
     2322,  1674,  2376,  2376,  2430,  2484,  2538,  2214,  2592,  2646, 
     1674,  2700,  2754,  2808,  2862,  1674,  2916,  2970,  3024,  3078, 
     3132,  1674,  3186,  3240,  3294,  3348,  3402,  3456,  3510,  3564, 
     3564,  3618,  3672,  3726,  3780,  3780,  3834,  3888,  3942,  3996, 
     3996,  4050,  4104,  4158,  4212,  1674,  4266,  4266,  4320,  4374, 
     4428,  4482,  1674,  1674,  1728,  1674,  1674,  4536,  4590,  4644, 
     4698,  4752,  4806,  4860,  4914,  4968,  1674,  5022,  5076,  1674, 
     1674,  2376,  5130,  2484,  1674,  5184,  2538,  1674,  2916,  5238, 
     3024,  1674,  5292,  3078,  4536,  5346,  5400,  5454,  3348,  1674, 
     5508,  5562,  3564,  5616,  3618,  1674,  5670,  5724,  5778,  5778, 
     5832,  5886,  3726,  3564,  3780,  5940,  3834,  1674,  5994,  3888, 
     3942,  3780,  3996,  6048,  4050,  1674,  6102,  6156,  6210,  6210, 
     6264,  6318,  6372,  4266,  6426,  4320,  1674,  6480,  6534,  6588, 
     6588,  6642,  6696,  6750,  6804,  6858,  6912,  6966,  1674,  7020, 
     7074,  1674,  1674,  1674,  1998,  7128,  7182,  7236,  7290,  7344, 
     7398,  5670,  7452,  7452,  6102,  7506,  7506,  7560,  6480,  7614, 
     7614,  7668,  1674,  7722,  7776,  7830,  1674,  7884,  7938,  7992, 
     8046,  8100,  8154,  8208,  5832,  6264,  8262,  6642,  8316,  8370, 
     8424,  1674,  8478,  8532,  8586,  8640,  8694,  8748,  8802,  8856, 
     8910,  8964,  9018,  9072,  9126,  1674,  1674,  9180,  9234,  9288, 
     9342,  1674,  1674,  1674,  9396,  9450,  9504,  9558,  9612,  9666, 
     1674,  9720,  4158,  4428,  9774,  9828,  9882,  9936,  1998
  };

  /** 
   * The packed transition table of the DFA
   */
  final private static String yy_packed = 
    "\1\34\1\35\10\34\1\36\4\34\1\37\46\34\1\40"+
    "\1\41\64\40\1\42\1\43\16\42\1\44\1\42\1\45"+
    "\43\42\1\46\1\47\64\46\1\42\1\43\5\42\1\50"+
    "\12\42\1\45\44\42\1\43\2\42\1\51\1\52\2\42"+
    "\1\53\3\42\1\52\5\42\1\52\1\54\1\55\4\53"+
    "\1\42\12\53\1\42\7\53\1\42\3\53\1\42\3\53"+
    "\1\42\1\53\1\42\1\43\2\42\1\51\1\56\6\42"+
    "\1\56\5\42\1\56\43\42\1\57\1\60\2\57\1\61"+
    "\15\57\1\45\43\57\1\42\1\43\2\42\1\62\1\52"+
    "\2\42\1\63\3\42\1\52\5\42\1\52\6\63\1\42"+
    "\12\63\1\42\7\63\1\42\3\63\1\42\3\63\1\42"+
    "\1\63\1\42\1\43\2\42\1\62\1\52\2\42\1\63"+
    "\3\42\1\52\5\42\1\52\6\63\1\42\12\63\1\64"+
    "\7\63\1\42\3\63\1\42\3\63\1\42\1\63\1\65"+
    "\1\43\1\42\1\66\1\67\1\52\3\65\1\70\1\65"+
    "\1\71\1\52\5\65\1\52\43\65\1\42\1\43\2\42"+
    "\1\72\15\42\1\45\43\42\1\73\1\74\1\75\1\76"+
    "\4\73\1\77\12\73\6\100\1\73\12\100\1\73\7\100"+
    "\1\73\3\100\1\73\3\100\1\73\1\100\1\42\1\74"+
    "\1\75\1\76\1\42\1\52\2\42\1\101\3\42\1\52"+
    "\5\42\1\52\6\101\1\42\12\101\1\42\7\101\1\42"+
    "\3\101\1\42\3\101\1\42\1\101\1\42\1\74\1\75"+
    "\1\76\1\42\1\52\2\42\1\101\3\42\1\52\5\42"+
    "\1\52\6\101\1\42\12\101\1\102\7\101\1\42\3\101"+
    "\1\42\3\101\1\42\1\101\1\103\1\74\1\75\1\104"+
    "\1\103\1\52\3\103\1\105\1\103\1\106\1\52\5\103"+
    "\1\52\43\103\1\42\1\107\1\110\2\42\1\52\6\42"+
    "\1\52\5\42\1\52\10\42\1\111\1\112\2\42\1\113"+
    "\7\42\1\113\1\42\1\112\1\111\14\42\1\43\1\110"+
    "\2\42\1\52\6\42\1\52\5\42\1\52\6\42\1\114"+
    "\35\42\1\43\1\110\2\42\1\52\2\42\1\115\3\42"+
    "\1\52\5\42\1\52\6\115\1\114\12\115\1\42\7\115"+
    "\1\42\3\115\1\42\3\115\1\42\1\115\1\42\1\43"+
    "\1\110\2\42\1\52\6\42\1\52\5\42\1\52\6\42"+
    "\1\114\6\42\1\116\5\42\1\117\6\42\1\116\10\42"+
    "\1\120\1\43\1\110\1\121\1\120\1\52\3\120\1\122"+
    "\1\120\1\123\1\52\5\120\1\52\6\120\1\124\34\120"+
    "\1\125\1\43\1\110\1\126\1\125\1\52\3\125\1\127"+
    "\1\125\1\130\1\52\5\125\1\52\6\125\1\131\34\125"+
    "\1\132\1\43\1\110\1\133\1\132\1\52\3\132\1\134"+
    "\1\132\1\135\1\52\5\132\1\52\43\132\1\136\1\137"+
    "\1\140\63\136\1\141\1\43\1\110\1\142\1\141\1\52"+
    "\3\141\1\143\1\141\1\144\1\52\5\141\1\52\43\141"+
    "\1\145\1\146\1\147\63\145\1\150\1\151\64\150\1\34"+
    "\1\0\10\34\1\0\4\34\1\0\46\34\3\0\1\152"+
    "\1\153\14\0\1\154\51\0\1\155\2\0\1\156\3\0"+
    "\1\155\5\0\1\155\6\156\1\0\12\156\1\0\7\156"+
    "\1\157\3\156\1\0\3\156\1\0\1\156\5\0\1\155"+
    "\2\0\1\160\3\0\1\155\2\0\1\161\2\0\1\155"+
    "\6\160\1\0\12\160\1\0\7\160\1\0\3\160\1\0"+
    "\3\160\1\0\1\160\107\0\1\162\64\0\1\163\54\0"+
    "\1\164\60\0\1\165\70\0\1\52\6\0\1\52\5\0"+
    "\1\52\51\0\3\53\4\0\1\53\5\0\6\53\1\0"+
    "\12\53\1\0\7\53\1\0\3\53\1\0\5\53\6\0"+
    "\3\53\4\0\1\53\5\0\2\53\2\166\2\53\1\0"+
    "\12\53\1\0\7\53\1\0\3\53\1\0\5\53\6\0"+
    "\3\53\4\0\1\53\5\0\2\53\1\166\1\167\2\53"+
    "\1\0\12\53\1\0\7\53\1\0\3\53\1\0\5\53"+
    "\5\0\1\56\6\0\1\56\5\0\1\56\45\0\1\170"+
    "\65\0\1\171\71\0\3\63\4\0\1\63\5\0\6\63"+
    "\1\0\12\63\1\0\7\63\1\0\3\63\1\0\5\63"+
    "\1\65\2\0\1\172\1\65\1\0\3\65\1\0\1\65"+
    "\2\0\5\65\1\0\44\65\1\0\1\171\1\172\1\65"+
    "\1\0\3\65\1\0\1\65\2\0\5\65\1\0\43\65"+
    "\1\70\2\173\1\174\1\70\1\173\3\70\1\175\1\70"+
    "\2\173\5\70\1\173\43\70\1\71\2\176\1\177\1\71"+
    "\1\176\3\71\1\176\1\71\1\175\1\176\5\71\1\176"+
    "\43\71\1\73\3\0\17\73\6\0\1\73\12\0\1\73"+
    "\7\0\1\73\3\0\1\73\3\0\1\73\4\0\1\152"+
    "\15\0\1\154\46\0\1\200\63\0\1\73\3\0\2\73"+
    "\3\77\4\73\1\77\5\73\6\100\1\73\12\100\1\73"+
    "\7\100\1\73\3\100\1\73\3\100\1\77\1\100\6\0"+
    "\3\100\4\0\1\100\5\0\6\100\1\0\12\100\1\0"+
    "\7\100\1\0\3\100\1\0\5\100\6\0\3\101\4\0"+
    "\1\101\5\0\6\101\1\0\12\101\1\0\7\101\1\0"+
    "\3\101\1\0\5\101\1\103\2\0\1\201\1\103\1\0"+
    "\3\103\1\0\1\103\2\0\5\103\1\0\44\103\1\0"+
    "\1\200\1\201\1\103\1\0\3\103\1\0\1\103\2\0"+
    "\5\103\1\0\43\103\1\105\2\202\1\203\1\105\1\202"+
    "\3\105\1\204\1\105\2\202\5\105\1\202\43\105\1\106"+
    "\2\205\1\206\1\106\1\205\3\106\1\205\1\106\1\204"+
    "\1\205\5\106\1\205\43\106\3\0\1\152\15\0\1\207"+
    "\106\0\1\210\60\0\1\211\12\0\1\211\44\0\2\212"+
    "\35\0\20\213\1\214\45\213\6\0\3\115\4\0\1\115"+
    "\5\0\6\115\1\0\12\115\1\0\7\115\1\0\3\115"+
    "\1\0\5\115\45\0\1\215\5\0\1\215\71\0\1\216"+
    "\6\0\1\120\2\0\1\217\1\120\1\0\3\120\1\0"+
    "\1\120\2\0\5\120\1\0\43\120\1\122\2\220\1\221"+
    "\1\122\1\220\3\122\1\222\1\122\2\220\5\122\1\220"+
    "\43\122\1\223\2\224\1\225\1\226\1\224\3\226\1\224"+
    "\1\223\1\227\1\230\3\226\1\223\1\226\1\230\6\226"+
    "\1\223\31\226\2\223\1\226\1\124\2\213\1\231\1\124"+
    "\1\213\3\124\1\213\1\124\2\213\3\124\1\232\1\124"+
    "\1\213\43\124\1\125\2\0\1\233\1\125\1\0\3\125"+
    "\1\0\1\125\2\0\5\125\1\0\43\125\1\127\2\234"+
    "\1\235\1\127\1\234\3\127\1\236\1\127\2\234\5\127"+
    "\1\234\43\127\1\130\2\237\1\240\1\130\1\237\3\130"+
    "\1\237\1\130\1\236\1\237\5\130\1\237\43\130\1\131"+
    "\2\213\1\241\1\131\1\213\3\131\1\213\1\131\2\213"+
    "\3\131\1\242\1\131\1\213\43\131\1\132\2\0\1\243"+
    "\1\132\1\0\3\132\1\0\1\132\2\0\5\132\1\0"+
    "\43\132\1\134\2\244\1\245\1\134\1\244\3\134\1\246"+
    "\1\134\2\244\5\134\1\244\43\134\1\247\2\250\1\251"+
    "\1\252\1\250\3\252\1\250\1\247\1\253\1\254\3\252"+
    "\1\247\1\252\1\254\6\252\1\247\31\252\2\247\1\252"+
    "\2\136\1\0\65\136\1\0\16\136\1\255\44\136\1\141"+
    "\2\0\1\256\1\141\1\0\3\141\1\0\1\141\2\0"+
    "\5\141\1\0\43\141\1\143\2\257\1\260\1\143\1\257"+
    "\3\143\1\261\1\143\2\257\5\143\1\257\43\143\1\262"+
    "\2\263\1\264\1\265\1\263\3\265\1\263\1\262\1\266"+
    "\1\267\3\265\1\262\1\265\1\267\6\265\1\262\31\265"+
    "\2\262\1\265\2\145\1\0\65\145\1\0\16\145\1\270"+
    "\44\145\7\0\1\271\21\0\1\272\41\0\1\155\2\0"+
    "\1\34\3\0\1\155\5\0\1\155\6\34\1\0\12\34"+
    "\1\0\7\34\1\0\3\34\1\0\3\34\1\0\1\34"+
    "\1\273\1\0\3\273\1\274\3\156\1\273\1\0\1\273"+
    "\1\274\1\156\1\273\1\0\2\273\1\274\6\156\1\273"+
    "\12\156\1\273\7\156\1\273\3\156\1\275\5\156\15\0"+
    "\1\276\6\0\1\277\41\0\1\273\1\0\3\273\1\274"+
    "\3\160\1\273\1\0\1\273\1\274\1\160\1\273\1\0"+
    "\2\273\1\274\6\160\1\273\12\160\1\273\7\160\1\273"+
    "\3\160\1\300\5\160\17\0\1\161\77\0\1\272\36\0"+
    "\1\301\65\0\1\302\71\0\3\53\4\0\1\53\5\0"+
    "\4\53\2\303\1\0\12\53\1\0\7\53\1\0\3\53"+
    "\1\0\5\53\6\0\3\53\4\0\1\53\5\0\4\53"+
    "\1\303\1\304\1\0\12\53\1\0\7\53\1\0\3\53"+
    "\1\0\5\53\11\173\1\175\54\173\13\176\1\175\52\176"+
    "\11\202\1\204\54\202\13\205\1\204\52\205\32\0\1\305"+
    "\27\0\1\305\40\0\1\306\12\0\1\306\54\0\1\307"+
    "\7\0\1\307\56\0\1\310\14\0\1\310\71\0\1\311"+
    "\4\0\11\220\1\222\54\220\1\223\2\224\1\312\1\223"+
    "\1\224\3\223\1\224\1\223\1\222\1\224\5\223\1\224"+
    "\43\223\13\224\1\222\52\224\1\223\2\224\1\312\1\223"+
    "\1\224\3\223\1\224\1\223\1\313\1\224\5\223\1\224"+
    "\43\223\13\0\1\314\52\0\13\224\1\313\52\224\11\234"+
    "\1\236\54\234\13\237\1\236\52\237\11\244\1\246\54\244"+
    "\1\247\2\250\1\315\1\247\1\250\3\247\1\250\1\247"+
    "\1\246\1\250\5\247\1\250\43\247\13\250\1\246\52\250"+
    "\1\247\2\250\1\315\1\247\1\250\3\247\1\250\1\247"+
    "\1\316\1\250\5\247\1\250\43\247\13\0\1\317\52\0"+
    "\13\250\1\316\52\250\2\136\1\0\26\136\1\320\34\136"+
    "\11\257\1\261\54\257\1\262\2\263\1\321\1\262\1\263"+
    "\3\262\1\263\1\262\1\261\1\263\5\262\1\263\43\262"+
    "\13\263\1\261\52\263\1\262\2\263\1\321\1\262\1\263"+
    "\3\262\1\263\1\262\1\322\1\263\5\262\1\263\43\262"+
    "\13\0\1\323\52\0\13\263\1\322\52\263\2\145\1\0"+
    "\26\145\1\324\34\145\7\0\1\325\110\0\1\326\33\0"+
    "\1\273\1\0\10\273\1\0\4\273\1\0\40\273\1\0"+
    "\6\273\1\0\3\273\1\274\2\273\1\327\1\273\1\0"+
    "\1\273\1\274\2\273\1\0\2\273\1\274\6\327\1\273"+
    "\12\327\1\273\7\327\1\273\3\327\1\330\3\327\1\273"+
    "\1\327\15\0\1\276\42\0\1\331\22\0\1\332\14\0"+
    "\3\332\2\0\1\332\7\0\1\332\1\0\2\332\3\0"+
    "\1\332\2\0\2\332\11\0\1\53\1\333\1\53\4\0"+
    "\1\53\5\0\6\53\1\0\12\53\1\0\7\53\1\0"+
    "\3\53\1\0\5\53\35\0\1\334\12\0\1\334\44\0"+
    "\2\335\62\0\2\336\74\0\1\337\12\0\1\337\44\0"+
    "\2\340\40\0\2\341\1\0\3\341\2\0\1\227\4\341"+
    "\1\0\10\341\1\0\31\341\2\0\1\341\3\0\2\342"+
    "\1\0\3\342\2\0\1\253\4\342\1\0\10\342\1\0"+
    "\31\342\2\0\1\342\2\136\1\0\27\136\1\343\33\136"+
    "\3\0\2\344\1\0\3\344\2\0\1\266\4\344\1\0"+
    "\10\344\1\0\31\344\2\0\1\344\2\145\1\0\27\145"+
    "\1\345\33\145\33\0\1\346\32\0\1\273\1\0\3\273"+
    "\1\347\3\327\1\273\1\0\1\273\1\347\1\327\1\273"+
    "\1\0\2\273\1\347\6\327\1\273\12\327\1\273\7\327"+
    "\1\273\3\327\1\350\5\327\60\0\1\330\22\0\1\332"+
    "\14\0\3\332\2\0\1\332\7\0\1\332\1\0\2\332"+
    "\3\0\1\332\1\0\1\331\2\332\11\0\3\53\4\0"+
    "\1\53\5\0\6\53\1\0\6\53\1\351\3\53\1\0"+
    "\7\53\1\0\3\53\1\0\5\53\45\0\1\352\5\0"+
    "\1\352\53\0\1\353\63\0\1\354\7\0\1\354\55\0"+
    "\1\355\7\0\1\355\57\0\1\356\24\0\2\136\1\0"+
    "\30\136\1\357\32\136\2\145\1\0\30\145\1\360\32\145"+
    "\34\0\1\361\31\0\1\273\1\0\3\273\1\347\2\273"+
    "\1\327\1\273\1\0\1\273\1\347\2\273\1\0\2\273"+
    "\1\347\6\327\1\273\12\327\1\273\7\327\1\273\3\327"+
    "\1\0\3\327\1\273\1\327\6\0\3\53\4\0\1\53"+
    "\5\0\6\53\1\0\12\53\1\0\3\53\1\362\3\53"+
    "\1\0\3\53\1\0\5\53\46\0\1\363\57\0\1\364"+
    "\14\0\1\364\53\0\1\365\47\0\2\366\71\0\1\367"+
    "\27\0\1\367\3\0\2\136\1\0\31\136\1\370\31\136"+
    "\2\145\1\0\31\145\1\371\31\145\35\0\1\372\36\0"+
    "\3\53\4\0\1\53\5\0\6\53\1\0\12\53\1\0"+
    "\6\53\1\373\1\0\3\53\1\0\5\53\37\0\1\374"+
    "\7\0\1\374\53\0\1\375\12\0\1\375\52\0\1\376"+
    "\12\0\1\376\15\0\2\136\1\0\32\136\1\377\30\136"+
    "\2\145\1\0\32\145\1\u0100\30\145\34\0\1\u0101\37\0"+
    "\3\53\4\0\1\53\5\0\5\53\1\u0102\1\0\12\53"+
    "\1\0\7\53\1\0\3\53\1\0\5\53\2\136\1\0"+
    "\31\136\1\u0103\31\136\2\145\1\0\31\145\1\u0104\31\145"+
    "\31\0\1\u0105\42\0\3\53\4\0\1\53\5\0\6\53"+
    "\1\0\5\53\1\u0106\4\53\1\0\7\53\1\0\3\53"+
    "\1\0\5\53\2\136\1\0\26\136\1\u0107\34\136\2\145"+
    "\1\0\26\145\1\u0108\34\145\6\0\3\53\4\0\1\53"+
    "\5\0\6\53\1\0\6\53\1\u0109\3\53\1\0\7\53"+
    "\1\0\3\53\1\0\5\53\6\0\3\53\4\0\1\53"+
    "\5\0\6\53\1\0\12\53\1\0\7\53\1\0\3\53"+
    "\1\0\4\53\1\u010a\6\0\3\53\4\0\1\53\5\0"+
    "\6\53\1\0\5\53\1\u010b\4\53\1\0\7\53\1\0"+
    "\3\53\1\0\5\53\6\0\3\53\4\0\1\53\5\0"+
    "\6\53\1\0\5\53\1\u010c\4\53\1\0\7\53\1\0"+
    "\3\53\1\0\5\53\6\0\3\53\4\0\1\53\5\0"+
    "\6\53\1\0\12\53\1\0\3\53\1\u010d\3\53\1\0"+
    "\3\53\1\0\5\53";

  /** 
   * The transition table of the DFA
   */
  final private static int yytrans [] = yy_unpack(yy_packed);


  /* error codes */
  final private static int YY_UNKNOWN_ERROR = 0;
  // final private static int YY_ILLEGAL_STATE = 1;
  final private static int YY_NO_MATCH = 2;
  final private static int YY_PUSHBACK_2BIG = 3;

  /* error messages for the codes above */
  final private static String YY_ERROR_MSG[] = {
    "Unkown internal scanner error",		//$NON-NLS-1$
    "Internal error: unknown state",		//$NON-NLS-1$
    "Error: could not match input",		//$NON-NLS-1$
    "Error: pushback value was too large"	//$NON-NLS-1$
  };

  /**
   * YY_ATTRIBUTE[aState] contains the attributes of state <code>aState</code>
   */
  private final static byte YY_ATTRIBUTE[] = {
     1,  0,  0,  0,  0,  1,  0,  0,  1,  1,  1,  0,  1,  1,  1,  1, 
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  0,  1,  1,  1,  1,  9, 
     1,  9,  1,  1,  9,  9,  1,  1,  1,  1,  1,  1,  1,  1,  9,  1, 
     1,  1,  1,  9,  1,  1,  1,  1,  1,  1,  1,  1,  9,  1,  1,  1, 
     1,  9,  1,  1,  1,  1,  1,  9,  1,  1,  1,  1,  1,  1,  1,  1, 
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  9, 
     1,  1,  1,  1,  1,  1,  9,  9,  1,  9,  9,  1,  0,  1,  0,  1, 
     1,  0,  0,  0,  9,  1,  1,  9,  9,  0,  0,  0,  9,  0,  0,  9, 
     0,  0,  0,  9,  0,  0,  0,  0,  0,  0,  0,  9,  0,  0,  0,  0, 
     0,  9,  1,  0,  0,  1,  1,  0,  0,  1,  0,  0,  0,  9,  0,  0, 
     0,  1,  0,  0,  0,  9,  1,  0,  0,  1,  1,  0,  1,  0,  0,  0, 
     9,  1,  0,  0,  1,  1,  0,  1,  0,  0,  1,  1,  9,  0,  0,  9, 
     9,  9,  1,  1,  0,  0,  0,  0,  0,  0,  1,  0,  0,  1,  0,  1, 
     0,  1,  0,  1,  9,  0,  1,  1,  9,  0,  1,  0,  0,  0,  0,  0, 
     0,  0,  1,  0,  1,  0,  1,  9,  1,  0,  0,  0,  0,  0,  1,  1, 
     0,  1,  0,  0,  0,  9,  9,  1,  1,  0,  1,  9,  9,  9,  1,  1, 
     0,  1,  1,  1,  9,  1,  1,  1,  1,  1,  1,  1,  1
  };

  /** the input device */
  private java.io.Reader yy_reader;

  /** the current state of the DFA */
  private int yy_state;

  /** the current lexical state */
  private int yy_lexical_state = YYINITIAL;

  /** this buffer contains the current text to be matched and is
      the source of the yytext() string */
  private char yy_buffer[] = new char[16384];

  /** the textposition at the last accepting state */
  private int yy_markedPos;

  /** the textposition at the last state to be included in yytext */
  int yy_pushbackPos;

  /** the current text position in the buffer */
  private int yy_currentPos;

  /** startRead marks the beginning of the yytext() string in the buffer */
  private int yy_startRead;

  /** endRead marks the last character in the buffer, that has been read
      from input */
  private int yy_endRead;

  /** number of newlines encountered up to the start of the matched text */
  int yyline;

  /** the number of characters up to the start of the matched text */
  private int yychar;

  /**
   * the number of characters from the last newline up to the start of the 
   * matched text
   */
  // private int yycolumn; 

  /** 
   * yy_atBOL == true <=> the scanner is currently at the beginning of a line
   */
  // private boolean yy_atBOL;

  /** yy_atEOF == true <=> the scanner has returned a value for EOF */
  private boolean yy_atEOF;

  /** denotes if the user-EOF-code has already been executed */
  private boolean yy_eof_done;

  /* user code: */
	private int fTokenCount = 0;
 
	// required holders for white-space compacting
	private boolean fShouldLoadBuffered = false;
	private String fBufferedContext = null;
	private int fBufferedStart = 1;
	private int fBufferedLength = 0;
	private String f_context = null;

	// state stack for handling embedded regions
	private IntStack fStateStack = new IntStack();

	private String context = null;
	private int start = 0;
	private int textLength = 0;
	private int length = 0;

	// offset for tracking position specific block tags
	private int fOffset = 0;
	
	// the name of the current tag being opened
	private String fCurrentTagName = null;

	// the list of tag name BlockMarkers
	private List fBlockMarkers = new ArrayList();

	// required to not seek text blocks on an end tag
	private boolean fIsBlockingEnabled = false;
	private boolean fIsCaseSensitiveBlocking = true;

	private XMLParserRegionFactory fRegionFactory = new XMLParserRegionFactory();
/**
 * user method 
 */
public final void addBlockMarker(BlockMarker marker) {
	if(containsTagName(marker.getTagName()))
		return;
	fBlockMarkers.add(marker);
}
/**
 * user method 
 */
public final void removeBlockMarker(BlockMarker marker) {
	fBlockMarkers.remove(marker);
}
/**
 * user method 
 */
public final void removeBlockMarker(String tagname) {
	if (fBlockMarkers != null) {
		Iterator blocks = fBlockMarkers.iterator();
		while (blocks.hasNext()) {
			if (((BlockMarker) blocks.next()).getTagName().equals(tagname))
				blocks.remove();
		}
	}
}
/* user method */
public final boolean isCaseSensitiveBlocking() {
	return fIsCaseSensitiveBlocking;
}
/* user method */
public final void setCaseSensitiveBlocking(boolean newValue) {
	fIsCaseSensitiveBlocking = newValue;
}
/* user method */
public boolean getBlockMarkerCaseSensitivity() {
        return getBlockMarkerCaseSensitivity(fCurrentTagName);
}
/* user method */
public boolean getBlockMarkerCaseSensitivity(String name) {
	Iterator iterator = fBlockMarkers.iterator();
	while(iterator.hasNext()) {
		BlockMarker marker = (BlockMarker)iterator.next();
		boolean casesensitive = marker.isCaseSensitive();
		if(casesensitive && marker.getTagName().equals(name))
			return casesensitive;
		else if(!casesensitive && marker.getTagName().equalsIgnoreCase(name))
			return casesensitive;
	}
	return true;
}
/* user method */
public String getBlockMarkerContext() {
	return getBlockMarkerContext(fCurrentTagName);
}
/* user method */
public String getBlockMarkerContext(String name) {
	Iterator iterator = fBlockMarkers.iterator();
	while(iterator.hasNext()) {
		BlockMarker marker = (BlockMarker)iterator.next();
		if(marker.getTagName().equals(name))
			return marker.getContext();
	}
	return BLOCK_TEXT;
}
/* user method */
public List getBlockMarkers() {
	return fBlockMarkers;
}
/* user method */
public final int getOffset() {
	return fOffset + yychar;
}
private final boolean isBlockMarker() {
	return isBlockMarker(fCurrentTagName);
}
private final boolean isBlockMarker(String tagName) {
	if (!fIsBlockingEnabled)
		return false;
	return containsTagName(tagName);
}
/**
 * user method
 */
public final void beginBlockTagScan(String newTagName) {
	beginBlockMarkerScan(newTagName, BLOCK_TEXT);
}
/**
 * user method
 *
 * Special tokenizer setup.  Allows tokenization to be initiated at the
 * start of a text block within a "newTagName" tag.
 *
 * Example: 
 *	Tokenizer toker = new Tokenizer();
 *	toker.setCaseSensitiveBlocking(false);
 *	toker.reset(new java.io.StringReader("afiuhqwkejhtasihgalkwhtq</scripter></scr></script>asgdasga"));
 *	toker.beginBlockMarkerScan("script", BLOCK_TEXT);
 *	toker.getRegions(); 
 *
 * Returns:
 *	BLOCK_TEXT: 0-40
 *	XML_END_TAG_OPEN: 41-42
 *	XML_TAG_NAME: 43-48
 *	XML_TAG_CLOSE: 49-49
 *	XML_CONTENT: 50-57
 *
 */
public final void beginBlockMarkerScan(String newTagName, String blockcontext) {
	yybegin(ST_BLOCK_TAG_SCAN);
	fCurrentTagName = newTagName;
}
/**
 * Method doScan.
 * 
 * Returns a context region for all of the text from the current position upto the end of input or
 * to right *before* the first occurence of searchString
 * 
 * @param searchString - target string to search for ex.: "-->", "</tagname"
 * @param requireTailSeparator - whether the target must be immediately followed by whitespace or '>'
 * @param context - the context of the scanned region if non-zero length
 * @param exitState - the state to go to if the region was of non-zero length
 * @param abortState - the state to go to if the searchString was found immediately
 * @return String - the context found: the desired context on a non-zero length match, the abortContext on immediate success
 * @throws IOException
 */
private final String doScan(String searchString, boolean requireTailSeparator, String searchContext, int exitState, int immediateFallbackState) throws IOException {
	boolean stillSearching = true;
	// Disable further block (probably)
	fIsBlockingEnabled = false;
	int searchStringLength = searchString.length();
	int n = 0;
	char lastCheckChar;
	int i;
	boolean same = false;
	while (stillSearching) {
		n = 0;
		// Ensure that enough data from the input exists to compare against the search String.
		n = yy_advance();
		while(n != YYEOF && yy_currentPos < searchStringLength)
			n = yy_advance();
		// If the input was too short or we've exhausted the input, stop immediately.
		if (n == YYEOF) {
			stillSearching = false;
		}
		else {
			same = true;
			// Ensure that we've not encountered a complete block (<%%>) that was *shorter* than the closeTagString and
			// thus found twice at current-targetLength [since the first scan would have come out this far anyway].
			// Check the characters in the target versus the last targetLength characters read from the buffer
			// and see if it matches
			
			// safety check for array accesses (yy_currentPos is the *last* character we can check against)
			if(yy_currentPos >= searchStringLength && yy_currentPos <= yy_buffer.length) {
				for(i = 0; i < searchStringLength; i++) {
					if(same && fIsCaseSensitiveBlocking)
						same = yy_buffer[i + yy_currentPos - searchStringLength] == searchString.charAt(i);
					else if(same && !fIsCaseSensitiveBlocking)
						same = Character.toLowerCase(yy_buffer[i + yy_currentPos - searchStringLength]) == Character.toLowerCase(searchString.charAt(i));
				}
			}
			// safety check failed; no match is possible right now
			else {
				same = false;
			}
			if (same && requireTailSeparator && yy_currentPos < yy_buffer.length) {
				// Additional check for close tags to ensure that targetString="</script" doesn't match
				// "</scriptS"
				lastCheckChar = yy_buffer[yy_currentPos];
				// Succeed on "</script>" and "</script "
				if(lastCheckChar == '>' || Character.isWhitespace(lastCheckChar))
					stillSearching = false;
			}
			else {
				stillSearching = !same || (yy_currentPos < yy_startRead + searchStringLength);
			}
		}
	}
	if (n != YYEOF || same) {
		// We've stopped short of the end or definitely found a match
		yy_markedPos = yy_currentPos - searchStringLength;
		yy_currentPos = yy_markedPos + 1;
		// If the searchString occurs at the very beginning of what would have
		// been a Block, resume scanning normally immediately
		if (yy_markedPos == yy_startRead) {
			yybegin(immediateFallbackState);
			return primGetNextToken();
		}
	}
	else {
		// We ran through the rest of the input
		yy_markedPos = yy_currentPos;
		yy_currentPos++;
	}
	yybegin(exitState);
	// If the ending occurs at the very beginning of what would have
	// been a Block, resume scanning normally immediately
	if(yy_markedPos == yy_startRead)
		return primGetNextToken();
	return searchContext;
}
/**
 * user method
 *
 * A generic lookahead-like operation
 */
private final String doBlockScan(String target, String targetContext, int immediateFallbackState) throws IOException {
	return doScan(target, false, targetContext, immediateFallbackState, immediateFallbackState);
}
/**
 * user method 
 * does a lookahead for the current tag name
 */
private final String doBlockTagScan() throws IOException {
        fIsCaseSensitiveBlocking = getBlockMarkerCaseSensitivity();
	return doScan("</" + fCurrentTagName, true, getBlockMarkerContext(fCurrentTagName), YYINITIAL, YYINITIAL);
}

/**
 * user method
 *
 * Converts the raw context String returned by the primGetNextToken()
 * method into a full ITextRegion by pulling in values for the
 * current offset within the scanning text.
 *
 * Returns null when EOF is encountered and attaches intermittently
 * discovered whitespace onto the end of useful regions.
 *
 * Note that this algorithm caches the token following the one being returned
 * so that whitespace can be collapsed.
 */
public final ITextRegion getNextToken() throws IOException {
	// load the starting non-whitespace token (assume that it is so)
	if (fShouldLoadBuffered) {
		context = fBufferedContext;
		start = fBufferedStart;
		textLength = length = fBufferedLength;
		fShouldLoadBuffered = false;
	}
	else {
		context = primGetNextToken();
		if (context == XML_TAG_NAME) {
			if(containsTagName(yy_buffer, yy_startRead, yy_markedPos-yy_startRead))
				fCurrentTagName = yytext();
			else
				fCurrentTagName = null;
		}
		else if (context == XML_TAG_OPEN) {
			fIsBlockingEnabled = true;
		}
		else if (context == XML_END_TAG_OPEN) {
			fIsBlockingEnabled = false;
		}
		start = yychar;
		textLength = length = yylength();
		if (yy_atEOF) {
			fTokenCount++;
			return null;
		}
	}
	// store the next token
	f_context = primGetNextToken();
	if (f_context == XML_TAG_NAME) {
		if(containsTagName(yy_buffer, yy_startRead, yy_markedPos-yy_startRead))
			fCurrentTagName = yytext();
		else
			fCurrentTagName = null;
	}
	else if (f_context == XML_TAG_OPEN) {
		fIsBlockingEnabled = true;
	}
	else if (f_context == XML_END_TAG_OPEN) {
		fIsBlockingEnabled = false;
	}
	fBufferedContext = f_context;
	fBufferedStart = yychar;
	fBufferedLength = yylength();
	fShouldLoadBuffered = true;
	if (fBufferedContext == WHITE_SPACE) {
		fShouldLoadBuffered = false;
		length += fBufferedLength;
	}
	if (context == null) {
		// EOF
		if (Debug.debugTokenizer) {
			System.out.println(getClass().getName() + " discovered " + fTokenCount + " tokens."); //$NON-NLS-2$//$NON-NLS-1$
		}
		return null;
	}
	fTokenCount++;
	return fRegionFactory.createToken(context, start, textLength, length, null, fCurrentTagName);
}
/* user method */
public XMLLineTokenizer(){
	super();
}
/* user method */
public XMLLineTokenizer(char[] charArray){
		this(new CharArrayReader(charArray));
}
/* user method */
public void reset(char[] charArray) {
	reset(new CharArrayReader(charArray), 0);
}
/* user method */
public void reset(char[] charArray, int newOffset) {
	reset(new CharArrayReader(charArray), newOffset);
}
/* user method */
public void reset(java.io.InputStream in) {
	reset(new java.io.InputStreamReader(in), 0);
}
/* user method */
public void reset(java.io.InputStream in, int newOffset) {
	reset(new java.io.InputStreamReader(in), newOffset);
}
/* user method */
public void reset(java.io.Reader in) {
	reset(in, 0);
}
/**
 * user method *
 *
 * Reset internal counters and vars to "newly created" values, in the hopes
 * that resetting a pre-existing tokenizer is faster than creating a new one.
 *
 * This method contains code blocks that were essentially duplicated from the
 * <em>generated</em> output of this specification before this method was
 * added.  Those code blocks were under the above copyright.
 */
public void reset(java.io.Reader in, int newOffset) {
	if (Debug.debugTokenizer) {
		System.out.println("resetting tokenizer");//$NON-NLS-1$
	}
	fOffset = newOffset;

	/* the input device */
	yy_reader = in;

	/* the current state of the DFA */
	yy_state = 0;

	/* the current lexical state */
	yy_lexical_state = YYINITIAL;

	/* this buffer contains the current text to be matched and is
	the source of the yytext() string */
	java.util.Arrays.fill(yy_buffer, (char)0);

	/* the textposition at the last accepting state */
	yy_markedPos = 0;

	/* the textposition at the last state to be included in yytext */
	//yy_pushbackPos = 0;

	/* the current text position in the buffer */
	yy_currentPos = 0;

	/* startRead marks the beginning of the yytext() string in the buffer */
	yy_startRead = 0;

	/** 
	 * endRead marks the last character in the buffer, that has been read
	 * from input 
	 */
	yy_endRead = 0;

	/* number of newlines encountered up to the start of the matched text */
	yyline = 0;

	/* the number of characters up to the start of the matched text */
	yychar = 0;

	/* yy_atEOF == true <=> the scanner has returned a value for EOF */
	yy_atEOF = false;

	/* denotes if the user-EOF-code has already been executed */
	yy_eof_done = false;


	/* user vars: */
	fTokenCount = 0;
 
	fShouldLoadBuffered = false;
	fBufferedContext = null;
	fBufferedStart = 1;
	fBufferedLength = 0;
	fStateStack = new IntStack();

	context = null;
	start = 0;
	textLength = 0;
	length = 0;
}

	/**
	 * user method
	 *
	 */
	public BlockTokenizer newInstance() {
		XMLLineTokenizer newInstance = new XMLLineTokenizer();
		// global tagmarkers can be shared; they have no state and 
		// are never destroyed (e.g. 'release')
		for(int i = 0; i < fBlockMarkers.size(); i++) {
			BlockMarker blockMarker = (BlockMarker) fBlockMarkers.get(i);
			if(blockMarker.isGlobal())
				newInstance.addBlockMarker(blockMarker);
		}
		return newInstance;
	}
/* user method */
private final String scanXMLCommentText() throws IOException {
	// Scan for '-->' and return the text up to that point as
	//   XML_COMMENT_TEXT unless the string occurs IMMEDIATELY, in which
	//  case change to the ST_XML_COMMENT_END state and return the next
	//  context as usual.
	return doScan("-->", false, XML_COMMENT_TEXT, ST_XML_COMMENT_END, ST_XML_COMMENT_END);
}


  /**
   * Creates a new scanner
   * There is also a java.io.InputStream version of this constructor.
   *
   * @param   in  the java.io.Reader to read input from.
   */
  XMLLineTokenizer(java.io.Reader in) {
    this.yy_reader = in;
  }

  /**
   * Creates a new scanner.
   * There is also java.io.Reader version of this constructor.
   *
   * @param   in  the java.io.Inputstream to read input from.
   */
  XMLLineTokenizer(java.io.InputStream in) {
    this(new java.io.InputStreamReader(in));
  }

  /** 
   * Unpacks the compressed DFA transition table.
   *
   * @param packed   the packed transition table
   * @return         the unpacked transition table
   */
  private static int [] yy_unpack(String packed) {
    int [] trans = new int[9990];
    int i = 0;  /* index in packed string  */
    int j = 0;  /* index in unpacked array */
    while (i < 3270) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      value--;
      do trans[j++] = value; while (--count > 0);
    }
    return trans;
  }

  /** 
   * Unpacks the compressed character translation table.
   *
   * @param packed   the packed character translation table
   * @return         the unpacked character translation table
   */
  private static char [] yy_unpack_cmap(String packed) {
    char [] map = new char[0x10000];
    int i = 0;  /* index in packed string  */
    int j = 0;  /* index in unpacked array */
    while (i < 1372) {
      int  count = packed.charAt(i++);
      char value = packed.charAt(i++);
      do map[j++] = value; while (--count > 0);
    }
    return map;
  }


  /**
   * Gets the next input character.
   *
   * @return      the next character of the input stream, EOF if the
   *              end of the stream is reached.
   * @exception   IOException  if any I/O-Error occurs
   */
  private int yy_advance() throws java.io.IOException {

    /* standard case */
    if (yy_currentPos < yy_endRead) return yy_buffer[yy_currentPos++];

    /* if the eof is reached, we don't need to work hard */ 
    if (yy_atEOF) return YYEOF;

    /* otherwise: need to refill the buffer */

    /* first: make room (if you can) */
    if (yy_startRead > 0) {
      System.arraycopy(yy_buffer, yy_startRead, 
                       yy_buffer, 0, 
                       yy_endRead-yy_startRead);

      /* translate stored positions */
      yy_endRead-= yy_startRead;
      yy_currentPos-= yy_startRead;
      yy_markedPos-= yy_startRead;
      yy_pushbackPos-= yy_startRead;
      yy_startRead = 0;
    }

    /* is the buffer big enough? */
    if (yy_currentPos >= yy_buffer.length) {
      /* if not: blow it up */
      char newBuffer[] = new char[yy_currentPos*2];
      System.arraycopy(yy_buffer, 0, newBuffer, 0, yy_buffer.length);
      yy_buffer = newBuffer;
    }

    /* finally: fill the buffer with new input */
    int numRead = yy_reader.read(yy_buffer, yy_endRead, 
                                            yy_buffer.length-yy_endRead);

    if ( numRead == -1 ) return YYEOF;

    yy_endRead+= numRead;

    return yy_buffer[yy_currentPos++];
  }

    
  /**
   * Closes the input stream.
   */
  final public void yyclose() throws java.io.IOException {
    yy_atEOF = true;            /* indicate end of file */
    yy_endRead = yy_startRead;  /* invalidate buffer    */
    yy_reader.close();
  }


  /**
   * Returns the current lexical state.
   */
  final public int yystate() {
    return yy_lexical_state;
  }

  /**
   * Enters a new lexical state
   *
   * @param newState the new lexical state
   */
  final public void yybegin(int newState) {
    yy_lexical_state = newState;
  }


  /**
   * Returns the text matched by the current regular expression.
   */
  final public String yytext() {
    return new String( yy_buffer, yy_startRead, yy_markedPos-yy_startRead );
  }

  /**
   * Returns the length of the matched text region.
   */
  final public int yylength() {
    return yy_markedPos-yy_startRead;
  }


  /**
   * Reports an error that occured while scanning - from the SED JFlex skeleton
   *
   * @param   errorCode  the code of the errormessage to display
   */
  private void yy_ScanError(int errorCode) {
    try {
      Logger.log(Logger.ERROR, YY_ERROR_MSG[errorCode]);
    }
    catch (ArrayIndexOutOfBoundsException e) {
      Logger.log(Logger.ERROR, YY_ERROR_MSG[YY_UNKNOWN_ERROR]);
    }
    // DO NOT EXIT the VM on an error
    // System.exit(1);
  } 


  /**
   * Pushes the specified amount of characters back into the input stream.
   *
   * They will be read again by then next call of the scanning method
   *
   * @param number  the number of characters to be read again.
   *                This number must not be greater than yylength()!
   */
  void yypushback(int number) {
    if ( number > yylength() )
      yy_ScanError(YY_PUSHBACK_2BIG);

    yy_markedPos -= number;
  }

	/**
	 * user method - skeleton.sed
	 */
	protected final boolean containsTagName(char[] markerTagName, int offset, int tagnameLength) {
		for(int j = 0; j < fBlockMarkers.size(); j++) {
			BlockMarker marker = (BlockMarker)fBlockMarkers.get(j);
			if(marker.getTagName().length() == tagnameLength) {
				boolean matchesSoFar = true;
				for(int i = 0; i < tagnameLength && matchesSoFar; i++) {
					if(marker.isCaseSensitive()) {
						if(marker.getTagName().charAt(i) != markerTagName[i + offset])
							matchesSoFar = false;
					}
					else {
						if(Character.toLowerCase(marker.getTagName().charAt(i)) != Character.toLowerCase(markerTagName[i + offset]))
							matchesSoFar = false;
					}
				}
				if(matchesSoFar)
					return true;
			}
		}
		return false;
	}

	/**
	 * user method - skeleton.sed
	 *
	 * Return ALL of the regions scannable within the remaining text
	 * Note: for verification use
	 */
	public final List getRegions() {
		List tokens = new ArrayList();
		ITextRegion region = null;
		try {
			region = getNextToken();
			while(region != null) {
				if (region != null) {
					tokens.add(region);
				}
				region = getNextToken();
			}
		}
		catch (StackOverflowError e) {
			Logger.logException(getClass().getName()+": input could not be tokenized correctly at position " + getOffset(), e);//$NON-NLS-1$
			throw e;
		}
		catch (Exception e) {
			// Since this is convenience method and NOT the recommended 
			// way of getting tokens, many errors are simply hidden
			Logger.logException("Exception not handled retrieving regions: " + e.getLocalizedMessage(), e);//$NON-NLS-1$
		}
		return tokens;
	}
	/**
	 * user method - skeleton.sed
	 */
	private final void dump(String s) {
		if (Debug.debugTokenizer) {
			System.out.println(s + " (" + yychar + "-" + //$NON-NLS-2$//$NON-NLS-1$
				(yylength() + yychar) + "):\'" +//$NON-NLS-1$
					StringUtils.escape(yytext()) + "\'");//$NON-NLS-1$
		}
	}
	/* user method  - skeleton.sed */
	public final boolean isEOF() {
		return yy_atEOF;
	}
/* user method - skeleton.sed */
protected final boolean containsTagName(String markerTagName) {
	Iterator blocks = fBlockMarkers.iterator();
	while(blocks.hasNext()) {
		BlockMarker marker = (BlockMarker)blocks.next();
		if(marker.isCaseSensitive()) {
			if(marker.getTagName().equals(markerTagName))
				return true;
		}
		else {
			if(marker.getTagName().equalsIgnoreCase(markerTagName))
				return true;
		}
	}
	return false;
}

  /**
   * Contains user EOF-code, which will be executed exactly once,
   * when the end of file is reached
   */
  private void yy_do_eof() {
    if (!yy_eof_done) {
      yy_eof_done = true;
    // do nothing, this is the downstream parser's job

    }
  }


  /**
   * Resumes scanning until the next regular expression is matched,
   * the end of input is encountered or an I/O-Error occurs.
   *
   * @return      the next token
   * @exception   IOException  if any I/O-Error occurs
   */
  public String primGetNextToken() throws java.io.IOException {
    int yy_input;
    int yy_action;


    while (true) {

      yychar+= yylength();

      boolean yy_counted = false;
      for (yy_currentPos = yy_startRead; yy_currentPos < yy_markedPos;
                                                      yy_currentPos++) {
        switch (yy_buffer[yy_currentPos]) {
        case '\r':
          yyline++;
          yy_counted = true;
          break;
        case '\n':
          if (yy_counted)
            yy_counted = false;
          else {
            yyline++;
          }
          break;
        default:
          yy_counted = false;
        }
      }

      if (yy_counted) {
        if ( yy_advance() == '\n' ) yyline--;
        if ( !yy_atEOF ) yy_currentPos--;
      }

      yy_action = -1;

      yy_currentPos = yy_startRead = yy_markedPos;

      yy_state = yy_lexical_state;


      yy_forAction: {
        while (true) {
    
          yy_input = yy_advance();

          if ( yy_input == YYEOF ) break yy_forAction;

          int yy_next = yytrans[ yy_rowMap[yy_state] + yycmap[yy_input] ];
          if (yy_next == -1) break yy_forAction;
          yy_state = yy_next;

          int yy_attributes = YY_ATTRIBUTE[yy_state];
          if ( (yy_attributes & 1) > 0 ) {
            yy_action = yy_state; 
            yy_markedPos = yy_currentPos; 
            if ( (yy_attributes & 8) > 0 ) break yy_forAction;
          }

        }
      }


      switch (yy_action) {    

        case 268: 
          { 
	if(Debug.debugTokenizer)
		dump("XSL processing instruction target");//$NON-NLS-1$
        yybegin(ST_XML_PI_ATTRIBUTE_NAME);
        return XML_TAG_NAME;
 }
        case 270: break;
        case 260: 
        case 262: 
        case 263: 
          { 
	if(Debug.debugTokenizer)
		dump("\nCDATA start");//$NON-NLS-1$
	fStateStack.push(yystate());
	yybegin(ST_CDATA_TEXT);
	return XML_CDATA_OPEN;
 }
        case 271: break;
        case 253: 
          { 
	if(Debug.debugTokenizer)
		dump("element");//$NON-NLS-1$
	yybegin(ST_XML_ELEMENT_DECLARATION);
	return XML_ELEMENT_DECLARATION;
 }
        case 272: break;
        case 252: 
          { 
	if(Debug.debugTokenizer)
		dump("attlist");//$NON-NLS-1$
	yybegin(ST_XML_ATTLIST_DECLARATION);
	return XML_ATTLIST_DECLARATION;
 }
        case 273: break;
        case 251: 
          { 
	if(Debug.debugTokenizer)
		dump("doctype");//$NON-NLS-1$
	yybegin(ST_XML_DOCTYPE_DECLARATION);
	return XML_DOCTYPE_DECLARATION;
 }
        case 274: break;
        case 246: 
          { 
	if(Debug.debugTokenizer)
		dump("doctype external id");//$NON-NLS-1$
	yybegin(ST_XML_DOCTYPE_ID_PUBLIC);
	return XML_DOCTYPE_EXTERNAL_ID_PUBLIC;
 }
        case 275: break;
        case 245: 
          { 
	if(Debug.debugTokenizer)
		dump("doctype external id");//$NON-NLS-1$
	yybegin(ST_XML_DOCTYPE_ID_SYSTEM);
	return XML_DOCTYPE_EXTERNAL_ID_SYSTEM;
 }
        case 276: break;
        case 216: 
          { 
	if(Debug.debugTokenizer)
		dump("\nCharRef");//$NON-NLS-1$
	return XML_CHAR_REFERENCE;
 }
        case 277: break;
        case 212: 
          { 
	if(Debug.debugTokenizer)
		dump("\ncomment start");//$NON-NLS-1$
	yybegin(ST_XML_COMMENT);
	return XML_COMMENT_OPEN;
 }
        case 278: break;
        case 194: 
        case 195: 
          { 
	if(Debug.debugTokenizer)
		dump("XML processing instruction target");//$NON-NLS-1$
        yybegin(ST_XML_PI_ATTRIBUTE_NAME);
        return XML_TAG_NAME;
 }
        case 279: break;
        case 193: 
          { 
	if(Debug.debugTokenizer)
		dump("comment end");//$NON-NLS-1$
	yybegin(YYINITIAL);
	return XML_COMMENT_CLOSE;
 }
        case 280: break;
        case 192: 
          { 
	if(Debug.debugTokenizer)
		dump("CDATA end");//$NON-NLS-1$
	yybegin(fStateStack.pop());
	return XML_CDATA_CLOSE;
 }
        case 281: break;
        case 191: 
          { 
	if(Debug.debugTokenizer)
		dump("\nPEReference");//$NON-NLS-1$
	return XML_PE_REFERENCE;
 }
        case 282: break;
        case 188: 
          { 
	if(Debug.debugTokenizer)
		dump("\nEntityRef");//$NON-NLS-1$
	return XML_ENTITY_REFERENCE;
 }
        case 283: break;
        case 139: 
        case 153: 
        case 161: 
          { 
	return XML_DOCTYPE_INTERNAL_SUBSET;
 }
        case 284: break;
        case 127: 
          { 
        yybegin(YYINITIAL);
	if(Debug.debugTokenizer)
		dump("empty tag close");//$NON-NLS-1$
        return XML_EMPTY_TAG_CLOSE;
 }
        case 285: break;
        case 120: 
          { 
	if(Debug.debugTokenizer)
		dump("XML processing instruction end");//$NON-NLS-1$
        yybegin(YYINITIAL);
        return XML_PI_CLOSE;
 }
        case 286: break;
        case 119: 
          { 
		// ended with nothing inside
        yybegin(YYINITIAL);
        return XML_PI_CLOSE;
 }
        case 287: break;
        case 52: 
        case 54: 
        case 55: 
        case 56: 
        case 124: 
          { 
	if(Debug.debugTokenizer)
		dump("XML processing instruction attribute value");//$NON-NLS-1$
        yybegin(ST_XML_PI_ATTRIBUTE_NAME);
        return XML_TAG_ATTRIBUTE_VALUE;
 }
        case 288: break;
        case 51: 
          { 
	if(Debug.debugTokenizer)
		dump("XML processing instruction '='");//$NON-NLS-1$
        yybegin(ST_XML_PI_ATTRIBUTE_VALUE);
        return XML_TAG_ATTRIBUTE_EQUALS;
 }
        case 289: break;
        case 50: 
          { 
	if(Debug.debugTokenizer)
		dump("XML processing instruction attribute name");//$NON-NLS-1$
        yybegin(ST_XML_PI_EQUALS);
        return XML_TAG_ATTRIBUTE_NAME;
 }
        case 290: break;
        case 46: 
        case 47: 
        case 48: 
          { 
	// block scan until close is found
	return doScan("?>", false, XML_PI_CONTENT, ST_XML_PI_TAG_CLOSE, ST_XML_PI_TAG_CLOSE);
 }
        case 291: break;
        case 45: 
          { 
        yybegin(ST_PI_CONTENT);
        return WHITE_SPACE;
 }
        case 292: break;
        case 42: 
        case 43: 
        case 44: 
        case 117: 
        case 118: 
        case 218: 
        case 232: 
        case 241: 
        case 250: 
        case 257: 
        case 261: 
        case 264: 
        case 265: 
        case 266: 
        case 267: 
          { 
	if(Debug.debugTokenizer)
		dump("processing instruction target");//$NON-NLS-1$
        yybegin(ST_PI_WS);
        return XML_TAG_NAME;
 }
        case 293: break;
        case 37: 
        case 38: 
          { 
	if(Debug.debugTokenizer)
		dump("comment content");//$NON-NLS-1$
	return scanXMLCommentText();
 }
        case 294: break;
        case 36: 
          { 
	if(Debug.debugTokenizer)
		dump("LINE FEED");//$NON-NLS-1$
	return WHITE_SPACE;
 }
        case 295: break;
        case 31: 
        case 32: 
          { 
	if(Debug.debugTokenizer)
		dump("CDATA text");//$NON-NLS-1$
	String blockContext = doBlockScan("]]>", XML_CDATA_TEXT, ST_CDATA_END);//$NON-NLS-1$
	if(blockContext == XML_CDATA_TEXT)
		yybegin(ST_CDATA_END);
	return blockContext;
 }
        case 296: break;
        case 0: 
        case 27: 
        case 109: 
        case 111: 
        case 186: 
        case 187: 
        case 214: 
        case 215: 
        case 230: 
        case 231: 
          { 
	if(Debug.debugTokenizer)
		dump("\nXML content");//$NON-NLS-1$
	return XML_CONTENT;
 }
        case 297: break;
        case 5: 
        case 8: 
        case 9: 
        case 10: 
        case 13: 
        case 14: 
        case 15: 
        case 16: 
        case 17: 
        case 18: 
        case 19: 
        case 20: 
        case 21: 
        case 22: 
        case 24: 
        case 41: 
          { 
	if(Debug.debugTokenizer)
		dump("white space");//$NON-NLS-1$
        return WHITE_SPACE;
 }
        case 298: break;
        case 12: 
        case 58: 
          { 
	if(Debug.debugTokenizer)
		dump("inappropriate tag name");//$NON-NLS-1$
	yybegin(YYINITIAL);
        return XML_CONTENT;
 }
        case 299: break;
        case 23: 
        case 93: 
        case 94: 
        case 172: 
        case 207: 
        case 226: 
        case 238: 
        case 247: 
        case 254: 
        case 258: 
          { 
	if(Debug.debugTokenizer)
		dump("elementdecl contentspec");//$NON-NLS-1$
	return XML_ELEMENT_DECL_CONTENT;
 }
        case 300: break;
        case 25: 
        case 100: 
        case 101: 
        case 183: 
        case 211: 
        case 228: 
        case 239: 
        case 248: 
        case 255: 
        case 259: 
          { 
	if(Debug.debugTokenizer)
		dump("attlist contentspec");//$NON-NLS-1$
	return XML_ATTLIST_DECL_CONTENT;
 }
        case 301: break;
        case 28: 
        case 59: 
        case 70: 
          { 
	if(Debug.debugTokenizer)
		dump("\nstart tag open");//$NON-NLS-1$
        yybegin(ST_XML_TAG_NAME);
        return XML_TAG_OPEN;
 }
        case 302: break;
        case 29: 
        case 33: 
        case 34: 
        case 35: 
        case 39: 
        case 40: 
        case 49: 
        case 53: 
        case 57: 
        case 61: 
        case 67: 
        case 72: 
        case 73: 
        case 74: 
        case 75: 
        case 77: 
        case 78: 
        case 80: 
        case 85: 
        case 90: 
        case 97: 
          { 
	if (Debug.debugTokenizer)
		System.out.println("!!!unexpected!!!: \"" + yytext() + "\":" + //$NON-NLS-2$//$NON-NLS-1$
			yychar + "-" + (yychar + yylength()));//$NON-NLS-1$
	return UNDEFINED;
 }
        case 303: break;
        case 30: 
        case 112: 
          { 
	if(Debug.debugTokenizer)
		dump("non-reference %");//$NON-NLS-1$
	return XML_CONTENT;
 }
        case 304: break;
        case 60: 
          { 
	if(Debug.debugTokenizer)
		dump("tag close");//$NON-NLS-1$
	if(isBlockMarker()) {
        	yybegin(ST_BLOCK_TAG_SCAN);
	}
	else
        	yybegin(YYINITIAL);
        return XML_TAG_CLOSE;
 }
        case 305: break;
        case 62: 
        case 63: 
          { 
	if(Debug.debugTokenizer)
		dump("tag name");//$NON-NLS-1$
        yybegin(ST_XML_ATTRIBUTE_NAME);
        return XML_TAG_NAME;
 }
        case 306: break;
        case 64: 
          { 
	if(Debug.debugTokenizer)
		dump("attr name");//$NON-NLS-1$
        yybegin(ST_XML_EQUALS);
        return XML_TAG_ATTRIBUTE_NAME;
 }
        case 307: break;
        case 65: 
          { 
	if(Debug.debugTokenizer)
		dump("equals");//$NON-NLS-1$
        yybegin(ST_XML_ATTRIBUTE_VALUE);
        return XML_TAG_ATTRIBUTE_EQUALS;
 }
        case 308: break;
        case 66: 
        case 68: 
        case 69: 
        case 131: 
          { 
	if(Debug.debugTokenizer)
		dump("attr value");//$NON-NLS-1$
        yybegin(ST_XML_ATTRIBUTE_NAME);
        return XML_TAG_ATTRIBUTE_VALUE;
 }
        case 309: break;
        case 71: 
          { 
	if(Debug.debugTokenizer)
		dump("declaration end");//$NON-NLS-1$
	if (Debug.debugTokenizer) {
		if(fStateStack.peek()!=YYINITIAL)
			System.out.println("end embedded region");//$NON-NLS-1$
	}
	yybegin(fStateStack.pop());
	return XML_DECLARATION_CLOSE;
 }
        case 310: break;
        case 76: 
          { 
	if(Debug.debugTokenizer)
		dump("doctype type");//$NON-NLS-1$
	yybegin(ST_XML_DOCTYPE_EXTERNAL_ID);
	return XML_DOCTYPE_NAME;
 }
        case 311: break;
        case 79: 
        case 81: 
        case 82: 
        case 83: 
        case 145: 
        case 146: 
        case 149: 
        case 150: 
        case 202: 
          { 
	if(Debug.debugTokenizer)
		dump("doctype public reference");//$NON-NLS-1$
	yybegin(ST_XML_DOCTYPE_ID_SYSTEM);
	return XML_DOCTYPE_EXTERNAL_ID_PUBREF;
 }
        case 312: break;
        case 84: 
        case 86: 
        case 87: 
        case 88: 
        case 157: 
          { 
	if(Debug.debugTokenizer)
		dump("doctype system reference");//$NON-NLS-1$
	yybegin(ST_XML_DECLARATION_CLOSE);
	return XML_DOCTYPE_EXTERNAL_ID_SYSREF;
 }
        case 313: break;
        case 89: 
        case 91: 
        case 92: 
        case 165: 
        case 166: 
        case 169: 
        case 170: 
        case 205: 
          { 
	if(Debug.debugTokenizer)
		dump("elementdecl name");//$NON-NLS-1$
	yybegin(ST_XML_ELEMENT_DECLARATION_CONTENT);
	return XML_ELEMENT_DECL_NAME;
 }
        case 314: break;
        case 95: 
          { 
	if(Debug.debugTokenizer)
		dump("elementdecl close");//$NON-NLS-1$
	if (Debug.debugTokenizer) {
		if(fStateStack.peek()!=YYINITIAL)
			System.out.println("end embedded region");//$NON-NLS-1$
	}
	yybegin(fStateStack.pop());
	return XML_DECLARATION_CLOSE;
 }
        case 315: break;
        case 96: 
        case 98: 
        case 99: 
        case 176: 
        case 177: 
        case 180: 
        case 181: 
        case 209: 
          { 
	if(Debug.debugTokenizer)
		dump("attlist name");//$NON-NLS-1$
	yybegin(ST_XML_ATTLIST_DECLARATION_CONTENT);
	return XML_ATTLIST_DECL_NAME;
 }
        case 316: break;
        case 102: 
          { 
	if(Debug.debugTokenizer)
		dump("attlist close");//$NON-NLS-1$
	if (Debug.debugTokenizer) {
		if(fStateStack.peek()!=YYINITIAL)
			System.out.println("end embedded region");//$NON-NLS-1$
	}
	yybegin(fStateStack.pop());
	return XML_DECLARATION_CLOSE;
 }
        case 317: break;
        case 105: 
          { 
	if(Debug.debugTokenizer)
		dump("\nend tag open");//$NON-NLS-1$
        yybegin(ST_XML_TAG_NAME);
        return XML_END_TAG_OPEN;
 }
        case 318: break;
        case 106: 
          { 
	if(Debug.debugTokenizer)
		dump("\nprocessing instruction start");//$NON-NLS-1$
	yybegin(ST_PI);
        return XML_PI_OPEN;
 }
        case 319: break;
        case 107: 
          { 
	fStateStack.push(yystate());
	if(Debug.debugTokenizer)
		dump("\ndeclaration start");//$NON-NLS-1$
        yybegin(ST_XML_DECLARATION);
	return XML_DECLARATION_OPEN;
 }
        case 320: break;
        case 116: 
          { 
	if(Debug.debugTokenizer)
		dump("processing instruction end");//$NON-NLS-1$
        yybegin(YYINITIAL);
        return XML_PI_CLOSE;
 }
        case 321: break;
        case 103: 
        case 104: 
          { 
		return doBlockTagScan();
	 }
        case 322: break;
        default: 
          if (yy_input == YYEOF && yy_startRead == yy_currentPos) {
            yy_atEOF = true;
            yy_do_eof();
              return null;
          } 
          else {
            yy_ScanError(YY_NO_MATCH);
          }
      }
    }
  }    


}
