/* $Id: glue-proc.c,v 1.5 2009-01-27 17:06:40 potyra Exp $ 
 *
 * Copyright (C) 2007-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include "config.h"

#include <sys/types.h>
#include <sys/wait.h>
#include <assert.h>
#include <stdio.h>

#include "glue-proc.h"

static struct {
	int pid;
	void *s;
	void (*f)(int, void *);
} callback[100];
static unsigned int callback_count;


void
proc_register(int pid, void *s, void (*f)(int, void *))
{
	assert(1 < pid);
	assert(s);
	assert(f);

	assert(callback_count < sizeof(callback) / sizeof(callback[0]));

	callback[callback_count].pid = pid;
	callback[callback_count].s = s;
	callback[callback_count].f = f;
	callback_count++;
}

void
proc_unregister(int pid)
{
	unsigned int i;

	for (i = 0; pid != callback[i].pid; i++) {
		assert(i < callback_count);
	}
	assert(/* 0 <= i && */ i < callback_count);

	callback[i].pid = callback[callback_count - 1].pid;
	callback[i].s = callback[callback_count - 1].s;
	callback[i].f = callback[callback_count - 1].f;

	callback_count--;
}

void
proc_do(void)
{
	for (;;) {
		int pid;
		int status;
		unsigned int i;

		pid = waitpid(0, &status, WNOHANG);

		if (pid <= 0) {
			break;
		}

		for (i = 0; ; i++) {
			if (callback_count <= i) {
				/* Pid not found. Just ignore... */
				break;
			}
			if (pid == callback[i].pid) {
				(*callback[i].f)(pid, callback[i].s);
				break;
			}
		}
	}
}

void
proc_init(void)
{
	callback_count = 0;
}
