/*
 *  $Id: monitor_gui_null.c,v 1.9 2012-02-22 11:59:42 siflkres Exp $
 *
 * Copyright (C) 2007-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */


#include <assert.h>
#include <stdio.h>
#include <stdlib.h>

#include "monitor_gui_null.h"
#include "glue-gui-recorder.h"
#include "glue-shm.h"

#define COMP "monitor"

struct cpssp {
	void * gui;
};

/*
 * Simulator Callbacks
 */
static void
monitor_gui_pixel_set(
	void *_cpssp,
	unsigned int x,
	unsigned int y,
	uint8_t r,
	uint8_t g,
	uint8_t b
)
{
	struct cpssp *cpssp = (struct cpssp *) _cpssp;

	gui_recorder_pixel_set(cpssp->gui, x, y, r, g, b);
}

static void
monitor_gui_size_set(void *_cpssp, unsigned int width, unsigned int height)
{
	struct cpssp *cpssp = (struct cpssp *) _cpssp;

	gui_recorder_size_set(cpssp->gui, width, height);
}

static void
monitor_gui_sync(void *_cpssp)
{
#if 0
	struct cpssp *cpssp = (struct cpssp *) _cpssp;
#endif
}

static void
monitor_gui_screenshot_set(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = (struct cpssp *) _cpssp;

	if (val == 0) return;

	gui_recorder_screenshot(cpssp->gui);
}

static void
monitor_gui_rec_set(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = (struct cpssp *) _cpssp;

	gui_recorder_rec_set(cpssp->gui, val);
}

/*
 * GUI Callbacks
 */

void *
monitor_gui_null_create(
	unsigned int page,
	const char *name,
	struct sig_manage *port_manage,
	struct sig_boolean *port_power_230v,
	struct sig_vga *port_vga,
	struct sig_opt_rgb *port_opt_video,
	struct sig_boolean *port_screenshot,
	struct sig_boolean *port_rec
)
{
	static const struct sig_opt_rgb_funcs opt_video_funcs = {
		.pixel_set = monitor_gui_pixel_set,
		.size_set = monitor_gui_size_set,
		.sync = monitor_gui_sync,
	};
	static const struct sig_boolean_funcs screenshot_funcs = {
		.set = monitor_gui_screenshot_set,
	};
	static const struct sig_boolean_funcs rec_funcs = {
		.set = monitor_gui_rec_set,
	};
	struct cpssp *cpssp;

	cpssp = shm_alloc(sizeof(*cpssp));
	assert(cpssp);

	cpssp->gui = gui_recorder_create(1600,1200);

	/* In */
	sig_opt_rgb_connect(port_opt_video, cpssp, &opt_video_funcs);
	sig_boolean_connect_in(port_screenshot, cpssp, &screenshot_funcs);
	sig_boolean_connect_in(port_rec, cpssp, &rec_funcs);

	return cpssp;
}

void
monitor_gui_null_destroy(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;

	gui_recorder_destroy(cpssp->gui);

	shm_free(cpssp);
}
