/***************************************************************************
 *   Copyright (C) 2012~2012 by CSSlayer                                   *
 *   wengxt@gmail.com                                                      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA.              *
 ***************************************************************************/

#ifndef __FcitxKey_COMPOSE_DATA_H_
#define __FcitxKey_COMPOSE_DATA_H_

#ifndef XK_TECHNICAL
#define XK_TECHNICAL
#endif

#ifndef XK_APL
#define XK_APL
#endif

#include <X11/keysym.h>

static const quint32 fcitx_compose_seqs_compact[] = {
    XK_dead_stroke, 138, 226, 235, 235, 235,
    XK_Greek_accentdieresis, 235, 239, 239, 239, 239,
    XK_dead_grave, 239, 299, 386, 598, 598,
    XK_dead_acute, 598, 664, 760, 1036, 1036,
    XK_dead_circumflex, 1036, 1176, 1176, 1376, 1376,
    XK_dead_tilde, 1376, 1458, 1521, 1661, 1661,
    XK_dead_macron, 1661, 1707, 1707, 1779, 1779,
    XK_dead_breve, 1779, 1833, 1833, 1857, 1857,
    XK_dead_abovedot, 1857, 1887, 1890, 1922, 1922,
    XK_dead_diaeresis, 1922, 2010, 2019, 2043, 2043,
    XK_dead_abovering, 2043, 2053, 2053, 2053, 2053,
    XK_dead_doubleacute, 2053, 2063, 2063, 2063, 2063,
    XK_dead_caron, 2063, 2089, 2089, 2097, 2097,
    XK_dead_cedilla, 2097, 2111, 2111, 2111, 2111,
    XK_dead_ogonek, 2111, 2121, 2121, 2121, 2121,
    XK_dead_iota, 2121, 2143, 2242, 2674, 3334,
    XK_dead_voiced_sound, 3334, 3380, 3380, 3380, 3380,
    XK_dead_semivoiced_sound, 3380, 3390, 3390, 3390, 3390,
    XK_dead_belowdot, 3390, 3400, 3400, 3416, 3416,
    XK_dead_hook, 3416, 3494, 3494, 3550, 3550,
    XK_dead_psili, 3550, 3578, 3578, 3578, 3578,
    XK_dead_dasia, 3578, 3610, 3610, 3610, 3610,
    XK_Multi_key, 3610, 3610, 9589, 13297, 15157,
    XK_space, 0x002F,
    XK_2, 0x01BB,
    XK_A, 0x023A,
    XK_B, 0x0243,
    XK_C, 0x023B,
    XK_D, 0x0110,
    XK_E, 0x0246,
    XK_G, 0x01E4,
    XK_H, 0x0126,
    XK_I, 0x0197,
    XK_J, 0x0248,
    XK_L, 0x0141,
    XK_O, 0x00D8,
    XK_P, 0x2C63,
    XK_R, 0x024C,
    XK_T, 0x0166,
    XK_U, 0x0244,
    XK_Y, 0x024E,
    XK_Z, 0x01B5,
    XK_a, 0x2C65,
    XK_b, 0x0180,
    XK_c, 0x023C,
    XK_d, 0x0111,
    XK_e, 0x0247,
    XK_g, 0x01E5,
    XK_h, 0x0127,
    XK_i, 0x0268,
    XK_j, 0x0249,
    XK_l, 0x0142,
    XK_o, 0x00F8,
    XK_p, 0x1D7D,
    XK_r, 0x024D,
    XK_t, 0x0167,
    XK_u, 0x0289,
    XK_y, 0x024F,
    XK_z, 0x01B6,
    XK_nobreakspace, 0x0338,
    XK_Oacute, 0x01FE,
    XK_oacute, 0x01FF,
    0x0237, 0x025F,
    0x0269, 0x1D7C,
    XK_dead_stroke, 0x002F,
    XK_lessthanequal, 0x2270,
    XK_greaterthanequal, 0x2271,
    XK_dead_acute, XK_O, 0x01FE,
    XK_dead_acute, XK_o, 0x01FF,
    XK_dead_abovedot, XK_j, 0x025F,
    XK_Greek_iota, 0x0390,
    XK_Greek_upsilon, 0x03B0,
    XK_space, 0x0060,
    XK_V, 0x01DB,
    XK_v, 0x01DC,
    XK_Abreve, 0x1EB0,
    XK_abreve, 0x1EB1,
    XK_Emacron, 0x1E14,
    XK_emacron, 0x1E15,
    XK_Omacron, 0x1E50,
    XK_omacron, 0x1E51,
    XK_Cyrillic_ie, 0x0450,
    XK_Cyrillic_i, 0x045D,
    XK_Cyrillic_IE, 0x0400,
    XK_Cyrillic_I, 0x040D,
    XK_Greek_iotadieresis, 0x1FD2,
    XK_Greek_upsilondieresis, 0x1FE2,
    XK_Greek_ALPHA, 0x1FBA,
    XK_Greek_EPSILON, 0x1FC8,
    XK_Greek_ETA, 0x1FCA,
    XK_Greek_IOTA, 0x1FDA,
    XK_Greek_OMICRON, 0x1FF8,
    XK_Greek_UPSILON, 0x1FEA,
    XK_Greek_OMEGA, 0x1FFA,
    XK_Greek_alpha, 0x1F70,
    XK_Greek_epsilon, 0x1F72,
    XK_Greek_eta, 0x1F74,
    XK_Greek_iota, 0x1F76,
    XK_Greek_omicron, 0x1F78,
    XK_Greek_upsilon, 0x1F7A,
    XK_Greek_omega, 0x1F7C,
    XK_dead_grave, 0x0060,
    XK_dead_diaeresis, XK_Greek_iota, 0x1FD2,
    XK_dead_diaeresis, XK_Greek_upsilon, 0x1FE2,
    XK_dead_psili, XK_Greek_ALPHA, 0x1F0A,
    XK_dead_psili, XK_Greek_EPSILON, 0x1F1A,
    XK_dead_psili, XK_Greek_ETA, 0x1F2A,
    XK_dead_psili, XK_Greek_IOTA, 0x1F3A,
    XK_dead_psili, XK_Greek_OMICRON, 0x1F4A,
    XK_dead_psili, XK_Greek_OMEGA, 0x1F6A,
    XK_dead_psili, XK_Greek_alpha, 0x1F02,
    XK_dead_psili, XK_Greek_epsilon, 0x1F12,
    XK_dead_psili, XK_Greek_eta, 0x1F22,
    XK_dead_psili, XK_Greek_iota, 0x1F32,
    XK_dead_psili, XK_Greek_omicron, 0x1F42,
    XK_dead_psili, XK_Greek_upsilon, 0x1F52,
    XK_dead_psili, XK_Greek_omega, 0x1F62,
    XK_dead_dasia, XK_Greek_ALPHA, 0x1F0B,
    XK_dead_dasia, XK_Greek_EPSILON, 0x1F1B,
    XK_dead_dasia, XK_Greek_ETA, 0x1F2B,
    XK_dead_dasia, XK_Greek_IOTA, 0x1F3B,
    XK_dead_dasia, XK_Greek_OMICRON, 0x1F4B,
    XK_dead_dasia, XK_Greek_UPSILON, 0x1F5B,
    XK_dead_dasia, XK_Greek_OMEGA, 0x1F6B,
    XK_dead_dasia, XK_Greek_alpha, 0x1F03,
    XK_dead_dasia, XK_Greek_epsilon, 0x1F13,
    XK_dead_dasia, XK_Greek_eta, 0x1F23,
    XK_dead_dasia, XK_Greek_iota, 0x1F33,
    XK_dead_dasia, XK_Greek_omicron, 0x1F43,
    XK_dead_dasia, XK_Greek_upsilon, 0x1F53,
    XK_dead_dasia, XK_Greek_omega, 0x1F63,
    XK_Multi_key, XK_quotedbl, XK_U, 0x01DB,
    XK_Multi_key, XK_quotedbl, XK_u, 0x01DC,
    XK_Multi_key, XK_quotedbl, XK_Greek_iota, 0x1FD2,
    XK_Multi_key, XK_quotedbl, XK_Greek_upsilon, 0x1FE2,
    XK_Multi_key, XK_parenleft, XK_Greek_ALPHA, 0x1F0B,
    XK_Multi_key, XK_parenleft, XK_Greek_EPSILON, 0x1F1B,
    XK_Multi_key, XK_parenleft, XK_Greek_ETA, 0x1F2B,
    XK_Multi_key, XK_parenleft, XK_Greek_IOTA, 0x1F3B,
    XK_Multi_key, XK_parenleft, XK_Greek_OMICRON, 0x1F4B,
    XK_Multi_key, XK_parenleft, XK_Greek_UPSILON, 0x1F5B,
    XK_Multi_key, XK_parenleft, XK_Greek_OMEGA, 0x1F6B,
    XK_Multi_key, XK_parenleft, XK_Greek_alpha, 0x1F03,
    XK_Multi_key, XK_parenleft, XK_Greek_epsilon, 0x1F13,
    XK_Multi_key, XK_parenleft, XK_Greek_eta, 0x1F23,
    XK_Multi_key, XK_parenleft, XK_Greek_iota, 0x1F33,
    XK_Multi_key, XK_parenleft, XK_Greek_omicron, 0x1F43,
    XK_Multi_key, XK_parenleft, XK_Greek_upsilon, 0x1F53,
    XK_Multi_key, XK_parenleft, XK_Greek_omega, 0x1F63,
    XK_Multi_key, XK_parenright, XK_Greek_ALPHA, 0x1F0A,
    XK_Multi_key, XK_parenright, XK_Greek_EPSILON, 0x1F1A,
    XK_Multi_key, XK_parenright, XK_Greek_ETA, 0x1F2A,
    XK_Multi_key, XK_parenright, XK_Greek_IOTA, 0x1F3A,
    XK_Multi_key, XK_parenright, XK_Greek_OMICRON, 0x1F4A,
    XK_Multi_key, XK_parenright, XK_Greek_OMEGA, 0x1F6A,
    XK_Multi_key, XK_parenright, XK_Greek_alpha, 0x1F02,
    XK_Multi_key, XK_parenright, XK_Greek_epsilon, 0x1F12,
    XK_Multi_key, XK_parenright, XK_Greek_eta, 0x1F22,
    XK_Multi_key, XK_parenright, XK_Greek_iota, 0x1F32,
    XK_Multi_key, XK_parenright, XK_Greek_omicron, 0x1F42,
    XK_Multi_key, XK_parenright, XK_Greek_upsilon, 0x1F52,
    XK_Multi_key, XK_parenright, XK_Greek_omega, 0x1F62,
    XK_Multi_key, XK_plus, XK_O, 0x1EDC,
    XK_Multi_key, XK_plus, XK_U, 0x1EEA,
    XK_Multi_key, XK_plus, XK_o, 0x1EDD,
    XK_Multi_key, XK_plus, XK_u, 0x1EEB,
    XK_Multi_key, XK_U, XK_A, 0x1EB0,
    XK_Multi_key, XK_U, XK_a, 0x1EB1,
    XK_Multi_key, XK_asciicircum, XK_A, 0x1EA6,
    XK_Multi_key, XK_asciicircum, XK_E, 0x1EC0,
    XK_Multi_key, XK_asciicircum, XK_O, 0x1ED2,
    XK_Multi_key, XK_asciicircum, XK_a, 0x1EA7,
    XK_Multi_key, XK_asciicircum, XK_e, 0x1EC1,
    XK_Multi_key, XK_asciicircum, XK_o, 0x1ED3,
    XK_Multi_key, XK_underscore, XK_E, 0x1E14,
    XK_Multi_key, XK_underscore, XK_O, 0x1E50,
    XK_Multi_key, XK_underscore, XK_e, 0x1E15,
    XK_Multi_key, XK_underscore, XK_o, 0x1E51,
    XK_Multi_key, XK_b, XK_A, 0x1EB0,
    XK_Multi_key, XK_b, XK_a, 0x1EB1,
    XK_Multi_key, XK_macron, XK_E, 0x1E14,
    XK_Multi_key, XK_macron, XK_O, 0x1E50,
    XK_Multi_key, XK_macron, XK_e, 0x1E15,
    XK_Multi_key, XK_macron, XK_o, 0x1E51,
    XK_space, 0x0027,
    XK_V, 0x01D7,
    XK_v, 0x01D8,
    XK_Abreve, 0x1EAE,
    XK_abreve, 0x1EAF,
    XK_Emacron, 0x1E16,
    XK_emacron, 0x1E17,
    XK_Utilde, 0x1E78,
    XK_omacron, 0x1E53,
    XK_utilde, 0x1E79,
    XK_Cyrillic_ghe, 0x0453,
    XK_Cyrillic_ka, 0x045C,
    XK_Cyrillic_GHE, 0x0403,
    XK_Cyrillic_KA, 0x040C,
    XK_Greek_iotadieresis, 0x0390,
    XK_Greek_upsilondieresis, 0x03B0,
    XK_Greek_ALPHA, 0x0386,
    XK_Greek_EPSILON, 0x0388,
    XK_Greek_ETA, 0x0389,
    XK_Greek_IOTA, 0x038A,
    XK_Greek_OMICRON, 0x038C,
    XK_Greek_UPSILON, 0x038E,
    XK_Greek_OMEGA, 0x038F,
    XK_Greek_alpha, 0x03AC,
    XK_Greek_epsilon, 0x03AD,
    XK_Greek_eta, 0x03AE,
    XK_Greek_iota, 0x03AF,
    XK_Greek_omicron, 0x03CC,
    XK_Greek_upsilon, 0x03CD,
    XK_Greek_omega, 0x03CE,
    XK_Sabovedot, 0x1E64,
    XK_sabovedot, 0x1E65,
    XK_dead_acute, 0x00B4,
    XK_dead_stroke, XK_O, 0x01FE,
    XK_dead_stroke, XK_o, 0x01FF,
    XK_dead_diaeresis, XK_space, 0x0385,
    XK_dead_diaeresis, XK_Greek_iota, 0x0390,
    XK_dead_diaeresis, XK_Greek_upsilon, 0x03B0,
    XK_dead_psili, XK_Greek_ALPHA, 0x1F0C,
    XK_dead_psili, XK_Greek_EPSILON, 0x1F1C,
    XK_dead_psili, XK_Greek_ETA, 0x1F2C,
    XK_dead_psili, XK_Greek_IOTA, 0x1F3C,
    XK_dead_psili, XK_Greek_OMICRON, 0x1F4C,
    XK_dead_psili, XK_Greek_OMEGA, 0x1F6C,
    XK_dead_psili, XK_Greek_alpha, 0x1F04,
    XK_dead_psili, XK_Greek_epsilon, 0x1F14,
    XK_dead_psili, XK_Greek_eta, 0x1F24,
    XK_dead_psili, XK_Greek_iota, 0x1F34,
    XK_dead_psili, XK_Greek_omicron, 0x1F44,
    XK_dead_psili, XK_Greek_upsilon, 0x1F54,
    XK_dead_psili, XK_Greek_omega, 0x1F64,
    XK_dead_dasia, XK_Greek_ALPHA, 0x1F0D,
    XK_dead_dasia, XK_Greek_EPSILON, 0x1F1D,
    XK_dead_dasia, XK_Greek_ETA, 0x1F2D,
    XK_dead_dasia, XK_Greek_IOTA, 0x1F3D,
    XK_dead_dasia, XK_Greek_OMICRON, 0x1F4D,
    XK_dead_dasia, XK_Greek_UPSILON, 0x1F5D,
    XK_dead_dasia, XK_Greek_OMEGA, 0x1F6D,
    XK_dead_dasia, XK_Greek_alpha, 0x1F05,
    XK_dead_dasia, XK_Greek_epsilon, 0x1F15,
    XK_dead_dasia, XK_Greek_eta, 0x1F25,
    XK_dead_dasia, XK_Greek_iota, 0x1F35,
    XK_dead_dasia, XK_Greek_omicron, 0x1F45,
    XK_dead_dasia, XK_Greek_upsilon, 0x1F55,
    XK_dead_dasia, XK_Greek_omega, 0x1F65,
    XK_Multi_key, XK_quotedbl, XK_I, 0x1E2E,
    XK_Multi_key, XK_quotedbl, XK_U, 0x01D7,
    XK_Multi_key, XK_quotedbl, XK_i, 0x1E2F,
    XK_Multi_key, XK_quotedbl, XK_u, 0x01D8,
    XK_Multi_key, XK_quotedbl, XK_Greek_iota, 0x0390,
    XK_Multi_key, XK_quotedbl, XK_Greek_upsilon, 0x03B0,
    XK_Multi_key, XK_parenleft, XK_Greek_ALPHA, 0x1F0D,
    XK_Multi_key, XK_parenleft, XK_Greek_EPSILON, 0x1F1D,
    XK_Multi_key, XK_parenleft, XK_Greek_ETA, 0x1F2D,
    XK_Multi_key, XK_parenleft, XK_Greek_IOTA, 0x1F3D,
    XK_Multi_key, XK_parenleft, XK_Greek_OMICRON, 0x1F4D,
    XK_Multi_key, XK_parenleft, XK_Greek_UPSILON, 0x1F5D,
    XK_Multi_key, XK_parenleft, XK_Greek_OMEGA, 0x1F6D,
    XK_Multi_key, XK_parenleft, XK_Greek_alpha, 0x1F05,
    XK_Multi_key, XK_parenleft, XK_Greek_epsilon, 0x1F15,
    XK_Multi_key, XK_parenleft, XK_Greek_eta, 0x1F25,
    XK_Multi_key, XK_parenleft, XK_Greek_iota, 0x1F35,
    XK_Multi_key, XK_parenleft, XK_Greek_omicron, 0x1F45,
    XK_Multi_key, XK_parenleft, XK_Greek_upsilon, 0x1F55,
    XK_Multi_key, XK_parenleft, XK_Greek_omega, 0x1F65,
    XK_Multi_key, XK_parenright, XK_Greek_ALPHA, 0x1F0C,
    XK_Multi_key, XK_parenright, XK_Greek_EPSILON, 0x1F1C,
    XK_Multi_key, XK_parenright, XK_Greek_ETA, 0x1F2C,
    XK_Multi_key, XK_parenright, XK_Greek_IOTA, 0x1F3C,
    XK_Multi_key, XK_parenright, XK_Greek_OMICRON, 0x1F4C,
    XK_Multi_key, XK_parenright, XK_Greek_OMEGA, 0x1F6C,
    XK_Multi_key, XK_parenright, XK_Greek_alpha, 0x1F04,
    XK_Multi_key, XK_parenright, XK_Greek_epsilon, 0x1F14,
    XK_Multi_key, XK_parenright, XK_Greek_eta, 0x1F24,
    XK_Multi_key, XK_parenright, XK_Greek_iota, 0x1F34,
    XK_Multi_key, XK_parenright, XK_Greek_omicron, 0x1F44,
    XK_Multi_key, XK_parenright, XK_Greek_upsilon, 0x1F54,
    XK_Multi_key, XK_parenright, XK_Greek_omega, 0x1F64,
    XK_Multi_key, XK_plus, XK_O, 0x1EDA,
    XK_Multi_key, XK_plus, XK_U, 0x1EE8,
    XK_Multi_key, XK_plus, XK_o, 0x1EDB,
    XK_Multi_key, XK_plus, XK_u, 0x1EE9,
    XK_Multi_key, XK_comma, XK_C, 0x1E08,
    XK_Multi_key, XK_comma, XK_c, 0x1E09,
    XK_Multi_key, XK_slash, XK_O, 0x01FE,
    XK_Multi_key, XK_slash, XK_o, 0x01FF,
    XK_Multi_key, XK_U, XK_A, 0x1EAE,
    XK_Multi_key, XK_U, XK_a, 0x1EAF,
    XK_Multi_key, XK_asciicircum, XK_A, 0x1EA4,
    XK_Multi_key, XK_asciicircum, XK_E, 0x1EBE,
    XK_Multi_key, XK_asciicircum, XK_O, 0x1ED0,
    XK_Multi_key, XK_asciicircum, XK_a, 0x1EA5,
    XK_Multi_key, XK_asciicircum, XK_e, 0x1EBF,
    XK_Multi_key, XK_asciicircum, XK_o, 0x1ED1,
    XK_Multi_key, XK_underscore, XK_E, 0x1E16,
    XK_Multi_key, XK_underscore, XK_O, 0x1E52,
    XK_Multi_key, XK_underscore, XK_e, 0x1E17,
    XK_Multi_key, XK_underscore, XK_o, 0x1E53,
    XK_Multi_key, XK_b, XK_A, 0x1EAE,
    XK_Multi_key, XK_b, XK_a, 0x1EAF,
    XK_Multi_key, XK_o, XK_A, 0x01FA,
    XK_Multi_key, XK_o, XK_a, 0x01FB,
    XK_Multi_key, XK_asciitilde, XK_O, 0x1E4C,
    XK_Multi_key, XK_asciitilde, XK_U, 0x1E78,
    XK_Multi_key, XK_asciitilde, XK_o, 0x1E4D,
    XK_Multi_key, XK_asciitilde, XK_u, 0x1E79,
    XK_Multi_key, XK_macron, XK_E, 0x1E16,
    XK_Multi_key, XK_macron, XK_O, 0x1E52,
    XK_Multi_key, XK_macron, XK_e, 0x1E17,
    XK_Multi_key, XK_macron, XK_o, 0x1E53,
    XK_Multi_key, XK_cedilla, XK_C, 0x1E08,
    XK_Multi_key, XK_cedilla, XK_c, 0x1E09,
    XK_Multi_key, XK_KP_Divide, XK_O, 0x01FE,
    XK_Multi_key, XK_KP_Divide, XK_o, 0x01FF,
    XK_space, 0x005E,
    XK_parenleft, 0x207D,
    XK_parenright, 0x207E,
    XK_plus, 0x207A,
    XK_minus, 0x207B,
    XK_0, 0x2070,
    XK_1, 0x00B9,
    XK_2, 0x00B2,
    XK_3, 0x00B3,
    XK_4, 0x2074,
    XK_5, 0x2075,
    XK_6, 0x2076,
    XK_7, 0x2077,
    XK_8, 0x2078,
    XK_9, 0x2079,
    XK_equal, 0x207C,
    XK_nobreakspace, 0x0302,
    XK_Agrave, 0x1EA6,
    XK_Aacute, 0x1EA4,
    XK_Atilde, 0x1EAA,
    XK_Egrave, 0x1EC0,
    XK_Eacute, 0x1EBE,
    XK_Ograve, 0x1ED2,
    XK_Oacute, 0x1ED0,
    XK_Otilde, 0x1ED6,
    XK_agrave, 0x1EA7,
    XK_aacute, 0x1EA5,
    XK_atilde, 0x1EAB,
    XK_egrave, 0x1EC1,
    XK_eacute, 0x1EBF,
    XK_ograve, 0x1ED3,
    XK_oacute, 0x1ED1,
    XK_otilde, 0x1ED7,
    XK_Ahook, 0x1EA8,
    XK_ahook, 0x1EA9,
    XK_Ehook, 0x1EC2,
    XK_ehook, 0x1EC3,
    XK_Etilde, 0x1EC4,
    XK_etilde, 0x1EC5,
    XK_Ohook, 0x1ED4,
    XK_ohook, 0x1ED5,
    0x2212, 0x207B,
    0x4E00, 0x3192,
    0x4E01, 0x319C,
    0x4E09, 0x3194,
    0x4E0A, 0x3196,
    0x4E0B, 0x3198,
    0x4E19, 0x319B,
    0x4E2D, 0x3197,
    0x4E59, 0x319A,
    0x4E8C, 0x3193,
    0x4EBA, 0x319F,
    0x56DB, 0x3195,
    0x5730, 0x319E,
    0x5929, 0x319D,
    0x7532, 0x3199,
    XK_dead_circumflex, 0x005E,
    XK_KP_Space, 0x00B2,
    XK_KP_Add, 0x207A,
    XK_KP_0, 0x2070,
    XK_KP_1, 0x00B9,
    XK_KP_2, 0x00B2,
    XK_KP_3, 0x00B3,
    XK_KP_4, 0x2074,
    XK_KP_5, 0x2075,
    XK_KP_6, 0x2076,
    XK_KP_7, 0x2077,
    XK_KP_8, 0x2078,
    XK_KP_9, 0x2079,
    XK_KP_Equal, 0x207C,
    XK_Multi_key, XK_exclam, XK_A, 0x1EAC,
    XK_Multi_key, XK_exclam, XK_E, 0x1EC6,
    XK_Multi_key, XK_exclam, XK_O, 0x1ED8,
    XK_Multi_key, XK_exclam, XK_a, 0x1EAD,
    XK_Multi_key, XK_exclam, XK_e, 0x1EC7,
    XK_Multi_key, XK_exclam, XK_o, 0x1ED9,
    XK_Multi_key, XK_S, XK_M, 0x2120,
    XK_Multi_key, XK_S, XK_m, 0x2120,
    XK_Multi_key, XK_T, XK_M, 0x2122,
    XK_Multi_key, XK_T, XK_m, 0x2122,
    XK_Multi_key, XK_underscore, XK_a, 0x00AA,
    XK_Multi_key, XK_underscore, XK_h, 0x02B0,
    XK_Multi_key, XK_underscore, XK_i, 0x2071,
    XK_Multi_key, XK_underscore, XK_j, 0x02B2,
    XK_Multi_key, XK_underscore, XK_l, 0x02E1,
    XK_Multi_key, XK_underscore, XK_n, 0x207F,
    XK_Multi_key, XK_underscore, XK_o, 0x00BA,
    XK_Multi_key, XK_underscore, XK_r, 0x02B3,
    XK_Multi_key, XK_underscore, XK_s, 0x02E2,
    XK_Multi_key, XK_underscore, XK_w, 0x02B7,
    XK_Multi_key, XK_underscore, XK_x, 0x02E3,
    XK_Multi_key, XK_underscore, XK_y, 0x02B8,
    XK_Multi_key, XK_underscore, 0x0263, 0x02E0,
    XK_Multi_key, XK_underscore, 0x0266, 0x02B1,
    XK_Multi_key, XK_underscore, 0x0279, 0x02B4,
    XK_Multi_key, XK_underscore, 0x027B, 0x02B5,
    XK_Multi_key, XK_underscore, 0x0281, 0x02B6,
    XK_Multi_key, XK_underscore, 0x0295, 0x02E4,
    XK_Multi_key, XK_s, XK_M, 0x2120,
    XK_Multi_key, XK_s, XK_m, 0x2120,
    XK_Multi_key, XK_t, XK_M, 0x2122,
    XK_Multi_key, XK_t, XK_m, 0x2122,
    XK_Multi_key, XK_underbar, XK_a, 0x00AA,
    XK_Multi_key, XK_underbar, XK_h, 0x02B0,
    XK_Multi_key, XK_underbar, XK_i, 0x2071,
    XK_Multi_key, XK_underbar, XK_j, 0x02B2,
    XK_Multi_key, XK_underbar, XK_l, 0x02E1,
    XK_Multi_key, XK_underbar, XK_n, 0x207F,
    XK_Multi_key, XK_underbar, XK_o, 0x00BA,
    XK_Multi_key, XK_underbar, XK_r, 0x02B3,
    XK_Multi_key, XK_underbar, XK_s, 0x02E2,
    XK_Multi_key, XK_underbar, XK_w, 0x02B7,
    XK_Multi_key, XK_underbar, XK_x, 0x02E3,
    XK_Multi_key, XK_underbar, XK_y, 0x02B8,
    XK_Multi_key, XK_underbar, 0x0263, 0x02E0,
    XK_Multi_key, XK_underbar, 0x0266, 0x02B1,
    XK_Multi_key, XK_underbar, 0x0279, 0x02B4,
    XK_Multi_key, XK_underbar, 0x027B, 0x02B5,
    XK_Multi_key, XK_underbar, 0x0281, 0x02B6,
    XK_Multi_key, XK_underbar, 0x0295, 0x02E4,
    XK_space, 0x007E,
    XK_less, 0x2272,
    XK_equal, 0x2243,
    XK_greater, 0x2273,
    XK_Oacute, 0x1E4C,
    XK_Odiaeresis, 0x1E4E,
    XK_Uacute, 0x1E78,
    XK_oacute, 0x1E4D,
    XK_odiaeresis, 0x1E4F,
    XK_uacute, 0x1E79,
    XK_Abreve, 0x1EB4,
    XK_abreve, 0x1EB5,
    XK_Omacron, 0x022C,
    XK_omacron, 0x022D,
    XK_Greek_iotadieresis, 0x1FD7,
    XK_Greek_upsilondieresis, 0x1FE7,
    XK_Greek_alpha, 0x1FB6,
    XK_Greek_eta, 0x1FC6,
    XK_Greek_iota, 0x1FD6,
    XK_Greek_upsilon, 0x1FE6,
    XK_Greek_omega, 0x1FF6,
    0x1F00, 0x1F06,
    0x1F01, 0x1F07,
    0x1F08, 0x1F0E,
    0x1F09, 0x1F0F,
    0x1F20, 0x1F26,
    0x1F21, 0x1F27,
    0x1F28, 0x1F2E,
    0x1F29, 0x1F2F,
    0x1F30, 0x1F36,
    0x1F31, 0x1F37,
    0x1F38, 0x1F3E,
    0x1F39, 0x1F3F,
    0x1F50, 0x1F56,
    0x1F51, 0x1F57,
    0x1F59, 0x1F5F,
    0x1F60, 0x1F66,
    0x1F61, 0x1F67,
    0x1F68, 0x1F6E,
    0x1F69, 0x1F6F,
    XK_dead_tilde, 0x007E,
    XK_dead_diaeresis, XK_Greek_iota, 0x1FD7,
    XK_dead_diaeresis, XK_Greek_upsilon, 0x1FE7,
    XK_dead_psili, XK_Greek_ALPHA, 0x1F0E,
    XK_dead_psili, XK_Greek_ETA, 0x1F2E,
    XK_dead_psili, XK_Greek_IOTA, 0x1F3E,
    XK_dead_psili, XK_Greek_OMEGA, 0x1F6E,
    XK_dead_psili, XK_Greek_alpha, 0x1F06,
    XK_dead_psili, XK_Greek_eta, 0x1F26,
    XK_dead_psili, XK_Greek_iota, 0x1F36,
    XK_dead_psili, XK_Greek_upsilon, 0x1F56,
    XK_dead_psili, XK_Greek_omega, 0x1F66,
    XK_dead_dasia, XK_Greek_ALPHA, 0x1F0F,
    XK_dead_dasia, XK_Greek_ETA, 0x1F2F,
    XK_dead_dasia, XK_Greek_IOTA, 0x1F3F,
    XK_dead_dasia, XK_Greek_UPSILON, 0x1F5F,
    XK_dead_dasia, XK_Greek_OMEGA, 0x1F6F,
    XK_dead_dasia, XK_Greek_alpha, 0x1F07,
    XK_dead_dasia, XK_Greek_eta, 0x1F27,
    XK_dead_dasia, XK_Greek_iota, 0x1F37,
    XK_dead_dasia, XK_Greek_upsilon, 0x1F57,
    XK_dead_dasia, XK_Greek_omega, 0x1F67,
    XK_Multi_key, XK_quotedbl, XK_Greek_iota, 0x1FD7,
    XK_Multi_key, XK_quotedbl, XK_Greek_upsilon, 0x1FE7,
    XK_Multi_key, XK_parenleft, XK_Greek_ALPHA, 0x1F0F,
    XK_Multi_key, XK_parenleft, XK_Greek_ETA, 0x1F2F,
    XK_Multi_key, XK_parenleft, XK_Greek_IOTA, 0x1F3F,
    XK_Multi_key, XK_parenleft, XK_Greek_UPSILON, 0x1F5F,
    XK_Multi_key, XK_parenleft, XK_Greek_OMEGA, 0x1F6F,
    XK_Multi_key, XK_parenleft, XK_Greek_alpha, 0x1F07,
    XK_Multi_key, XK_parenleft, XK_Greek_eta, 0x1F27,
    XK_Multi_key, XK_parenleft, XK_Greek_iota, 0x1F37,
    XK_Multi_key, XK_parenleft, XK_Greek_upsilon, 0x1F57,
    XK_Multi_key, XK_parenleft, XK_Greek_omega, 0x1F67,
    XK_Multi_key, XK_parenright, XK_Greek_ALPHA, 0x1F0E,
    XK_Multi_key, XK_parenright, XK_Greek_ETA, 0x1F2E,
    XK_Multi_key, XK_parenright, XK_Greek_IOTA, 0x1F3E,
    XK_Multi_key, XK_parenright, XK_Greek_OMEGA, 0x1F6E,
    XK_Multi_key, XK_parenright, XK_Greek_alpha, 0x1F06,
    XK_Multi_key, XK_parenright, XK_Greek_eta, 0x1F26,
    XK_Multi_key, XK_parenright, XK_Greek_iota, 0x1F36,
    XK_Multi_key, XK_parenright, XK_Greek_upsilon, 0x1F56,
    XK_Multi_key, XK_parenright, XK_Greek_omega, 0x1F66,
    XK_Multi_key, XK_plus, XK_O, 0x1EE0,
    XK_Multi_key, XK_plus, XK_U, 0x1EEE,
    XK_Multi_key, XK_plus, XK_o, 0x1EE1,
    XK_Multi_key, XK_plus, XK_u, 0x1EEF,
    XK_Multi_key, XK_U, XK_A, 0x1EB4,
    XK_Multi_key, XK_U, XK_a, 0x1EB5,
    XK_Multi_key, XK_asciicircum, XK_A, 0x1EAA,
    XK_Multi_key, XK_asciicircum, XK_E, 0x1EC4,
    XK_Multi_key, XK_asciicircum, XK_O, 0x1ED6,
    XK_Multi_key, XK_asciicircum, XK_a, 0x1EAB,
    XK_Multi_key, XK_asciicircum, XK_e, 0x1EC5,
    XK_Multi_key, XK_asciicircum, XK_o, 0x1ED7,
    XK_Multi_key, XK_b, XK_A, 0x1EB4,
    XK_Multi_key, XK_b, XK_a, 0x1EB5,
    XK_space, 0x00AF,
    XK_V, 0x01D5,
    XK_v, 0x01D6,
    XK_nobreakspace, 0x0304,
    XK_Egrave, 0x1E14,
    XK_Eacute, 0x1E16,
    XK_Ograve, 0x1E50,
    XK_Oacute, 0x1E52,
    XK_egrave, 0x1E15,
    XK_eacute, 0x1E17,
    XK_ograve, 0x1E51,
    XK_oacute, 0x1E53,
    XK_Cyrillic_i, 0x04E3,
    XK_Cyrillic_u, 0x04EF,
    XK_Cyrillic_I, 0x04E2,
    XK_Cyrillic_U, 0x04EE,
    XK_Greek_ALPHA, 0x1FB9,
    XK_Greek_IOTA, 0x1FD9,
    XK_Greek_UPSILON, 0x1FE9,
    XK_Greek_alpha, 0x1FB1,
    XK_Greek_iota, 0x1FD1,
    XK_Greek_upsilon, 0x1FE1,
    XK_dead_macron, 0x00AF,
    XK_Multi_key, XK_exclam, XK_L, 0x1E38,
    XK_Multi_key, XK_exclam, XK_R, 0x1E5C,
    XK_Multi_key, XK_exclam, XK_l, 0x1E39,
    XK_Multi_key, XK_exclam, XK_r, 0x1E5D,
    XK_Multi_key, XK_quotedbl, XK_A, 0x01DE,
    XK_Multi_key, XK_quotedbl, XK_O, 0x022A,
    XK_Multi_key, XK_quotedbl, XK_U, 0x01D5,
    XK_Multi_key, XK_quotedbl, XK_a, 0x01DF,
    XK_Multi_key, XK_quotedbl, XK_o, 0x022B,
    XK_Multi_key, XK_quotedbl, XK_u, 0x01D6,
    XK_Multi_key, XK_period, XK_A, 0x01E0,
    XK_Multi_key, XK_period, XK_O, 0x0230,
    XK_Multi_key, XK_period, XK_a, 0x01E1,
    XK_Multi_key, XK_period, XK_o, 0x0231,
    XK_Multi_key, XK_semicolon, XK_O, 0x01EC,
    XK_Multi_key, XK_semicolon, XK_o, 0x01ED,
    XK_Multi_key, XK_asciitilde, XK_O, 0x022C,
    XK_Multi_key, XK_asciitilde, XK_o, 0x022D,
    XK_space, 0x02D8,
    XK_nobreakspace, 0x0306,
    XK_Agrave, 0x1EB0,
    XK_Aacute, 0x1EAE,
    XK_Atilde, 0x1EB4,
    XK_agrave, 0x1EB1,
    XK_aacute, 0x1EAF,
    XK_atilde, 0x1EB5,
    XK_Cyrillic_a, 0x04D1,
    XK_Cyrillic_ie, 0x04D7,
    XK_Cyrillic_i, 0x0439,
    XK_Cyrillic_u, 0x045E,
    XK_Cyrillic_zhe, 0x04C2,
    XK_Cyrillic_A, 0x04D0,
    XK_Cyrillic_IE, 0x04D6,
    XK_Cyrillic_I, 0x0419,
    XK_Cyrillic_U, 0x040E,
    XK_Cyrillic_ZHE, 0x04C1,
    XK_Greek_ALPHA, 0x1FB8,
    XK_Greek_IOTA, 0x1FD8,
    XK_Greek_UPSILON, 0x1FE8,
    XK_Greek_alpha, 0x1FB0,
    XK_Greek_iota, 0x1FD0,
    XK_Greek_upsilon, 0x1FE0,
    XK_Ahook, 0x1EB2,
    XK_ahook, 0x1EB3,
    XK_dead_breve, 0x02D8,
    XK_Multi_key, XK_exclam, XK_A, 0x1EB6,
    XK_Multi_key, XK_exclam, XK_a, 0x1EB7,
    XK_Multi_key, XK_comma, XK_E, 0x1E1C,
    XK_Multi_key, XK_comma, XK_e, 0x1E1D,
    XK_Multi_key, XK_cedilla, XK_E, 0x1E1C,
    XK_Multi_key, XK_cedilla, XK_e, 0x1E1D,
    XK_space, 0x02D9,
    XK_L, 0x013F,
    XK_i, 0x0131,
    XK_j, 0x0237,
    XK_l, 0x0140,
    XK_nobreakspace, 0x0307,
    XK_Sacute, 0x1E64,
    XK_Scaron, 0x1E66,
    XK_sacute, 0x1E65,
    XK_scaron, 0x1E67,
    XK_Amacron, 0x01E0,
    XK_Omacron, 0x0230,
    XK_amacron, 0x01E1,
    XK_omacron, 0x0231,
    XK_dead_abovedot, 0x02D9,
    XK_dead_stroke, XK_j, 0x025F,
    XK_Multi_key, XK_exclam, XK_S, 0x1E68,
    XK_Multi_key, XK_exclam, XK_s, 0x1E69,
    XK_Multi_key, XK_apostrophe, XK_S, 0x1E64,
    XK_Multi_key, XK_apostrophe, XK_s, 0x1E65,
    XK_Multi_key, XK_c, XK_S, 0x1E66,
    XK_Multi_key, XK_c, XK_s, 0x1E67,
    XK_Multi_key, XK_acute, XK_S, 0x1E64,
    XK_Multi_key, XK_acute, XK_s, 0x1E65,
    XK_space, 0x0022,
    XK_apostrophe, 0x0344,
    XK_nobreakspace, 0x0308,
    XK_acute, 0x0344,
    XK_Iacute, 0x1E2E,
    XK_Ugrave, 0x01DB,
    XK_Uacute, 0x01D7,
    XK_iacute, 0x1E2F,
    XK_ugrave, 0x01DC,
    XK_uacute, 0x01D8,
    0x01D3, 0x01D9,
    0x01D4, 0x01DA,
    XK_Amacron, 0x01DE,
    XK_Umacron, 0x1E7A,
    XK_amacron, 0x01DF,
    XK_omacron, 0x022B,
    XK_umacron, 0x1E7B,
    XK_Ukrainian_i, 0x0457,
    XK_Ukrainian_I, 0x0407,
    XK_Cyrillic_a, 0x04D3,
    XK_Cyrillic_ie, 0x0451,
    XK_Cyrillic_i, 0x04E5,
    XK_Cyrillic_o, 0x04E7,
    XK_Cyrillic_u, 0x04F1,
    XK_Cyrillic_zhe, 0x04DD,
    XK_Cyrillic_yeru, 0x04F9,
    XK_Cyrillic_ze, 0x04DF,
    XK_Cyrillic_e, 0x04ED,
    XK_Cyrillic_che, 0x04F5,
    XK_Cyrillic_A, 0x04D2,
    XK_Cyrillic_IE, 0x0401,
    XK_Cyrillic_I, 0x04E4,
    XK_Cyrillic_O, 0x04E6,
    XK_Cyrillic_U, 0x04F0,
    XK_Cyrillic_ZHE, 0x04DC,
    XK_Cyrillic_YERU, 0x04F8,
    XK_Cyrillic_ZE, 0x04DE,
    XK_Cyrillic_E, 0x04EC,
    XK_Cyrillic_CHE, 0x04F4,
    XK_Greek_IOTA, 0x03AA,
    XK_Greek_UPSILON, 0x03AB,
    XK_Greek_iota, 0x03CA,
    XK_Greek_upsilon, 0x03CB,
    XK_dead_diaeresis, 0x00A8,
    XK_dead_acute, XK_space, 0x0385,
    XK_dead_acute, XK_Greek_iota, 0x0390,
    XK_dead_acute, XK_Greek_upsilon, 0x03B0,
    XK_Multi_key, XK_underscore, XK_U, 0x1E7A,
    XK_Multi_key, XK_underscore, XK_u, 0x1E7B,
    XK_Multi_key, XK_asciitilde, XK_O, 0x1E4E,
    XK_Multi_key, XK_asciitilde, XK_o, 0x1E4F,
    XK_Multi_key, XK_macron, XK_U, 0x1E7A,
    XK_Multi_key, XK_macron, XK_u, 0x1E7B,
    XK_space, 0x00B0,
    XK_nobreakspace, 0x030A,
    XK_Aacute, 0x01FA,
    XK_aacute, 0x01FB,
    XK_dead_abovering, 0x00B0,
    XK_space, 0x02DD,
    XK_nobreakspace, 0x030B,
    XK_Cyrillic_u, 0x04F3,
    XK_Cyrillic_U, 0x04F2,
    XK_dead_doubleacute, 0x02DD,
    XK_space, 0x02C7,
    XK_parenleft, 0x208D,
    XK_parenright, 0x208E,
    XK_plus, 0x208A,
    XK_minus, 0x208B,
    XK_equal, 0x208C,
    XK_V, 0x01D9,
    XK_v, 0x01DA,
    XK_nobreakspace, 0x030C,
    0x01F2, 0x01C5,
    XK_Sabovedot, 0x1E66,
    XK_sabovedot, 0x1E67,
    XK_dead_caron, 0x02C7,
    XK_Multi_key, XK_quotedbl, XK_U, 0x01D9,
    XK_Multi_key, XK_quotedbl, XK_u, 0x01DA,
    XK_space, 0x00B8,
    XK_nobreakspace, 0x0327,
    XK_cent, 0x20B5,
    XK_Cacute, 0x1E08,
    XK_cacute, 0x1E09,
    XK_ColonSign, 0x20B5,
    XK_dead_cedilla, 0x00B8,
    XK_space, 0x02DB,
    XK_nobreakspace, 0x0328,
    XK_Omacron, 0x01EC,
    XK_omacron, 0x01ED,
    XK_dead_ogonek, 0x02DB,
    XK_space, 0x037A,
    XK_Greek_alphaaccent, 0x1FB4,
    XK_Greek_etaaccent, 0x1FC4,
    XK_Greek_omegaaccent, 0x1FF4,
    XK_Greek_ALPHA, 0x1FBC,
    XK_Greek_ETA, 0x1FCC,
    XK_Greek_OMEGA, 0x1FFC,
    XK_Greek_alpha, 0x1FB3,
    XK_Greek_eta, 0x1FC3,
    XK_Greek_omega, 0x1FF3,
    XK_dead_iota, 0x037A,
    XK_dead_grave, XK_Greek_alpha, 0x1FB2,
    XK_dead_grave, XK_Greek_eta, 0x1FC2,
    XK_dead_grave, XK_Greek_omega, 0x1FF2,
    XK_dead_acute, XK_Greek_alpha, 0x1FB4,
    XK_dead_acute, XK_Greek_eta, 0x1FC4,
    XK_dead_acute, XK_Greek_omega, 0x1FF4,
    XK_dead_tilde, XK_Greek_alpha, 0x1FB7,
    XK_dead_tilde, XK_Greek_eta, 0x1FC7,
    XK_dead_tilde, XK_Greek_omega, 0x1FF7,
    XK_dead_tilde, 0x1F00, 0x1F86,
    XK_dead_tilde, 0x1F01, 0x1F87,
    XK_dead_tilde, 0x1F08, 0x1F8E,
    XK_dead_tilde, 0x1F09, 0x1F8F,
    XK_dead_tilde, 0x1F20, 0x1F96,
    XK_dead_tilde, 0x1F21, 0x1F97,
    XK_dead_tilde, 0x1F28, 0x1F9E,
    XK_dead_tilde, 0x1F29, 0x1F9F,
    XK_dead_tilde, 0x1F60, 0x1FA6,
    XK_dead_tilde, 0x1F61, 0x1FA7,
    XK_dead_tilde, 0x1F68, 0x1FAE,
    XK_dead_tilde, 0x1F69, 0x1FAF,
    XK_dead_psili, XK_Greek_ALPHA, 0x1F88,
    XK_dead_psili, XK_Greek_ETA, 0x1F98,
    XK_dead_psili, XK_Greek_OMEGA, 0x1FA8,
    XK_dead_psili, XK_Greek_alpha, 0x1F80,
    XK_dead_psili, XK_Greek_eta, 0x1F90,
    XK_dead_psili, XK_Greek_omega, 0x1FA0,
    XK_dead_dasia, XK_Greek_ALPHA, 0x1F89,
    XK_dead_dasia, XK_Greek_ETA, 0x1F99,
    XK_dead_dasia, XK_Greek_OMEGA, 0x1FA9,
    XK_dead_dasia, XK_Greek_alpha, 0x1F81,
    XK_dead_dasia, XK_Greek_eta, 0x1F91,
    XK_dead_dasia, XK_Greek_omega, 0x1FA1,
    XK_dead_grave, XK_dead_psili, XK_Greek_ALPHA, 0x1F8A,
    XK_dead_grave, XK_dead_psili, XK_Greek_ETA, 0x1F9A,
    XK_dead_grave, XK_dead_psili, XK_Greek_OMEGA, 0x1FAA,
    XK_dead_grave, XK_dead_psili, XK_Greek_alpha, 0x1F82,
    XK_dead_grave, XK_dead_psili, XK_Greek_eta, 0x1F92,
    XK_dead_grave, XK_dead_psili, XK_Greek_omega, 0x1FA2,
    XK_dead_grave, XK_dead_dasia, XK_Greek_ALPHA, 0x1F8B,
    XK_dead_grave, XK_dead_dasia, XK_Greek_ETA, 0x1F9B,
    XK_dead_grave, XK_dead_dasia, XK_Greek_OMEGA, 0x1FAB,
    XK_dead_grave, XK_dead_dasia, XK_Greek_alpha, 0x1F83,
    XK_dead_grave, XK_dead_dasia, XK_Greek_eta, 0x1F93,
    XK_dead_grave, XK_dead_dasia, XK_Greek_omega, 0x1FA3,
    XK_dead_acute, XK_dead_psili, XK_Greek_ALPHA, 0x1F8C,
    XK_dead_acute, XK_dead_psili, XK_Greek_ETA, 0x1F9C,
    XK_dead_acute, XK_dead_psili, XK_Greek_OMEGA, 0x1FAC,
    XK_dead_acute, XK_dead_psili, XK_Greek_alpha, 0x1F84,
    XK_dead_acute, XK_dead_psili, XK_Greek_eta, 0x1F94,
    XK_dead_acute, XK_dead_psili, XK_Greek_omega, 0x1FA4,
    XK_dead_acute, XK_dead_dasia, XK_Greek_ALPHA, 0x1F8D,
    XK_dead_acute, XK_dead_dasia, XK_Greek_ETA, 0x1F9D,
    XK_dead_acute, XK_dead_dasia, XK_Greek_OMEGA, 0x1FAD,
    XK_dead_acute, XK_dead_dasia, XK_Greek_alpha, 0x1F85,
    XK_dead_acute, XK_dead_dasia, XK_Greek_eta, 0x1F95,
    XK_dead_acute, XK_dead_dasia, XK_Greek_omega, 0x1FA5,
    XK_dead_tilde, XK_dead_psili, XK_Greek_ALPHA, 0x1F8E,
    XK_dead_tilde, XK_dead_psili, XK_Greek_ETA, 0x1F9E,
    XK_dead_tilde, XK_dead_psili, XK_Greek_OMEGA, 0x1FAE,
    XK_dead_tilde, XK_dead_psili, XK_Greek_alpha, 0x1F86,
    XK_dead_tilde, XK_dead_psili, XK_Greek_eta, 0x1F96,
    XK_dead_tilde, XK_dead_psili, XK_Greek_omega, 0x1FA6,
    XK_dead_tilde, XK_dead_dasia, XK_Greek_ALPHA, 0x1F8F,
    XK_dead_tilde, XK_dead_dasia, XK_Greek_ETA, 0x1F9F,
    XK_dead_tilde, XK_dead_dasia, XK_Greek_OMEGA, 0x1FAF,
    XK_dead_tilde, XK_dead_dasia, XK_Greek_alpha, 0x1F87,
    XK_dead_tilde, XK_dead_dasia, XK_Greek_eta, 0x1F97,
    XK_dead_tilde, XK_dead_dasia, XK_Greek_omega, 0x1FA7,
    XK_Multi_key, XK_apostrophe, XK_Greek_alpha, 0x1FB4,
    XK_Multi_key, XK_apostrophe, XK_Greek_eta, 0x1FC4,
    XK_Multi_key, XK_apostrophe, XK_Greek_omega, 0x1FF4,
    XK_Multi_key, XK_apostrophe, 0x1F00, 0x1F84,
    XK_Multi_key, XK_apostrophe, 0x1F01, 0x1F85,
    XK_Multi_key, XK_apostrophe, 0x1F08, 0x1F8C,
    XK_Multi_key, XK_apostrophe, 0x1F09, 0x1F8D,
    XK_Multi_key, XK_apostrophe, 0x1F20, 0x1F94,
    XK_Multi_key, XK_apostrophe, 0x1F21, 0x1F95,
    XK_Multi_key, XK_apostrophe, 0x1F28, 0x1F9C,
    XK_Multi_key, XK_apostrophe, 0x1F29, 0x1F9D,
    XK_Multi_key, XK_apostrophe, 0x1F60, 0x1FA4,
    XK_Multi_key, XK_apostrophe, 0x1F61, 0x1FA5,
    XK_Multi_key, XK_apostrophe, 0x1F68, 0x1FAC,
    XK_Multi_key, XK_apostrophe, 0x1F69, 0x1FAD,
    XK_Multi_key, XK_parenleft, XK_Greek_ALPHA, 0x1F89,
    XK_Multi_key, XK_parenleft, XK_Greek_ETA, 0x1F99,
    XK_Multi_key, XK_parenleft, XK_Greek_OMEGA, 0x1FA9,
    XK_Multi_key, XK_parenleft, XK_Greek_alpha, 0x1F81,
    XK_Multi_key, XK_parenleft, XK_Greek_eta, 0x1F91,
    XK_Multi_key, XK_parenleft, XK_Greek_omega, 0x1FA1,
    XK_Multi_key, XK_parenright, XK_Greek_ALPHA, 0x1F88,
    XK_Multi_key, XK_parenright, XK_Greek_ETA, 0x1F98,
    XK_Multi_key, XK_parenright, XK_Greek_OMEGA, 0x1FA8,
    XK_Multi_key, XK_parenright, XK_Greek_alpha, 0x1F80,
    XK_Multi_key, XK_parenright, XK_Greek_eta, 0x1F90,
    XK_Multi_key, XK_parenright, XK_Greek_omega, 0x1FA0,
    XK_Multi_key, XK_grave, XK_Greek_alpha, 0x1FB2,
    XK_Multi_key, XK_grave, XK_Greek_eta, 0x1FC2,
    XK_Multi_key, XK_grave, XK_Greek_omega, 0x1FF2,
    XK_Multi_key, XK_grave, 0x1F00, 0x1F82,
    XK_Multi_key, XK_grave, 0x1F01, 0x1F83,
    XK_Multi_key, XK_grave, 0x1F08, 0x1F8A,
    XK_Multi_key, XK_grave, 0x1F09, 0x1F8B,
    XK_Multi_key, XK_grave, 0x1F20, 0x1F92,
    XK_Multi_key, XK_grave, 0x1F21, 0x1F93,
    XK_Multi_key, XK_grave, 0x1F28, 0x1F9A,
    XK_Multi_key, XK_grave, 0x1F29, 0x1F9B,
    XK_Multi_key, XK_grave, 0x1F60, 0x1FA2,
    XK_Multi_key, XK_grave, 0x1F61, 0x1FA3,
    XK_Multi_key, XK_grave, 0x1F68, 0x1FAA,
    XK_Multi_key, XK_grave, 0x1F69, 0x1FAB,
    XK_Multi_key, XK_asciitilde, XK_Greek_alpha, 0x1FB7,
    XK_Multi_key, XK_asciitilde, XK_Greek_eta, 0x1FC7,
    XK_Multi_key, XK_asciitilde, XK_Greek_omega, 0x1FF7,
    XK_Multi_key, XK_asciitilde, 0x1F00, 0x1F86,
    XK_Multi_key, XK_asciitilde, 0x1F01, 0x1F87,
    XK_Multi_key, XK_asciitilde, 0x1F08, 0x1F8E,
    XK_Multi_key, XK_asciitilde, 0x1F09, 0x1F8F,
    XK_Multi_key, XK_asciitilde, 0x1F20, 0x1F96,
    XK_Multi_key, XK_asciitilde, 0x1F21, 0x1F97,
    XK_Multi_key, XK_asciitilde, 0x1F28, 0x1F9E,
    XK_Multi_key, XK_asciitilde, 0x1F29, 0x1F9F,
    XK_Multi_key, XK_asciitilde, 0x1F60, 0x1FA6,
    XK_Multi_key, XK_asciitilde, 0x1F61, 0x1FA7,
    XK_Multi_key, XK_asciitilde, 0x1F68, 0x1FAE,
    XK_Multi_key, XK_asciitilde, 0x1F69, 0x1FAF,
    XK_Multi_key, XK_acute, XK_Greek_alpha, 0x1FB4,
    XK_Multi_key, XK_acute, XK_Greek_eta, 0x1FC4,
    XK_Multi_key, XK_acute, XK_Greek_omega, 0x1FF4,
    XK_Multi_key, XK_acute, 0x1F00, 0x1F84,
    XK_Multi_key, XK_acute, 0x1F01, 0x1F85,
    XK_Multi_key, XK_acute, 0x1F08, 0x1F8C,
    XK_Multi_key, XK_acute, 0x1F09, 0x1F8D,
    XK_Multi_key, XK_acute, 0x1F20, 0x1F94,
    XK_Multi_key, XK_acute, 0x1F21, 0x1F95,
    XK_Multi_key, XK_acute, 0x1F28, 0x1F9C,
    XK_Multi_key, XK_acute, 0x1F29, 0x1F9D,
    XK_Multi_key, XK_acute, 0x1F60, 0x1FA4,
    XK_Multi_key, XK_acute, 0x1F61, 0x1FA5,
    XK_Multi_key, XK_acute, 0x1F68, 0x1FAC,
    XK_Multi_key, XK_acute, 0x1F69, 0x1FAD,
    XK_dead_grave, XK_Multi_key, XK_parenleft, XK_Greek_ALPHA, 0x1F8B,
    XK_dead_grave, XK_Multi_key, XK_parenleft, XK_Greek_ETA, 0x1F9B,
    XK_dead_grave, XK_Multi_key, XK_parenleft, XK_Greek_OMEGA, 0x1FAB,
    XK_dead_grave, XK_Multi_key, XK_parenleft, XK_Greek_alpha, 0x1F83,
    XK_dead_grave, XK_Multi_key, XK_parenleft, XK_Greek_eta, 0x1F93,
    XK_dead_grave, XK_Multi_key, XK_parenleft, XK_Greek_omega, 0x1FA3,
    XK_dead_grave, XK_Multi_key, XK_parenright, XK_Greek_ALPHA, 0x1F8A,
    XK_dead_grave, XK_Multi_key, XK_parenright, XK_Greek_ETA, 0x1F9A,
    XK_dead_grave, XK_Multi_key, XK_parenright, XK_Greek_OMEGA, 0x1FAA,
    XK_dead_grave, XK_Multi_key, XK_parenright, XK_Greek_alpha, 0x1F82,
    XK_dead_grave, XK_Multi_key, XK_parenright, XK_Greek_eta, 0x1F92,
    XK_dead_grave, XK_Multi_key, XK_parenright, XK_Greek_omega, 0x1FA2,
    XK_dead_acute, XK_Multi_key, XK_parenleft, XK_Greek_ALPHA, 0x1F8D,
    XK_dead_acute, XK_Multi_key, XK_parenleft, XK_Greek_ETA, 0x1F9D,
    XK_dead_acute, XK_Multi_key, XK_parenleft, XK_Greek_OMEGA, 0x1FAD,
    XK_dead_acute, XK_Multi_key, XK_parenleft, XK_Greek_alpha, 0x1F85,
    XK_dead_acute, XK_Multi_key, XK_parenleft, XK_Greek_eta, 0x1F95,
    XK_dead_acute, XK_Multi_key, XK_parenleft, XK_Greek_omega, 0x1FA5,
    XK_dead_acute, XK_Multi_key, XK_parenright, XK_Greek_ALPHA, 0x1F8C,
    XK_dead_acute, XK_Multi_key, XK_parenright, XK_Greek_ETA, 0x1F9C,
    XK_dead_acute, XK_Multi_key, XK_parenright, XK_Greek_OMEGA, 0x1FAC,
    XK_dead_acute, XK_Multi_key, XK_parenright, XK_Greek_alpha, 0x1F84,
    XK_dead_acute, XK_Multi_key, XK_parenright, XK_Greek_eta, 0x1F94,
    XK_dead_acute, XK_Multi_key, XK_parenright, XK_Greek_omega, 0x1FA4,
    XK_dead_tilde, XK_Multi_key, XK_parenleft, XK_Greek_ALPHA, 0x1F8F,
    XK_dead_tilde, XK_Multi_key, XK_parenleft, XK_Greek_ETA, 0x1F9F,
    XK_dead_tilde, XK_Multi_key, XK_parenleft, XK_Greek_OMEGA, 0x1FAF,
    XK_dead_tilde, XK_Multi_key, XK_parenleft, XK_Greek_alpha, 0x1F87,
    XK_dead_tilde, XK_Multi_key, XK_parenleft, XK_Greek_eta, 0x1F97,
    XK_dead_tilde, XK_Multi_key, XK_parenleft, XK_Greek_omega, 0x1FA7,
    XK_dead_tilde, XK_Multi_key, XK_parenright, XK_Greek_ALPHA, 0x1F8E,
    XK_dead_tilde, XK_Multi_key, XK_parenright, XK_Greek_ETA, 0x1F9E,
    XK_dead_tilde, XK_Multi_key, XK_parenright, XK_Greek_OMEGA, 0x1FAE,
    XK_dead_tilde, XK_Multi_key, XK_parenright, XK_Greek_alpha, 0x1F86,
    XK_dead_tilde, XK_Multi_key, XK_parenright, XK_Greek_eta, 0x1F96,
    XK_dead_tilde, XK_Multi_key, XK_parenright, XK_Greek_omega, 0x1FA6,
    XK_Multi_key, XK_apostrophe, XK_parenleft, XK_Greek_ALPHA, 0x1F8D,
    XK_Multi_key, XK_apostrophe, XK_parenleft, XK_Greek_ETA, 0x1F9D,
    XK_Multi_key, XK_apostrophe, XK_parenleft, XK_Greek_OMEGA, 0x1FAD,
    XK_Multi_key, XK_apostrophe, XK_parenleft, XK_Greek_alpha, 0x1F85,
    XK_Multi_key, XK_apostrophe, XK_parenleft, XK_Greek_eta, 0x1F95,
    XK_Multi_key, XK_apostrophe, XK_parenleft, XK_Greek_omega, 0x1FA5,
    XK_Multi_key, XK_apostrophe, XK_parenright, XK_Greek_ALPHA, 0x1F8C,
    XK_Multi_key, XK_apostrophe, XK_parenright, XK_Greek_ETA, 0x1F9C,
    XK_Multi_key, XK_apostrophe, XK_parenright, XK_Greek_OMEGA, 0x1FAC,
    XK_Multi_key, XK_apostrophe, XK_parenright, XK_Greek_alpha, 0x1F84,
    XK_Multi_key, XK_apostrophe, XK_parenright, XK_Greek_eta, 0x1F94,
    XK_Multi_key, XK_apostrophe, XK_parenright, XK_Greek_omega, 0x1FA4,
    XK_Multi_key, XK_apostrophe, XK_dead_psili, XK_Greek_ALPHA, 0x1F8C,
    XK_Multi_key, XK_apostrophe, XK_dead_psili, XK_Greek_ETA, 0x1F9C,
    XK_Multi_key, XK_apostrophe, XK_dead_psili, XK_Greek_OMEGA, 0x1FAC,
    XK_Multi_key, XK_apostrophe, XK_dead_psili, XK_Greek_alpha, 0x1F84,
    XK_Multi_key, XK_apostrophe, XK_dead_psili, XK_Greek_eta, 0x1F94,
    XK_Multi_key, XK_apostrophe, XK_dead_psili, XK_Greek_omega, 0x1FA4,
    XK_Multi_key, XK_apostrophe, XK_dead_dasia, XK_Greek_ALPHA, 0x1F8D,
    XK_Multi_key, XK_apostrophe, XK_dead_dasia, XK_Greek_ETA, 0x1F9D,
    XK_Multi_key, XK_apostrophe, XK_dead_dasia, XK_Greek_OMEGA, 0x1FAD,
    XK_Multi_key, XK_apostrophe, XK_dead_dasia, XK_Greek_alpha, 0x1F85,
    XK_Multi_key, XK_apostrophe, XK_dead_dasia, XK_Greek_eta, 0x1F95,
    XK_Multi_key, XK_apostrophe, XK_dead_dasia, XK_Greek_omega, 0x1FA5,
    XK_Multi_key, XK_grave, XK_parenleft, XK_Greek_ALPHA, 0x1F8B,
    XK_Multi_key, XK_grave, XK_parenleft, XK_Greek_ETA, 0x1F9B,
    XK_Multi_key, XK_grave, XK_parenleft, XK_Greek_OMEGA, 0x1FAB,
    XK_Multi_key, XK_grave, XK_parenleft, XK_Greek_alpha, 0x1F83,
    XK_Multi_key, XK_grave, XK_parenleft, XK_Greek_eta, 0x1F93,
    XK_Multi_key, XK_grave, XK_parenleft, XK_Greek_omega, 0x1FA3,
    XK_Multi_key, XK_grave, XK_parenright, XK_Greek_ALPHA, 0x1F8A,
    XK_Multi_key, XK_grave, XK_parenright, XK_Greek_ETA, 0x1F9A,
    XK_Multi_key, XK_grave, XK_parenright, XK_Greek_OMEGA, 0x1FAA,
    XK_Multi_key, XK_grave, XK_parenright, XK_Greek_alpha, 0x1F82,
    XK_Multi_key, XK_grave, XK_parenright, XK_Greek_eta, 0x1F92,
    XK_Multi_key, XK_grave, XK_parenright, XK_Greek_omega, 0x1FA2,
    XK_Multi_key, XK_grave, XK_dead_psili, XK_Greek_ALPHA, 0x1F8A,
    XK_Multi_key, XK_grave, XK_dead_psili, XK_Greek_ETA, 0x1F9A,
    XK_Multi_key, XK_grave, XK_dead_psili, XK_Greek_OMEGA, 0x1FAA,
    XK_Multi_key, XK_grave, XK_dead_psili, XK_Greek_alpha, 0x1F82,
    XK_Multi_key, XK_grave, XK_dead_psili, XK_Greek_eta, 0x1F92,
    XK_Multi_key, XK_grave, XK_dead_psili, XK_Greek_omega, 0x1FA2,
    XK_Multi_key, XK_grave, XK_dead_dasia, XK_Greek_ALPHA, 0x1F8B,
    XK_Multi_key, XK_grave, XK_dead_dasia, XK_Greek_ETA, 0x1F9B,
    XK_Multi_key, XK_grave, XK_dead_dasia, XK_Greek_OMEGA, 0x1FAB,
    XK_Multi_key, XK_grave, XK_dead_dasia, XK_Greek_alpha, 0x1F83,
    XK_Multi_key, XK_grave, XK_dead_dasia, XK_Greek_eta, 0x1F93,
    XK_Multi_key, XK_grave, XK_dead_dasia, XK_Greek_omega, 0x1FA3,
    XK_Multi_key, XK_asciitilde, XK_parenleft, XK_Greek_ALPHA, 0x1F8F,
    XK_Multi_key, XK_asciitilde, XK_parenleft, XK_Greek_ETA, 0x1F9F,
    XK_Multi_key, XK_asciitilde, XK_parenleft, XK_Greek_OMEGA, 0x1FAF,
    XK_Multi_key, XK_asciitilde, XK_parenleft, XK_Greek_alpha, 0x1F87,
    XK_Multi_key, XK_asciitilde, XK_parenleft, XK_Greek_eta, 0x1F97,
    XK_Multi_key, XK_asciitilde, XK_parenleft, XK_Greek_omega, 0x1FA7,
    XK_Multi_key, XK_asciitilde, XK_parenright, XK_Greek_ALPHA, 0x1F8E,
    XK_Multi_key, XK_asciitilde, XK_parenright, XK_Greek_ETA, 0x1F9E,
    XK_Multi_key, XK_asciitilde, XK_parenright, XK_Greek_OMEGA, 0x1FAE,
    XK_Multi_key, XK_asciitilde, XK_parenright, XK_Greek_alpha, 0x1F86,
    XK_Multi_key, XK_asciitilde, XK_parenright, XK_Greek_eta, 0x1F96,
    XK_Multi_key, XK_asciitilde, XK_parenright, XK_Greek_omega, 0x1FA6,
    XK_Multi_key, XK_asciitilde, XK_dead_psili, XK_Greek_ALPHA, 0x1F8E,
    XK_Multi_key, XK_asciitilde, XK_dead_psili, XK_Greek_ETA, 0x1F9E,
    XK_Multi_key, XK_asciitilde, XK_dead_psili, XK_Greek_OMEGA, 0x1FAE,
    XK_Multi_key, XK_asciitilde, XK_dead_psili, XK_Greek_alpha, 0x1F86,
    XK_Multi_key, XK_asciitilde, XK_dead_psili, XK_Greek_eta, 0x1F96,
    XK_Multi_key, XK_asciitilde, XK_dead_psili, XK_Greek_omega, 0x1FA6,
    XK_Multi_key, XK_asciitilde, XK_dead_dasia, XK_Greek_ALPHA, 0x1F8F,
    XK_Multi_key, XK_asciitilde, XK_dead_dasia, XK_Greek_ETA, 0x1F9F,
    XK_Multi_key, XK_asciitilde, XK_dead_dasia, XK_Greek_OMEGA, 0x1FAF,
    XK_Multi_key, XK_asciitilde, XK_dead_dasia, XK_Greek_alpha, 0x1F87,
    XK_Multi_key, XK_asciitilde, XK_dead_dasia, XK_Greek_eta, 0x1F97,
    XK_Multi_key, XK_asciitilde, XK_dead_dasia, XK_Greek_omega, 0x1FA7,
    XK_Multi_key, XK_acute, XK_parenleft, XK_Greek_ALPHA, 0x1F8D,
    XK_Multi_key, XK_acute, XK_parenleft, XK_Greek_ETA, 0x1F9D,
    XK_Multi_key, XK_acute, XK_parenleft, XK_Greek_OMEGA, 0x1FAD,
    XK_Multi_key, XK_acute, XK_parenleft, XK_Greek_alpha, 0x1F85,
    XK_Multi_key, XK_acute, XK_parenleft, XK_Greek_eta, 0x1F95,
    XK_Multi_key, XK_acute, XK_parenleft, XK_Greek_omega, 0x1FA5,
    XK_Multi_key, XK_acute, XK_parenright, XK_Greek_ALPHA, 0x1F8C,
    XK_Multi_key, XK_acute, XK_parenright, XK_Greek_ETA, 0x1F9C,
    XK_Multi_key, XK_acute, XK_parenright, XK_Greek_OMEGA, 0x1FAC,
    XK_Multi_key, XK_acute, XK_parenright, XK_Greek_alpha, 0x1F84,
    XK_Multi_key, XK_acute, XK_parenright, XK_Greek_eta, 0x1F94,
    XK_Multi_key, XK_acute, XK_parenright, XK_Greek_omega, 0x1FA4,
    XK_Multi_key, XK_acute, XK_dead_psili, XK_Greek_ALPHA, 0x1F8C,
    XK_Multi_key, XK_acute, XK_dead_psili, XK_Greek_ETA, 0x1F9C,
    XK_Multi_key, XK_acute, XK_dead_psili, XK_Greek_OMEGA, 0x1FAC,
    XK_Multi_key, XK_acute, XK_dead_psili, XK_Greek_alpha, 0x1F84,
    XK_Multi_key, XK_acute, XK_dead_psili, XK_Greek_eta, 0x1F94,
    XK_Multi_key, XK_acute, XK_dead_psili, XK_Greek_omega, 0x1FA4,
    XK_Multi_key, XK_acute, XK_dead_dasia, XK_Greek_ALPHA, 0x1F8D,
    XK_Multi_key, XK_acute, XK_dead_dasia, XK_Greek_ETA, 0x1F9D,
    XK_Multi_key, XK_acute, XK_dead_dasia, XK_Greek_OMEGA, 0x1FAD,
    XK_Multi_key, XK_acute, XK_dead_dasia, XK_Greek_alpha, 0x1F85,
    XK_Multi_key, XK_acute, XK_dead_dasia, XK_Greek_eta, 0x1F95,
    XK_Multi_key, XK_acute, XK_dead_dasia, XK_Greek_omega, 0x1FA5,
    XK_kana_WO, 0x30FA,
    XK_kana_U, 0x30F4,
    XK_kana_KA, 0x30AC,
    XK_kana_KI, 0x30AE,
    XK_kana_KU, 0x30B0,
    XK_kana_KE, 0x30B2,
    XK_kana_KO, 0x30B4,
    XK_kana_SA, 0x30B6,
    XK_kana_SHI, 0x30B8,
    XK_kana_SU, 0x30BA,
    XK_kana_SE, 0x30BC,
    XK_kana_SO, 0x30BE,
    XK_kana_TA, 0x30C0,
    XK_kana_CHI, 0x30C2,
    XK_kana_TSU, 0x30C5,
    XK_kana_TE, 0x30C7,
    XK_kana_TO, 0x30C9,
    XK_kana_HA, 0x30D0,
    XK_kana_HI, 0x30D3,
    XK_kana_FU, 0x30D6,
    XK_kana_HE, 0x30D9,
    XK_kana_HO, 0x30DC,
    XK_kana_WA, 0x30F7,
    XK_kana_HA, 0x30D1,
    XK_kana_HI, 0x30D4,
    XK_kana_FU, 0x30D7,
    XK_kana_HE, 0x30DA,
    XK_kana_HO, 0x30DD,
    XK_plus, 0x2A25,
    XK_minus, 0x2A2A,
    XK_equal, 0x2A66,
    XK_Abreve, 0x1EB6,
    XK_abreve, 0x1EB7,
    XK_Multi_key, XK_plus, XK_O, 0x1EE2,
    XK_Multi_key, XK_plus, XK_U, 0x1EF0,
    XK_Multi_key, XK_plus, XK_o, 0x1EE3,
    XK_Multi_key, XK_plus, XK_u, 0x1EF1,
    XK_space, 0x0309,
    XK_B, 0x0181,
    XK_C, 0x0187,
    XK_D, 0x018A,
    XK_F, 0x0191,
    XK_G, 0x0193,
    XK_K, 0x0198,
    XK_M, 0x2C6E,
    XK_N, 0x019D,
    XK_P, 0x01A4,
    XK_T, 0x01AC,
    XK_V, 0x01B2,
    XK_W, 0x2C72,
    XK_Z, 0x0224,
    XK_b, 0x0253,
    XK_c, 0x0188,
    XK_d, 0x0257,
    XK_f, 0x0192,
    XK_g, 0x0260,
    XK_h, 0x0266,
    XK_k, 0x0199,
    XK_m, 0x0271,
    XK_n, 0x0272,
    XK_p, 0x01A5,
    XK_q, 0x02A0,
    XK_s, 0x0282,
    XK_t, 0x01AD,
    XK_v, 0x028B,
    XK_w, 0x2C73,
    XK_z, 0x0225,
    XK_nobreakspace, 0x0309,
    XK_Abreve, 0x1EB2,
    XK_abreve, 0x1EB3,
    0x0256, 0x1D91,
    XK_schwa, 0x025A,
    0x025C, 0x025D,
    0x025F, 0x0284,
    0x0279, 0x027B,
    XK_dead_hook, 0x0309,
    XK_Multi_key, XK_plus, XK_O, 0x1EDE,
    XK_Multi_key, XK_plus, XK_U, 0x1EEC,
    XK_Multi_key, XK_plus, XK_o, 0x1EDF,
    XK_Multi_key, XK_plus, XK_u, 0x1EED,
    XK_Multi_key, XK_U, XK_A, 0x1EB2,
    XK_Multi_key, XK_U, XK_a, 0x1EB3,
    XK_Multi_key, XK_asciicircum, XK_A, 0x1EA8,
    XK_Multi_key, XK_asciicircum, XK_E, 0x1EC2,
    XK_Multi_key, XK_asciicircum, XK_O, 0x1ED4,
    XK_Multi_key, XK_asciicircum, XK_a, 0x1EA9,
    XK_Multi_key, XK_asciicircum, XK_e, 0x1EC3,
    XK_Multi_key, XK_asciicircum, XK_o, 0x1ED5,
    XK_Multi_key, XK_b, XK_A, 0x1EB2,
    XK_Multi_key, XK_b, XK_a, 0x1EB3,
    XK_Greek_ALPHA, 0x1F08,
    XK_Greek_EPSILON, 0x1F18,
    XK_Greek_ETA, 0x1F28,
    XK_Greek_IOTA, 0x1F38,
    XK_Greek_OMICRON, 0x1F48,
    XK_Greek_OMEGA, 0x1F68,
    XK_Greek_alpha, 0x1F00,
    XK_Greek_epsilon, 0x1F10,
    XK_Greek_eta, 0x1F20,
    XK_Greek_iota, 0x1F30,
    XK_Greek_omicron, 0x1F40,
    XK_Greek_rho, 0x1FE4,
    XK_Greek_upsilon, 0x1F50,
    XK_Greek_omega, 0x1F60,
    XK_Greek_ALPHA, 0x1F09,
    XK_Greek_EPSILON, 0x1F19,
    XK_Greek_ETA, 0x1F29,
    XK_Greek_IOTA, 0x1F39,
    XK_Greek_OMICRON, 0x1F49,
    XK_Greek_RHO, 0x1FEC,
    XK_Greek_UPSILON, 0x1F59,
    XK_Greek_OMEGA, 0x1F69,
    XK_Greek_alpha, 0x1F01,
    XK_Greek_epsilon, 0x1F11,
    XK_Greek_eta, 0x1F21,
    XK_Greek_iota, 0x1F31,
    XK_Greek_omicron, 0x1F41,
    XK_Greek_rho, 0x1FE5,
    XK_Greek_upsilon, 0x1F51,
    XK_Greek_omega, 0x1F61,
    XK_space, XK_space, 0x00A0,
    XK_space, XK_apostrophe, 0x0027,
    XK_space, XK_parenleft, 0x02D8,
    XK_space, XK_comma, 0x00B8,
    XK_space, XK_minus, 0x007E,
    XK_space, XK_period, 0x2008,
    XK_space, XK_less, 0x02C7,
    XK_space, XK_greater, 0x005E,
    XK_space, XK_asciicircum, 0x005E,
    XK_space, XK_grave, 0x0060,
    XK_space, XK_asciitilde, 0x007E,
    XK_exclam, XK_exclam, 0x00A1,
    XK_exclam, XK_question, 0x203D,
    XK_exclam, XK_A, 0x1EA0,
    XK_exclam, XK_B, 0x1E04,
    XK_exclam, XK_D, 0x1E0C,
    XK_exclam, XK_E, 0x1EB8,
    XK_exclam, XK_H, 0x1E24,
    XK_exclam, XK_I, 0x1ECA,
    XK_exclam, XK_K, 0x1E32,
    XK_exclam, XK_L, 0x1E36,
    XK_exclam, XK_M, 0x1E42,
    XK_exclam, XK_N, 0x1E46,
    XK_exclam, XK_O, 0x1ECC,
    XK_exclam, XK_P, 0x00B6,
    XK_exclam, XK_R, 0x1E5A,
    XK_exclam, XK_S, 0x00A7,
    XK_exclam, XK_T, 0x1E6C,
    XK_exclam, XK_U, 0x1EE4,
    XK_exclam, XK_V, 0x1E7E,
    XK_exclam, XK_W, 0x1E88,
    XK_exclam, XK_Y, 0x1EF4,
    XK_exclam, XK_Z, 0x1E92,
    XK_exclam, XK_asciicircum, 0x00A6,
    XK_exclam, XK_a, 0x1EA1,
    XK_exclam, XK_b, 0x1E05,
    XK_exclam, XK_d, 0x1E0D,
    XK_exclam, XK_e, 0x1EB9,
    XK_exclam, XK_h, 0x1E25,
    XK_exclam, XK_i, 0x1ECB,
    XK_exclam, XK_k, 0x1E33,
    XK_exclam, XK_l, 0x1E37,
    XK_exclam, XK_m, 0x1E43,
    XK_exclam, XK_n, 0x1E47,
    XK_exclam, XK_o, 0x1ECD,
    XK_exclam, XK_p, 0x00B6,
    XK_exclam, XK_r, 0x1E5B,
    XK_exclam, XK_s, 0x00A7,
    XK_exclam, XK_t, 0x1E6D,
    XK_exclam, XK_u, 0x1EE5,
    XK_exclam, XK_v, 0x1E7F,
    XK_exclam, XK_w, 0x1E89,
    XK_exclam, XK_y, 0x1EF5,
    XK_exclam, XK_z, 0x1E93,
    XK_exclam, XK_Ohorn, 0x1EE2,
    XK_exclam, XK_ohorn, 0x1EE3,
    XK_exclam, XK_Uhorn, 0x1EF0,
    XK_exclam, XK_uhorn, 0x1EF1,
    XK_quotedbl, XK_quotedbl, 0x00A8,
    XK_quotedbl, XK_apostrophe, 0x0344,
    XK_quotedbl, XK_comma, 0x201E,
    XK_quotedbl, XK_slash, 0x301E,
    XK_quotedbl, XK_less, 0x201C,
    XK_quotedbl, XK_greater, 0x201D,
    XK_quotedbl, XK_A, 0x00C4,
    XK_quotedbl, XK_E, 0x00CB,
    XK_quotedbl, XK_H, 0x1E26,
    XK_quotedbl, XK_I, 0x00CF,
    XK_quotedbl, XK_O, 0x00D6,
    XK_quotedbl, XK_U, 0x00DC,
    XK_quotedbl, XK_W, 0x1E84,
    XK_quotedbl, XK_X, 0x1E8C,
    XK_quotedbl, XK_Y, 0x0178,
    XK_quotedbl, XK_backslash, 0x301D,
    XK_quotedbl, XK_a, 0x00E4,
    XK_quotedbl, XK_e, 0x00EB,
    XK_quotedbl, XK_h, 0x1E27,
    XK_quotedbl, XK_i, 0x00EF,
    XK_quotedbl, XK_o, 0x00F6,
    XK_quotedbl, XK_t, 0x1E97,
    XK_quotedbl, XK_u, 0x00FC,
    XK_quotedbl, XK_w, 0x1E85,
    XK_quotedbl, XK_x, 0x1E8D,
    XK_quotedbl, XK_y, 0x00FF,
    XK_quotedbl, XK_acute, 0x0344,
    XK_quotedbl, XK_Otilde, 0x1E4E,
    XK_quotedbl, XK_otilde, 0x1E4F,
    XK_quotedbl, 0x03D2, 0x03D4,
    XK_quotedbl, XK_Umacron, 0x1E7A,
    XK_quotedbl, XK_umacron, 0x1E7B,
    XK_quotedbl, 0x04D8, 0x04DA,
    XK_quotedbl, 0x04D9, 0x04DB,
    XK_quotedbl, 0x04E8, 0x04EA,
    XK_quotedbl, 0x04E9, 0x04EB,
    XK_quotedbl, XK_Ukrainian_i, 0x0457,
    XK_quotedbl, XK_Ukrainian_I, 0x0407,
    XK_quotedbl, XK_Cyrillic_a, 0x04D3,
    XK_quotedbl, XK_Cyrillic_ie, 0x0451,
    XK_quotedbl, XK_Cyrillic_i, 0x04E5,
    XK_quotedbl, XK_Cyrillic_o, 0x04E7,
    XK_quotedbl, XK_Cyrillic_u, 0x04F1,
    XK_quotedbl, XK_Cyrillic_zhe, 0x04DD,
    XK_quotedbl, XK_Cyrillic_yeru, 0x04F9,
    XK_quotedbl, XK_Cyrillic_ze, 0x04DF,
    XK_quotedbl, XK_Cyrillic_e, 0x04ED,
    XK_quotedbl, XK_Cyrillic_che, 0x04F5,
    XK_quotedbl, XK_Cyrillic_A, 0x04D2,
    XK_quotedbl, XK_Cyrillic_IE, 0x0401,
    XK_quotedbl, XK_Cyrillic_I, 0x04E4,
    XK_quotedbl, XK_Cyrillic_O, 0x04E6,
    XK_quotedbl, XK_Cyrillic_U, 0x04F0,
    XK_quotedbl, XK_Cyrillic_ZHE, 0x04DC,
    XK_quotedbl, XK_Cyrillic_YERU, 0x04F8,
    XK_quotedbl, XK_Cyrillic_ZE, 0x04DE,
    XK_quotedbl, XK_Cyrillic_E, 0x04EC,
    XK_quotedbl, XK_Cyrillic_CHE, 0x04F4,
    XK_quotedbl, XK_Greek_IOTA, 0x03AA,
    XK_quotedbl, XK_Greek_UPSILON, 0x03AB,
    XK_quotedbl, XK_Greek_iota, 0x03CA,
    XK_quotedbl, XK_Greek_upsilon, 0x03CB,
    XK_quotedbl, XK_dead_acute, 0x0344,
    XK_numbersign, XK_numbersign, 0x266F,
    XK_numbersign, XK_b, 0x266D,
    XK_numbersign, XK_f, 0x266E,
    XK_percent, XK_o, 0x2030,
    XK_apostrophe, XK_space, 0x0027,
    XK_apostrophe, XK_apostrophe, 0x00B4,
    XK_apostrophe, XK_comma, 0x201A,
    XK_apostrophe, XK_less, 0x2018,
    XK_apostrophe, XK_greater, 0x2019,
    XK_apostrophe, XK_A, 0x00C1,
    XK_apostrophe, XK_C, 0x0106,
    XK_apostrophe, XK_E, 0x00C9,
    XK_apostrophe, XK_G, 0x01F4,
    XK_apostrophe, XK_I, 0x00CD,
    XK_apostrophe, XK_K, 0x1E30,
    XK_apostrophe, XK_L, 0x0139,
    XK_apostrophe, XK_M, 0x1E3E,
    XK_apostrophe, XK_N, 0x0143,
    XK_apostrophe, XK_O, 0x00D3,
    XK_apostrophe, XK_P, 0x1E54,
    XK_apostrophe, XK_R, 0x0154,
    XK_apostrophe, XK_S, 0x015A,
    XK_apostrophe, XK_U, 0x00DA,
    XK_apostrophe, XK_W, 0x1E82,
    XK_apostrophe, XK_Y, 0x00DD,
    XK_apostrophe, XK_Z, 0x0179,
    XK_apostrophe, XK_a, 0x00E1,
    XK_apostrophe, XK_c, 0x0107,
    XK_apostrophe, XK_e, 0x00E9,
    XK_apostrophe, XK_g, 0x01F5,
    XK_apostrophe, XK_i, 0x00ED,
    XK_apostrophe, XK_k, 0x1E31,
    XK_apostrophe, XK_l, 0x013A,
    XK_apostrophe, XK_m, 0x1E3F,
    XK_apostrophe, XK_n, 0x0144,
    XK_apostrophe, XK_o, 0x00F3,
    XK_apostrophe, XK_p, 0x1E55,
    XK_apostrophe, XK_r, 0x0155,
    XK_apostrophe, XK_s, 0x015B,
    XK_apostrophe, XK_u, 0x00FA,
    XK_apostrophe, XK_w, 0x1E83,
    XK_apostrophe, XK_y, 0x00FD,
    XK_apostrophe, XK_z, 0x017A,
    XK_apostrophe, XK_Acircumflex, 0x1EA4,
    XK_apostrophe, XK_Aring, 0x01FA,
    XK_apostrophe, XK_AE, 0x01FC,
    XK_apostrophe, XK_Ccedilla, 0x1E08,
    XK_apostrophe, XK_Ecircumflex, 0x1EBE,
    XK_apostrophe, XK_Idiaeresis, 0x1E2E,
    XK_apostrophe, XK_Ocircumflex, 0x1ED0,
    XK_apostrophe, XK_Otilde, 0x1E4C,
    XK_apostrophe, XK_Ooblique, 0x01FE,
    XK_apostrophe, 0x00DC, 0x01D7,
    XK_apostrophe, XK_acircumflex, 0x1EA5,
    XK_apostrophe, XK_aring, 0x01FB,
    XK_apostrophe, XK_ae, 0x01FD,
    XK_apostrophe, XK_ccedilla, 0x1E09,
    XK_apostrophe, XK_ecircumflex, 0x1EBF,
    XK_apostrophe, XK_idiaeresis, 0x1E2F,
    XK_apostrophe, XK_ocircumflex, 0x1ED1,
    XK_apostrophe, XK_otilde, 0x1E4D,
    XK_apostrophe, XK_oslash, 0x01FF,
    XK_apostrophe, XK_udiaeresis, 0x01D8,
    XK_apostrophe, XK_Ohorn, 0x1EDA,
    XK_apostrophe, XK_ohorn, 0x1EDB,
    XK_apostrophe, XK_Uhorn, 0x1EE8,
    XK_apostrophe, XK_uhorn, 0x1EE9,
    XK_apostrophe, XK_Abreve, 0x1EAE,
    XK_apostrophe, XK_abreve, 0x1EAF,
    XK_apostrophe, XK_Emacron, 0x1E16,
    XK_apostrophe, XK_emacron, 0x1E17,
    XK_apostrophe, XK_Omacron, 0x1E52,
    XK_apostrophe, XK_Utilde, 0x1E78,
    XK_apostrophe, XK_omacron, 0x1E53,
    XK_apostrophe, XK_utilde, 0x1E79,
    XK_apostrophe, XK_Cyrillic_ghe, 0x0453,
    XK_apostrophe, XK_Cyrillic_ka, 0x045C,
    XK_apostrophe, XK_Cyrillic_GHE, 0x0403,
    XK_apostrophe, XK_Cyrillic_KA, 0x040C,
    XK_apostrophe, XK_Greek_iotadieresis, 0x0390,
    XK_apostrophe, XK_Greek_upsilondieresis, 0x03B0,
    XK_apostrophe, XK_Greek_ALPHA, 0x0386,
    XK_apostrophe, XK_Greek_EPSILON, 0x0388,
    XK_apostrophe, XK_Greek_ETA, 0x0389,
    XK_apostrophe, XK_Greek_IOTA, 0x038A,
    XK_apostrophe, XK_Greek_OMICRON, 0x038C,
    XK_apostrophe, XK_Greek_UPSILON, 0x038E,
    XK_apostrophe, XK_Greek_OMEGA, 0x038F,
    XK_apostrophe, XK_Greek_alpha, 0x03AC,
    XK_apostrophe, XK_Greek_epsilon, 0x03AD,
    XK_apostrophe, XK_Greek_eta, 0x03AE,
    XK_apostrophe, XK_Greek_iota, 0x03AF,
    XK_apostrophe, XK_Greek_omicron, 0x03CC,
    XK_apostrophe, XK_Greek_upsilon, 0x03CD,
    XK_apostrophe, XK_Greek_omega, 0x03CE,
    XK_apostrophe, 0x1F00, 0x1F04,
    XK_apostrophe, 0x1F01, 0x1F05,
    XK_apostrophe, 0x1F08, 0x1F0C,
    XK_apostrophe, 0x1F09, 0x1F0D,
    XK_apostrophe, 0x1F10, 0x1F14,
    XK_apostrophe, 0x1F11, 0x1F15,
    XK_apostrophe, 0x1F18, 0x1F1C,
    XK_apostrophe, 0x1F19, 0x1F1D,
    XK_apostrophe, 0x1F20, 0x1F24,
    XK_apostrophe, 0x1F21, 0x1F25,
    XK_apostrophe, 0x1F28, 0x1F2C,
    XK_apostrophe, 0x1F29, 0x1F2D,
    XK_apostrophe, 0x1F30, 0x1F34,
    XK_apostrophe, 0x1F31, 0x1F35,
    XK_apostrophe, 0x1F38, 0x1F3C,
    XK_apostrophe, 0x1F39, 0x1F3D,
    XK_apostrophe, 0x1F40, 0x1F44,
    XK_apostrophe, 0x1F41, 0x1F45,
    XK_apostrophe, 0x1F48, 0x1F4C,
    XK_apostrophe, 0x1F49, 0x1F4D,
    XK_apostrophe, 0x1F50, 0x1F54,
    XK_apostrophe, 0x1F51, 0x1F55,
    XK_apostrophe, 0x1F59, 0x1F5D,
    XK_apostrophe, 0x1F60, 0x1F64,
    XK_apostrophe, 0x1F61, 0x1F65,
    XK_apostrophe, 0x1F68, 0x1F6C,
    XK_apostrophe, 0x1F69, 0x1F6D,
    XK_parenleft, XK_space, 0x02D8,
    XK_parenleft, XK_parenleft, 0x005B,
    XK_parenleft, XK_minus, 0x007B,
    XK_parenleft, XK_A, 0x0102,
    XK_parenleft, XK_G, 0x011E,
    XK_parenleft, XK_a, 0x0103,
    XK_parenleft, XK_c, 0x00A9,
    XK_parenleft, XK_g, 0x011F,
    XK_parenleft, XK_r, 0x00AE,
    XK_parenleft, XK_Greek_ALPHA, 0x1F09,
    XK_parenleft, XK_Greek_EPSILON, 0x1F19,
    XK_parenleft, XK_Greek_ETA, 0x1F29,
    XK_parenleft, XK_Greek_IOTA, 0x1F39,
    XK_parenleft, XK_Greek_OMICRON, 0x1F49,
    XK_parenleft, XK_Greek_RHO, 0x1FEC,
    XK_parenleft, XK_Greek_UPSILON, 0x1F59,
    XK_parenleft, XK_Greek_OMEGA, 0x1F69,
    XK_parenleft, XK_Greek_alpha, 0x1F01,
    XK_parenleft, XK_Greek_epsilon, 0x1F11,
    XK_parenleft, XK_Greek_eta, 0x1F21,
    XK_parenleft, XK_Greek_iota, 0x1F31,
    XK_parenleft, XK_Greek_omicron, 0x1F41,
    XK_parenleft, XK_Greek_rho, 0x1FE5,
    XK_parenleft, XK_Greek_upsilon, 0x1F51,
    XK_parenleft, XK_Greek_omega, 0x1F61,
    XK_parenright, XK_parenright, 0x005D,
    XK_parenright, XK_minus, 0x007D,
    XK_parenright, XK_Greek_ALPHA, 0x1F08,
    XK_parenright, XK_Greek_EPSILON, 0x1F18,
    XK_parenright, XK_Greek_ETA, 0x1F28,
    XK_parenright, XK_Greek_IOTA, 0x1F38,
    XK_parenright, XK_Greek_OMICRON, 0x1F48,
    XK_parenright, XK_Greek_OMEGA, 0x1F68,
    XK_parenright, XK_Greek_alpha, 0x1F00,
    XK_parenright, XK_Greek_epsilon, 0x1F10,
    XK_parenright, XK_Greek_eta, 0x1F20,
    XK_parenright, XK_Greek_iota, 0x1F30,
    XK_parenright, XK_Greek_omicron, 0x1F40,
    XK_parenright, XK_Greek_rho, 0x1FE4,
    XK_parenright, XK_Greek_upsilon, 0x1F50,
    XK_parenright, XK_Greek_omega, 0x1F60,
    XK_asterisk, XK_0, 0x00B0,
    XK_asterisk, XK_A, 0x00C5,
    XK_asterisk, XK_U, 0x016E,
    XK_asterisk, XK_a, 0x00E5,
    XK_asterisk, XK_u, 0x016F,
    XK_plus, XK_plus, 0x0023,
    XK_plus, XK_minus, 0x00B1,
    XK_plus, XK_O, 0x01A0,
    XK_plus, XK_U, 0x01AF,
    XK_plus, XK_o, 0x01A1,
    XK_plus, XK_u, 0x01B0,
    XK_comma, XK_space, 0x00B8,
    XK_comma, XK_quotedbl, 0x201E,
    XK_comma, XK_apostrophe, 0x201A,
    XK_comma, XK_comma, 0x00B8,
    XK_comma, XK_minus, 0x00AC,
    XK_comma, XK_A, 0x0104,
    XK_comma, XK_C, 0x00C7,
    XK_comma, XK_D, 0x1E10,
    XK_comma, XK_E, 0x0118,
    XK_comma, XK_G, 0x0122,
    XK_comma, XK_H, 0x1E28,
    XK_comma, XK_I, 0x012E,
    XK_comma, XK_K, 0x0136,
    XK_comma, XK_L, 0x013B,
    XK_comma, XK_N, 0x0145,
    XK_comma, XK_R, 0x0156,
    XK_comma, XK_S, 0x015E,
    XK_comma, XK_T, 0x0162,
    XK_comma, XK_U, 0x0172,
    XK_comma, XK_a, 0x0105,
    XK_comma, XK_c, 0x00E7,
    XK_comma, XK_d, 0x1E11,
    XK_comma, XK_e, 0x0119,
    XK_comma, XK_g, 0x0123,
    XK_comma, XK_h, 0x1E29,
    XK_comma, XK_i, 0x012F,
    XK_comma, XK_k, 0x0137,
    XK_comma, XK_l, 0x013C,
    XK_comma, XK_n, 0x0146,
    XK_comma, XK_r, 0x0157,
    XK_comma, XK_s, 0x015F,
    XK_comma, XK_t, 0x0163,
    XK_comma, XK_u, 0x0173,
    XK_minus, XK_space, 0x007E,
    XK_minus, XK_parenleft, 0x007B,
    XK_minus, XK_parenright, 0x007D,
    XK_minus, XK_plus, 0x00B1,
    XK_minus, XK_comma, 0x00AC,
    XK_minus, XK_colon, 0x00F7,
    XK_minus, XK_A, 0x00C3,
    XK_minus, XK_D, 0x0110,
    XK_minus, XK_E, 0x0112,
    XK_minus, XK_I, 0x012A,
    XK_minus, XK_L, 0x00A3,
    XK_minus, XK_N, 0x00D1,
    XK_minus, XK_O, 0x00D5,
    XK_minus, XK_U, 0x016A,
    XK_minus, XK_Y, 0x00A5,
    XK_minus, XK_asciicircum, 0x00AF,
    XK_minus, XK_a, 0x00E3,
    XK_minus, XK_d, 0x0111,
    XK_minus, XK_e, 0x0113,
    XK_minus, XK_i, 0x012B,
    XK_minus, XK_l, 0x00A3,
    XK_minus, XK_n, 0x00F1,
    XK_minus, XK_o, 0x00F5,
    XK_minus, XK_u, 0x016B,
    XK_minus, XK_y, 0x00A5,
    XK_period, XK_minus, 0x00B7,
    XK_period, XK_period, 0x02D9,
    XK_period, XK_less, 0x2039,
    XK_period, XK_equal, 0x2022,
    XK_period, XK_greater, 0x203A,
    XK_period, XK_A, 0x0226,
    XK_period, XK_B, 0x1E02,
    XK_period, XK_C, 0x010A,
    XK_period, XK_D, 0x1E0A,
    XK_period, XK_E, 0x0116,
    XK_period, XK_F, 0x1E1E,
    XK_period, XK_G, 0x0120,
    XK_period, XK_H, 0x1E22,
    XK_period, XK_I, 0x0130,
    XK_period, XK_M, 0x1E40,
    XK_period, XK_N, 0x1E44,
    XK_period, XK_O, 0x022E,
    XK_period, XK_P, 0x1E56,
    XK_period, XK_R, 0x1E58,
    XK_period, XK_S, 0x1E60,
    XK_period, XK_T, 0x1E6A,
    XK_period, XK_W, 0x1E86,
    XK_period, XK_X, 0x1E8A,
    XK_period, XK_Y, 0x1E8E,
    XK_period, XK_Z, 0x017B,
    XK_period, XK_asciicircum, 0x00B7,
    XK_period, XK_a, 0x0227,
    XK_period, XK_b, 0x1E03,
    XK_period, XK_c, 0x010B,
    XK_period, XK_d, 0x1E0B,
    XK_period, XK_e, 0x0117,
    XK_period, XK_f, 0x1E1F,
    XK_period, XK_g, 0x0121,
    XK_period, XK_h, 0x1E23,
    XK_period, XK_i, 0x0131,
    XK_period, XK_m, 0x1E41,
    XK_period, XK_n, 0x1E45,
    XK_period, XK_o, 0x022F,
    XK_period, XK_p, 0x1E57,
    XK_period, XK_r, 0x1E59,
    XK_period, XK_s, 0x1E61,
    XK_period, XK_t, 0x1E6B,
    XK_period, XK_w, 0x1E87,
    XK_period, XK_x, 0x1E8B,
    XK_period, XK_y, 0x1E8F,
    XK_period, XK_z, 0x017C,
    XK_period, 0x017F, 0x1E9B,
    XK_period, XK_Sacute, 0x1E64,
    XK_period, XK_Scaron, 0x1E66,
    XK_period, XK_sacute, 0x1E65,
    XK_period, XK_scaron, 0x1E67,
    XK_period, 0x1E62, 0x1E68,
    XK_period, 0x1E63, 0x1E69,
    XK_slash, XK_slash, 0x005C,
    XK_slash, XK_less, 0x005C,
    XK_slash, XK_C, 0x00A2,
    XK_slash, XK_D, 0x0110,
    XK_slash, XK_G, 0x01E4,
    XK_slash, XK_H, 0x0126,
    XK_slash, XK_I, 0x0197,
    XK_slash, XK_L, 0x0141,
    XK_slash, XK_O, 0x00D8,
    XK_slash, XK_T, 0x0166,
    XK_slash, XK_U, 0x00B5,
    XK_slash, XK_Z, 0x01B5,
    XK_slash, XK_asciicircum, 0x007C,
    XK_slash, XK_b, 0x0180,
    XK_slash, XK_c, 0x00A2,
    XK_slash, XK_d, 0x0111,
    XK_slash, XK_g, 0x01E5,
    XK_slash, XK_h, 0x0127,
    XK_slash, XK_i, 0x0268,
    XK_slash, XK_l, 0x0142,
    XK_slash, XK_m, 0x20A5,
    XK_slash, XK_o, 0x00F8,
    XK_slash, XK_t, 0x0167,
    XK_slash, XK_u, 0x00B5,
    XK_slash, XK_z, 0x01B6,
    XK_slash, 0x0294, 0x02A1,
    XK_slash, 0x04AE, 0x04B0,
    XK_slash, 0x04AF, 0x04B1,
    XK_slash, XK_Cyrillic_ghe, 0x0493,
    XK_slash, XK_Cyrillic_ka, 0x049F,
    XK_slash, XK_Cyrillic_GHE, 0x0492,
    XK_slash, XK_Cyrillic_KA, 0x049E,
    XK_slash, XK_leftarrow, 0x219A,
    XK_slash, XK_rightarrow, 0x219B,
    XK_slash, 0x2194, 0x21AE,
    XK_0, XK_asterisk, 0x00B0,
    XK_0, XK_C, 0x00A9,
    XK_0, XK_S, 0x00A7,
    XK_0, XK_X, 0x00A4,
    XK_0, XK_asciicircum, 0x00B0,
    XK_0, XK_c, 0x00A9,
    XK_0, XK_s, 0x00A7,
    XK_0, XK_x, 0x00A4,
    XK_1, XK_2, 0x00BD,
    XK_1, XK_3, 0x2153,
    XK_1, XK_4, 0x00BC,
    XK_1, XK_5, 0x2155,
    XK_1, XK_6, 0x2159,
    XK_1, XK_8, 0x215B,
    XK_1, XK_S, 0x00B9,
    XK_1, XK_asciicircum, 0x00B9,
    XK_1, XK_s, 0x00B9,
    XK_2, XK_3, 0x2154,
    XK_2, XK_5, 0x2156,
    XK_2, XK_S, 0x00B2,
    XK_2, XK_asciicircum, 0x00B2,
    XK_2, XK_s, 0x00B2,
    XK_3, XK_4, 0x00BE,
    XK_3, XK_5, 0x2157,
    XK_3, XK_8, 0x215C,
    XK_3, XK_S, 0x00B3,
    XK_3, XK_asciicircum, 0x00B3,
    XK_3, XK_s, 0x00B3,
    XK_4, XK_5, 0x2158,
    XK_5, XK_6, 0x215A,
    XK_5, XK_8, 0x215D,
    XK_7, XK_8, 0x215E,
    XK_colon, XK_minus, 0x00F7,
    XK_semicolon, XK_A, 0x0104,
    XK_semicolon, XK_E, 0x0118,
    XK_semicolon, XK_I, 0x012E,
    XK_semicolon, XK_O, 0x01EA,
    XK_semicolon, XK_U, 0x0172,
    XK_semicolon, XK_a, 0x0105,
    XK_semicolon, XK_e, 0x0119,
    XK_semicolon, XK_i, 0x012F,
    XK_semicolon, XK_o, 0x01EB,
    XK_semicolon, XK_u, 0x0173,
    XK_less, XK_space, 0x02C7,
    XK_less, XK_quotedbl, 0x201C,
    XK_less, XK_apostrophe, 0x2018,
    XK_less, XK_slash, 0x005C,
    XK_less, XK_less, 0x00AB,
    XK_less, XK_C, 0x010C,
    XK_less, XK_D, 0x010E,
    XK_less, XK_E, 0x011A,
    XK_less, XK_L, 0x013D,
    XK_less, XK_N, 0x0147,
    XK_less, XK_R, 0x0158,
    XK_less, XK_S, 0x0160,
    XK_less, XK_T, 0x0164,
    XK_less, XK_Z, 0x017D,
    XK_less, XK_c, 0x010D,
    XK_less, XK_d, 0x010F,
    XK_less, XK_e, 0x011B,
    XK_less, XK_l, 0x013E,
    XK_less, XK_n, 0x0148,
    XK_less, XK_r, 0x0159,
    XK_less, XK_s, 0x0161,
    XK_less, XK_t, 0x0165,
    XK_less, XK_z, 0x017E,
    XK_less, 0x0338, 0x226E,
    XK_equal, XK_C, 0x20AC,
    XK_equal, XK_E, 0x20AC,
    XK_equal, XK_L, 0x00A3,
    XK_equal, XK_N, 0x20A6,
    XK_equal, XK_O, 0x0150,
    XK_equal, XK_U, 0x0170,
    XK_equal, XK_W, 0x20A9,
    XK_equal, XK_Y, 0x00A5,
    XK_equal, XK_c, 0x20AC,
    XK_equal, XK_e, 0x20AC,
    XK_equal, XK_l, 0x00A3,
    XK_equal, XK_o, 0x0151,
    XK_equal, XK_u, 0x0171,
    XK_equal, XK_y, 0x00A5,
    XK_equal, 0x0338, 0x2260,
    XK_equal, XK_Cyrillic_u, 0x04F3,
    XK_equal, XK_Cyrillic_IE, 0x20AC,
    XK_equal, XK_Cyrillic_ES, 0x20AC,
    XK_equal, XK_Cyrillic_U, 0x04F2,
    XK_greater, XK_space, 0x005E,
    XK_greater, XK_quotedbl, 0x201D,
    XK_greater, XK_apostrophe, 0x2019,
    XK_greater, XK_greater, 0x00BB,
    XK_greater, XK_A, 0x00C2,
    XK_greater, XK_E, 0x00CA,
    XK_greater, XK_I, 0x00CE,
    XK_greater, XK_O, 0x00D4,
    XK_greater, XK_U, 0x00DB,
    XK_greater, XK_a, 0x00E2,
    XK_greater, XK_e, 0x00EA,
    XK_greater, XK_i, 0x00EE,
    XK_greater, XK_o, 0x00F4,
    XK_greater, XK_u, 0x00FB,
    XK_greater, 0x0338, 0x226F,
    XK_question, XK_exclam, 0x203D,
    XK_question, XK_question, 0x00BF,
    XK_question, XK_A, 0x1EA2,
    XK_question, XK_E, 0x1EBA,
    XK_question, XK_I, 0x1EC8,
    XK_question, XK_O, 0x1ECE,
    XK_question, XK_U, 0x1EE6,
    XK_question, XK_Y, 0x1EF6,
    XK_question, XK_a, 0x1EA3,
    XK_question, XK_e, 0x1EBB,
    XK_question, XK_i, 0x1EC9,
    XK_question, XK_o, 0x1ECF,
    XK_question, XK_u, 0x1EE7,
    XK_question, XK_y, 0x1EF7,
    XK_question, XK_Acircumflex, 0x1EA8,
    XK_question, XK_Ecircumflex, 0x1EC2,
    XK_question, XK_Ocircumflex, 0x1ED4,
    XK_question, XK_acircumflex, 0x1EA9,
    XK_question, XK_ecircumflex, 0x1EC3,
    XK_question, XK_ocircumflex, 0x1ED5,
    XK_question, XK_Ohorn, 0x1EDE,
    XK_question, XK_ohorn, 0x1EDF,
    XK_question, XK_Uhorn, 0x1EEC,
    XK_question, XK_uhorn, 0x1EED,
    XK_question, XK_Abreve, 0x1EB2,
    XK_question, XK_abreve, 0x1EB3,
    XK_A, XK_quotedbl, 0x00C4,
    XK_A, XK_apostrophe, 0x00C1,
    XK_A, XK_parenleft, 0x0102,
    XK_A, XK_asterisk, 0x00C5,
    XK_A, XK_comma, 0x0104,
    XK_A, XK_minus, 0x00C3,
    XK_A, XK_greater, 0x00C2,
    XK_A, XK_A, 0x00C5,
    XK_A, XK_E, 0x00C6,
    XK_A, XK_T, 0x0040,
    XK_A, XK_asciicircum, 0x00C2,
    XK_A, XK_underscore, 0x00AA,
    XK_A, XK_grave, 0x00C0,
    XK_A, XK_asciitilde, 0x00C3,
    XK_A, XK_diaeresis, 0x00C4,
    XK_A, XK_acute, 0x00C1,
    XK_B, XK_period, 0x1E02,
    XK_C, XK_apostrophe, 0x0106,
    XK_C, XK_comma, 0x00C7,
    XK_C, XK_period, 0x010A,
    XK_C, XK_slash, 0x00A2,
    XK_C, XK_0, 0x00A9,
    XK_C, XK_less, 0x010C,
    XK_C, XK_equal, 0x20AC,
    XK_C, XK_E, 0x20A0,
    XK_C, XK_O, 0x00A9,
    XK_C, XK_o, 0x00A9,
    XK_C, XK_r, 0x20A2,
    XK_C, XK_bar, 0x00A2,
    XK_D, XK_minus, 0x0110,
    XK_D, XK_period, 0x1E0A,
    XK_D, XK_less, 0x010E,
    XK_D, XK_H, 0x00D0,
    XK_E, XK_quotedbl, 0x00CB,
    XK_E, XK_apostrophe, 0x00C9,
    XK_E, XK_comma, 0x0118,
    XK_E, XK_minus, 0x0112,
    XK_E, XK_period, 0x0116,
    XK_E, XK_less, 0x011A,
    XK_E, XK_equal, 0x20AC,
    XK_E, XK_greater, 0x00CA,
    XK_E, XK_asciicircum, 0x00CA,
    XK_E, XK_underscore, 0x0112,
    XK_E, XK_grave, 0x00C8,
    XK_E, XK_diaeresis, 0x00CB,
    XK_E, XK_acute, 0x00C9,
    XK_F, XK_period, 0x1E1E,
    XK_F, XK_r, 0x20A3,
    XK_G, XK_parenleft, 0x011E,
    XK_G, XK_comma, 0x0122,
    XK_G, XK_period, 0x0120,
    XK_G, XK_U, 0x011E,
    XK_G, XK_breve, 0x011E,
    XK_I, XK_quotedbl, 0x00CF,
    XK_I, XK_apostrophe, 0x00CD,
    XK_I, XK_comma, 0x012E,
    XK_I, XK_minus, 0x012A,
    XK_I, XK_period, 0x0130,
    XK_I, XK_greater, 0x00CE,
    XK_I, XK_asciicircum, 0x00CE,
    XK_I, XK_underscore, 0x012A,
    XK_I, XK_grave, 0x00CC,
    XK_I, XK_asciitilde, 0x0128,
    XK_I, XK_diaeresis, 0x00CF,
    XK_I, XK_acute, 0x00CD,
    XK_K, XK_comma, 0x0136,
    XK_L, XK_apostrophe, 0x0139,
    XK_L, XK_comma, 0x013B,
    XK_L, XK_minus, 0x00A3,
    XK_L, XK_slash, 0x0141,
    XK_L, XK_less, 0x013D,
    XK_L, XK_equal, 0x00A3,
    XK_L, XK_V, 0x007C,
    XK_M, XK_period, 0x1E40,
    XK_N, XK_apostrophe, 0x0143,
    XK_N, XK_comma, 0x0145,
    XK_N, XK_minus, 0x00D1,
    XK_N, XK_less, 0x0147,
    XK_N, XK_equal, 0x20A6,
    XK_N, XK_G, 0x014A,
    XK_N, XK_O, 0x2116,
    XK_N, XK_o, 0x2116,
    XK_N, XK_asciitilde, 0x00D1,
    XK_O, XK_quotedbl, 0x00D6,
    XK_O, XK_apostrophe, 0x00D3,
    XK_O, XK_minus, 0x00D5,
    XK_O, XK_slash, 0x00D8,
    XK_O, XK_greater, 0x00D4,
    XK_O, XK_C, 0x00A9,
    XK_O, XK_E, 0x0152,
    XK_O, XK_R, 0x00AE,
    XK_O, XK_S, 0x00A7,
    XK_O, XK_X, 0x00A4,
    XK_O, XK_asciicircum, 0x00D4,
    XK_O, XK_underscore, 0x00BA,
    XK_O, XK_grave, 0x00D2,
    XK_O, XK_c, 0x00A9,
    XK_O, XK_r, 0x00AE,
    XK_O, XK_x, 0x00A4,
    XK_O, XK_asciitilde, 0x00D5,
    XK_O, XK_diaeresis, 0x00D6,
    XK_O, XK_acute, 0x00D3,
    XK_P, XK_exclam, 0x00B6,
    XK_P, XK_period, 0x1E56,
    XK_P, XK_P, 0x00B6,
    XK_P, XK_t, 0x20A7,
    XK_R, XK_apostrophe, 0x0154,
    XK_R, XK_comma, 0x0156,
    XK_R, XK_less, 0x0158,
    XK_R, XK_O, 0x00AE,
    XK_R, XK_s, 0x20A8,
    XK_S, XK_exclam, 0x00A7,
    XK_S, XK_apostrophe, 0x015A,
    XK_S, XK_comma, 0x015E,
    XK_S, XK_period, 0x1E60,
    XK_S, XK_0, 0x00A7,
    XK_S, XK_1, 0x00B9,
    XK_S, XK_2, 0x00B2,
    XK_S, XK_3, 0x00B3,
    XK_S, XK_less, 0x0160,
    XK_S, XK_M, 0x2120,
    XK_S, XK_O, 0x00A7,
    XK_S, XK_m, 0x2120,
    XK_S, XK_cedilla, 0x015E,
    XK_T, XK_minus, 0x0166,
    XK_T, XK_period, 0x1E6A,
    XK_T, XK_slash, 0x0166,
    XK_T, XK_less, 0x0164,
    XK_T, XK_H, 0x00DE,
    XK_T, XK_M, 0x2122,
    XK_T, XK_m, 0x2122,
    XK_U, XK_quotedbl, 0x00DC,
    XK_U, XK_apostrophe, 0x00DA,
    XK_U, XK_asterisk, 0x016E,
    XK_U, XK_comma, 0x0172,
    XK_U, XK_minus, 0x016A,
    XK_U, XK_slash, 0x00B5,
    XK_U, XK_greater, 0x00DB,
    XK_U, XK_A, 0x0102,
    XK_U, XK_E, 0x0114,
    XK_U, XK_G, 0x011E,
    XK_U, XK_I, 0x012C,
    XK_U, XK_O, 0x014E,
    XK_U, XK_U, 0x016C,
    XK_U, XK_asciicircum, 0x00DB,
    XK_U, XK_underscore, 0x016A,
    XK_U, XK_grave, 0x00D9,
    XK_U, XK_a, 0x0103,
    XK_U, XK_e, 0x0115,
    XK_U, XK_g, 0x011F,
    XK_U, XK_i, 0x012D,
    XK_U, XK_o, 0x014F,
    XK_U, XK_u, 0x016D,
    XK_U, XK_asciitilde, 0x0168,
    XK_U, XK_diaeresis, 0x00DC,
    XK_U, XK_acute, 0x00DA,
    XK_U, 0x0228, 0x1E1C,
    XK_U, 0x0229, 0x1E1D,
    XK_U, XK_Cyrillic_a, 0x04D1,
    XK_U, XK_Cyrillic_ie, 0x04D7,
    XK_U, XK_Cyrillic_i, 0x0439,
    XK_U, XK_Cyrillic_u, 0x045E,
    XK_U, XK_Cyrillic_zhe, 0x04C2,
    XK_U, XK_Cyrillic_A, 0x04D0,
    XK_U, XK_Cyrillic_IE, 0x04D6,
    XK_U, XK_Cyrillic_I, 0x0419,
    XK_U, XK_Cyrillic_U, 0x040E,
    XK_U, XK_Cyrillic_ZHE, 0x04C1,
    XK_U, XK_Greek_ALPHA, 0x1FB8,
    XK_U, XK_Greek_IOTA, 0x1FD8,
    XK_U, XK_Greek_UPSILON, 0x1FE8,
    XK_U, XK_Greek_alpha, 0x1FB0,
    XK_U, XK_Greek_iota, 0x1FD0,
    XK_U, XK_Greek_upsilon, 0x1FE0,
    XK_U, 0x1EA0, 0x1EB6,
    XK_U, 0x1EA1, 0x1EB7,
    XK_V, XK_L, 0x007C,
    XK_W, XK_equal, 0x20A9,
    XK_W, XK_asciicircum, 0x0174,
    XK_X, XK_0, 0x00A4,
    XK_X, XK_O, 0x00A4,
    XK_X, XK_o, 0x00A4,
    XK_Y, XK_quotedbl, 0x0178,
    XK_Y, XK_apostrophe, 0x00DD,
    XK_Y, XK_minus, 0x00A5,
    XK_Y, XK_equal, 0x00A5,
    XK_Y, XK_asciicircum, 0x0176,
    XK_Y, XK_diaeresis, 0x0178,
    XK_Y, XK_acute, 0x00DD,
    XK_Z, XK_apostrophe, 0x0179,
    XK_Z, XK_period, 0x017B,
    XK_Z, XK_less, 0x017D,
    XK_asciicircum, XK_space, 0x005E,
    XK_asciicircum, XK_parenleft, 0x207D,
    XK_asciicircum, XK_parenright, 0x207E,
    XK_asciicircum, XK_plus, 0x207A,
    XK_asciicircum, XK_minus, 0x00AF,
    XK_asciicircum, XK_period, 0x00B7,
    XK_asciicircum, XK_slash, 0x007C,
    XK_asciicircum, XK_0, 0x00B0,
    XK_asciicircum, XK_1, 0x00B9,
    XK_asciicircum, XK_2, 0x00B2,
    XK_asciicircum, XK_3, 0x00B3,
    XK_asciicircum, XK_4, 0x2074,
    XK_asciicircum, XK_5, 0x2075,
    XK_asciicircum, XK_6, 0x2076,
    XK_asciicircum, XK_7, 0x2077,
    XK_asciicircum, XK_8, 0x2078,
    XK_asciicircum, XK_9, 0x2079,
    XK_asciicircum, XK_equal, 0x207C,
    XK_asciicircum, XK_A, 0x00C2,
    XK_asciicircum, XK_C, 0x0108,
    XK_asciicircum, XK_E, 0x00CA,
    XK_asciicircum, XK_G, 0x011C,
    XK_asciicircum, XK_H, 0x0124,
    XK_asciicircum, XK_I, 0x00CE,
    XK_asciicircum, XK_J, 0x0134,
    XK_asciicircum, XK_O, 0x00D4,
    XK_asciicircum, XK_S, 0x015C,
    XK_asciicircum, XK_U, 0x00DB,
    XK_asciicircum, XK_W, 0x0174,
    XK_asciicircum, XK_Y, 0x0176,
    XK_asciicircum, XK_Z, 0x1E90,
    XK_asciicircum, XK_underscore, 0x00AF,
    XK_asciicircum, XK_a, 0x00E2,
    XK_asciicircum, XK_c, 0x0109,
    XK_asciicircum, XK_e, 0x00EA,
    XK_asciicircum, XK_g, 0x011D,
    XK_asciicircum, XK_h, 0x0125,
    XK_asciicircum, XK_i, 0x00EE,
    XK_asciicircum, XK_j, 0x0135,
    XK_asciicircum, XK_o, 0x00F4,
    XK_asciicircum, XK_s, 0x015D,
    XK_asciicircum, XK_u, 0x00FB,
    XK_asciicircum, XK_w, 0x0175,
    XK_asciicircum, XK_y, 0x0177,
    XK_asciicircum, XK_z, 0x1E91,
    XK_asciicircum, 0x1EA0, 0x1EAC,
    XK_asciicircum, 0x1EA1, 0x1EAD,
    XK_asciicircum, 0x1EB8, 0x1EC6,
    XK_asciicircum, 0x1EB9, 0x1EC7,
    XK_asciicircum, 0x1ECC, 0x1ED8,
    XK_asciicircum, 0x1ECD, 0x1ED9,
    XK_asciicircum, 0x2212, 0x207B,
    XK_asciicircum, 0x4E00, 0x3192,
    XK_asciicircum, 0x4E01, 0x319C,
    XK_asciicircum, 0x4E09, 0x3194,
    XK_asciicircum, 0x4E0A, 0x3196,
    XK_asciicircum, 0x4E0B, 0x3198,
    XK_asciicircum, 0x4E19, 0x319B,
    XK_asciicircum, 0x4E2D, 0x3197,
    XK_asciicircum, 0x4E59, 0x319A,
    XK_asciicircum, 0x4E8C, 0x3193,
    XK_asciicircum, 0x4EBA, 0x319F,
    XK_asciicircum, 0x56DB, 0x3195,
    XK_asciicircum, 0x5730, 0x319E,
    XK_asciicircum, 0x5929, 0x319D,
    XK_asciicircum, 0x7532, 0x3199,
    XK_asciicircum, XK_KP_Space, 0x00B2,
    XK_asciicircum, XK_KP_Add, 0x207A,
    XK_asciicircum, XK_KP_0, 0x2070,
    XK_asciicircum, XK_KP_1, 0x00B9,
    XK_asciicircum, XK_KP_2, 0x00B2,
    XK_asciicircum, XK_KP_3, 0x00B3,
    XK_asciicircum, XK_KP_4, 0x2074,
    XK_asciicircum, XK_KP_5, 0x2075,
    XK_asciicircum, XK_KP_6, 0x2076,
    XK_asciicircum, XK_KP_7, 0x2077,
    XK_asciicircum, XK_KP_8, 0x2078,
    XK_asciicircum, XK_KP_9, 0x2079,
    XK_asciicircum, XK_KP_Equal, 0x207C,
    XK_underscore, XK_parenleft, 0x208D,
    XK_underscore, XK_parenright, 0x208E,
    XK_underscore, XK_plus, 0x208A,
    XK_underscore, XK_0, 0x2080,
    XK_underscore, XK_1, 0x2081,
    XK_underscore, XK_2, 0x2082,
    XK_underscore, XK_3, 0x2083,
    XK_underscore, XK_4, 0x2084,
    XK_underscore, XK_5, 0x2085,
    XK_underscore, XK_6, 0x2086,
    XK_underscore, XK_7, 0x2087,
    XK_underscore, XK_8, 0x2088,
    XK_underscore, XK_9, 0x2089,
    XK_underscore, XK_equal, 0x208C,
    XK_underscore, XK_A, 0x00AA,
    XK_underscore, XK_E, 0x0112,
    XK_underscore, XK_G, 0x1E20,
    XK_underscore, XK_I, 0x012A,
    XK_underscore, XK_O, 0x00BA,
    XK_underscore, XK_U, 0x016A,
    XK_underscore, XK_Y, 0x0232,
    XK_underscore, XK_asciicircum, 0x00AF,
    XK_underscore, XK_underscore, 0x00AF,
    XK_underscore, XK_a, 0x00AA,
    XK_underscore, XK_e, 0x0113,
    XK_underscore, XK_g, 0x1E21,
    XK_underscore, XK_i, 0x012B,
    XK_underscore, XK_o, 0x00BA,
    XK_underscore, XK_u, 0x016B,
    XK_underscore, XK_y, 0x0233,
    XK_underscore, XK_Adiaeresis, 0x01DE,
    XK_underscore, XK_AE, 0x01E2,
    XK_underscore, XK_Otilde, 0x022C,
    XK_underscore, XK_Odiaeresis, 0x022A,
    XK_underscore, 0x00DC, 0x01D5,
    XK_underscore, XK_adiaeresis, 0x01DF,
    XK_underscore, XK_ae, 0x01E3,
    XK_underscore, XK_otilde, 0x022D,
    XK_underscore, XK_odiaeresis, 0x022B,
    XK_underscore, XK_udiaeresis, 0x01D6,
    XK_underscore, 0x01EA, 0x01EC,
    XK_underscore, 0x01EB, 0x01ED,
    XK_underscore, 0x0226, 0x01E0,
    XK_underscore, 0x0227, 0x01E1,
    XK_underscore, 0x022E, 0x0230,
    XK_underscore, 0x022F, 0x0231,
    XK_underscore, XK_Cyrillic_i, 0x04E3,
    XK_underscore, XK_Cyrillic_u, 0x04EF,
    XK_underscore, XK_Cyrillic_I, 0x04E2,
    XK_underscore, XK_Cyrillic_U, 0x04EE,
    XK_underscore, XK_Greek_ALPHA, 0x1FB9,
    XK_underscore, XK_Greek_IOTA, 0x1FD9,
    XK_underscore, XK_Greek_UPSILON, 0x1FE9,
    XK_underscore, XK_Greek_alpha, 0x1FB1,
    XK_underscore, XK_Greek_iota, 0x1FD1,
    XK_underscore, XK_Greek_upsilon, 0x1FE1,
    XK_underscore, 0x1E36, 0x1E38,
    XK_underscore, 0x1E37, 0x1E39,
    XK_underscore, 0x1E5A, 0x1E5C,
    XK_underscore, 0x1E5B, 0x1E5D,
    XK_underscore, 0x2212, 0x208B,
    XK_underscore, XK_KP_Space, 0x2082,
    XK_underscore, XK_KP_Add, 0x208A,
    XK_underscore, XK_KP_0, 0x2080,
    XK_underscore, XK_KP_1, 0x2081,
    XK_underscore, XK_KP_2, 0x2082,
    XK_underscore, XK_KP_3, 0x2083,
    XK_underscore, XK_KP_4, 0x2084,
    XK_underscore, XK_KP_5, 0x2085,
    XK_underscore, XK_KP_6, 0x2086,
    XK_underscore, XK_KP_7, 0x2087,
    XK_underscore, XK_KP_8, 0x2088,
    XK_underscore, XK_KP_9, 0x2089,
    XK_underscore, XK_KP_Equal, 0x208C,
    XK_grave, XK_space, 0x0060,
    XK_grave, XK_A, 0x00C0,
    XK_grave, XK_E, 0x00C8,
    XK_grave, XK_I, 0x00CC,
    XK_grave, XK_N, 0x01F8,
    XK_grave, XK_O, 0x00D2,
    XK_grave, XK_U, 0x00D9,
    XK_grave, XK_W, 0x1E80,
    XK_grave, XK_Y, 0x1EF2,
    XK_grave, XK_a, 0x00E0,
    XK_grave, XK_e, 0x00E8,
    XK_grave, XK_i, 0x00EC,
    XK_grave, XK_n, 0x01F9,
    XK_grave, XK_o, 0x00F2,
    XK_grave, XK_u, 0x00F9,
    XK_grave, XK_w, 0x1E81,
    XK_grave, XK_y, 0x1EF3,
    XK_grave, XK_Acircumflex, 0x1EA6,
    XK_grave, XK_Ecircumflex, 0x1EC0,
    XK_grave, XK_Ocircumflex, 0x1ED2,
    XK_grave, 0x00DC, 0x01DB,
    XK_grave, XK_acircumflex, 0x1EA7,
    XK_grave, XK_ecircumflex, 0x1EC1,
    XK_grave, XK_ocircumflex, 0x1ED3,
    XK_grave, XK_udiaeresis, 0x01DC,
    XK_grave, XK_Ohorn, 0x1EDC,
    XK_grave, XK_ohorn, 0x1EDD,
    XK_grave, XK_Uhorn, 0x1EEA,
    XK_grave, XK_uhorn, 0x1EEB,
    XK_grave, XK_Abreve, 0x1EB0,
    XK_grave, XK_abreve, 0x1EB1,
    XK_grave, XK_Emacron, 0x1E14,
    XK_grave, XK_emacron, 0x1E15,
    XK_grave, XK_Omacron, 0x1E50,
    XK_grave, XK_omacron, 0x1E51,
    XK_grave, XK_Cyrillic_ie, 0x0450,
    XK_grave, XK_Cyrillic_i, 0x045D,
    XK_grave, XK_Cyrillic_IE, 0x0400,
    XK_grave, XK_Cyrillic_I, 0x040D,
    XK_grave, XK_Greek_iotadieresis, 0x1FD2,
    XK_grave, XK_Greek_upsilondieresis, 0x1FE2,
    XK_grave, XK_Greek_ALPHA, 0x1FBA,
    XK_grave, XK_Greek_EPSILON, 0x1FC8,
    XK_grave, XK_Greek_ETA, 0x1FCA,
    XK_grave, XK_Greek_IOTA, 0x1FDA,
    XK_grave, XK_Greek_OMICRON, 0x1FF8,
    XK_grave, XK_Greek_UPSILON, 0x1FEA,
    XK_grave, XK_Greek_OMEGA, 0x1FFA,
    XK_grave, XK_Greek_alpha, 0x1F70,
    XK_grave, XK_Greek_epsilon, 0x1F72,
    XK_grave, XK_Greek_eta, 0x1F74,
    XK_grave, XK_Greek_iota, 0x1F76,
    XK_grave, XK_Greek_omicron, 0x1F78,
    XK_grave, XK_Greek_upsilon, 0x1F7A,
    XK_grave, XK_Greek_omega, 0x1F7C,
    XK_grave, 0x1F00, 0x1F02,
    XK_grave, 0x1F01, 0x1F03,
    XK_grave, 0x1F08, 0x1F0A,
    XK_grave, 0x1F09, 0x1F0B,
    XK_grave, 0x1F10, 0x1F12,
    XK_grave, 0x1F11, 0x1F13,
    XK_grave, 0x1F18, 0x1F1A,
    XK_grave, 0x1F19, 0x1F1B,
    XK_grave, 0x1F20, 0x1F22,
    XK_grave, 0x1F21, 0x1F23,
    XK_grave, 0x1F28, 0x1F2A,
    XK_grave, 0x1F29, 0x1F2B,
    XK_grave, 0x1F30, 0x1F32,
    XK_grave, 0x1F31, 0x1F33,
    XK_grave, 0x1F38, 0x1F3A,
    XK_grave, 0x1F39, 0x1F3B,
    XK_grave, 0x1F40, 0x1F42,
    XK_grave, 0x1F41, 0x1F43,
    XK_grave, 0x1F48, 0x1F4A,
    XK_grave, 0x1F49, 0x1F4B,
    XK_grave, 0x1F50, 0x1F52,
    XK_grave, 0x1F51, 0x1F53,
    XK_grave, 0x1F59, 0x1F5B,
    XK_grave, 0x1F60, 0x1F62,
    XK_grave, 0x1F61, 0x1F63,
    XK_grave, 0x1F68, 0x1F6A,
    XK_grave, 0x1F69, 0x1F6B,
    XK_a, XK_quotedbl, 0x00E4,
    XK_a, XK_apostrophe, 0x00E1,
    XK_a, XK_parenleft, 0x0103,
    XK_a, XK_asterisk, 0x00E5,
    XK_a, XK_comma, 0x0105,
    XK_a, XK_minus, 0x00E3,
    XK_a, XK_greater, 0x00E2,
    XK_a, XK_asciicircum, 0x00E2,
    XK_a, XK_underscore, 0x00AA,
    XK_a, XK_grave, 0x00E0,
    XK_a, XK_a, 0x00E5,
    XK_a, XK_e, 0x00E6,
    XK_a, XK_asciitilde, 0x00E3,
    XK_a, XK_diaeresis, 0x00E4,
    XK_a, XK_acute, 0x00E1,
    XK_b, XK_period, 0x1E03,
    XK_b, XK_A, 0x0102,
    XK_b, XK_E, 0x0114,
    XK_b, XK_G, 0x011E,
    XK_b, XK_I, 0x012C,
    XK_b, XK_O, 0x014E,
    XK_b, XK_U, 0x016C,
    XK_b, XK_a, 0x0103,
    XK_b, XK_e, 0x0115,
    XK_b, XK_g, 0x011F,
    XK_b, XK_i, 0x012D,
    XK_b, XK_o, 0x014F,
    XK_b, XK_u, 0x016D,
    XK_b, 0x0228, 0x1E1C,
    XK_b, 0x0229, 0x1E1D,
    XK_b, XK_Cyrillic_a, 0x04D1,
    XK_b, XK_Cyrillic_ie, 0x04D7,
    XK_b, XK_Cyrillic_i, 0x0439,
    XK_b, XK_Cyrillic_u, 0x045E,
    XK_b, XK_Cyrillic_zhe, 0x04C2,
    XK_b, XK_Cyrillic_A, 0x04D0,
    XK_b, XK_Cyrillic_IE, 0x04D6,
    XK_b, XK_Cyrillic_I, 0x0419,
    XK_b, XK_Cyrillic_U, 0x040E,
    XK_b, XK_Cyrillic_ZHE, 0x04C1,
    XK_b, XK_Greek_ALPHA, 0x1FB8,
    XK_b, XK_Greek_IOTA, 0x1FD8,
    XK_b, XK_Greek_UPSILON, 0x1FE8,
    XK_b, XK_Greek_alpha, 0x1FB0,
    XK_b, XK_Greek_iota, 0x1FD0,
    XK_b, XK_Greek_upsilon, 0x1FE0,
    XK_b, 0x1EA0, 0x1EB6,
    XK_b, 0x1EA1, 0x1EB7,
    XK_c, XK_apostrophe, 0x0107,
    XK_c, XK_comma, 0x00E7,
    XK_c, XK_period, 0x010B,
    XK_c, XK_slash, 0x00A2,
    XK_c, XK_0, 0x00A9,
    XK_c, XK_less, 0x010D,
    XK_c, XK_equal, 0x20AC,
    XK_c, XK_A, 0x01CD,
    XK_c, XK_C, 0x010C,
    XK_c, XK_D, 0x010E,
    XK_c, XK_E, 0x011A,
    XK_c, XK_G, 0x01E6,
    XK_c, XK_H, 0x021E,
    XK_c, XK_I, 0x01CF,
    XK_c, XK_K, 0x01E8,
    XK_c, XK_L, 0x013D,
    XK_c, XK_N, 0x0147,
    XK_c, XK_O, 0x00A9,
    XK_c, XK_R, 0x0158,
    XK_c, XK_S, 0x0160,
    XK_c, XK_T, 0x0164,
    XK_c, XK_U, 0x01D3,
    XK_c, XK_Z, 0x017D,
    XK_c, XK_a, 0x01CE,
    XK_c, XK_c, 0x010D,
    XK_c, XK_d, 0x010F,
    XK_c, XK_e, 0x011B,
    XK_c, XK_g, 0x01E7,
    XK_c, XK_h, 0x021F,
    XK_c, XK_i, 0x01D0,
    XK_c, XK_j, 0x01F0,
    XK_c, XK_k, 0x01E9,
    XK_c, XK_l, 0x013E,
    XK_c, XK_n, 0x0148,
    XK_c, XK_o, 0x00A9,
    XK_c, XK_r, 0x0159,
    XK_c, XK_s, 0x0161,
    XK_c, XK_t, 0x0165,
    XK_c, XK_u, 0x01D4,
    XK_c, XK_z, 0x017E,
    XK_c, XK_bar, 0x00A2,
    XK_c, 0x00DC, 0x01D9,
    XK_c, XK_udiaeresis, 0x01DA,
    XK_c, 0x01B7, 0x01EE,
    XK_c, 0x0292, 0x01EF,
    XK_d, XK_minus, 0x0111,
    XK_d, XK_period, 0x1E0B,
    XK_d, XK_less, 0x010F,
    XK_d, XK_h, 0x00F0,
    XK_e, XK_quotedbl, 0x00EB,
    XK_e, XK_apostrophe, 0x00E9,
    XK_e, XK_comma, 0x0119,
    XK_e, XK_minus, 0x0113,
    XK_e, XK_period, 0x0117,
    XK_e, XK_less, 0x011B,
    XK_e, XK_equal, 0x20AC,
    XK_e, XK_greater, 0x00EA,
    XK_e, XK_asciicircum, 0x00EA,
    XK_e, XK_underscore, 0x0113,
    XK_e, XK_grave, 0x00E8,
    XK_e, XK_e, 0x0259,
    XK_e, XK_diaeresis, 0x00EB,
    XK_e, XK_acute, 0x00E9,
    XK_f, XK_period, 0x1E1F,
    XK_f, XK_S, 0x017F,
    XK_f, XK_s, 0x017F,
    XK_g, XK_parenleft, 0x011F,
    XK_g, XK_comma, 0x0123,
    XK_g, XK_period, 0x0121,
    XK_g, XK_U, 0x011F,
    XK_g, XK_breve, 0x011F,
    XK_i, XK_quotedbl, 0x00EF,
    XK_i, XK_apostrophe, 0x00ED,
    XK_i, XK_comma, 0x012F,
    XK_i, XK_minus, 0x012B,
    XK_i, XK_period, 0x0131,
    XK_i, XK_greater, 0x00EE,
    XK_i, XK_asciicircum, 0x00EE,
    XK_i, XK_underscore, 0x012B,
    XK_i, XK_grave, 0x00EC,
    XK_i, XK_asciitilde, 0x0129,
    XK_i, XK_diaeresis, 0x00EF,
    XK_i, XK_acute, 0x00ED,
    XK_k, XK_comma, 0x0137,
    XK_k, XK_k, 0x0138,
    XK_l, XK_apostrophe, 0x013A,
    XK_l, XK_comma, 0x013C,
    XK_l, XK_minus, 0x00A3,
    XK_l, XK_slash, 0x0142,
    XK_l, XK_less, 0x013E,
    XK_l, XK_equal, 0x00A3,
    XK_l, XK_v, 0x007C,
    XK_m, XK_period, 0x1E41,
    XK_m, XK_slash, 0x20A5,
    XK_m, XK_u, 0x00B5,
    XK_n, XK_apostrophe, 0x0144,
    XK_n, XK_comma, 0x0146,
    XK_n, XK_minus, 0x00F1,
    XK_n, XK_less, 0x0148,
    XK_n, XK_g, 0x014B,
    XK_n, XK_asciitilde, 0x00F1,
    XK_o, XK_quotedbl, 0x00F6,
    XK_o, XK_apostrophe, 0x00F3,
    XK_o, XK_minus, 0x00F5,
    XK_o, XK_slash, 0x00F8,
    XK_o, XK_greater, 0x00F4,
    XK_o, XK_A, 0x00C5,
    XK_o, XK_C, 0x00A9,
    XK_o, XK_R, 0x00AE,
    XK_o, XK_U, 0x016E,
    XK_o, XK_X, 0x00A4,
    XK_o, XK_asciicircum, 0x00F4,
    XK_o, XK_underscore, 0x00BA,
    XK_o, XK_grave, 0x00F2,
    XK_o, XK_a, 0x00E5,
    XK_o, XK_c, 0x00A9,
    XK_o, XK_e, 0x0153,
    XK_o, XK_o, 0x00B0,
    XK_o, XK_r, 0x00AE,
    XK_o, XK_s, 0x00A7,
    XK_o, XK_u, 0x016F,
    XK_o, XK_w, 0x1E98,
    XK_o, XK_x, 0x00A4,
    XK_o, XK_y, 0x1E99,
    XK_o, XK_asciitilde, 0x00F5,
    XK_o, XK_diaeresis, 0x00F6,
    XK_o, XK_acute, 0x00F3,
    XK_p, XK_exclam, 0x00B6,
    XK_p, XK_period, 0x1E57,
    XK_r, XK_apostrophe, 0x0155,
    XK_r, XK_comma, 0x0157,
    XK_r, XK_less, 0x0159,
    XK_s, XK_exclam, 0x00A7,
    XK_s, XK_apostrophe, 0x015B,
    XK_s, XK_comma, 0x015F,
    XK_s, XK_period, 0x1E61,
    XK_s, XK_0, 0x00A7,
    XK_s, XK_1, 0x00B9,
    XK_s, XK_2, 0x00B2,
    XK_s, XK_3, 0x00B3,
    XK_s, XK_less, 0x0161,
    XK_s, XK_M, 0x2120,
    XK_s, XK_m, 0x2120,
    XK_s, XK_o, 0x00A7,
    XK_s, XK_s, 0x00DF,
    XK_s, XK_cedilla, 0x015F,
    XK_t, XK_minus, 0x0167,
    XK_t, XK_period, 0x1E6B,
    XK_t, XK_slash, 0x0167,
    XK_t, XK_less, 0x0165,
    XK_t, XK_M, 0x2122,
    XK_t, XK_h, 0x00FE,
    XK_t, XK_m, 0x2122,
    XK_u, XK_quotedbl, 0x00FC,
    XK_u, XK_apostrophe, 0x00FA,
    XK_u, XK_asterisk, 0x016F,
    XK_u, XK_comma, 0x0173,
    XK_u, XK_minus, 0x016B,
    XK_u, XK_slash, 0x00B5,
    XK_u, XK_greater, 0x00FB,
    XK_u, XK_asciicircum, 0x00FB,
    XK_u, XK_underscore, 0x016B,
    XK_u, XK_grave, 0x00F9,
    XK_u, XK_u, 0x016D,
    XK_u, XK_asciitilde, 0x0169,
    XK_u, XK_diaeresis, 0x00FC,
    XK_u, XK_acute, 0x00FA,
    XK_v, XK_Z, 0x017D,
    XK_v, XK_l, 0x007C,
    XK_v, XK_z, 0x017E,
    XK_w, XK_asciicircum, 0x0175,
    XK_x, XK_0, 0x00A4,
    XK_x, XK_O, 0x00A4,
    XK_x, XK_o, 0x00A4,
    XK_x, XK_x, 0x00D7,
    XK_y, XK_quotedbl, 0x00FF,
    XK_y, XK_apostrophe, 0x00FD,
    XK_y, XK_minus, 0x00A5,
    XK_y, XK_equal, 0x00A5,
    XK_y, XK_asciicircum, 0x0177,
    XK_y, XK_diaeresis, 0x00FF,
    XK_y, XK_acute, 0x00FD,
    XK_z, XK_apostrophe, 0x017A,
    XK_z, XK_period, 0x017C,
    XK_z, XK_less, 0x017E,
    XK_bar, XK_C, 0x00A2,
    XK_bar, XK_c, 0x00A2,
    XK_asciitilde, XK_space, 0x007E,
    XK_asciitilde, XK_A, 0x00C3,
    XK_asciitilde, XK_E, 0x1EBC,
    XK_asciitilde, XK_I, 0x0128,
    XK_asciitilde, XK_N, 0x00D1,
    XK_asciitilde, XK_O, 0x00D5,
    XK_asciitilde, XK_U, 0x0168,
    XK_asciitilde, XK_V, 0x1E7C,
    XK_asciitilde, XK_Y, 0x1EF8,
    XK_asciitilde, XK_a, 0x00E3,
    XK_asciitilde, XK_e, 0x1EBD,
    XK_asciitilde, XK_i, 0x0129,
    XK_asciitilde, XK_n, 0x00F1,
    XK_asciitilde, XK_o, 0x00F5,
    XK_asciitilde, XK_u, 0x0169,
    XK_asciitilde, XK_v, 0x1E7D,
    XK_asciitilde, XK_y, 0x1EF9,
    XK_asciitilde, XK_Acircumflex, 0x1EAA,
    XK_asciitilde, XK_Ecircumflex, 0x1EC4,
    XK_asciitilde, XK_Ocircumflex, 0x1ED6,
    XK_asciitilde, XK_acircumflex, 0x1EAB,
    XK_asciitilde, XK_ecircumflex, 0x1EC5,
    XK_asciitilde, XK_ocircumflex, 0x1ED7,
    XK_asciitilde, XK_Ohorn, 0x1EE0,
    XK_asciitilde, XK_ohorn, 0x1EE1,
    XK_asciitilde, XK_Uhorn, 0x1EEE,
    XK_asciitilde, XK_uhorn, 0x1EEF,
    XK_asciitilde, XK_Abreve, 0x1EB4,
    XK_asciitilde, XK_abreve, 0x1EB5,
    XK_asciitilde, XK_Greek_iotadieresis, 0x1FD7,
    XK_asciitilde, XK_Greek_upsilondieresis, 0x1FE7,
    XK_asciitilde, XK_Greek_alpha, 0x1FB6,
    XK_asciitilde, XK_Greek_eta, 0x1FC6,
    XK_asciitilde, XK_Greek_iota, 0x1FD6,
    XK_asciitilde, XK_Greek_upsilon, 0x1FE6,
    XK_asciitilde, XK_Greek_omega, 0x1FF6,
    XK_asciitilde, 0x1F00, 0x1F06,
    XK_asciitilde, 0x1F01, 0x1F07,
    XK_asciitilde, 0x1F08, 0x1F0E,
    XK_asciitilde, 0x1F09, 0x1F0F,
    XK_asciitilde, 0x1F20, 0x1F26,
    XK_asciitilde, 0x1F21, 0x1F27,
    XK_asciitilde, 0x1F28, 0x1F2E,
    XK_asciitilde, 0x1F29, 0x1F2F,
    XK_asciitilde, 0x1F30, 0x1F36,
    XK_asciitilde, 0x1F31, 0x1F37,
    XK_asciitilde, 0x1F38, 0x1F3E,
    XK_asciitilde, 0x1F39, 0x1F3F,
    XK_asciitilde, 0x1F50, 0x1F56,
    XK_asciitilde, 0x1F51, 0x1F57,
    XK_asciitilde, 0x1F59, 0x1F5F,
    XK_asciitilde, 0x1F60, 0x1F66,
    XK_asciitilde, 0x1F61, 0x1F67,
    XK_asciitilde, 0x1F68, 0x1F6E,
    XK_asciitilde, 0x1F69, 0x1F6F,
    XK_diaeresis, XK_apostrophe, 0x0385,
    XK_diaeresis, XK_A, 0x00C4,
    XK_diaeresis, XK_E, 0x00CB,
    XK_diaeresis, XK_I, 0x00CF,
    XK_diaeresis, XK_O, 0x00D6,
    XK_diaeresis, XK_U, 0x00DC,
    XK_diaeresis, XK_Y, 0x0178,
    XK_diaeresis, XK_grave, 0x1FED,
    XK_diaeresis, XK_a, 0x00E4,
    XK_diaeresis, XK_e, 0x00EB,
    XK_diaeresis, XK_i, 0x00EF,
    XK_diaeresis, XK_o, 0x00F6,
    XK_diaeresis, XK_u, 0x00FC,
    XK_diaeresis, XK_y, 0x00FF,
    XK_diaeresis, XK_asciitilde, 0x1FC1,
    XK_diaeresis, XK_acute, 0x0385,
    XK_diaeresis, XK_dead_grave, 0x1FED,
    XK_diaeresis, XK_dead_acute, 0x0385,
    XK_diaeresis, XK_dead_tilde, 0x1FC1,
    XK_macron, XK_A, 0x0100,
    XK_macron, XK_E, 0x0112,
    XK_macron, XK_G, 0x1E20,
    XK_macron, XK_I, 0x012A,
    XK_macron, XK_O, 0x014C,
    XK_macron, XK_U, 0x016A,
    XK_macron, XK_Y, 0x0232,
    XK_macron, XK_a, 0x0101,
    XK_macron, XK_e, 0x0113,
    XK_macron, XK_g, 0x1E21,
    XK_macron, XK_i, 0x012B,
    XK_macron, XK_o, 0x014D,
    XK_macron, XK_u, 0x016B,
    XK_macron, XK_y, 0x0233,
    XK_macron, XK_Adiaeresis, 0x01DE,
    XK_macron, XK_AE, 0x01E2,
    XK_macron, XK_Otilde, 0x022C,
    XK_macron, XK_Odiaeresis, 0x022A,
    XK_macron, 0x00DC, 0x01D5,
    XK_macron, XK_adiaeresis, 0x01DF,
    XK_macron, XK_ae, 0x01E3,
    XK_macron, XK_otilde, 0x022D,
    XK_macron, XK_odiaeresis, 0x022B,
    XK_macron, XK_udiaeresis, 0x01D6,
    XK_macron, 0x01EA, 0x01EC,
    XK_macron, 0x01EB, 0x01ED,
    XK_macron, 0x0226, 0x01E0,
    XK_macron, 0x0227, 0x01E1,
    XK_macron, 0x022E, 0x0230,
    XK_macron, 0x022F, 0x0231,
    XK_macron, XK_Cyrillic_i, 0x04E3,
    XK_macron, XK_Cyrillic_u, 0x04EF,
    XK_macron, XK_Cyrillic_I, 0x04E2,
    XK_macron, XK_Cyrillic_U, 0x04EE,
    XK_macron, XK_Greek_ALPHA, 0x1FB9,
    XK_macron, XK_Greek_IOTA, 0x1FD9,
    XK_macron, XK_Greek_UPSILON, 0x1FE9,
    XK_macron, XK_Greek_alpha, 0x1FB1,
    XK_macron, XK_Greek_iota, 0x1FD1,
    XK_macron, XK_Greek_upsilon, 0x1FE1,
    XK_macron, 0x1E36, 0x1E38,
    XK_macron, 0x1E37, 0x1E39,
    XK_macron, 0x1E5A, 0x1E5C,
    XK_macron, 0x1E5B, 0x1E5D,
    XK_acute, XK_A, 0x00C1,
    XK_acute, XK_C, 0x0106,
    XK_acute, XK_E, 0x00C9,
    XK_acute, XK_G, 0x01F4,
    XK_acute, XK_I, 0x00CD,
    XK_acute, XK_K, 0x1E30,
    XK_acute, XK_L, 0x0139,
    XK_acute, XK_M, 0x1E3E,
    XK_acute, XK_N, 0x0143,
    XK_acute, XK_O, 0x00D3,
    XK_acute, XK_P, 0x1E54,
    XK_acute, XK_R, 0x0154,
    XK_acute, XK_S, 0x015A,
    XK_acute, XK_U, 0x00DA,
    XK_acute, XK_W, 0x1E82,
    XK_acute, XK_Y, 0x00DD,
    XK_acute, XK_Z, 0x0179,
    XK_acute, XK_a, 0x00E1,
    XK_acute, XK_c, 0x0107,
    XK_acute, XK_e, 0x00E9,
    XK_acute, XK_g, 0x01F5,
    XK_acute, XK_i, 0x00ED,
    XK_acute, XK_k, 0x1E31,
    XK_acute, XK_l, 0x013A,
    XK_acute, XK_m, 0x1E3F,
    XK_acute, XK_n, 0x0144,
    XK_acute, XK_o, 0x00F3,
    XK_acute, XK_p, 0x1E55,
    XK_acute, XK_r, 0x0155,
    XK_acute, XK_s, 0x015B,
    XK_acute, XK_u, 0x00FA,
    XK_acute, XK_w, 0x1E83,
    XK_acute, XK_y, 0x00FD,
    XK_acute, XK_z, 0x017A,
    XK_acute, XK_Acircumflex, 0x1EA4,
    XK_acute, XK_Aring, 0x01FA,
    XK_acute, XK_AE, 0x01FC,
    XK_acute, XK_Ccedilla, 0x1E08,
    XK_acute, XK_Ecircumflex, 0x1EBE,
    XK_acute, XK_Idiaeresis, 0x1E2E,
    XK_acute, XK_Ocircumflex, 0x1ED0,
    XK_acute, XK_Otilde, 0x1E4C,
    XK_acute, XK_Ooblique, 0x01FE,
    XK_acute, 0x00DC, 0x01D7,
    XK_acute, XK_acircumflex, 0x1EA5,
    XK_acute, XK_aring, 0x01FB,
    XK_acute, XK_ae, 0x01FD,
    XK_acute, XK_ccedilla, 0x1E09,
    XK_acute, XK_ecircumflex, 0x1EBF,
    XK_acute, XK_idiaeresis, 0x1E2F,
    XK_acute, XK_ocircumflex, 0x1ED1,
    XK_acute, XK_otilde, 0x1E4D,
    XK_acute, XK_oslash, 0x01FF,
    XK_acute, XK_udiaeresis, 0x01D8,
    XK_acute, XK_Ohorn, 0x1EDA,
    XK_acute, XK_ohorn, 0x1EDB,
    XK_acute, XK_Uhorn, 0x1EE8,
    XK_acute, XK_uhorn, 0x1EE9,
    XK_acute, XK_Abreve, 0x1EAE,
    XK_acute, XK_abreve, 0x1EAF,
    XK_acute, XK_Emacron, 0x1E16,
    XK_acute, XK_emacron, 0x1E17,
    XK_acute, XK_Omacron, 0x1E52,
    XK_acute, XK_Utilde, 0x1E78,
    XK_acute, XK_omacron, 0x1E53,
    XK_acute, XK_utilde, 0x1E79,
    XK_acute, XK_Cyrillic_ghe, 0x0453,
    XK_acute, XK_Cyrillic_ka, 0x045C,
    XK_acute, XK_Cyrillic_GHE, 0x0403,
    XK_acute, XK_Cyrillic_KA, 0x040C,
    XK_acute, XK_Greek_iotadieresis, 0x0390,
    XK_acute, XK_Greek_upsilondieresis, 0x03B0,
    XK_acute, XK_Greek_ALPHA, 0x0386,
    XK_acute, XK_Greek_EPSILON, 0x0388,
    XK_acute, XK_Greek_ETA, 0x0389,
    XK_acute, XK_Greek_IOTA, 0x038A,
    XK_acute, XK_Greek_OMICRON, 0x038C,
    XK_acute, XK_Greek_UPSILON, 0x038E,
    XK_acute, XK_Greek_OMEGA, 0x038F,
    XK_acute, XK_Greek_alpha, 0x03AC,
    XK_acute, XK_Greek_epsilon, 0x03AD,
    XK_acute, XK_Greek_eta, 0x03AE,
    XK_acute, XK_Greek_iota, 0x03AF,
    XK_acute, XK_Greek_omicron, 0x03CC,
    XK_acute, XK_Greek_upsilon, 0x03CD,
    XK_acute, XK_Greek_omega, 0x03CE,
    XK_acute, 0x1F00, 0x1F04,
    XK_acute, 0x1F01, 0x1F05,
    XK_acute, 0x1F08, 0x1F0C,
    XK_acute, 0x1F09, 0x1F0D,
    XK_acute, 0x1F10, 0x1F14,
    XK_acute, 0x1F11, 0x1F15,
    XK_acute, 0x1F18, 0x1F1C,
    XK_acute, 0x1F19, 0x1F1D,
    XK_acute, 0x1F20, 0x1F24,
    XK_acute, 0x1F21, 0x1F25,
    XK_acute, 0x1F28, 0x1F2C,
    XK_acute, 0x1F29, 0x1F2D,
    XK_acute, 0x1F30, 0x1F34,
    XK_acute, 0x1F31, 0x1F35,
    XK_acute, 0x1F38, 0x1F3C,
    XK_acute, 0x1F39, 0x1F3D,
    XK_acute, 0x1F40, 0x1F44,
    XK_acute, 0x1F41, 0x1F45,
    XK_acute, 0x1F48, 0x1F4C,
    XK_acute, 0x1F49, 0x1F4D,
    XK_acute, 0x1F50, 0x1F54,
    XK_acute, 0x1F51, 0x1F55,
    XK_acute, 0x1F59, 0x1F5D,
    XK_acute, 0x1F60, 0x1F64,
    XK_acute, 0x1F61, 0x1F65,
    XK_acute, 0x1F68, 0x1F6C,
    XK_acute, 0x1F69, 0x1F6D,
    XK_cedilla, XK_C, 0x00C7,
    XK_cedilla, XK_D, 0x1E10,
    XK_cedilla, XK_E, 0x0228,
    XK_cedilla, XK_G, 0x0122,
    XK_cedilla, XK_H, 0x1E28,
    XK_cedilla, XK_K, 0x0136,
    XK_cedilla, XK_L, 0x013B,
    XK_cedilla, XK_N, 0x0145,
    XK_cedilla, XK_R, 0x0156,
    XK_cedilla, XK_S, 0x015E,
    XK_cedilla, XK_T, 0x0162,
    XK_cedilla, XK_c, 0x00E7,
    XK_cedilla, XK_d, 0x1E11,
    XK_cedilla, XK_e, 0x0229,
    XK_cedilla, XK_g, 0x0123,
    XK_cedilla, XK_h, 0x1E29,
    XK_cedilla, XK_k, 0x0137,
    XK_cedilla, XK_l, 0x013C,
    XK_cedilla, XK_n, 0x0146,
    XK_cedilla, XK_r, 0x0157,
    XK_cedilla, XK_s, 0x015F,
    XK_cedilla, XK_t, 0x0163,
    XK_breve, XK_G, 0x011E,
    XK_breve, XK_g, 0x011F,
    0x05B4, XK_hebrew_yod, 0xFB1D,
    0x05B7, 0x05F2, 0xFB1F,
    0x05B7, XK_hebrew_aleph, 0xFB2E,
    0x05B8, XK_hebrew_aleph, 0xFB2F,
    0x05B9, XK_hebrew_waw, 0xFB4B,
    0x05BC, XK_hebrew_aleph, 0xFB30,
    0x05BC, XK_hebrew_beth, 0xFB31,
    0x05BC, XK_hebrew_gimmel, 0xFB32,
    0x05BC, XK_hebrew_daleth, 0xFB33,
    0x05BC, XK_hebrew_he, 0xFB34,
    0x05BC, XK_hebrew_waw, 0xFB35,
    0x05BC, XK_hebrew_zayin, 0xFB36,
    0x05BC, XK_hebrew_teth, 0xFB38,
    0x05BC, XK_hebrew_yod, 0xFB39,
    0x05BC, XK_hebrew_finalkaph, 0xFB3A,
    0x05BC, XK_hebrew_kaph, 0xFB3B,
    0x05BC, XK_hebrew_lamed, 0xFB3C,
    0x05BC, XK_hebrew_mem, 0xFB3E,
    0x05BC, XK_hebrew_nun, 0xFB40,
    0x05BC, XK_hebrew_samekh, 0xFB41,
    0x05BC, XK_hebrew_finalpe, 0xFB43,
    0x05BC, XK_hebrew_pe, 0xFB44,
    0x05BC, XK_hebrew_zadi, 0xFB46,
    0x05BC, XK_hebrew_qoph, 0xFB47,
    0x05BC, XK_hebrew_resh, 0xFB48,
    0x05BC, XK_hebrew_shin, 0xFB49,
    0x05BC, XK_hebrew_taw, 0xFB4A,
    0x05BF, XK_hebrew_beth, 0xFB4C,
    0x05BF, XK_hebrew_kaph, 0xFB4D,
    0x05BF, XK_hebrew_pe, 0xFB4E,
    0x05C1, XK_hebrew_shin, 0xFB2A,
    0x05C1, 0xFB49, 0xFB2C,
    0x05C2, XK_hebrew_shin, 0xFB2B,
    0x05C2, 0xFB49, 0xFB2D,
    0x0653, XK_Arabic_alef, 0x0622,
    0x0654, XK_Arabic_alef, 0x0623,
    0x0654, XK_Arabic_waw, 0x0624,
    0x0654, XK_Arabic_yeh, 0x0626,
    0x0654, 0x06C1, 0x06C2,
    0x0654, 0x06D2, 0x06D3,
    0x0654, 0x06D5, 0x06C0,
    0x0655, XK_Arabic_alef, 0x0625,
    XK_Cyrillic_pe, XK_Cyrillic_a, 0x00A7,
    XK_Cyrillic_IE, XK_equal, 0x20AC,
    XK_Cyrillic_EN, XK_Cyrillic_o, 0x2116,
    XK_Cyrillic_EN, XK_Cyrillic_O, 0x2116,
    XK_Cyrillic_ES, XK_equal, 0x20AC,
    XK_Greek_ALPHA, XK_apostrophe, 0x0386,
    XK_Greek_EPSILON, XK_apostrophe, 0x0388,
    XK_Greek_ETA, XK_apostrophe, 0x0389,
    XK_Greek_IOTA, XK_quotedbl, 0x03AA,
    XK_Greek_IOTA, XK_apostrophe, 0x038A,
    XK_Greek_OMICRON, XK_apostrophe, 0x038C,
    XK_Greek_UPSILON, XK_quotedbl, 0x03AB,
    XK_Greek_UPSILON, XK_apostrophe, 0x038E,
    XK_Greek_OMEGA, XK_apostrophe, 0x038F,
    XK_Greek_alpha, XK_apostrophe, 0x03AC,
    XK_Greek_epsilon, XK_apostrophe, 0x03AD,
    XK_Greek_eta, XK_apostrophe, 0x03AE,
    XK_Greek_iota, XK_quotedbl, 0x03CA,
    XK_Greek_iota, XK_apostrophe, 0x03AF,
    XK_Greek_iota, XK_Greek_alphaaccent, 0x1FB4,
    XK_Greek_iota, XK_Greek_etaaccent, 0x1FC4,
    XK_Greek_iota, XK_Greek_omegaaccent, 0x1FF4,
    XK_Greek_iota, XK_Greek_ALPHA, 0x1FBC,
    XK_Greek_iota, XK_Greek_ETA, 0x1FCC,
    XK_Greek_iota, XK_Greek_OMEGA, 0x1FFC,
    XK_Greek_iota, XK_Greek_alpha, 0x1FB3,
    XK_Greek_iota, XK_Greek_eta, 0x1FC3,
    XK_Greek_iota, XK_Greek_omega, 0x1FF3,
    XK_Greek_iota, 0x1F00, 0x1F80,
    XK_Greek_iota, 0x1F01, 0x1F81,
    XK_Greek_iota, 0x1F02, 0x1F82,
    XK_Greek_iota, 0x1F03, 0x1F83,
    XK_Greek_iota, 0x1F04, 0x1F84,
    XK_Greek_iota, 0x1F05, 0x1F85,
    XK_Greek_iota, 0x1F06, 0x1F86,
    XK_Greek_iota, 0x1F07, 0x1F87,
    XK_Greek_iota, 0x1F08, 0x1F88,
    XK_Greek_iota, 0x1F09, 0x1F89,
    XK_Greek_iota, 0x1F0A, 0x1F8A,
    XK_Greek_iota, 0x1F0B, 0x1F8B,
    XK_Greek_iota, 0x1F0C, 0x1F8C,
    XK_Greek_iota, 0x1F0D, 0x1F8D,
    XK_Greek_iota, 0x1F0E, 0x1F8E,
    XK_Greek_iota, 0x1F0F, 0x1F8F,
    XK_Greek_iota, 0x1F20, 0x1F90,
    XK_Greek_iota, 0x1F21, 0x1F91,
    XK_Greek_iota, 0x1F22, 0x1F92,
    XK_Greek_iota, 0x1F23, 0x1F93,
    XK_Greek_iota, 0x1F24, 0x1F94,
    XK_Greek_iota, 0x1F25, 0x1F95,
    XK_Greek_iota, 0x1F26, 0x1F96,
    XK_Greek_iota, 0x1F27, 0x1F97,
    XK_Greek_iota, 0x1F28, 0x1F98,
    XK_Greek_iota, 0x1F29, 0x1F99,
    XK_Greek_iota, 0x1F2A, 0x1F9A,
    XK_Greek_iota, 0x1F2B, 0x1F9B,
    XK_Greek_iota, 0x1F2C, 0x1F9C,
    XK_Greek_iota, 0x1F2D, 0x1F9D,
    XK_Greek_iota, 0x1F2E, 0x1F9E,
    XK_Greek_iota, 0x1F2F, 0x1F9F,
    XK_Greek_iota, 0x1F60, 0x1FA0,
    XK_Greek_iota, 0x1F61, 0x1FA1,
    XK_Greek_iota, 0x1F62, 0x1FA2,
    XK_Greek_iota, 0x1F63, 0x1FA3,
    XK_Greek_iota, 0x1F64, 0x1FA4,
    XK_Greek_iota, 0x1F65, 0x1FA5,
    XK_Greek_iota, 0x1F66, 0x1FA6,
    XK_Greek_iota, 0x1F67, 0x1FA7,
    XK_Greek_iota, 0x1F68, 0x1FA8,
    XK_Greek_iota, 0x1F69, 0x1FA9,
    XK_Greek_iota, 0x1F6A, 0x1FAA,
    XK_Greek_iota, 0x1F6B, 0x1FAB,
    XK_Greek_iota, 0x1F6C, 0x1FAC,
    XK_Greek_iota, 0x1F6D, 0x1FAD,
    XK_Greek_iota, 0x1F6E, 0x1FAE,
    XK_Greek_iota, 0x1F6F, 0x1FAF,
    XK_Greek_iota, 0x1F70, 0x1FB2,
    XK_Greek_iota, 0x1F74, 0x1FC2,
    XK_Greek_iota, 0x1F7C, 0x1FF2,
    XK_Greek_iota, 0x1FB6, 0x1FB7,
    XK_Greek_iota, 0x1FC6, 0x1FC7,
    XK_Greek_iota, 0x1FF6, 0x1FF7,
    XK_Greek_omicron, XK_apostrophe, 0x03CC,
    XK_Greek_upsilon, XK_quotedbl, 0x03CB,
    XK_Greek_upsilon, XK_apostrophe, 0x03CD,
    XK_Greek_omega, XK_apostrophe, 0x03CE,
    XK_lessthanequal, 0x0338, 0x2270,
    XK_greaterthanequal, 0x0338, 0x2271,
    XK_approximate, 0x0338, 0x2247,
    XK_identical, 0x0338, 0x2262,
    XK_includedin, 0x0338, 0x2284,
    XK_includes, 0x0338, 0x2285,
    0x093C, 0x0915, 0x0958,
    0x093C, 0x0916, 0x0959,
    0x093C, 0x0917, 0x095A,
    0x093C, 0x091C, 0x095B,
    0x093C, 0x0921, 0x095C,
    0x093C, 0x0922, 0x095D,
    0x093C, 0x0928, 0x0929,
    0x093C, 0x092B, 0x095E,
    0x093C, 0x092F, 0x095F,
    0x093C, 0x0930, 0x0931,
    0x093C, 0x0933, 0x0934,
    0x09BC, 0x09A1, 0x09DC,
    0x09BC, 0x09A2, 0x09DD,
    0x09BC, 0x09AF, 0x09DF,
    0x09C7, 0x09BE, 0x09CB,
    0x09C7, 0x09D7, 0x09CC,
    0x0A3C, 0x0A16, 0x0A59,
    0x0A3C, 0x0A17, 0x0A5A,
    0x0A3C, 0x0A1C, 0x0A5B,
    0x0A3C, 0x0A2B, 0x0A5E,
    0x0A3C, 0x0A32, 0x0A33,
    0x0A3C, 0x0A38, 0x0A36,
    0x0B3C, 0x0B21, 0x0B5C,
    0x0B3C, 0x0B22, 0x0B5D,
    0x0B47, 0x0B3E, 0x0B4B,
    0x0B47, 0x0B56, 0x0B48,
    0x0B47, 0x0B57, 0x0B4C,
    XK_leftcaret, 0x0338, 0x226E,
    XK_rightcaret, 0x0338, 0x226F,
    XK_underbar, XK_parenleft, 0x208D,
    XK_underbar, XK_parenright, 0x208E,
    XK_underbar, XK_plus, 0x208A,
    XK_underbar, XK_0, 0x2080,
    XK_underbar, XK_1, 0x2081,
    XK_underbar, XK_2, 0x2082,
    XK_underbar, XK_3, 0x2083,
    XK_underbar, XK_4, 0x2084,
    XK_underbar, XK_5, 0x2085,
    XK_underbar, XK_6, 0x2086,
    XK_underbar, XK_7, 0x2087,
    XK_underbar, XK_8, 0x2088,
    XK_underbar, XK_9, 0x2089,
    XK_underbar, XK_equal, 0x208C,
    0x0BC6, 0x0BBE, 0x0BCA,
    0x0BC6, 0x0BD7, 0x0BCC,
    XK_underbar, 0x2212, 0x208B,
    XK_underbar, XK_KP_Space, 0x2082,
    XK_underbar, XK_KP_Add, 0x208A,
    XK_underbar, XK_KP_0, 0x2080,
    XK_underbar, XK_KP_1, 0x2081,
    XK_underbar, XK_KP_2, 0x2082,
    XK_underbar, XK_KP_3, 0x2083,
    XK_underbar, XK_KP_4, 0x2084,
    XK_underbar, XK_KP_5, 0x2085,
    XK_underbar, XK_KP_6, 0x2086,
    XK_underbar, XK_KP_7, 0x2087,
    XK_underbar, XK_KP_8, 0x2088,
    XK_underbar, XK_KP_9, 0x2089,
    XK_underbar, XK_KP_Equal, 0x208C,
    0x0BC7, 0x0BBE, 0x0BCB,
    0x0BD7, 0x0B92, 0x0B94,
    XK_rightshoe, 0x0338, 0x2285,
    XK_leftshoe, 0x0338, 0x2284,
    XK_righttack, 0x0338, 0x22AC,
    0x0C46, 0x0C56, 0x0C48,
    0x0CBF, 0x0CD5, 0x0CC0,
    0x0CC6, 0x0CC2, 0x0CCA,
    0x0CC6, 0x0CD5, 0x0CC7,
    0x0CC6, 0x0CD6, 0x0CC8,
    0x0CCA, 0x0CD5, 0x0CCB,
    0x0D46, 0x0D3E, 0x0D4A,
    0x0D46, 0x0D57, 0x0D4C,
    0x0D47, 0x0D3E, 0x0D4B,
    0x0DD9, 0x0DCA, 0x0DDA,
    0x0DD9, 0x0DCF, 0x0DDC,
    0x0DD9, 0x0DDF, 0x0DDE,
    0x0DDC, 0x0DCA, 0x0DDD,
    0x0F71, 0x0F72, 0x0F73,
    0x0F71, 0x0F74, 0x0F75,
    0x0F71, 0x0F80, 0x0F81,
    0x0F90, 0x0FB5, 0x0FB9,
    0x0F92, 0x0FB7, 0x0F93,
    0x0F9C, 0x0FB7, 0x0F9D,
    0x0FA1, 0x0FB7, 0x0FA2,
    0x0FA6, 0x0FB7, 0x0FA7,
    0x0FAB, 0x0FB7, 0x0FAC,
    0x0FB2, 0x0F80, 0x0F76,
    0x0FB3, 0x0F80, 0x0F78,
    0x0FB5, 0x0F40, 0x0F69,
    0x0FB7, 0x0F42, 0x0F43,
    0x0FB7, 0x0F4C, 0x0F4D,
    0x0FB7, 0x0F51, 0x0F52,
    0x0FB7, 0x0F56, 0x0F57,
    0x0FB7, 0x0F5B, 0x0F5C,
    0x102E, 0x1025, 0x1026,
    0x1100, 0x1100, 0x1101,
    0x1102, 0x1100, 0x1113,
    0x1102, 0x1102, 0x1114,
    0x1102, 0x1103, 0x1115,
    0x1102, 0x1107, 0x1116,
    0x1103, 0x1100, 0x1117,
    0x1103, 0x1103, 0x1104,
    0x1105, 0x1102, 0x1118,
    0x1105, 0x1105, 0x1119,
    0x1105, 0x110B, 0x111B,
    0x1105, 0x1112, 0x111A,
    0x1106, 0x1107, 0x111C,
    0x1106, 0x110B, 0x111D,
    0x1107, 0x1100, 0x111E,
    0x1107, 0x1102, 0x111F,
    0x1107, 0x1103, 0x1120,
    0x1107, 0x1107, 0x1108,
    0x1107, 0x1109, 0x1121,
    0x1107, 0x110A, 0x1125,
    0x1107, 0x110B, 0x112B,
    0x1107, 0x110C, 0x1127,
    0x1107, 0x110E, 0x1128,
    0x1107, 0x1110, 0x1129,
    0x1107, 0x1111, 0x112A,
    0x1107, 0x112B, 0x112C,
    0x1107, 0x112D, 0x1122,
    0x1107, 0x112F, 0x1123,
    0x1107, 0x1132, 0x1124,
    0x1107, 0x1136, 0x1126,
    0x1108, 0x110B, 0x112C,
    0x1109, 0x1100, 0x112D,
    0x1109, 0x1102, 0x112E,
    0x1109, 0x1103, 0x112F,
    0x1109, 0x1105, 0x1130,
    0x1109, 0x1106, 0x1131,
    0x1109, 0x1107, 0x1132,
    0x1109, 0x1109, 0x110A,
    0x1109, 0x110A, 0x1134,
    0x1109, 0x110B, 0x1135,
    0x1109, 0x110C, 0x1136,
    0x1109, 0x110E, 0x1137,
    0x1109, 0x110F, 0x1138,
    0x1109, 0x1110, 0x1139,
    0x1109, 0x1111, 0x113A,
    0x1109, 0x1112, 0x113B,
    0x1109, 0x111E, 0x1133,
    0x110A, 0x1109, 0x1134,
    0x110B, 0x1100, 0x1141,
    0x110B, 0x1103, 0x1142,
    0x110B, 0x1106, 0x1143,
    0x110B, 0x1107, 0x1144,
    0x110B, 0x1109, 0x1145,
    0x110B, 0x110B, 0x1147,
    0x110B, 0x110C, 0x1148,
    0x110B, 0x110E, 0x1149,
    0x110B, 0x1110, 0x114A,
    0x110B, 0x1111, 0x114B,
    0x110B, 0x1140, 0x1146,
    0x110C, 0x110B, 0x114D,
    0x110C, 0x110C, 0x110D,
    0x110E, 0x110F, 0x1152,
    0x110E, 0x1112, 0x1153,
    0x1111, 0x1107, 0x1156,
    0x1111, 0x110B, 0x1157,
    0x1112, 0x1112, 0x1158,
    0x1121, 0x1100, 0x1122,
    0x1121, 0x1103, 0x1123,
    0x1121, 0x1107, 0x1124,
    0x1121, 0x1109, 0x1125,
    0x1121, 0x110C, 0x1126,
    0x1132, 0x1100, 0x1133,
    0x113C, 0x113C, 0x113D,
    0x113E, 0x113E, 0x113F,
    0x114E, 0x114E, 0x114F,
    0x1150, 0x1150, 0x1151,
    0x1161, 0x1169, 0x1176,
    0x1161, 0x116E, 0x1177,
    0x1161, 0x1175, 0x1162,
    0x1163, 0x1169, 0x1178,
    0x1163, 0x116D, 0x1179,
    0x1163, 0x1175, 0x1164,
    0x1165, 0x1169, 0x117A,
    0x1165, 0x116E, 0x117B,
    0x1165, 0x1173, 0x117C,
    0x1165, 0x1175, 0x1166,
    0x1167, 0x1169, 0x117D,
    0x1167, 0x116E, 0x117E,
    0x1167, 0x1175, 0x1168,
    0x1169, 0x1161, 0x116A,
    0x1169, 0x1162, 0x116B,
    0x1169, 0x1165, 0x117F,
    0x1169, 0x1166, 0x1180,
    0x1169, 0x1168, 0x1181,
    0x1169, 0x1169, 0x1182,
    0x1169, 0x116E, 0x1183,
    0x1169, 0x1175, 0x116C,
    0x116A, 0x1175, 0x116B,
    0x116D, 0x1163, 0x1184,
    0x116D, 0x1164, 0x1185,
    0x116D, 0x1167, 0x1186,
    0x116D, 0x1169, 0x1187,
    0x116D, 0x1175, 0x1188,
    0x116E, 0x1161, 0x1189,
    0x116E, 0x1162, 0x118A,
    0x116E, 0x1165, 0x116F,
    0x116E, 0x1166, 0x1170,
    0x116E, 0x1168, 0x118C,
    0x116E, 0x116E, 0x118D,
    0x116E, 0x1175, 0x1171,
    0x116E, 0x117C, 0x118B,
    0x116F, 0x1173, 0x118B,
    0x116F, 0x1175, 0x1170,
    0x1172, 0x1161, 0x118E,
    0x1172, 0x1165, 0x118F,
    0x1172, 0x1166, 0x1190,
    0x1172, 0x1167, 0x1191,
    0x1172, 0x1168, 0x1192,
    0x1172, 0x116E, 0x1193,
    0x1172, 0x1175, 0x1194,
    0x1173, 0x116E, 0x1195,
    0x1173, 0x1173, 0x1196,
    0x1173, 0x1175, 0x1174,
    0x1174, 0x116E, 0x1197,
    0x1175, 0x1161, 0x1198,
    0x1175, 0x1163, 0x1199,
    0x1175, 0x1169, 0x119A,
    0x1175, 0x116E, 0x119B,
    0x1175, 0x1173, 0x119C,
    0x1175, 0x119E, 0x119D,
    0x119E, 0x1165, 0x119F,
    0x119E, 0x116E, 0x11A0,
    0x119E, 0x1175, 0x11A1,
    0x119E, 0x119E, 0x11A2,
    0x11A8, 0x11A8, 0x11A9,
    0x11A8, 0x11AF, 0x11C3,
    0x11A8, 0x11BA, 0x11AA,
    0x11A8, 0x11E7, 0x11C4,
    0x11AA, 0x11A8, 0x11C4,
    0x11AB, 0x11A8, 0x11C5,
    0x11AB, 0x11AE, 0x11C6,
    0x11AB, 0x11BA, 0x11C7,
    0x11AB, 0x11BD, 0x11AC,
    0x11AB, 0x11C0, 0x11C9,
    0x11AB, 0x11C2, 0x11AD,
    0x11AB, 0x11EB, 0x11C8,
    0x11AE, 0x11A8, 0x11CA,
    0x11AE, 0x11AF, 0x11CB,
    0x11AF, 0x11A8, 0x11B0,
    0x11AF, 0x11AA, 0x11CC,
    0x11AF, 0x11AB, 0x11CD,
    0x11AF, 0x11AE, 0x11CE,
    0x11AF, 0x11AF, 0x11D0,
    0x11AF, 0x11B7, 0x11B1,
    0x11AF, 0x11B8, 0x11B2,
    0x11AF, 0x11B9, 0x11D3,
    0x11AF, 0x11BA, 0x11B3,
    0x11AF, 0x11BB, 0x11D6,
    0x11AF, 0x11BF, 0x11D8,
    0x11AF, 0x11C0, 0x11B4,
    0x11AF, 0x11C1, 0x11B5,
    0x11AF, 0x11C2, 0x11B6,
    0x11AF, 0x11DA, 0x11D1,
    0x11AF, 0x11DD, 0x11D2,
    0x11AF, 0x11E5, 0x11D4,
    0x11AF, 0x11E6, 0x11D5,
    0x11AF, 0x11EB, 0x11D7,
    0x11AF, 0x11F9, 0x11D9,
    0x11B0, 0x11BA, 0x11CC,
    0x11B1, 0x11A8, 0x11D1,
    0x11B1, 0x11BA, 0x11D2,
    0x11B2, 0x11BA, 0x11D3,
    0x11B2, 0x11BC, 0x11D5,
    0x11B2, 0x11C2, 0x11D4,
    0x11B3, 0x11BA, 0x11D6,
    0x11B7, 0x11A8, 0x11DA,
    0x11B7, 0x11AF, 0x11DB,
    0x11B7, 0x11B8, 0x11DC,
    0x11B7, 0x11BA, 0x11DD,
    0x11B7, 0x11BB, 0x11DE,
    0x11B7, 0x11BC, 0x11E2,
    0x11B7, 0x11BE, 0x11E0,
    0x11B7, 0x11C2, 0x11E1,
    0x11B7, 0x11EB, 0x11DF,
    0x11B8, 0x11AF, 0x11E3,
    0x11B8, 0x11BA, 0x11B9,
    0x11B8, 0x11BC, 0x11E6,
    0x11B8, 0x11C1, 0x11E4,
    0x11B8, 0x11C2, 0x11E5,
    0x11BA, 0x11A8, 0x11E7,
    0x11BA, 0x11AE, 0x11E8,
    0x11BA, 0x11AF, 0x11E9,
    0x11BA, 0x11B8, 0x11EA,
    0x11BA, 0x11BA, 0x11BB,
    0x11BC, 0x11A8, 0x11EC,
    0x11BC, 0x11A9, 0x11ED,
    0x11BC, 0x11BC, 0x11EE,
    0x11BC, 0x11BF, 0x11EF,
    0x11C1, 0x11B8, 0x11F3,
    0x11C1, 0x11BC, 0x11F4,
    0x11C2, 0x11AB, 0x11F5,
    0x11C2, 0x11AF, 0x11F6,
    0x11C2, 0x11B7, 0x11F7,
    0x11C2, 0x11B8, 0x11F8,
    0x11CE, 0x11C2, 0x11CF,
    0x11DD, 0x11BA, 0x11DE,
    0x11EC, 0x11A8, 0x11ED,
    0x11F0, 0x11BA, 0x11F1,
    0x11F0, 0x11EB, 0x11F2,
    0x1FBF, XK_apostrophe, 0x1FCE,
    0x1FBF, XK_grave, 0x1FCD,
    0x1FBF, XK_asciitilde, 0x1FCF,
    0x1FBF, XK_acute, 0x1FCE,
    0x1FBF, XK_dead_grave, 0x1FCD,
    0x1FBF, XK_dead_acute, 0x1FCE,
    0x1FBF, XK_dead_tilde, 0x1FCF,
    0x1FFE, XK_apostrophe, 0x1FDE,
    0x1FFE, XK_grave, 0x1FDD,
    0x1FFE, XK_asciitilde, 0x1FDF,
    0x1FFE, XK_acute, 0x1FDE,
    0x1FFE, XK_dead_grave, 0x1FDD,
    0x1FFE, XK_dead_acute, 0x1FDE,
    0x1FFE, XK_dead_tilde, 0x1FDF,
    0x2203, 0x0338, 0x2204,
    0x2208, 0x0338, 0x2209,
    0x220B, 0x0338, 0x220C,
    0x2223, 0x0338, 0x2224,
    0x2225, 0x0338, 0x2226,
    0x223C, 0x0338, 0x2241,
    0x2243, 0x0338, 0x2244,
    0x2248, 0x0338, 0x2249,
    0x224D, 0x0338, 0x226D,
    0x2272, 0x0338, 0x2274,
    0x2273, 0x0338, 0x2275,
    0x2276, 0x0338, 0x2278,
    0x2277, 0x0338, 0x2279,
    0x227A, 0x0338, 0x2280,
    0x227B, 0x0338, 0x2281,
    0x227C, 0x0338, 0x22E0,
    0x227D, 0x0338, 0x22E1,
    0x2286, 0x0338, 0x2288,
    0x2287, 0x0338, 0x2289,
    0x2291, 0x0338, 0x22E2,
    0x2292, 0x0338, 0x22E3,
    0x22A8, 0x0338, 0x22AD,
    0x22A9, 0x0338, 0x22AE,
    0x22AB, 0x0338, 0x22AF,
    0x22B2, 0x0338, 0x22EA,
    0x22B3, 0x0338, 0x22EB,
    0x22B4, 0x0338, 0x22EC,
    0x22B5, 0x0338, 0x22ED,
    0x2ADD, 0x0338, 0x2ADC,
    XK_KP_Divide, XK_D, 0x0110,
    XK_KP_Divide, XK_G, 0x01E4,
    XK_KP_Divide, XK_H, 0x0126,
    XK_KP_Divide, XK_I, 0x0197,
    XK_KP_Divide, XK_L, 0x0141,
    XK_KP_Divide, XK_O, 0x00D8,
    XK_KP_Divide, XK_T, 0x0166,
    XK_KP_Divide, XK_Z, 0x01B5,
    XK_KP_Divide, XK_b, 0x0180,
    XK_KP_Divide, XK_d, 0x0111,
    XK_KP_Divide, XK_g, 0x01E5,
    XK_KP_Divide, XK_h, 0x0127,
    XK_KP_Divide, XK_i, 0x0268,
    XK_KP_Divide, XK_l, 0x0142,
    XK_KP_Divide, XK_o, 0x00F8,
    XK_KP_Divide, XK_t, 0x0167,
    XK_KP_Divide, XK_z, 0x01B6,
    XK_KP_Divide, 0x0294, 0x02A1,
    XK_KP_Divide, 0x04AE, 0x04B0,
    XK_KP_Divide, 0x04AF, 0x04B1,
    XK_KP_Divide, XK_Cyrillic_ghe, 0x0493,
    XK_KP_Divide, XK_Cyrillic_ka, 0x049F,
    XK_KP_Divide, XK_Cyrillic_GHE, 0x0492,
    XK_KP_Divide, XK_Cyrillic_KA, 0x049E,
    XK_KP_Divide, XK_leftarrow, 0x219A,
    XK_KP_Divide, XK_rightarrow, 0x219B,
    XK_KP_Divide, 0x2194, 0x21AE,
    XK_KP_Equal, 0x0338, 0x2260,
    XK_exclam, XK_plus, XK_O, 0x1EE2,
    XK_exclam, XK_plus, XK_U, 0x1EF0,
    XK_exclam, XK_plus, XK_o, 0x1EE3,
    XK_exclam, XK_plus, XK_u, 0x1EF1,
    XK_exclam, XK_dead_horn, XK_O, 0x1EE2,
    XK_exclam, XK_dead_horn, XK_U, 0x1EF0,
    XK_exclam, XK_dead_horn, XK_o, 0x1EE3,
    XK_exclam, XK_dead_horn, XK_u, 0x1EF1,
    XK_quotedbl, XK_apostrophe, XK_space, 0x0385,
    XK_quotedbl, XK_apostrophe, XK_Greek_iota, 0x0390,
    XK_quotedbl, XK_apostrophe, XK_Greek_upsilon, 0x03B0,
    XK_quotedbl, XK_underscore, XK_U, 0x1E7A,
    XK_quotedbl, XK_underscore, XK_u, 0x1E7B,
    XK_quotedbl, XK_asciitilde, XK_O, 0x1E4E,
    XK_quotedbl, XK_asciitilde, XK_o, 0x1E4F,
    XK_quotedbl, XK_macron, XK_U, 0x1E7A,
    XK_quotedbl, XK_macron, XK_u, 0x1E7B,
    XK_quotedbl, XK_dead_tilde, XK_O, 0x1E4E,
    XK_quotedbl, XK_dead_tilde, XK_o, 0x1E4F,
    XK_quotedbl, XK_dead_macron, XK_U, 0x1E7A,
    XK_quotedbl, XK_dead_macron, XK_u, 0x1E7B,
    XK_apostrophe, XK_quotedbl, XK_space, 0x0385,
    XK_apostrophe, XK_quotedbl, XK_I, 0x1E2E,
    XK_apostrophe, XK_quotedbl, XK_U, 0x01D7,
    XK_apostrophe, XK_quotedbl, XK_i, 0x1E2F,
    XK_apostrophe, XK_quotedbl, XK_u, 0x01D8,
    XK_apostrophe, XK_quotedbl, XK_Greek_iota, 0x0390,
    XK_apostrophe, XK_quotedbl, XK_Greek_upsilon, 0x03B0,
    XK_apostrophe, XK_parenleft, XK_Greek_ALPHA, 0x1F0D,
    XK_apostrophe, XK_parenleft, XK_Greek_EPSILON, 0x1F1D,
    XK_apostrophe, XK_parenleft, XK_Greek_ETA, 0x1F2D,
    XK_apostrophe, XK_parenleft, XK_Greek_IOTA, 0x1F3D,
    XK_apostrophe, XK_parenleft, XK_Greek_OMICRON, 0x1F4D,
    XK_apostrophe, XK_parenleft, XK_Greek_UPSILON, 0x1F5D,
    XK_apostrophe, XK_parenleft, XK_Greek_OMEGA, 0x1F6D,
    XK_apostrophe, XK_parenleft, XK_Greek_alpha, 0x1F05,
    XK_apostrophe, XK_parenleft, XK_Greek_epsilon, 0x1F15,
    XK_apostrophe, XK_parenleft, XK_Greek_eta, 0x1F25,
    XK_apostrophe, XK_parenleft, XK_Greek_iota, 0x1F35,
    XK_apostrophe, XK_parenleft, XK_Greek_omicron, 0x1F45,
    XK_apostrophe, XK_parenleft, XK_Greek_upsilon, 0x1F55,
    XK_apostrophe, XK_parenleft, XK_Greek_omega, 0x1F65,
    XK_apostrophe, XK_parenright, XK_Greek_ALPHA, 0x1F0C,
    XK_apostrophe, XK_parenright, XK_Greek_EPSILON, 0x1F1C,
    XK_apostrophe, XK_parenright, XK_Greek_ETA, 0x1F2C,
    XK_apostrophe, XK_parenright, XK_Greek_IOTA, 0x1F3C,
    XK_apostrophe, XK_parenright, XK_Greek_OMICRON, 0x1F4C,
    XK_apostrophe, XK_parenright, XK_Greek_OMEGA, 0x1F6C,
    XK_apostrophe, XK_parenright, XK_Greek_alpha, 0x1F04,
    XK_apostrophe, XK_parenright, XK_Greek_epsilon, 0x1F14,
    XK_apostrophe, XK_parenright, XK_Greek_eta, 0x1F24,
    XK_apostrophe, XK_parenright, XK_Greek_iota, 0x1F34,
    XK_apostrophe, XK_parenright, XK_Greek_omicron, 0x1F44,
    XK_apostrophe, XK_parenright, XK_Greek_upsilon, 0x1F54,
    XK_apostrophe, XK_parenright, XK_Greek_omega, 0x1F64,
    XK_apostrophe, XK_plus, XK_O, 0x1EDA,
    XK_apostrophe, XK_plus, XK_U, 0x1EE8,
    XK_apostrophe, XK_plus, XK_o, 0x1EDB,
    XK_apostrophe, XK_plus, XK_u, 0x1EE9,
    XK_apostrophe, XK_slash, XK_O, 0x01FE,
    XK_apostrophe, XK_slash, XK_o, 0x01FF,
    XK_apostrophe, XK_asciicircum, XK_A, 0x1EA4,
    XK_apostrophe, XK_asciicircum, XK_E, 0x1EBE,
    XK_apostrophe, XK_asciicircum, XK_O, 0x1ED0,
    XK_apostrophe, XK_asciicircum, XK_a, 0x1EA5,
    XK_apostrophe, XK_asciicircum, XK_e, 0x1EBF,
    XK_apostrophe, XK_asciicircum, XK_o, 0x1ED1,
    XK_apostrophe, XK_underscore, XK_E, 0x1E16,
    XK_apostrophe, XK_underscore, XK_O, 0x1E52,
    XK_apostrophe, XK_underscore, XK_e, 0x1E17,
    XK_apostrophe, XK_underscore, XK_o, 0x1E53,
    XK_apostrophe, XK_b, XK_A, 0x1EAE,
    XK_apostrophe, XK_b, XK_a, 0x1EAF,
    XK_apostrophe, XK_asciitilde, XK_O, 0x1E4C,
    XK_apostrophe, XK_asciitilde, XK_U, 0x1E78,
    XK_apostrophe, XK_asciitilde, XK_o, 0x1E4D,
    XK_apostrophe, XK_asciitilde, XK_u, 0x1E79,
    XK_apostrophe, XK_macron, XK_E, 0x1E16,
    XK_apostrophe, XK_macron, XK_O, 0x1E52,
    XK_apostrophe, XK_macron, XK_e, 0x1E17,
    XK_apostrophe, XK_macron, XK_o, 0x1E53,
    XK_apostrophe, XK_cedilla, XK_C, 0x1E08,
    XK_apostrophe, XK_cedilla, XK_c, 0x1E09,
    XK_apostrophe, XK_dead_circumflex, XK_A, 0x1EA4,
    XK_apostrophe, XK_dead_circumflex, XK_E, 0x1EBE,
    XK_apostrophe, XK_dead_circumflex, XK_O, 0x1ED0,
    XK_apostrophe, XK_dead_circumflex, XK_a, 0x1EA5,
    XK_apostrophe, XK_dead_circumflex, XK_e, 0x1EBF,
    XK_apostrophe, XK_dead_circumflex, XK_o, 0x1ED1,
    XK_apostrophe, XK_dead_tilde, XK_O, 0x1E4C,
    XK_apostrophe, XK_dead_tilde, XK_U, 0x1E78,
    XK_apostrophe, XK_dead_tilde, XK_o, 0x1E4D,
    XK_apostrophe, XK_dead_tilde, XK_u, 0x1E79,
    XK_apostrophe, XK_dead_macron, XK_E, 0x1E16,
    XK_apostrophe, XK_dead_macron, XK_O, 0x1E52,
    XK_apostrophe, XK_dead_macron, XK_e, 0x1E17,
    XK_apostrophe, XK_dead_macron, XK_o, 0x1E53,
    XK_apostrophe, XK_dead_breve, XK_A, 0x1EAE,
    XK_apostrophe, XK_dead_breve, XK_a, 0x1EAF,
    XK_apostrophe, XK_dead_diaeresis, XK_I, 0x1E2E,
    XK_apostrophe, XK_dead_diaeresis, XK_U, 0x01D7,
    XK_apostrophe, XK_dead_diaeresis, XK_i, 0x1E2F,
    XK_apostrophe, XK_dead_diaeresis, XK_u, 0x01D8,
    XK_apostrophe, XK_dead_diaeresis, XK_Greek_iota, 0x0390,
    XK_apostrophe, XK_dead_diaeresis, XK_Greek_upsilon, 0x03B0,
    XK_apostrophe, XK_dead_abovering, XK_A, 0x01FA,
    XK_apostrophe, XK_dead_abovering, XK_a, 0x01FB,
    XK_apostrophe, XK_dead_cedilla, XK_C, 0x1E08,
    XK_apostrophe, XK_dead_cedilla, XK_c, 0x1E09,
    XK_apostrophe, XK_dead_horn, XK_O, 0x1EDA,
    XK_apostrophe, XK_dead_horn, XK_U, 0x1EE8,
    XK_apostrophe, XK_dead_horn, XK_o, 0x1EDB,
    XK_apostrophe, XK_dead_horn, XK_u, 0x1EE9,
    XK_apostrophe, XK_dead_psili, XK_Greek_ALPHA, 0x1F0C,
    XK_apostrophe, XK_dead_psili, XK_Greek_EPSILON, 0x1F1C,
    XK_apostrophe, XK_dead_psili, XK_Greek_ETA, 0x1F2C,
    XK_apostrophe, XK_dead_psili, XK_Greek_IOTA, 0x1F3C,
    XK_apostrophe, XK_dead_psili, XK_Greek_OMICRON, 0x1F4C,
    XK_apostrophe, XK_dead_psili, XK_Greek_OMEGA, 0x1F6C,
    XK_apostrophe, XK_dead_psili, XK_Greek_alpha, 0x1F04,
    XK_apostrophe, XK_dead_psili, XK_Greek_epsilon, 0x1F14,
    XK_apostrophe, XK_dead_psili, XK_Greek_eta, 0x1F24,
    XK_apostrophe, XK_dead_psili, XK_Greek_iota, 0x1F34,
    XK_apostrophe, XK_dead_psili, XK_Greek_omicron, 0x1F44,
    XK_apostrophe, XK_dead_psili, XK_Greek_upsilon, 0x1F54,
    XK_apostrophe, XK_dead_psili, XK_Greek_omega, 0x1F64,
    XK_apostrophe, XK_dead_dasia, XK_Greek_ALPHA, 0x1F0D,
    XK_apostrophe, XK_dead_dasia, XK_Greek_EPSILON, 0x1F1D,
    XK_apostrophe, XK_dead_dasia, XK_Greek_ETA, 0x1F2D,
    XK_apostrophe, XK_dead_dasia, XK_Greek_IOTA, 0x1F3D,
    XK_apostrophe, XK_dead_dasia, XK_Greek_OMICRON, 0x1F4D,
    XK_apostrophe, XK_dead_dasia, XK_Greek_UPSILON, 0x1F5D,
    XK_apostrophe, XK_dead_dasia, XK_Greek_OMEGA, 0x1F6D,
    XK_apostrophe, XK_dead_dasia, XK_Greek_alpha, 0x1F05,
    XK_apostrophe, XK_dead_dasia, XK_Greek_epsilon, 0x1F15,
    XK_apostrophe, XK_dead_dasia, XK_Greek_eta, 0x1F25,
    XK_apostrophe, XK_dead_dasia, XK_Greek_iota, 0x1F35,
    XK_apostrophe, XK_dead_dasia, XK_Greek_omicron, 0x1F45,
    XK_apostrophe, XK_dead_dasia, XK_Greek_upsilon, 0x1F55,
    XK_apostrophe, XK_dead_dasia, XK_Greek_omega, 0x1F65,
    XK_apostrophe, XK_KP_Divide, XK_O, 0x01FE,
    XK_apostrophe, XK_KP_Divide, XK_o, 0x01FF,
    XK_parenleft, XK_0, XK_parenright, 0x24EA,
    XK_parenleft, XK_1, XK_parenright, 0x2460,
    XK_parenleft, XK_2, XK_parenright, 0x2461,
    XK_parenleft, XK_3, XK_parenright, 0x2462,
    XK_parenleft, XK_4, XK_parenright, 0x2463,
    XK_parenleft, XK_5, XK_parenright, 0x2464,
    XK_parenleft, XK_6, XK_parenright, 0x2465,
    XK_parenleft, XK_7, XK_parenright, 0x2466,
    XK_parenleft, XK_8, XK_parenright, 0x2467,
    XK_parenleft, XK_9, XK_parenright, 0x2468,
    XK_parenleft, XK_A, XK_parenright, 0x24B6,
    XK_parenleft, XK_B, XK_parenright, 0x24B7,
    XK_parenleft, XK_C, XK_parenright, 0x24B8,
    XK_parenleft, XK_D, XK_parenright, 0x24B9,
    XK_parenleft, XK_E, XK_parenright, 0x24BA,
    XK_parenleft, XK_F, XK_parenright, 0x24BB,
    XK_parenleft, XK_G, XK_parenright, 0x24BC,
    XK_parenleft, XK_H, XK_parenright, 0x24BD,
    XK_parenleft, XK_I, XK_parenright, 0x24BE,
    XK_parenleft, XK_J, XK_parenright, 0x24BF,
    XK_parenleft, XK_K, XK_parenright, 0x24C0,
    XK_parenleft, XK_L, XK_parenright, 0x24C1,
    XK_parenleft, XK_M, XK_parenright, 0x24C2,
    XK_parenleft, XK_N, XK_parenright, 0x24C3,
    XK_parenleft, XK_O, XK_parenright, 0x24C4,
    XK_parenleft, XK_P, XK_parenright, 0x24C5,
    XK_parenleft, XK_Q, XK_parenright, 0x24C6,
    XK_parenleft, XK_R, XK_parenright, 0x24C7,
    XK_parenleft, XK_S, XK_parenright, 0x24C8,
    XK_parenleft, XK_T, XK_parenright, 0x24C9,
    XK_parenleft, XK_U, XK_parenright, 0x24CA,
    XK_parenleft, XK_V, XK_parenright, 0x24CB,
    XK_parenleft, XK_W, XK_parenright, 0x24CC,
    XK_parenleft, XK_X, XK_parenright, 0x24CD,
    XK_parenleft, XK_Y, XK_parenright, 0x24CE,
    XK_parenleft, XK_Z, XK_parenright, 0x24CF,
    XK_parenleft, XK_a, XK_parenright, 0x24D0,
    XK_parenleft, XK_b, XK_parenright, 0x24D1,
    XK_parenleft, XK_c, XK_parenright, 0x24D2,
    XK_parenleft, XK_d, XK_parenright, 0x24D3,
    XK_parenleft, XK_e, XK_parenright, 0x24D4,
    XK_parenleft, XK_f, XK_parenright, 0x24D5,
    XK_parenleft, XK_g, XK_parenright, 0x24D6,
    XK_parenleft, XK_h, XK_parenright, 0x24D7,
    XK_parenleft, XK_i, XK_parenright, 0x24D8,
    XK_parenleft, XK_j, XK_parenright, 0x24D9,
    XK_parenleft, XK_k, XK_parenright, 0x24DA,
    XK_parenleft, XK_l, XK_parenright, 0x24DB,
    XK_parenleft, XK_m, XK_parenright, 0x24DC,
    XK_parenleft, XK_n, XK_parenright, 0x24DD,
    XK_parenleft, XK_o, XK_parenright, 0x24DE,
    XK_parenleft, XK_p, XK_parenright, 0x24DF,
    XK_parenleft, XK_q, XK_parenright, 0x24E0,
    XK_parenleft, XK_r, XK_parenright, 0x24E1,
    XK_parenleft, XK_s, XK_parenright, 0x24E2,
    XK_parenleft, XK_t, XK_parenright, 0x24E3,
    XK_parenleft, XK_u, XK_parenright, 0x24E4,
    XK_parenleft, XK_v, XK_parenright, 0x24E5,
    XK_parenleft, XK_w, XK_parenright, 0x24E6,
    XK_parenleft, XK_x, XK_parenright, 0x24E7,
    XK_parenleft, XK_y, XK_parenright, 0x24E8,
    XK_parenleft, XK_z, XK_parenright, 0x24E9,
    XK_parenleft, XK_kana_WO, XK_parenright, 0x32FE,
    XK_parenleft, XK_kana_A, XK_parenright, 0x32D0,
    XK_parenleft, XK_kana_I, XK_parenright, 0x32D1,
    XK_parenleft, XK_kana_U, XK_parenright, 0x32D2,
    XK_parenleft, XK_kana_E, XK_parenright, 0x32D3,
    XK_parenleft, XK_kana_O, XK_parenright, 0x32D4,
    XK_parenleft, XK_kana_KA, XK_parenright, 0x32D5,
    XK_parenleft, XK_kana_KI, XK_parenright, 0x32D6,
    XK_parenleft, XK_kana_KU, XK_parenright, 0x32D7,
    XK_parenleft, XK_kana_KE, XK_parenright, 0x32D8,
    XK_parenleft, XK_kana_KO, XK_parenright, 0x32D9,
    XK_parenleft, XK_kana_SA, XK_parenright, 0x32DA,
    XK_parenleft, XK_kana_SHI, XK_parenright, 0x32DB,
    XK_parenleft, XK_kana_SU, XK_parenright, 0x32DC,
    XK_parenleft, XK_kana_SE, XK_parenright, 0x32DD,
    XK_parenleft, XK_kana_SO, XK_parenright, 0x32DE,
    XK_parenleft, XK_kana_TA, XK_parenright, 0x32DF,
    XK_parenleft, XK_kana_CHI, XK_parenright, 0x32E0,
    XK_parenleft, XK_kana_TSU, XK_parenright, 0x32E1,
    XK_parenleft, XK_kana_TE, XK_parenright, 0x32E2,
    XK_parenleft, XK_kana_TO, XK_parenright, 0x32E3,
    XK_parenleft, XK_kana_NA, XK_parenright, 0x32E4,
    XK_parenleft, XK_kana_NI, XK_parenright, 0x32E5,
    XK_parenleft, XK_kana_NU, XK_parenright, 0x32E6,
    XK_parenleft, XK_kana_NE, XK_parenright, 0x32E7,
    XK_parenleft, XK_kana_NO, XK_parenright, 0x32E8,
    XK_parenleft, XK_kana_HA, XK_parenright, 0x32E9,
    XK_parenleft, XK_kana_HI, XK_parenright, 0x32EA,
    XK_parenleft, XK_kana_FU, XK_parenright, 0x32EB,
    XK_parenleft, XK_kana_HE, XK_parenright, 0x32EC,
    XK_parenleft, XK_kana_HO, XK_parenright, 0x32ED,
    XK_parenleft, XK_kana_MA, XK_parenright, 0x32EE,
    XK_parenleft, XK_kana_MI, XK_parenright, 0x32EF,
    XK_parenleft, XK_kana_MU, XK_parenright, 0x32F0,
    XK_parenleft, XK_kana_ME, XK_parenright, 0x32F1,
    XK_parenleft, XK_kana_MO, XK_parenright, 0x32F2,
    XK_parenleft, XK_kana_YA, XK_parenright, 0x32F3,
    XK_parenleft, XK_kana_YU, XK_parenright, 0x32F4,
    XK_parenleft, XK_kana_YO, XK_parenright, 0x32F5,
    XK_parenleft, XK_kana_RA, XK_parenright, 0x32F6,
    XK_parenleft, XK_kana_RI, XK_parenright, 0x32F7,
    XK_parenleft, XK_kana_RU, XK_parenright, 0x32F8,
    XK_parenleft, XK_kana_RE, XK_parenright, 0x32F9,
    XK_parenleft, XK_kana_RO, XK_parenright, 0x32FA,
    XK_parenleft, XK_kana_WA, XK_parenright, 0x32FB,
    XK_parenleft, 0x1100, XK_parenright, 0x3260,
    XK_parenleft, 0x1102, XK_parenright, 0x3261,
    XK_parenleft, 0x1103, XK_parenright, 0x3262,
    XK_parenleft, 0x1105, XK_parenright, 0x3263,
    XK_parenleft, 0x1106, XK_parenright, 0x3264,
    XK_parenleft, 0x1107, XK_parenright, 0x3265,
    XK_parenleft, 0x1109, XK_parenright, 0x3266,
    XK_parenleft, 0x110B, XK_parenright, 0x3267,
    XK_parenleft, 0x110C, XK_parenright, 0x3268,
    XK_parenleft, 0x110E, XK_parenright, 0x3269,
    XK_parenleft, 0x110F, XK_parenright, 0x326A,
    XK_parenleft, 0x1110, XK_parenright, 0x326B,
    XK_parenleft, 0x1111, XK_parenright, 0x326C,
    XK_parenleft, 0x1112, XK_parenright, 0x326D,
    XK_parenleft, 0x30F0, XK_parenright, 0x32FC,
    XK_parenleft, 0x30F1, XK_parenright, 0x32FD,
    XK_parenleft, 0x4E00, XK_parenright, 0x3280,
    XK_parenleft, 0x4E03, XK_parenright, 0x3286,
    XK_parenleft, 0x4E09, XK_parenright, 0x3282,
    XK_parenleft, 0x4E0A, XK_parenright, 0x32A4,
    XK_parenleft, 0x4E0B, XK_parenright, 0x32A6,
    XK_parenleft, 0x4E2D, XK_parenright, 0x32A5,
    XK_parenleft, 0x4E5D, XK_parenright, 0x3288,
    XK_parenleft, 0x4E8C, XK_parenright, 0x3281,
    XK_parenleft, 0x4E94, XK_parenright, 0x3284,
    XK_parenleft, 0x4F01, XK_parenright, 0x32AD,
    XK_parenleft, 0x4F11, XK_parenright, 0x32A1,
    XK_parenleft, 0x512A, XK_parenright, 0x329D,
    XK_parenleft, 0x516B, XK_parenright, 0x3287,
    XK_parenleft, 0x516D, XK_parenright, 0x3285,
    XK_parenleft, 0x5199, XK_parenright, 0x32A2,
    XK_parenleft, 0x52B4, XK_parenright, 0x3298,
    XK_parenleft, 0x533B, XK_parenright, 0x32A9,
    XK_parenleft, 0x5341, XK_parenright, 0x3289,
    XK_parenleft, 0x5354, XK_parenright, 0x32AF,
    XK_parenleft, 0x5370, XK_parenright, 0x329E,
    XK_parenleft, 0x53F3, XK_parenright, 0x32A8,
    XK_parenleft, 0x540D, XK_parenright, 0x3294,
    XK_parenleft, 0x56DB, XK_parenright, 0x3283,
    XK_parenleft, 0x571F, XK_parenright, 0x328F,
    XK_parenleft, 0x591C, XK_parenright, 0x32B0,
    XK_parenleft, 0x5973, XK_parenright, 0x329B,
    XK_parenleft, 0x5B66, XK_parenright, 0x32AB,
    XK_parenleft, 0x5B97, XK_parenright, 0x32AA,
    XK_parenleft, 0x5DE6, XK_parenright, 0x32A7,
    XK_parenleft, 0x65E5, XK_parenright, 0x3290,
    XK_parenleft, 0x6708, XK_parenright, 0x328A,
    XK_parenleft, 0x6709, XK_parenright, 0x3292,
    XK_parenleft, 0x6728, XK_parenright, 0x328D,
    XK_parenleft, 0x682A, XK_parenright, 0x3291,
    XK_parenleft, 0x6B63, XK_parenright, 0x32A3,
    XK_parenleft, 0x6C34, XK_parenright, 0x328C,
    XK_parenleft, 0x6CE8, XK_parenright, 0x329F,
    XK_parenleft, 0x706B, XK_parenright, 0x328B,
    XK_parenleft, 0x7279, XK_parenright, 0x3295,
    XK_parenleft, 0x7537, XK_parenright, 0x329A,
    XK_parenleft, 0x76E3, XK_parenright, 0x32AC,
    XK_parenleft, 0x793E, XK_parenright, 0x3293,
    XK_parenleft, 0x795D, XK_parenright, 0x3297,
    XK_parenleft, 0x79D8, XK_parenright, 0x3299,
    XK_parenleft, 0x8CA1, XK_parenright, 0x3296,
    XK_parenleft, 0x8CC7, XK_parenright, 0x32AE,
    XK_parenleft, 0x9069, XK_parenright, 0x329C,
    XK_parenleft, 0x91D1, XK_parenright, 0x328E,
    XK_parenleft, 0x9805, XK_parenright, 0x32A0,
    XK_parenleft, XK_KP_Space, XK_parenright, 0x2461,
    XK_parenleft, XK_KP_0, XK_parenright, 0x24EA,
    XK_parenleft, XK_KP_1, XK_parenright, 0x2460,
    XK_parenleft, XK_KP_2, XK_parenright, 0x2461,
    XK_parenleft, XK_KP_3, XK_parenright, 0x2462,
    XK_parenleft, XK_KP_4, XK_parenright, 0x2463,
    XK_parenleft, XK_KP_5, XK_parenright, 0x2464,
    XK_parenleft, XK_KP_6, XK_parenright, 0x2465,
    XK_parenleft, XK_KP_7, XK_parenright, 0x2466,
    XK_parenleft, XK_KP_8, XK_parenright, 0x2467,
    XK_parenleft, XK_KP_9, XK_parenright, 0x2468,
    XK_minus, XK_minus, XK_space, 0x00AD,
    XK_minus, XK_minus, XK_minus, 0x2014,
    XK_minus, XK_minus, XK_period, 0x2013,
    XK_period, XK_exclam, XK_S, 0x1E68,
    XK_period, XK_exclam, XK_s, 0x1E69,
    XK_period, XK_apostrophe, XK_S, 0x1E64,
    XK_period, XK_apostrophe, XK_s, 0x1E65,
    XK_period, XK_acute, XK_S, 0x1E64,
    XK_period, XK_acute, XK_s, 0x1E65,
    XK_period, XK_dead_acute, XK_S, 0x1E64,
    XK_period, XK_dead_acute, XK_s, 0x1E65,
    XK_period, XK_dead_caron, XK_S, 0x1E66,
    XK_period, XK_dead_caron, XK_s, 0x1E67,
    XK_period, XK_dead_belowdot, XK_S, 0x1E68,
    XK_period, XK_dead_belowdot, XK_s, 0x1E69,
    XK_question, XK_plus, XK_O, 0x1EDE,
    XK_question, XK_plus, XK_U, 0x1EEC,
    XK_question, XK_plus, XK_o, 0x1EDF,
    XK_question, XK_plus, XK_u, 0x1EED,
    XK_question, XK_asciicircum, XK_A, 0x1EA8,
    XK_question, XK_asciicircum, XK_E, 0x1EC2,
    XK_question, XK_asciicircum, XK_O, 0x1ED4,
    XK_question, XK_asciicircum, XK_a, 0x1EA9,
    XK_question, XK_asciicircum, XK_e, 0x1EC3,
    XK_question, XK_asciicircum, XK_o, 0x1ED5,
    XK_question, XK_b, XK_A, 0x1EB2,
    XK_question, XK_b, XK_a, 0x1EB3,
    XK_question, XK_dead_circumflex, XK_A, 0x1EA8,
    XK_question, XK_dead_circumflex, XK_E, 0x1EC2,
    XK_question, XK_dead_circumflex, XK_O, 0x1ED4,
    XK_question, XK_dead_circumflex, XK_a, 0x1EA9,
    XK_question, XK_dead_circumflex, XK_e, 0x1EC3,
    XK_question, XK_dead_circumflex, XK_o, 0x1ED5,
    XK_question, XK_dead_breve, XK_A, 0x1EB2,
    XK_question, XK_dead_breve, XK_a, 0x1EB3,
    XK_question, XK_dead_horn, XK_O, 0x1EDE,
    XK_question, XK_dead_horn, XK_U, 0x1EEC,
    XK_question, XK_dead_horn, XK_o, 0x1EDF,
    XK_question, XK_dead_horn, XK_u, 0x1EED,
    XK_U, XK_exclam, XK_A, 0x1EB6,
    XK_U, XK_exclam, XK_a, 0x1EB7,
    XK_U, XK_comma, XK_E, 0x1E1C,
    XK_U, XK_comma, XK_e, 0x1E1D,
    XK_U, XK_cedilla, XK_E, 0x1E1C,
    XK_U, XK_cedilla, XK_e, 0x1E1D,
    XK_U, XK_dead_cedilla, XK_E, 0x1E1C,
    XK_U, XK_dead_cedilla, XK_e, 0x1E1D,
    XK_U, XK_dead_belowdot, XK_A, 0x1EB6,
    XK_U, XK_dead_belowdot, XK_a, 0x1EB7,
    XK_asciicircum, XK_exclam, XK_A, 0x1EAC,
    XK_asciicircum, XK_exclam, XK_E, 0x1EC6,
    XK_asciicircum, XK_exclam, XK_O, 0x1ED8,
    XK_asciicircum, XK_exclam, XK_a, 0x1EAD,
    XK_asciicircum, XK_exclam, XK_e, 0x1EC7,
    XK_asciicircum, XK_exclam, XK_o, 0x1ED9,
    XK_asciicircum, XK_underscore, XK_a, 0x00AA,
    XK_asciicircum, XK_underscore, XK_h, 0x02B0,
    XK_asciicircum, XK_underscore, XK_i, 0x2071,
    XK_asciicircum, XK_underscore, XK_j, 0x02B2,
    XK_asciicircum, XK_underscore, XK_l, 0x02E1,
    XK_asciicircum, XK_underscore, XK_n, 0x207F,
    XK_asciicircum, XK_underscore, XK_o, 0x00BA,
    XK_asciicircum, XK_underscore, XK_r, 0x02B3,
    XK_asciicircum, XK_underscore, XK_s, 0x02E2,
    XK_asciicircum, XK_underscore, XK_w, 0x02B7,
    XK_asciicircum, XK_underscore, XK_x, 0x02E3,
    XK_asciicircum, XK_underscore, XK_y, 0x02B8,
    XK_asciicircum, XK_underscore, 0x0263, 0x02E0,
    XK_asciicircum, XK_underscore, 0x0266, 0x02B1,
    XK_asciicircum, XK_underscore, 0x0279, 0x02B4,
    XK_asciicircum, XK_underscore, 0x027B, 0x02B5,
    XK_asciicircum, XK_underscore, 0x0281, 0x02B6,
    XK_asciicircum, XK_underscore, 0x0295, 0x02E4,
    XK_asciicircum, XK_underbar, XK_a, 0x00AA,
    XK_asciicircum, XK_underbar, XK_h, 0x02B0,
    XK_asciicircum, XK_underbar, XK_i, 0x2071,
    XK_asciicircum, XK_underbar, XK_j, 0x02B2,
    XK_asciicircum, XK_underbar, XK_l, 0x02E1,
    XK_asciicircum, XK_underbar, XK_n, 0x207F,
    XK_asciicircum, XK_underbar, XK_o, 0x00BA,
    XK_asciicircum, XK_underbar, XK_r, 0x02B3,
    XK_asciicircum, XK_underbar, XK_s, 0x02E2,
    XK_asciicircum, XK_underbar, XK_w, 0x02B7,
    XK_asciicircum, XK_underbar, XK_x, 0x02E3,
    XK_asciicircum, XK_underbar, XK_y, 0x02B8,
    XK_asciicircum, XK_underbar, 0x0263, 0x02E0,
    XK_asciicircum, XK_underbar, 0x0266, 0x02B1,
    XK_asciicircum, XK_underbar, 0x0279, 0x02B4,
    XK_asciicircum, XK_underbar, 0x027B, 0x02B5,
    XK_asciicircum, XK_underbar, 0x0281, 0x02B6,
    XK_asciicircum, XK_underbar, 0x0295, 0x02E4,
    XK_asciicircum, XK_dead_belowdot, XK_A, 0x1EAC,
    XK_asciicircum, XK_dead_belowdot, XK_E, 0x1EC6,
    XK_asciicircum, XK_dead_belowdot, XK_O, 0x1ED8,
    XK_asciicircum, XK_dead_belowdot, XK_a, 0x1EAD,
    XK_asciicircum, XK_dead_belowdot, XK_e, 0x1EC7,
    XK_asciicircum, XK_dead_belowdot, XK_o, 0x1ED9,
    XK_underscore, XK_exclam, XK_L, 0x1E38,
    XK_underscore, XK_exclam, XK_R, 0x1E5C,
    XK_underscore, XK_exclam, XK_l, 0x1E39,
    XK_underscore, XK_exclam, XK_r, 0x1E5D,
    XK_underscore, XK_quotedbl, XK_A, 0x01DE,
    XK_underscore, XK_quotedbl, XK_O, 0x022A,
    XK_underscore, XK_quotedbl, XK_U, 0x01D5,
    XK_underscore, XK_quotedbl, XK_a, 0x01DF,
    XK_underscore, XK_quotedbl, XK_o, 0x022B,
    XK_underscore, XK_quotedbl, XK_u, 0x01D6,
    XK_underscore, XK_period, XK_A, 0x01E0,
    XK_underscore, XK_period, XK_O, 0x0230,
    XK_underscore, XK_period, XK_a, 0x01E1,
    XK_underscore, XK_period, XK_o, 0x0231,
    XK_underscore, XK_semicolon, XK_O, 0x01EC,
    XK_underscore, XK_semicolon, XK_o, 0x01ED,
    XK_underscore, XK_asciitilde, XK_O, 0x022C,
    XK_underscore, XK_asciitilde, XK_o, 0x022D,
    XK_underscore, XK_dead_tilde, XK_O, 0x022C,
    XK_underscore, XK_dead_tilde, XK_o, 0x022D,
    XK_underscore, XK_dead_abovedot, XK_A, 0x01E0,
    XK_underscore, XK_dead_abovedot, XK_O, 0x0230,
    XK_underscore, XK_dead_abovedot, XK_a, 0x01E1,
    XK_underscore, XK_dead_abovedot, XK_o, 0x0231,
    XK_underscore, XK_dead_diaeresis, XK_A, 0x01DE,
    XK_underscore, XK_dead_diaeresis, XK_O, 0x022A,
    XK_underscore, XK_dead_diaeresis, XK_U, 0x01D5,
    XK_underscore, XK_dead_diaeresis, XK_a, 0x01DF,
    XK_underscore, XK_dead_diaeresis, XK_o, 0x022B,
    XK_underscore, XK_dead_diaeresis, XK_u, 0x01D6,
    XK_underscore, XK_dead_ogonek, XK_O, 0x01EC,
    XK_underscore, XK_dead_ogonek, XK_o, 0x01ED,
    XK_underscore, XK_dead_belowdot, XK_L, 0x1E38,
    XK_underscore, XK_dead_belowdot, XK_R, 0x1E5C,
    XK_underscore, XK_dead_belowdot, XK_l, 0x1E39,
    XK_underscore, XK_dead_belowdot, XK_r, 0x1E5D,
    XK_grave, XK_quotedbl, XK_U, 0x01DB,
    XK_grave, XK_quotedbl, XK_u, 0x01DC,
    XK_grave, XK_quotedbl, XK_Greek_iota, 0x1FD2,
    XK_grave, XK_quotedbl, XK_Greek_upsilon, 0x1FE2,
    XK_grave, XK_parenleft, XK_Greek_ALPHA, 0x1F0B,
    XK_grave, XK_parenleft, XK_Greek_EPSILON, 0x1F1B,
    XK_grave, XK_parenleft, XK_Greek_ETA, 0x1F2B,
    XK_grave, XK_parenleft, XK_Greek_IOTA, 0x1F3B,
    XK_grave, XK_parenleft, XK_Greek_OMICRON, 0x1F4B,
    XK_grave, XK_parenleft, XK_Greek_UPSILON, 0x1F5B,
    XK_grave, XK_parenleft, XK_Greek_OMEGA, 0x1F6B,
    XK_grave, XK_parenleft, XK_Greek_alpha, 0x1F03,
    XK_grave, XK_parenleft, XK_Greek_epsilon, 0x1F13,
    XK_grave, XK_parenleft, XK_Greek_eta, 0x1F23,
    XK_grave, XK_parenleft, XK_Greek_iota, 0x1F33,
    XK_grave, XK_parenleft, XK_Greek_omicron, 0x1F43,
    XK_grave, XK_parenleft, XK_Greek_upsilon, 0x1F53,
    XK_grave, XK_parenleft, XK_Greek_omega, 0x1F63,
    XK_grave, XK_parenright, XK_Greek_ALPHA, 0x1F0A,
    XK_grave, XK_parenright, XK_Greek_EPSILON, 0x1F1A,
    XK_grave, XK_parenright, XK_Greek_ETA, 0x1F2A,
    XK_grave, XK_parenright, XK_Greek_IOTA, 0x1F3A,
    XK_grave, XK_parenright, XK_Greek_OMICRON, 0x1F4A,
    XK_grave, XK_parenright, XK_Greek_OMEGA, 0x1F6A,
    XK_grave, XK_parenright, XK_Greek_alpha, 0x1F02,
    XK_grave, XK_parenright, XK_Greek_epsilon, 0x1F12,
    XK_grave, XK_parenright, XK_Greek_eta, 0x1F22,
    XK_grave, XK_parenright, XK_Greek_iota, 0x1F32,
    XK_grave, XK_parenright, XK_Greek_omicron, 0x1F42,
    XK_grave, XK_parenright, XK_Greek_upsilon, 0x1F52,
    XK_grave, XK_parenright, XK_Greek_omega, 0x1F62,
    XK_grave, XK_plus, XK_O, 0x1EDC,
    XK_grave, XK_plus, XK_U, 0x1EEA,
    XK_grave, XK_plus, XK_o, 0x1EDD,
    XK_grave, XK_plus, XK_u, 0x1EEB,
    XK_grave, XK_asciicircum, XK_A, 0x1EA6,
    XK_grave, XK_asciicircum, XK_E, 0x1EC0,
    XK_grave, XK_asciicircum, XK_O, 0x1ED2,
    XK_grave, XK_asciicircum, XK_a, 0x1EA7,
    XK_grave, XK_asciicircum, XK_e, 0x1EC1,
    XK_grave, XK_asciicircum, XK_o, 0x1ED3,
    XK_grave, XK_underscore, XK_E, 0x1E14,
    XK_grave, XK_underscore, XK_O, 0x1E50,
    XK_grave, XK_underscore, XK_e, 0x1E15,
    XK_grave, XK_underscore, XK_o, 0x1E51,
    XK_grave, XK_b, XK_A, 0x1EB0,
    XK_grave, XK_b, XK_a, 0x1EB1,
    XK_grave, XK_macron, XK_E, 0x1E14,
    XK_grave, XK_macron, XK_O, 0x1E50,
    XK_grave, XK_macron, XK_e, 0x1E15,
    XK_grave, XK_macron, XK_o, 0x1E51,
    XK_grave, XK_dead_circumflex, XK_A, 0x1EA6,
    XK_grave, XK_dead_circumflex, XK_E, 0x1EC0,
    XK_grave, XK_dead_circumflex, XK_O, 0x1ED2,
    XK_grave, XK_dead_circumflex, XK_a, 0x1EA7,
    XK_grave, XK_dead_circumflex, XK_e, 0x1EC1,
    XK_grave, XK_dead_circumflex, XK_o, 0x1ED3,
    XK_grave, XK_dead_macron, XK_E, 0x1E14,
    XK_grave, XK_dead_macron, XK_O, 0x1E50,
    XK_grave, XK_dead_macron, XK_e, 0x1E15,
    XK_grave, XK_dead_macron, XK_o, 0x1E51,
    XK_grave, XK_dead_breve, XK_A, 0x1EB0,
    XK_grave, XK_dead_breve, XK_a, 0x1EB1,
    XK_grave, XK_dead_diaeresis, XK_U, 0x01DB,
    XK_grave, XK_dead_diaeresis, XK_u, 0x01DC,
    XK_grave, XK_dead_diaeresis, XK_Greek_iota, 0x1FD2,
    XK_grave, XK_dead_diaeresis, XK_Greek_upsilon, 0x1FE2,
    XK_grave, XK_dead_horn, XK_O, 0x1EDC,
    XK_grave, XK_dead_horn, XK_U, 0x1EEA,
    XK_grave, XK_dead_horn, XK_o, 0x1EDD,
    XK_grave, XK_dead_horn, XK_u, 0x1EEB,
    XK_grave, XK_dead_psili, XK_Greek_ALPHA, 0x1F0A,
    XK_grave, XK_dead_psili, XK_Greek_EPSILON, 0x1F1A,
    XK_grave, XK_dead_psili, XK_Greek_ETA, 0x1F2A,
    XK_grave, XK_dead_psili, XK_Greek_IOTA, 0x1F3A,
    XK_grave, XK_dead_psili, XK_Greek_OMICRON, 0x1F4A,
    XK_grave, XK_dead_psili, XK_Greek_OMEGA, 0x1F6A,
    XK_grave, XK_dead_psili, XK_Greek_alpha, 0x1F02,
    XK_grave, XK_dead_psili, XK_Greek_epsilon, 0x1F12,
    XK_grave, XK_dead_psili, XK_Greek_eta, 0x1F22,
    XK_grave, XK_dead_psili, XK_Greek_iota, 0x1F32,
    XK_grave, XK_dead_psili, XK_Greek_omicron, 0x1F42,
    XK_grave, XK_dead_psili, XK_Greek_upsilon, 0x1F52,
    XK_grave, XK_dead_psili, XK_Greek_omega, 0x1F62,
    XK_grave, XK_dead_dasia, XK_Greek_ALPHA, 0x1F0B,
    XK_grave, XK_dead_dasia, XK_Greek_EPSILON, 0x1F1B,
    XK_grave, XK_dead_dasia, XK_Greek_ETA, 0x1F2B,
    XK_grave, XK_dead_dasia, XK_Greek_IOTA, 0x1F3B,
    XK_grave, XK_dead_dasia, XK_Greek_OMICRON, 0x1F4B,
    XK_grave, XK_dead_dasia, XK_Greek_UPSILON, 0x1F5B,
    XK_grave, XK_dead_dasia, XK_Greek_OMEGA, 0x1F6B,
    XK_grave, XK_dead_dasia, XK_Greek_alpha, 0x1F03,
    XK_grave, XK_dead_dasia, XK_Greek_epsilon, 0x1F13,
    XK_grave, XK_dead_dasia, XK_Greek_eta, 0x1F23,
    XK_grave, XK_dead_dasia, XK_Greek_iota, 0x1F33,
    XK_grave, XK_dead_dasia, XK_Greek_omicron, 0x1F43,
    XK_grave, XK_dead_dasia, XK_Greek_upsilon, 0x1F53,
    XK_grave, XK_dead_dasia, XK_Greek_omega, 0x1F63,
    XK_b, XK_exclam, XK_A, 0x1EB6,
    XK_b, XK_exclam, XK_a, 0x1EB7,
    XK_b, XK_comma, XK_E, 0x1E1C,
    XK_b, XK_comma, XK_e, 0x1E1D,
    XK_b, XK_cedilla, XK_E, 0x1E1C,
    XK_b, XK_cedilla, XK_e, 0x1E1D,
    XK_b, XK_dead_cedilla, XK_E, 0x1E1C,
    XK_b, XK_dead_cedilla, XK_e, 0x1E1D,
    XK_b, XK_dead_belowdot, XK_A, 0x1EB6,
    XK_b, XK_dead_belowdot, XK_a, 0x1EB7,
    XK_c, XK_quotedbl, XK_U, 0x01D9,
    XK_c, XK_quotedbl, XK_u, 0x01DA,
    XK_c, XK_dead_diaeresis, XK_U, 0x01D9,
    XK_c, XK_dead_diaeresis, XK_u, 0x01DA,
    XK_o, XK_apostrophe, XK_A, 0x01FA,
    XK_o, XK_apostrophe, XK_a, 0x01FB,
    XK_asciitilde, XK_quotedbl, XK_Greek_iota, 0x1FD7,
    XK_asciitilde, XK_quotedbl, XK_Greek_upsilon, 0x1FE7,
    XK_asciitilde, XK_parenleft, XK_Greek_ALPHA, 0x1F0F,
    XK_asciitilde, XK_parenleft, XK_Greek_ETA, 0x1F2F,
    XK_asciitilde, XK_parenleft, XK_Greek_IOTA, 0x1F3F,
    XK_asciitilde, XK_parenleft, XK_Greek_UPSILON, 0x1F5F,
    XK_asciitilde, XK_parenleft, XK_Greek_OMEGA, 0x1F6F,
    XK_asciitilde, XK_parenleft, XK_Greek_alpha, 0x1F07,
    XK_asciitilde, XK_parenleft, XK_Greek_eta, 0x1F27,
    XK_asciitilde, XK_parenleft, XK_Greek_iota, 0x1F37,
    XK_asciitilde, XK_parenleft, XK_Greek_upsilon, 0x1F57,
    XK_asciitilde, XK_parenleft, XK_Greek_omega, 0x1F67,
    XK_asciitilde, XK_parenright, XK_Greek_ALPHA, 0x1F0E,
    XK_asciitilde, XK_parenright, XK_Greek_ETA, 0x1F2E,
    XK_asciitilde, XK_parenright, XK_Greek_IOTA, 0x1F3E,
    XK_asciitilde, XK_parenright, XK_Greek_OMEGA, 0x1F6E,
    XK_asciitilde, XK_parenright, XK_Greek_alpha, 0x1F06,
    XK_asciitilde, XK_parenright, XK_Greek_eta, 0x1F26,
    XK_asciitilde, XK_parenright, XK_Greek_iota, 0x1F36,
    XK_asciitilde, XK_parenright, XK_Greek_upsilon, 0x1F56,
    XK_asciitilde, XK_parenright, XK_Greek_omega, 0x1F66,
    XK_asciitilde, XK_plus, XK_O, 0x1EE0,
    XK_asciitilde, XK_plus, XK_U, 0x1EEE,
    XK_asciitilde, XK_plus, XK_o, 0x1EE1,
    XK_asciitilde, XK_plus, XK_u, 0x1EEF,
    XK_asciitilde, XK_asciicircum, XK_A, 0x1EAA,
    XK_asciitilde, XK_asciicircum, XK_E, 0x1EC4,
    XK_asciitilde, XK_asciicircum, XK_O, 0x1ED6,
    XK_asciitilde, XK_asciicircum, XK_a, 0x1EAB,
    XK_asciitilde, XK_asciicircum, XK_e, 0x1EC5,
    XK_asciitilde, XK_asciicircum, XK_o, 0x1ED7,
    XK_asciitilde, XK_b, XK_A, 0x1EB4,
    XK_asciitilde, XK_b, XK_a, 0x1EB5,
    XK_asciitilde, XK_dead_circumflex, XK_A, 0x1EAA,
    XK_asciitilde, XK_dead_circumflex, XK_E, 0x1EC4,
    XK_asciitilde, XK_dead_circumflex, XK_O, 0x1ED6,
    XK_asciitilde, XK_dead_circumflex, XK_a, 0x1EAB,
    XK_asciitilde, XK_dead_circumflex, XK_e, 0x1EC5,
    XK_asciitilde, XK_dead_circumflex, XK_o, 0x1ED7,
    XK_asciitilde, XK_dead_breve, XK_A, 0x1EB4,
    XK_asciitilde, XK_dead_breve, XK_a, 0x1EB5,
    XK_asciitilde, XK_dead_diaeresis, XK_Greek_iota, 0x1FD7,
    XK_asciitilde, XK_dead_diaeresis, XK_Greek_upsilon, 0x1FE7,
    XK_asciitilde, XK_dead_horn, XK_O, 0x1EE0,
    XK_asciitilde, XK_dead_horn, XK_U, 0x1EEE,
    XK_asciitilde, XK_dead_horn, XK_o, 0x1EE1,
    XK_asciitilde, XK_dead_horn, XK_u, 0x1EEF,
    XK_asciitilde, XK_dead_psili, XK_Greek_ALPHA, 0x1F0E,
    XK_asciitilde, XK_dead_psili, XK_Greek_ETA, 0x1F2E,
    XK_asciitilde, XK_dead_psili, XK_Greek_IOTA, 0x1F3E,
    XK_asciitilde, XK_dead_psili, XK_Greek_OMEGA, 0x1F6E,
    XK_asciitilde, XK_dead_psili, XK_Greek_alpha, 0x1F06,
    XK_asciitilde, XK_dead_psili, XK_Greek_eta, 0x1F26,
    XK_asciitilde, XK_dead_psili, XK_Greek_iota, 0x1F36,
    XK_asciitilde, XK_dead_psili, XK_Greek_upsilon, 0x1F56,
    XK_asciitilde, XK_dead_psili, XK_Greek_omega, 0x1F66,
    XK_asciitilde, XK_dead_dasia, XK_Greek_ALPHA, 0x1F0F,
    XK_asciitilde, XK_dead_dasia, XK_Greek_ETA, 0x1F2F,
    XK_asciitilde, XK_dead_dasia, XK_Greek_IOTA, 0x1F3F,
    XK_asciitilde, XK_dead_dasia, XK_Greek_UPSILON, 0x1F5F,
    XK_asciitilde, XK_dead_dasia, XK_Greek_OMEGA, 0x1F6F,
    XK_asciitilde, XK_dead_dasia, XK_Greek_alpha, 0x1F07,
    XK_asciitilde, XK_dead_dasia, XK_Greek_eta, 0x1F27,
    XK_asciitilde, XK_dead_dasia, XK_Greek_iota, 0x1F37,
    XK_asciitilde, XK_dead_dasia, XK_Greek_upsilon, 0x1F57,
    XK_asciitilde, XK_dead_dasia, XK_Greek_omega, 0x1F67,
    XK_macron, XK_exclam, XK_L, 0x1E38,
    XK_macron, XK_exclam, XK_R, 0x1E5C,
    XK_macron, XK_exclam, XK_l, 0x1E39,
    XK_macron, XK_exclam, XK_r, 0x1E5D,
    XK_macron, XK_quotedbl, XK_A, 0x01DE,
    XK_macron, XK_quotedbl, XK_O, 0x022A,
    XK_macron, XK_quotedbl, XK_U, 0x01D5,
    XK_macron, XK_quotedbl, XK_a, 0x01DF,
    XK_macron, XK_quotedbl, XK_o, 0x022B,
    XK_macron, XK_quotedbl, XK_u, 0x01D6,
    XK_macron, XK_period, XK_A, 0x01E0,
    XK_macron, XK_period, XK_O, 0x0230,
    XK_macron, XK_period, XK_a, 0x01E1,
    XK_macron, XK_period, XK_o, 0x0231,
    XK_macron, XK_semicolon, XK_O, 0x01EC,
    XK_macron, XK_semicolon, XK_o, 0x01ED,
    XK_macron, XK_asciitilde, XK_O, 0x022C,
    XK_macron, XK_asciitilde, XK_o, 0x022D,
    XK_macron, XK_dead_tilde, XK_O, 0x022C,
    XK_macron, XK_dead_tilde, XK_o, 0x022D,
    XK_macron, XK_dead_abovedot, XK_A, 0x01E0,
    XK_macron, XK_dead_abovedot, XK_O, 0x0230,
    XK_macron, XK_dead_abovedot, XK_a, 0x01E1,
    XK_macron, XK_dead_abovedot, XK_o, 0x0231,
    XK_macron, XK_dead_diaeresis, XK_A, 0x01DE,
    XK_macron, XK_dead_diaeresis, XK_O, 0x022A,
    XK_macron, XK_dead_diaeresis, XK_U, 0x01D5,
    XK_macron, XK_dead_diaeresis, XK_a, 0x01DF,
    XK_macron, XK_dead_diaeresis, XK_o, 0x022B,
    XK_macron, XK_dead_diaeresis, XK_u, 0x01D6,
    XK_macron, XK_dead_ogonek, XK_O, 0x01EC,
    XK_macron, XK_dead_ogonek, XK_o, 0x01ED,
    XK_macron, XK_dead_belowdot, XK_L, 0x1E38,
    XK_macron, XK_dead_belowdot, XK_R, 0x1E5C,
    XK_macron, XK_dead_belowdot, XK_l, 0x1E39,
    XK_macron, XK_dead_belowdot, XK_r, 0x1E5D,
    XK_acute, XK_quotedbl, XK_I, 0x1E2E,
    XK_acute, XK_quotedbl, XK_U, 0x01D7,
    XK_acute, XK_quotedbl, XK_i, 0x1E2F,
    XK_acute, XK_quotedbl, XK_u, 0x01D8,
    XK_acute, XK_quotedbl, XK_Greek_iota, 0x0390,
    XK_acute, XK_quotedbl, XK_Greek_upsilon, 0x03B0,
    XK_acute, XK_parenleft, XK_Greek_ALPHA, 0x1F0D,
    XK_acute, XK_parenleft, XK_Greek_EPSILON, 0x1F1D,
    XK_acute, XK_parenleft, XK_Greek_ETA, 0x1F2D,
    XK_acute, XK_parenleft, XK_Greek_IOTA, 0x1F3D,
    XK_acute, XK_parenleft, XK_Greek_OMICRON, 0x1F4D,
    XK_acute, XK_parenleft, XK_Greek_UPSILON, 0x1F5D,
    XK_acute, XK_parenleft, XK_Greek_OMEGA, 0x1F6D,
    XK_acute, XK_parenleft, XK_Greek_alpha, 0x1F05,
    XK_acute, XK_parenleft, XK_Greek_epsilon, 0x1F15,
    XK_acute, XK_parenleft, XK_Greek_eta, 0x1F25,
    XK_acute, XK_parenleft, XK_Greek_iota, 0x1F35,
    XK_acute, XK_parenleft, XK_Greek_omicron, 0x1F45,
    XK_acute, XK_parenleft, XK_Greek_upsilon, 0x1F55,
    XK_acute, XK_parenleft, XK_Greek_omega, 0x1F65,
    XK_acute, XK_parenright, XK_Greek_ALPHA, 0x1F0C,
    XK_acute, XK_parenright, XK_Greek_EPSILON, 0x1F1C,
    XK_acute, XK_parenright, XK_Greek_ETA, 0x1F2C,
    XK_acute, XK_parenright, XK_Greek_IOTA, 0x1F3C,
    XK_acute, XK_parenright, XK_Greek_OMICRON, 0x1F4C,
    XK_acute, XK_parenright, XK_Greek_OMEGA, 0x1F6C,
    XK_acute, XK_parenright, XK_Greek_alpha, 0x1F04,
    XK_acute, XK_parenright, XK_Greek_epsilon, 0x1F14,
    XK_acute, XK_parenright, XK_Greek_eta, 0x1F24,
    XK_acute, XK_parenright, XK_Greek_iota, 0x1F34,
    XK_acute, XK_parenright, XK_Greek_omicron, 0x1F44,
    XK_acute, XK_parenright, XK_Greek_upsilon, 0x1F54,
    XK_acute, XK_parenright, XK_Greek_omega, 0x1F64,
    XK_acute, XK_plus, XK_O, 0x1EDA,
    XK_acute, XK_plus, XK_U, 0x1EE8,
    XK_acute, XK_plus, XK_o, 0x1EDB,
    XK_acute, XK_plus, XK_u, 0x1EE9,
    XK_acute, XK_comma, XK_C, 0x1E08,
    XK_acute, XK_comma, XK_c, 0x1E09,
    XK_acute, XK_slash, XK_O, 0x01FE,
    XK_acute, XK_slash, XK_o, 0x01FF,
    XK_acute, XK_asciicircum, XK_A, 0x1EA4,
    XK_acute, XK_asciicircum, XK_E, 0x1EBE,
    XK_acute, XK_asciicircum, XK_O, 0x1ED0,
    XK_acute, XK_asciicircum, XK_a, 0x1EA5,
    XK_acute, XK_asciicircum, XK_e, 0x1EBF,
    XK_acute, XK_asciicircum, XK_o, 0x1ED1,
    XK_acute, XK_underscore, XK_E, 0x1E16,
    XK_acute, XK_underscore, XK_O, 0x1E52,
    XK_acute, XK_underscore, XK_e, 0x1E17,
    XK_acute, XK_underscore, XK_o, 0x1E53,
    XK_acute, XK_b, XK_A, 0x1EAE,
    XK_acute, XK_b, XK_a, 0x1EAF,
    XK_acute, XK_asciitilde, XK_O, 0x1E4C,
    XK_acute, XK_asciitilde, XK_U, 0x1E78,
    XK_acute, XK_asciitilde, XK_o, 0x1E4D,
    XK_acute, XK_asciitilde, XK_u, 0x1E79,
    XK_acute, XK_macron, XK_E, 0x1E16,
    XK_acute, XK_macron, XK_O, 0x1E52,
    XK_acute, XK_macron, XK_e, 0x1E17,
    XK_acute, XK_macron, XK_o, 0x1E53,
    XK_acute, XK_cedilla, XK_C, 0x1E08,
    XK_acute, XK_cedilla, XK_c, 0x1E09,
    XK_acute, XK_dead_circumflex, XK_A, 0x1EA4,
    XK_acute, XK_dead_circumflex, XK_E, 0x1EBE,
    XK_acute, XK_dead_circumflex, XK_O, 0x1ED0,
    XK_acute, XK_dead_circumflex, XK_a, 0x1EA5,
    XK_acute, XK_dead_circumflex, XK_e, 0x1EBF,
    XK_acute, XK_dead_circumflex, XK_o, 0x1ED1,
    XK_acute, XK_dead_tilde, XK_O, 0x1E4C,
    XK_acute, XK_dead_tilde, XK_U, 0x1E78,
    XK_acute, XK_dead_tilde, XK_o, 0x1E4D,
    XK_acute, XK_dead_tilde, XK_u, 0x1E79,
    XK_acute, XK_dead_macron, XK_E, 0x1E16,
    XK_acute, XK_dead_macron, XK_O, 0x1E52,
    XK_acute, XK_dead_macron, XK_e, 0x1E17,
    XK_acute, XK_dead_macron, XK_o, 0x1E53,
    XK_acute, XK_dead_breve, XK_A, 0x1EAE,
    XK_acute, XK_dead_breve, XK_a, 0x1EAF,
    XK_acute, XK_dead_diaeresis, XK_I, 0x1E2E,
    XK_acute, XK_dead_diaeresis, XK_U, 0x01D7,
    XK_acute, XK_dead_diaeresis, XK_i, 0x1E2F,
    XK_acute, XK_dead_diaeresis, XK_u, 0x01D8,
    XK_acute, XK_dead_diaeresis, XK_Greek_iota, 0x0390,
    XK_acute, XK_dead_diaeresis, XK_Greek_upsilon, 0x03B0,
    XK_acute, XK_dead_abovering, XK_A, 0x01FA,
    XK_acute, XK_dead_abovering, XK_a, 0x01FB,
    XK_acute, XK_dead_cedilla, XK_C, 0x1E08,
    XK_acute, XK_dead_cedilla, XK_c, 0x1E09,
    XK_acute, XK_dead_horn, XK_O, 0x1EDA,
    XK_acute, XK_dead_horn, XK_U, 0x1EE8,
    XK_acute, XK_dead_horn, XK_o, 0x1EDB,
    XK_acute, XK_dead_horn, XK_u, 0x1EE9,
    XK_acute, XK_dead_psili, XK_Greek_ALPHA, 0x1F0C,
    XK_acute, XK_dead_psili, XK_Greek_EPSILON, 0x1F1C,
    XK_acute, XK_dead_psili, XK_Greek_ETA, 0x1F2C,
    XK_acute, XK_dead_psili, XK_Greek_IOTA, 0x1F3C,
    XK_acute, XK_dead_psili, XK_Greek_OMICRON, 0x1F4C,
    XK_acute, XK_dead_psili, XK_Greek_OMEGA, 0x1F6C,
    XK_acute, XK_dead_psili, XK_Greek_alpha, 0x1F04,
    XK_acute, XK_dead_psili, XK_Greek_epsilon, 0x1F14,
    XK_acute, XK_dead_psili, XK_Greek_eta, 0x1F24,
    XK_acute, XK_dead_psili, XK_Greek_iota, 0x1F34,
    XK_acute, XK_dead_psili, XK_Greek_omicron, 0x1F44,
    XK_acute, XK_dead_psili, XK_Greek_upsilon, 0x1F54,
    XK_acute, XK_dead_psili, XK_Greek_omega, 0x1F64,
    XK_acute, XK_dead_dasia, XK_Greek_ALPHA, 0x1F0D,
    XK_acute, XK_dead_dasia, XK_Greek_EPSILON, 0x1F1D,
    XK_acute, XK_dead_dasia, XK_Greek_ETA, 0x1F2D,
    XK_acute, XK_dead_dasia, XK_Greek_IOTA, 0x1F3D,
    XK_acute, XK_dead_dasia, XK_Greek_OMICRON, 0x1F4D,
    XK_acute, XK_dead_dasia, XK_Greek_UPSILON, 0x1F5D,
    XK_acute, XK_dead_dasia, XK_Greek_OMEGA, 0x1F6D,
    XK_acute, XK_dead_dasia, XK_Greek_alpha, 0x1F05,
    XK_acute, XK_dead_dasia, XK_Greek_epsilon, 0x1F15,
    XK_acute, XK_dead_dasia, XK_Greek_eta, 0x1F25,
    XK_acute, XK_dead_dasia, XK_Greek_iota, 0x1F35,
    XK_acute, XK_dead_dasia, XK_Greek_omicron, 0x1F45,
    XK_acute, XK_dead_dasia, XK_Greek_upsilon, 0x1F55,
    XK_acute, XK_dead_dasia, XK_Greek_omega, 0x1F65,
    XK_acute, XK_KP_Divide, XK_O, 0x01FE,
    XK_acute, XK_KP_Divide, XK_o, 0x01FF,
    0x05C1, 0x05BC, XK_hebrew_shin, 0xFB2C,
    0x05C2, 0x05BC, XK_hebrew_shin, 0xFB2D,
    XK_Greek_iota, XK_apostrophe, XK_Greek_alpha, 0x1FB4,
    XK_Greek_iota, XK_apostrophe, XK_Greek_eta, 0x1FC4,
    XK_Greek_iota, XK_apostrophe, XK_Greek_omega, 0x1FF4,
    XK_Greek_iota, XK_apostrophe, 0x1F00, 0x1F84,
    XK_Greek_iota, XK_apostrophe, 0x1F01, 0x1F85,
    XK_Greek_iota, XK_apostrophe, 0x1F08, 0x1F8C,
    XK_Greek_iota, XK_apostrophe, 0x1F09, 0x1F8D,
    XK_Greek_iota, XK_apostrophe, 0x1F20, 0x1F94,
    XK_Greek_iota, XK_apostrophe, 0x1F21, 0x1F95,
    XK_Greek_iota, XK_apostrophe, 0x1F28, 0x1F9C,
    XK_Greek_iota, XK_apostrophe, 0x1F29, 0x1F9D,
    XK_Greek_iota, XK_apostrophe, 0x1F60, 0x1FA4,
    XK_Greek_iota, XK_apostrophe, 0x1F61, 0x1FA5,
    XK_Greek_iota, XK_apostrophe, 0x1F68, 0x1FAC,
    XK_Greek_iota, XK_apostrophe, 0x1F69, 0x1FAD,
    XK_Greek_iota, XK_parenleft, XK_Greek_ALPHA, 0x1F89,
    XK_Greek_iota, XK_parenleft, XK_Greek_ETA, 0x1F99,
    XK_Greek_iota, XK_parenleft, XK_Greek_OMEGA, 0x1FA9,
    XK_Greek_iota, XK_parenleft, XK_Greek_alpha, 0x1F81,
    XK_Greek_iota, XK_parenleft, XK_Greek_eta, 0x1F91,
    XK_Greek_iota, XK_parenleft, XK_Greek_omega, 0x1FA1,
    XK_Greek_iota, XK_parenright, XK_Greek_ALPHA, 0x1F88,
    XK_Greek_iota, XK_parenright, XK_Greek_ETA, 0x1F98,
    XK_Greek_iota, XK_parenright, XK_Greek_OMEGA, 0x1FA8,
    XK_Greek_iota, XK_parenright, XK_Greek_alpha, 0x1F80,
    XK_Greek_iota, XK_parenright, XK_Greek_eta, 0x1F90,
    XK_Greek_iota, XK_parenright, XK_Greek_omega, 0x1FA0,
    XK_Greek_iota, XK_grave, XK_Greek_alpha, 0x1FB2,
    XK_Greek_iota, XK_grave, XK_Greek_eta, 0x1FC2,
    XK_Greek_iota, XK_grave, XK_Greek_omega, 0x1FF2,
    XK_Greek_iota, XK_grave, 0x1F00, 0x1F82,
    XK_Greek_iota, XK_grave, 0x1F01, 0x1F83,
    XK_Greek_iota, XK_grave, 0x1F08, 0x1F8A,
    XK_Greek_iota, XK_grave, 0x1F09, 0x1F8B,
    XK_Greek_iota, XK_grave, 0x1F20, 0x1F92,
    XK_Greek_iota, XK_grave, 0x1F21, 0x1F93,
    XK_Greek_iota, XK_grave, 0x1F28, 0x1F9A,
    XK_Greek_iota, XK_grave, 0x1F29, 0x1F9B,
    XK_Greek_iota, XK_grave, 0x1F60, 0x1FA2,
    XK_Greek_iota, XK_grave, 0x1F61, 0x1FA3,
    XK_Greek_iota, XK_grave, 0x1F68, 0x1FAA,
    XK_Greek_iota, XK_grave, 0x1F69, 0x1FAB,
    XK_Greek_iota, XK_asciitilde, XK_Greek_alpha, 0x1FB7,
    XK_Greek_iota, XK_asciitilde, XK_Greek_eta, 0x1FC7,
    XK_Greek_iota, XK_asciitilde, XK_Greek_omega, 0x1FF7,
    XK_Greek_iota, XK_asciitilde, 0x1F00, 0x1F86,
    XK_Greek_iota, XK_asciitilde, 0x1F01, 0x1F87,
    XK_Greek_iota, XK_asciitilde, 0x1F08, 0x1F8E,
    XK_Greek_iota, XK_asciitilde, 0x1F09, 0x1F8F,
    XK_Greek_iota, XK_asciitilde, 0x1F20, 0x1F96,
    XK_Greek_iota, XK_asciitilde, 0x1F21, 0x1F97,
    XK_Greek_iota, XK_asciitilde, 0x1F28, 0x1F9E,
    XK_Greek_iota, XK_asciitilde, 0x1F29, 0x1F9F,
    XK_Greek_iota, XK_asciitilde, 0x1F60, 0x1FA6,
    XK_Greek_iota, XK_asciitilde, 0x1F61, 0x1FA7,
    XK_Greek_iota, XK_asciitilde, 0x1F68, 0x1FAE,
    XK_Greek_iota, XK_asciitilde, 0x1F69, 0x1FAF,
    XK_Greek_iota, XK_acute, XK_Greek_alpha, 0x1FB4,
    XK_Greek_iota, XK_acute, XK_Greek_eta, 0x1FC4,
    XK_Greek_iota, XK_acute, XK_Greek_omega, 0x1FF4,
    XK_Greek_iota, XK_acute, 0x1F00, 0x1F84,
    XK_Greek_iota, XK_acute, 0x1F01, 0x1F85,
    XK_Greek_iota, XK_acute, 0x1F08, 0x1F8C,
    XK_Greek_iota, XK_acute, 0x1F09, 0x1F8D,
    XK_Greek_iota, XK_acute, 0x1F20, 0x1F94,
    XK_Greek_iota, XK_acute, 0x1F21, 0x1F95,
    XK_Greek_iota, XK_acute, 0x1F28, 0x1F9C,
    XK_Greek_iota, XK_acute, 0x1F29, 0x1F9D,
    XK_Greek_iota, XK_acute, 0x1F60, 0x1FA4,
    XK_Greek_iota, XK_acute, 0x1F61, 0x1FA5,
    XK_Greek_iota, XK_acute, 0x1F68, 0x1FAC,
    XK_Greek_iota, XK_acute, 0x1F69, 0x1FAD,
    XK_Greek_iota, XK_dead_grave, XK_Greek_alpha, 0x1FB2,
    XK_Greek_iota, XK_dead_grave, XK_Greek_eta, 0x1FC2,
    XK_Greek_iota, XK_dead_grave, XK_Greek_omega, 0x1FF2,
    XK_Greek_iota, XK_dead_grave, 0x1F00, 0x1F82,
    XK_Greek_iota, XK_dead_grave, 0x1F01, 0x1F83,
    XK_Greek_iota, XK_dead_grave, 0x1F08, 0x1F8A,
    XK_Greek_iota, XK_dead_grave, 0x1F09, 0x1F8B,
    XK_Greek_iota, XK_dead_grave, 0x1F20, 0x1F92,
    XK_Greek_iota, XK_dead_grave, 0x1F21, 0x1F93,
    XK_Greek_iota, XK_dead_grave, 0x1F28, 0x1F9A,
    XK_Greek_iota, XK_dead_grave, 0x1F29, 0x1F9B,
    XK_Greek_iota, XK_dead_grave, 0x1F60, 0x1FA2,
    XK_Greek_iota, XK_dead_grave, 0x1F61, 0x1FA3,
    XK_Greek_iota, XK_dead_grave, 0x1F68, 0x1FAA,
    XK_Greek_iota, XK_dead_grave, 0x1F69, 0x1FAB,
    XK_Greek_iota, XK_dead_acute, XK_Greek_alpha, 0x1FB4,
    XK_Greek_iota, XK_dead_acute, XK_Greek_eta, 0x1FC4,
    XK_Greek_iota, XK_dead_acute, XK_Greek_omega, 0x1FF4,
    XK_Greek_iota, XK_dead_acute, 0x1F00, 0x1F84,
    XK_Greek_iota, XK_dead_acute, 0x1F01, 0x1F85,
    XK_Greek_iota, XK_dead_acute, 0x1F08, 0x1F8C,
    XK_Greek_iota, XK_dead_acute, 0x1F09, 0x1F8D,
    XK_Greek_iota, XK_dead_acute, 0x1F20, 0x1F94,
    XK_Greek_iota, XK_dead_acute, 0x1F21, 0x1F95,
    XK_Greek_iota, XK_dead_acute, 0x1F28, 0x1F9C,
    XK_Greek_iota, XK_dead_acute, 0x1F29, 0x1F9D,
    XK_Greek_iota, XK_dead_acute, 0x1F60, 0x1FA4,
    XK_Greek_iota, XK_dead_acute, 0x1F61, 0x1FA5,
    XK_Greek_iota, XK_dead_acute, 0x1F68, 0x1FAC,
    XK_Greek_iota, XK_dead_acute, 0x1F69, 0x1FAD,
    XK_Greek_iota, XK_dead_tilde, XK_Greek_alpha, 0x1FB7,
    XK_Greek_iota, XK_dead_tilde, XK_Greek_eta, 0x1FC7,
    XK_Greek_iota, XK_dead_tilde, XK_Greek_omega, 0x1FF7,
    XK_Greek_iota, XK_dead_tilde, 0x1F00, 0x1F86,
    XK_Greek_iota, XK_dead_tilde, 0x1F01, 0x1F87,
    XK_Greek_iota, XK_dead_tilde, 0x1F08, 0x1F8E,
    XK_Greek_iota, XK_dead_tilde, 0x1F09, 0x1F8F,
    XK_Greek_iota, XK_dead_tilde, 0x1F20, 0x1F96,
    XK_Greek_iota, XK_dead_tilde, 0x1F21, 0x1F97,
    XK_Greek_iota, XK_dead_tilde, 0x1F28, 0x1F9E,
    XK_Greek_iota, XK_dead_tilde, 0x1F29, 0x1F9F,
    XK_Greek_iota, XK_dead_tilde, 0x1F60, 0x1FA6,
    XK_Greek_iota, XK_dead_tilde, 0x1F61, 0x1FA7,
    XK_Greek_iota, XK_dead_tilde, 0x1F68, 0x1FAE,
    XK_Greek_iota, XK_dead_tilde, 0x1F69, 0x1FAF,
    XK_Greek_iota, XK_dead_psili, XK_Greek_ALPHA, 0x1F88,
    XK_Greek_iota, XK_dead_psili, XK_Greek_ETA, 0x1F98,
    XK_Greek_iota, XK_dead_psili, XK_Greek_OMEGA, 0x1FA8,
    XK_Greek_iota, XK_dead_psili, XK_Greek_alpha, 0x1F80,
    XK_Greek_iota, XK_dead_psili, XK_Greek_eta, 0x1F90,
    XK_Greek_iota, XK_dead_psili, XK_Greek_omega, 0x1FA0,
    XK_Greek_iota, XK_dead_dasia, XK_Greek_ALPHA, 0x1F89,
    XK_Greek_iota, XK_dead_dasia, XK_Greek_ETA, 0x1F99,
    XK_Greek_iota, XK_dead_dasia, XK_Greek_OMEGA, 0x1FA9,
    XK_Greek_iota, XK_dead_dasia, XK_Greek_alpha, 0x1F81,
    XK_Greek_iota, XK_dead_dasia, XK_Greek_eta, 0x1F91,
    XK_Greek_iota, XK_dead_dasia, XK_Greek_omega, 0x1FA1,
    XK_parenleft, XK_1, XK_0, XK_parenright, 0x2469,
    XK_parenleft, XK_1, XK_1, XK_parenright, 0x246A,
    XK_parenleft, XK_1, XK_2, XK_parenright, 0x246B,
    XK_parenleft, XK_1, XK_3, XK_parenright, 0x246C,
    XK_parenleft, XK_1, XK_4, XK_parenright, 0x246D,
    XK_parenleft, XK_1, XK_5, XK_parenright, 0x246E,
    XK_parenleft, XK_1, XK_6, XK_parenright, 0x246F,
    XK_parenleft, XK_1, XK_7, XK_parenright, 0x2470,
    XK_parenleft, XK_1, XK_8, XK_parenright, 0x2471,
    XK_parenleft, XK_1, XK_9, XK_parenright, 0x2472,
    XK_parenleft, XK_1, XK_KP_Space, XK_parenright, 0x246B,
    XK_parenleft, XK_1, XK_KP_0, XK_parenright, 0x2469,
    XK_parenleft, XK_1, XK_KP_1, XK_parenright, 0x246A,
    XK_parenleft, XK_1, XK_KP_2, XK_parenright, 0x246B,
    XK_parenleft, XK_1, XK_KP_3, XK_parenright, 0x246C,
    XK_parenleft, XK_1, XK_KP_4, XK_parenright, 0x246D,
    XK_parenleft, XK_1, XK_KP_5, XK_parenright, 0x246E,
    XK_parenleft, XK_1, XK_KP_6, XK_parenright, 0x246F,
    XK_parenleft, XK_1, XK_KP_7, XK_parenright, 0x2470,
    XK_parenleft, XK_1, XK_KP_8, XK_parenright, 0x2471,
    XK_parenleft, XK_1, XK_KP_9, XK_parenright, 0x2472,
    XK_parenleft, XK_2, XK_0, XK_parenright, 0x2473,
    XK_parenleft, XK_2, XK_1, XK_parenright, 0x3251,
    XK_parenleft, XK_2, XK_2, XK_parenright, 0x3252,
    XK_parenleft, XK_2, XK_3, XK_parenright, 0x3253,
    XK_parenleft, XK_2, XK_4, XK_parenright, 0x3254,
    XK_parenleft, XK_2, XK_5, XK_parenright, 0x3255,
    XK_parenleft, XK_2, XK_6, XK_parenright, 0x3256,
    XK_parenleft, XK_2, XK_7, XK_parenright, 0x3257,
    XK_parenleft, XK_2, XK_8, XK_parenright, 0x3258,
    XK_parenleft, XK_2, XK_9, XK_parenright, 0x3259,
    XK_parenleft, XK_2, XK_KP_Space, XK_parenright, 0x3252,
    XK_parenleft, XK_2, XK_KP_0, XK_parenright, 0x2473,
    XK_parenleft, XK_2, XK_KP_1, XK_parenright, 0x3251,
    XK_parenleft, XK_2, XK_KP_2, XK_parenright, 0x3252,
    XK_parenleft, XK_2, XK_KP_3, XK_parenright, 0x3253,
    XK_parenleft, XK_2, XK_KP_4, XK_parenright, 0x3254,
    XK_parenleft, XK_2, XK_KP_5, XK_parenright, 0x3255,
    XK_parenleft, XK_2, XK_KP_6, XK_parenright, 0x3256,
    XK_parenleft, XK_2, XK_KP_7, XK_parenright, 0x3257,
    XK_parenleft, XK_2, XK_KP_8, XK_parenright, 0x3258,
    XK_parenleft, XK_2, XK_KP_9, XK_parenright, 0x3259,
    XK_parenleft, XK_3, XK_0, XK_parenright, 0x325A,
    XK_parenleft, XK_3, XK_1, XK_parenright, 0x325B,
    XK_parenleft, XK_3, XK_2, XK_parenright, 0x325C,
    XK_parenleft, XK_3, XK_3, XK_parenright, 0x325D,
    XK_parenleft, XK_3, XK_4, XK_parenright, 0x325E,
    XK_parenleft, XK_3, XK_5, XK_parenright, 0x325F,
    XK_parenleft, XK_3, XK_6, XK_parenright, 0x32B1,
    XK_parenleft, XK_3, XK_7, XK_parenright, 0x32B2,
    XK_parenleft, XK_3, XK_8, XK_parenright, 0x32B3,
    XK_parenleft, XK_3, XK_9, XK_parenright, 0x32B4,
    XK_parenleft, XK_3, XK_KP_Space, XK_parenright, 0x325C,
    XK_parenleft, XK_3, XK_KP_0, XK_parenright, 0x325A,
    XK_parenleft, XK_3, XK_KP_1, XK_parenright, 0x325B,
    XK_parenleft, XK_3, XK_KP_2, XK_parenright, 0x325C,
    XK_parenleft, XK_3, XK_KP_3, XK_parenright, 0x325D,
    XK_parenleft, XK_3, XK_KP_4, XK_parenright, 0x325E,
    XK_parenleft, XK_3, XK_KP_5, XK_parenright, 0x325F,
    XK_parenleft, XK_3, XK_KP_6, XK_parenright, 0x32B1,
    XK_parenleft, XK_3, XK_KP_7, XK_parenright, 0x32B2,
    XK_parenleft, XK_3, XK_KP_8, XK_parenright, 0x32B3,
    XK_parenleft, XK_3, XK_KP_9, XK_parenright, 0x32B4,
    XK_parenleft, XK_4, XK_0, XK_parenright, 0x32B5,
    XK_parenleft, XK_4, XK_1, XK_parenright, 0x32B6,
    XK_parenleft, XK_4, XK_2, XK_parenright, 0x32B7,
    XK_parenleft, XK_4, XK_3, XK_parenright, 0x32B8,
    XK_parenleft, XK_4, XK_4, XK_parenright, 0x32B9,
    XK_parenleft, XK_4, XK_5, XK_parenright, 0x32BA,
    XK_parenleft, XK_4, XK_6, XK_parenright, 0x32BB,
    XK_parenleft, XK_4, XK_7, XK_parenright, 0x32BC,
    XK_parenleft, XK_4, XK_8, XK_parenright, 0x32BD,
    XK_parenleft, XK_4, XK_9, XK_parenright, 0x32BE,
    XK_parenleft, XK_4, XK_KP_Space, XK_parenright, 0x32B7,
    XK_parenleft, XK_4, XK_KP_0, XK_parenright, 0x32B5,
    XK_parenleft, XK_4, XK_KP_1, XK_parenright, 0x32B6,
    XK_parenleft, XK_4, XK_KP_2, XK_parenright, 0x32B7,
    XK_parenleft, XK_4, XK_KP_3, XK_parenright, 0x32B8,
    XK_parenleft, XK_4, XK_KP_4, XK_parenright, 0x32B9,
    XK_parenleft, XK_4, XK_KP_5, XK_parenright, 0x32BA,
    XK_parenleft, XK_4, XK_KP_6, XK_parenright, 0x32BB,
    XK_parenleft, XK_4, XK_KP_7, XK_parenright, 0x32BC,
    XK_parenleft, XK_4, XK_KP_8, XK_parenright, 0x32BD,
    XK_parenleft, XK_4, XK_KP_9, XK_parenright, 0x32BE,
    XK_parenleft, XK_5, XK_KP_0, XK_parenright, 0x32BF,
    XK_parenleft, 0x1100, 0x1161, XK_parenright, 0x326E,
    XK_parenleft, 0x1102, 0x1161, XK_parenright, 0x326F,
    XK_parenleft, 0x1103, 0x1161, XK_parenright, 0x3270,
    XK_parenleft, 0x1105, 0x1161, XK_parenright, 0x3271,
    XK_parenleft, 0x1106, 0x1161, XK_parenright, 0x3272,
    XK_parenleft, 0x1107, 0x1161, XK_parenright, 0x3273,
    XK_parenleft, 0x1109, 0x1161, XK_parenright, 0x3274,
    XK_parenleft, 0x110B, 0x1161, XK_parenright, 0x3275,
    XK_parenleft, 0x110C, 0x1161, XK_parenright, 0x3276,
    XK_parenleft, 0x110E, 0x1161, XK_parenright, 0x3277,
    XK_parenleft, 0x110F, 0x1161, XK_parenright, 0x3278,
    XK_parenleft, 0x1110, 0x1161, XK_parenright, 0x3279,
    XK_parenleft, 0x1111, 0x1161, XK_parenright, 0x327A,
    XK_parenleft, 0x1112, 0x1161, XK_parenright, 0x327B,
    XK_parenleft, XK_KP_Space, XK_0, XK_parenright, 0x2473,
    XK_parenleft, XK_KP_Space, XK_1, XK_parenright, 0x3251,
    XK_parenleft, XK_KP_Space, XK_2, XK_parenright, 0x3252,
    XK_parenleft, XK_KP_Space, XK_3, XK_parenright, 0x3253,
    XK_parenleft, XK_KP_Space, XK_4, XK_parenright, 0x3254,
    XK_parenleft, XK_KP_Space, XK_5, XK_parenright, 0x3255,
    XK_parenleft, XK_KP_Space, XK_6, XK_parenright, 0x3256,
    XK_parenleft, XK_KP_Space, XK_7, XK_parenright, 0x3257,
    XK_parenleft, XK_KP_Space, XK_8, XK_parenright, 0x3258,
    XK_parenleft, XK_KP_Space, XK_9, XK_parenright, 0x3259,
    XK_parenleft, XK_KP_Space, XK_KP_Space, XK_parenright, 0x3252,
    XK_parenleft, XK_KP_Space, XK_KP_0, XK_parenright, 0x2473,
    XK_parenleft, XK_KP_Space, XK_KP_1, XK_parenright, 0x3251,
    XK_parenleft, XK_KP_Space, XK_KP_2, XK_parenright, 0x3252,
    XK_parenleft, XK_KP_Space, XK_KP_3, XK_parenright, 0x3253,
    XK_parenleft, XK_KP_Space, XK_KP_4, XK_parenright, 0x3254,
    XK_parenleft, XK_KP_Space, XK_KP_5, XK_parenright, 0x3255,
    XK_parenleft, XK_KP_Space, XK_KP_6, XK_parenright, 0x3256,
    XK_parenleft, XK_KP_Space, XK_KP_7, XK_parenright, 0x3257,
    XK_parenleft, XK_KP_Space, XK_KP_8, XK_parenright, 0x3258,
    XK_parenleft, XK_KP_Space, XK_KP_9, XK_parenright, 0x3259,
    XK_parenleft, XK_KP_1, XK_0, XK_parenright, 0x2469,
    XK_parenleft, XK_KP_1, XK_1, XK_parenright, 0x246A,
    XK_parenleft, XK_KP_1, XK_2, XK_parenright, 0x246B,
    XK_parenleft, XK_KP_1, XK_3, XK_parenright, 0x246C,
    XK_parenleft, XK_KP_1, XK_4, XK_parenright, 0x246D,
    XK_parenleft, XK_KP_1, XK_5, XK_parenright, 0x246E,
    XK_parenleft, XK_KP_1, XK_6, XK_parenright, 0x246F,
    XK_parenleft, XK_KP_1, XK_7, XK_parenright, 0x2470,
    XK_parenleft, XK_KP_1, XK_8, XK_parenright, 0x2471,
    XK_parenleft, XK_KP_1, XK_9, XK_parenright, 0x2472,
    XK_parenleft, XK_KP_1, XK_KP_Space, XK_parenright, 0x246B,
    XK_parenleft, XK_KP_1, XK_KP_0, XK_parenright, 0x2469,
    XK_parenleft, XK_KP_1, XK_KP_1, XK_parenright, 0x246A,
    XK_parenleft, XK_KP_1, XK_KP_2, XK_parenright, 0x246B,
    XK_parenleft, XK_KP_1, XK_KP_3, XK_parenright, 0x246C,
    XK_parenleft, XK_KP_1, XK_KP_4, XK_parenright, 0x246D,
    XK_parenleft, XK_KP_1, XK_KP_5, XK_parenright, 0x246E,
    XK_parenleft, XK_KP_1, XK_KP_6, XK_parenright, 0x246F,
    XK_parenleft, XK_KP_1, XK_KP_7, XK_parenright, 0x2470,
    XK_parenleft, XK_KP_1, XK_KP_8, XK_parenright, 0x2471,
    XK_parenleft, XK_KP_1, XK_KP_9, XK_parenright, 0x2472,
    XK_parenleft, XK_KP_2, XK_0, XK_parenright, 0x2473,
    XK_parenleft, XK_KP_2, XK_1, XK_parenright, 0x3251,
    XK_parenleft, XK_KP_2, XK_2, XK_parenright, 0x3252,
    XK_parenleft, XK_KP_2, XK_3, XK_parenright, 0x3253,
    XK_parenleft, XK_KP_2, XK_4, XK_parenright, 0x3254,
    XK_parenleft, XK_KP_2, XK_5, XK_parenright, 0x3255,
    XK_parenleft, XK_KP_2, XK_6, XK_parenright, 0x3256,
    XK_parenleft, XK_KP_2, XK_7, XK_parenright, 0x3257,
    XK_parenleft, XK_KP_2, XK_8, XK_parenright, 0x3258,
    XK_parenleft, XK_KP_2, XK_9, XK_parenright, 0x3259,
    XK_parenleft, XK_KP_2, XK_KP_Space, XK_parenright, 0x3252,
    XK_parenleft, XK_KP_2, XK_KP_0, XK_parenright, 0x2473,
    XK_parenleft, XK_KP_2, XK_KP_1, XK_parenright, 0x3251,
    XK_parenleft, XK_KP_2, XK_KP_2, XK_parenright, 0x3252,
    XK_parenleft, XK_KP_2, XK_KP_3, XK_parenright, 0x3253,
    XK_parenleft, XK_KP_2, XK_KP_4, XK_parenright, 0x3254,
    XK_parenleft, XK_KP_2, XK_KP_5, XK_parenright, 0x3255,
    XK_parenleft, XK_KP_2, XK_KP_6, XK_parenright, 0x3256,
    XK_parenleft, XK_KP_2, XK_KP_7, XK_parenright, 0x3257,
    XK_parenleft, XK_KP_2, XK_KP_8, XK_parenright, 0x3258,
    XK_parenleft, XK_KP_2, XK_KP_9, XK_parenright, 0x3259,
    XK_parenleft, XK_KP_3, XK_0, XK_parenright, 0x325A,
    XK_parenleft, XK_KP_3, XK_1, XK_parenright, 0x325B,
    XK_parenleft, XK_KP_3, XK_2, XK_parenright, 0x325C,
    XK_parenleft, XK_KP_3, XK_3, XK_parenright, 0x325D,
    XK_parenleft, XK_KP_3, XK_4, XK_parenright, 0x325E,
    XK_parenleft, XK_KP_3, XK_5, XK_parenright, 0x325F,
    XK_parenleft, XK_KP_3, XK_6, XK_parenright, 0x32B1,
    XK_parenleft, XK_KP_3, XK_7, XK_parenright, 0x32B2,
    XK_parenleft, XK_KP_3, XK_8, XK_parenright, 0x32B3,
    XK_parenleft, XK_KP_3, XK_9, XK_parenright, 0x32B4,
    XK_parenleft, XK_KP_3, XK_KP_Space, XK_parenright, 0x325C,
    XK_parenleft, XK_KP_3, XK_KP_0, XK_parenright, 0x325A,
    XK_parenleft, XK_KP_3, XK_KP_1, XK_parenright, 0x325B,
    XK_parenleft, XK_KP_3, XK_KP_2, XK_parenright, 0x325C,
    XK_parenleft, XK_KP_3, XK_KP_3, XK_parenright, 0x325D,
    XK_parenleft, XK_KP_3, XK_KP_4, XK_parenright, 0x325E,
    XK_parenleft, XK_KP_3, XK_KP_5, XK_parenright, 0x325F,
    XK_parenleft, XK_KP_3, XK_KP_6, XK_parenright, 0x32B1,
    XK_parenleft, XK_KP_3, XK_KP_7, XK_parenright, 0x32B2,
    XK_parenleft, XK_KP_3, XK_KP_8, XK_parenright, 0x32B3,
    XK_parenleft, XK_KP_3, XK_KP_9, XK_parenright, 0x32B4,
    XK_parenleft, XK_KP_4, XK_0, XK_parenright, 0x32B5,
    XK_parenleft, XK_KP_4, XK_1, XK_parenright, 0x32B6,
    XK_parenleft, XK_KP_4, XK_2, XK_parenright, 0x32B7,
    XK_parenleft, XK_KP_4, XK_3, XK_parenright, 0x32B8,
    XK_parenleft, XK_KP_4, XK_4, XK_parenright, 0x32B9,
    XK_parenleft, XK_KP_4, XK_5, XK_parenright, 0x32BA,
    XK_parenleft, XK_KP_4, XK_6, XK_parenright, 0x32BB,
    XK_parenleft, XK_KP_4, XK_7, XK_parenright, 0x32BC,
    XK_parenleft, XK_KP_4, XK_8, XK_parenright, 0x32BD,
    XK_parenleft, XK_KP_4, XK_9, XK_parenright, 0x32BE,
    XK_parenleft, XK_KP_4, XK_KP_Space, XK_parenright, 0x32B7,
    XK_parenleft, XK_KP_4, XK_KP_0, XK_parenright, 0x32B5,
    XK_parenleft, XK_KP_4, XK_KP_1, XK_parenright, 0x32B6,
    XK_parenleft, XK_KP_4, XK_KP_2, XK_parenright, 0x32B7,
    XK_parenleft, XK_KP_4, XK_KP_3, XK_parenright, 0x32B8,
    XK_parenleft, XK_KP_4, XK_KP_4, XK_parenright, 0x32B9,
    XK_parenleft, XK_KP_4, XK_KP_5, XK_parenright, 0x32BA,
    XK_parenleft, XK_KP_4, XK_KP_6, XK_parenright, 0x32BB,
    XK_parenleft, XK_KP_4, XK_KP_7, XK_parenright, 0x32BC,
    XK_parenleft, XK_KP_4, XK_KP_8, XK_parenright, 0x32BD,
    XK_parenleft, XK_KP_4, XK_KP_9, XK_parenright, 0x32BE,
    XK_parenleft, XK_KP_5, XK_KP_0, XK_parenright, 0x32BF,
    XK_Greek_iota, XK_apostrophe, XK_parenleft, XK_Greek_ALPHA, 0x1F8D,
    XK_Greek_iota, XK_apostrophe, XK_parenleft, XK_Greek_ETA, 0x1F9D,
    XK_Greek_iota, XK_apostrophe, XK_parenleft, XK_Greek_OMEGA, 0x1FAD,
    XK_Greek_iota, XK_apostrophe, XK_parenleft, XK_Greek_alpha, 0x1F85,
    XK_Greek_iota, XK_apostrophe, XK_parenleft, XK_Greek_eta, 0x1F95,
    XK_Greek_iota, XK_apostrophe, XK_parenleft, XK_Greek_omega, 0x1FA5,
    XK_Greek_iota, XK_apostrophe, XK_parenright, XK_Greek_ALPHA, 0x1F8C,
    XK_Greek_iota, XK_apostrophe, XK_parenright, XK_Greek_ETA, 0x1F9C,
    XK_Greek_iota, XK_apostrophe, XK_parenright, XK_Greek_OMEGA, 0x1FAC,
    XK_Greek_iota, XK_apostrophe, XK_parenright, XK_Greek_alpha, 0x1F84,
    XK_Greek_iota, XK_apostrophe, XK_parenright, XK_Greek_eta, 0x1F94,
    XK_Greek_iota, XK_apostrophe, XK_parenright, XK_Greek_omega, 0x1FA4,
    XK_Greek_iota, XK_apostrophe, XK_dead_psili, XK_Greek_ALPHA, 0x1F8C,
    XK_Greek_iota, XK_apostrophe, XK_dead_psili, XK_Greek_ETA, 0x1F9C,
    XK_Greek_iota, XK_apostrophe, XK_dead_psili, XK_Greek_OMEGA, 0x1FAC,
    XK_Greek_iota, XK_apostrophe, XK_dead_psili, XK_Greek_alpha, 0x1F84,
    XK_Greek_iota, XK_apostrophe, XK_dead_psili, XK_Greek_eta, 0x1F94,
    XK_Greek_iota, XK_apostrophe, XK_dead_psili, XK_Greek_omega, 0x1FA4,
    XK_Greek_iota, XK_apostrophe, XK_dead_dasia, XK_Greek_ALPHA, 0x1F8D,
    XK_Greek_iota, XK_apostrophe, XK_dead_dasia, XK_Greek_ETA, 0x1F9D,
    XK_Greek_iota, XK_apostrophe, XK_dead_dasia, XK_Greek_OMEGA, 0x1FAD,
    XK_Greek_iota, XK_apostrophe, XK_dead_dasia, XK_Greek_alpha, 0x1F85,
    XK_Greek_iota, XK_apostrophe, XK_dead_dasia, XK_Greek_eta, 0x1F95,
    XK_Greek_iota, XK_apostrophe, XK_dead_dasia, XK_Greek_omega, 0x1FA5,
    XK_Greek_iota, XK_grave, XK_parenleft, XK_Greek_ALPHA, 0x1F8B,
    XK_Greek_iota, XK_grave, XK_parenleft, XK_Greek_ETA, 0x1F9B,
    XK_Greek_iota, XK_grave, XK_parenleft, XK_Greek_OMEGA, 0x1FAB,
    XK_Greek_iota, XK_grave, XK_parenleft, XK_Greek_alpha, 0x1F83,
    XK_Greek_iota, XK_grave, XK_parenleft, XK_Greek_eta, 0x1F93,
    XK_Greek_iota, XK_grave, XK_parenleft, XK_Greek_omega, 0x1FA3,
    XK_Greek_iota, XK_grave, XK_parenright, XK_Greek_ALPHA, 0x1F8A,
    XK_Greek_iota, XK_grave, XK_parenright, XK_Greek_ETA, 0x1F9A,
    XK_Greek_iota, XK_grave, XK_parenright, XK_Greek_OMEGA, 0x1FAA,
    XK_Greek_iota, XK_grave, XK_parenright, XK_Greek_alpha, 0x1F82,
    XK_Greek_iota, XK_grave, XK_parenright, XK_Greek_eta, 0x1F92,
    XK_Greek_iota, XK_grave, XK_parenright, XK_Greek_omega, 0x1FA2,
    XK_Greek_iota, XK_grave, XK_dead_psili, XK_Greek_ALPHA, 0x1F8A,
    XK_Greek_iota, XK_grave, XK_dead_psili, XK_Greek_ETA, 0x1F9A,
    XK_Greek_iota, XK_grave, XK_dead_psili, XK_Greek_OMEGA, 0x1FAA,
    XK_Greek_iota, XK_grave, XK_dead_psili, XK_Greek_alpha, 0x1F82,
    XK_Greek_iota, XK_grave, XK_dead_psili, XK_Greek_eta, 0x1F92,
    XK_Greek_iota, XK_grave, XK_dead_psili, XK_Greek_omega, 0x1FA2,
    XK_Greek_iota, XK_grave, XK_dead_dasia, XK_Greek_ALPHA, 0x1F8B,
    XK_Greek_iota, XK_grave, XK_dead_dasia, XK_Greek_ETA, 0x1F9B,
    XK_Greek_iota, XK_grave, XK_dead_dasia, XK_Greek_OMEGA, 0x1FAB,
    XK_Greek_iota, XK_grave, XK_dead_dasia, XK_Greek_alpha, 0x1F83,
    XK_Greek_iota, XK_grave, XK_dead_dasia, XK_Greek_eta, 0x1F93,
    XK_Greek_iota, XK_grave, XK_dead_dasia, XK_Greek_omega, 0x1FA3,
    XK_Greek_iota, XK_asciitilde, XK_parenleft, XK_Greek_ALPHA, 0x1F8F,
    XK_Greek_iota, XK_asciitilde, XK_parenleft, XK_Greek_ETA, 0x1F9F,
    XK_Greek_iota, XK_asciitilde, XK_parenleft, XK_Greek_OMEGA, 0x1FAF,
    XK_Greek_iota, XK_asciitilde, XK_parenleft, XK_Greek_alpha, 0x1F87,
    XK_Greek_iota, XK_asciitilde, XK_parenleft, XK_Greek_eta, 0x1F97,
    XK_Greek_iota, XK_asciitilde, XK_parenleft, XK_Greek_omega, 0x1FA7,
    XK_Greek_iota, XK_asciitilde, XK_parenright, XK_Greek_ALPHA, 0x1F8E,
    XK_Greek_iota, XK_asciitilde, XK_parenright, XK_Greek_ETA, 0x1F9E,
    XK_Greek_iota, XK_asciitilde, XK_parenright, XK_Greek_OMEGA, 0x1FAE,
    XK_Greek_iota, XK_asciitilde, XK_parenright, XK_Greek_alpha, 0x1F86,
    XK_Greek_iota, XK_asciitilde, XK_parenright, XK_Greek_eta, 0x1F96,
    XK_Greek_iota, XK_asciitilde, XK_parenright, XK_Greek_omega, 0x1FA6,
    XK_Greek_iota, XK_asciitilde, XK_dead_psili, XK_Greek_ALPHA, 0x1F8E,
    XK_Greek_iota, XK_asciitilde, XK_dead_psili, XK_Greek_ETA, 0x1F9E,
    XK_Greek_iota, XK_asciitilde, XK_dead_psili, XK_Greek_OMEGA, 0x1FAE,
    XK_Greek_iota, XK_asciitilde, XK_dead_psili, XK_Greek_alpha, 0x1F86,
    XK_Greek_iota, XK_asciitilde, XK_dead_psili, XK_Greek_eta, 0x1F96,
    XK_Greek_iota, XK_asciitilde, XK_dead_psili, XK_Greek_omega, 0x1FA6,
    XK_Greek_iota, XK_asciitilde, XK_dead_dasia, XK_Greek_ALPHA, 0x1F8F,
    XK_Greek_iota, XK_asciitilde, XK_dead_dasia, XK_Greek_ETA, 0x1F9F,
    XK_Greek_iota, XK_asciitilde, XK_dead_dasia, XK_Greek_OMEGA, 0x1FAF,
    XK_Greek_iota, XK_asciitilde, XK_dead_dasia, XK_Greek_alpha, 0x1F87,
    XK_Greek_iota, XK_asciitilde, XK_dead_dasia, XK_Greek_eta, 0x1F97,
    XK_Greek_iota, XK_asciitilde, XK_dead_dasia, XK_Greek_omega, 0x1FA7,
    XK_Greek_iota, XK_acute, XK_parenleft, XK_Greek_ALPHA, 0x1F8D,
    XK_Greek_iota, XK_acute, XK_parenleft, XK_Greek_ETA, 0x1F9D,
    XK_Greek_iota, XK_acute, XK_parenleft, XK_Greek_OMEGA, 0x1FAD,
    XK_Greek_iota, XK_acute, XK_parenleft, XK_Greek_alpha, 0x1F85,
    XK_Greek_iota, XK_acute, XK_parenleft, XK_Greek_eta, 0x1F95,
    XK_Greek_iota, XK_acute, XK_parenleft, XK_Greek_omega, 0x1FA5,
    XK_Greek_iota, XK_acute, XK_parenright, XK_Greek_ALPHA, 0x1F8C,
    XK_Greek_iota, XK_acute, XK_parenright, XK_Greek_ETA, 0x1F9C,
    XK_Greek_iota, XK_acute, XK_parenright, XK_Greek_OMEGA, 0x1FAC,
    XK_Greek_iota, XK_acute, XK_parenright, XK_Greek_alpha, 0x1F84,
    XK_Greek_iota, XK_acute, XK_parenright, XK_Greek_eta, 0x1F94,
    XK_Greek_iota, XK_acute, XK_parenright, XK_Greek_omega, 0x1FA4,
    XK_Greek_iota, XK_acute, XK_dead_psili, XK_Greek_ALPHA, 0x1F8C,
    XK_Greek_iota, XK_acute, XK_dead_psili, XK_Greek_ETA, 0x1F9C,
    XK_Greek_iota, XK_acute, XK_dead_psili, XK_Greek_OMEGA, 0x1FAC,
    XK_Greek_iota, XK_acute, XK_dead_psili, XK_Greek_alpha, 0x1F84,
    XK_Greek_iota, XK_acute, XK_dead_psili, XK_Greek_eta, 0x1F94,
    XK_Greek_iota, XK_acute, XK_dead_psili, XK_Greek_omega, 0x1FA4,
    XK_Greek_iota, XK_acute, XK_dead_dasia, XK_Greek_ALPHA, 0x1F8D,
    XK_Greek_iota, XK_acute, XK_dead_dasia, XK_Greek_ETA, 0x1F9D,
    XK_Greek_iota, XK_acute, XK_dead_dasia, XK_Greek_OMEGA, 0x1FAD,
    XK_Greek_iota, XK_acute, XK_dead_dasia, XK_Greek_alpha, 0x1F85,
    XK_Greek_iota, XK_acute, XK_dead_dasia, XK_Greek_eta, 0x1F95,
    XK_Greek_iota, XK_acute, XK_dead_dasia, XK_Greek_omega, 0x1FA5,
    XK_Greek_iota, XK_dead_grave, XK_parenleft, XK_Greek_ALPHA, 0x1F8B,
    XK_Greek_iota, XK_dead_grave, XK_parenleft, XK_Greek_ETA, 0x1F9B,
    XK_Greek_iota, XK_dead_grave, XK_parenleft, XK_Greek_OMEGA, 0x1FAB,
    XK_Greek_iota, XK_dead_grave, XK_parenleft, XK_Greek_alpha, 0x1F83,
    XK_Greek_iota, XK_dead_grave, XK_parenleft, XK_Greek_eta, 0x1F93,
    XK_Greek_iota, XK_dead_grave, XK_parenleft, XK_Greek_omega, 0x1FA3,
    XK_Greek_iota, XK_dead_grave, XK_parenright, XK_Greek_ALPHA, 0x1F8A,
    XK_Greek_iota, XK_dead_grave, XK_parenright, XK_Greek_ETA, 0x1F9A,
    XK_Greek_iota, XK_dead_grave, XK_parenright, XK_Greek_OMEGA, 0x1FAA,
    XK_Greek_iota, XK_dead_grave, XK_parenright, XK_Greek_alpha, 0x1F82,
    XK_Greek_iota, XK_dead_grave, XK_parenright, XK_Greek_eta, 0x1F92,
    XK_Greek_iota, XK_dead_grave, XK_parenright, XK_Greek_omega, 0x1FA2,
    XK_Greek_iota, XK_dead_grave, XK_dead_psili, XK_Greek_ALPHA, 0x1F8A,
    XK_Greek_iota, XK_dead_grave, XK_dead_psili, XK_Greek_ETA, 0x1F9A,
    XK_Greek_iota, XK_dead_grave, XK_dead_psili, XK_Greek_OMEGA, 0x1FAA,
    XK_Greek_iota, XK_dead_grave, XK_dead_psili, XK_Greek_alpha, 0x1F82,
    XK_Greek_iota, XK_dead_grave, XK_dead_psili, XK_Greek_eta, 0x1F92,
    XK_Greek_iota, XK_dead_grave, XK_dead_psili, XK_Greek_omega, 0x1FA2,
    XK_Greek_iota, XK_dead_grave, XK_dead_dasia, XK_Greek_ALPHA, 0x1F8B,
    XK_Greek_iota, XK_dead_grave, XK_dead_dasia, XK_Greek_ETA, 0x1F9B,
    XK_Greek_iota, XK_dead_grave, XK_dead_dasia, XK_Greek_OMEGA, 0x1FAB,
    XK_Greek_iota, XK_dead_grave, XK_dead_dasia, XK_Greek_alpha, 0x1F83,
    XK_Greek_iota, XK_dead_grave, XK_dead_dasia, XK_Greek_eta, 0x1F93,
    XK_Greek_iota, XK_dead_grave, XK_dead_dasia, XK_Greek_omega, 0x1FA3,
    XK_Greek_iota, XK_dead_acute, XK_parenleft, XK_Greek_ALPHA, 0x1F8D,
    XK_Greek_iota, XK_dead_acute, XK_parenleft, XK_Greek_ETA, 0x1F9D,
    XK_Greek_iota, XK_dead_acute, XK_parenleft, XK_Greek_OMEGA, 0x1FAD,
    XK_Greek_iota, XK_dead_acute, XK_parenleft, XK_Greek_alpha, 0x1F85,
    XK_Greek_iota, XK_dead_acute, XK_parenleft, XK_Greek_eta, 0x1F95,
    XK_Greek_iota, XK_dead_acute, XK_parenleft, XK_Greek_omega, 0x1FA5,
    XK_Greek_iota, XK_dead_acute, XK_parenright, XK_Greek_ALPHA, 0x1F8C,
    XK_Greek_iota, XK_dead_acute, XK_parenright, XK_Greek_ETA, 0x1F9C,
    XK_Greek_iota, XK_dead_acute, XK_parenright, XK_Greek_OMEGA, 0x1FAC,
    XK_Greek_iota, XK_dead_acute, XK_parenright, XK_Greek_alpha, 0x1F84,
    XK_Greek_iota, XK_dead_acute, XK_parenright, XK_Greek_eta, 0x1F94,
    XK_Greek_iota, XK_dead_acute, XK_parenright, XK_Greek_omega, 0x1FA4,
    XK_Greek_iota, XK_dead_acute, XK_dead_psili, XK_Greek_ALPHA, 0x1F8C,
    XK_Greek_iota, XK_dead_acute, XK_dead_psili, XK_Greek_ETA, 0x1F9C,
    XK_Greek_iota, XK_dead_acute, XK_dead_psili, XK_Greek_OMEGA, 0x1FAC,
    XK_Greek_iota, XK_dead_acute, XK_dead_psili, XK_Greek_alpha, 0x1F84,
    XK_Greek_iota, XK_dead_acute, XK_dead_psili, XK_Greek_eta, 0x1F94,
    XK_Greek_iota, XK_dead_acute, XK_dead_psili, XK_Greek_omega, 0x1FA4,
    XK_Greek_iota, XK_dead_acute, XK_dead_dasia, XK_Greek_ALPHA, 0x1F8D,
    XK_Greek_iota, XK_dead_acute, XK_dead_dasia, XK_Greek_ETA, 0x1F9D,
    XK_Greek_iota, XK_dead_acute, XK_dead_dasia, XK_Greek_OMEGA, 0x1FAD,
    XK_Greek_iota, XK_dead_acute, XK_dead_dasia, XK_Greek_alpha, 0x1F85,
    XK_Greek_iota, XK_dead_acute, XK_dead_dasia, XK_Greek_eta, 0x1F95,
    XK_Greek_iota, XK_dead_acute, XK_dead_dasia, XK_Greek_omega, 0x1FA5,
    XK_Greek_iota, XK_dead_tilde, XK_parenleft, XK_Greek_ALPHA, 0x1F8F,
    XK_Greek_iota, XK_dead_tilde, XK_parenleft, XK_Greek_ETA, 0x1F9F,
    XK_Greek_iota, XK_dead_tilde, XK_parenleft, XK_Greek_OMEGA, 0x1FAF,
    XK_Greek_iota, XK_dead_tilde, XK_parenleft, XK_Greek_alpha, 0x1F87,
    XK_Greek_iota, XK_dead_tilde, XK_parenleft, XK_Greek_eta, 0x1F97,
    XK_Greek_iota, XK_dead_tilde, XK_parenleft, XK_Greek_omega, 0x1FA7,
    XK_Greek_iota, XK_dead_tilde, XK_parenright, XK_Greek_ALPHA, 0x1F8E,
    XK_Greek_iota, XK_dead_tilde, XK_parenright, XK_Greek_ETA, 0x1F9E,
    XK_Greek_iota, XK_dead_tilde, XK_parenright, XK_Greek_OMEGA, 0x1FAE,
    XK_Greek_iota, XK_dead_tilde, XK_parenright, XK_Greek_alpha, 0x1F86,
    XK_Greek_iota, XK_dead_tilde, XK_parenright, XK_Greek_eta, 0x1F96,
    XK_Greek_iota, XK_dead_tilde, XK_parenright, XK_Greek_omega, 0x1FA6,
    XK_Greek_iota, XK_dead_tilde, XK_dead_psili, XK_Greek_ALPHA, 0x1F8E,
    XK_Greek_iota, XK_dead_tilde, XK_dead_psili, XK_Greek_ETA, 0x1F9E,
    XK_Greek_iota, XK_dead_tilde, XK_dead_psili, XK_Greek_OMEGA, 0x1FAE,
    XK_Greek_iota, XK_dead_tilde, XK_dead_psili, XK_Greek_alpha, 0x1F86,
    XK_Greek_iota, XK_dead_tilde, XK_dead_psili, XK_Greek_eta, 0x1F96,
    XK_Greek_iota, XK_dead_tilde, XK_dead_psili, XK_Greek_omega, 0x1FA6,
    XK_Greek_iota, XK_dead_tilde, XK_dead_dasia, XK_Greek_ALPHA, 0x1F8F,
    XK_Greek_iota, XK_dead_tilde, XK_dead_dasia, XK_Greek_ETA, 0x1F9F,
    XK_Greek_iota, XK_dead_tilde, XK_dead_dasia, XK_Greek_OMEGA, 0x1FAF,
    XK_Greek_iota, XK_dead_tilde, XK_dead_dasia, XK_Greek_alpha, 0x1F87,
    XK_Greek_iota, XK_dead_tilde, XK_dead_dasia, XK_Greek_eta, 0x1F97,
};

#endif


// kate: indent-mode cstyle; space-indent on; indent-width 0;
