/* ************************************************************************ */
/*                                                                          */
/*   This file is part of Frama-C.                                          */
/*                                                                          */
/*   Copyright (C) 2007-2022                                                */
/*     CEA (Commissariat à l'énergie atomique et aux énergies               */
/*          alternatives)                                                   */
/*                                                                          */
/*   you can redistribute it and/or modify it under the terms of the GNU    */
/*   Lesser General Public License as published by the Free Software        */
/*   Foundation, version 2.1.                                               */
/*                                                                          */
/*   It is distributed in the hope that it will be useful,                  */
/*   but WITHOUT ANY WARRANTY; without even the implied warranty of         */
/*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          */
/*   GNU Lesser General Public License for more details.                    */
/*                                                                          */
/*   See the GNU Lesser General Public License version 2.1                  */
/*   for more details (enclosed in the file licenses/LGPLv2.1).             */
/*                                                                          */
/* ************************************************************************ */

// --------------------------------------------------------------------------
// --- Electron renderer-process entry-point for Dome.
// --------------------------------------------------------------------------

/*
   Template of ./src/renderer/index.js
   Imported from $(DOME)/template/renderer.js

   You can modify this template and add your own code before or
   after rendering the main components.

   However, please note that React hot-reloading is fragile.
   Component that are not imported by <Application/> or <Preferences/>
   may suffer from well known limitations of hot-reloading and
   may lead to state losses or complete application reloads.
*/

// Enable live-editing in React:
import 'react-hot-loader/patch' ;
import React from 'react' ;
import {
  setApplicationWindow,
  setPreferencesWindow,
  isApplicationWindow,
  isPreferencesWindow,
} from 'dome' ;

// You can change the name of the main components,
// provided you define the makefile variable
// `DOME_CUSTOM_ENTRIES` to prevent files 'Application.js' and 'Preferences.js'
// from being generated by the template makefile.

import Application from './Application' ;
import Preferences from './Preferences' ;

// Define the application main components for each window:
setApplicationWindow(Application);
setPreferencesWindow(Preferences);

// Mark the main application reloadable and enable live updates:
module.hot && isApplicationWindow() &&
  module.hot.accept('./Application',() => setApplicationWindow(Application));
module.hot && isPreferencesWindow() &&
  module.hot.accept('./Preferences',() => setPreferencesWindow(Preferences));

// --------------------------------------------------------------------------
