#                                                         -*- Perl -*-
# Copyright (c) 1999, 2000  Motoyuki Kasahara
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2, or (at your option)
# any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#

#
# ʸ᤿ե뤿Υ饹
#
package FreePWING::Text;

require 5.005;
use English;
use FreePWING::BaseText;
use strict;
use integer;

use vars qw(@ISA
	    @EXPORT
	    @EXPORT_OK);

@ISA = qw(FreePWING::BaseText);

#
# :
#	new()
# ᥽åɤζʬ:
# 	public 饹᥽åɡ
# :
# 	֥Ȥ롣
# :
# 	֥ȤؤΥե󥹤֤
#
sub new {
    my $type = shift;
    return $type->SUPER::new();
}

#
# :
#	open(file_name, reference_file_name, tag_file_name)
#           file_name
#		ʸե̾
#           reference_file_name
#		Ⱦե̾
#           tag_file_name
#		ե̾
# ᥽åɤζʬ:
# 	public 󥹥󥹥᥽åɡ
# :
# 	񤭹Ѥʸե򳫤
# :
#	 1 ֤Ԥ 0 ֤
#
sub open {
    my $self = shift;
    my ($file_name, $reference_file_name, $tag_file_name) = @ARG;
    
    return $self->SUPER::open($file_name, $reference_file_name,
			      $tag_file_name);
}

#
# :
#	add_entry_start()
# ᥽åɤζʬ:
# 	protected 󥹥󥹥᥽åɡ
# :
# 	ʥȥγϤ򼨤浭һҤɲä롣
# :
#	 1 ֤Ԥ 0 ֤
#
sub add_entry_start {
    my $self = shift;

    return $self->write_data(pack('nn', 0x1f09, 0x0001));
}

1;

