/*===========================================================================*
 *                                                                           *
 *  gghead.h - Header for generated gsl.h                                    *
 *                                                                           *
 *  Copyright (c) 1996-2010 iMatix Corporation                               *
 *                                                                           *
 *  This program is free software; you can redistribute it and/or modify     *
 *  it under the terms of the GNU General Public License as published by     *
 *  the Free Software Foundation; either version 3 of the License, or (at    *
 *  your option) any later version.                                          *
 *                                                                           *
 *  This program is distributed in the hope that it will be useful, but      *
 *  WITHOUT ANY WARRANTY; without even the implied warranty of               *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU        *
 *  General Public License for more details.                                 *
 *                                                                           *
 *  For information on alternative licensing for OEMs, please contact        *
 *  iMatix Corporation.                                                      *
 *                                                                           *
 *===========================================================================*/
/*  ----------------------------------------------------------------<Prolog>-
    Synopsis:   This header file is GENERATED by the Boom installer.  DO NOT
                MODIFY THIS FILE.  If you change prelude.h, or any of the
                other GSL header files, re-run boomake to recreate this file.
 ------------------------------------------------------------------</Prolog>-*/
/*===========================================================================*
 *                                                                           *
 *  ggcomm.h - Common functions                                              *
 *                                                                           *
 *  Copyright (c) 1996-2010 iMatix Corporation                               *
 *                                                                           *
 *  This program is free software; you can redistribute it and/or modify     *
 *  it under the terms of the GNU General Public License as published by     *
 *  the Free Software Foundation; either version 3 of the License, or (at    *
 *  your option) any later version.                                          *
 *                                                                           *
 *  This program is distributed in the hope that it will be useful, but      *
 *  WITHOUT ANY WARRANTY; without even the implied warranty of               *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU        *
 *  General Public License for more details.                                 *
 *                                                                           *
 *  For information on alternative licensing for OEMs, please contact        *
 *  iMatix Corporation.                                                      *
 *                                                                           *
 *===========================================================================*/

#ifndef GGCOMM_INCLUDED                 /*  Allow multiple inclusions        */
#define GGCOMM_INCLUDED

/*- Macros ------------------------------------------------------------------*/

#define LONG_WIDTH 10
#define PATH       "PATH"

#define BLOCK_START_MARKER 1
#define BLOCK_END_MARKER   2
#define BLOCK_DONE_MARKER  3

#define copy_value(d,s)       copy_value_ (NULL, d, s)

#define string_result(r) ((r) ? string_value (& (r)-> value) : NULL)
#define number_result(r) ((r) ? number_value (& (r)-> value) : NULL)

/*- Type definitions --------------------------------------------------------*/

typedef struct _SCRIPT_NODE      SCRIPT_NODE;
typedef struct _CLASS_DESCRIPTOR CLASS_DESCRIPTOR;
typedef struct _RESULT_NODE      RESULT_NODE;


typedef enum { GG_COMMENT,
               GG_LINE,
               GG_TEXT,
               GG_SUBSTITUTE,
               GG_OPERATOR,
               GG_LITERAL,
               GG_NUMBER,
               GG_SYMBOL,
               GG_MEMBER,
               GG_ATTRIBUTE,
               GG_CALL,
               GG_OUTPUT,
               GG_APPEND,
               GG_CLOSE,
               GG_IF,
               GG_ELSIF,
               GG_ELSE,
               GG_END_IF,
               GG_FOR,
               GG_END_FOR,
               GG_SCOPE,
               GG_END_SCOPE,
               GG_NEW,
               GG_END_NEW,
               GG_DELETE,
               GG_MOVE,
               GG_COPY,
               GG_WHILE,
               GG_END_WHILE,
               GG_NEXT,
               GG_LAST,
               GG_MACRO,
               GG_END_MACRO,
               GG_FUNCTION,
               GG_END_FUNCTION,
               GG_RETURN,
               GG_GSL,
               GG_DIRECT,
               GG_XML,
               GG_TEMPLATE,
               GG_END_TEMPLATE,
               GG_ECHO,
               GG_ABORT,
               GG_DEFINE,
               GG_SAVE,
               GG_SORT,
               GG_UNDEFINED }
    SCRIPT_NODE_TYPE;


typedef enum { OP_UNDEFINED,
               OP_TIMES,
               OP_DIVIDE,
               OP_PLUS,
               OP_MINUS,
               OP_IIF,
               OP_DEFAULT,
               OP_EQUALS,
               OP_NOT_EQUALS,
               OP_GREATER_THAN,
               OP_LESS_THAN,
               OP_GREATER_EQUAL,
               OP_LESS_EQUAL,
               OP_SAFE_EQUALS,
               OP_SAFE_NOT_EQUALS,
               OP_SAFE_GREATER_THAN,
               OP_SAFE_LESS_THAN,
               OP_SAFE_GREATER_EQUAL,
               OP_SAFE_LESS_EQUAL,
               OP_NOT,
               OP_OR,
               OP_AND,
               OP_NEXT_ARG }
    OPERATOR;


typedef enum { TYPE_UNDEFINED,
               TYPE_STRING,
               TYPE_NUMBER,
               TYPE_BLOCK,
               TYPE_POINTER,
               TYPE_UNKNOWN }
    DATA_TYPE;

typedef struct {
    DATA_TYPE
        type;
    char
       *s;                              /*  String value                     */
    double
        n;                              /*  Numeric value                    */
    char
      **b;                              /*  Block value                      */
    CLASS_DESCRIPTOR
        *c;                             /*  Pointer value - class            */
    void
        *i;                             /*  Pointer value - item             */
} VALUE;

struct _SCRIPT_NODE {
    SCRIPT_NODE
        *parent;
    SCRIPT_NODE
        *scope,
        *name,
        *op1,
        *op2,
        *as,
        *to,
        *before,                        /*  Also 'where'                     */
        *after;                         /*  Also 'by'                        */
    VALUE          
        result;                         /*  Only used if result is constant  */
    int  
        width:16,                       /*  Width of script construct        */
        spaces:16,                      /*  Leading spaces in script         */
        brackets:16;
    OPERATOR
        operator:8;
    SCRIPT_NODE_TYPE
        type:8;
    int
        extend:1,
        constant:1,                     /*  Is the result constant?          */
        stacked:1,                      /*  Is scope to be 'stacked'?        */
        dynamic:1;                      /*  TRUE if job == 0.                */
};

typedef struct {
    CLASS_DESCRIPTOR
        *class;
    void
        *item;
} CLASS_ITEM;

typedef enum {
    PARM_VALUE,
    PARM_REFERENCE,
    PARM_SIMPLE_SCOPE,
    PARM_EXPRESSION
} PARM_TYPE;

typedef
    PARM_TYPE PARM_LIST [];

typedef int  PLUGIN_INITIALISE (CLASS_DESCRIPTOR **class,
                                void             **item,
                                THREAD            *gsl_thread);

typedef const char * ITEM_NAME_FUNCTION (void *item);
typedef VALUE *      GET_ATTR_FUNCTION (      void *item,
                                        const char *name,
                                              Bool ignorecase);
typedef int  PUT_ATTR_FUNCTION (      void  *item,
                                const char  *name,
                                      VALUE *value,
                                      Bool  ignorecase);
typedef int  NAVIGATE_FUNCTION (void              *olditem,
                                const       char  *name,
                                            Bool   ignorecase,
                                CLASS_DESCRIPTOR **class,
                                            void **item);
typedef int  PARENT_FUNCTION   (void              *olditem,
                                CLASS_DESCRIPTOR **class,
                                void             **item,
                                THREAD            *gsl_thread);
typedef int  CREATE_FUNCTION   (const       char  *name,
                                            void  *parent,
                                            void  *sibling,
                                CLASS_DESCRIPTOR **class,
                                            void **item);
typedef int  ITEM_FUNCTION     (void  *item);
typedef void * ATTACH_FUNCTION (            void *item,
                                CLASS_DESCRIPTOR *to_class,
                                const       char *name,
                                            void *parent,
                                            void *sibling);
typedef void  REMOVE_FUNCTION  (void *item, void *remove);
                           
typedef int EVAL_FUNCTION (int argc,
                           RESULT_NODE **argv,
                           void        *item,
                           RESULT_NODE *result,
                           THREAD *gsl_thread);

typedef int THREAD_FUNCTION (THREAD *gsl_thread);

typedef struct {
    char
       *name;
    int
        min_parmc,
        max_parmc,
        cnt_parmt;
    PARM_LIST
       *parmt;
    Bool
        immediate;
    EVAL_FUNCTION
       *evaluate;
} GSL_FUNCTION;

struct _CLASS_DESCRIPTOR {
    const char
        *name;
    ITEM_NAME_FUNCTION
        *item_name;
    GET_ATTR_FUNCTION
        *get_attr;
    PUT_ATTR_FUNCTION
        *put_attr;
    NAVIGATE_FUNCTION
        *first_child,
        *next_sibling;
    PARENT_FUNCTION
        *parent;
    CREATE_FUNCTION
        *create;
    ITEM_FUNCTION
        *destroy;
    ITEM_FUNCTION
        *link,
        *delete;
    ATTACH_FUNCTION
        *copy,
        *move;
    REMOVE_FUNCTION
        *remove;
    GSL_FUNCTION
        *methods;
    int
        method_cnt;
};

struct _RESULT_NODE {
    RESULT_NODE
        *next,                          /*  In stack or cache                */
        *parent,
        *scope,
        *name,
        *op1,
        *op2,
        *as,
        *to,
        *before,
        *after,
        *operand;                       /*  Result of evaluating operand     */
    SCRIPT_NODE
        *script_node;                   /*  Corresponding parse node         */
    RESULT_NODE
        *result_node;
    void
        *macro;
    GSL_FUNCTION
        *gsl_function;
    int
        argc;
    RESULT_NODE
      **argv;
    char
        *culprit;
    int
        indent,                         /*  Leading spaces after shuffling   */
        width,                          /*  Width of last line of result     */
        item_nbr;
    VALUE
        value;                          /*  Result                           */
    Bool
        constant;                       /*  Is result constant?              */
};

/*- Functions ---------------------------------------------------------------*/

Bool         gsl_file_read              (FILE *stream,
                                         char *string);
char *       name_the_symbol            (RESULT_NODE *node);
void         result_node_error          (const char *message,
                                         RESULT_NODE *node,
                                         char **error_text);
char        *extended_scope_string      (RESULT_NODE *scope);
void         init_value                 (VALUE  *value);
void         destroy_value              (VALUE  *value);
void         copy_value_                (MEMTRN *memtrn,
                                         VALUE  *dest,
                                         VALUE  *source);
void         assign_number              (VALUE  *dest,
                                         double n);
void         assign_string              (VALUE *dest,
                                         char  *s);
void         assign_pointer             (VALUE            *dest,
                                         CLASS_DESCRIPTOR *c,
                                         void             *i);
void         free_pointer               (CLASS_DESCRIPTOR *c,
                                         void *i);
RESULT_NODE *new_result_node            (void);
void         init_result                (RESULT_NODE *node);
void         destroy_result             (RESULT_NODE *node);
void         copy_result                (RESULT_NODE *dest,
                                         RESULT_NODE *source);

char        *string_value               (VALUE *value);
double       number_value               (VALUE *value);
int          parse_format               (char *format, size_t format_max,
                                         char *conversion,
                                         RESULT_NODE *node,
                                         char **error_text);
int          format_output              (char *format, 
                                         char conversion, 
                                         int width,
                                         RESULT_NODE *node);
int          pretty_print               (VALUE *result,
                                         RESULT_NODE *pretty,
                                         char *example,
                                         int  space,
                                         char **error_text);
size_t       strllen                    (const char *s);
char        *concatenate_results        (RESULT_NODE *r,
                                         int shuffle,
                                         Bool convert_indent,
                                         char **error_text);
void         destroy_caches             (void);

/*---------------------------------------------------------------------------*/

#endif
/*===========================================================================*
 *                                                                           *
 *  ggpars.h - Script parser functions                                       *
 *                                                                           *
 *  Copyright (c) 1996-2010 iMatix Corporation                               *
 *                                                                           *
 *  This program is free software; you can redistribute it and/or modify     *
 *  it under the terms of the GNU General Public License as published by     *
 *  the Free Software Foundation; either version 3 of the License, or (at    *
 *  your option) any later version.                                          *
 *                                                                           *
 *  This program is distributed in the hope that it will be useful, but      *
 *  WITHOUT ANY WARRANTY; without even the implied warranty of               *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU        *
 *  General Public License for more details.                                 *
 *                                                                           *
 *  For information on alternative licensing for OEMs, please contact        *
 *  iMatix Corporation.                                                      *
 *                                                                           *
 *===========================================================================*/

#ifndef GGPARS_INCLUDED                 /*  Allow multiple inclusions        */
#define GGPARS_INCLUDED

/*- Type definitions --------------------------------------------------------*/

typedef        void *              JOBID;

/*  Function type for function to read next line of script                   */

typedef Bool (SCRIPT_READ) (JOBID job, char *text);

/*- Globals that control parsing symbols ------------------------------------*/

extern char *g_escape;           /*  By default, '\\'                        */
extern char *g_substitute;       /*  By default, '$('                        */

/*- Macros ------------------------------------------------------------------*/

/*  Prototypes  */
void         gg_free             (SCRIPT_NODE *node);
XML_ITEM    *gg_xml              (SCRIPT_NODE *node);
char        *operator_text       (OPERATOR op);
char        *node_type_string    (SCRIPT_NODE_TYPE type);

void         init_script_node    (SCRIPT_NODE *node);

int          ggpars_init         (void);
int          gg_parse_template   (SCRIPT_READ *read,  JOBID job,
                                  QUEUE       *replyqueue);
int          gg_parse_gsl        (SCRIPT_READ *read,  JOBID job,
                                  QUEUE       *replyqueue);
int          gg_parse_expression (char        *expression,  JOBID job,
                                  QUEUE       *replyqueue);
int          ggpars_term         (void);

/*---------------------------------------------------------------------------*/

#endif
/*---------------------------------------------------------------------------
 *  ggparsm.h - prototypes for ggpars messages.
 *
 *  Generated from ggpars.xml by smtmesg.gsl using GSL.
 *  DO NOT MODIFY THIS FILE.
 *
 *  For documentation and updates see http://www.imatix.com.
 *---------------------------------------------------------------------------*/
#ifndef INCLUDE_GGPARSM
#define INCLUDE_GGPARSM

/*---------------------------------------------------------------------------
 *  Definitions and prototypes for ggpars - gslgen parser agent.
 *---------------------------------------------------------------------------*/

typedef struct {
    void *job;                          /*  job id                           */
} struct_ggpars_parse;

int
put_ggpars_parse (
          byte **_buffer,
    const void *job);                   /*  job id                           */

int
get_ggpars_parse (
    byte *_buffer,
    struct_ggpars_parse **params);

void
free_ggpars_parse (
    struct_ggpars_parse **params);

/*---------------------------------------------------------------------------
 *  Definitions and prototypes for template - parse template line.
 *---------------------------------------------------------------------------*/

extern char *GGPARS_TEMPLATE;

#define declare_ggpars_template(_event, _priority)                             \
    method_declare (agent, GGPARS_TEMPLATE, _event, _priority)

/*  Send event - template                                                    */

int 
lsend_ggpars_template (
    const QID  *_to,
    const QID  *_from,
          char *_accept,
          char *_reject,
          char *_expire,
          word _timeout,
    const void *job);               /*  job id                           */

#define send_ggpars_template(_to,                                              \
            job)                                                             \
       lsend_ggpars_template(_to,                                              \
            &thread-> queue-> qid,                                           \
            NULL, NULL, NULL, 0,                                             \
            job)

/*---------------------------------------------------------------------------
 *  Definitions and prototypes for gsl - parse gsl line.
 *---------------------------------------------------------------------------*/

extern char *GGPARS_GSL;

#define declare_ggpars_gsl(_event, _priority)                                  \
    method_declare (agent, GGPARS_GSL, _event, _priority)

/*  Send event - gsl                                                         */

int 
lsend_ggpars_gsl (
    const QID  *_to,
    const QID  *_from,
          char *_accept,
          char *_reject,
          char *_expire,
          word _timeout,
    const void *job);               /*  job id                           */

#define send_ggpars_gsl(_to,                                                   \
            job)                                                             \
       lsend_ggpars_gsl(_to,                                                   \
            &thread-> queue-> qid,                                           \
            NULL, NULL, NULL, 0,                                             \
            job)

/*---------------------------------------------------------------------------
 *  Definitions and prototypes for expression - parse expression.
 *---------------------------------------------------------------------------*/

extern char *GGPARS_EXPRESSION;

#define declare_ggpars_expression(_event, _priority)                           \
    method_declare (agent, GGPARS_EXPRESSION, _event, _priority)

/*  Send event - expression                                                  */

int 
lsend_ggpars_expression (
    const QID  *_to,
    const QID  *_from,
          char *_accept,
          char *_reject,
          char *_expire,
          word _timeout,
    const void *job);               /*  job id                           */

#define send_ggpars_expression(_to,                                            \
            job)                                                             \
       lsend_ggpars_expression(_to,                                            \
            &thread-> queue-> qid,                                           \
            NULL, NULL, NULL, 0,                                             \
            job)


typedef struct {
    void *job;                          /*  job id                           */
    void *parse_root;                   /*  parse tree root                  */
    void *parse_memtrn;                 /*  Memory transaction               */
    qbyte size;                         /*  Data size                        */
} struct_ggpars_ok;

int
put_ggpars_ok (
          byte **_buffer,
    const void *job,                    /*  job id                           */
    const void *parse_root,             /*  parse tree root                  */
    const void *parse_memtrn,           /*  Memory transaction               */
    const qbyte size);                  /*  Data size                        */

int
get_ggpars_ok (
    byte *_buffer,
    struct_ggpars_ok **params);

void
free_ggpars_ok (
    struct_ggpars_ok **params);

/*---------------------------------------------------------------------------
 *  Definitions and prototypes for ok - ok reply.
 *---------------------------------------------------------------------------*/

extern char *GGPARS_OK;

#define declare_ggpars_ok(_event, _priority)                                   \
    method_declare (agent, GGPARS_OK, _event, _priority)

/*  Send event - ok                                                          */

int 
lsend_ggpars_ok (
    const QID  *_to,
    const QID  *_from,
          char *_accept,
          char *_reject,
          char *_expire,
          word _timeout,
    const void *job,                /*  job id                           */
    const void *parse_root,         /*  parse tree root                  */
    const void *parse_memtrn,       /*  Memory transaction               */
    const qbyte size);              /*  Data size                        */

#define send_ggpars_ok(_to,                                                    \
            job,                                                             \
            parse_root,                                                      \
            parse_memtrn,                                                    \
            size)                                                            \
       lsend_ggpars_ok(_to,                                                    \
            &thread-> queue-> qid,                                           \
            NULL, NULL, NULL, 0,                                             \
            job,                                                             \
            parse_root,                                                      \
            parse_memtrn,                                                    \
            size)


typedef struct {
    void *job;                          /*  job id                           */
} struct_ggpars_eof;

int
put_ggpars_eof (
          byte **_buffer,
    const void *job);                   /*  job id                           */

int
get_ggpars_eof (
    byte *_buffer,
    struct_ggpars_eof **params);

void
free_ggpars_eof (
    struct_ggpars_eof **params);

/*---------------------------------------------------------------------------
 *  Definitions and prototypes for eof - eof reply.
 *---------------------------------------------------------------------------*/

extern char *GGPARS_EOF;

#define declare_ggpars_eof(_event, _priority)                                  \
    method_declare (agent, GGPARS_EOF, _event, _priority)

/*  Send event - eof                                                         */

int 
lsend_ggpars_eof (
    const QID  *_to,
    const QID  *_from,
          char *_accept,
          char *_reject,
          char *_expire,
          word _timeout,
    const void *job);               /*  job id                           */

#define send_ggpars_eof(_to,                                                   \
            job)                                                             \
       lsend_ggpars_eof(_to,                                                   \
            &thread-> queue-> qid,                                           \
            NULL, NULL, NULL, 0,                                             \
            job)


typedef struct {
    void *job;                          /*  job id                           */
    char *error_text;                   /*  error message text               */
} struct_ggpars_error;

int
put_ggpars_error (
          byte **_buffer,
    const void *job,                    /*  job id                           */
    const char *error_text);            /*  error message text               */

int
get_ggpars_error (
    byte *_buffer,
    struct_ggpars_error **params);

void
free_ggpars_error (
    struct_ggpars_error **params);

/*---------------------------------------------------------------------------
 *  Definitions and prototypes for error - error reply.
 *---------------------------------------------------------------------------*/

extern char *GGPARS_ERROR;

#define declare_ggpars_error(_event, _priority)                                \
    method_declare (agent, GGPARS_ERROR, _event, _priority)

/*  Send event - error                                                       */

int 
lsend_ggpars_error (
    const QID  *_to,
    const QID  *_from,
          char *_accept,
          char *_reject,
          char *_expire,
          word _timeout,
    const void *job,                /*  job id                           */
    const char *error_text);        /*  error message text               */

#define send_ggpars_error(_to,                                                 \
            job,                                                             \
            error_text)                                                      \
       lsend_ggpars_error(_to,                                                 \
            &thread-> queue-> qid,                                           \
            NULL, NULL, NULL, 0,                                             \
            job,                                                             \
            error_text)



#endif                                  /*  Included                         */
/*---------------------------------------------------------------------------
 *  ggscrp.h - GSL/script package header
 *
 *  Generated from ggscrp by ggobjt.gsl using GSL/4.
 *  DO NOT MODIFY THIS FILE.
 *
 *  For documentation and updates see http://www.imatix.com.
 *---------------------------------------------------------------------------*/

#ifndef GGSCRP_INCLUDED
#define GGSCRP_INCLUDED
/*- Public definitions ------------------------------------------------------*/

typedef struct _SCRIPT_HANDLE {
    struct _SCRIPT_HANDLE
        *next,
        *prev;
    int
        links,
        waiting;                        /*  Use on incomplete file           */
    char
        *path,
        *name;
    Bool
        keep;
    long
        size;
    time_t
        last_closed,
        timestamp;
    LIST
        line_head;
} SCRIPT_HANDLE;

typedef struct _SCRIPT_LINE {
    struct _SCRIPT_LINE
        *next,
        *prev,
        *loop_start,                     /*  Start of loop block             */
        *block_end;                      /*  End of control block            */
    int
        links;
    SCRIPT_HANDLE
        *parent;
    long
        size;
    SCRIPT_NODE
        *node;                           /*  GSL parse tree for GSL lines    */
    char
        *text;                           /*  Text for non-GSL lines          */
    word
        line;
    Bool
        template:1;
} SCRIPT_LINE;

typedef struct {                        /*  Store reference for macros       */
    int
        links;
    SYMTAB
        *symtab;
} MACRO_TABLE_ITEM;

typedef struct {                        /*  Store reference for macros       */
    char
        *name;
    SCRIPT_LINE
        *line;
    SYMBOL
        *symbol;
    SYMTAB
        *symtab;
} MACRO_ITEM;

/**************************** Global variables *******************************/

extern long
    max_size;                           /*  Threshold before freeing space   */

/************************** Function prototypes ******************************/

void script_load_file   (char *filename, Bool template, Bool debug,
                         RESULT_NODE *result, QUEUE *replyq);

void script_load_string (char *name, char *string, Bool template, Bool debug,
                         RESULT_NODE *result, QUEUE *replyq);

void script_handle_link    (SCRIPT_HANDLE *script_handle);
void script_handle_destroy (SCRIPT_HANDLE *script_handle);

MACRO_TABLE_ITEM *macro_table_create  (void);
void              macro_table_link    (MACRO_TABLE_ITEM *macro_table);
void              macro_table_destroy (MACRO_TABLE_ITEM *macro_table);

MACRO_ITEM *macro_create (MACRO_TABLE_ITEM *macro_table, const char *name, SCRIPT_LINE *start);
MACRO_ITEM *macro_lookup (MACRO_TABLE_ITEM *macro_table, const char *name);
void macro_destroy       (MACRO_ITEM *macro);
MACRO_ITEM *macro_value  (LIST *scope_stack, RESULT_NODE *symbol);


/*- Global variables --------------------------------------------------------*/

extern CLASS_DESCRIPTOR
    script_line_class;

/*- Function prototypes -----------------------------------------------------*/

int register_script_line_classes (void);

int shutdown_script_line_classes (void);

#endif
/*===========================================================================*
 *                                                                           *
 *  ggscop.h - Scope functions                                               *
 *                                                                           *
 *  Copyright (c) 1996-2010 iMatix Corporation                               *
 *                                                                           *
 *  This program is free software; you can redistribute it and/or modify     *
 *  it under the terms of the GNU General Public License as published by     *
 *  the Free Software Foundation; either version 3 of the License, or (at    *
 *  your option) any later version.                                          *
 *                                                                           *
 *  This program is distributed in the hope that it will be useful, but      *
 *  WITHOUT ANY WARRANTY; without even the implied warranty of               *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU        *
 *  General Public License for more details.                                 *
 *                                                                           *
 *  For information on alternative licensing for OEMs, please contact        *
 *  iMatix Corporation.                                                      *
 *                                                                           *
 *===========================================================================*/

#ifndef GGSCOP_INCLUDED                 /*  Allow multiple inclusions        */
#define GGSCOP_INCLUDED

/*- Type definitions --------------------------------------------------------*/

typedef struct _SCOPE_ITEM {
    struct _SCOPE_ITEM
        *next,
        *prev;
    CLASS_DESCRIPTOR
        *class;
    void
        *item;                          /*  Data for this item               */
    long
        item_num;                       /*  Item number                      */
    VALUE
        sort_key;
} SCOPE_ITEM;

typedef struct _SCOPE_BLOCK {
    struct _SCOPE_BLOCK
        *next,
        *prev;
    SCRIPT_NODE_TYPE
        scope_type;
    char
        *name;                          /*  Scope name                       */
    LIST
        item_list;                      /*  List of items to iterate through */
    SCOPE_ITEM
        *scope_item;                    /*  Current item in for list         */
    CLASS_DESCRIPTOR
        *class;
    void
        *item;                          /*  Data for this item               */
    long
        total,                          /*  Total number of items in loop    */
        index;                          /*  Loop index                       */
    Bool
        stacked;                        /*  Is scope 'stacked'?              */
    MACRO_TABLE_ITEM
        *macros;                        /*  Spaces for macros in this block  */
} SCOPE_BLOCK;

/*- Functions ---------------------------------------------------------------*/

SCOPE_BLOCK *lookup_simple_scope        (LIST  *scope_stack,
                                         VALUE *scope_value,
                                         Bool  ignorecase,
                                         CLASS_DESCRIPTOR **class,
                                         void **item,
                                         char  **error_text);
int          symbol_item                (LIST *scope_stack,
                                         RESULT_NODE *symbol,
                                         Bool ignorecase,
                                         CLASS_DESCRIPTOR **class,
                                         void **item,
                                         char **error_text);
VALUE       *symbol_value               (LIST *scope_stack,
                                         RESULT_NODE *symbol,
                                         Bool ignorecase,
                                         char **error_text);
Bool         store_symbol_definition    (LIST *scope_stack,
                                         Bool  ignorecase,
                                         RESULT_NODE *symbol,
                                         VALUE *value,
                                         char **error_text);

SCOPE_BLOCK *create_scope_block         (LIST *scope_stack,
                                         SCRIPT_NODE_TYPE scope_type,
                                         const char *alias,
                                         CLASS_DESCRIPTOR *class);
void         destroy_scope_block        (SCOPE_BLOCK *scope_block);
SCOPE_BLOCK *first_scope_block          (LIST *scope_stack);
SCOPE_BLOCK *last_scope_block           (LIST *scope_stack);

SCOPE_ITEM  *create_scope_item          (SCOPE_BLOCK *scope_block,
                                         CLASS_DESCRIPTOR *class,
                                         void *item,
                                         long item_num);
void         destroy_scope_item         (SCOPE_ITEM *scope_item);

Bool         first_scope_item           (SCOPE_BLOCK *scope_block);
Bool         next_scope_item            (SCOPE_BLOCK *scope_block);

void         copy_scope_stack           (LIST *to,
                                         LIST *from);

#endif
/*===========================================================================*
 *                                                                           *
 *  ggobjt.h - Object functions                                              *
 *                                                                           *
 *  Copyright (c) 1996-2010 iMatix Corporation                               *
 *                                                                           *
 *  This program is free software; you can redistribute it and/or modify     *
 *  it under the terms of the GNU General Public License as published by     *
 *  the Free Software Foundation; either version 3 of the License, or (at    *
 *  your option) any later version.                                          *
 *                                                                           *
 *  This program is distributed in the hope that it will be useful, but      *
 *  WITHOUT ANY WARRANTY; without even the implied warranty of               *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU        *
 *  General Public License for more details.                                 *
 *                                                                           *
 *  For information on alternative licensing for OEMs, please contact        *
 *  iMatix Corporation.                                                      *
 *                                                                           *
 *===========================================================================*/

#ifndef GGOBJT_INCLUDED                 /*  Allow multiple inclusions        */
#define GGOBJT_INCLUDED

/*- Type definitions --------------------------------------------------------*/


/*- Global variables --------------------------------------------------------*/

extern char
    object_error [LINE_MAX + 1];

/*- Functions ---------------------------------------------------------------*/

void          initialise_objects     (void);
void          destroy_objects        (void);
int           object_register        (PLUGIN_INITIALISE *init,
                                      function          shutdown);
int           initialise_classes     (THREAD *thread);
GSL_FUNCTION *locate_method          (CLASS_DESCRIPTOR *class,
                                      const char *name);
int           build_method_arguments (SCRIPT_NODE *fn_node,
                                      RESULT_NODE ***arg);
Bool          arguments_are_defined  (int argc,
                                      RESULT_NODE **argv,
                                      RESULT_NODE *result);
void         *get_class_item         (THREAD *gsl_thread,
                                      const char *class);

/*---------------------------------------------------------------------------*/

#endif
/*---------------------------------------------------------------------------
 *  ggsymb.h - GSL/symb package header
 *
 *  Generated from ggsymb by ggobjt.gsl using GSL/4.
 *  DO NOT MODIFY THIS FILE.
 *
 *  For documentation and updates see http://www.imatix.com.
 *---------------------------------------------------------------------------*/

#ifndef GGSYMB_INCLUDED
#define GGSYMB_INCLUDED
/*- Public definitions ------------------------------------------------------*/

typedef struct {
    int
        links;
    char
        *name;
    SYMTAB
        *symtab;
    Bool
        done,
        loop;                           /*  To check for self-references     */
} SYMTAB_ITEM;


/*- Global variables --------------------------------------------------------*/

extern CLASS_DESCRIPTOR
    symb_class;

/*- Function prototypes -----------------------------------------------------*/

int register_symb_classes (void);


#endif
/*---------------------------------------------------------------------------
 *  gggsl.h - GSL/gsl control package header
 *
 *  Generated from gggsl by ggobjt.gsl using GSL/4.
 *  DO NOT MODIFY THIS FILE.
 *
 *  For documentation and updates see http://www.imatix.com.
 *---------------------------------------------------------------------------*/

#ifndef GGGSL_INCLUDED
#define GGGSL_INCLUDED
/*- Public definitions ------------------------------------------------------*/

typedef struct {
    int
        links;
    Bool
        ignorecase,                    /*  = use case for pretty-print       */
        cobol,                         /*  COBOL = 6 char line numbers       */
        template;                      /*  Template mode?                    */
    SCRIPT_LINE
        *line;                         /*  script_line item for current line */
    int
        shuffle;                       /*  Min whitespace size for shuffle   */
    char
        *terminator;                   /*  Line terminator string            */
    char
        *escape;                       /*  Escape symbol, if not '\'         */
    char
        *substitute;                   /*  Substitute symbol, if not '$'     */
    int
        argc;                          /*  Command line arguments            */
    char
        **argv;
    SYMTAB_ITEM
        *switches;                     /*  Original command-line switches    */
    char
        *output_file,                  /*  Output file name                  */
        *input_file;                   /*  Input file name                   */
    long
        output_line;                   /*  Line number in output file.       */
} GSL_CONTROL;

extern char
    *me,                               /*  Module name                       */
    *version;                          /*  GSL version                       */


/*- Global variables --------------------------------------------------------*/

extern CLASS_DESCRIPTOR
    gsl_class;

/*- Function prototypes -----------------------------------------------------*/

int register_gsl_classes (void);


#endif
/*===========================================================================*
 *                                                                           *
 *  ggcode.h - Code generator functions                                      *
 *                                                                           *
 *  Copyright (c) 1996-2010 iMatix Corporation                               *
 *                                                                           *
 *  This program is free software; you can redistribute it and/or modify     *
 *  it under the terms of the GNU General Public License as published by     *
 *  the Free Software Foundation; either version 3 of the License, or (at    *
 *  your option) any later version.                                          *
 *                                                                           *
 *  This program is distributed in the hope that it will be useful, but      *
 *  WITHOUT ANY WARRANTY; without even the implied warranty of               *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU        *
 *  General Public License for more details.                                 *
 *                                                                           *
 *  For information on alternative licensing for OEMs, please contact        *
 *  iMatix Corporation.                                                      *
 *                                                                           *
 *===========================================================================*/

#ifndef GGCODE_INCLUDED                /*  Allow multiple inclusions         */
#define GGCODE_INCLUDED

/*---------------------------------------------------------------------------*/

typedef void (OUTPUT_FCT) (JOBID, const char *);
typedef void (HANDLER_FCT) (void);

typedef struct                          /*  Thread context block:            */
{
    THREAD
        *thread;
    MEMTRN
        *scratch_memtrn;
    JOBID
        job;
    GSL_CONTROL
        *gsl;                           /*  GSL internal data                */
    SYMTAB_ITEM
        *classes;                       /*  Table of predefined classes      */
    CLASS_ITEM
        *initial;                       /*  Array of initial objects         */
    int
        initial_cnt;                    /*  Number of initial objects        */
    QUEUE
        *replyq;
    int
        execute_level;
    char
        *script_name,
        *script_text;
    SCRIPT_HANDLE
        *script;                        /*  Careful - can be dangling        */
    FILE
        *output;
    SCRIPT_NODE
        *script_root,
        *script_node,
        *evaluate_node,
        *operand_node,
        *fake_for_node;
    RESULT_NODE
       **result_ptr,
        *result_root,
        *result_node,
       *output_buffer;
    RESULT_NODE
        call_result;
    Bool
        stdout_echo,                   /*  Copy to stdout                   */
        execute_full,
        stepping,
        error_occurred;
    LIST
        script_stack,
        scope_stack;
    RESULT_NODE
        *node_stack;
    OUTPUT_FCT
        *output_fct;                    /*  Redirector function              */
    DATA_TYPE
        sort_type;
    void
        *item;
} GGCODE_TCB;


/*- Function prototypes -----------------------------------------------------*/

int     gsl_init         (long size);

THREAD *gsl_execute      (QUEUE    *replyqueue,
                          JOBID     job,
                          SYMTAB   *switches,
                          int       count,
                          /* CLASS_ITEM *item */ ...);
THREAD *gsl_start        (QUEUE    *replyqueue,
                          JOBID     job,
                          SYMTAB   *switches,
                          int       count,
                          /* CLASS_ITEM *item */ ...);
THREAD *gsl_copy         (THREAD   *old_thread,
                          QUEUE    *replyqueue,
                          JOBID     job);
void    gsl_continue     (THREAD   *gsl_thread,
                          Bool      terminate,
                          QUEUE    *replyqueue);
void    gsl_next         (THREAD   *gsl_thread,
                          QUEUE    *replyqueue);
void    gsl_command      (THREAD   *gsl_thread,
                          char     *command,
                          Bool      terminate,
                          QUEUE    *replyqueue);
int     gsl_function     (THREAD   *gsl_thread,
                          QUEUE    *replyqueue,
                          const char *function,
                          int       parm_count,
                          VALUE    *parm_value[]);
int     gsl_evaluate     (THREAD      *gsl_thread,
                          char        *expression,
                          Bool        terminate,
                          RESULT_NODE **result,
                          QUEUE       *replyqueue);
THREAD *gsl_spawn        (THREAD   *gsl_thread,
                          QUEUE    *replyqueue,
                          SCRIPT_HANDLE *script_handle);
void    gsl_finish       (THREAD   *gsl_thread);

char   *gsl_cur_script   (THREAD *gsl_thread);
int     gsl_cur_line     (THREAD *gsl_thread);
char   *gsl_cur_text     (THREAD *gsl_thread);

int  gsl_term         (void);

void gg_send_output   (THREAD *gsl_thread, OUTPUT_FCT *output_fct, Bool echo);
void gg_set_handler   (HANDLER_FCT *handler_fct, int event);

/*  These are the events that we can provide handlers for                    */

typedef enum {
    EVENT_ABORT
} GG_EVENT;


/*---------------------------------------------------------------------------*/

#endif
/*---------------------------------------------------------------------------
 *  ggcodem.h - prototypes for GGCODE messages.
 *
 *  Generated from ggcode.xml by smtmesg.gsl using GSL.
 *  DO NOT MODIFY THIS FILE.
 *
 *  For documentation and updates see http://www.imatix.com.
 *---------------------------------------------------------------------------*/
#ifndef INCLUDE_GGCODEM
#define INCLUDE_GGCODEM

/*---------------------------------------------------------------------------
 *  Definitions and prototypes for ggcode - GSLGen GGCODE agent.
 *---------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------
 *  Definitions and prototypes for execute - Execute script.
 *---------------------------------------------------------------------------*/

extern char *GGCODE_EXECUTE;

#define declare_ggcode_execute(_event, _priority)                              \
    method_declare (agent, GGCODE_EXECUTE, _event, _priority)

/*  Send event - execute                                                     */

#define lsend_ggcode_execute(_to, _from,                                       \
    _accept, _reject, _expire, _timeout)                                     \
        event_send (_to,                                                     \
                    _from,                                                   \
                    GGCODE_EXECUTE,                                            \
                    NULL, 0,                                                 \
                    _accept, _reject, _expire, _timeout)
#define send_ggcode_execute(_to)                                               \
        event_send (_to,                                                     \
                    &thread-> queue-> qid,                                   \
                    GGCODE_EXECUTE,                                            \
                    NULL, 0,                                                 \
                    NULL, NULL, NULL, 0)


/*---------------------------------------------------------------------------
 *  Definitions and prototypes for start - Start thread.
 *---------------------------------------------------------------------------*/

extern char *GGCODE_START;

#define declare_ggcode_start(_event, _priority)                                \
    method_declare (agent, GGCODE_START, _event, _priority)

/*  Send event - start                                                       */

#define lsend_ggcode_start(_to, _from,                                         \
    _accept, _reject, _expire, _timeout)                                     \
        event_send (_to,                                                     \
                    _from,                                                   \
                    GGCODE_START,                                              \
                    NULL, 0,                                                 \
                    _accept, _reject, _expire, _timeout)
#define send_ggcode_start(_to)                                                 \
        event_send (_to,                                                     \
                    &thread-> queue-> qid,                                   \
                    GGCODE_START,                                              \
                    NULL, 0,                                                 \
                    NULL, NULL, NULL, 0)


/*---------------------------------------------------------------------------
 *  Definitions and prototypes for spawn - Spawn thread.
 *---------------------------------------------------------------------------*/

extern char *GGCODE_SPAWN;

#define declare_ggcode_spawn(_event, _priority)                                \
    method_declare (agent, GGCODE_SPAWN, _event, _priority)

/*  Send event - spawn                                                       */

#define lsend_ggcode_spawn(_to, _from,                                         \
    _accept, _reject, _expire, _timeout)                                     \
        event_send (_to,                                                     \
                    _from,                                                   \
                    GGCODE_SPAWN,                                              \
                    NULL, 0,                                                 \
                    _accept, _reject, _expire, _timeout)
#define send_ggcode_spawn(_to)                                                 \
        event_send (_to,                                                     \
                    &thread-> queue-> qid,                                   \
                    GGCODE_SPAWN,                                              \
                    NULL, 0,                                                 \
                    NULL, NULL, NULL, 0)


/*---------------------------------------------------------------------------
 *  Definitions and prototypes for continue - Continue thread.
 *---------------------------------------------------------------------------*/

extern char *GGCODE_CONTINUE;

#define declare_ggcode_continue(_event, _priority)                             \
    method_declare (agent, GGCODE_CONTINUE, _event, _priority)

/*  Send event - continue                                                    */

#define lsend_ggcode_continue(_to, _from,                                      \
    _accept, _reject, _expire, _timeout)                                     \
        event_send (_to,                                                     \
                    _from,                                                   \
                    GGCODE_CONTINUE,                                           \
                    NULL, 0,                                                 \
                    _accept, _reject, _expire, _timeout)
#define send_ggcode_continue(_to)                                              \
        event_send (_to,                                                     \
                    &thread-> queue-> qid,                                   \
                    GGCODE_CONTINUE,                                           \
                    NULL, 0,                                                 \
                    NULL, NULL, NULL, 0)


/*---------------------------------------------------------------------------
 *  Definitions and prototypes for next - Execute next line.
 *---------------------------------------------------------------------------*/

extern char *GGCODE_NEXT;

#define declare_ggcode_next(_event, _priority)                                 \
    method_declare (agent, GGCODE_NEXT, _event, _priority)

/*  Send event - next                                                        */

#define lsend_ggcode_next(_to, _from,                                          \
    _accept, _reject, _expire, _timeout)                                     \
        event_send (_to,                                                     \
                    _from,                                                   \
                    GGCODE_NEXT,                                               \
                    NULL, 0,                                                 \
                    _accept, _reject, _expire, _timeout)
#define send_ggcode_next(_to)                                                  \
        event_send (_to,                                                     \
                    &thread-> queue-> qid,                                   \
                    GGCODE_NEXT,                                               \
                    NULL, 0,                                                 \
                    NULL, NULL, NULL, 0)


/*---------------------------------------------------------------------------
 *  Definitions and prototypes for step - Step next line.
 *---------------------------------------------------------------------------*/

extern char *GGCODE_STEP;

#define declare_ggcode_step(_event, _priority)                                 \
    method_declare (agent, GGCODE_STEP, _event, _priority)

/*  Send event - step                                                        */

#define lsend_ggcode_step(_to, _from,                                          \
    _accept, _reject, _expire, _timeout)                                     \
        event_send (_to,                                                     \
                    _from,                                                   \
                    GGCODE_STEP,                                               \
                    NULL, 0,                                                 \
                    _accept, _reject, _expire, _timeout)
#define send_ggcode_step(_to)                                                  \
        event_send (_to,                                                     \
                    &thread-> queue-> qid,                                   \
                    GGCODE_STEP,                                               \
                    NULL, 0,                                                 \
                    NULL, NULL, NULL, 0)


/*---------------------------------------------------------------------------
 *  Definitions and prototypes for finish - Finish thread.
 *---------------------------------------------------------------------------*/

extern char *GGCODE_FINISH;

#define declare_ggcode_finish(_event, _priority)                               \
    method_declare (agent, GGCODE_FINISH, _event, _priority)

/*  Send event - finish                                                      */

#define lsend_ggcode_finish(_to, _from,                                        \
    _accept, _reject, _expire, _timeout)                                     \
        event_send (_to,                                                     \
                    _from,                                                   \
                    GGCODE_FINISH,                                             \
                    NULL, 0,                                                 \
                    _accept, _reject, _expire, _timeout)
#define send_ggcode_finish(_to)                                                \
        event_send (_to,                                                     \
                    &thread-> queue-> qid,                                   \
                    GGCODE_FINISH,                                             \
                    NULL, 0,                                                 \
                    NULL, NULL, NULL, 0)


typedef struct {
    char *command;                      /*  GSL command line                 */
} struct_ggcode_gsl;

int
put_ggcode_gsl (
          byte **_buffer,
    const char *command);               /*  GSL command line                 */

int
get_ggcode_gsl (
    byte *_buffer,
    struct_ggcode_gsl **params);

void
free_ggcode_gsl (
    struct_ggcode_gsl **params);

/*---------------------------------------------------------------------------
 *  Definitions and prototypes for gsl - Execute command.
 *---------------------------------------------------------------------------*/

extern char *GGCODE_GSL;

#define declare_ggcode_gsl(_event, _priority)                                  \
    method_declare (agent, GGCODE_GSL, _event, _priority)

/*  Send event - gsl                                                         */

int 
lsend_ggcode_gsl (
    const QID  *_to,
    const QID  *_from,
          char *_accept,
          char *_reject,
          char *_expire,
          word _timeout,
    const char *command);           /*  GSL command line                 */

#define send_ggcode_gsl(_to,                                                   \
            command)                                                         \
       lsend_ggcode_gsl(_to,                                                   \
            &thread-> queue-> qid,                                           \
            NULL, NULL, NULL, 0,                                             \
            command)


typedef struct {
    char *expression;                   /*  GSL command line                 */
} struct_ggcode_evaluate;

int
put_ggcode_evaluate (
          byte **_buffer,
    const char *expression);            /*  GSL command line                 */

int
get_ggcode_evaluate (
    byte *_buffer,
    struct_ggcode_evaluate **params);

void
free_ggcode_evaluate (
    struct_ggcode_evaluate **params);

/*---------------------------------------------------------------------------
 *  Definitions and prototypes for evaluate - Execute command.
 *---------------------------------------------------------------------------*/

extern char *GGCODE_EVALUATE;

#define declare_ggcode_evaluate(_event, _priority)                             \
    method_declare (agent, GGCODE_EVALUATE, _event, _priority)

/*  Send event - evaluate                                                    */

int 
lsend_ggcode_evaluate (
    const QID  *_to,
    const QID  *_from,
          char *_accept,
          char *_reject,
          char *_expire,
          word _timeout,
    const char *expression);        /*  GSL command line                 */

#define send_ggcode_evaluate(_to,                                              \
            expression)                                                      \
       lsend_ggcode_evaluate(_to,                                              \
            &thread-> queue-> qid,                                           \
            NULL, NULL, NULL, 0,                                             \
            expression)


/*---------------------------------------------------------------------------
 *  Definitions and prototypes for call - Call GSL function.
 *---------------------------------------------------------------------------*/

extern char *GGCODE_CALL;

#define declare_ggcode_call(_event, _priority)                                 \
    method_declare (agent, GGCODE_CALL, _event, _priority)

/*  Send event - call                                                        */

#define lsend_ggcode_call(_to, _from,                                          \
    _accept, _reject, _expire, _timeout)                                     \
        event_send (_to,                                                     \
                    _from,                                                   \
                    GGCODE_CALL,                                               \
                    NULL, 0,                                                 \
                    _accept, _reject, _expire, _timeout)
#define send_ggcode_call(_to)                                                  \
        event_send (_to,                                                     \
                    &thread-> queue-> qid,                                   \
                    GGCODE_CALL,                                               \
                    NULL, 0,                                                 \
                    NULL, NULL, NULL, 0)


typedef struct {
    void *job;                          /*  Job id                           */
} struct_ggcode_job;

int
put_ggcode_job (
          byte **_buffer,
    const void *job);                   /*  Job id                           */

int
get_ggcode_job (
    byte *_buffer,
    struct_ggcode_job **params);

void
free_ggcode_job (
    struct_ggcode_job **params);

/*---------------------------------------------------------------------------
 *  Definitions and prototypes for ok - OK reply.
 *---------------------------------------------------------------------------*/

extern char *GGCODE_OK;

#define declare_ggcode_ok(_event, _priority)                                   \
    method_declare (agent, GGCODE_OK, _event, _priority)

/*  Send event - ok                                                          */

int 
lsend_ggcode_ok (
    const QID  *_to,
    const QID  *_from,
          char *_accept,
          char *_reject,
          char *_expire,
          word _timeout,
    const void *job);               /*  Job id                           */

#define send_ggcode_ok(_to,                                                    \
            job)                                                             \
       lsend_ggcode_ok(_to,                                                    \
            &thread-> queue-> qid,                                           \
            NULL, NULL, NULL, 0,                                             \
            job)


typedef struct {
    void *job;                          /*  Job id                           */
    char *error_name;                   /*  Error file name                  */
    qbyte error_line;                   /*  Error line                       */
    char *error_text;                   /*  Error message text               */
} struct_ggcode_error_reply;

int
put_ggcode_error_reply (
          byte **_buffer,
    const void *job,                    /*  Job id                           */
    const char *error_name,             /*  Error file name                  */
    const qbyte error_line,             /*  Error line                       */
    const char *error_text);            /*  Error message text               */

int
get_ggcode_error_reply (
    byte *_buffer,
    struct_ggcode_error_reply **params);

void
free_ggcode_error_reply (
    struct_ggcode_error_reply **params);

/*---------------------------------------------------------------------------
 *  Definitions and prototypes for message - Error reply.
 *---------------------------------------------------------------------------*/

extern char *GGCODE_MESSAGE;

#define declare_ggcode_message(_event, _priority)                              \
    method_declare (agent, GGCODE_MESSAGE, _event, _priority)

/*  Send event - message                                                     */

int 
lsend_ggcode_message (
    const QID  *_to,
    const QID  *_from,
          char *_accept,
          char *_reject,
          char *_expire,
          word _timeout,
    const void *job,                /*  Job id                           */
    const char *error_name,         /*  Error file name                  */
    const qbyte error_line,         /*  Error line                       */
    const char *error_text);        /*  Error message text               */

#define send_ggcode_message(_to,                                               \
            job,                                                             \
            error_name,                                                      \
            error_line,                                                      \
            error_text)                                                      \
       lsend_ggcode_message(_to,                                               \
            &thread-> queue-> qid,                                           \
            NULL, NULL, NULL, 0,                                             \
            job,                                                             \
            error_name,                                                      \
            error_line,                                                      \
            error_text)

/*---------------------------------------------------------------------------
 *  Definitions and prototypes for error - Error reply.
 *---------------------------------------------------------------------------*/

extern char *GGCODE_ERROR;

#define declare_ggcode_error(_event, _priority)                                \
    method_declare (agent, GGCODE_ERROR, _event, _priority)

/*  Send event - error                                                       */

int 
lsend_ggcode_error (
    const QID  *_to,
    const QID  *_from,
          char *_accept,
          char *_reject,
          char *_expire,
          word _timeout,
    const void *job,                /*  Job id                           */
    const char *error_name,         /*  Error file name                  */
    const qbyte error_line,         /*  Error line                       */
    const char *error_text);        /*  Error message text               */

#define send_ggcode_error(_to,                                                 \
            job,                                                             \
            error_name,                                                      \
            error_line,                                                      \
            error_text)                                                      \
       lsend_ggcode_error(_to,                                                 \
            &thread-> queue-> qid,                                           \
            NULL, NULL, NULL, 0,                                             \
            job,                                                             \
            error_name,                                                      \
            error_line,                                                      \
            error_text)

/*---------------------------------------------------------------------------
 *  Definitions and prototypes for fatal - Fatal reply.
 *---------------------------------------------------------------------------*/

extern char *GGCODE_FATAL;

#define declare_ggcode_fatal(_event, _priority)                                \
    method_declare (agent, GGCODE_FATAL, _event, _priority)

/*  Send event - fatal                                                       */

int 
lsend_ggcode_fatal (
    const QID  *_to,
    const QID  *_from,
          char *_accept,
          char *_reject,
          char *_expire,
          word _timeout,
    const void *job,                /*  Job id                           */
    const char *error_name,         /*  Error file name                  */
    const qbyte error_line,         /*  Error line                       */
    const char *error_text);        /*  Error message text               */

#define send_ggcode_fatal(_to,                                                 \
            job,                                                             \
            error_name,                                                      \
            error_line,                                                      \
            error_text)                                                      \
       lsend_ggcode_fatal(_to,                                                 \
            &thread-> queue-> qid,                                           \
            NULL, NULL, NULL, 0,                                             \
            job,                                                             \
            error_name,                                                      \
            error_line,                                                      \
            error_text)


/*---------------------------------------------------------------------------
 *  Definitions and prototypes for call ok - .
 *---------------------------------------------------------------------------*/

extern char *GGCODE_CALL_OK;

#define declare_ggcode_call_ok(_event, _priority)                              \
    method_declare (agent, GGCODE_CALL_OK, _event, _priority)

/*  Send event - call ok                                                     */

#define lsend_ggcode_call_ok(_to, _from,                                       \
    _accept, _reject, _expire, _timeout)                                     \
        event_send (_to,                                                     \
                    _from,                                                   \
                    GGCODE_CALL_OK,                                            \
                    NULL, 0,                                                 \
                    _accept, _reject, _expire, _timeout)
#define send_ggcode_call_ok(_to)                                               \
        event_send (_to,                                                     \
                    &thread-> queue-> qid,                                   \
                    GGCODE_CALL_OK,                                            \
                    NULL, 0,                                                 \
                    NULL, NULL, NULL, 0)


typedef struct {
    char *error_name;                   /*  Error file name                  */
    qbyte error_line;                   /*  Error line                       */
    char *error_text;                   /*  Error message text               */
} struct_ggcode_call_error;

int
put_ggcode_call_error (
          byte **_buffer,
    const char *error_name,             /*  Error file name                  */
    const qbyte error_line,             /*  Error line                       */
    const char *error_text);            /*  Error message text               */

int
get_ggcode_call_error (
    byte *_buffer,
    struct_ggcode_call_error **params);

void
free_ggcode_call_error (
    struct_ggcode_call_error **params);

/*---------------------------------------------------------------------------
 *  Definitions and prototypes for call message - Message reply.
 *---------------------------------------------------------------------------*/

extern char *GGCODE_CALL_MESSAGE;

#define declare_ggcode_call_message(_event, _priority)                         \
    method_declare (agent, GGCODE_CALL_MESSAGE, _event, _priority)

/*  Send event - call message                                                */

int 
lsend_ggcode_call_message (
    const QID  *_to,
    const QID  *_from,
          char *_accept,
          char *_reject,
          char *_expire,
          word _timeout,
    const char *error_name,         /*  Error file name                  */
    const qbyte error_line,         /*  Error line                       */
    const char *error_text);        /*  Error message text               */

#define send_ggcode_call_message(_to,                                          \
            error_name,                                                      \
            error_line,                                                      \
            error_text)                                                      \
       lsend_ggcode_call_message(_to,                                          \
            &thread-> queue-> qid,                                           \
            NULL, NULL, NULL, 0,                                             \
            error_name,                                                      \
            error_line,                                                      \
            error_text)

/*---------------------------------------------------------------------------
 *  Definitions and prototypes for call error - Error reply.
 *---------------------------------------------------------------------------*/

extern char *GGCODE_CALL_ERROR;

#define declare_ggcode_call_error(_event, _priority)                           \
    method_declare (agent, GGCODE_CALL_ERROR, _event, _priority)

/*  Send event - call error                                                  */

int 
lsend_ggcode_call_error (
    const QID  *_to,
    const QID  *_from,
          char *_accept,
          char *_reject,
          char *_expire,
          word _timeout,
    const char *error_name,         /*  Error file name                  */
    const qbyte error_line,         /*  Error line                       */
    const char *error_text);        /*  Error message text               */

#define send_ggcode_call_error(_to,                                            \
            error_name,                                                      \
            error_line,                                                      \
            error_text)                                                      \
       lsend_ggcode_call_error(_to,                                            \
            &thread-> queue-> qid,                                           \
            NULL, NULL, NULL, 0,                                             \
            error_name,                                                      \
            error_line,                                                      \
            error_text)



#endif                                  /*  Included                         */
/*---------------------------------------------------------------------------
 *  ggfile.h - GSL/fileio package header
 *
 *  Generated from ggfile by ggobjt.gsl using GSL/4.
 *  DO NOT MODIFY THIS FILE.
 *
 *  For documentation and updates see http://www.imatix.com.
 *---------------------------------------------------------------------------*/

#ifndef GGFILE_INCLUDED
#define GGFILE_INCLUDED

/*- Global variables --------------------------------------------------------*/

extern CLASS_DESCRIPTOR
    directory_class;

extern CLASS_DESCRIPTOR
    directory_entry_class;

extern CLASS_DESCRIPTOR
    file_class;

extern CLASS_DESCRIPTOR
    file_entry_class;

/*- Function prototypes -----------------------------------------------------*/

int register_file_classes (void);


#endif
/*---------------------------------------------------------------------------
 *  ggstrn.h - GSL/string package header
 *
 *  Generated from ggstrn by ggobjt.gsl using GSL/4.
 *  DO NOT MODIFY THIS FILE.
 *
 *  For documentation and updates see http://www.imatix.com.
 *---------------------------------------------------------------------------*/

#ifndef GGSTRN_INCLUDED
#define GGSTRN_INCLUDED

/*- Global variables --------------------------------------------------------*/

extern CLASS_DESCRIPTOR
    string_class;

/*- Function prototypes -----------------------------------------------------*/

int register_string_classes (void);


#endif
/*---------------------------------------------------------------------------
 *  ggenvt.h - GSL/environment package header
 *
 *  Generated from ggenvt by ggobjt.gsl using GSL/4.
 *  DO NOT MODIFY THIS FILE.
 *
 *  For documentation and updates see http://www.imatix.com.
 *---------------------------------------------------------------------------*/

#ifndef GGENVT_INCLUDED
#define GGENVT_INCLUDED

/*- Global variables --------------------------------------------------------*/

extern CLASS_DESCRIPTOR
    env_class;

/*- Function prototypes -----------------------------------------------------*/

int register_env_classes (void);


#endif
/*---------------------------------------------------------------------------
 *  ggconv.h - GSL/conv package header
 *
 *  Generated from ggconv by ggobjt.gsl using GSL/4.
 *  DO NOT MODIFY THIS FILE.
 *
 *  For documentation and updates see http://www.imatix.com.
 *---------------------------------------------------------------------------*/

#ifndef GGCONV_INCLUDED
#define GGCONV_INCLUDED

/*- Global variables --------------------------------------------------------*/

extern CLASS_DESCRIPTOR
    conv_class;

/*- Function prototypes -----------------------------------------------------*/

int register_conv_classes (void);


#endif
/*---------------------------------------------------------------------------
 *  ggmath.h - GSL/math package header
 *
 *  Generated from ggmath by ggobjt.gsl using GSL/4.
 *  DO NOT MODIFY THIS FILE.
 *
 *  For documentation and updates see http://www.imatix.com.
 *---------------------------------------------------------------------------*/

#ifndef GGMATH_INCLUDED
#define GGMATH_INCLUDED

/*- Global variables --------------------------------------------------------*/

extern CLASS_DESCRIPTOR
    math_class;

/*- Function prototypes -----------------------------------------------------*/

int register_math_classes (void);


#endif
/*---------------------------------------------------------------------------
 *  ggsock.h - GSL/socket package header
 *
 *  Generated from ggsock by ggobjt.gsl using GSL/4.
 *  DO NOT MODIFY THIS FILE.
 *
 *  For documentation and updates see http://www.imatix.com.
 *---------------------------------------------------------------------------*/

#ifndef GGSOCK_INCLUDED
#define GGSOCK_INCLUDED

/*- Global variables --------------------------------------------------------*/

extern CLASS_DESCRIPTOR
    sock_class;

extern CLASS_DESCRIPTOR
    sock_handle_class;

/*- Function prototypes -----------------------------------------------------*/

int register_sock_classes (void);


#endif
/*---------------------------------------------------------------------------
 *  ggthrd.h - GSL/thrd package header
 *
 *  Generated from ggthrd by ggobjt.gsl using GSL/4.
 *  DO NOT MODIFY THIS FILE.
 *
 *  For documentation and updates see http://www.imatix.com.
 *---------------------------------------------------------------------------*/

#ifndef GGTHRD_INCLUDED
#define GGTHRD_INCLUDED

/*- Global variables --------------------------------------------------------*/

extern CLASS_DESCRIPTOR
    thread_class;

extern CLASS_DESCRIPTOR
    remote_thread_class;

extern CLASS_DESCRIPTOR
    child_thread_class;

extern CLASS_DESCRIPTOR
    parsed_item_class;

/*- Function prototypes -----------------------------------------------------*/

int register_thread_classes (void);


#endif
/*---------------------------------------------------------------------------
 *  ggxml.h - GSL/XML package header
 *
 *  Generated from ggxml by ggobjt.gsl using GSL/4.
 *  DO NOT MODIFY THIS FILE.
 *
 *  For documentation and updates see http://www.imatix.com.
 *---------------------------------------------------------------------------*/

#ifndef GGXML_INCLUDED
#define GGXML_INCLUDED
/*- Public definitions ------------------------------------------------------*/

void *
get_gsl_xml_item (XML_ITEM *xml_item);

XML_ITEM *
get_xml_item (void *gsl_xml_item);


/*- Global variables --------------------------------------------------------*/

extern CLASS_DESCRIPTOR
    XML_class;

extern CLASS_DESCRIPTOR
    XML_item_class;

extern CLASS_DESCRIPTOR
    XML_value_class;

/*- Function prototypes -----------------------------------------------------*/

int register_XML_classes (void);

int shutdown_XML_classes (void);

#endif
/*---------------------------------------------------------------------------
 *  ggtime.h - GSL/time package header
 *
 *  Generated from ggtime by ggobjt.gsl using GSL/4.
 *  DO NOT MODIFY THIS FILE.
 *
 *  For documentation and updates see http://www.imatix.com.
 *---------------------------------------------------------------------------*/

#ifndef GGTIME_INCLUDED
#define GGTIME_INCLUDED

/*- Global variables --------------------------------------------------------*/

extern CLASS_DESCRIPTOR
    time_class;

extern CLASS_DESCRIPTOR
    date_class;

/*- Function prototypes -----------------------------------------------------*/

int register_time_classes (void);


#endif
/*---------------------------------------------------------------------------
 *  ggpcre.h - GSL/regexp package header
 *
 *  Generated from ggpcre by ggobjt.gsl using GSL/4.
 *  DO NOT MODIFY THIS FILE.
 *
 *  For documentation and updates see http://www.imatix.com.
 *---------------------------------------------------------------------------*/

#ifndef GGPCRE_INCLUDED
#define GGPCRE_INCLUDED

/*- Global variables --------------------------------------------------------*/

extern CLASS_DESCRIPTOR
    regexp_class;

/*- Function prototypes -----------------------------------------------------*/

int register_regexp_classes (void);


#endif
/*---------------------------------------------------------------------------
 *  ggdiag.h - GSL/diag package header
 *
 *  Generated from ggdiag by ggobjt.gsl using GSL/4.
 *  DO NOT MODIFY THIS FILE.
 *
 *  For documentation and updates see http://www.imatix.com.
 *---------------------------------------------------------------------------*/

#ifndef GGDIAG_INCLUDED
#define GGDIAG_INCLUDED

/*- Global variables --------------------------------------------------------*/

extern CLASS_DESCRIPTOR
    diag_class;

/*- Function prototypes -----------------------------------------------------*/

int register_diag_classes (void);


#endif
/*---------------------------------------------------------------------------
 *  ggproc.h - GSL/process management
package header
 *
 *  Generated from ggproc by ggobjt.gsl using GSL/4.
 *  DO NOT MODIFY THIS FILE.
 *
 *  For documentation and updates see http://www.imatix.com.
 *---------------------------------------------------------------------------*/

#ifndef GGPROC_INCLUDED
#define GGPROC_INCLUDED

/*- Global variables --------------------------------------------------------*/

extern CLASS_DESCRIPTOR
    proc_class;

extern CLASS_DESCRIPTOR
    proc_handle_class;

/*- Function prototypes -----------------------------------------------------*/

int register_proc_classes (void);


#endif
