package eventrules

// go generate -import github.com/mesos/mesos-go/api/v1/lib/executor -type E:*executor.Event:&executor.Event{} -type ET:executor.Event_Type -output metrics_generated.go
// GENERATED CODE FOLLOWS; DO NOT EDIT.

import (
	"context"

	"strings"

	"github.com/mesos/mesos-go/api/v1/lib/extras/metrics"

	"github.com/mesos/mesos-go/api/v1/lib/executor"
)

// Labeler generates a set of strings that should be associated with metrics that are generated for the given event.
type Labeler func(ctx context.Context, e *executor.Event) []string

var defaultLabels = func() map[executor.Event_Type][]string {
	m := make(map[executor.Event_Type][]string)
	for k, v := range executor.Event_Type_name {
		m[executor.Event_Type(k)] = []string{strings.ToLower(v)}
	}
	return m
}()

func defaultLabeler(ctx context.Context, e *executor.Event) []string {
	return defaultLabels[e.GetType()]
}

// Metrics generates a Rule that invokes the given harness for each event, using the labels generated by the Labeler.
// Panics if harness or labeler is nil.
func Metrics(harness metrics.Harness, labeler Labeler) Rule {
	if harness == nil {
		panic("harness is a required parameter")
	}
	if labeler == nil {
		labeler = defaultLabeler
	}
	return func(ctx context.Context, e *executor.Event, err error, ch Chain) (context.Context, *executor.Event, error) {
		labels := labeler(ctx, e)
		harness(func() error {
			ctx, e, err = ch(ctx, e, err)
			return err
		}, labels...)
		return ctx, e, err
	}
}
