#include "imgconvert.h"

GdkPixbuf* getPixbufC(gchar* filename, gint width, gint height, gint behaviour, gint autorotate){
	GdkPixbuf* pixbuf;
       	GdkPixbuf* bgpixbuf;
	GdkPixbuf* oldpixbuf;
	pixbuf = gdk_pixbuf_new_from_file(filename, NULL);
	gint pwidth, pheight;
        pwidth = gdk_pixbuf_get_width(pixbuf);
	pheight = gdk_pixbuf_get_height(pixbuf);
	gfloat proportion = pwidth/pheight;
	if(proportion < 1 && autorotate == IMGCONVERT_AUTOROTATE_CW){  // CW
		oldpixbuf = pixbuf;
		pixbuf = gdk_pixbuf_rotate_simple(pixbuf, GDK_PIXBUF_ROTATE_CLOCKWISE);
		g_object_unref(oldpixbuf);
		pwidth = gdk_pixbuf_get_width(pixbuf);
		pheight = gdk_pixbuf_get_height(pixbuf);
	}else if(proportion < 1 && autorotate == IMGCONVERT_AUTOROTATE_CCW){  // CCW
		oldpixbuf = pixbuf;
		pixbuf = gdk_pixbuf_rotate_simple(pixbuf, GDK_PIXBUF_ROTATE_COUNTERCLOCKWISE);
		g_object_unref(oldpixbuf);
		pwidth = gdk_pixbuf_get_width(pixbuf);
		pheight = gdk_pixbuf_get_height(pixbuf);
	}
	gint height_with_ratio = pheight*width/pwidth;
	oldpixbuf = pixbuf;
	if(behaviour == IMGCONVERT_BEHAVIOUR_STRETCH){  // Stretch
		pixbuf = gdk_pixbuf_scale_simple(pixbuf, width, height, GDK_INTERP_BILINEAR);
	}else if(behaviour == IMGCONVERT_BEHAVIOUR_ZOOM){  // Zoom
		if(height_with_ratio > height){
			//bgpixbuf = gdk_pixbuf_composite_color_simple(bgpixbuf, width, height, GDK_INTERP_BILINEAR, 0, 2, 0, 0);
			pixbuf = gdk_pixbuf_scale_simple(pixbuf, width, height_with_ratio, GDK_INTERP_BILINEAR);
			bgpixbuf = gdk_pixbuf_new(GDK_COLORSPACE_RGB, gdk_pixbuf_get_has_alpha(pixbuf), 8, width, height);
			//gdk_pixbuf_fill(bgpixbuf, 0);
			gdk_pixbuf_copy_area(pixbuf, 0, (height_with_ratio-height)/2, width, height, bgpixbuf, 0, 0);
			g_object_unref(pixbuf);
			pixbuf = bgpixbuf;
		}else if(height_with_ratio < height){
			gint width_with_ratio = pwidth*height/pheight;
			//bgpixbuf = gdk_pixbuf_composite_color_simple(bgpixbuf, width, height, GDK_INTERP_BILINEAR, 0, 2, 0, 0);
			bgpixbuf = gdk_pixbuf_new(GDK_COLORSPACE_RGB, gdk_pixbuf_get_has_alpha(pixbuf), 8, width, height);
			//gdk_pixbuf_fill(bgpixbuf, 0);
			pixbuf = gdk_pixbuf_scale_simple(pixbuf, width_with_ratio, height, GDK_INTERP_BILINEAR);
			gdk_pixbuf_copy_area(pixbuf, (width_with_ratio-width)/2, 0, width, height, bgpixbuf, 0, 0);
			g_object_unref(pixbuf);
			pixbuf = bgpixbuf;
		}else{
			pixbuf = gdk_pixbuf_scale_simple(pixbuf, width, height, GDK_INTERP_BILINEAR);
		}
	}else{  //Fit
		if(height > height_with_ratio){
			//bgpixbuf = gdk_pixbuf_composite_color_simple(bgpixbuf, width, height, GDK_INTERP_BILINEAR, 0, 2, 0, 0);
			bgpixbuf = gdk_pixbuf_new(GDK_COLORSPACE_RGB, gdk_pixbuf_get_has_alpha(pixbuf), 8, width, height);
			gdk_pixbuf_fill(bgpixbuf, 0);
			pixbuf = gdk_pixbuf_scale_simple(pixbuf, width, height_with_ratio, GDK_INTERP_BILINEAR);
			gdk_pixbuf_copy_area(pixbuf, 0, 0, width, height_with_ratio, bgpixbuf, 0, (height-height_with_ratio)/2);
			g_object_unref(pixbuf);
			pixbuf = bgpixbuf;
		}else if(height < height_with_ratio){
			gint width_with_ratio = pwidth*height/pheight;
			//bgpixbuf = gdk_pixbuf_composite_color_simple(bgpixbuf, width, height, GDK_INTERP_BILINEAR, 0, 2, 0, 0);
			bgpixbuf = gdk_pixbuf_new(GDK_COLORSPACE_RGB, gdk_pixbuf_get_has_alpha(pixbuf), 8, width, height);
			gdk_pixbuf_fill(bgpixbuf, 0);
			pixbuf = gdk_pixbuf_scale_simple(pixbuf, width_with_ratio, height, GDK_INTERP_BILINEAR);
			gdk_pixbuf_copy_area(pixbuf, 0, 0, width_with_ratio, height, bgpixbuf, (width-width_with_ratio)/2, 0);
			g_object_unref(pixbuf);
			pixbuf = bgpixbuf;
		}else{
			pixbuf = gdk_pixbuf_scale_simple(pixbuf, width, height, GDK_INTERP_BILINEAR);
		}
	}
	g_object_unref(oldpixbuf);
	return pixbuf;
}

void toRGB565C(gchar* filename, gint width, gint height, gboolean swap_bytes, gboolean rotate, gint behaviour, gint autorotate, gchar* savefilename){
	GdkPixbuf* pixbuf;
	//pixbuf = gdk_pixbuf_new_from_file_at_scale(filename, width, height, FALSE, NULL);
	pixbuf = getPixbufC(filename, width, height, behaviour, autorotate);
	if(!pixbuf){
		printf("Argh! Failed to get pixbuf!\n");
		exit(1);
	}
	if(rotate){
		GdkPixbuf* oldpixbuf;
		oldpixbuf = pixbuf;
		pixbuf = gdk_pixbuf_rotate_simple(pixbuf, GDK_PIXBUF_ROTATE_COUNTERCLOCKWISE);
		g_object_unref(oldpixbuf);
		gint width2 = height;
		height = width;
		width = width2;
	}
	guchar *pixels = gdk_pixbuf_get_pixels(pixbuf);
	gint x = 0;
	gint y = 0;
        gint rgbpx, red, green, green2, blue, byte1, byte2;
	//gint imgsize = gdk_pixbuf_get_rowstride(pixbuf)*(gdk_pixbuf_get_height(pixbuf)-1)+
	//	                        (gdk_pixbuf_get_width(pixbuf)*(31/8));
	if(gdk_pixbuf_get_has_alpha(pixbuf)){
		rgbpx = 4;
	}else{
		rgbpx = 3;
	}
	//gint imgsize = width*height*rgbpx;
	guchar *rgb565data = (guchar *) g_malloc(width*height*2);
        if(!rgb565data){
		printf("Argh... Could not allocate memory when converting to RGB565!\n");
		exit(1);
	}
	// Sometimes happen that rowstride > width*rgpx. So we cut exceeding padding bytes.
	gint rowstride = gdk_pixbuf_get_rowstride(pixbuf);
	gint imgwidth = width*rgbpx;
	gint exc = rowstride - imgwidth;
	gint h = 0;
	gint w;
	while(h < height){
		w = 0;
		while(w < imgwidth){
			red = pixels[x];
               		red = red >> 3;
			green = pixels[x+1] >> 2;
			blue = pixels[x+2] >> 3;
			green2 = green & 7;
			byte1 = (red << 3) + (green >> 3);
			byte2 = (green2 << 5) + blue;
			if(swap_bytes){
				rgb565data[y] = byte2;
				rgb565data[y+1] = byte1;
			}else{
				rgb565data[y] = byte1;
				rgb565data[y+1] = byte2;
			}
			w += rgbpx;
			x += rgbpx;
			y += 2;
		}
		x += exc;
		h++;
	}
	FILE *fsp = fopen(savefilename, "w+b");
	if(!fsp){
		printf("Argh! Could not open file for writing RGB565 data!\n");
		exit(1);
	}
	fwrite(rgb565data, width*height*2, 1, fsp);
	fclose(fsp);
	while(G_IS_OBJECT(pixbuf)){
		g_object_unref(pixbuf);
	}
	g_free(rgb565data);
}

void fromRGB565C(guchar* rgb565data, gint width, gint height, gboolean swap_bytes, gboolean rotate, gchar* savefilename){
	gint x = 0;
	gint y = 0;
	gint red, green, green1, green2, blue, byte1, byte2;
	gint imgsize = width*3*height;
	guchar *pixels = (guchar *) g_malloc(imgsize);
	if(!pixels){
		printf("Argh... Could not allocate memory when converting from RGB565!\n");
		exit(1);
	}
	while(x < imgsize/3*2){
		if(swap_bytes){
			byte2 = rgb565data[x];
			byte1 = rgb565data[x+1];
		}else{
			byte1 = rgb565data[x];
			byte2 = rgb565data[x+1];
		}
		red = byte1 >> 3;
		blue = byte2 & 31;
		green1 = byte1 & 7;
		green2 = byte2 >> 5;
		green1 = green1 << 3;
		green = green1 + green2;
		red = red << 3;
		green = green << 2;
		blue = blue << 3;
		pixels[y] = red;
		pixels[y+1] = green;
		pixels[y+2] = blue;
		x += 2;
		y += 3;
	}
	GdkPixbuf* pixbuf;
	if(rotate){
		pixbuf = gdk_pixbuf_new_from_data(pixels, GDK_COLORSPACE_RGB, FALSE, 8, height, width, (height * 3), NULL, NULL);
		GdkPixbuf* oldpixbuf = pixbuf;
		pixbuf = gdk_pixbuf_rotate_simple(pixbuf, GDK_PIXBUF_ROTATE_CLOCKWISE);
		g_object_unref(oldpixbuf);
	}else{
		pixbuf = gdk_pixbuf_new_from_data(pixels, GDK_COLORSPACE_RGB, FALSE, 8, width, height, (width * 3), NULL, NULL);
	}
	gdk_pixbuf_save(pixbuf, savefilename, "png", NULL, NULL);
	//g_free(pixels);
	g_object_unref(pixbuf);
}

gint limit8bit(gint x){
	if(x > 255){
		return 255;
	}else if(x < 0){
		return 0;
	}else{
		return x;
	}
}

void toInterlacedUYVYC(gchar* filename, gint behaviour, gint autorotate, gchar *savefilename){
	GdkPixbuf* pixbuf;
	gint width = 720;
	gint height = 480;
	//pixbuf = gdk_pixbuf_new_from_file_at_scale(filename, width, height, FALSE, NULL);
	pixbuf = getPixbufC(filename, width, height, behaviour, autorotate);
	if(!pixbuf){
		printf("Argh! Failed to get pixbuf!\n");
		exit(1);
	}
	guchar* pixels = gdk_pixbuf_get_pixels(pixbuf);
	gint x = 0;
	gint z = 0;
	gint z2 = 0;
	gint r0, g0, b0, r1, g1, b1, r2, g2, b2, r3, g3, b3;
	//gint imgsize = gdk_pixbuf_get_rowstride(pixbuf)*(gdk_pixbuf_get_height(pixbuf)-1)+(gdk_pixbuf_get_width(pixbuf)*(31/8));
	gint yuvsize = width*2*height;
	guchar* yuvdata = (guchar*) g_malloc(yuvsize);
	if(!yuvdata){
		printf("Argh... Could not allocate memory when converting to interlaced YUV!\n");
		exit(1);
	}
	gint halfyuv = yuvsize/2;
	gint alphabit, rgbpx;
	if(gdk_pixbuf_get_has_alpha(pixbuf)){
		alphabit = 1;
		rgbpx = 4;
	}else{
		alphabit = 0;
		rgbpx = 3;
	}
	gint rowstride = gdk_pixbuf_get_rowstride(pixbuf);
	gint exc = rowstride - width*rgbpx;
	gint h = 0;
	while(h < height){
		gint w = 0;
		if((h % 2) == 0){
			while(w < width){
				r0 = pixels[x];
				g0 = pixels[x+1];
				b0 = pixels[x+2];
				r1 = pixels[x+3+alphabit];
				g1 = pixels[x+4+alphabit];
				b1 = pixels[x+5+alphabit];
				yuvdata[z] = ((r0*-38 + g0*-74 + b0*112 + 128) >> 8) + 128; //U0
				yuvdata[z+1] = ((r0*66 + g0*129 + b0*25 + 128) >> 8) + 16;  //Y0
				yuvdata[z+2] = ((r0*112 + g0*-94 + b0*-18 + 128) >> 8) + 128;  //V0
				yuvdata[z+3] = ((r1*66 + g1*129 + b1*25 + 128) >> 8) + 16;  //Y1
				w += 2;
				z += 4;
				x += rgbpx*2;
			}
		}else{
			while(w < width){
				r2 = pixels[x];
				g2 = pixels[x+1];
				b2 = pixels[x+2];
				r3 = pixels[x+3+alphabit];
				g3 = pixels[x+4+alphabit];
				b3 = pixels[x+5+alphabit];
				yuvdata[halfyuv+z2] = ((r2*-38 + g2*-74 + b2*112 + 128) >> 8) + 128; //U1
				yuvdata[halfyuv+z2+1] = ((r2*66 + g2*129 + b2*25 + 128) >> 8) + 16;  //Y2
				yuvdata[halfyuv+z2+2] = ((r2*112 + g2*-94 + b2*-18 + 128) >> 8) + 128;  //V1
				yuvdata[halfyuv+z2+3] = ((r3*66 + g3*129 + b3*25 + 128) >> 8) + 16;  //Y3
				w += 2;
				z2 += 4;
				x += rgbpx*2;
			}
		}
		x += exc;
		h++;
	}
	FILE *fsp = fopen(savefilename, "w+b");
	if(!fsp){
		printf("Argh! Could not open file for writing interlaced YUV data!\n");
		exit(1);
	}
	fwrite(yuvdata, yuvsize, 1, fsp);
	fclose(fsp);
	while(G_IS_OBJECT(pixbuf)){
		g_object_unref(pixbuf);
	}
	g_free(yuvdata);
}		

void fromInterlacedUYVYC(guchar* yuvdata, gchar* savefilename){
	gint width = 720;
	gint height = 480;
	gint imgsize = width*3*height;
	guchar* rgbdata = (guchar*) g_malloc(imgsize);
	if(!rgbdata){
		printf("Argh... Could not allocate memory when converting from interlaced YUV!\n");
		exit(1);
	}
	gint halfimgsize = imgsize/2;
	gint halfyuv = halfimgsize/3*2;
	gint x = 0;
	gint z = 0;
	gint z2 = 0;
	gint u0, y0, v0, y1, u1, y2, v1, y3;
	gint h = 0;
	while(h < height){
		gint w = 0;
		if((h % 2) == 0){
			while(w < width){
				u0 = yuvdata[z];
				y0 = yuvdata[z+1];
				v0 = yuvdata[z+2];
				y1 = yuvdata[z+3];
				rgbdata[x] = limit8bit((y0-16)*1.164 + (v0-128)*1.596);  //R0
				rgbdata[x+1] = limit8bit((y0-16)*1.164 - (v0-128)*0.813 - (u0-128)*0.391);  //G0
				rgbdata[x+2] = limit8bit((y0-16)*1.164 + (u0-128)*2.018); //B0
				rgbdata[x+3] = limit8bit((y0-16)*1.164 + (v0-128)*1.596);  //R1
				rgbdata[x+4] = limit8bit((y1-16)*1.164 - (v0-128)*0.813 - (u0-128)*0.391);  //G1
				rgbdata[x+5] = limit8bit((y1-16)*1.164 + (u0-128)*2.018); //B1
				w += 2;
				z += 4;
				x += 6;
			}
		}else{
			while(w < width){
				u1 = yuvdata[halfyuv+z2];
				y2 = yuvdata[halfyuv+z2+1];
				v1 = yuvdata[halfyuv+z2+2];
				y3 = yuvdata[halfyuv+z2+3];
				rgbdata[x] = limit8bit((y2-16)*1.164 + (v1-128)*1.596);
				rgbdata[x+1] = limit8bit((y2-16)*1.164 - (v1-128)*0.813 - (u1-128)*0.391);
				rgbdata[x+2] = limit8bit((y2-16)*1.164 + (u1-128)*2.018);
				rgbdata[x+3] = limit8bit((y2-16)*1.164 + (v1-128)*1.596);
				rgbdata[x+4] = limit8bit((y3-16)*1.164 - (v1-128)*0.813 - (u1-128)*0.391);
				rgbdata[x+5] = limit8bit((y3-16)*1.164 + (u1-128)*2.018);
				w += 2;
				z2 += 4;
				x += 6;
			}
		}
		h++;
	}
        GdkPixbuf *pixbuf = gdk_pixbuf_new_from_data(rgbdata, GDK_COLORSPACE_RGB, FALSE, 8, width, height, (width * 3), NULL, NULL);
	//g_free(rgbdata);
	gdk_pixbuf_save(pixbuf, savefilename, "png", NULL, NULL);
}

void testAll(){
	//GdkPixbuf* pixbuf;
	gint width, height;
	width = 640;
	height = 480;
	//guchar* pixbufchars;
	toRGB565C("tramontofortini.jpg", width, height, FALSE, TRUE, IMGCONVERT_BEHAVIOUR_FIT, IMGCONVERT_AUTOROTATE_NONE, "test.rgb");
	//pixbuf = fromRGB565C(pixbufchars, height, width, FALSE, TRUE);
	//gdk_pixbuf_save(pixbuf, "test.png", "png", NULL, NULL);
}

//int main(int argc, char *argv[]){
//	gtk_init(&argc, &argv);
//	GdkPixbuf* pixbuf;
        //pixbuf = gdk_pixbuf_new_from_file("GPixPod.png", NULL);
//	gint width, height;
        //width = gdk_pixbuf_get_width(pixbuf);
	//height = gdk_pixbuf_get_height(pixbuf);
	//if(gdk_pixbuf_get_has_alpha(pixbuf)){
	//	printf("Pixbuf ha alpha");
	//}else{
	//	printf("Pixbuf non ha alpha");
	//}
//	width = 640;
//	height = 480;
	//pixbuf = getPixbuf(argv[1], width, height, FALSE, 1, 1);
//	guchar* pixbufchars;
//	pixbufchars = toRGB565C(argv[1], width, height, TRUE, FALSE, IMGCONVERT_BEHAVIOUR_ZOOM, IMGCONVERT_AUTOROTATE_NONE);
//	pixbuf = fromRGB565C(pixbufchars, width, height, TRUE, FALSE);
//	gdk_pixbuf_save(pixbuf, "test.png", "png", NULL, NULL);
//	pixbufchars = toInterlacedUYVYC(argv[1], 2, 0);
//	pixbuf = fromInterlacedUYVYC(pixbufchars);
//	gdk_pixbuf_save(pixbuf, "test.png", "png", NULL, NULL);
//	return 0;
//}
