/*
 *  Hamlib Uniden backend - uniden_digital header
 *  Copyright (c) 2001-2008 by Stephane Fillod
 *
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   Lesser General Public License for more details.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */

#ifndef _UNIDEN_DIGITAL_H
#define _UNIDEN_DIGITAL_H 1

#include "hamlib/rig.h"

#define BACKEND_DIGITAL_VER	"0.3"

int uniden_digital_transaction (RIG *rig, const char *cmdstr, int cmd_len,
		const char *replystr, char *data, size_t *datasize);

const char* uniden_digital_get_info(RIG *rig);

int uniden_digital_set_freq(RIG *rig, vfo_t vfo, freq_t freq);
int uniden_digital_get_freq(RIG *rig, vfo_t vfo, freq_t *freq);


#endif /* _UNIDEN_DIGITAL_H */
