dnl
dnl lib/fmt/xml/hidrd.xsd template.
dnl
dnl Copyright (C) 2010 Nikolai Kondrashov
dnl
dnl This file is part of hidrd.
dnl
dnl Hidrd is free software; you can redistribute it and/or modify
dnl it under the terms of the GNU General Public License as published by
dnl the Free Software Foundation; either version 2 of the License, or
dnl (at your option) any later version.
dnl
dnl Hidrd is distributed in the hope that it will be useful,
dnl but WITHOUT ANY WARRANTY; without even the implied warranty of
dnl MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
dnl GNU General Public License for more details.
dnl
dnl You should have received a copy of the GNU General Public License
dnl along with hidrd; if not, write to the Free Software
dnl Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
dnl
dnl @(#) $Id: all.c.m4 420 2010-05-13 19:50:21Z spb_nick $
dnl
include(`m4/hidrd/util.m4')dnl
dnl
`<?xml version="1.0"?>
<!--
  - vim:nomodifiable
  -
  - - - - - - - - - DO NOT EDIT - - - - - - - -
  - This file is autogenerated from hidrd.xsd.m4
  - - - - - - - - - - - - - - - - - - - - - - - 
  -->
<xsd:schema xmlns:xsd="http://www.w3.org/2001/XMLSchema"
            targetNamespace="http://digimend.sourceforge.net"
            xmlns="http://digimend.sourceforge.net"
            elementFormDefault="qualified">

    <!-- - - - - - - - - - - - - - - - - - - - - - - - - - 
        COMMON DEFINITIONS
    - - - - - - - - - - - - - - - - - - - - - - - - - - -->
    <xsd:complexType name="empty">
        <xsd:complexContent>
            <xsd:restriction base="xsd:anyType" />
        </xsd:complexContent>
    </xsd:complexType>

    <!-- - - - - - - - - - - - - - - - - - - - - - - - - - 
        BASIC ITEM
    - - - - - - - - - - - - - - - - - - - - - - - - - - -->
    <xsd:simpleType name="basic_size">
        <xsd:restriction base="xsd:nonNegativeInteger">
            <xsd:enumeration value="0" />
            <xsd:enumeration value="1" />
            <xsd:enumeration value="2" />
            <xsd:enumeration value="4" />
        </xsd:restriction>
    </xsd:simpleType>

    <xsd:simpleType name="basic_type_token">
        <xsd:restriction base="xsd:string">
            <xsd:enumeration value="main" />
            <xsd:enumeration value="global" />
            <xsd:enumeration value="local" />
            <xsd:enumeration value="reserved" />
        </xsd:restriction>
    </xsd:simpleType>

    <xsd:simpleType name="basic_type_dec">
        <xsd:restriction base="xsd:integer">
            <xsd:minInclusive value="0" />
            <xsd:maxInclusive value="3" />
        </xsd:restriction>
    </xsd:simpleType>

    <xsd:simpleType name="basic_type">
        <xsd:union memberTypes="basic_type_token basic_type_dec" />
    </xsd:simpleType>

    <xsd:simpleType name="basic_tag">
        <xsd:restriction base="xsd:nonNegativeInteger">
            <xsd:maxInclusive value="15" />
        </xsd:restriction>
    </xsd:simpleType>

    <xsd:simpleType name="basic_data">
        <xsd:restriction base="xsd:hexBinary">
            <xsd:maxLength value="257" />
        </xsd:restriction>
    </xsd:simpleType>

    <xsd:element name="basic">
        <xsd:complexType>
            <xsd:simpleContent>
                <xsd:extension base="basic_data">
                    <xsd:attribute name="type" type="basic_type"
                                   use="required" />
                    <xsd:attribute name="size" type="basic_size"
                                   use="required" />
                    <xsd:attribute name="tag" type="basic_tag"
                                   use="required" />
                </xsd:extension>
            </xsd:simpleContent>
        </xsd:complexType>
    </xsd:element>

    <xsd:group name="basic">
        <xsd:choice>
            <xsd:element ref="short" />
            <xsd:group ref="short" />
            <xsd:element ref="long" />
        </xsd:choice>
    </xsd:group>

    <!-- - - - - - - - - - - - - - - - - - - - - - - - - - 
        SHORT ITEM
    - - - - - - - - - - - - - - - - - - - - - - - - - - -->
    <xsd:simpleType name="short_type_dec">
        <xsd:restriction base="basic_type_dec">
            <xsd:maxInclusive value="2" />
        </xsd:restriction>
    </xsd:simpleType>

    <xsd:simpleType name="short_type_token">
        <xsd:restriction base="basic_type_token">
            <xsd:enumeration value="main" />
            <xsd:enumeration value="global" />
            <xsd:enumeration value="local" />
        </xsd:restriction>
    </xsd:simpleType>

    <xsd:simpleType name="short_type">
        <xsd:union memberTypes="short_type_token short_type_dec" />
    </xsd:simpleType>

    <xsd:simpleType name="short_tag">
        <xsd:restriction base="basic_tag" />
    </xsd:simpleType>

    <xsd:simpleType name="short_data">
        <xsd:restriction base="basic_data">
            <xsd:maxLength value="4" />
        </xsd:restriction>
    </xsd:simpleType>

    <xsd:element name="short">
        <xsd:complexType>
            <xsd:simpleContent>
                <xsd:extension base="short_data">
                    <xsd:attribute name="type" type="short_type"
                                   use="required" />
                    <xsd:attribute name="tag" type="short_tag"
                                   use="required" />
                </xsd:extension>
            </xsd:simpleContent>
        </xsd:complexType>
    </xsd:element>

    <xsd:group name="short">
        <xsd:choice>
            <xsd:element ref="main" />
            <xsd:group ref="main" />
            <xsd:element ref="global" />
            <xsd:group ref="global" />
            <xsd:element ref="local" />
            <xsd:group ref="local" />
        </xsd:choice>
    </xsd:group>

    <!-- - - - - - - - - - - - - - - - - - - - - - - - - - 
        MAIN ITEM
    - - - - - - - - - - - - - - - - - - - - - - - - - - -->
    <xsd:simpleType name="main_tag">
        <xsd:union memberTypes="short_tag">
            <xsd:simpleType>
                <xsd:restriction base="xsd:string">
                    <xsd:enumeration value="input" />
                    <xsd:enumeration value="output" />
                    <xsd:enumeration value="feature" />
                    <xsd:enumeration value="collection" />
                    <xsd:enumeration value="end_collection" />
                </xsd:restriction>
            </xsd:simpleType>
        </xsd:union>
    </xsd:simpleType>

    <xsd:element name="main">
        <xsd:complexType>
            <xsd:simpleContent>
                <xsd:extension base="short_data">
                    <xsd:attribute name="tag" type="main_tag"
                                   use="required" />
                </xsd:extension>
            </xsd:simpleContent>
        </xsd:complexType>
    </xsd:element>

    <xsd:group name="main">
        <xsd:choice>
            <xsd:element ref="input" />
            <xsd:element ref="output" />
            <xsd:element ref="feature" />
            <xsd:element ref="collection" />
            <xsd:element ref="end_collection" />
            <xsd:element ref="COLLECTION" />
        </xsd:choice>
    </xsd:group>

    <!-- - - - - - - - - - - - - - - - - - - - - - - - - - 
        MAIN ITEM: INPUT
    - - - - - - - - - - - - - - - - - - - - - - - - - - -->
    <xsd:element name="input">
        <xsd:complexType>
            <xsd:sequence>
                <xsd:choice minOccurs="0">
                    <xsd:element name="bit0" type="xsd:boolean" default="1" />
                    <xsd:element name="data" type="xsd:boolean" default="true" />
                    <xsd:element name="constant" type="xsd:boolean" default="true" />
                </xsd:choice>
                <xsd:choice minOccurs="0">
                    <xsd:element name="bit1" type="xsd:boolean" default="1" />
                    <xsd:element name="array" type="xsd:boolean" default="true" />
                    <xsd:element name="variable" type="xsd:boolean" default="true" />
                </xsd:choice>
                <xsd:choice minOccurs="0">
                    <xsd:element name="bit2" type="xsd:boolean" default="1" />
                    <xsd:element name="absolute" type="xsd:boolean" default="true" />
                    <xsd:element name="relative" type="xsd:boolean" default="true" />
                </xsd:choice>
                <xsd:choice minOccurs="0">
                    <xsd:element name="bit3" type="xsd:boolean" default="1" />
                    <xsd:element name="no_wrap" type="xsd:boolean" default="true" />
                    <xsd:element name="wrap" type="xsd:boolean" default="true" />
                </xsd:choice>
                <xsd:choice minOccurs="0">
                    <xsd:element name="bit4" type="xsd:boolean" default="1" />
                    <xsd:element name="linear" type="xsd:boolean" default="true" />
                    <xsd:element name="non_linear" type="xsd:boolean" default="true" />
                </xsd:choice>
                <xsd:choice minOccurs="0">
                    <xsd:element name="bit5" type="xsd:boolean" default="1" />
                    <xsd:element name="preferred_state" type="xsd:boolean" default="true" />
                    <xsd:element name="no_preferred" type="xsd:boolean" default="true" />
                </xsd:choice>
                <xsd:choice minOccurs="0">
                    <xsd:element name="bit6" type="xsd:boolean" default="1" />
                    <xsd:element name="no_null_position" type="xsd:boolean" default="true" />
                    <xsd:element name="null_state" type="xsd:boolean" default="true" />
                </xsd:choice>
                <xsd:element name="bit7" type="xsd:boolean" default="1" minOccurs="0" />
                <xsd:choice minOccurs="0">
                    <xsd:element name="bit8" type="xsd:boolean" default="1" />
                    <xsd:element name="bit_field" type="xsd:boolean" default="true" />
                    <xsd:element name="buffered_bytes" type="xsd:boolean" default="true" />
                </xsd:choice>
                <xsd:element name="bit9" type="xsd:boolean" default="1" minOccurs="0" />
                <xsd:element name="bit10" type="xsd:boolean" default="1" minOccurs="0" />
                <xsd:element name="bit11" type="xsd:boolean" default="1" minOccurs="0" />
                <xsd:element name="bit12" type="xsd:boolean" default="1" minOccurs="0" />
                <xsd:element name="bit13" type="xsd:boolean" default="1" minOccurs="0" />
                <xsd:element name="bit14" type="xsd:boolean" default="1" minOccurs="0" />
                <xsd:element name="bit15" type="xsd:boolean" default="1" minOccurs="0" />
                <xsd:element name="bit16" type="xsd:boolean" default="1" minOccurs="0" />
                <xsd:element name="bit17" type="xsd:boolean" default="1" minOccurs="0" />
                <xsd:element name="bit18" type="xsd:boolean" default="1" minOccurs="0" />
                <xsd:element name="bit19" type="xsd:boolean" default="1" minOccurs="0" />
                <xsd:element name="bit20" type="xsd:boolean" default="1" minOccurs="0" />
                <xsd:element name="bit21" type="xsd:boolean" default="1" minOccurs="0" />
                <xsd:element name="bit22" type="xsd:boolean" default="1" minOccurs="0" />
                <xsd:element name="bit23" type="xsd:boolean" default="1" minOccurs="0" />
                <xsd:element name="bit24" type="xsd:boolean" default="1" minOccurs="0" />
                <xsd:element name="bit25" type="xsd:boolean" default="1" minOccurs="0" />
                <xsd:element name="bit26" type="xsd:boolean" default="1" minOccurs="0" />
                <xsd:element name="bit27" type="xsd:boolean" default="1" minOccurs="0" />
                <xsd:element name="bit28" type="xsd:boolean" default="1" minOccurs="0" />
                <xsd:element name="bit29" type="xsd:boolean" default="1" minOccurs="0" />
                <xsd:element name="bit30" type="xsd:boolean" default="1" minOccurs="0" />
                <xsd:element name="bit31" type="xsd:boolean" default="1" minOccurs="0" />
            </xsd:sequence>
        </xsd:complexType>
    </xsd:element>

    <!-- - - - - - - - - - - - - - - - - - - - - - - - - - 
        MAIN ITEM: OUTPUT AND FEATURE
    - - - - - - - - - - - - - - - - - - - - - - - - - - -->
    <xsd:complexType name="output_or_feature">
        <xsd:sequence>
            <xsd:choice minOccurs="0">
                <xsd:element name="bit0" type="xsd:boolean" default="1" />
                <xsd:element name="data" type="xsd:boolean" default="true" />
                <xsd:element name="constant" type="xsd:boolean" default="true" />
            </xsd:choice>
            <xsd:choice minOccurs="0">
                <xsd:element name="bit1" type="xsd:boolean" default="1" />
                <xsd:element name="array" type="xsd:boolean" default="true" />
                <xsd:element name="variable" type="xsd:boolean" default="true" />
            </xsd:choice>
            <xsd:choice minOccurs="0">
                <xsd:element name="bit2" type="xsd:boolean" default="1" />
                <xsd:element name="absolute" type="xsd:boolean" default="true" />
                <xsd:element name="relative" type="xsd:boolean" default="true" />
            </xsd:choice>
            <xsd:choice minOccurs="0">
                <xsd:element name="bit3" type="xsd:boolean" default="1" />
                <xsd:element name="no_wrap" type="xsd:boolean" default="true" />
                <xsd:element name="wrap" type="xsd:boolean" default="true" />
            </xsd:choice>
            <xsd:choice minOccurs="0">
                <xsd:element name="bit4" type="xsd:boolean" default="1" />
                <xsd:element name="linear" type="xsd:boolean" default="true" />
                <xsd:element name="non_linear" type="xsd:boolean" default="true" />
            </xsd:choice>
            <xsd:choice minOccurs="0">
                <xsd:element name="bit5" type="xsd:boolean" default="1" />
                <xsd:element name="preferred_state" type="xsd:boolean" default="true" />
                <xsd:element name="no_preferred" type="xsd:boolean" default="true" />
            </xsd:choice>
            <xsd:choice minOccurs="0">
                <xsd:element name="bit6" type="xsd:boolean" default="1" />
                <xsd:element name="no_null_position" type="xsd:boolean" default="true" />
                <xsd:element name="null_state" type="xsd:boolean" default="true" />
            </xsd:choice>
            <xsd:choice minOccurs="0">
                <xsd:element name="bit7" type="xsd:boolean" default="1" />
                <xsd:element name="non_volatile" type="xsd:boolean" default="true" />
                <xsd:element name="volatile" type="xsd:boolean" default="true" />
            </xsd:choice>
            <xsd:choice minOccurs="0">
                <xsd:element name="bit8" type="xsd:boolean" default="1" />
                <xsd:element name="bit_field" type="xsd:boolean" default="true" />
                <xsd:element name="buffered_bytes" type="xsd:boolean" default="true" />
            </xsd:choice>
            <xsd:element name="bit9" type="xsd:boolean" default="1" minOccurs="0" />
            <xsd:element name="bit10" type="xsd:boolean" default="1" minOccurs="0" />
            <xsd:element name="bit11" type="xsd:boolean" default="1" minOccurs="0" />
            <xsd:element name="bit12" type="xsd:boolean" default="1" minOccurs="0" />
            <xsd:element name="bit13" type="xsd:boolean" default="1" minOccurs="0" />
            <xsd:element name="bit14" type="xsd:boolean" default="1" minOccurs="0" />
            <xsd:element name="bit15" type="xsd:boolean" default="1" minOccurs="0" />
            <xsd:element name="bit16" type="xsd:boolean" default="1" minOccurs="0" />
            <xsd:element name="bit17" type="xsd:boolean" default="1" minOccurs="0" />
            <xsd:element name="bit18" type="xsd:boolean" default="1" minOccurs="0" />
            <xsd:element name="bit19" type="xsd:boolean" default="1" minOccurs="0" />
            <xsd:element name="bit20" type="xsd:boolean" default="1" minOccurs="0" />
            <xsd:element name="bit21" type="xsd:boolean" default="1" minOccurs="0" />
            <xsd:element name="bit22" type="xsd:boolean" default="1" minOccurs="0" />
            <xsd:element name="bit23" type="xsd:boolean" default="1" minOccurs="0" />
            <xsd:element name="bit24" type="xsd:boolean" default="1" minOccurs="0" />
            <xsd:element name="bit25" type="xsd:boolean" default="1" minOccurs="0" />
            <xsd:element name="bit26" type="xsd:boolean" default="1" minOccurs="0" />
            <xsd:element name="bit27" type="xsd:boolean" default="1" minOccurs="0" />
            <xsd:element name="bit28" type="xsd:boolean" default="1" minOccurs="0" />
            <xsd:element name="bit29" type="xsd:boolean" default="1" minOccurs="0" />
            <xsd:element name="bit30" type="xsd:boolean" default="1" minOccurs="0" />
            <xsd:element name="bit31" type="xsd:boolean" default="1" minOccurs="0" />
        </xsd:sequence>
    </xsd:complexType>

    <xsd:element name="output" type="output_or_feature" />
    <xsd:element name="feature" type="output_or_feature" />

    <!-- - - - - - - - - - - - - - - - - - - - - - - - - - 
        MAIN ITEM: COLLECTION AND END_COLLECTION
    - - - - - - - - - - - - - - - - - - - - - - - - - - -->
    <xsd:simpleType name="collection_type">
        <xsd:union memberTypes="xsd:unsignedByte">
            <xsd:simpleType>
                <xsd:restriction base="xsd:string">
                    <xsd:enumeration value="physical" />
                    <xsd:enumeration value="application" />
                    <xsd:enumeration value="logical" />
                    <xsd:enumeration value="report" />
                    <xsd:enumeration value="named_array" />
                    <xsd:enumeration value="usage_switch" />
                    <xsd:enumeration value="usage_modifier" />
                </xsd:restriction>
            </xsd:simpleType>
        </xsd:union>
    </xsd:simpleType>

    <xsd:element name="collection">
        <xsd:complexType>
            <xsd:attribute name="type" type="collection_type"
                           use="required" />
        </xsd:complexType>
    </xsd:element>

    <xsd:element name="end_collection" type="empty" />

    <!-- - - - - - - - - - - - - - - - - - - - - - - - - - 
        META ITEM: COLLECTION
    - - - - - - - - - - - - - - - - - - - - - - - - - - -->
    <xsd:element name="COLLECTION">
        <xsd:complexType>
            <xsd:complexContent>
                <xsd:extension base="basic_sequence">
                    <xsd:attribute name="type" type="collection_type"
                                   use="required" />
                </xsd:extension>
            </xsd:complexContent>
        </xsd:complexType>
    </xsd:element>

    <!-- - - - - - - - - - - - - - - - - - - - - - - - - - 
        GLOBAL ITEM
    - - - - - - - - - - - - - - - - - - - - - - - - - - -->
    <xsd:simpleType name="global_tag">
        <xsd:union memberTypes="short_tag">
            <xsd:simpleType>
                <xsd:restriction base="xsd:string">
                    <xsd:enumeration value="usage_page" />
                    <xsd:enumeration value="logical_minimum" />
                    <xsd:enumeration value="logical_maximum" />
                    <xsd:enumeration value="physical_minimum" />
                    <xsd:enumeration value="physical_maximum" />
                    <xsd:enumeration value="unit_exponent" />
                    <xsd:enumeration value="unit" />
                    <xsd:enumeration value="report_size" />
                    <xsd:enumeration value="report_id" />
                    <xsd:enumeration value="report_count" />
                    <xsd:enumeration value="push" />
                    <xsd:enumeration value="pop" />
                </xsd:restriction>
            </xsd:simpleType>
        </xsd:union>
    </xsd:simpleType>

    <xsd:element name="global">
        <xsd:complexType>
            <xsd:simpleContent>
                <xsd:extension base="short_data">
                    <xsd:attribute name="tag" type="global_tag"
                                   use="required" />
                </xsd:extension>
            </xsd:simpleContent>
        </xsd:complexType>
    </xsd:element>

    <xsd:group name="global">
        <xsd:choice>
            <xsd:element ref="usage_page" />
            <xsd:element ref="logical_minimum" />
            <xsd:element ref="logical_maximum" />
            <xsd:element ref="physical_minimum" />
            <xsd:element ref="physical_maximum" />
            <xsd:element ref="unit_exponent" />
            <xsd:element ref="unit" />
            <xsd:element ref="report_size" />
            <xsd:element ref="report_id" />
            <xsd:element ref="report_count" />
            <xsd:element ref="push" />
            <xsd:element ref="pop" />
            <xsd:element ref="PUSH" />
        </xsd:choice>
    </xsd:group>

    <!-- - - - - - - - - - - - - - - - - - - - - - - - - - 
        GLOBAL ITEM: USAGE PAGE
    - - - - - - - - - - - - - - - - - - - - - - - - - - -->
    <xsd:simpleType name="usage_page_hex">
        <xsd:restriction base="xsd:string">
            <xsd:pattern value="[0-9a-fA-F]{1,4}"
                         annotation="unsigned 16-bit hexadecimal integer" />
        </xsd:restriction>
    </xsd:simpleType>
    <xsd:simpleType name="usage_page_token">
        <xsd:restriction base="xsd:string">
            <xsd:enumeration value="undefined">
                <xsd:annotation>
                    <xsd:documentation>Undefined</xsd:documentation>
                </xsd:annotation>
            </xsd:enumeration>'
pushdef(PAGE,dnl
`            <xsd:enumeration value="xml_attvalue(lowercase(`$2'))">
                <xsd:annotation>
                    <xsd:documentation>xml_cdata(capitalize_first(`$3'))</xsd:documentation>
                </xsd:annotation>
            </xsd:enumeration>
')dnl
include(`db/usage/page.m4')dnl
popdef(`PAGE')dnl
`        </xsd:restriction>
    </xsd:simpleType>
    <xsd:simpleType name="usage_page">
        <xsd:union memberTypes="usage_page_hex usage_page_token" />
    </xsd:simpleType>

    <xsd:element name="usage_page" type="usage_page" />

    <!-- - - - - - - - - - - - - - - - - - - - - - - - - - 
        GLOBAL ITEM: LOGICAL MINIMUM
                     LOGICAL MAXIMUM
                     PHYSICAL MINIMUM
                     PHYSICAL MAXIMUM
                     UNIT EXPONENT
    - - - - - - - - - - - - - - - - - - - - - - - - - - -->
    <xsd:element name="logical_minimum" type="xsd:int" />
    <xsd:element name="logical_maximum" type="xsd:int" />
    <xsd:element name="physical_minimum" type="xsd:int" />
    <xsd:element name="physical_maximum" type="xsd:int" />
    <xsd:element name="unit_exponent" type="xsd:int" />

    <!-- - - - - - - - - - - - - - - - - - - - - - - - - - 
        GLOBAL ITEM: UNIT
    - - - - - - - - - - - - - - - - - - - - - - - - - - -->
    <xsd:simpleType name="unit_data_exp">
        <xsd:restriction base="xsd:integer">
            <xsd:minInclusive value="-8" />
            <xsd:maxInclusive value="7" />
        </xsd:restriction>
    </xsd:simpleType>

    <xsd:simpleType name="unit_data_system_code">
        <xsd:restriction base="xsd:integer">
            <xsd:minInclusive value="0" />
            <xsd:maxInclusive value="15" />
        </xsd:restriction>
    </xsd:simpleType>

    <xsd:simpleType name="unit_data_system_name">
        <xsd:restriction base="xsd:string">
            <xsd:enumeration value="none" />
            <xsd:enumeration value="si_linear" />
            <xsd:enumeration value="si_rotation" />
            <xsd:enumeration value="english_linear" />
            <xsd:enumeration value="english_rotation" />
            <xsd:enumeration value="vendor" />
        </xsd:restriction>
    </xsd:simpleType>

    <xsd:simpleType name="unit_data_system">
        <xsd:union memberTypes="unit_data_system_code unit_data_system_name" />
    </xsd:simpleType>

    <xsd:element name="unit">
        <xsd:complexType>
            <xsd:choice minOccurs="0">
                <xsd:element name="none" type="empty" />
                <xsd:element name="value">
                    <xsd:simpleType>
                        <xsd:restriction base="xsd:hexBinary">
                            <xsd:minLength value="0" />
                            <xsd:maxLength value="4" />
                        </xsd:restriction>
                    </xsd:simpleType>
                </xsd:element>
                <xsd:element name="generic">
                    <xsd:complexType>
                        <xsd:sequence minOccurs="1">
                            <xsd:element name="length" type="unit_data_exp"
                                         default="1" minOccurs="0" />
                            <xsd:element name="mass" type="unit_data_exp"
                                         default="1" minOccurs="0" />
                            <xsd:element name="time" type="unit_data_exp"
                                         default="1" minOccurs="0" />
                            <xsd:element name="temperature" type="unit_data_exp"
                                         default="1" minOccurs="0" />
                            <xsd:element name="current" type="unit_data_exp"
                                         default="1" minOccurs="0" />
                            <xsd:element name="luminous_intensity" type="unit_data_exp"
                                         default="1" minOccurs="0" />
                        </xsd:sequence>
                        <xsd:attribute name="system" type="unit_data_system"
                                       use="required" />
                    </xsd:complexType>
                </xsd:element>
                <xsd:element name="si_linear">
                    <xsd:complexType>
                        <xsd:sequence minOccurs="1">
                            <xsd:element name="centimeter" type="unit_data_exp"
                                         default="1" minOccurs="0" />
                            <xsd:element name="gram" type="unit_data_exp"
                                         default="1" minOccurs="0" />
                            <xsd:element name="seconds" type="unit_data_exp"
                                         default="1" minOccurs="0" />
                            <xsd:element name="kelvin" type="unit_data_exp"
                                         default="1" minOccurs="0" />
                            <xsd:element name="ampere" type="unit_data_exp"
                                         default="1" minOccurs="0" />
                            <xsd:element name="candela" type="unit_data_exp"
                                         default="1" minOccurs="0" />
                        </xsd:sequence>
                    </xsd:complexType>
                </xsd:element>
                <xsd:element name="si_rotation">
                    <xsd:complexType>
                        <xsd:sequence minOccurs="1">
                            <xsd:element name="radians" type="unit_data_exp"
                                         default="1" minOccurs="0" />
                            <xsd:element name="gram" type="unit_data_exp"
                                         default="1" minOccurs="0" />
                            <xsd:element name="seconds" type="unit_data_exp"
                                         default="1" minOccurs="0" />
                            <xsd:element name="kelvin" type="unit_data_exp"
                                         default="1" minOccurs="0" />
                            <xsd:element name="ampere" type="unit_data_exp"
                                         default="1" minOccurs="0" />
                            <xsd:element name="candela" type="unit_data_exp"
                                         default="1" minOccurs="0" />
                        </xsd:sequence>
                    </xsd:complexType>
                </xsd:element>
                <xsd:element name="english_linear">
                    <xsd:complexType>
                        <xsd:sequence minOccurs="1">
                            <xsd:element name="inch" type="unit_data_exp"
                                         default="1" minOccurs="0" />
                            <xsd:element name="slug" type="unit_data_exp"
                                         default="1" minOccurs="0" />
                            <xsd:element name="seconds" type="unit_data_exp"
                                         default="1" minOccurs="0" />
                            <xsd:element name="fahrenheit" type="unit_data_exp"
                                         default="1" minOccurs="0" />
                            <xsd:element name="ampere" type="unit_data_exp"
                                         default="1" minOccurs="0" />
                            <xsd:element name="candela" type="unit_data_exp"
                                         default="1" minOccurs="0" />
                        </xsd:sequence>
                    </xsd:complexType>
                </xsd:element>
                <xsd:element name="english_rotation">
                    <xsd:complexType>
                        <xsd:sequence minOccurs="1">
                            <xsd:element name="degrees" type="unit_data_exp"
                                         default="1" minOccurs="0" />
                            <xsd:element name="slug" type="unit_data_exp"
                                         default="1" minOccurs="0" />
                            <xsd:element name="seconds" type="unit_data_exp"
                                         default="1" minOccurs="0" />
                            <xsd:element name="fahrenheit" type="unit_data_exp"
                                         default="1" minOccurs="0" />
                            <xsd:element name="ampere" type="unit_data_exp"
                                         default="1" minOccurs="0" />
                            <xsd:element name="candela" type="unit_data_exp"
                                         default="1" minOccurs="0" />
                        </xsd:sequence>
                    </xsd:complexType>
                </xsd:element>
            </xsd:choice>
        </xsd:complexType>
    </xsd:element>

    <!-- - - - - - - - - - - - - - - - - - - - - - - - - - 
        GLOBAL ITEM: REPORT SIZE
                     REPORT COUNT
    - - - - - - - - - - - - - - - - - - - - - - - - - - -->
    <xsd:element name="report_size" type="xsd:unsignedInt" />
    <xsd:element name="report_count" type="xsd:unsignedInt" />

    <!-- - - - - - - - - - - - - - - - - - - - - - - - - - 
        GLOBAL ITEM: REPORT ID
    - - - - - - - - - - - - - - - - - - - - - - - - - - -->
    <xsd:element name="report_id">
        <xsd:simpleType>
            <xsd:restriction base="xsd:unsignedByte">
                <xsd:minInclusive value="1" />
            </xsd:restriction>
        </xsd:simpleType>
    </xsd:element>

    <!-- - - - - - - - - - - - - - - - - - - - - - - - - - 
        GLOBAL ITEM: PUSH AND POP (AND PUSH GROUP - PUSH/POP)
    - - - - - - - - - - - - - - - - - - - - - - - - - - -->
    <xsd:element name="push" type="empty" />
    <xsd:element name="pop" type="empty" />

    <!-- - - - - - - - - - - - - - - - - - - - - - - - - - 
        META ITEM: PUSH (PUSH/POP PAIR)
    - - - - - - - - - - - - - - - - - - - - - - - - - - -->
    <xsd:element name="PUSH" type="basic_sequence" />

    <!-- - - - - - - - - - - - - - - - - - - - - - - - - - 
        LOCAL ITEM
    - - - - - - - - - - - - - - - - - - - - - - - - - - -->
    <xsd:simpleType name="local_tag">
        <xsd:union memberTypes="short_tag">
            <xsd:simpleType>
                <xsd:restriction base="xsd:string">
                    <xsd:enumeration value="usage" />
                    <xsd:enumeration value="usage_minimum" />
                    <xsd:enumeration value="usage_maximum" />
                    <xsd:enumeration value="designator_index" />
                    <xsd:enumeration value="designator_minimum" />
                    <xsd:enumeration value="designator_maximum" />
                    <xsd:enumeration value="string_index" />
                    <xsd:enumeration value="string_minimum" />
                    <xsd:enumeration value="string_maximum" />
                    <xsd:enumeration value="delimiter" />
                </xsd:restriction>
            </xsd:simpleType>
        </xsd:union>
    </xsd:simpleType>

    <xsd:element name="local">
        <xsd:complexType>
            <xsd:simpleContent>
                <xsd:extension base="short_data">
                    <xsd:attribute name="tag" type="local_tag"
                                   use="required" />
                </xsd:extension>
            </xsd:simpleContent>
        </xsd:complexType>
    </xsd:element>

    <xsd:group name="local">
        <xsd:choice>
            <xsd:element ref="usage" />
            <xsd:element ref="usage_minimum" />
            <xsd:element ref="usage_maximum" />
            <xsd:element ref="designator_index" />
            <xsd:element ref="designator_minimum" />
            <xsd:element ref="designator_maximum" />
            <xsd:element ref="string_index" />
            <xsd:element ref="string_minimum" />
            <xsd:element ref="string_maximum" />
            <xsd:element ref="delimiter" />
            <xsd:element ref="SET" />
        </xsd:choice>
    </xsd:group>

    <!-- - - - - - - - - - - - - - - - - - - - - - - - - - 
        LOCAL ITEM: USAGE
                    USAGE MINIMUM
                    USAGE MAXIMUM
    - - - - - - - - - - - - - - - - - - - - - - - - - - -->
    <xsd:simpleType name="usage_hex">
        <xsd:restriction base="xsd:string">
            <xsd:pattern value="[0-9a-fA-F]{1,8}"
                         annotation="unsigned 32-bit hexadecimal integer" />
        </xsd:restriction>
    </xsd:simpleType>
    <xsd:simpleType name="undefined_usage_token">
        <xsd:annotation>
            <xsd:documentation>Undefined page</xsd:documentation>
        </xsd:annotation>
        <xsd:restriction base="xsd:string">
            <xsd:enumeration value="undefined_undefined">
                <xsd:annotation>
                    <xsd:documentation>Undefined</xsd:documentation>
                </xsd:annotation>
            </xsd:enumeration>
        </xsd:restriction>
    </xsd:simpleType>
'pushdef(`PAGE',
`ifelse(eval(PAGE_ID_NUM(`$2') > 0), 1,
`pushdef(`ID',
`'            <xsd:enumeration value="`xml_attvalue'(lowercase($2)_``'lowercase'(`$'2))">
                <xsd:annotation>
                    <xsd:documentation>`xml_cdata'(`capitalize_first'(`$'4) (`$'3))</xsd:documentation>
                </xsd:annotation>
            </xsd:enumeration>
)dnl
    <xsd:simpleType name="xml_attvalue(lowercase($2)_usage_token)">
        <xsd:annotation>
            <xsd:documentation>xml_cdata(capitalize_first($3) page)</xsd:documentation>
        </xsd:annotation>
        <xsd:restriction base="xsd:string">
sinclude(`db/usage/id_'lowercase($2)`.m4')dnl
        </xsd:restriction>
    </xsd:simpleType>
popdef(`ID')dnl
')')dnl
include(`db/usage/page.m4')dnl
popdef(`PAGE')dnl
`    <xsd:simpleType name="usage_token">
        <xsd:union memberTypes="undefined_usage_token'dnl
pushdef(`PAGE', `ifelse(eval(PAGE_ID_NUM(`$2') > 0), 1,
                        ` 'xml_attvalue( lowercase(`$2')_usage_token))`'')dnl
include(`db/usage/page.m4')dnl
popdef(`PAGE')dnl
`" />
    </xsd:simpleType>
    <xsd:simpleType name="usage">
        <xsd:union memberTypes="usage_hex usage_token" />
    </xsd:simpleType>

    <xsd:element name="usage" type="usage" />
    <xsd:element name="usage_minimum" type="usage" />
    <xsd:element name="usage_maximum" type="usage" />

    <!-- - - - - - - - - - - - - - - - - - - - - - - - - - 
        LOCAL ITEM: DESIGNATOR INDEX
                    DESIGNATOR MINIMUM
                    DESIGNATOR MAXIMUM
                    STRING INDEX
                    STRING MINIMUM
                    STRING MAXIMUM
    - - - - - - - - - - - - - - - - - - - - - - - - - - -->
    <xsd:element name="designator_index" type="xsd:unsignedInt" />
    <xsd:element name="designator_minimum" type="xsd:unsignedInt" />
    <xsd:element name="designator_maximum" type="xsd:unsignedInt" />
    <xsd:element name="string_index" type="xsd:unsignedInt" />
    <xsd:element name="string_minimum" type="xsd:unsignedInt" />
    <xsd:element name="string_maximum" type="xsd:unsignedInt" />

    <!-- - - - - - - - - - - - - - - - - - - - - - - - - - 
        LOCAL ITEM: DELIMITER
    - - - - - - - - - - - - - - - - - - - - - - - - - - -->
    <xsd:element name="delimiter">
        <xsd:complexType>
            <xsd:attribute name="open" type="xsd:boolean" use="required" />
        </xsd:complexType>
    </xsd:element>

    <!-- - - - - - - - - - - - - - - - - - - - - - - - - - 
        META ITEM: SET (OPEN/CLOSE DELIMITER PAIR)
    - - - - - - - - - - - - - - - - - - - - - - - - - - -->
    <xsd:element name="SET" type="basic_sequence" />

    <!-- - - - - - - - - - - - - - - - - - - - - - - - - - 
        LONG ITEM
    - - - - - - - - - - - - - - - - - - - - - - - - - - -->
    <xsd:simpleType name="long_tag">
        <xsd:restriction base="xsd:nonNegativeInteger">
            <xsd:maxInclusive value="255" />
        </xsd:restriction>
    </xsd:simpleType>

    <xsd:simpleType name="long_data">
        <xsd:restriction base="basic_data">
            <xsd:maxLength value="255" />
        </xsd:restriction>
    </xsd:simpleType>

    <xsd:element name="long">
        <xsd:complexType>
            <xsd:simpleContent>
                <xsd:extension base="long_data">
                    <xsd:attribute name="tag" type="long_tag"
                                   use="required" />
                </xsd:extension>
            </xsd:simpleContent>
        </xsd:complexType>
    </xsd:element>

    <!-- - - - - - - - - - - - - - - - - - - - - - - - - - 
        DESCRIPTOR
    - - - - - - - - - - - - - - - - - - - - - - - - - - -->
    <xsd:group name="basic_choice">
        <xsd:choice>
            <xsd:element ref="basic" />
            <xsd:group ref="basic" />
        </xsd:choice>
    </xsd:group>

    <xsd:complexType name="basic_sequence">
        <xsd:sequence>
            <xsd:group ref="basic_choice"
                       minOccurs="0" maxOccurs="unbounded" />
        </xsd:sequence>
    </xsd:complexType>

    <xsd:element name="descriptor" type="basic_sequence" />
</xsd:schema>'
