/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

var htrace = htrace || {};

// Show a modal dialog box with a warning message.
htrace.showModalWarning = function(title, body) {
  var html = _.template($("#modal-warning-template").html())
      ({ title: title, body: body });
  htrace.showModal(html);
}

// Show a modal dialog box.
htrace.showModal = function(html) {
  var el = $("#modal");
  el.html(html);
  // Dismiss the modal dialog box when enter is pressed.
  $(document).on("keypress", function(e) {
    if (e.which === 13) {
      $(document).off('keypress');
      $('#modal button:first', $(this)).click();
      return false;
    }
  });
  el.modal();
};
