/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2012 Nick Gnedin 
All rights reserved.

This file may be distributed and/or modified under the terms of the
GNU General Public License version 2 as published by the Free Software
Foundation and appearing in the file LICENSE.GPL included in the
packaging of this file.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/

//
//  GUI widgets that control a single key
//

#ifndef IGGWIDGETKEYHANDLER_H
#define IGGWIDGETKEYHANDLER_H


#include "iggwidget.h"


class iObjectKey;
template<class T> class iPointerArray;

class iggDataTypeProvider;
class iggFrame;


//
//  Non-template base class
//
class iggWidgetKeyHandlerBase : public iggWidget
{

	friend class iggFrame;
	friend class iggFrameBoxSize;

public:

	virtual bool CheckBaloonHelpStatus();

	virtual void SetRenderMode(int m);
	int GetRenderMode() const;

	static void SetGlobalRenderMode(int m);
	static inline int GetGlobalRenderMode(){ return mGlobalRenderMode; }

	void SetSelfChecking(bool s);
    void SetIndex(int i);

	void AttachDataTypeProvider(const iggDataTypeProvider *provider);

#ifdef I_CHECK1
	//
	//  For internal checking
	//
	static void SetCheckNullIndexKeys(bool s);
#endif

protected:

	iggWidgetKeyHandlerBase(int type, const iObjectKey &key, int rm, iggFrame *parent, int index, const iObjectKey *indkey);
	virtual ~iggWidgetKeyHandlerBase();

	const iObjectKey& GetKey() const;
	const iObjectKey& Translate(const iObjectKey &key) const;
	void UpdateHelp();

	bool mSelfChecking;
	const int mType;
	int mIndex;
	const iObjectKey *mIndexKey;

	const iggDataTypeProvider *mProvider;

	//
	//  Registry functionality
	//
	static iPointerArray<iggWidgetKeyHandlerBase> &VariableLimitsList();
	static iPointerArray<iggWidgetKeyHandlerBase> &PositionList();
	static iPointerArray<iggWidgetKeyHandlerBase> &List();

#ifdef I_CHECK1
	//
	//  For internal checking
	//
	static bool mCheckNullIndexKeys;
#endif

private:

	const iObjectKey &mKey;  // Main key must be accessed via GetKey() 
	int mRenderMode; // RenderMode should be accessed via GetRenderMode always
	static int mGlobalRenderMode;
};


template <class T>
class iggWidgetKeyHandler : public iggWidgetKeyHandlerBase
{

public:

	inline T GetValue() const { return mValue; }

	virtual bool ExecuteControl(bool final);
	virtual bool ExecuteControl(bool final, T val);

	void SetActionKey(bool s){ mActionKey = s; }

protected:

	iggWidgetKeyHandler(int type, const iObjectKey &key, int rm, iggFrame *parent, int index, const iObjectKey *indkey);

	virtual void UpdateWidgetBody();
	virtual void QueryValue(T &v) const = 0;
	virtual void UpdateValue(T v) = 0;

	T mValue;
	bool mActionKey;
};

//
//  This is a dummy invisible widget, which is controlled by PushValue and PullValue functions
//
template <class T>
class iggWidgetKeyDummy : public iggWidgetKeyHandler<T>
{

public:

	iggWidgetKeyDummy(const iObjectKey &key, iggFrame *parent, int index, const iObjectKey *indkey);

	void SetValue(T v);

protected:

	virtual void QueryValue(T &v) const;
	virtual void UpdateValue(T v);
};

#endif  // IGGWIDGETKEYHANDLER_H

