/*****************************************************************************
 * This file is generated by test_api.py. Do not change it manually
 *****************************************************************************/

/*****************************************************************************
 Copyright (c) 2021-2023, Intel Corporation

 Redistribution and use in source and binary forms, with or without
 modification, are permitted provided that the following conditions are met:

     * Redistributions of source code must retain the above copyright notice,
       this list of conditions and the following disclaimer.
     * Redistributions in binary form must reproduce the above copyright
       notice, this list of conditions and the following disclaimer in the
       documentation and/or other materials provided with the distribution.
     * Neither the name of Intel Corporation nor the names of its contributors
       may be used to endorse or promote products derived from this software
       without specific prior written permission.

 THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
 FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*****************************************************************************/

#include <stdint.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <setjmp.h>
#include <signal.h>

#include <intel-ipsec-mb.h>
#include "gcm_ctr_vectors_test.h"
#include "utils.h"

#ifdef _WIN32
#define __func__ __FUNCTION__
#endif

#define BUFF_SIZE 4
#define MAX_BUFFS 17

int
direct_api_param_test(struct IMB_MGR *mb_mgr);

/* Check if imb_errno contains unexpected value */
static int
unexpected_err(IMB_MGR *mgr, const IMB_ERR expected_err, const char *func_desc)
{
        const IMB_ERR err = imb_get_errno(mgr);

        if (err != expected_err) {
                printf("%s error: expected %s, got %s\n", func_desc, imb_get_strerror(expected_err),
                       imb_get_strerror(err));
                return 1;
        }
        return 0;
}

#ifdef _WIN32
#define __func__ __FUNCTION__
#endif

/* Used to restore environment after potential segfaults */
jmp_buf dir_api_param_env;

#ifndef DEBUG
#ifndef _WIN32
static void
seg_handler(int signum) __attribute__((noreturn));
#endif
/* Signal handler to handle segfaults */
static void
seg_handler(int signum)
{
        (void) signum; /* unused */

        signal(SIGSEGV, seg_handler);  /* reset handler */
        longjmp(dir_api_param_env, 1); /* reset dir_api_param_env */
}
#endif /* DEBUG */

/*
 * @brief Performs direct API invalid param tests for IMB_AES_KEYEXP_128 */
static int
test_IMB_AES_KEYEXP_128(struct IMB_MGR *mgr)
{
        unsigned i = 1;
        const uint8_t key[BUFF_SIZE];
        uint8_t enc_exp_key[BUFF_SIZE];
        uint8_t dec_exp_key[BUFF_SIZE];
        int seg_err; /* segfault flag */

        seg_err = setjmp(dir_api_param_env);
        if (seg_err) {
                printf("%s: segfault occurred!", __func__);
                return 1;
        }

        struct fn_args {
                const void *key;
                void *enc_exp_key;
                void *dec_exp_key;
                const IMB_ERR exp_err;
        } fn_args[] = { { NULL, enc_exp_key, dec_exp_key, IMB_ERR_NULL_KEY },
                        { key, NULL, dec_exp_key, IMB_ERR_NULL_EXP_KEY },
                        { key, enc_exp_key, NULL, IMB_ERR_NULL_EXP_KEY } };

        /* Iterate over args */
        for (i = 0; i < DIM(fn_args); i++) {
                const struct fn_args *ap = &fn_args[i];

                IMB_AES_KEYEXP_128(mgr, ap->key, ap->enc_exp_key, ap->dec_exp_key);
                if (unexpected_err(mgr, ap->exp_err, "IMB_AES_KEYEXP_128"))
                        return 1;
        }
        return 0;
}

/*
 * @brief Performs direct API invalid param tests for IMB_AES_KEYEXP_192 */
static int
test_IMB_AES_KEYEXP_192(struct IMB_MGR *mgr)
{
        unsigned i = 1;
        const uint8_t key[BUFF_SIZE];
        uint8_t enc_exp_key[BUFF_SIZE];
        uint8_t dec_exp_key[BUFF_SIZE];
        int seg_err; /* segfault flag */

        seg_err = setjmp(dir_api_param_env);
        if (seg_err) {
                printf("%s: segfault occurred!", __func__);
                return 1;
        }

        struct fn_args {
                const void *key;
                void *enc_exp_key;
                void *dec_exp_key;
                const IMB_ERR exp_err;
        } fn_args[] = { { NULL, enc_exp_key, dec_exp_key, IMB_ERR_NULL_KEY },
                        { key, NULL, dec_exp_key, IMB_ERR_NULL_EXP_KEY },
                        { key, enc_exp_key, NULL, IMB_ERR_NULL_EXP_KEY } };

        /* Iterate over args */
        for (i = 0; i < DIM(fn_args); i++) {
                const struct fn_args *ap = &fn_args[i];

                IMB_AES_KEYEXP_192(mgr, ap->key, ap->enc_exp_key, ap->dec_exp_key);
                if (unexpected_err(mgr, ap->exp_err, "IMB_AES_KEYEXP_192"))
                        return 1;
        }
        return 0;
}

/*
 * @brief Performs direct API invalid param tests for IMB_AES_KEYEXP_256 */
static int
test_IMB_AES_KEYEXP_256(struct IMB_MGR *mgr)
{
        unsigned i = 1;
        const uint8_t key[BUFF_SIZE];
        uint8_t enc_exp_key[BUFF_SIZE];
        uint8_t dec_exp_key[BUFF_SIZE];
        int seg_err; /* segfault flag */

        seg_err = setjmp(dir_api_param_env);
        if (seg_err) {
                printf("%s: segfault occurred!", __func__);
                return 1;
        }

        struct fn_args {
                const void *key;
                void *enc_exp_key;
                void *dec_exp_key;
                const IMB_ERR exp_err;
        } fn_args[] = { { NULL, enc_exp_key, dec_exp_key, IMB_ERR_NULL_KEY },
                        { key, NULL, dec_exp_key, IMB_ERR_NULL_EXP_KEY },
                        { key, enc_exp_key, NULL, IMB_ERR_NULL_EXP_KEY } };

        /* Iterate over args */
        for (i = 0; i < DIM(fn_args); i++) {
                const struct fn_args *ap = &fn_args[i];

                IMB_AES_KEYEXP_256(mgr, ap->key, ap->enc_exp_key, ap->dec_exp_key);
                if (unexpected_err(mgr, ap->exp_err, "IMB_AES_KEYEXP_256"))
                        return 1;
        }
        return 0;
}

/*
 * @brief Performs direct API invalid param tests for
 * IMB_AES_CMAC_SUBKEY_GEN_128 */
static int
test_IMB_AES_CMAC_SUBKEY_GEN_128(struct IMB_MGR *mgr)
{
        unsigned i = 1;
        const uint8_t exp_key[BUFF_SIZE];
        uint8_t key1[BUFF_SIZE];
        uint8_t key2[BUFF_SIZE];
        int seg_err; /* segfault flag */

        seg_err = setjmp(dir_api_param_env);
        if (seg_err) {
                printf("%s: segfault occurred!", __func__);
                return 1;
        }

        struct fn_args {
                const void *exp_key;
                void *key1;
                void *key2;
                const IMB_ERR exp_err;
        } fn_args[] = { { NULL, key1, key2, IMB_ERR_NULL_EXP_KEY },
                        { exp_key, NULL, key2, IMB_ERR_NULL_KEY },
                        { exp_key, key1, NULL, IMB_ERR_NULL_KEY } };

        /* Iterate over args */
        for (i = 0; i < DIM(fn_args); i++) {
                const struct fn_args *ap = &fn_args[i];

                IMB_AES_CMAC_SUBKEY_GEN_128(mgr, ap->exp_key, ap->key1, ap->key2);
                if (unexpected_err(mgr, ap->exp_err, "IMB_AES_CMAC_SUBKEY_GEN_128"))
                        return 1;
        }
        return 0;
}

/*
 * @brief Performs direct API invalid param tests for IMB_AES_XCBC_KEYEXP */
static int
test_IMB_AES_XCBC_KEYEXP(struct IMB_MGR *mgr)
{
        unsigned i = 1;
        const uint8_t key[BUFF_SIZE];
        uint8_t exp_key[BUFF_SIZE];
        uint8_t exp_key2[BUFF_SIZE];
        uint8_t exp_key3[BUFF_SIZE];
        int seg_err; /* segfault flag */

        seg_err = setjmp(dir_api_param_env);
        if (seg_err) {
                printf("%s: segfault occurred!", __func__);
                return 1;
        }

        struct fn_args {
                const void *key;
                void *exp_key;
                void *exp_key2;
                void *exp_key3;
                const IMB_ERR exp_err;
        } fn_args[] = { { NULL, exp_key, exp_key2, exp_key3, IMB_ERR_NULL_KEY },
                        { key, NULL, exp_key2, exp_key3, IMB_ERR_NULL_EXP_KEY },
                        { key, exp_key, NULL, exp_key3, IMB_ERR_NULL_EXP_KEY },
                        { key, exp_key, exp_key2, NULL, IMB_ERR_NULL_EXP_KEY } };

        /* Iterate over args */
        for (i = 0; i < DIM(fn_args); i++) {
                const struct fn_args *ap = &fn_args[i];

                IMB_AES_XCBC_KEYEXP(mgr, ap->key, ap->exp_key, ap->exp_key2, ap->exp_key3);
                if (unexpected_err(mgr, ap->exp_err, "IMB_AES_XCBC_KEYEXP"))
                        return 1;
        }
        return 0;
}

/*
 * @brief Performs direct API invalid param tests for IMB_DES_KEYSCHED */
static int
test_IMB_DES_KEYSCHED(struct IMB_MGR *mgr)
{
        unsigned i = 1;
        uint64_t exp_key[BUFF_SIZE];
        const uint8_t key[BUFF_SIZE];
        int seg_err; /* segfault flag */

        seg_err = setjmp(dir_api_param_env);
        if (seg_err) {
                printf("%s: segfault occurred!", __func__);
                return 1;
        }

        struct fn_args {
                uint64_t *exp_key;
                const void *key;
                const IMB_ERR exp_err;
        } fn_args[] = { { NULL, key, IMB_ERR_NULL_EXP_KEY }, { exp_key, NULL, IMB_ERR_NULL_KEY } };

        /* Iterate over args */
        for (i = 0; i < DIM(fn_args); i++) {
                const struct fn_args *ap = &fn_args[i];

                IMB_DES_KEYSCHED(mgr, ap->exp_key, ap->key);
                if (unexpected_err(mgr, ap->exp_err, "IMB_DES_KEYSCHED"))
                        return 1;
        }
        return 0;
}

/*
 * @brief Performs direct API invalid param tests for IMB_SHA1_ONE_BLOCK */
static int
test_IMB_SHA1_ONE_BLOCK(struct IMB_MGR *mgr)
{
        unsigned i = 1;
        const uint8_t src[BUFF_SIZE];
        uint8_t tag[BUFF_SIZE];
        int seg_err; /* segfault flag */

        seg_err = setjmp(dir_api_param_env);
        if (seg_err) {
                printf("%s: segfault occurred!", __func__);
                return 1;
        }

        struct fn_args {
                const void *src;
                void *tag;
                const IMB_ERR exp_err;
        } fn_args[] = { { NULL, tag, IMB_ERR_NULL_SRC }, { src, NULL, IMB_ERR_NULL_AUTH } };

        /* Iterate over args */
        for (i = 0; i < DIM(fn_args); i++) {
                const struct fn_args *ap = &fn_args[i];

                IMB_SHA1_ONE_BLOCK(mgr, ap->src, ap->tag);
                if (unexpected_err(mgr, ap->exp_err, "IMB_SHA1_ONE_BLOCK"))
                        return 1;
        }
        return 0;
}

/*
 * @brief Performs direct API invalid param tests for IMB_SHA224_ONE_BLOCK */
static int
test_IMB_SHA224_ONE_BLOCK(struct IMB_MGR *mgr)
{
        unsigned i = 1;
        const uint8_t src[BUFF_SIZE];
        uint8_t tag[BUFF_SIZE];
        int seg_err; /* segfault flag */

        seg_err = setjmp(dir_api_param_env);
        if (seg_err) {
                printf("%s: segfault occurred!", __func__);
                return 1;
        }

        struct fn_args {
                const void *src;
                void *tag;
                const IMB_ERR exp_err;
        } fn_args[] = { { NULL, tag, IMB_ERR_NULL_SRC }, { src, NULL, IMB_ERR_NULL_AUTH } };

        /* Iterate over args */
        for (i = 0; i < DIM(fn_args); i++) {
                const struct fn_args *ap = &fn_args[i];

                IMB_SHA224_ONE_BLOCK(mgr, ap->src, ap->tag);
                if (unexpected_err(mgr, ap->exp_err, "IMB_SHA224_ONE_BLOCK"))
                        return 1;
        }
        return 0;
}

/*
 * @brief Performs direct API invalid param tests for IMB_SHA256_ONE_BLOCK */
static int
test_IMB_SHA256_ONE_BLOCK(struct IMB_MGR *mgr)
{
        unsigned i = 1;
        const uint8_t src[BUFF_SIZE];
        uint8_t tag[BUFF_SIZE];
        int seg_err; /* segfault flag */

        seg_err = setjmp(dir_api_param_env);
        if (seg_err) {
                printf("%s: segfault occurred!", __func__);
                return 1;
        }

        struct fn_args {
                const void *src;
                void *tag;
                const IMB_ERR exp_err;
        } fn_args[] = { { NULL, tag, IMB_ERR_NULL_SRC }, { src, NULL, IMB_ERR_NULL_AUTH } };

        /* Iterate over args */
        for (i = 0; i < DIM(fn_args); i++) {
                const struct fn_args *ap = &fn_args[i];

                IMB_SHA256_ONE_BLOCK(mgr, ap->src, ap->tag);
                if (unexpected_err(mgr, ap->exp_err, "IMB_SHA256_ONE_BLOCK"))
                        return 1;
        }
        return 0;
}

/*
 * @brief Performs direct API invalid param tests for IMB_SHA384_ONE_BLOCK */
static int
test_IMB_SHA384_ONE_BLOCK(struct IMB_MGR *mgr)
{
        unsigned i = 1;
        const uint8_t src[BUFF_SIZE];
        uint8_t tag[BUFF_SIZE];
        int seg_err; /* segfault flag */

        seg_err = setjmp(dir_api_param_env);
        if (seg_err) {
                printf("%s: segfault occurred!", __func__);
                return 1;
        }

        struct fn_args {
                const void *src;
                void *tag;
                const IMB_ERR exp_err;
        } fn_args[] = { { NULL, tag, IMB_ERR_NULL_SRC }, { src, NULL, IMB_ERR_NULL_AUTH } };

        /* Iterate over args */
        for (i = 0; i < DIM(fn_args); i++) {
                const struct fn_args *ap = &fn_args[i];

                IMB_SHA384_ONE_BLOCK(mgr, ap->src, ap->tag);
                if (unexpected_err(mgr, ap->exp_err, "IMB_SHA384_ONE_BLOCK"))
                        return 1;
        }
        return 0;
}

/*
 * @brief Performs direct API invalid param tests for IMB_SHA512_ONE_BLOCK */
static int
test_IMB_SHA512_ONE_BLOCK(struct IMB_MGR *mgr)
{
        unsigned i = 1;
        const uint8_t src[BUFF_SIZE];
        uint8_t tag[BUFF_SIZE];
        int seg_err; /* segfault flag */

        seg_err = setjmp(dir_api_param_env);
        if (seg_err) {
                printf("%s: segfault occurred!", __func__);
                return 1;
        }

        struct fn_args {
                const void *src;
                void *tag;
                const IMB_ERR exp_err;
        } fn_args[] = { { NULL, tag, IMB_ERR_NULL_SRC }, { src, NULL, IMB_ERR_NULL_AUTH } };

        /* Iterate over args */
        for (i = 0; i < DIM(fn_args); i++) {
                const struct fn_args *ap = &fn_args[i];

                IMB_SHA512_ONE_BLOCK(mgr, ap->src, ap->tag);
                if (unexpected_err(mgr, ap->exp_err, "IMB_SHA512_ONE_BLOCK"))
                        return 1;
        }
        return 0;
}

/*
 * @brief Performs direct API invalid param tests for IMB_MD5_ONE_BLOCK */
static int
test_IMB_MD5_ONE_BLOCK(struct IMB_MGR *mgr)
{
        unsigned i = 1;
        const uint8_t src[BUFF_SIZE];
        uint8_t tag[BUFF_SIZE];
        int seg_err; /* segfault flag */

        seg_err = setjmp(dir_api_param_env);
        if (seg_err) {
                printf("%s: segfault occurred!", __func__);
                return 1;
        }

        struct fn_args {
                const void *src;
                void *tag;
                const IMB_ERR exp_err;
        } fn_args[] = { { NULL, tag, IMB_ERR_NULL_SRC }, { src, NULL, IMB_ERR_NULL_AUTH } };

        /* Iterate over args */
        for (i = 0; i < DIM(fn_args); i++) {
                const struct fn_args *ap = &fn_args[i];

                IMB_MD5_ONE_BLOCK(mgr, ap->src, ap->tag);
                if (unexpected_err(mgr, ap->exp_err, "IMB_MD5_ONE_BLOCK"))
                        return 1;
        }
        return 0;
}

/*
 * @brief Performs direct API invalid param tests for IMB_SHA1 */
static int
test_IMB_SHA1(struct IMB_MGR *mgr)
{
        unsigned i = 1;
        const uint8_t src[BUFF_SIZE];
        const uint64_t length = 1;
        uint8_t tag[BUFF_SIZE];
        int seg_err; /* segfault flag */

        seg_err = setjmp(dir_api_param_env);
        if (seg_err) {
                printf("%s: segfault occurred!", __func__);
                return 1;
        }

        struct fn_args {
                const void *src;
                const uint64_t length;
                void *tag;
                const IMB_ERR exp_err;
        } fn_args[] = { { NULL, length, tag, IMB_ERR_NULL_SRC },
                        { src, length, NULL, IMB_ERR_NULL_AUTH } };

        /* Iterate over args */
        for (i = 0; i < DIM(fn_args); i++) {
                const struct fn_args *ap = &fn_args[i];

                IMB_SHA1(mgr, ap->src, ap->length, ap->tag);
                if (unexpected_err(mgr, ap->exp_err, "IMB_SHA1"))
                        return 1;
        }
        return 0;
}

/*
 * @brief Performs direct API invalid param tests for IMB_SHA224 */
static int
test_IMB_SHA224(struct IMB_MGR *mgr)
{
        unsigned i = 1;
        const uint8_t src[BUFF_SIZE];
        const uint64_t length = 1;
        uint8_t tag[BUFF_SIZE];
        int seg_err; /* segfault flag */

        seg_err = setjmp(dir_api_param_env);
        if (seg_err) {
                printf("%s: segfault occurred!", __func__);
                return 1;
        }

        struct fn_args {
                const void *src;
                const uint64_t length;
                void *tag;
                const IMB_ERR exp_err;
        } fn_args[] = { { NULL, length, tag, IMB_ERR_NULL_SRC },
                        { src, length, NULL, IMB_ERR_NULL_AUTH } };

        /* Iterate over args */
        for (i = 0; i < DIM(fn_args); i++) {
                const struct fn_args *ap = &fn_args[i];

                IMB_SHA224(mgr, ap->src, ap->length, ap->tag);
                if (unexpected_err(mgr, ap->exp_err, "IMB_SHA224"))
                        return 1;
        }
        return 0;
}

/*
 * @brief Performs direct API invalid param tests for IMB_SHA256 */
static int
test_IMB_SHA256(struct IMB_MGR *mgr)
{
        unsigned i = 1;
        const uint8_t src[BUFF_SIZE];
        const uint64_t length = 1;
        uint8_t tag[BUFF_SIZE];
        int seg_err; /* segfault flag */

        seg_err = setjmp(dir_api_param_env);
        if (seg_err) {
                printf("%s: segfault occurred!", __func__);
                return 1;
        }

        struct fn_args {
                const void *src;
                const uint64_t length;
                void *tag;
                const IMB_ERR exp_err;
        } fn_args[] = { { NULL, length, tag, IMB_ERR_NULL_SRC },
                        { src, length, NULL, IMB_ERR_NULL_AUTH } };

        /* Iterate over args */
        for (i = 0; i < DIM(fn_args); i++) {
                const struct fn_args *ap = &fn_args[i];

                IMB_SHA256(mgr, ap->src, ap->length, ap->tag);
                if (unexpected_err(mgr, ap->exp_err, "IMB_SHA256"))
                        return 1;
        }
        return 0;
}

/*
 * @brief Performs direct API invalid param tests for IMB_SHA384 */
static int
test_IMB_SHA384(struct IMB_MGR *mgr)
{
        unsigned i = 1;
        const uint8_t src[BUFF_SIZE];
        const uint64_t length = 1;
        uint8_t tag[BUFF_SIZE];
        int seg_err; /* segfault flag */

        seg_err = setjmp(dir_api_param_env);
        if (seg_err) {
                printf("%s: segfault occurred!", __func__);
                return 1;
        }

        struct fn_args {
                const void *src;
                const uint64_t length;
                void *tag;
                const IMB_ERR exp_err;
        } fn_args[] = { { NULL, length, tag, IMB_ERR_NULL_SRC },
                        { src, length, NULL, IMB_ERR_NULL_AUTH } };

        /* Iterate over args */
        for (i = 0; i < DIM(fn_args); i++) {
                const struct fn_args *ap = &fn_args[i];

                IMB_SHA384(mgr, ap->src, ap->length, ap->tag);
                if (unexpected_err(mgr, ap->exp_err, "IMB_SHA384"))
                        return 1;
        }
        return 0;
}

/*
 * @brief Performs direct API invalid param tests for IMB_SHA512 */
static int
test_IMB_SHA512(struct IMB_MGR *mgr)
{
        unsigned i = 1;
        const uint8_t src[BUFF_SIZE];
        const uint64_t length = 1;
        uint8_t tag[BUFF_SIZE];
        int seg_err; /* segfault flag */

        seg_err = setjmp(dir_api_param_env);
        if (seg_err) {
                printf("%s: segfault occurred!", __func__);
                return 1;
        }

        struct fn_args {
                const void *src;
                const uint64_t length;
                void *tag;
                const IMB_ERR exp_err;
        } fn_args[] = { { NULL, length, tag, IMB_ERR_NULL_SRC },
                        { src, length, NULL, IMB_ERR_NULL_AUTH } };

        /* Iterate over args */
        for (i = 0; i < DIM(fn_args); i++) {
                const struct fn_args *ap = &fn_args[i];

                IMB_SHA512(mgr, ap->src, ap->length, ap->tag);
                if (unexpected_err(mgr, ap->exp_err, "IMB_SHA512"))
                        return 1;
        }
        return 0;
}

/*
 * @brief Performs direct API invalid param tests for IMB_AES128_CFB_ONE */
static int
test_IMB_AES128_CFB_ONE(struct IMB_MGR *mgr)
{
        unsigned i = 1;
        uint8_t dst[BUFF_SIZE];
        const uint8_t src[BUFF_SIZE];
        const uint8_t iv[BUFF_SIZE];
        const uint8_t enc_exp_key[BUFF_SIZE];
        uint64_t len = 1;
        int seg_err; /* segfault flag */

        seg_err = setjmp(dir_api_param_env);
        if (seg_err) {
                printf("%s: segfault occurred!", __func__);
                return 1;
        }

        struct fn_args {
                void *dst;
                const void *src;
                const void *iv;
                const void *enc_exp_key;
                uint64_t len;
                const IMB_ERR exp_err;
        } fn_args[] = { { NULL, src, iv, enc_exp_key, len, IMB_ERR_NULL_DST },
                        { dst, NULL, iv, enc_exp_key, len, IMB_ERR_NULL_SRC },
                        { dst, src, NULL, enc_exp_key, len, IMB_ERR_NULL_IV },
                        { dst, src, iv, NULL, len, IMB_ERR_NULL_EXP_KEY } };

        /* Iterate over args */
        for (i = 0; i < DIM(fn_args); i++) {
                const struct fn_args *ap = &fn_args[i];

                IMB_AES128_CFB_ONE(mgr, ap->dst, ap->src, ap->iv, ap->enc_exp_key, ap->len);
                if (unexpected_err(mgr, ap->exp_err, "IMB_AES128_CFB_ONE"))
                        return 1;
        }
        return 0;
}

/*
 * @brief Performs direct API invalid param tests for IMB_AES128_GCM_ENC */
static int
test_IMB_AES128_GCM_ENC(struct IMB_MGR *mgr)
{
        unsigned i = 1;
        const struct gcm_key_data exp_key_s;
        const struct gcm_key_data *exp_key = &exp_key_s;
        struct gcm_context_data ctx_s;
        struct gcm_context_data *ctx = &ctx_s;
        uint8_t dst[BUFF_SIZE];
        uint8_t const src[BUFF_SIZE];
        uint64_t len = 1;
        const uint8_t iv[BUFF_SIZE];
        uint8_t const aad[BUFF_SIZE];
        uint64_t aadl = 1;
        uint8_t tag[BUFF_SIZE];
        uint64_t tagl = 1;
        int seg_err; /* segfault flag */

        seg_err = setjmp(dir_api_param_env);
        if (seg_err) {
                printf("%s: segfault occurred!", __func__);
                return 1;
        }

        struct fn_args {
                const struct gcm_key_data *exp_key;
                struct gcm_context_data *ctx;
                uint8_t *dst;
                uint8_t const *src;
                uint64_t len;
                const uint8_t *iv;
                uint8_t const *aad;
                uint64_t aadl;
                uint8_t *tag;
                uint64_t tagl;
                const IMB_ERR exp_err;
        } fn_args[] = {
                { NULL, ctx, dst, src, len, iv, aad, aadl, tag, tagl, IMB_ERR_NULL_EXP_KEY },
                { exp_key, NULL, dst, src, len, iv, aad, aadl, tag, tagl, IMB_ERR_NULL_CTX },
                { exp_key, ctx, NULL, src, len, iv, aad, aadl, tag, tagl, IMB_ERR_NULL_DST },
                { exp_key, ctx, dst, NULL, len, iv, aad, aadl, tag, tagl, IMB_ERR_NULL_SRC },
                { exp_key, ctx, dst, src, ((1ULL << 39) - 256), iv, aad, aadl, tag, tagl,
                  IMB_ERR_CIPH_LEN },
                { exp_key, ctx, dst, src, len, NULL, aad, aadl, tag, tagl, IMB_ERR_NULL_IV },
                { exp_key, ctx, dst, src, len, iv, NULL, aadl, tag, tagl, IMB_ERR_NULL_AAD },
                { exp_key, ctx, dst, src, len, iv, aad, aadl, NULL, tagl, IMB_ERR_NULL_AUTH },
                { exp_key, ctx, dst, src, len, iv, aad, aadl, tag, ((1ULL << 39) - 256),
                  IMB_ERR_AUTH_TAG_LEN }
        };

        /* Iterate over args */
        for (i = 0; i < DIM(fn_args); i++) {
                const struct fn_args *ap = &fn_args[i];

                IMB_AES128_GCM_ENC(mgr, ap->exp_key, ap->ctx, ap->dst, ap->src, ap->len, ap->iv,
                                   ap->aad, ap->aadl, ap->tag, ap->tagl);
                if (unexpected_err(mgr, ap->exp_err, "IMB_AES128_GCM_ENC"))
                        return 1;
        }
        return 0;
}

/*
 * @brief Performs direct API invalid param tests for IMB_AES192_GCM_ENC */
static int
test_IMB_AES192_GCM_ENC(struct IMB_MGR *mgr)
{
        unsigned i = 1;
        const struct gcm_key_data exp_key_s;
        const struct gcm_key_data *exp_key = &exp_key_s;
        struct gcm_context_data ctx_s;
        struct gcm_context_data *ctx = &ctx_s;
        uint8_t dst[BUFF_SIZE];
        uint8_t const src[BUFF_SIZE];
        uint64_t len = 1;
        const uint8_t iv[BUFF_SIZE];
        uint8_t const aad[BUFF_SIZE];
        uint64_t aadl = 1;
        uint8_t tag[BUFF_SIZE];
        uint64_t tagl = 1;
        int seg_err; /* segfault flag */

        seg_err = setjmp(dir_api_param_env);
        if (seg_err) {
                printf("%s: segfault occurred!", __func__);
                return 1;
        }

        struct fn_args {
                const struct gcm_key_data *exp_key;
                struct gcm_context_data *ctx;
                uint8_t *dst;
                uint8_t const *src;
                uint64_t len;
                const uint8_t *iv;
                uint8_t const *aad;
                uint64_t aadl;
                uint8_t *tag;
                uint64_t tagl;
                const IMB_ERR exp_err;
        } fn_args[] = {
                { NULL, ctx, dst, src, len, iv, aad, aadl, tag, tagl, IMB_ERR_NULL_EXP_KEY },
                { exp_key, NULL, dst, src, len, iv, aad, aadl, tag, tagl, IMB_ERR_NULL_CTX },
                { exp_key, ctx, NULL, src, len, iv, aad, aadl, tag, tagl, IMB_ERR_NULL_DST },
                { exp_key, ctx, dst, NULL, len, iv, aad, aadl, tag, tagl, IMB_ERR_NULL_SRC },
                { exp_key, ctx, dst, src, ((1ULL << 39) - 256), iv, aad, aadl, tag, tagl,
                  IMB_ERR_CIPH_LEN },
                { exp_key, ctx, dst, src, len, NULL, aad, aadl, tag, tagl, IMB_ERR_NULL_IV },
                { exp_key, ctx, dst, src, len, iv, NULL, aadl, tag, tagl, IMB_ERR_NULL_AAD },
                { exp_key, ctx, dst, src, len, iv, aad, aadl, NULL, tagl, IMB_ERR_NULL_AUTH },
                { exp_key, ctx, dst, src, len, iv, aad, aadl, tag, ((1ULL << 39) - 256),
                  IMB_ERR_AUTH_TAG_LEN }
        };

        /* Iterate over args */
        for (i = 0; i < DIM(fn_args); i++) {
                const struct fn_args *ap = &fn_args[i];

                IMB_AES192_GCM_ENC(mgr, ap->exp_key, ap->ctx, ap->dst, ap->src, ap->len, ap->iv,
                                   ap->aad, ap->aadl, ap->tag, ap->tagl);
                if (unexpected_err(mgr, ap->exp_err, "IMB_AES192_GCM_ENC"))
                        return 1;
        }
        return 0;
}

/*
 * @brief Performs direct API invalid param tests for IMB_AES256_GCM_ENC */
static int
test_IMB_AES256_GCM_ENC(struct IMB_MGR *mgr)
{
        unsigned i = 1;
        const struct gcm_key_data exp_key_s;
        const struct gcm_key_data *exp_key = &exp_key_s;
        struct gcm_context_data ctx_s;
        struct gcm_context_data *ctx = &ctx_s;
        uint8_t dst[BUFF_SIZE];
        uint8_t const src[BUFF_SIZE];
        uint64_t len = 1;
        const uint8_t iv[BUFF_SIZE];
        uint8_t const aad[BUFF_SIZE];
        uint64_t aadl = 1;
        uint8_t tag[BUFF_SIZE];
        uint64_t tagl = 1;
        int seg_err; /* segfault flag */

        seg_err = setjmp(dir_api_param_env);
        if (seg_err) {
                printf("%s: segfault occurred!", __func__);
                return 1;
        }

        struct fn_args {
                const struct gcm_key_data *exp_key;
                struct gcm_context_data *ctx;
                uint8_t *dst;
                uint8_t const *src;
                uint64_t len;
                const uint8_t *iv;
                uint8_t const *aad;
                uint64_t aadl;
                uint8_t *tag;
                uint64_t tagl;
                const IMB_ERR exp_err;
        } fn_args[] = {
                { NULL, ctx, dst, src, len, iv, aad, aadl, tag, tagl, IMB_ERR_NULL_EXP_KEY },
                { exp_key, NULL, dst, src, len, iv, aad, aadl, tag, tagl, IMB_ERR_NULL_CTX },
                { exp_key, ctx, NULL, src, len, iv, aad, aadl, tag, tagl, IMB_ERR_NULL_DST },
                { exp_key, ctx, dst, NULL, len, iv, aad, aadl, tag, tagl, IMB_ERR_NULL_SRC },
                { exp_key, ctx, dst, src, ((1ULL << 39) - 256), iv, aad, aadl, tag, tagl,
                  IMB_ERR_CIPH_LEN },
                { exp_key, ctx, dst, src, len, NULL, aad, aadl, tag, tagl, IMB_ERR_NULL_IV },
                { exp_key, ctx, dst, src, len, iv, NULL, aadl, tag, tagl, IMB_ERR_NULL_AAD },
                { exp_key, ctx, dst, src, len, iv, aad, aadl, NULL, tagl, IMB_ERR_NULL_AUTH },
                { exp_key, ctx, dst, src, len, iv, aad, aadl, tag, ((1ULL << 39) - 256),
                  IMB_ERR_AUTH_TAG_LEN }
        };

        /* Iterate over args */
        for (i = 0; i < DIM(fn_args); i++) {
                const struct fn_args *ap = &fn_args[i];

                IMB_AES256_GCM_ENC(mgr, ap->exp_key, ap->ctx, ap->dst, ap->src, ap->len, ap->iv,
                                   ap->aad, ap->aadl, ap->tag, ap->tagl);
                if (unexpected_err(mgr, ap->exp_err, "IMB_AES256_GCM_ENC"))
                        return 1;
        }
        return 0;
}

/*
 * @brief Performs direct API invalid param tests for IMB_AES128_GCM_DEC */
static int
test_IMB_AES128_GCM_DEC(struct IMB_MGR *mgr)
{
        unsigned i = 1;
        const struct gcm_key_data exp_key_s;
        const struct gcm_key_data *exp_key = &exp_key_s;
        struct gcm_context_data ctx_s;
        struct gcm_context_data *ctx = &ctx_s;
        uint8_t dst[BUFF_SIZE];
        uint8_t const src[BUFF_SIZE];
        uint64_t len = 1;
        const uint8_t iv[BUFF_SIZE];
        uint8_t const aad[BUFF_SIZE];
        uint64_t aadl = 1;
        uint8_t tag[BUFF_SIZE];
        uint64_t tagl = 1;
        int seg_err; /* segfault flag */

        seg_err = setjmp(dir_api_param_env);
        if (seg_err) {
                printf("%s: segfault occurred!", __func__);
                return 1;
        }

        struct fn_args {
                const struct gcm_key_data *exp_key;
                struct gcm_context_data *ctx;
                uint8_t *dst;
                uint8_t const *src;
                uint64_t len;
                const uint8_t *iv;
                uint8_t const *aad;
                uint64_t aadl;
                uint8_t *tag;
                uint64_t tagl;
                const IMB_ERR exp_err;
        } fn_args[] = {
                { NULL, ctx, dst, src, len, iv, aad, aadl, tag, tagl, IMB_ERR_NULL_EXP_KEY },
                { exp_key, NULL, dst, src, len, iv, aad, aadl, tag, tagl, IMB_ERR_NULL_CTX },
                { exp_key, ctx, NULL, src, len, iv, aad, aadl, tag, tagl, IMB_ERR_NULL_DST },
                { exp_key, ctx, dst, NULL, len, iv, aad, aadl, tag, tagl, IMB_ERR_NULL_SRC },
                { exp_key, ctx, dst, src, ((1ULL << 39) - 256), iv, aad, aadl, tag, tagl,
                  IMB_ERR_CIPH_LEN },
                { exp_key, ctx, dst, src, len, NULL, aad, aadl, tag, tagl, IMB_ERR_NULL_IV },
                { exp_key, ctx, dst, src, len, iv, NULL, aadl, tag, tagl, IMB_ERR_NULL_AAD },
                { exp_key, ctx, dst, src, len, iv, aad, aadl, NULL, tagl, IMB_ERR_NULL_AUTH },
                { exp_key, ctx, dst, src, len, iv, aad, aadl, tag, ((1ULL << 39) - 256),
                  IMB_ERR_AUTH_TAG_LEN }
        };

        /* Iterate over args */
        for (i = 0; i < DIM(fn_args); i++) {
                const struct fn_args *ap = &fn_args[i];

                IMB_AES128_GCM_DEC(mgr, ap->exp_key, ap->ctx, ap->dst, ap->src, ap->len, ap->iv,
                                   ap->aad, ap->aadl, ap->tag, ap->tagl);
                if (unexpected_err(mgr, ap->exp_err, "IMB_AES128_GCM_DEC"))
                        return 1;
        }
        return 0;
}

/*
 * @brief Performs direct API invalid param tests for IMB_AES192_GCM_DEC */
static int
test_IMB_AES192_GCM_DEC(struct IMB_MGR *mgr)
{
        unsigned i = 1;
        const struct gcm_key_data exp_key_s;
        const struct gcm_key_data *exp_key = &exp_key_s;
        struct gcm_context_data ctx_s;
        struct gcm_context_data *ctx = &ctx_s;
        uint8_t dst[BUFF_SIZE];
        uint8_t const src[BUFF_SIZE];
        uint64_t len = 1;
        const uint8_t iv[BUFF_SIZE];
        uint8_t const aad[BUFF_SIZE];
        uint64_t aadl = 1;
        uint8_t tag[BUFF_SIZE];
        uint64_t tagl = 1;
        int seg_err; /* segfault flag */

        seg_err = setjmp(dir_api_param_env);
        if (seg_err) {
                printf("%s: segfault occurred!", __func__);
                return 1;
        }

        struct fn_args {
                const struct gcm_key_data *exp_key;
                struct gcm_context_data *ctx;
                uint8_t *dst;
                uint8_t const *src;
                uint64_t len;
                const uint8_t *iv;
                uint8_t const *aad;
                uint64_t aadl;
                uint8_t *tag;
                uint64_t tagl;
                const IMB_ERR exp_err;
        } fn_args[] = {
                { NULL, ctx, dst, src, len, iv, aad, aadl, tag, tagl, IMB_ERR_NULL_EXP_KEY },
                { exp_key, NULL, dst, src, len, iv, aad, aadl, tag, tagl, IMB_ERR_NULL_CTX },
                { exp_key, ctx, NULL, src, len, iv, aad, aadl, tag, tagl, IMB_ERR_NULL_DST },
                { exp_key, ctx, dst, NULL, len, iv, aad, aadl, tag, tagl, IMB_ERR_NULL_SRC },
                { exp_key, ctx, dst, src, ((1ULL << 39) - 256), iv, aad, aadl, tag, tagl,
                  IMB_ERR_CIPH_LEN },
                { exp_key, ctx, dst, src, len, NULL, aad, aadl, tag, tagl, IMB_ERR_NULL_IV },
                { exp_key, ctx, dst, src, len, iv, NULL, aadl, tag, tagl, IMB_ERR_NULL_AAD },
                { exp_key, ctx, dst, src, len, iv, aad, aadl, NULL, tagl, IMB_ERR_NULL_AUTH },
                { exp_key, ctx, dst, src, len, iv, aad, aadl, tag, ((1ULL << 39) - 256),
                  IMB_ERR_AUTH_TAG_LEN }
        };

        /* Iterate over args */
        for (i = 0; i < DIM(fn_args); i++) {
                const struct fn_args *ap = &fn_args[i];

                IMB_AES192_GCM_DEC(mgr, ap->exp_key, ap->ctx, ap->dst, ap->src, ap->len, ap->iv,
                                   ap->aad, ap->aadl, ap->tag, ap->tagl);
                if (unexpected_err(mgr, ap->exp_err, "IMB_AES192_GCM_DEC"))
                        return 1;
        }
        return 0;
}

/*
 * @brief Performs direct API invalid param tests for IMB_AES256_GCM_DEC */
static int
test_IMB_AES256_GCM_DEC(struct IMB_MGR *mgr)
{
        unsigned i = 1;
        const struct gcm_key_data exp_key_s;
        const struct gcm_key_data *exp_key = &exp_key_s;
        struct gcm_context_data ctx_s;
        struct gcm_context_data *ctx = &ctx_s;
        uint8_t dst[BUFF_SIZE];
        uint8_t const src[BUFF_SIZE];
        uint64_t len = 1;
        const uint8_t iv[BUFF_SIZE];
        uint8_t const aad[BUFF_SIZE];
        uint64_t aadl = 1;
        uint8_t tag[BUFF_SIZE];
        uint64_t tagl = 1;
        int seg_err; /* segfault flag */

        seg_err = setjmp(dir_api_param_env);
        if (seg_err) {
                printf("%s: segfault occurred!", __func__);
                return 1;
        }

        struct fn_args {
                const struct gcm_key_data *exp_key;
                struct gcm_context_data *ctx;
                uint8_t *dst;
                uint8_t const *src;
                uint64_t len;
                const uint8_t *iv;
                uint8_t const *aad;
                uint64_t aadl;
                uint8_t *tag;
                uint64_t tagl;
                const IMB_ERR exp_err;
        } fn_args[] = {
                { NULL, ctx, dst, src, len, iv, aad, aadl, tag, tagl, IMB_ERR_NULL_EXP_KEY },
                { exp_key, NULL, dst, src, len, iv, aad, aadl, tag, tagl, IMB_ERR_NULL_CTX },
                { exp_key, ctx, NULL, src, len, iv, aad, aadl, tag, tagl, IMB_ERR_NULL_DST },
                { exp_key, ctx, dst, NULL, len, iv, aad, aadl, tag, tagl, IMB_ERR_NULL_SRC },
                { exp_key, ctx, dst, src, ((1ULL << 39) - 256), iv, aad, aadl, tag, tagl,
                  IMB_ERR_CIPH_LEN },
                { exp_key, ctx, dst, src, len, NULL, aad, aadl, tag, tagl, IMB_ERR_NULL_IV },
                { exp_key, ctx, dst, src, len, iv, NULL, aadl, tag, tagl, IMB_ERR_NULL_AAD },
                { exp_key, ctx, dst, src, len, iv, aad, aadl, NULL, tagl, IMB_ERR_NULL_AUTH },
                { exp_key, ctx, dst, src, len, iv, aad, aadl, tag, ((1ULL << 39) - 256),
                  IMB_ERR_AUTH_TAG_LEN }
        };

        /* Iterate over args */
        for (i = 0; i < DIM(fn_args); i++) {
                const struct fn_args *ap = &fn_args[i];

                IMB_AES256_GCM_DEC(mgr, ap->exp_key, ap->ctx, ap->dst, ap->src, ap->len, ap->iv,
                                   ap->aad, ap->aadl, ap->tag, ap->tagl);
                if (unexpected_err(mgr, ap->exp_err, "IMB_AES256_GCM_DEC"))
                        return 1;
        }
        return 0;
}

/*
 * @brief Performs direct API invalid param tests for IMB_AES128_GCM_INIT */
static int
test_IMB_AES128_GCM_INIT(struct IMB_MGR *mgr)
{
        unsigned i = 1;
        const struct gcm_key_data exp_key_s;
        const struct gcm_key_data *exp_key = &exp_key_s;
        struct gcm_context_data ctx_s;
        struct gcm_context_data *ctx = &ctx_s;
        const uint8_t iv[BUFF_SIZE];
        uint8_t const aad[BUFF_SIZE];
        uint64_t aadl = 1;
        int seg_err; /* segfault flag */

        seg_err = setjmp(dir_api_param_env);
        if (seg_err) {
                printf("%s: segfault occurred!", __func__);
                return 1;
        }

        struct fn_args {
                const struct gcm_key_data *exp_key;
                struct gcm_context_data *ctx;
                const uint8_t *iv;
                uint8_t const *aad;
                uint64_t aadl;
                const IMB_ERR exp_err;
        } fn_args[] = { { NULL, ctx, iv, aad, aadl, IMB_ERR_NULL_EXP_KEY },
                        { exp_key, NULL, iv, aad, aadl, IMB_ERR_NULL_CTX },
                        { exp_key, ctx, NULL, aad, aadl, IMB_ERR_NULL_IV },
                        { exp_key, ctx, iv, NULL, aadl, IMB_ERR_NULL_AAD } };

        /* Iterate over args */
        for (i = 0; i < DIM(fn_args); i++) {
                const struct fn_args *ap = &fn_args[i];

                IMB_AES128_GCM_INIT(mgr, ap->exp_key, ap->ctx, ap->iv, ap->aad, ap->aadl);
                if (unexpected_err(mgr, ap->exp_err, "IMB_AES128_GCM_INIT"))
                        return 1;
        }
        return 0;
}

/*
 * @brief Performs direct API invalid param tests for IMB_AES192_GCM_INIT */
static int
test_IMB_AES192_GCM_INIT(struct IMB_MGR *mgr)
{
        unsigned i = 1;
        const struct gcm_key_data exp_key_s;
        const struct gcm_key_data *exp_key = &exp_key_s;
        struct gcm_context_data ctx_s;
        struct gcm_context_data *ctx = &ctx_s;
        const uint8_t iv[BUFF_SIZE];
        uint8_t const aad[BUFF_SIZE];
        uint64_t aadl = 1;
        int seg_err; /* segfault flag */

        seg_err = setjmp(dir_api_param_env);
        if (seg_err) {
                printf("%s: segfault occurred!", __func__);
                return 1;
        }

        struct fn_args {
                const struct gcm_key_data *exp_key;
                struct gcm_context_data *ctx;
                const uint8_t *iv;
                uint8_t const *aad;
                uint64_t aadl;
                const IMB_ERR exp_err;
        } fn_args[] = { { NULL, ctx, iv, aad, aadl, IMB_ERR_NULL_EXP_KEY },
                        { exp_key, NULL, iv, aad, aadl, IMB_ERR_NULL_CTX },
                        { exp_key, ctx, NULL, aad, aadl, IMB_ERR_NULL_IV },
                        { exp_key, ctx, iv, NULL, aadl, IMB_ERR_NULL_AAD } };

        /* Iterate over args */
        for (i = 0; i < DIM(fn_args); i++) {
                const struct fn_args *ap = &fn_args[i];

                IMB_AES192_GCM_INIT(mgr, ap->exp_key, ap->ctx, ap->iv, ap->aad, ap->aadl);
                if (unexpected_err(mgr, ap->exp_err, "IMB_AES192_GCM_INIT"))
                        return 1;
        }
        return 0;
}

/*
 * @brief Performs direct API invalid param tests for IMB_AES256_GCM_INIT */
static int
test_IMB_AES256_GCM_INIT(struct IMB_MGR *mgr)
{
        unsigned i = 1;
        const struct gcm_key_data exp_key_s;
        const struct gcm_key_data *exp_key = &exp_key_s;
        struct gcm_context_data ctx_s;
        struct gcm_context_data *ctx = &ctx_s;
        const uint8_t iv[BUFF_SIZE];
        uint8_t const aad[BUFF_SIZE];
        uint64_t aadl = 1;
        int seg_err; /* segfault flag */

        seg_err = setjmp(dir_api_param_env);
        if (seg_err) {
                printf("%s: segfault occurred!", __func__);
                return 1;
        }

        struct fn_args {
                const struct gcm_key_data *exp_key;
                struct gcm_context_data *ctx;
                const uint8_t *iv;
                uint8_t const *aad;
                uint64_t aadl;
                const IMB_ERR exp_err;
        } fn_args[] = { { NULL, ctx, iv, aad, aadl, IMB_ERR_NULL_EXP_KEY },
                        { exp_key, NULL, iv, aad, aadl, IMB_ERR_NULL_CTX },
                        { exp_key, ctx, NULL, aad, aadl, IMB_ERR_NULL_IV },
                        { exp_key, ctx, iv, NULL, aadl, IMB_ERR_NULL_AAD } };

        /* Iterate over args */
        for (i = 0; i < DIM(fn_args); i++) {
                const struct fn_args *ap = &fn_args[i];

                IMB_AES256_GCM_INIT(mgr, ap->exp_key, ap->ctx, ap->iv, ap->aad, ap->aadl);
                if (unexpected_err(mgr, ap->exp_err, "IMB_AES256_GCM_INIT"))
                        return 1;
        }
        return 0;
}

/*
 * @brief Performs direct API invalid param tests for IMB_AES128_GCM_ENC_UPDATE
 */
static int
test_IMB_AES128_GCM_ENC_UPDATE(struct IMB_MGR *mgr)
{
        unsigned i = 1;
        const struct gcm_key_data exp_key_s;
        const struct gcm_key_data *exp_key = &exp_key_s;
        struct gcm_context_data ctx_s;
        struct gcm_context_data *ctx = &ctx_s;
        uint8_t dst[BUFF_SIZE];
        const uint8_t src[BUFF_SIZE];
        uint64_t len = 1;
        int seg_err; /* segfault flag */

        seg_err = setjmp(dir_api_param_env);
        if (seg_err) {
                printf("%s: segfault occurred!", __func__);
                return 1;
        }

        struct fn_args {
                const struct gcm_key_data *exp_key;
                struct gcm_context_data *ctx;
                uint8_t *dst;
                const uint8_t *src;
                uint64_t len;
                const IMB_ERR exp_err;
        } fn_args[] = { { NULL, ctx, dst, src, len, IMB_ERR_NULL_EXP_KEY },
                        { exp_key, NULL, dst, src, len, IMB_ERR_NULL_CTX },
                        { exp_key, ctx, NULL, src, len, IMB_ERR_NULL_DST },
                        { exp_key, ctx, dst, NULL, len, IMB_ERR_NULL_SRC },
                        { exp_key, ctx, dst, src, ((1ULL << 39) - 256), IMB_ERR_CIPH_LEN } };

        /* Iterate over args */
        for (i = 0; i < DIM(fn_args); i++) {
                const struct fn_args *ap = &fn_args[i];

                IMB_AES128_GCM_ENC_UPDATE(mgr, ap->exp_key, ap->ctx, ap->dst, ap->src, ap->len);
                if (unexpected_err(mgr, ap->exp_err, "IMB_AES128_GCM_ENC_UPDATE"))
                        return 1;
        }
        return 0;
}

/*
 * @brief Performs direct API invalid param tests for IMB_AES192_GCM_ENC_UPDATE
 */
static int
test_IMB_AES192_GCM_ENC_UPDATE(struct IMB_MGR *mgr)
{
        unsigned i = 1;
        const struct gcm_key_data exp_key_s;
        const struct gcm_key_data *exp_key = &exp_key_s;
        struct gcm_context_data ctx_s;
        struct gcm_context_data *ctx = &ctx_s;
        uint8_t dst[BUFF_SIZE];
        const uint8_t src[BUFF_SIZE];
        uint64_t len = 1;
        int seg_err; /* segfault flag */

        seg_err = setjmp(dir_api_param_env);
        if (seg_err) {
                printf("%s: segfault occurred!", __func__);
                return 1;
        }

        struct fn_args {
                const struct gcm_key_data *exp_key;
                struct gcm_context_data *ctx;
                uint8_t *dst;
                const uint8_t *src;
                uint64_t len;
                const IMB_ERR exp_err;
        } fn_args[] = { { NULL, ctx, dst, src, len, IMB_ERR_NULL_EXP_KEY },
                        { exp_key, NULL, dst, src, len, IMB_ERR_NULL_CTX },
                        { exp_key, ctx, NULL, src, len, IMB_ERR_NULL_DST },
                        { exp_key, ctx, dst, NULL, len, IMB_ERR_NULL_SRC },
                        { exp_key, ctx, dst, src, ((1ULL << 39) - 256), IMB_ERR_CIPH_LEN } };

        /* Iterate over args */
        for (i = 0; i < DIM(fn_args); i++) {
                const struct fn_args *ap = &fn_args[i];

                IMB_AES192_GCM_ENC_UPDATE(mgr, ap->exp_key, ap->ctx, ap->dst, ap->src, ap->len);
                if (unexpected_err(mgr, ap->exp_err, "IMB_AES192_GCM_ENC_UPDATE"))
                        return 1;
        }
        return 0;
}

/*
 * @brief Performs direct API invalid param tests for IMB_AES256_GCM_ENC_UPDATE
 */
static int
test_IMB_AES256_GCM_ENC_UPDATE(struct IMB_MGR *mgr)
{
        unsigned i = 1;
        const struct gcm_key_data exp_key_s;
        const struct gcm_key_data *exp_key = &exp_key_s;
        struct gcm_context_data ctx_s;
        struct gcm_context_data *ctx = &ctx_s;
        uint8_t dst[BUFF_SIZE];
        const uint8_t src[BUFF_SIZE];
        uint64_t len = 1;
        int seg_err; /* segfault flag */

        seg_err = setjmp(dir_api_param_env);
        if (seg_err) {
                printf("%s: segfault occurred!", __func__);
                return 1;
        }

        struct fn_args {
                const struct gcm_key_data *exp_key;
                struct gcm_context_data *ctx;
                uint8_t *dst;
                const uint8_t *src;
                uint64_t len;
                const IMB_ERR exp_err;
        } fn_args[] = { { NULL, ctx, dst, src, len, IMB_ERR_NULL_EXP_KEY },
                        { exp_key, NULL, dst, src, len, IMB_ERR_NULL_CTX },
                        { exp_key, ctx, NULL, src, len, IMB_ERR_NULL_DST },
                        { exp_key, ctx, dst, NULL, len, IMB_ERR_NULL_SRC },
                        { exp_key, ctx, dst, src, ((1ULL << 39) - 256), IMB_ERR_CIPH_LEN } };

        /* Iterate over args */
        for (i = 0; i < DIM(fn_args); i++) {
                const struct fn_args *ap = &fn_args[i];

                IMB_AES256_GCM_ENC_UPDATE(mgr, ap->exp_key, ap->ctx, ap->dst, ap->src, ap->len);
                if (unexpected_err(mgr, ap->exp_err, "IMB_AES256_GCM_ENC_UPDATE"))
                        return 1;
        }
        return 0;
}

/*
 * @brief Performs direct API invalid param tests for IMB_AES128_GCM_DEC_UPDATE
 */
static int
test_IMB_AES128_GCM_DEC_UPDATE(struct IMB_MGR *mgr)
{
        unsigned i = 1;
        const struct gcm_key_data exp_key_s;
        const struct gcm_key_data *exp_key = &exp_key_s;
        struct gcm_context_data ctx_s;
        struct gcm_context_data *ctx = &ctx_s;
        uint8_t dst[BUFF_SIZE];
        const uint8_t src[BUFF_SIZE];
        uint64_t len = 1;
        int seg_err; /* segfault flag */

        seg_err = setjmp(dir_api_param_env);
        if (seg_err) {
                printf("%s: segfault occurred!", __func__);
                return 1;
        }

        struct fn_args {
                const struct gcm_key_data *exp_key;
                struct gcm_context_data *ctx;
                uint8_t *dst;
                const uint8_t *src;
                uint64_t len;
                const IMB_ERR exp_err;
        } fn_args[] = { { NULL, ctx, dst, src, len, IMB_ERR_NULL_EXP_KEY },
                        { exp_key, NULL, dst, src, len, IMB_ERR_NULL_CTX },
                        { exp_key, ctx, NULL, src, len, IMB_ERR_NULL_DST },
                        { exp_key, ctx, dst, NULL, len, IMB_ERR_NULL_SRC },
                        { exp_key, ctx, dst, src, ((1ULL << 39) - 256), IMB_ERR_CIPH_LEN } };

        /* Iterate over args */
        for (i = 0; i < DIM(fn_args); i++) {
                const struct fn_args *ap = &fn_args[i];

                IMB_AES128_GCM_DEC_UPDATE(mgr, ap->exp_key, ap->ctx, ap->dst, ap->src, ap->len);
                if (unexpected_err(mgr, ap->exp_err, "IMB_AES128_GCM_DEC_UPDATE"))
                        return 1;
        }
        return 0;
}

/*
 * @brief Performs direct API invalid param tests for IMB_AES192_GCM_DEC_UPDATE
 */
static int
test_IMB_AES192_GCM_DEC_UPDATE(struct IMB_MGR *mgr)
{
        unsigned i = 1;
        const struct gcm_key_data exp_key_s;
        const struct gcm_key_data *exp_key = &exp_key_s;
        struct gcm_context_data ctx_s;
        struct gcm_context_data *ctx = &ctx_s;
        uint8_t dst[BUFF_SIZE];
        const uint8_t src[BUFF_SIZE];
        uint64_t len = 1;
        int seg_err; /* segfault flag */

        seg_err = setjmp(dir_api_param_env);
        if (seg_err) {
                printf("%s: segfault occurred!", __func__);
                return 1;
        }

        struct fn_args {
                const struct gcm_key_data *exp_key;
                struct gcm_context_data *ctx;
                uint8_t *dst;
                const uint8_t *src;
                uint64_t len;
                const IMB_ERR exp_err;
        } fn_args[] = { { NULL, ctx, dst, src, len, IMB_ERR_NULL_EXP_KEY },
                        { exp_key, NULL, dst, src, len, IMB_ERR_NULL_CTX },
                        { exp_key, ctx, NULL, src, len, IMB_ERR_NULL_DST },
                        { exp_key, ctx, dst, NULL, len, IMB_ERR_NULL_SRC },
                        { exp_key, ctx, dst, src, ((1ULL << 39) - 256), IMB_ERR_CIPH_LEN } };

        /* Iterate over args */
        for (i = 0; i < DIM(fn_args); i++) {
                const struct fn_args *ap = &fn_args[i];

                IMB_AES192_GCM_DEC_UPDATE(mgr, ap->exp_key, ap->ctx, ap->dst, ap->src, ap->len);
                if (unexpected_err(mgr, ap->exp_err, "IMB_AES192_GCM_DEC_UPDATE"))
                        return 1;
        }
        return 0;
}

/*
 * @brief Performs direct API invalid param tests for IMB_AES256_GCM_DEC_UPDATE
 */
static int
test_IMB_AES256_GCM_DEC_UPDATE(struct IMB_MGR *mgr)
{
        unsigned i = 1;
        const struct gcm_key_data exp_key_s;
        const struct gcm_key_data *exp_key = &exp_key_s;
        struct gcm_context_data ctx_s;
        struct gcm_context_data *ctx = &ctx_s;
        uint8_t dst[BUFF_SIZE];
        const uint8_t src[BUFF_SIZE];
        uint64_t len = 1;
        int seg_err; /* segfault flag */

        seg_err = setjmp(dir_api_param_env);
        if (seg_err) {
                printf("%s: segfault occurred!", __func__);
                return 1;
        }

        struct fn_args {
                const struct gcm_key_data *exp_key;
                struct gcm_context_data *ctx;
                uint8_t *dst;
                const uint8_t *src;
                uint64_t len;
                const IMB_ERR exp_err;
        } fn_args[] = { { NULL, ctx, dst, src, len, IMB_ERR_NULL_EXP_KEY },
                        { exp_key, NULL, dst, src, len, IMB_ERR_NULL_CTX },
                        { exp_key, ctx, NULL, src, len, IMB_ERR_NULL_DST },
                        { exp_key, ctx, dst, NULL, len, IMB_ERR_NULL_SRC },
                        { exp_key, ctx, dst, src, ((1ULL << 39) - 256), IMB_ERR_CIPH_LEN } };

        /* Iterate over args */
        for (i = 0; i < DIM(fn_args); i++) {
                const struct fn_args *ap = &fn_args[i];

                IMB_AES256_GCM_DEC_UPDATE(mgr, ap->exp_key, ap->ctx, ap->dst, ap->src, ap->len);
                if (unexpected_err(mgr, ap->exp_err, "IMB_AES256_GCM_DEC_UPDATE"))
                        return 1;
        }
        return 0;
}

/*
 * @brief Performs direct API invalid param tests for
 * IMB_AES128_GCM_ENC_FINALIZE */
static int
test_IMB_AES128_GCM_ENC_FINALIZE(struct IMB_MGR *mgr)
{
        unsigned i = 1;
        const struct gcm_key_data exp_key_s;
        const struct gcm_key_data *exp_key = &exp_key_s;
        struct gcm_context_data ctx_s;
        struct gcm_context_data *ctx = &ctx_s;
        uint8_t tag[BUFF_SIZE];
        uint64_t tagl = 1;
        int seg_err; /* segfault flag */

        seg_err = setjmp(dir_api_param_env);
        if (seg_err) {
                printf("%s: segfault occurred!", __func__);
                return 1;
        }

        struct fn_args {
                const struct gcm_key_data *exp_key;
                struct gcm_context_data *ctx;
                uint8_t *tag;
                uint64_t tagl;
                const IMB_ERR exp_err;
        } fn_args[] = { { NULL, ctx, tag, tagl, IMB_ERR_NULL_EXP_KEY },
                        { exp_key, NULL, tag, tagl, IMB_ERR_NULL_CTX },
                        { exp_key, ctx, NULL, tagl, IMB_ERR_NULL_AUTH },
                        { exp_key, ctx, tag, 0, IMB_ERR_AUTH_TAG_LEN } };

        /* Iterate over args */
        for (i = 0; i < DIM(fn_args); i++) {
                const struct fn_args *ap = &fn_args[i];

                IMB_AES128_GCM_ENC_FINALIZE(mgr, ap->exp_key, ap->ctx, ap->tag, ap->tagl);
                if (unexpected_err(mgr, ap->exp_err, "IMB_AES128_GCM_ENC_FINALIZE"))
                        return 1;
        }
        return 0;
}

/*
 * @brief Performs direct API invalid param tests for
 * IMB_AES192_GCM_ENC_FINALIZE */
static int
test_IMB_AES192_GCM_ENC_FINALIZE(struct IMB_MGR *mgr)
{
        unsigned i = 1;
        const struct gcm_key_data exp_key_s;
        const struct gcm_key_data *exp_key = &exp_key_s;
        struct gcm_context_data ctx_s;
        struct gcm_context_data *ctx = &ctx_s;
        uint8_t tag[BUFF_SIZE];
        uint64_t tagl = 1;
        int seg_err; /* segfault flag */

        seg_err = setjmp(dir_api_param_env);
        if (seg_err) {
                printf("%s: segfault occurred!", __func__);
                return 1;
        }

        struct fn_args {
                const struct gcm_key_data *exp_key;
                struct gcm_context_data *ctx;
                uint8_t *tag;
                uint64_t tagl;
                const IMB_ERR exp_err;
        } fn_args[] = { { NULL, ctx, tag, tagl, IMB_ERR_NULL_EXP_KEY },
                        { exp_key, NULL, tag, tagl, IMB_ERR_NULL_CTX },
                        { exp_key, ctx, NULL, tagl, IMB_ERR_NULL_AUTH },
                        { exp_key, ctx, tag, 0, IMB_ERR_AUTH_TAG_LEN } };

        /* Iterate over args */
        for (i = 0; i < DIM(fn_args); i++) {
                const struct fn_args *ap = &fn_args[i];

                IMB_AES192_GCM_ENC_FINALIZE(mgr, ap->exp_key, ap->ctx, ap->tag, ap->tagl);
                if (unexpected_err(mgr, ap->exp_err, "IMB_AES192_GCM_ENC_FINALIZE"))
                        return 1;
        }
        return 0;
}

/*
 * @brief Performs direct API invalid param tests for
 * IMB_AES256_GCM_ENC_FINALIZE */
static int
test_IMB_AES256_GCM_ENC_FINALIZE(struct IMB_MGR *mgr)
{
        unsigned i = 1;
        const struct gcm_key_data exp_key_s;
        const struct gcm_key_data *exp_key = &exp_key_s;
        struct gcm_context_data ctx_s;
        struct gcm_context_data *ctx = &ctx_s;
        uint8_t tag[BUFF_SIZE];
        uint64_t tagl = 1;
        int seg_err; /* segfault flag */

        seg_err = setjmp(dir_api_param_env);
        if (seg_err) {
                printf("%s: segfault occurred!", __func__);
                return 1;
        }

        struct fn_args {
                const struct gcm_key_data *exp_key;
                struct gcm_context_data *ctx;
                uint8_t *tag;
                uint64_t tagl;
                const IMB_ERR exp_err;
        } fn_args[] = { { NULL, ctx, tag, tagl, IMB_ERR_NULL_EXP_KEY },
                        { exp_key, NULL, tag, tagl, IMB_ERR_NULL_CTX },
                        { exp_key, ctx, NULL, tagl, IMB_ERR_NULL_AUTH },
                        { exp_key, ctx, tag, 0, IMB_ERR_AUTH_TAG_LEN } };

        /* Iterate over args */
        for (i = 0; i < DIM(fn_args); i++) {
                const struct fn_args *ap = &fn_args[i];

                IMB_AES256_GCM_ENC_FINALIZE(mgr, ap->exp_key, ap->ctx, ap->tag, ap->tagl);
                if (unexpected_err(mgr, ap->exp_err, "IMB_AES256_GCM_ENC_FINALIZE"))
                        return 1;
        }
        return 0;
}

/*
 * @brief Performs direct API invalid param tests for
 * IMB_AES128_GCM_DEC_FINALIZE */
static int
test_IMB_AES128_GCM_DEC_FINALIZE(struct IMB_MGR *mgr)
{
        unsigned i = 1;
        const struct gcm_key_data exp_key_s;
        const struct gcm_key_data *exp_key = &exp_key_s;
        struct gcm_context_data ctx_s;
        struct gcm_context_data *ctx = &ctx_s;
        uint8_t tag[BUFF_SIZE];
        uint64_t tagl = 1;
        int seg_err; /* segfault flag */

        seg_err = setjmp(dir_api_param_env);
        if (seg_err) {
                printf("%s: segfault occurred!", __func__);
                return 1;
        }

        struct fn_args {
                const struct gcm_key_data *exp_key;
                struct gcm_context_data *ctx;
                uint8_t *tag;
                uint64_t tagl;
                const IMB_ERR exp_err;
        } fn_args[] = { { NULL, ctx, tag, tagl, IMB_ERR_NULL_EXP_KEY },
                        { exp_key, NULL, tag, tagl, IMB_ERR_NULL_CTX },
                        { exp_key, ctx, NULL, tagl, IMB_ERR_NULL_AUTH },
                        { exp_key, ctx, tag, 0, IMB_ERR_AUTH_TAG_LEN } };

        /* Iterate over args */
        for (i = 0; i < DIM(fn_args); i++) {
                const struct fn_args *ap = &fn_args[i];

                IMB_AES128_GCM_DEC_FINALIZE(mgr, ap->exp_key, ap->ctx, ap->tag, ap->tagl);
                if (unexpected_err(mgr, ap->exp_err, "IMB_AES128_GCM_DEC_FINALIZE"))
                        return 1;
        }
        return 0;
}

/*
 * @brief Performs direct API invalid param tests for
 * IMB_AES192_GCM_DEC_FINALIZE */
static int
test_IMB_AES192_GCM_DEC_FINALIZE(struct IMB_MGR *mgr)
{
        unsigned i = 1;
        const struct gcm_key_data exp_key_s;
        const struct gcm_key_data *exp_key = &exp_key_s;
        struct gcm_context_data ctx_s;
        struct gcm_context_data *ctx = &ctx_s;
        uint8_t tag[BUFF_SIZE];
        uint64_t tagl = 1;
        int seg_err; /* segfault flag */

        seg_err = setjmp(dir_api_param_env);
        if (seg_err) {
                printf("%s: segfault occurred!", __func__);
                return 1;
        }

        struct fn_args {
                const struct gcm_key_data *exp_key;
                struct gcm_context_data *ctx;
                uint8_t *tag;
                uint64_t tagl;
                const IMB_ERR exp_err;
        } fn_args[] = { { NULL, ctx, tag, tagl, IMB_ERR_NULL_EXP_KEY },
                        { exp_key, NULL, tag, tagl, IMB_ERR_NULL_CTX },
                        { exp_key, ctx, NULL, tagl, IMB_ERR_NULL_AUTH },
                        { exp_key, ctx, tag, 0, IMB_ERR_AUTH_TAG_LEN } };

        /* Iterate over args */
        for (i = 0; i < DIM(fn_args); i++) {
                const struct fn_args *ap = &fn_args[i];

                IMB_AES192_GCM_DEC_FINALIZE(mgr, ap->exp_key, ap->ctx, ap->tag, ap->tagl);
                if (unexpected_err(mgr, ap->exp_err, "IMB_AES192_GCM_DEC_FINALIZE"))
                        return 1;
        }
        return 0;
}

/*
 * @brief Performs direct API invalid param tests for
 * IMB_AES256_GCM_DEC_FINALIZE */
static int
test_IMB_AES256_GCM_DEC_FINALIZE(struct IMB_MGR *mgr)
{
        unsigned i = 1;
        const struct gcm_key_data exp_key_s;
        const struct gcm_key_data *exp_key = &exp_key_s;
        struct gcm_context_data ctx_s;
        struct gcm_context_data *ctx = &ctx_s;
        uint8_t tag[BUFF_SIZE];
        uint64_t tagl = 1;
        int seg_err; /* segfault flag */

        seg_err = setjmp(dir_api_param_env);
        if (seg_err) {
                printf("%s: segfault occurred!", __func__);
                return 1;
        }

        struct fn_args {
                const struct gcm_key_data *exp_key;
                struct gcm_context_data *ctx;
                uint8_t *tag;
                uint64_t tagl;
                const IMB_ERR exp_err;
        } fn_args[] = { { NULL, ctx, tag, tagl, IMB_ERR_NULL_EXP_KEY },
                        { exp_key, NULL, tag, tagl, IMB_ERR_NULL_CTX },
                        { exp_key, ctx, NULL, tagl, IMB_ERR_NULL_AUTH },
                        { exp_key, ctx, tag, 0, IMB_ERR_AUTH_TAG_LEN } };

        /* Iterate over args */
        for (i = 0; i < DIM(fn_args); i++) {
                const struct fn_args *ap = &fn_args[i];

                IMB_AES256_GCM_DEC_FINALIZE(mgr, ap->exp_key, ap->ctx, ap->tag, ap->tagl);
                if (unexpected_err(mgr, ap->exp_err, "IMB_AES256_GCM_DEC_FINALIZE"))
                        return 1;
        }
        return 0;
}

/*
 * @brief Performs direct API invalid param tests for IMB_AES128_GCM_PRE */
static int
test_IMB_AES128_GCM_PRE(struct IMB_MGR *mgr)
{
        unsigned i = 1;
        const uint8_t key[BUFF_SIZE];
        struct gcm_key_data exp_key_s;
        struct gcm_key_data *exp_key = &exp_key_s;
        int seg_err; /* segfault flag */

        seg_err = setjmp(dir_api_param_env);
        if (seg_err) {
                printf("%s: segfault occurred!", __func__);
                return 1;
        }

        struct fn_args {
                const void *key;
                struct gcm_key_data *exp_key;
                const IMB_ERR exp_err;
        } fn_args[] = { { NULL, exp_key, IMB_ERR_NULL_KEY }, { key, NULL, IMB_ERR_NULL_EXP_KEY } };

        /* Iterate over args */
        for (i = 0; i < DIM(fn_args); i++) {
                const struct fn_args *ap = &fn_args[i];

                IMB_AES128_GCM_PRE(mgr, ap->key, ap->exp_key);
                if (unexpected_err(mgr, ap->exp_err, "IMB_AES128_GCM_PRE"))
                        return 1;
        }
        return 0;
}

/*
 * @brief Performs direct API invalid param tests for IMB_AES192_GCM_PRE */
static int
test_IMB_AES192_GCM_PRE(struct IMB_MGR *mgr)
{
        unsigned i = 1;
        const uint8_t key[BUFF_SIZE];
        struct gcm_key_data exp_key_s;
        struct gcm_key_data *exp_key = &exp_key_s;
        int seg_err; /* segfault flag */

        seg_err = setjmp(dir_api_param_env);
        if (seg_err) {
                printf("%s: segfault occurred!", __func__);
                return 1;
        }

        struct fn_args {
                const void *key;
                struct gcm_key_data *exp_key;
                const IMB_ERR exp_err;
        } fn_args[] = { { NULL, exp_key, IMB_ERR_NULL_KEY }, { key, NULL, IMB_ERR_NULL_EXP_KEY } };

        /* Iterate over args */
        for (i = 0; i < DIM(fn_args); i++) {
                const struct fn_args *ap = &fn_args[i];

                IMB_AES192_GCM_PRE(mgr, ap->key, ap->exp_key);
                if (unexpected_err(mgr, ap->exp_err, "IMB_AES192_GCM_PRE"))
                        return 1;
        }
        return 0;
}

/*
 * @brief Performs direct API invalid param tests for IMB_AES256_GCM_PRE */
static int
test_IMB_AES256_GCM_PRE(struct IMB_MGR *mgr)
{
        unsigned i = 1;
        const uint8_t key[BUFF_SIZE];
        struct gcm_key_data exp_key_s;
        struct gcm_key_data *exp_key = &exp_key_s;
        int seg_err; /* segfault flag */

        seg_err = setjmp(dir_api_param_env);
        if (seg_err) {
                printf("%s: segfault occurred!", __func__);
                return 1;
        }

        struct fn_args {
                const void *key;
                struct gcm_key_data *exp_key;
                const IMB_ERR exp_err;
        } fn_args[] = { { NULL, exp_key, IMB_ERR_NULL_KEY }, { key, NULL, IMB_ERR_NULL_EXP_KEY } };

        /* Iterate over args */
        for (i = 0; i < DIM(fn_args); i++) {
                const struct fn_args *ap = &fn_args[i];

                IMB_AES256_GCM_PRE(mgr, ap->key, ap->exp_key);
                if (unexpected_err(mgr, ap->exp_err, "IMB_AES256_GCM_PRE"))
                        return 1;
        }
        return 0;
}

/*
 * @brief Performs direct API invalid param tests for IMB_ZUC_EEA3_1_BUFFER */
static int
test_IMB_ZUC_EEA3_1_BUFFER(struct IMB_MGR *mgr)
{
        unsigned i = 1;
        const uint8_t key[BUFF_SIZE];
        const uint8_t iv[BUFF_SIZE];
        const uint8_t src[BUFF_SIZE];
        uint8_t dst[BUFF_SIZE];
        const uint32_t len = 1;
        int seg_err; /* segfault flag */

        seg_err = setjmp(dir_api_param_env);
        if (seg_err) {
                printf("%s: segfault occurred!", __func__);
                return 1;
        }

        struct fn_args {
                const void *key;
                const void *iv;
                const void *src;
                void *dst;
                const uint32_t len;
                const IMB_ERR exp_err;
        } fn_args[] = { { NULL, iv, src, dst, len, IMB_ERR_NULL_KEY },
                        { key, NULL, src, dst, len, IMB_ERR_NULL_IV },
                        { key, iv, NULL, dst, len, IMB_ERR_NULL_SRC },
                        { key, iv, src, NULL, len, IMB_ERR_NULL_DST },
                        { key, iv, src, dst, 0, IMB_ERR_CIPH_LEN } };

        /* Iterate over args */
        for (i = 0; i < DIM(fn_args); i++) {
                const struct fn_args *ap = &fn_args[i];

                IMB_ZUC_EEA3_1_BUFFER(mgr, ap->key, ap->iv, ap->src, ap->dst, ap->len);
                if (unexpected_err(mgr, ap->exp_err, "IMB_ZUC_EEA3_1_BUFFER"))
                        return 1;
        }
        return 0;
}

/*
 * @brief Performs direct API invalid param tests for IMB_ZUC_EEA3_4_BUFFER */
static int
test_IMB_ZUC_EEA3_4_BUFFER(struct IMB_MGR *mgr)
{
        unsigned i = 1;
        const void *key[MAX_BUFFS];
        const void *key_NULL_pts[MAX_BUFFS];
        const uint8_t key_s[MAX_BUFFS][BUFF_SIZE];
        const void *iv[MAX_BUFFS];
        const void *iv_NULL_pts[MAX_BUFFS];
        const uint8_t iv_s[MAX_BUFFS][BUFF_SIZE];
        const void *src[MAX_BUFFS];
        const void *src_NULL_pts[MAX_BUFFS];
        const uint8_t src_s[MAX_BUFFS][BUFF_SIZE];
        void *dst[MAX_BUFFS];
        void *dst_NULL_pts[MAX_BUFFS];
        uint8_t dst_s[MAX_BUFFS][BUFF_SIZE];
        const uint32_t len_all_zero[MAX_BUFFS] = {
                0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
        };
        const uint32_t len[MAX_BUFFS] = { 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 };
        int seg_err; /* segfault flag */

        seg_err = setjmp(dir_api_param_env);
        if (seg_err) {
                printf("%s: segfault occurred!", __func__);
                return 1;
        }

        for (i = 0; i < MAX_BUFFS; i++) {
                key[i] = key_s[i];
                key_NULL_pts[i] = NULL;
                iv[i] = iv_s[i];
                iv_NULL_pts[i] = NULL;
                src[i] = src_s[i];
                src_NULL_pts[i] = NULL;
                dst[i] = dst_s[i];
                dst_NULL_pts[i] = NULL;
        }

        struct fn_args {
                const void *const *key;
                const void *const *iv;
                const void *const *src;
                void **dst;
                const uint32_t *len;
                const IMB_ERR exp_err;
        } fn_args[] = { { key_NULL_pts, iv, src, dst, len, IMB_ERR_NULL_KEY },
                        { NULL, iv, src, dst, len, IMB_ERR_NULL_KEY },
                        { key, iv_NULL_pts, src, dst, len, IMB_ERR_NULL_IV },
                        { key, NULL, src, dst, len, IMB_ERR_NULL_IV },
                        { key, iv, src_NULL_pts, dst, len, IMB_ERR_NULL_SRC },
                        { key, iv, NULL, dst, len, IMB_ERR_NULL_SRC },
                        { key, iv, src, dst_NULL_pts, len, IMB_ERR_NULL_DST },
                        { key, iv, src, NULL, len, IMB_ERR_NULL_DST },
                        { key, iv, src, dst, len_all_zero, IMB_ERR_CIPH_LEN } };

        /* Iterate over args */
        for (i = 0; i < DIM(fn_args); i++) {
                const struct fn_args *ap = &fn_args[i];

                IMB_ZUC_EEA3_4_BUFFER(mgr, ap->key, ap->iv, ap->src, ap->dst, ap->len);
                if (unexpected_err(mgr, ap->exp_err, "IMB_ZUC_EEA3_4_BUFFER"))
                        return 1;
        }
        return 0;
}

/*
 * @brief Performs direct API invalid param tests for IMB_ZUC_EEA3_N_BUFFER */
static int
test_IMB_ZUC_EEA3_N_BUFFER(struct IMB_MGR *mgr)
{
        unsigned i = 1;
        const void *key[MAX_BUFFS];
        const void *key_NULL_pts[MAX_BUFFS];
        const uint8_t key_s[MAX_BUFFS][BUFF_SIZE];
        const void *iv[MAX_BUFFS];
        const void *iv_NULL_pts[MAX_BUFFS];
        const uint8_t iv_s[MAX_BUFFS][BUFF_SIZE];
        const void *src[MAX_BUFFS];
        const void *src_NULL_pts[MAX_BUFFS];
        const uint8_t src_s[MAX_BUFFS][BUFF_SIZE];
        void *dst[MAX_BUFFS];
        void *dst_NULL_pts[MAX_BUFFS];
        uint8_t dst_s[MAX_BUFFS][BUFF_SIZE];
        const uint32_t len_all_zero[MAX_BUFFS] = {
                0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
        };
        const uint32_t len[MAX_BUFFS] = { 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 };
        const uint32_t count = MAX_BUFFS;
        int seg_err; /* segfault flag */

        seg_err = setjmp(dir_api_param_env);
        if (seg_err) {
                printf("%s: segfault occurred!", __func__);
                return 1;
        }

        for (i = 0; i < MAX_BUFFS; i++) {
                key[i] = key_s[i];
                key_NULL_pts[i] = NULL;
                iv[i] = iv_s[i];
                iv_NULL_pts[i] = NULL;
                src[i] = src_s[i];
                src_NULL_pts[i] = NULL;
                dst[i] = dst_s[i];
                dst_NULL_pts[i] = NULL;
        }

        struct fn_args {
                const void *const *key;
                const void *const *iv;
                const void *const *src;
                void **dst;
                const uint32_t *len;
                const uint32_t count;
                const IMB_ERR exp_err;
        } fn_args[] = { { key_NULL_pts, iv, src, dst, len, count, IMB_ERR_NULL_KEY },
                        { NULL, iv, src, dst, len, count, IMB_ERR_NULL_KEY },
                        { key, iv_NULL_pts, src, dst, len, count, IMB_ERR_NULL_IV },
                        { key, NULL, src, dst, len, count, IMB_ERR_NULL_IV },
                        { key, iv, src_NULL_pts, dst, len, count, IMB_ERR_NULL_SRC },
                        { key, iv, NULL, dst, len, count, IMB_ERR_NULL_SRC },
                        { key, iv, src, dst_NULL_pts, len, count, IMB_ERR_NULL_DST },
                        { key, iv, src, NULL, len, count, IMB_ERR_NULL_DST },
                        { key, iv, src, dst, len_all_zero, count, IMB_ERR_CIPH_LEN } };

        /* Iterate over args */
        for (i = 0; i < DIM(fn_args); i++) {
                const struct fn_args *ap = &fn_args[i];

                IMB_ZUC_EEA3_N_BUFFER(mgr, ap->key, ap->iv, ap->src, ap->dst, ap->len, ap->count);
                if (unexpected_err(mgr, ap->exp_err, "IMB_ZUC_EEA3_N_BUFFER"))
                        return 1;
        }
        return 0;
}

/*
 * @brief Performs direct API invalid param tests for IMB_ZUC_EIA3_1_BUFFER */
static int
test_IMB_ZUC_EIA3_1_BUFFER(struct IMB_MGR *mgr)
{
        unsigned i = 1;
        const uint8_t key[BUFF_SIZE];
        const uint8_t iv[BUFF_SIZE];
        const uint8_t src[BUFF_SIZE];
        const uint32_t len = 1;
        uint32_t tag[BUFF_SIZE];
        int seg_err; /* segfault flag */

        seg_err = setjmp(dir_api_param_env);
        if (seg_err) {
                printf("%s: segfault occurred!", __func__);
                return 1;
        }

        struct fn_args {
                const void *key;
                const void *iv;
                const void *src;
                const uint32_t len;
                uint32_t *tag;
                const IMB_ERR exp_err;
        } fn_args[] = { { NULL, iv, src, len, tag, IMB_ERR_NULL_KEY },
                        { key, NULL, src, len, tag, IMB_ERR_NULL_IV },
                        { key, iv, NULL, len, tag, IMB_ERR_NULL_SRC },
                        { key, iv, src, 0, tag, IMB_ERR_AUTH_LEN },
                        { key, iv, src, len, NULL, IMB_ERR_NULL_AUTH } };

        /* Iterate over args */
        for (i = 0; i < DIM(fn_args); i++) {
                const struct fn_args *ap = &fn_args[i];

                IMB_ZUC_EIA3_1_BUFFER(mgr, ap->key, ap->iv, ap->src, ap->len, ap->tag);
                if (unexpected_err(mgr, ap->exp_err, "IMB_ZUC_EIA3_1_BUFFER"))
                        return 1;
        }
        return 0;
}

/*
 * @brief Performs direct API invalid param tests for IMB_KASUMI_F8_1_BUFFER */
static int
test_IMB_KASUMI_F8_1_BUFFER(struct IMB_MGR *mgr)
{
        unsigned i = 1;
        const kasumi_key_sched_t exp_key_s;
        const kasumi_key_sched_t *exp_key = &exp_key_s;
        const uint64_t iv = 1;
        const uint8_t src[BUFF_SIZE];
        uint8_t dst[BUFF_SIZE];
        const uint32_t len = 1;
        int seg_err; /* segfault flag */

        seg_err = setjmp(dir_api_param_env);
        if (seg_err) {
                printf("%s: segfault occurred!", __func__);
                return 1;
        }

        struct fn_args {
                const kasumi_key_sched_t *exp_key;
                const uint64_t iv;
                const void *src;
                void *dst;
                const uint32_t len;
                const IMB_ERR exp_err;
        } fn_args[] = { { NULL, iv, src, dst, len, IMB_ERR_NULL_EXP_KEY },
                        { exp_key, iv, NULL, dst, len, IMB_ERR_NULL_SRC },
                        { exp_key, iv, src, NULL, len, IMB_ERR_NULL_DST },
                        { exp_key, iv, src, dst, 0, IMB_ERR_CIPH_LEN } };

        /* Iterate over args */
        for (i = 0; i < DIM(fn_args); i++) {
                const struct fn_args *ap = &fn_args[i];

                IMB_KASUMI_F8_1_BUFFER(mgr, ap->exp_key, ap->iv, ap->src, ap->dst, ap->len);
                if (unexpected_err(mgr, ap->exp_err, "IMB_KASUMI_F8_1_BUFFER"))
                        return 1;
        }
        return 0;
}

/*
 * @brief Performs direct API invalid param tests for IMB_KASUMI_F8_1_BUFFER_BIT
 */
static int
test_IMB_KASUMI_F8_1_BUFFER_BIT(struct IMB_MGR *mgr)
{
        unsigned i = 1;
        const kasumi_key_sched_t exp_key_s;
        const kasumi_key_sched_t *exp_key = &exp_key_s;
        const uint64_t iv = 1;
        const uint8_t src[BUFF_SIZE];
        uint8_t dst[BUFF_SIZE];
        const uint32_t len = 1;
        const uint32_t offset = 1;
        int seg_err; /* segfault flag */

        seg_err = setjmp(dir_api_param_env);
        if (seg_err) {
                printf("%s: segfault occurred!", __func__);
                return 1;
        }

        struct fn_args {
                const kasumi_key_sched_t *exp_key;
                const uint64_t iv;
                const void *src;
                void *dst;
                const uint32_t len;
                const uint32_t offset;
                const IMB_ERR exp_err;
        } fn_args[] = { { NULL, iv, src, dst, len, offset, IMB_ERR_NULL_EXP_KEY },
                        { exp_key, iv, NULL, dst, len, offset, IMB_ERR_NULL_SRC },
                        { exp_key, iv, src, NULL, len, offset, IMB_ERR_NULL_DST },
                        { exp_key, iv, src, dst, 0, offset, IMB_ERR_CIPH_LEN } };

        /* Iterate over args */
        for (i = 0; i < DIM(fn_args); i++) {
                const struct fn_args *ap = &fn_args[i];

                IMB_KASUMI_F8_1_BUFFER_BIT(mgr, ap->exp_key, ap->iv, ap->src, ap->dst, ap->len,
                                           ap->offset);
                if (unexpected_err(mgr, ap->exp_err, "IMB_KASUMI_F8_1_BUFFER_BIT"))
                        return 1;
        }
        return 0;
}

/*
 * @brief Performs direct API invalid param tests for IMB_KASUMI_F8_2_BUFFER */
static int
test_IMB_KASUMI_F8_2_BUFFER(struct IMB_MGR *mgr)
{
        unsigned i = 1;
        const kasumi_key_sched_t exp_key_s;
        const kasumi_key_sched_t *exp_key = &exp_key_s;
        const uint64_t iv1 = 1;
        const uint64_t iv2 = 1;
        const uint8_t src1[BUFF_SIZE];
        uint8_t dst1[BUFF_SIZE];
        const uint32_t len1 = 1;
        const uint8_t src2[BUFF_SIZE];
        uint8_t dst2[BUFF_SIZE];
        const uint32_t len2 = 1;
        int seg_err; /* segfault flag */

        seg_err = setjmp(dir_api_param_env);
        if (seg_err) {
                printf("%s: segfault occurred!", __func__);
                return 1;
        }

        struct fn_args {
                const kasumi_key_sched_t *exp_key;
                const uint64_t iv1;
                const uint64_t iv2;
                const void *src1;
                void *dst1;
                const uint32_t len1;
                const void *src2;
                void *dst2;
                const uint32_t len2;
                const IMB_ERR exp_err;
        } fn_args[] = { { NULL, iv1, iv2, src1, dst1, len1, src2, dst2, len2,
                          IMB_ERR_NULL_EXP_KEY },
                        { exp_key, iv1, iv2, NULL, dst1, len1, src2, dst2, len2, IMB_ERR_NULL_SRC },
                        { exp_key, iv1, iv2, src1, NULL, len1, src2, dst2, len2, IMB_ERR_NULL_DST },
                        { exp_key, iv1, iv2, src1, dst1, 0, src2, dst2, len2, IMB_ERR_CIPH_LEN },
                        { exp_key, iv1, iv2, src1, dst1, len1, NULL, dst2, len2, IMB_ERR_NULL_SRC },
                        { exp_key, iv1, iv2, src1, dst1, len1, src2, NULL, len2, IMB_ERR_NULL_DST },
                        { exp_key, iv1, iv2, src1, dst1, len1, src2, dst2, 0, IMB_ERR_CIPH_LEN } };

        /* Iterate over args */
        for (i = 0; i < DIM(fn_args); i++) {
                const struct fn_args *ap = &fn_args[i];

                IMB_KASUMI_F8_2_BUFFER(mgr, ap->exp_key, ap->iv1, ap->iv2, ap->src1, ap->dst1,
                                       ap->len1, ap->src2, ap->dst2, ap->len2);
                if (unexpected_err(mgr, ap->exp_err, "IMB_KASUMI_F8_2_BUFFER"))
                        return 1;
        }
        return 0;
}

/*
 * @brief Performs direct API invalid param tests for IMB_KASUMI_F8_3_BUFFER */
static int
test_IMB_KASUMI_F8_3_BUFFER(struct IMB_MGR *mgr)
{
        unsigned i = 1;
        const kasumi_key_sched_t exp_key_s;
        const kasumi_key_sched_t *exp_key = &exp_key_s;
        const uint64_t iv1 = 1;
        const uint64_t iv2 = 1;
        const uint64_t iv3 = 1;
        const uint8_t src1[BUFF_SIZE];
        uint8_t dst1[BUFF_SIZE];
        const uint8_t src2[BUFF_SIZE];
        uint8_t dst2[BUFF_SIZE];
        const uint8_t src3[BUFF_SIZE];
        uint8_t dst3[BUFF_SIZE];
        const uint32_t len = 1;
        int seg_err; /* segfault flag */

        seg_err = setjmp(dir_api_param_env);
        if (seg_err) {
                printf("%s: segfault occurred!", __func__);
                return 1;
        }

        struct fn_args {
                const kasumi_key_sched_t *exp_key;
                const uint64_t iv1;
                const uint64_t iv2;
                const uint64_t iv3;
                const void *src1;
                void *dst1;
                const void *src2;
                void *dst2;
                const void *src3;
                void *dst3;
                const uint32_t len;
                const IMB_ERR exp_err;
        } fn_args[] = { { NULL, iv1, iv2, iv3, src1, dst1, src2, dst2, src3, dst3, len,
                          IMB_ERR_NULL_EXP_KEY },
                        { exp_key, iv1, iv2, iv3, NULL, dst1, src2, dst2, src3, dst3, len,
                          IMB_ERR_NULL_SRC },
                        { exp_key, iv1, iv2, iv3, src1, NULL, src2, dst2, src3, dst3, len,
                          IMB_ERR_NULL_DST },
                        { exp_key, iv1, iv2, iv3, src1, dst1, NULL, dst2, src3, dst3, len,
                          IMB_ERR_NULL_SRC },
                        { exp_key, iv1, iv2, iv3, src1, dst1, src2, NULL, src3, dst3, len,
                          IMB_ERR_NULL_DST },
                        { exp_key, iv1, iv2, iv3, src1, dst1, src2, dst2, NULL, dst3, len,
                          IMB_ERR_NULL_SRC },
                        { exp_key, iv1, iv2, iv3, src1, dst1, src2, dst2, src3, NULL, len,
                          IMB_ERR_NULL_DST },
                        { exp_key, iv1, iv2, iv3, src1, dst1, src2, dst2, src3, dst3, 0,
                          IMB_ERR_CIPH_LEN } };

        /* Iterate over args */
        for (i = 0; i < DIM(fn_args); i++) {
                const struct fn_args *ap = &fn_args[i];

                IMB_KASUMI_F8_3_BUFFER(mgr, ap->exp_key, ap->iv1, ap->iv2, ap->iv3, ap->src1,
                                       ap->dst1, ap->src2, ap->dst2, ap->src3, ap->dst3, ap->len);
                if (unexpected_err(mgr, ap->exp_err, "IMB_KASUMI_F8_3_BUFFER"))
                        return 1;
        }
        return 0;
}

/*
 * @brief Performs direct API invalid param tests for IMB_KASUMI_F8_4_BUFFER */
static int
test_IMB_KASUMI_F8_4_BUFFER(struct IMB_MGR *mgr)
{
        unsigned i = 1;
        const kasumi_key_sched_t exp_key_s;
        const kasumi_key_sched_t *exp_key = &exp_key_s;
        const uint64_t iv1 = 1;
        const uint64_t iv2 = 1;
        const uint64_t iv3 = 1;
        const uint64_t iv4 = 1;
        const uint8_t src1[BUFF_SIZE];
        uint8_t dst1[BUFF_SIZE];
        const uint8_t src2[BUFF_SIZE];
        uint8_t dst2[BUFF_SIZE];
        const uint8_t src3[BUFF_SIZE];
        uint8_t dst3[BUFF_SIZE];
        const uint8_t src4[BUFF_SIZE];
        uint8_t dst4[BUFF_SIZE];
        const uint32_t len = 1;
        int seg_err; /* segfault flag */

        seg_err = setjmp(dir_api_param_env);
        if (seg_err) {
                printf("%s: segfault occurred!", __func__);
                return 1;
        }

        struct fn_args {
                const kasumi_key_sched_t *exp_key;
                const uint64_t iv1;
                const uint64_t iv2;
                const uint64_t iv3;
                const uint64_t iv4;
                const void *src1;
                void *dst1;
                const void *src2;
                void *dst2;
                const void *src3;
                void *dst3;
                const void *src4;
                void *dst4;
                const uint32_t len;
                const IMB_ERR exp_err;
        } fn_args[] = { { NULL, iv1, iv2, iv3, iv4, src1, dst1, src2, dst2, src3, dst3, src4, dst4,
                          len, IMB_ERR_NULL_EXP_KEY },
                        { exp_key, iv1, iv2, iv3, iv4, NULL, dst1, src2, dst2, src3, dst3, src4,
                          dst4, len, IMB_ERR_NULL_SRC },
                        { exp_key, iv1, iv2, iv3, iv4, src1, NULL, src2, dst2, src3, dst3, src4,
                          dst4, len, IMB_ERR_NULL_DST },
                        { exp_key, iv1, iv2, iv3, iv4, src1, dst1, NULL, dst2, src3, dst3, src4,
                          dst4, len, IMB_ERR_NULL_SRC },
                        { exp_key, iv1, iv2, iv3, iv4, src1, dst1, src2, NULL, src3, dst3, src4,
                          dst4, len, IMB_ERR_NULL_DST },
                        { exp_key, iv1, iv2, iv3, iv4, src1, dst1, src2, dst2, NULL, dst3, src4,
                          dst4, len, IMB_ERR_NULL_SRC },
                        { exp_key, iv1, iv2, iv3, iv4, src1, dst1, src2, dst2, src3, NULL, src4,
                          dst4, len, IMB_ERR_NULL_DST },
                        { exp_key, iv1, iv2, iv3, iv4, src1, dst1, src2, dst2, src3, dst3, NULL,
                          dst4, len, IMB_ERR_NULL_SRC },
                        { exp_key, iv1, iv2, iv3, iv4, src1, dst1, src2, dst2, src3, dst3, src4,
                          NULL, len, IMB_ERR_NULL_DST },
                        { exp_key, iv1, iv2, iv3, iv4, src1, dst1, src2, dst2, src3, dst3, src4,
                          dst4, 0, IMB_ERR_CIPH_LEN } };

        /* Iterate over args */
        for (i = 0; i < DIM(fn_args); i++) {
                const struct fn_args *ap = &fn_args[i];

                IMB_KASUMI_F8_4_BUFFER(mgr, ap->exp_key, ap->iv1, ap->iv2, ap->iv3, ap->iv4,
                                       ap->src1, ap->dst1, ap->src2, ap->dst2, ap->src3, ap->dst3,
                                       ap->src4, ap->dst4, ap->len);
                if (unexpected_err(mgr, ap->exp_err, "IMB_KASUMI_F8_4_BUFFER"))
                        return 1;
        }
        return 0;
}

/*
 * @brief Performs direct API invalid param tests for IMB_KASUMI_F8_N_BUFFER */
static int
test_IMB_KASUMI_F8_N_BUFFER(struct IMB_MGR *mgr)
{
        unsigned i = 1;
        const kasumi_key_sched_t exp_key_s;
        const kasumi_key_sched_t *exp_key = &exp_key_s;
        const uint64_t iv[BUFF_SIZE];
        const void *src[MAX_BUFFS];
        const void *src_NULL_pts[MAX_BUFFS];
        const uint8_t src_s[MAX_BUFFS][BUFF_SIZE];
        void *dst[MAX_BUFFS];
        void *dst_NULL_pts[MAX_BUFFS];
        uint8_t dst_s[MAX_BUFFS][BUFF_SIZE];
        const uint32_t len_all_zero[MAX_BUFFS] = {
                0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
        };
        const uint32_t len[MAX_BUFFS] = { 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 };
        const uint32_t count = MAX_BUFFS;
        int seg_err; /* segfault flag */

        seg_err = setjmp(dir_api_param_env);
        if (seg_err) {
                printf("%s: segfault occurred!", __func__);
                return 1;
        }

        for (i = 0; i < MAX_BUFFS; i++) {
                src[i] = src_s[i];
                src_NULL_pts[i] = NULL;
                dst[i] = dst_s[i];
                dst_NULL_pts[i] = NULL;
        }

        struct fn_args {
                const kasumi_key_sched_t *exp_key;
                const uint64_t *iv;
                const void *const *src;
                void **dst;
                const uint32_t *len;
                const uint32_t count;
                const IMB_ERR exp_err;
        } fn_args[] = { { NULL, iv, src, dst, len, count, IMB_ERR_NULL_EXP_KEY },
                        { exp_key, iv, src_NULL_pts, dst, len, count, IMB_ERR_NULL_SRC },
                        { exp_key, iv, NULL, dst, len, count, IMB_ERR_NULL_SRC },
                        { exp_key, iv, src, dst_NULL_pts, len, count, IMB_ERR_NULL_DST },
                        { exp_key, iv, src, NULL, len, count, IMB_ERR_NULL_DST },
                        { exp_key, iv, src, dst, len_all_zero, count, IMB_ERR_CIPH_LEN } };

        /* Iterate over args */
        for (i = 0; i < DIM(fn_args); i++) {
                const struct fn_args *ap = &fn_args[i];

                IMB_KASUMI_F8_N_BUFFER(mgr, ap->exp_key, ap->iv, ap->src, ap->dst, ap->len,
                                       ap->count);
                if (unexpected_err(mgr, ap->exp_err, "IMB_KASUMI_F8_N_BUFFER"))
                        return 1;
        }
        return 0;
}

/*
 * @brief Performs direct API invalid param tests for IMB_KASUMI_F9_1_BUFFER */
static int
test_IMB_KASUMI_F9_1_BUFFER(struct IMB_MGR *mgr)
{
        unsigned i = 1;
        const kasumi_key_sched_t exp_key_s;
        const kasumi_key_sched_t *exp_key = &exp_key_s;
        const uint8_t src[BUFF_SIZE];
        const uint32_t len = 1;
        uint8_t tag[BUFF_SIZE];
        int seg_err; /* segfault flag */

        seg_err = setjmp(dir_api_param_env);
        if (seg_err) {
                printf("%s: segfault occurred!", __func__);
                return 1;
        }

        struct fn_args {
                const kasumi_key_sched_t *exp_key;
                const void *src;
                const uint32_t len;
                void *tag;
                const IMB_ERR exp_err;
        } fn_args[] = { { NULL, src, len, tag, IMB_ERR_NULL_EXP_KEY },
                        { exp_key, NULL, len, tag, IMB_ERR_NULL_SRC },
                        { exp_key, src, 0, tag, IMB_ERR_AUTH_LEN },
                        { exp_key, src, len, NULL, IMB_ERR_NULL_AUTH } };

        /* Iterate over args */
        for (i = 0; i < DIM(fn_args); i++) {
                const struct fn_args *ap = &fn_args[i];

                IMB_KASUMI_F9_1_BUFFER(mgr, ap->exp_key, ap->src, ap->len, ap->tag);
                if (unexpected_err(mgr, ap->exp_err, "IMB_KASUMI_F9_1_BUFFER"))
                        return 1;
        }
        return 0;
}

/*
 * @brief Performs direct API invalid param tests for
 * IMB_KASUMI_F9_1_BUFFER_USER */
static int
test_IMB_KASUMI_F9_1_BUFFER_USER(struct IMB_MGR *mgr)
{
        unsigned i = 1;
        const kasumi_key_sched_t exp_key_s;
        const kasumi_key_sched_t *exp_key = &exp_key_s;
        const uint64_t iv = 1;
        const uint8_t src[BUFF_SIZE];
        const uint32_t len = 1;
        uint8_t tag[BUFF_SIZE];
        const uint32_t dir = 1;
        int seg_err; /* segfault flag */

        seg_err = setjmp(dir_api_param_env);
        if (seg_err) {
                printf("%s: segfault occurred!", __func__);
                return 1;
        }

        struct fn_args {
                const kasumi_key_sched_t *exp_key;
                const uint64_t iv;
                const void *src;
                const uint32_t len;
                void *tag;
                const uint32_t dir;
                const IMB_ERR exp_err;
        } fn_args[] = { { NULL, iv, src, len, tag, dir, IMB_ERR_NULL_EXP_KEY },
                        { exp_key, iv, NULL, len, tag, dir, IMB_ERR_NULL_SRC },
                        { exp_key, iv, src, 0, tag, dir, IMB_ERR_AUTH_LEN },
                        { exp_key, iv, src, len, NULL, dir, IMB_ERR_NULL_AUTH } };

        /* Iterate over args */
        for (i = 0; i < DIM(fn_args); i++) {
                const struct fn_args *ap = &fn_args[i];

                IMB_KASUMI_F9_1_BUFFER_USER(mgr, ap->exp_key, ap->iv, ap->src, ap->len, ap->tag,
                                            ap->dir);
                if (unexpected_err(mgr, ap->exp_err, "IMB_KASUMI_F9_1_BUFFER_USER"))
                        return 1;
        }
        return 0;
}

/*
 * @brief Performs direct API invalid param tests for
 * IMB_KASUMI_INIT_F8_KEY_SCHED */
static int
test_IMB_KASUMI_INIT_F8_KEY_SCHED(struct IMB_MGR *mgr)
{
        unsigned i = 1;
        const uint8_t key[BUFF_SIZE];
        kasumi_key_sched_t exp_key_s;
        kasumi_key_sched_t *exp_key = &exp_key_s;
        int seg_err; /* segfault flag */

        seg_err = setjmp(dir_api_param_env);
        if (seg_err) {
                printf("%s: segfault occurred!", __func__);
                return 1;
        }

        struct fn_args {
                const void *key;
                kasumi_key_sched_t *exp_key;
                const IMB_ERR exp_err;
        } fn_args[] = { { NULL, exp_key, IMB_ERR_NULL_KEY }, { key, NULL, IMB_ERR_NULL_EXP_KEY } };

        /* Iterate over args */
        for (i = 0; i < DIM(fn_args); i++) {
                const struct fn_args *ap = &fn_args[i];

                IMB_KASUMI_INIT_F8_KEY_SCHED(mgr, ap->key, ap->exp_key);
                if (unexpected_err(mgr, ap->exp_err, "IMB_KASUMI_INIT_F8_KEY_SCHED"))
                        return 1;
        }
        return 0;
}

/*
 * @brief Performs direct API invalid param tests for
 * IMB_KASUMI_INIT_F9_KEY_SCHED */
static int
test_IMB_KASUMI_INIT_F9_KEY_SCHED(struct IMB_MGR *mgr)
{
        unsigned i = 1;
        const uint8_t key[BUFF_SIZE];
        kasumi_key_sched_t exp_key_s;
        kasumi_key_sched_t *exp_key = &exp_key_s;
        int seg_err; /* segfault flag */

        seg_err = setjmp(dir_api_param_env);
        if (seg_err) {
                printf("%s: segfault occurred!", __func__);
                return 1;
        }

        struct fn_args {
                const void *key;
                kasumi_key_sched_t *exp_key;
                const IMB_ERR exp_err;
        } fn_args[] = { { NULL, exp_key, IMB_ERR_NULL_KEY }, { key, NULL, IMB_ERR_NULL_EXP_KEY } };

        /* Iterate over args */
        for (i = 0; i < DIM(fn_args); i++) {
                const struct fn_args *ap = &fn_args[i];

                IMB_KASUMI_INIT_F9_KEY_SCHED(mgr, ap->key, ap->exp_key);
                if (unexpected_err(mgr, ap->exp_err, "IMB_KASUMI_INIT_F9_KEY_SCHED"))
                        return 1;
        }
        return 0;
}

/*
 * @brief Performs direct API invalid param tests for IMB_SNOW3G_F8_1_BUFFER_BIT
 */
static int
test_IMB_SNOW3G_F8_1_BUFFER_BIT(struct IMB_MGR *mgr)
{
        unsigned i = 1;
        const snow3g_key_schedule_t exp_key_s;
        const snow3g_key_schedule_t *exp_key = &exp_key_s;
        const uint8_t iv[BUFF_SIZE];
        const uint8_t src[BUFF_SIZE];
        uint8_t dst[BUFF_SIZE];
        const uint32_t len = 1;
        const uint32_t offset = 1;
        int seg_err; /* segfault flag */

        seg_err = setjmp(dir_api_param_env);
        if (seg_err) {
                printf("%s: segfault occurred!", __func__);
                return 1;
        }

        struct fn_args {
                const snow3g_key_schedule_t *exp_key;
                const void *iv;
                const void *src;
                void *dst;
                const uint32_t len;
                const uint32_t offset;
                const IMB_ERR exp_err;
        } fn_args[] = { { NULL, iv, src, dst, len, offset, IMB_ERR_NULL_EXP_KEY },
                        { exp_key, NULL, src, dst, len, offset, IMB_ERR_NULL_IV },
                        { exp_key, iv, NULL, dst, len, offset, IMB_ERR_NULL_SRC },
                        { exp_key, iv, src, NULL, len, offset, IMB_ERR_NULL_DST },
                        { exp_key, iv, src, dst, 0, offset, IMB_ERR_CIPH_LEN } };

        /* Iterate over args */
        for (i = 0; i < DIM(fn_args); i++) {
                const struct fn_args *ap = &fn_args[i];

                IMB_SNOW3G_F8_1_BUFFER_BIT(mgr, ap->exp_key, ap->iv, ap->src, ap->dst, ap->len,
                                           ap->offset);
                if (unexpected_err(mgr, ap->exp_err, "IMB_SNOW3G_F8_1_BUFFER_BIT"))
                        return 1;
        }
        return 0;
}

/*
 * @brief Performs direct API invalid param tests for IMB_SNOW3G_F8_1_BUFFER */
static int
test_IMB_SNOW3G_F8_1_BUFFER(struct IMB_MGR *mgr)
{
        unsigned i = 1;
        const snow3g_key_schedule_t exp_key_s;
        const snow3g_key_schedule_t *exp_key = &exp_key_s;
        const uint8_t iv[BUFF_SIZE];
        const uint8_t src[BUFF_SIZE];
        uint8_t dst[BUFF_SIZE];
        const uint32_t len = 1;
        int seg_err; /* segfault flag */

        seg_err = setjmp(dir_api_param_env);
        if (seg_err) {
                printf("%s: segfault occurred!", __func__);
                return 1;
        }

        struct fn_args {
                const snow3g_key_schedule_t *exp_key;
                const void *iv;
                const void *src;
                void *dst;
                const uint32_t len;
                const IMB_ERR exp_err;
        } fn_args[] = { { NULL, iv, src, dst, len, IMB_ERR_NULL_EXP_KEY },
                        { exp_key, NULL, src, dst, len, IMB_ERR_NULL_IV },
                        { exp_key, iv, NULL, dst, len, IMB_ERR_NULL_SRC },
                        { exp_key, iv, src, NULL, len, IMB_ERR_NULL_DST },
                        { exp_key, iv, src, dst, 0, IMB_ERR_CIPH_LEN } };

        /* Iterate over args */
        for (i = 0; i < DIM(fn_args); i++) {
                const struct fn_args *ap = &fn_args[i];

                IMB_SNOW3G_F8_1_BUFFER(mgr, ap->exp_key, ap->iv, ap->src, ap->dst, ap->len);
                if (unexpected_err(mgr, ap->exp_err, "IMB_SNOW3G_F8_1_BUFFER"))
                        return 1;
        }
        return 0;
}

/*
 * @brief Performs direct API invalid param tests for IMB_SNOW3G_F8_2_BUFFER */
static int
test_IMB_SNOW3G_F8_2_BUFFER(struct IMB_MGR *mgr)
{
        unsigned i = 1;
        const snow3g_key_schedule_t exp_key_s;
        const snow3g_key_schedule_t *exp_key = &exp_key_s;
        const uint8_t iv1[BUFF_SIZE];
        const uint8_t iv2[BUFF_SIZE];
        const uint8_t src1[BUFF_SIZE];
        uint8_t dst1[BUFF_SIZE];
        const uint32_t len1 = 1;
        const uint8_t src2[BUFF_SIZE];
        uint8_t dst2[BUFF_SIZE];
        const uint32_t len2 = 1;
        int seg_err; /* segfault flag */

        seg_err = setjmp(dir_api_param_env);
        if (seg_err) {
                printf("%s: segfault occurred!", __func__);
                return 1;
        }

        struct fn_args {
                const snow3g_key_schedule_t *exp_key;
                const void *iv1;
                const void *iv2;
                const void *src1;
                void *dst1;
                const uint32_t len1;
                const void *src2;
                void *dst2;
                const uint32_t len2;
                const IMB_ERR exp_err;
        } fn_args[] = { { NULL, iv1, iv2, src1, dst1, len1, src2, dst2, len2,
                          IMB_ERR_NULL_EXP_KEY },
                        { exp_key, NULL, iv2, src1, dst1, len1, src2, dst2, len2, IMB_ERR_NULL_IV },
                        { exp_key, iv1, NULL, src1, dst1, len1, src2, dst2, len2, IMB_ERR_NULL_IV },
                        { exp_key, iv1, iv2, NULL, dst1, len1, src2, dst2, len2, IMB_ERR_NULL_SRC },
                        { exp_key, iv1, iv2, src1, NULL, len1, src2, dst2, len2, IMB_ERR_NULL_DST },
                        { exp_key, iv1, iv2, src1, dst1, 0, src2, dst2, len2, IMB_ERR_CIPH_LEN },
                        { exp_key, iv1, iv2, src1, dst1, len1, NULL, dst2, len2, IMB_ERR_NULL_SRC },
                        { exp_key, iv1, iv2, src1, dst1, len1, src2, NULL, len2, IMB_ERR_NULL_DST },
                        { exp_key, iv1, iv2, src1, dst1, len1, src2, dst2, 0, IMB_ERR_CIPH_LEN } };

        /* Iterate over args */
        for (i = 0; i < DIM(fn_args); i++) {
                const struct fn_args *ap = &fn_args[i];

                IMB_SNOW3G_F8_2_BUFFER(mgr, ap->exp_key, ap->iv1, ap->iv2, ap->src1, ap->dst1,
                                       ap->len1, ap->src2, ap->dst2, ap->len2);
                if (unexpected_err(mgr, ap->exp_err, "IMB_SNOW3G_F8_2_BUFFER"))
                        return 1;
        }
        return 0;
}

/*
 * @brief Performs direct API invalid param tests for IMB_SNOW3G_F8_4_BUFFER */
static int
test_IMB_SNOW3G_F8_4_BUFFER(struct IMB_MGR *mgr)
{
        unsigned i = 1;
        const snow3g_key_schedule_t exp_key_s;
        const snow3g_key_schedule_t *exp_key = &exp_key_s;
        const uint8_t iv1[BUFF_SIZE];
        const uint8_t iv2[BUFF_SIZE];
        const uint8_t iv3[BUFF_SIZE];
        const uint8_t iv4[BUFF_SIZE];
        const uint8_t src1[BUFF_SIZE];
        uint8_t dst1[BUFF_SIZE];
        const uint32_t len1 = 1;
        const uint8_t src2[BUFF_SIZE];
        uint8_t dst2[BUFF_SIZE];
        const uint32_t len2 = 1;
        const uint8_t src3[BUFF_SIZE];
        uint8_t dst3[BUFF_SIZE];
        const uint32_t len3 = 1;
        const uint8_t src4[BUFF_SIZE];
        uint8_t dst4[BUFF_SIZE];
        const uint32_t len4 = 1;
        int seg_err; /* segfault flag */

        seg_err = setjmp(dir_api_param_env);
        if (seg_err) {
                printf("%s: segfault occurred!", __func__);
                return 1;
        }

        struct fn_args {
                const snow3g_key_schedule_t *exp_key;
                const void *iv1;
                const void *iv2;
                const void *iv3;
                const void *iv4;
                const void *src1;
                void *dst1;
                const uint32_t len1;
                const void *src2;
                void *dst2;
                const uint32_t len2;
                const void *src3;
                void *dst3;
                const uint32_t len3;
                const void *src4;
                void *dst4;
                const uint32_t len4;
                const IMB_ERR exp_err;
        } fn_args[] = { { NULL, iv1, iv2, iv3, iv4, src1, dst1, len1, src2, dst2, len2, src3, dst3,
                          len3, src4, dst4, len4, IMB_ERR_NULL_EXP_KEY },
                        { exp_key, NULL, iv2, iv3, iv4, src1, dst1, len1, src2, dst2, len2, src3,
                          dst3, len3, src4, dst4, len4, IMB_ERR_NULL_IV },
                        { exp_key, iv1, NULL, iv3, iv4, src1, dst1, len1, src2, dst2, len2, src3,
                          dst3, len3, src4, dst4, len4, IMB_ERR_NULL_IV },
                        { exp_key, iv1, iv2, NULL, iv4, src1, dst1, len1, src2, dst2, len2, src3,
                          dst3, len3, src4, dst4, len4, IMB_ERR_NULL_IV },
                        { exp_key, iv1, iv2, iv3, NULL, src1, dst1, len1, src2, dst2, len2, src3,
                          dst3, len3, src4, dst4, len4, IMB_ERR_NULL_IV },
                        { exp_key, iv1, iv2, iv3, iv4, NULL, dst1, len1, src2, dst2, len2, src3,
                          dst3, len3, src4, dst4, len4, IMB_ERR_NULL_SRC },
                        { exp_key, iv1, iv2, iv3, iv4, src1, NULL, len1, src2, dst2, len2, src3,
                          dst3, len3, src4, dst4, len4, IMB_ERR_NULL_DST },
                        { exp_key, iv1, iv2, iv3, iv4, src1, dst1, 0, src2, dst2, len2, src3, dst3,
                          len3, src4, dst4, len4, IMB_ERR_CIPH_LEN },
                        { exp_key, iv1, iv2, iv3, iv4, src1, dst1, len1, NULL, dst2, len2, src3,
                          dst3, len3, src4, dst4, len4, IMB_ERR_NULL_SRC },
                        { exp_key, iv1, iv2, iv3, iv4, src1, dst1, len1, src2, NULL, len2, src3,
                          dst3, len3, src4, dst4, len4, IMB_ERR_NULL_DST },
                        { exp_key, iv1, iv2, iv3, iv4, src1, dst1, len1, src2, dst2, 0, src3, dst3,
                          len3, src4, dst4, len4, IMB_ERR_CIPH_LEN },
                        { exp_key, iv1, iv2, iv3, iv4, src1, dst1, len1, src2, dst2, len2, NULL,
                          dst3, len3, src4, dst4, len4, IMB_ERR_NULL_SRC },
                        { exp_key, iv1, iv2, iv3, iv4, src1, dst1, len1, src2, dst2, len2, src3,
                          NULL, len3, src4, dst4, len4, IMB_ERR_NULL_DST },
                        { exp_key, iv1, iv2, iv3, iv4, src1, dst1, len1, src2, dst2, len2, src3,
                          dst3, 0, src4, dst4, len4, IMB_ERR_CIPH_LEN },
                        { exp_key, iv1, iv2, iv3, iv4, src1, dst1, len1, src2, dst2, len2, src3,
                          dst3, len3, NULL, dst4, len4, IMB_ERR_NULL_SRC },
                        { exp_key, iv1, iv2, iv3, iv4, src1, dst1, len1, src2, dst2, len2, src3,
                          dst3, len3, src4, NULL, len4, IMB_ERR_NULL_DST },
                        { exp_key, iv1, iv2, iv3, iv4, src1, dst1, len1, src2, dst2, len2, src3,
                          dst3, len3, src4, dst4, 0, IMB_ERR_CIPH_LEN } };

        /* Iterate over args */
        for (i = 0; i < DIM(fn_args); i++) {
                const struct fn_args *ap = &fn_args[i];

                IMB_SNOW3G_F8_4_BUFFER(mgr, ap->exp_key, ap->iv1, ap->iv2, ap->iv3, ap->iv4,
                                       ap->src1, ap->dst1, ap->len1, ap->src2, ap->dst2, ap->len2,
                                       ap->src3, ap->dst3, ap->len3, ap->src4, ap->dst4, ap->len4);
                if (unexpected_err(mgr, ap->exp_err, "IMB_SNOW3G_F8_4_BUFFER"))
                        return 1;
        }
        return 0;
}

/*
 * @brief Performs direct API invalid param tests for IMB_SNOW3G_F8_8_BUFFER */
static int
test_IMB_SNOW3G_F8_8_BUFFER(struct IMB_MGR *mgr)
{
        unsigned i = 1;
        const snow3g_key_schedule_t exp_key_s;
        const snow3g_key_schedule_t *exp_key = &exp_key_s;
        const uint8_t iv1[BUFF_SIZE];
        const uint8_t iv2[BUFF_SIZE];
        const uint8_t iv3[BUFF_SIZE];
        const uint8_t iv4[BUFF_SIZE];
        const uint8_t iv5[BUFF_SIZE];
        const uint8_t iv6[BUFF_SIZE];
        const uint8_t iv7[BUFF_SIZE];
        const uint8_t iv8[BUFF_SIZE];
        const uint8_t src1[BUFF_SIZE];
        uint8_t dst1[BUFF_SIZE];
        const uint32_t len1 = 1;
        const uint8_t src2[BUFF_SIZE];
        uint8_t dst2[BUFF_SIZE];
        const uint32_t len2 = 1;
        const uint8_t src3[BUFF_SIZE];
        uint8_t dst3[BUFF_SIZE];
        const uint32_t len3 = 1;
        const uint8_t src4[BUFF_SIZE];
        uint8_t dst4[BUFF_SIZE];
        const uint32_t len4 = 1;
        const uint8_t src5[BUFF_SIZE];
        uint8_t dst5[BUFF_SIZE];
        const uint32_t len5 = 1;
        const uint8_t src6[BUFF_SIZE];
        uint8_t dst6[BUFF_SIZE];
        const uint32_t len6 = 1;
        const uint8_t src7[BUFF_SIZE];
        uint8_t dst7[BUFF_SIZE];
        const uint32_t len7 = 1;
        const uint8_t src8[BUFF_SIZE];
        uint8_t dst8[BUFF_SIZE];
        const uint32_t len8 = 1;
        int seg_err; /* segfault flag */

        seg_err = setjmp(dir_api_param_env);
        if (seg_err) {
                printf("%s: segfault occurred!", __func__);
                return 1;
        }

        struct fn_args {
                const snow3g_key_schedule_t *exp_key;
                const void *iv1;
                const void *iv2;
                const void *iv3;
                const void *iv4;
                const void *iv5;
                const void *iv6;
                const void *iv7;
                const void *iv8;
                const void *src1;
                void *dst1;
                const uint32_t len1;
                const void *src2;
                void *dst2;
                const uint32_t len2;
                const void *src3;
                void *dst3;
                const uint32_t len3;
                const void *src4;
                void *dst4;
                const uint32_t len4;
                const void *src5;
                void *dst5;
                const uint32_t len5;
                const void *src6;
                void *dst6;
                const uint32_t len6;
                const void *src7;
                void *dst7;
                const uint32_t len7;
                const void *src8;
                void *dst8;
                const uint32_t len8;
                const IMB_ERR exp_err;
        } fn_args[] = {
                { NULL, iv1,
                  iv2,  iv3,
                  iv4,  iv5,
                  iv6,  iv7,
                  iv8,  src1,
                  dst1, len1,
                  src2, dst2,
                  len2, src3,
                  dst3, len3,
                  src4, dst4,
                  len4, src5,
                  dst5, len5,
                  src6, dst6,
                  len6, src7,
                  dst7, len7,
                  src8, dst8,
                  len8, IMB_ERR_NULL_EXP_KEY },
                { exp_key,        NULL, iv2,  iv3,  iv4,  iv5,  iv6,  iv7,  iv8,  src1, dst1,
                  len1,           src2, dst2, len2, src3, dst3, len3, src4, dst4, len4, src5,
                  dst5,           len5, src6, dst6, len6, src7, dst7, len7, src8, dst8, len8,
                  IMB_ERR_NULL_IV },
                { exp_key,        iv1,  NULL, iv3,  iv4,  iv5,  iv6,  iv7,  iv8,  src1, dst1,
                  len1,           src2, dst2, len2, src3, dst3, len3, src4, dst4, len4, src5,
                  dst5,           len5, src6, dst6, len6, src7, dst7, len7, src8, dst8, len8,
                  IMB_ERR_NULL_IV },
                { exp_key, iv1,  iv2,  NULL,           iv4,  iv5,  iv6,  iv7,  iv8,  src1,
                  dst1,    len1, src2, dst2,           len2, src3, dst3, len3, src4, dst4,
                  len4,    src5, dst5, len5,           src6, dst6, len6, src7, dst7, len7,
                  src8,    dst8, len8, IMB_ERR_NULL_IV },
                { exp_key,        iv1,  iv2,  iv3,  NULL, iv5,  iv6,  iv7,  iv8,  src1, dst1,
                  len1,           src2, dst2, len2, src3, dst3, len3, src4, dst4, len4, src5,
                  dst5,           len5, src6, dst6, len6, src7, dst7, len7, src8, dst8, len8,
                  IMB_ERR_NULL_IV },
                { exp_key,        iv1,  iv2,  iv3,  iv4,  NULL, iv6,  iv7,  iv8,  src1, dst1,
                  len1,           src2, dst2, len2, src3, dst3, len3, src4, dst4, len4, src5,
                  dst5,           len5, src6, dst6, len6, src7, dst7, len7, src8, dst8, len8,
                  IMB_ERR_NULL_IV },
                { exp_key, iv1,  iv2,  iv3,  iv4,  iv5,  NULL,           iv7,  iv8,
                  src1,    dst1, len1, src2, dst2, len2, src3,           dst3, len3,
                  src4,    dst4, len4, src5, dst5, len5, src6,           dst6, len6,
                  src7,    dst7, len7, src8, dst8, len8, IMB_ERR_NULL_IV },
                { exp_key,        iv1,  iv2,  iv3,  iv4,  iv5,  iv6,  NULL, iv8,  src1, dst1,
                  len1,           src2, dst2, len2, src3, dst3, len3, src4, dst4, len4, src5,
                  dst5,           len5, src6, dst6, len6, src7, dst7, len7, src8, dst8, len8,
                  IMB_ERR_NULL_IV },
                { exp_key,        iv1,  iv2,  iv3,  iv4,  iv5,  iv6,  iv7,  NULL, src1, dst1,
                  len1,           src2, dst2, len2, src3, dst3, len3, src4, dst4, len4, src5,
                  dst5,           len5, src6, dst6, len6, src7, dst7, len7, src8, dst8, len8,
                  IMB_ERR_NULL_IV },
                { exp_key, iv1,
                  iv2,     iv3,
                  iv4,     iv5,
                  iv6,     iv7,
                  iv8,     NULL,
                  dst1,    len1,
                  src2,    dst2,
                  len2,    src3,
                  dst3,    len3,
                  src4,    dst4,
                  len4,    src5,
                  dst5,    len5,
                  src6,    dst6,
                  len6,    src7,
                  dst7,    len7,
                  src8,    dst8,
                  len8,    IMB_ERR_NULL_SRC },
                { exp_key, iv1,
                  iv2,     iv3,
                  iv4,     iv5,
                  iv6,     iv7,
                  iv8,     src1,
                  NULL,    len1,
                  src2,    dst2,
                  len2,    src3,
                  dst3,    len3,
                  src4,    dst4,
                  len4,    src5,
                  dst5,    len5,
                  src6,    dst6,
                  len6,    src7,
                  dst7,    len7,
                  src8,    dst8,
                  len8,    IMB_ERR_NULL_DST },
                { exp_key, iv1,
                  iv2,     iv3,
                  iv4,     iv5,
                  iv6,     iv7,
                  iv8,     src1,
                  dst1,    0,
                  src2,    dst2,
                  len2,    src3,
                  dst3,    len3,
                  src4,    dst4,
                  len4,    src5,
                  dst5,    len5,
                  src6,    dst6,
                  len6,    src7,
                  dst7,    len7,
                  src8,    dst8,
                  len8,    IMB_ERR_CIPH_LEN },
                { exp_key, iv1,
                  iv2,     iv3,
                  iv4,     iv5,
                  iv6,     iv7,
                  iv8,     src1,
                  dst1,    len1,
                  NULL,    dst2,
                  len2,    src3,
                  dst3,    len3,
                  src4,    dst4,
                  len4,    src5,
                  dst5,    len5,
                  src6,    dst6,
                  len6,    src7,
                  dst7,    len7,
                  src8,    dst8,
                  len8,    IMB_ERR_NULL_SRC },
                { exp_key, iv1,
                  iv2,     iv3,
                  iv4,     iv5,
                  iv6,     iv7,
                  iv8,     src1,
                  dst1,    len1,
                  src2,    NULL,
                  len2,    src3,
                  dst3,    len3,
                  src4,    dst4,
                  len4,    src5,
                  dst5,    len5,
                  src6,    dst6,
                  len6,    src7,
                  dst7,    len7,
                  src8,    dst8,
                  len8,    IMB_ERR_NULL_DST },
                { exp_key, iv1,
                  iv2,     iv3,
                  iv4,     iv5,
                  iv6,     iv7,
                  iv8,     src1,
                  dst1,    len1,
                  src2,    dst2,
                  0,       src3,
                  dst3,    len3,
                  src4,    dst4,
                  len4,    src5,
                  dst5,    len5,
                  src6,    dst6,
                  len6,    src7,
                  dst7,    len7,
                  src8,    dst8,
                  len8,    IMB_ERR_CIPH_LEN },
                { exp_key, iv1,
                  iv2,     iv3,
                  iv4,     iv5,
                  iv6,     iv7,
                  iv8,     src1,
                  dst1,    len1,
                  src2,    dst2,
                  len2,    NULL,
                  dst3,    len3,
                  src4,    dst4,
                  len4,    src5,
                  dst5,    len5,
                  src6,    dst6,
                  len6,    src7,
                  dst7,    len7,
                  src8,    dst8,
                  len8,    IMB_ERR_NULL_SRC },
                { exp_key, iv1,
                  iv2,     iv3,
                  iv4,     iv5,
                  iv6,     iv7,
                  iv8,     src1,
                  dst1,    len1,
                  src2,    dst2,
                  len2,    src3,
                  NULL,    len3,
                  src4,    dst4,
                  len4,    src5,
                  dst5,    len5,
                  src6,    dst6,
                  len6,    src7,
                  dst7,    len7,
                  src8,    dst8,
                  len8,    IMB_ERR_NULL_DST },
                { exp_key, iv1,
                  iv2,     iv3,
                  iv4,     iv5,
                  iv6,     iv7,
                  iv8,     src1,
                  dst1,    len1,
                  src2,    dst2,
                  len2,    src3,
                  dst3,    0,
                  src4,    dst4,
                  len4,    src5,
                  dst5,    len5,
                  src6,    dst6,
                  len6,    src7,
                  dst7,    len7,
                  src8,    dst8,
                  len8,    IMB_ERR_CIPH_LEN },
                { exp_key, iv1,
                  iv2,     iv3,
                  iv4,     iv5,
                  iv6,     iv7,
                  iv8,     src1,
                  dst1,    len1,
                  src2,    dst2,
                  len2,    src3,
                  dst3,    len3,
                  NULL,    dst4,
                  len4,    src5,
                  dst5,    len5,
                  src6,    dst6,
                  len6,    src7,
                  dst7,    len7,
                  src8,    dst8,
                  len8,    IMB_ERR_NULL_SRC },
                { exp_key, iv1,
                  iv2,     iv3,
                  iv4,     iv5,
                  iv6,     iv7,
                  iv8,     src1,
                  dst1,    len1,
                  src2,    dst2,
                  len2,    src3,
                  dst3,    len3,
                  src4,    NULL,
                  len4,    src5,
                  dst5,    len5,
                  src6,    dst6,
                  len6,    src7,
                  dst7,    len7,
                  src8,    dst8,
                  len8,    IMB_ERR_NULL_DST },
                { exp_key, iv1,
                  iv2,     iv3,
                  iv4,     iv5,
                  iv6,     iv7,
                  iv8,     src1,
                  dst1,    len1,
                  src2,    dst2,
                  len2,    src3,
                  dst3,    len3,
                  src4,    dst4,
                  0,       src5,
                  dst5,    len5,
                  src6,    dst6,
                  len6,    src7,
                  dst7,    len7,
                  src8,    dst8,
                  len8,    IMB_ERR_CIPH_LEN },
                { exp_key, iv1,
                  iv2,     iv3,
                  iv4,     iv5,
                  iv6,     iv7,
                  iv8,     src1,
                  dst1,    len1,
                  src2,    dst2,
                  len2,    src3,
                  dst3,    len3,
                  src4,    dst4,
                  len4,    NULL,
                  dst5,    len5,
                  src6,    dst6,
                  len6,    src7,
                  dst7,    len7,
                  src8,    dst8,
                  len8,    IMB_ERR_NULL_SRC },
                { exp_key, iv1,
                  iv2,     iv3,
                  iv4,     iv5,
                  iv6,     iv7,
                  iv8,     src1,
                  dst1,    len1,
                  src2,    dst2,
                  len2,    src3,
                  dst3,    len3,
                  src4,    dst4,
                  len4,    src5,
                  NULL,    len5,
                  src6,    dst6,
                  len6,    src7,
                  dst7,    len7,
                  src8,    dst8,
                  len8,    IMB_ERR_NULL_DST },
                { exp_key, iv1,
                  iv2,     iv3,
                  iv4,     iv5,
                  iv6,     iv7,
                  iv8,     src1,
                  dst1,    len1,
                  src2,    dst2,
                  len2,    src3,
                  dst3,    len3,
                  src4,    dst4,
                  len4,    src5,
                  dst5,    0,
                  src6,    dst6,
                  len6,    src7,
                  dst7,    len7,
                  src8,    dst8,
                  len8,    IMB_ERR_CIPH_LEN },
                { exp_key, iv1,
                  iv2,     iv3,
                  iv4,     iv5,
                  iv6,     iv7,
                  iv8,     src1,
                  dst1,    len1,
                  src2,    dst2,
                  len2,    src3,
                  dst3,    len3,
                  src4,    dst4,
                  len4,    src5,
                  dst5,    len5,
                  NULL,    dst6,
                  len6,    src7,
                  dst7,    len7,
                  src8,    dst8,
                  len8,    IMB_ERR_NULL_SRC },
                { exp_key, iv1,
                  iv2,     iv3,
                  iv4,     iv5,
                  iv6,     iv7,
                  iv8,     src1,
                  dst1,    len1,
                  src2,    dst2,
                  len2,    src3,
                  dst3,    len3,
                  src4,    dst4,
                  len4,    src5,
                  dst5,    len5,
                  src6,    NULL,
                  len6,    src7,
                  dst7,    len7,
                  src8,    dst8,
                  len8,    IMB_ERR_NULL_DST },
                { exp_key, iv1,
                  iv2,     iv3,
                  iv4,     iv5,
                  iv6,     iv7,
                  iv8,     src1,
                  dst1,    len1,
                  src2,    dst2,
                  len2,    src3,
                  dst3,    len3,
                  src4,    dst4,
                  len4,    src5,
                  dst5,    len5,
                  src6,    dst6,
                  0,       src7,
                  dst7,    len7,
                  src8,    dst8,
                  len8,    IMB_ERR_CIPH_LEN },
                { exp_key, iv1,
                  iv2,     iv3,
                  iv4,     iv5,
                  iv6,     iv7,
                  iv8,     src1,
                  dst1,    len1,
                  src2,    dst2,
                  len2,    src3,
                  dst3,    len3,
                  src4,    dst4,
                  len4,    src5,
                  dst5,    len5,
                  src6,    dst6,
                  len6,    NULL,
                  dst7,    len7,
                  src8,    dst8,
                  len8,    IMB_ERR_NULL_SRC },
                { exp_key, iv1,
                  iv2,     iv3,
                  iv4,     iv5,
                  iv6,     iv7,
                  iv8,     src1,
                  dst1,    len1,
                  src2,    dst2,
                  len2,    src3,
                  dst3,    len3,
                  src4,    dst4,
                  len4,    src5,
                  dst5,    len5,
                  src6,    dst6,
                  len6,    src7,
                  NULL,    len7,
                  src8,    dst8,
                  len8,    IMB_ERR_NULL_DST },
                { exp_key, iv1,
                  iv2,     iv3,
                  iv4,     iv5,
                  iv6,     iv7,
                  iv8,     src1,
                  dst1,    len1,
                  src2,    dst2,
                  len2,    src3,
                  dst3,    len3,
                  src4,    dst4,
                  len4,    src5,
                  dst5,    len5,
                  src6,    dst6,
                  len6,    src7,
                  dst7,    0,
                  src8,    dst8,
                  len8,    IMB_ERR_CIPH_LEN },
                { exp_key, iv1,
                  iv2,     iv3,
                  iv4,     iv5,
                  iv6,     iv7,
                  iv8,     src1,
                  dst1,    len1,
                  src2,    dst2,
                  len2,    src3,
                  dst3,    len3,
                  src4,    dst4,
                  len4,    src5,
                  dst5,    len5,
                  src6,    dst6,
                  len6,    src7,
                  dst7,    len7,
                  NULL,    dst8,
                  len8,    IMB_ERR_NULL_SRC },
                { exp_key, iv1,
                  iv2,     iv3,
                  iv4,     iv5,
                  iv6,     iv7,
                  iv8,     src1,
                  dst1,    len1,
                  src2,    dst2,
                  len2,    src3,
                  dst3,    len3,
                  src4,    dst4,
                  len4,    src5,
                  dst5,    len5,
                  src6,    dst6,
                  len6,    src7,
                  dst7,    len7,
                  src8,    NULL,
                  len8,    IMB_ERR_NULL_DST },
                { exp_key, iv1,
                  iv2,     iv3,
                  iv4,     iv5,
                  iv6,     iv7,
                  iv8,     src1,
                  dst1,    len1,
                  src2,    dst2,
                  len2,    src3,
                  dst3,    len3,
                  src4,    dst4,
                  len4,    src5,
                  dst5,    len5,
                  src6,    dst6,
                  len6,    src7,
                  dst7,    len7,
                  src8,    dst8,
                  0,       IMB_ERR_CIPH_LEN }
        };

        /* Iterate over args */
        for (i = 0; i < DIM(fn_args); i++) {
                const struct fn_args *ap = &fn_args[i];

                IMB_SNOW3G_F8_8_BUFFER(mgr, ap->exp_key, ap->iv1, ap->iv2, ap->iv3, ap->iv4,
                                       ap->iv5, ap->iv6, ap->iv7, ap->iv8, ap->src1, ap->dst1,
                                       ap->len1, ap->src2, ap->dst2, ap->len2, ap->src3, ap->dst3,
                                       ap->len3, ap->src4, ap->dst4, ap->len4, ap->src5, ap->dst5,
                                       ap->len5, ap->src6, ap->dst6, ap->len6, ap->src7, ap->dst7,
                                       ap->len7, ap->src8, ap->dst8, ap->len8);
                if (unexpected_err(mgr, ap->exp_err, "IMB_SNOW3G_F8_8_BUFFER"))
                        return 1;
        }
        return 0;
}

/*
 * @brief Performs direct API invalid param tests for IMB_SNOW3G_F8_N_BUFFER */
static int
test_IMB_SNOW3G_F8_N_BUFFER(struct IMB_MGR *mgr)
{
        unsigned i = 1;
        const snow3g_key_schedule_t exp_key_s;
        const snow3g_key_schedule_t *exp_key = &exp_key_s;
        const void *iv[MAX_BUFFS];
        const void *iv_NULL_pts[MAX_BUFFS];
        const uint8_t iv_s[MAX_BUFFS][BUFF_SIZE];
        const void *src[MAX_BUFFS];
        const void *src_NULL_pts[MAX_BUFFS];
        const uint8_t src_s[MAX_BUFFS][BUFF_SIZE];
        void *dst[MAX_BUFFS];
        void *dst_NULL_pts[MAX_BUFFS];
        uint8_t dst_s[MAX_BUFFS][BUFF_SIZE];
        const uint32_t len[MAX_BUFFS] = { 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 };
        const uint32_t count = MAX_BUFFS;
        int seg_err; /* segfault flag */

        seg_err = setjmp(dir_api_param_env);
        if (seg_err) {
                printf("%s: segfault occurred!", __func__);
                return 1;
        }

        for (i = 0; i < MAX_BUFFS; i++) {
                iv[i] = iv_s[i];
                iv_NULL_pts[i] = NULL;
                src[i] = src_s[i];
                src_NULL_pts[i] = NULL;
                dst[i] = dst_s[i];
                dst_NULL_pts[i] = NULL;
        }

        struct fn_args {
                const snow3g_key_schedule_t *exp_key;
                const void *const *iv;
                const void *const *src;
                void **dst;
                const uint32_t *len;
                const uint32_t count;
                const IMB_ERR exp_err;
        } fn_args[] = { { NULL, iv, src, dst, len, count, IMB_ERR_NULL_EXP_KEY },
                        { exp_key, iv_NULL_pts, src, dst, len, count, IMB_ERR_NULL_IV },
                        { exp_key, NULL, src, dst, len, count, IMB_ERR_NULL_IV },
                        { exp_key, iv, src_NULL_pts, dst, len, count, IMB_ERR_NULL_SRC },
                        { exp_key, iv, NULL, dst, len, count, IMB_ERR_NULL_SRC },
                        { exp_key, iv, src, dst_NULL_pts, len, count, IMB_ERR_NULL_DST },
                        { exp_key, iv, src, NULL, len, count, IMB_ERR_NULL_DST },
                        { exp_key, iv, src, dst, 0, count, IMB_ERR_CIPH_LEN } };

        /* Iterate over args */
        for (i = 0; i < DIM(fn_args); i++) {
                const struct fn_args *ap = &fn_args[i];

                IMB_SNOW3G_F8_N_BUFFER(mgr, ap->exp_key, ap->iv, ap->src, ap->dst, ap->len,
                                       ap->count);
                if (unexpected_err(mgr, ap->exp_err, "IMB_SNOW3G_F8_N_BUFFER"))
                        return 1;
        }
        return 0;
}

/*
 * @brief Performs direct API invalid param tests for
 * IMB_SNOW3G_F8_8_BUFFER_MULTIKEY */
static int
test_IMB_SNOW3G_F8_8_BUFFER_MULTIKEY(struct IMB_MGR *mgr)
{
        unsigned i = 1;
        const snow3g_key_schedule_t *exp_key[MAX_BUFFS];
        const snow3g_key_schedule_t *exp_key_NULL_pts[MAX_BUFFS];
        const snow3g_key_schedule_t exp_key_s[MAX_BUFFS][BUFF_SIZE];
        const void *iv[MAX_BUFFS];
        const void *iv_NULL_pts[MAX_BUFFS];
        const uint8_t iv_s[MAX_BUFFS][BUFF_SIZE];
        const void *src[MAX_BUFFS];
        const void *src_NULL_pts[MAX_BUFFS];
        const uint8_t src_s[MAX_BUFFS][BUFF_SIZE];
        void *dst[MAX_BUFFS];
        void *dst_NULL_pts[MAX_BUFFS];
        uint8_t dst_s[MAX_BUFFS][BUFF_SIZE];
        const uint32_t len[MAX_BUFFS] = { 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 };
        int seg_err; /* segfault flag */

        seg_err = setjmp(dir_api_param_env);
        if (seg_err) {
                printf("%s: segfault occurred!", __func__);
                return 1;
        }

        for (i = 0; i < MAX_BUFFS; i++) {
                exp_key[i] = exp_key_s[i];
                exp_key_NULL_pts[i] = NULL;
                iv[i] = iv_s[i];
                iv_NULL_pts[i] = NULL;
                src[i] = src_s[i];
                src_NULL_pts[i] = NULL;
                dst[i] = dst_s[i];
                dst_NULL_pts[i] = NULL;
        }

        struct fn_args {
                const snow3g_key_schedule_t *const *exp_key;
                const void *const *iv;
                const void *const *src;
                void **dst;
                const uint32_t *len;
                const IMB_ERR exp_err;
        } fn_args[] = { { exp_key_NULL_pts, iv, src, dst, len, IMB_ERR_NULL_EXP_KEY },
                        { NULL, iv, src, dst, len, IMB_ERR_NULL_EXP_KEY },
                        { exp_key, iv_NULL_pts, src, dst, len, IMB_ERR_NULL_IV },
                        { exp_key, NULL, src, dst, len, IMB_ERR_NULL_IV },
                        { exp_key, iv, src_NULL_pts, dst, len, IMB_ERR_NULL_SRC },
                        { exp_key, iv, NULL, dst, len, IMB_ERR_NULL_SRC },
                        { exp_key, iv, src, dst_NULL_pts, len, IMB_ERR_NULL_DST },
                        { exp_key, iv, src, NULL, len, IMB_ERR_NULL_DST },
                        { exp_key, iv, src, dst, 0, IMB_ERR_CIPH_LEN } };

        /* Iterate over args */
        for (i = 0; i < DIM(fn_args); i++) {
                const struct fn_args *ap = &fn_args[i];

                IMB_SNOW3G_F8_8_BUFFER_MULTIKEY(mgr, ap->exp_key, ap->iv, ap->src, ap->dst,
                                                ap->len);
                if (unexpected_err(mgr, ap->exp_err, "IMB_SNOW3G_F8_8_BUFFER_MULTIKEY"))
                        return 1;
        }
        return 0;
}

/*
 * @brief Performs direct API invalid param tests for
 * IMB_SNOW3G_F8_N_BUFFER_MULTIKEY */
static int
test_IMB_SNOW3G_F8_N_BUFFER_MULTIKEY(struct IMB_MGR *mgr)
{
        unsigned i = 1;
        const snow3g_key_schedule_t *exp_key[MAX_BUFFS];
        const snow3g_key_schedule_t *exp_key_NULL_pts[MAX_BUFFS];
        const snow3g_key_schedule_t exp_key_s[MAX_BUFFS][BUFF_SIZE];
        const void *iv[MAX_BUFFS];
        const void *iv_NULL_pts[MAX_BUFFS];
        const uint8_t iv_s[MAX_BUFFS][BUFF_SIZE];
        const void *src[MAX_BUFFS];
        const void *src_NULL_pts[MAX_BUFFS];
        const uint8_t src_s[MAX_BUFFS][BUFF_SIZE];
        void *dst[MAX_BUFFS];
        void *dst_NULL_pts[MAX_BUFFS];
        uint8_t dst_s[MAX_BUFFS][BUFF_SIZE];
        const uint32_t len[MAX_BUFFS] = { 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 };
        const uint32_t count = MAX_BUFFS;
        int seg_err; /* segfault flag */

        seg_err = setjmp(dir_api_param_env);
        if (seg_err) {
                printf("%s: segfault occurred!", __func__);
                return 1;
        }

        for (i = 0; i < MAX_BUFFS; i++) {
                exp_key[i] = exp_key_s[i];
                exp_key_NULL_pts[i] = NULL;
                iv[i] = iv_s[i];
                iv_NULL_pts[i] = NULL;
                src[i] = src_s[i];
                src_NULL_pts[i] = NULL;
                dst[i] = dst_s[i];
                dst_NULL_pts[i] = NULL;
        }

        struct fn_args {
                const snow3g_key_schedule_t *const *exp_key;
                const void *const *iv;
                const void *const *src;
                void **dst;
                const uint32_t *len;
                const uint32_t count;
                const IMB_ERR exp_err;
        } fn_args[] = { { exp_key_NULL_pts, iv, src, dst, len, count, IMB_ERR_NULL_EXP_KEY },
                        { NULL, iv, src, dst, len, count, IMB_ERR_NULL_EXP_KEY },
                        { exp_key, iv_NULL_pts, src, dst, len, count, IMB_ERR_NULL_IV },
                        { exp_key, NULL, src, dst, len, count, IMB_ERR_NULL_IV },
                        { exp_key, iv, src_NULL_pts, dst, len, count, IMB_ERR_NULL_SRC },
                        { exp_key, iv, NULL, dst, len, count, IMB_ERR_NULL_SRC },
                        { exp_key, iv, src, dst_NULL_pts, len, count, IMB_ERR_NULL_DST },
                        { exp_key, iv, src, NULL, len, count, IMB_ERR_NULL_DST },
                        { exp_key, iv, src, dst, 0, count, IMB_ERR_CIPH_LEN } };

        /* Iterate over args */
        for (i = 0; i < DIM(fn_args); i++) {
                const struct fn_args *ap = &fn_args[i];

                IMB_SNOW3G_F8_N_BUFFER_MULTIKEY(mgr, ap->exp_key, ap->iv, ap->src, ap->dst, ap->len,
                                                ap->count);
                if (unexpected_err(mgr, ap->exp_err, "IMB_SNOW3G_F8_N_BUFFER_MULTIKEY"))
                        return 1;
        }
        return 0;
}

/*
 * @brief Performs direct API invalid param tests for IMB_SNOW3G_F9_1_BUFFER */
static int
test_IMB_SNOW3G_F9_1_BUFFER(struct IMB_MGR *mgr)
{
        unsigned i = 1;
        const snow3g_key_schedule_t exp_key_s;
        const snow3g_key_schedule_t *exp_key = &exp_key_s;
        const uint8_t iv[BUFF_SIZE];
        const uint8_t src[BUFF_SIZE];
        const uint64_t len = 1;
        uint8_t tag[BUFF_SIZE];
        int seg_err; /* segfault flag */

        seg_err = setjmp(dir_api_param_env);
        if (seg_err) {
                printf("%s: segfault occurred!", __func__);
                return 1;
        }

        struct fn_args {
                const snow3g_key_schedule_t *exp_key;
                const void *iv;
                const void *src;
                const uint64_t len;
                void *tag;
                const IMB_ERR exp_err;
        } fn_args[] = { { NULL, iv, src, len, tag, IMB_ERR_NULL_EXP_KEY },
                        { exp_key, NULL, src, len, tag, IMB_ERR_NULL_IV },
                        { exp_key, iv, NULL, len, tag, IMB_ERR_NULL_SRC },
                        { exp_key, iv, src, 0, tag, IMB_ERR_AUTH_LEN },
                        { exp_key, iv, src, len, NULL, IMB_ERR_NULL_AUTH } };

        /* Iterate over args */
        for (i = 0; i < DIM(fn_args); i++) {
                const struct fn_args *ap = &fn_args[i];

                IMB_SNOW3G_F9_1_BUFFER(mgr, ap->exp_key, ap->iv, ap->src, ap->len, ap->tag);
                if (unexpected_err(mgr, ap->exp_err, "IMB_SNOW3G_F9_1_BUFFER"))
                        return 1;
        }
        return 0;
}

/*
 * @brief Performs direct API invalid param tests for IMB_SNOW3G_INIT_KEY_SCHED
 */
static int
test_IMB_SNOW3G_INIT_KEY_SCHED(struct IMB_MGR *mgr)
{
        unsigned i = 1;
        const uint8_t key[BUFF_SIZE];
        snow3g_key_schedule_t exp_key_s;
        snow3g_key_schedule_t *exp_key = &exp_key_s;
        int seg_err; /* segfault flag */

        seg_err = setjmp(dir_api_param_env);
        if (seg_err) {
                printf("%s: segfault occurred!", __func__);
                return 1;
        }

        struct fn_args {
                const void *key;
                snow3g_key_schedule_t *exp_key;
                const IMB_ERR exp_err;
        } fn_args[] = { { NULL, exp_key, IMB_ERR_NULL_KEY }, { key, NULL, IMB_ERR_NULL_EXP_KEY } };

        /* Iterate over args */
        for (i = 0; i < DIM(fn_args); i++) {
                const struct fn_args *ap = &fn_args[i];

                IMB_SNOW3G_INIT_KEY_SCHED(mgr, ap->key, ap->exp_key);
                if (unexpected_err(mgr, ap->exp_err, "IMB_SNOW3G_INIT_KEY_SCHED"))
                        return 1;
        }
        return 0;
}

/*
 * @brief Performs direct API invalid param tests for IMB_GHASH */
static int
test_IMB_GHASH(struct IMB_MGR *mgr)
{
        unsigned i = 1;
        struct gcm_key_data exp_key_s;
        struct gcm_key_data *exp_key = &exp_key_s;
        const uint8_t src[BUFF_SIZE];
        const uint64_t len = 1;
        uint8_t tag[BUFF_SIZE];
        const uint64_t tagl = 1;
        int seg_err; /* segfault flag */

        seg_err = setjmp(dir_api_param_env);
        if (seg_err) {
                printf("%s: segfault occurred!", __func__);
                return 1;
        }

        struct fn_args {
                struct gcm_key_data *exp_key;
                const void *src;
                const uint64_t len;
                void *tag;
                const uint64_t tagl;
                const IMB_ERR exp_err;
        } fn_args[] = { { NULL, src, len, tag, tagl, IMB_ERR_NULL_EXP_KEY },
                        { exp_key, NULL, len, tag, tagl, IMB_ERR_NULL_SRC },
                        { exp_key, src, 0, tag, tagl, IMB_ERR_AUTH_LEN },
                        { exp_key, src, len, NULL, tagl, IMB_ERR_NULL_AUTH },
                        { exp_key, src, len, tag, 0, IMB_ERR_AUTH_TAG_LEN } };

        /* Iterate over args */
        for (i = 0; i < DIM(fn_args); i++) {
                const struct fn_args *ap = &fn_args[i];

                IMB_GHASH(mgr, ap->exp_key, ap->src, ap->len, ap->tag, ap->tagl);
                if (unexpected_err(mgr, ap->exp_err, "IMB_GHASH"))
                        return 1;
        }
        return 0;
}

/*
 * @brief Performs direct API invalid param tests for IMB_ZUC_EIA3_N_BUFFER */
static int
test_IMB_ZUC_EIA3_N_BUFFER(struct IMB_MGR *mgr)
{
        unsigned i = 1;
        const void *key[MAX_BUFFS];
        const void *key_NULL_pts[MAX_BUFFS];
        const uint8_t key_s[MAX_BUFFS][BUFF_SIZE];
        const void *iv[MAX_BUFFS];
        const void *iv_NULL_pts[MAX_BUFFS];
        const uint8_t iv_s[MAX_BUFFS][BUFF_SIZE];
        const void *src[MAX_BUFFS];
        const void *src_NULL_pts[MAX_BUFFS];
        const uint8_t src_s[MAX_BUFFS][BUFF_SIZE];
        const uint32_t len_all_zero[MAX_BUFFS] = {
                0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
        };
        const uint32_t len[MAX_BUFFS] = { 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 };
        uint32_t *tag[MAX_BUFFS];
        uint32_t *tag_NULL_pts[MAX_BUFFS];
        uint32_t tag_s[MAX_BUFFS][BUFF_SIZE];
        const uint32_t count = MAX_BUFFS;
        int seg_err; /* segfault flag */

        seg_err = setjmp(dir_api_param_env);
        if (seg_err) {
                printf("%s: segfault occurred!", __func__);
                return 1;
        }

        for (i = 0; i < MAX_BUFFS; i++) {
                key[i] = key_s[i];
                key_NULL_pts[i] = NULL;
                iv[i] = iv_s[i];
                iv_NULL_pts[i] = NULL;
                src[i] = src_s[i];
                src_NULL_pts[i] = NULL;
                tag[i] = tag_s[i];
                tag_NULL_pts[i] = NULL;
        }

        struct fn_args {
                const void *const *key;
                const void *const *iv;
                const void *const *src;
                const uint32_t *len;
                uint32_t **tag;
                const uint32_t count;
                const IMB_ERR exp_err;
        } fn_args[] = { { key_NULL_pts, iv, src, len, tag, count, IMB_ERR_NULL_KEY },
                        { NULL, iv, src, len, tag, count, IMB_ERR_NULL_KEY },
                        { key, iv_NULL_pts, src, len, tag, count, IMB_ERR_NULL_IV },
                        { key, NULL, src, len, tag, count, IMB_ERR_NULL_IV },
                        { key, iv, src_NULL_pts, len, tag, count, IMB_ERR_NULL_SRC },
                        { key, iv, NULL, len, tag, count, IMB_ERR_NULL_SRC },
                        { key, iv, src, len_all_zero, tag, count, IMB_ERR_AUTH_LEN },
                        { key, iv, src, len, tag_NULL_pts, count, IMB_ERR_NULL_AUTH },
                        { key, iv, src, len, NULL, count, IMB_ERR_NULL_AUTH } };

        /* Iterate over args */
        for (i = 0; i < DIM(fn_args); i++) {
                const struct fn_args *ap = &fn_args[i];

                IMB_ZUC_EIA3_N_BUFFER(mgr, ap->key, ap->iv, ap->src, ap->len, ap->tag, ap->count);
                if (unexpected_err(mgr, ap->exp_err, "IMB_ZUC_EIA3_N_BUFFER"))
                        return 1;
        }
        return 0;
}

/*
 * @brief Performs direct API invalid param tests for IMB_AES128_GCM_INIT_VAR_IV
 */
static int
test_IMB_AES128_GCM_INIT_VAR_IV(struct IMB_MGR *mgr)
{
        unsigned i = 1;
        const struct gcm_key_data exp_key_s;
        const struct gcm_key_data *exp_key = &exp_key_s;
        struct gcm_context_data ctx_s;
        struct gcm_context_data *ctx = &ctx_s;
        const uint8_t iv[BUFF_SIZE];
        const uint64_t ivl = 1;
        const uint8_t aad[BUFF_SIZE];
        const uint64_t aadl = 1;
        int seg_err; /* segfault flag */

        seg_err = setjmp(dir_api_param_env);
        if (seg_err) {
                printf("%s: segfault occurred!", __func__);
                return 1;
        }

        struct fn_args {
                const struct gcm_key_data *exp_key;
                struct gcm_context_data *ctx;
                const uint8_t *iv;
                const uint64_t ivl;
                const uint8_t *aad;
                const uint64_t aadl;
                const IMB_ERR exp_err;
        } fn_args[] = { { NULL, ctx, iv, ivl, aad, aadl, IMB_ERR_NULL_EXP_KEY },
                        { exp_key, NULL, iv, ivl, aad, aadl, IMB_ERR_NULL_CTX },
                        { exp_key, ctx, NULL, ivl, aad, aadl, IMB_ERR_NULL_IV },
                        { exp_key, ctx, iv, 0, aad, aadl, IMB_ERR_IV_LEN },
                        { exp_key, ctx, iv, ivl, NULL, aadl, IMB_ERR_NULL_AAD } };

        /* Iterate over args */
        for (i = 0; i < DIM(fn_args); i++) {
                const struct fn_args *ap = &fn_args[i];

                IMB_AES128_GCM_INIT_VAR_IV(mgr, ap->exp_key, ap->ctx, ap->iv, ap->ivl, ap->aad,
                                           ap->aadl);
                if (unexpected_err(mgr, ap->exp_err, "IMB_AES128_GCM_INIT_VAR_IV"))
                        return 1;
        }
        return 0;
}

/*
 * @brief Performs direct API invalid param tests for IMB_AES192_GCM_INIT_VAR_IV
 */
static int
test_IMB_AES192_GCM_INIT_VAR_IV(struct IMB_MGR *mgr)
{
        unsigned i = 1;
        const struct gcm_key_data exp_key_s;
        const struct gcm_key_data *exp_key = &exp_key_s;
        struct gcm_context_data ctx_s;
        struct gcm_context_data *ctx = &ctx_s;
        const uint8_t iv[BUFF_SIZE];
        const uint64_t ivl = 1;
        const uint8_t aad[BUFF_SIZE];
        const uint64_t aadl = 1;
        int seg_err; /* segfault flag */

        seg_err = setjmp(dir_api_param_env);
        if (seg_err) {
                printf("%s: segfault occurred!", __func__);
                return 1;
        }

        struct fn_args {
                const struct gcm_key_data *exp_key;
                struct gcm_context_data *ctx;
                const uint8_t *iv;
                const uint64_t ivl;
                const uint8_t *aad;
                const uint64_t aadl;
                const IMB_ERR exp_err;
        } fn_args[] = { { NULL, ctx, iv, ivl, aad, aadl, IMB_ERR_NULL_EXP_KEY },
                        { exp_key, NULL, iv, ivl, aad, aadl, IMB_ERR_NULL_CTX },
                        { exp_key, ctx, NULL, ivl, aad, aadl, IMB_ERR_NULL_IV },
                        { exp_key, ctx, iv, 0, aad, aadl, IMB_ERR_IV_LEN },
                        { exp_key, ctx, iv, ivl, NULL, aadl, IMB_ERR_NULL_AAD } };

        /* Iterate over args */
        for (i = 0; i < DIM(fn_args); i++) {
                const struct fn_args *ap = &fn_args[i];

                IMB_AES192_GCM_INIT_VAR_IV(mgr, ap->exp_key, ap->ctx, ap->iv, ap->ivl, ap->aad,
                                           ap->aadl);
                if (unexpected_err(mgr, ap->exp_err, "IMB_AES192_GCM_INIT_VAR_IV"))
                        return 1;
        }
        return 0;
}

/*
 * @brief Performs direct API invalid param tests for IMB_AES256_GCM_INIT_VAR_IV
 */
static int
test_IMB_AES256_GCM_INIT_VAR_IV(struct IMB_MGR *mgr)
{
        unsigned i = 1;
        const struct gcm_key_data exp_key_s;
        const struct gcm_key_data *exp_key = &exp_key_s;
        struct gcm_context_data ctx_s;
        struct gcm_context_data *ctx = &ctx_s;
        const uint8_t iv[BUFF_SIZE];
        const uint64_t ivl = 1;
        const uint8_t aad[BUFF_SIZE];
        const uint64_t aadl = 1;
        int seg_err; /* segfault flag */

        seg_err = setjmp(dir_api_param_env);
        if (seg_err) {
                printf("%s: segfault occurred!", __func__);
                return 1;
        }

        struct fn_args {
                const struct gcm_key_data *exp_key;
                struct gcm_context_data *ctx;
                const uint8_t *iv;
                const uint64_t ivl;
                const uint8_t *aad;
                const uint64_t aadl;
                const IMB_ERR exp_err;
        } fn_args[] = { { NULL, ctx, iv, ivl, aad, aadl, IMB_ERR_NULL_EXP_KEY },
                        { exp_key, NULL, iv, ivl, aad, aadl, IMB_ERR_NULL_CTX },
                        { exp_key, ctx, NULL, ivl, aad, aadl, IMB_ERR_NULL_IV },
                        { exp_key, ctx, iv, 0, aad, aadl, IMB_ERR_IV_LEN },
                        { exp_key, ctx, iv, ivl, NULL, aadl, IMB_ERR_NULL_AAD } };

        /* Iterate over args */
        for (i = 0; i < DIM(fn_args); i++) {
                const struct fn_args *ap = &fn_args[i];

                IMB_AES256_GCM_INIT_VAR_IV(mgr, ap->exp_key, ap->ctx, ap->iv, ap->ivl, ap->aad,
                                           ap->aadl);
                if (unexpected_err(mgr, ap->exp_err, "IMB_AES256_GCM_INIT_VAR_IV"))
                        return 1;
        }
        return 0;
}

/*
 * @brief Performs direct API invalid param tests for IMB_AES128_GMAC_INIT */
static int
test_IMB_AES128_GMAC_INIT(struct IMB_MGR *mgr)
{
        unsigned i = 1;
        const struct gcm_key_data exp_key_s;
        const struct gcm_key_data *exp_key = &exp_key_s;
        struct gcm_context_data ctx_s;
        struct gcm_context_data *ctx = &ctx_s;
        const uint8_t iv[BUFF_SIZE];
        const uint64_t ivl = 1;
        int seg_err; /* segfault flag */

        seg_err = setjmp(dir_api_param_env);
        if (seg_err) {
                printf("%s: segfault occurred!", __func__);
                return 1;
        }

        struct fn_args {
                const struct gcm_key_data *exp_key;
                struct gcm_context_data *ctx;
                const uint8_t *iv;
                const uint64_t ivl;
                const IMB_ERR exp_err;
        } fn_args[] = { { NULL, ctx, iv, ivl, IMB_ERR_NULL_EXP_KEY },
                        { exp_key, NULL, iv, ivl, IMB_ERR_NULL_CTX },
                        { exp_key, ctx, NULL, ivl, IMB_ERR_NULL_IV },
                        { exp_key, ctx, iv, 0, IMB_ERR_IV_LEN } };

        /* Iterate over args */
        for (i = 0; i < DIM(fn_args); i++) {
                const struct fn_args *ap = &fn_args[i];

                IMB_AES128_GMAC_INIT(mgr, ap->exp_key, ap->ctx, ap->iv, ap->ivl);
                if (unexpected_err(mgr, ap->exp_err, "IMB_AES128_GMAC_INIT"))
                        return 1;
        }
        return 0;
}

/*
 * @brief Performs direct API invalid param tests for IMB_AES192_GMAC_INIT */
static int
test_IMB_AES192_GMAC_INIT(struct IMB_MGR *mgr)
{
        unsigned i = 1;
        const struct gcm_key_data exp_key_s;
        const struct gcm_key_data *exp_key = &exp_key_s;
        struct gcm_context_data ctx_s;
        struct gcm_context_data *ctx = &ctx_s;
        const uint8_t iv[BUFF_SIZE];
        const uint64_t ivl = 1;
        int seg_err; /* segfault flag */

        seg_err = setjmp(dir_api_param_env);
        if (seg_err) {
                printf("%s: segfault occurred!", __func__);
                return 1;
        }

        struct fn_args {
                const struct gcm_key_data *exp_key;
                struct gcm_context_data *ctx;
                const uint8_t *iv;
                const uint64_t ivl;
                const IMB_ERR exp_err;
        } fn_args[] = { { NULL, ctx, iv, ivl, IMB_ERR_NULL_EXP_KEY },
                        { exp_key, NULL, iv, ivl, IMB_ERR_NULL_CTX },
                        { exp_key, ctx, NULL, ivl, IMB_ERR_NULL_IV },
                        { exp_key, ctx, iv, 0, IMB_ERR_IV_LEN } };

        /* Iterate over args */
        for (i = 0; i < DIM(fn_args); i++) {
                const struct fn_args *ap = &fn_args[i];

                IMB_AES192_GMAC_INIT(mgr, ap->exp_key, ap->ctx, ap->iv, ap->ivl);
                if (unexpected_err(mgr, ap->exp_err, "IMB_AES192_GMAC_INIT"))
                        return 1;
        }
        return 0;
}

/*
 * @brief Performs direct API invalid param tests for IMB_AES256_GMAC_INIT */
static int
test_IMB_AES256_GMAC_INIT(struct IMB_MGR *mgr)
{
        unsigned i = 1;
        const struct gcm_key_data exp_key_s;
        const struct gcm_key_data *exp_key = &exp_key_s;
        struct gcm_context_data ctx_s;
        struct gcm_context_data *ctx = &ctx_s;
        const uint8_t iv[BUFF_SIZE];
        const uint64_t ivl = 1;
        int seg_err; /* segfault flag */

        seg_err = setjmp(dir_api_param_env);
        if (seg_err) {
                printf("%s: segfault occurred!", __func__);
                return 1;
        }

        struct fn_args {
                const struct gcm_key_data *exp_key;
                struct gcm_context_data *ctx;
                const uint8_t *iv;
                const uint64_t ivl;
                const IMB_ERR exp_err;
        } fn_args[] = { { NULL, ctx, iv, ivl, IMB_ERR_NULL_EXP_KEY },
                        { exp_key, NULL, iv, ivl, IMB_ERR_NULL_CTX },
                        { exp_key, ctx, NULL, ivl, IMB_ERR_NULL_IV },
                        { exp_key, ctx, iv, 0, IMB_ERR_IV_LEN } };

        /* Iterate over args */
        for (i = 0; i < DIM(fn_args); i++) {
                const struct fn_args *ap = &fn_args[i];

                IMB_AES256_GMAC_INIT(mgr, ap->exp_key, ap->ctx, ap->iv, ap->ivl);
                if (unexpected_err(mgr, ap->exp_err, "IMB_AES256_GMAC_INIT"))
                        return 1;
        }
        return 0;
}

/*
 * @brief Performs direct API invalid param tests for IMB_AES128_GMAC_UPDATE */
static int
test_IMB_AES128_GMAC_UPDATE(struct IMB_MGR *mgr)
{
        unsigned i = 1;
        const struct gcm_key_data exp_key_s;
        const struct gcm_key_data *exp_key = &exp_key_s;
        struct gcm_context_data ctx_s;
        struct gcm_context_data *ctx = &ctx_s;
        const uint8_t src[BUFF_SIZE];
        const uint64_t len = 1;
        int seg_err; /* segfault flag */

        seg_err = setjmp(dir_api_param_env);
        if (seg_err) {
                printf("%s: segfault occurred!", __func__);
                return 1;
        }

        struct fn_args {
                const struct gcm_key_data *exp_key;
                struct gcm_context_data *ctx;
                const uint8_t *src;
                const uint64_t len;
                const IMB_ERR exp_err;
        } fn_args[] = { { NULL, ctx, src, len, IMB_ERR_NULL_EXP_KEY },
                        { exp_key, NULL, src, len, IMB_ERR_NULL_CTX },
                        { exp_key, ctx, NULL, len, IMB_ERR_NULL_SRC } };

        /* Iterate over args */
        for (i = 0; i < DIM(fn_args); i++) {
                const struct fn_args *ap = &fn_args[i];

                IMB_AES128_GMAC_UPDATE(mgr, ap->exp_key, ap->ctx, ap->src, ap->len);
                if (unexpected_err(mgr, ap->exp_err, "IMB_AES128_GMAC_UPDATE"))
                        return 1;
        }
        return 0;
}

/*
 * @brief Performs direct API invalid param tests for IMB_AES192_GMAC_UPDATE */
static int
test_IMB_AES192_GMAC_UPDATE(struct IMB_MGR *mgr)
{
        unsigned i = 1;
        const struct gcm_key_data exp_key_s;
        const struct gcm_key_data *exp_key = &exp_key_s;
        struct gcm_context_data ctx_s;
        struct gcm_context_data *ctx = &ctx_s;
        const uint8_t src[BUFF_SIZE];
        const uint64_t len = 1;
        int seg_err; /* segfault flag */

        seg_err = setjmp(dir_api_param_env);
        if (seg_err) {
                printf("%s: segfault occurred!", __func__);
                return 1;
        }

        struct fn_args {
                const struct gcm_key_data *exp_key;
                struct gcm_context_data *ctx;
                const uint8_t *src;
                const uint64_t len;
                const IMB_ERR exp_err;
        } fn_args[] = { { NULL, ctx, src, len, IMB_ERR_NULL_EXP_KEY },
                        { exp_key, NULL, src, len, IMB_ERR_NULL_CTX },
                        { exp_key, ctx, NULL, len, IMB_ERR_NULL_SRC } };

        /* Iterate over args */
        for (i = 0; i < DIM(fn_args); i++) {
                const struct fn_args *ap = &fn_args[i];

                IMB_AES192_GMAC_UPDATE(mgr, ap->exp_key, ap->ctx, ap->src, ap->len);
                if (unexpected_err(mgr, ap->exp_err, "IMB_AES192_GMAC_UPDATE"))
                        return 1;
        }
        return 0;
}

/*
 * @brief Performs direct API invalid param tests for IMB_AES256_GMAC_UPDATE */
static int
test_IMB_AES256_GMAC_UPDATE(struct IMB_MGR *mgr)
{
        unsigned i = 1;
        const struct gcm_key_data exp_key_s;
        const struct gcm_key_data *exp_key = &exp_key_s;
        struct gcm_context_data ctx_s;
        struct gcm_context_data *ctx = &ctx_s;
        const uint8_t src[BUFF_SIZE];
        const uint64_t len = 1;
        int seg_err; /* segfault flag */

        seg_err = setjmp(dir_api_param_env);
        if (seg_err) {
                printf("%s: segfault occurred!", __func__);
                return 1;
        }

        struct fn_args {
                const struct gcm_key_data *exp_key;
                struct gcm_context_data *ctx;
                const uint8_t *src;
                const uint64_t len;
                const IMB_ERR exp_err;
        } fn_args[] = { { NULL, ctx, src, len, IMB_ERR_NULL_EXP_KEY },
                        { exp_key, NULL, src, len, IMB_ERR_NULL_CTX },
                        { exp_key, ctx, NULL, len, IMB_ERR_NULL_SRC } };

        /* Iterate over args */
        for (i = 0; i < DIM(fn_args); i++) {
                const struct fn_args *ap = &fn_args[i];

                IMB_AES256_GMAC_UPDATE(mgr, ap->exp_key, ap->ctx, ap->src, ap->len);
                if (unexpected_err(mgr, ap->exp_err, "IMB_AES256_GMAC_UPDATE"))
                        return 1;
        }
        return 0;
}

/*
 * @brief Performs direct API invalid param tests for IMB_AES128_GMAC_FINALIZE
 */
static int
test_IMB_AES128_GMAC_FINALIZE(struct IMB_MGR *mgr)
{
        unsigned i = 1;
        const struct gcm_key_data exp_key_s;
        const struct gcm_key_data *exp_key = &exp_key_s;
        struct gcm_context_data ctx_s;
        struct gcm_context_data *ctx = &ctx_s;
        uint8_t tag[BUFF_SIZE];
        const uint64_t tagl = 1;
        int seg_err; /* segfault flag */

        seg_err = setjmp(dir_api_param_env);
        if (seg_err) {
                printf("%s: segfault occurred!", __func__);
                return 1;
        }

        struct fn_args {
                const struct gcm_key_data *exp_key;
                struct gcm_context_data *ctx;
                uint8_t *tag;
                const uint64_t tagl;
                const IMB_ERR exp_err;
        } fn_args[] = { { NULL, ctx, tag, tagl, IMB_ERR_NULL_EXP_KEY },
                        { exp_key, NULL, tag, tagl, IMB_ERR_NULL_CTX },
                        { exp_key, ctx, NULL, tagl, IMB_ERR_NULL_AUTH },
                        { exp_key, ctx, tag, 0, IMB_ERR_AUTH_TAG_LEN } };

        /* Iterate over args */
        for (i = 0; i < DIM(fn_args); i++) {
                const struct fn_args *ap = &fn_args[i];

                IMB_AES128_GMAC_FINALIZE(mgr, ap->exp_key, ap->ctx, ap->tag, ap->tagl);
                if (unexpected_err(mgr, ap->exp_err, "IMB_AES128_GMAC_FINALIZE"))
                        return 1;
        }
        return 0;
}

/*
 * @brief Performs direct API invalid param tests for IMB_AES192_GMAC_FINALIZE
 */
static int
test_IMB_AES192_GMAC_FINALIZE(struct IMB_MGR *mgr)
{
        unsigned i = 1;
        const struct gcm_key_data exp_key_s;
        const struct gcm_key_data *exp_key = &exp_key_s;
        struct gcm_context_data ctx_s;
        struct gcm_context_data *ctx = &ctx_s;
        uint8_t tag[BUFF_SIZE];
        const uint64_t tagl = 1;
        int seg_err; /* segfault flag */

        seg_err = setjmp(dir_api_param_env);
        if (seg_err) {
                printf("%s: segfault occurred!", __func__);
                return 1;
        }

        struct fn_args {
                const struct gcm_key_data *exp_key;
                struct gcm_context_data *ctx;
                uint8_t *tag;
                const uint64_t tagl;
                const IMB_ERR exp_err;
        } fn_args[] = { { NULL, ctx, tag, tagl, IMB_ERR_NULL_EXP_KEY },
                        { exp_key, NULL, tag, tagl, IMB_ERR_NULL_CTX },
                        { exp_key, ctx, NULL, tagl, IMB_ERR_NULL_AUTH },
                        { exp_key, ctx, tag, 0, IMB_ERR_AUTH_TAG_LEN } };

        /* Iterate over args */
        for (i = 0; i < DIM(fn_args); i++) {
                const struct fn_args *ap = &fn_args[i];

                IMB_AES192_GMAC_FINALIZE(mgr, ap->exp_key, ap->ctx, ap->tag, ap->tagl);
                if (unexpected_err(mgr, ap->exp_err, "IMB_AES192_GMAC_FINALIZE"))
                        return 1;
        }
        return 0;
}

/*
 * @brief Performs direct API invalid param tests for IMB_AES256_GMAC_FINALIZE
 */
static int
test_IMB_AES256_GMAC_FINALIZE(struct IMB_MGR *mgr)
{
        unsigned i = 1;
        const struct gcm_key_data exp_key_s;
        const struct gcm_key_data *exp_key = &exp_key_s;
        struct gcm_context_data ctx_s;
        struct gcm_context_data *ctx = &ctx_s;
        uint8_t tag[BUFF_SIZE];
        const uint64_t tagl = 1;
        int seg_err; /* segfault flag */

        seg_err = setjmp(dir_api_param_env);
        if (seg_err) {
                printf("%s: segfault occurred!", __func__);
                return 1;
        }

        struct fn_args {
                const struct gcm_key_data *exp_key;
                struct gcm_context_data *ctx;
                uint8_t *tag;
                const uint64_t tagl;
                const IMB_ERR exp_err;
        } fn_args[] = { { NULL, ctx, tag, tagl, IMB_ERR_NULL_EXP_KEY },
                        { exp_key, NULL, tag, tagl, IMB_ERR_NULL_CTX },
                        { exp_key, ctx, NULL, tagl, IMB_ERR_NULL_AUTH },
                        { exp_key, ctx, tag, 0, IMB_ERR_AUTH_TAG_LEN } };

        /* Iterate over args */
        for (i = 0; i < DIM(fn_args); i++) {
                const struct fn_args *ap = &fn_args[i];

                IMB_AES256_GMAC_FINALIZE(mgr, ap->exp_key, ap->ctx, ap->tag, ap->tagl);
                if (unexpected_err(mgr, ap->exp_err, "IMB_AES256_GMAC_FINALIZE"))
                        return 1;
        }
        return 0;
}

/*
 * @brief Performs direct API invalid param tests for
 * IMB_AES_CMAC_SUBKEY_GEN_256 */
static int
test_IMB_AES_CMAC_SUBKEY_GEN_256(struct IMB_MGR *mgr)
{
        unsigned i = 1;
        const uint8_t exp_key[BUFF_SIZE];
        uint8_t key1[BUFF_SIZE];
        uint8_t key2[BUFF_SIZE];
        int seg_err; /* segfault flag */

        seg_err = setjmp(dir_api_param_env);
        if (seg_err) {
                printf("%s: segfault occurred!", __func__);
                return 1;
        }

        struct fn_args {
                const void *exp_key;
                void *key1;
                void *key2;
                const IMB_ERR exp_err;
        } fn_args[] = { { NULL, key1, key2, IMB_ERR_NULL_EXP_KEY },
                        { exp_key, NULL, key2, IMB_ERR_NULL_KEY },
                        { exp_key, key1, NULL, IMB_ERR_NULL_KEY } };

        /* Iterate over args */
        for (i = 0; i < DIM(fn_args); i++) {
                const struct fn_args *ap = &fn_args[i];

                IMB_AES_CMAC_SUBKEY_GEN_256(mgr, ap->exp_key, ap->key1, ap->key2);
                if (unexpected_err(mgr, ap->exp_err, "IMB_AES_CMAC_SUBKEY_GEN_256"))
                        return 1;
        }
        return 0;
}

/*
 * @brief Performs direct API invalid param tests for IMB_GHASH_PRE */
static int
test_IMB_GHASH_PRE(struct IMB_MGR *mgr)
{
        unsigned i = 1;
        const uint8_t key[BUFF_SIZE];
        struct gcm_key_data exp_key_s;
        struct gcm_key_data *exp_key = &exp_key_s;
        int seg_err; /* segfault flag */

        seg_err = setjmp(dir_api_param_env);
        if (seg_err) {
                printf("%s: segfault occurred!", __func__);
                return 1;
        }

        struct fn_args {
                const void *key;
                struct gcm_key_data *exp_key;
                const IMB_ERR exp_err;
        } fn_args[] = { { NULL, exp_key, IMB_ERR_NULL_KEY }, { key, NULL, IMB_ERR_NULL_EXP_KEY } };

        /* Iterate over args */
        for (i = 0; i < DIM(fn_args); i++) {
                const struct fn_args *ap = &fn_args[i];

                IMB_GHASH_PRE(mgr, ap->key, ap->exp_key);
                if (unexpected_err(mgr, ap->exp_err, "IMB_GHASH_PRE"))
                        return 1;
        }
        return 0;
}

/*
 * @brief Performs direct API invalid param tests for IMB_CRC32_ETHERNET_FCS */
static int
test_IMB_CRC32_ETHERNET_FCS(struct IMB_MGR *mgr)
{
        unsigned i = 1;
        const uint64_t len = 1;
        int seg_err; /* segfault flag */

        seg_err = setjmp(dir_api_param_env);
        if (seg_err) {
                printf("%s: segfault occurred!", __func__);
                return 1;
        }

        struct fn_args {
                const void *src;
                const uint64_t len;
                const IMB_ERR exp_err;
        } fn_args[] = { { NULL, len, IMB_ERR_NULL_SRC } };

        /* Iterate over args */
        for (i = 0; i < DIM(fn_args); i++) {
                const struct fn_args *ap = &fn_args[i];

                IMB_CRC32_ETHERNET_FCS(mgr, ap->src, ap->len);
                if (unexpected_err(mgr, ap->exp_err, "IMB_CRC32_ETHERNET_FCS"))
                        return 1;
        }
        return 0;
}

/*
 * @brief Performs direct API invalid param tests for IMB_CRC16_X25 */
static int
test_IMB_CRC16_X25(struct IMB_MGR *mgr)
{
        unsigned i = 1;
        const uint64_t len = 1;
        int seg_err; /* segfault flag */

        seg_err = setjmp(dir_api_param_env);
        if (seg_err) {
                printf("%s: segfault occurred!", __func__);
                return 1;
        }

        struct fn_args {
                const void *src;
                const uint64_t len;
                const IMB_ERR exp_err;
        } fn_args[] = { { NULL, len, IMB_ERR_NULL_SRC } };

        /* Iterate over args */
        for (i = 0; i < DIM(fn_args); i++) {
                const struct fn_args *ap = &fn_args[i];

                IMB_CRC16_X25(mgr, ap->src, ap->len);
                if (unexpected_err(mgr, ap->exp_err, "IMB_CRC16_X25"))
                        return 1;
        }
        return 0;
}

/*
 * @brief Performs direct API invalid param tests for IMB_CRC32_SCTP */
static int
test_IMB_CRC32_SCTP(struct IMB_MGR *mgr)
{
        unsigned i = 1;
        const uint64_t len = 1;
        int seg_err; /* segfault flag */

        seg_err = setjmp(dir_api_param_env);
        if (seg_err) {
                printf("%s: segfault occurred!", __func__);
                return 1;
        }

        struct fn_args {
                const void *src;
                const uint64_t len;
                const IMB_ERR exp_err;
        } fn_args[] = { { NULL, len, IMB_ERR_NULL_SRC } };

        /* Iterate over args */
        for (i = 0; i < DIM(fn_args); i++) {
                const struct fn_args *ap = &fn_args[i];

                IMB_CRC32_SCTP(mgr, ap->src, ap->len);
                if (unexpected_err(mgr, ap->exp_err, "IMB_CRC32_SCTP"))
                        return 1;
        }
        return 0;
}

/*
 * @brief Performs direct API invalid param tests for IMB_CRC24_LTE_A */
static int
test_IMB_CRC24_LTE_A(struct IMB_MGR *mgr)
{
        unsigned i = 1;
        const uint64_t len = 1;
        int seg_err; /* segfault flag */

        seg_err = setjmp(dir_api_param_env);
        if (seg_err) {
                printf("%s: segfault occurred!", __func__);
                return 1;
        }

        struct fn_args {
                const void *src;
                const uint64_t len;
                const IMB_ERR exp_err;
        } fn_args[] = { { NULL, len, IMB_ERR_NULL_SRC } };

        /* Iterate over args */
        for (i = 0; i < DIM(fn_args); i++) {
                const struct fn_args *ap = &fn_args[i];

                IMB_CRC24_LTE_A(mgr, ap->src, ap->len);
                if (unexpected_err(mgr, ap->exp_err, "IMB_CRC24_LTE_A"))
                        return 1;
        }
        return 0;
}

/*
 * @brief Performs direct API invalid param tests for IMB_CRC24_LTE_B */
static int
test_IMB_CRC24_LTE_B(struct IMB_MGR *mgr)
{
        unsigned i = 1;
        const uint64_t len = 1;
        int seg_err; /* segfault flag */

        seg_err = setjmp(dir_api_param_env);
        if (seg_err) {
                printf("%s: segfault occurred!", __func__);
                return 1;
        }

        struct fn_args {
                const void *src;
                const uint64_t len;
                const IMB_ERR exp_err;
        } fn_args[] = { { NULL, len, IMB_ERR_NULL_SRC } };

        /* Iterate over args */
        for (i = 0; i < DIM(fn_args); i++) {
                const struct fn_args *ap = &fn_args[i];

                IMB_CRC24_LTE_B(mgr, ap->src, ap->len);
                if (unexpected_err(mgr, ap->exp_err, "IMB_CRC24_LTE_B"))
                        return 1;
        }
        return 0;
}

/*
 * @brief Performs direct API invalid param tests for IMB_CRC16_FP_DATA */
static int
test_IMB_CRC16_FP_DATA(struct IMB_MGR *mgr)
{
        unsigned i = 1;
        const uint64_t len = 1;
        int seg_err; /* segfault flag */

        seg_err = setjmp(dir_api_param_env);
        if (seg_err) {
                printf("%s: segfault occurred!", __func__);
                return 1;
        }

        struct fn_args {
                const void *src;
                const uint64_t len;
                const IMB_ERR exp_err;
        } fn_args[] = { { NULL, len, IMB_ERR_NULL_SRC } };

        /* Iterate over args */
        for (i = 0; i < DIM(fn_args); i++) {
                const struct fn_args *ap = &fn_args[i];

                IMB_CRC16_FP_DATA(mgr, ap->src, ap->len);
                if (unexpected_err(mgr, ap->exp_err, "IMB_CRC16_FP_DATA"))
                        return 1;
        }
        return 0;
}

/*
 * @brief Performs direct API invalid param tests for IMB_CRC11_FP_HEADER */
static int
test_IMB_CRC11_FP_HEADER(struct IMB_MGR *mgr)
{
        unsigned i = 1;
        const uint64_t len = 1;
        int seg_err; /* segfault flag */

        seg_err = setjmp(dir_api_param_env);
        if (seg_err) {
                printf("%s: segfault occurred!", __func__);
                return 1;
        }

        struct fn_args {
                const void *src;
                const uint64_t len;
                const IMB_ERR exp_err;
        } fn_args[] = { { NULL, len, IMB_ERR_NULL_SRC } };

        /* Iterate over args */
        for (i = 0; i < DIM(fn_args); i++) {
                const struct fn_args *ap = &fn_args[i];

                IMB_CRC11_FP_HEADER(mgr, ap->src, ap->len);
                if (unexpected_err(mgr, ap->exp_err, "IMB_CRC11_FP_HEADER"))
                        return 1;
        }
        return 0;
}

/*
 * @brief Performs direct API invalid param tests for IMB_CRC7_FP_HEADER */
static int
test_IMB_CRC7_FP_HEADER(struct IMB_MGR *mgr)
{
        unsigned i = 1;
        const uint64_t len = 1;
        int seg_err; /* segfault flag */

        seg_err = setjmp(dir_api_param_env);
        if (seg_err) {
                printf("%s: segfault occurred!", __func__);
                return 1;
        }

        struct fn_args {
                const void *src;
                const uint64_t len;
                const IMB_ERR exp_err;
        } fn_args[] = { { NULL, len, IMB_ERR_NULL_SRC } };

        /* Iterate over args */
        for (i = 0; i < DIM(fn_args); i++) {
                const struct fn_args *ap = &fn_args[i];

                IMB_CRC7_FP_HEADER(mgr, ap->src, ap->len);
                if (unexpected_err(mgr, ap->exp_err, "IMB_CRC7_FP_HEADER"))
                        return 1;
        }
        return 0;
}

/*
 * @brief Performs direct API invalid param tests for IMB_CRC10_IUUP_DATA */
static int
test_IMB_CRC10_IUUP_DATA(struct IMB_MGR *mgr)
{
        unsigned i = 1;
        const uint64_t len = 1;
        int seg_err; /* segfault flag */

        seg_err = setjmp(dir_api_param_env);
        if (seg_err) {
                printf("%s: segfault occurred!", __func__);
                return 1;
        }

        struct fn_args {
                const void *src;
                const uint64_t len;
                const IMB_ERR exp_err;
        } fn_args[] = { { NULL, len, IMB_ERR_NULL_SRC } };

        /* Iterate over args */
        for (i = 0; i < DIM(fn_args); i++) {
                const struct fn_args *ap = &fn_args[i];

                IMB_CRC10_IUUP_DATA(mgr, ap->src, ap->len);
                if (unexpected_err(mgr, ap->exp_err, "IMB_CRC10_IUUP_DATA"))
                        return 1;
        }
        return 0;
}

/*
 * @brief Performs direct API invalid param tests for IMB_CRC6_IUUP_HEADER */
static int
test_IMB_CRC6_IUUP_HEADER(struct IMB_MGR *mgr)
{
        unsigned i = 1;
        const uint64_t len = 1;
        int seg_err; /* segfault flag */

        seg_err = setjmp(dir_api_param_env);
        if (seg_err) {
                printf("%s: segfault occurred!", __func__);
                return 1;
        }

        struct fn_args {
                const void *src;
                const uint64_t len;
                const IMB_ERR exp_err;
        } fn_args[] = { { NULL, len, IMB_ERR_NULL_SRC } };

        /* Iterate over args */
        for (i = 0; i < DIM(fn_args); i++) {
                const struct fn_args *ap = &fn_args[i];

                IMB_CRC6_IUUP_HEADER(mgr, ap->src, ap->len);
                if (unexpected_err(mgr, ap->exp_err, "IMB_CRC6_IUUP_HEADER"))
                        return 1;
        }
        return 0;
}

/*
 * @brief Performs direct API invalid param tests for IMB_CRC32_WIMAX_OFDMA_DATA
 */
static int
test_IMB_CRC32_WIMAX_OFDMA_DATA(struct IMB_MGR *mgr)
{
        unsigned i = 1;
        const uint64_t len = 1;
        int seg_err; /* segfault flag */

        seg_err = setjmp(dir_api_param_env);
        if (seg_err) {
                printf("%s: segfault occurred!", __func__);
                return 1;
        }

        struct fn_args {
                const void *src;
                const uint64_t len;
                const IMB_ERR exp_err;
        } fn_args[] = { { NULL, len, IMB_ERR_NULL_SRC } };

        /* Iterate over args */
        for (i = 0; i < DIM(fn_args); i++) {
                const struct fn_args *ap = &fn_args[i];

                IMB_CRC32_WIMAX_OFDMA_DATA(mgr, ap->src, ap->len);
                if (unexpected_err(mgr, ap->exp_err, "IMB_CRC32_WIMAX_OFDMA_DATA"))
                        return 1;
        }
        return 0;
}

/*
 * @brief Performs direct API invalid param tests for IMB_CRC8_WIMAX_OFDMA_HCS
 */
static int
test_IMB_CRC8_WIMAX_OFDMA_HCS(struct IMB_MGR *mgr)
{
        unsigned i = 1;
        const uint64_t len = 1;
        int seg_err; /* segfault flag */

        seg_err = setjmp(dir_api_param_env);
        if (seg_err) {
                printf("%s: segfault occurred!", __func__);
                return 1;
        }

        struct fn_args {
                const void *src;
                const uint64_t len;
                const IMB_ERR exp_err;
        } fn_args[] = { { NULL, len, IMB_ERR_NULL_SRC } };

        /* Iterate over args */
        for (i = 0; i < DIM(fn_args); i++) {
                const struct fn_args *ap = &fn_args[i];

                IMB_CRC8_WIMAX_OFDMA_HCS(mgr, ap->src, ap->len);
                if (unexpected_err(mgr, ap->exp_err, "IMB_CRC8_WIMAX_OFDMA_HCS"))
                        return 1;
        }
        return 0;
}

/*
 * @brief Performs direct API invalid param tests for IMB_CHACHA20_POLY1305_INIT
 */
static int
test_IMB_CHACHA20_POLY1305_INIT(struct IMB_MGR *mgr)
{
        unsigned i = 1;
        const uint8_t key[BUFF_SIZE];
        struct chacha20_poly1305_context_data ctx_s;
        struct chacha20_poly1305_context_data *ctx = &ctx_s;
        const uint8_t iv[BUFF_SIZE];
        const uint8_t aad[BUFF_SIZE];
        const uint64_t aadl = 1;
        int seg_err; /* segfault flag */

        seg_err = setjmp(dir_api_param_env);
        if (seg_err) {
                printf("%s: segfault occurred!", __func__);
                return 1;
        }

        struct fn_args {
                const void *key;
                struct chacha20_poly1305_context_data *ctx;
                const void *iv;
                const void *aad;
                const uint64_t aadl;
                const IMB_ERR exp_err;
        } fn_args[] = { { NULL, ctx, iv, aad, aadl, IMB_ERR_NULL_KEY },
                        { key, NULL, iv, aad, aadl, IMB_ERR_NULL_CTX },
                        { key, ctx, NULL, aad, aadl, IMB_ERR_NULL_IV },
                        { key, ctx, iv, NULL, aadl, IMB_ERR_NULL_AAD } };

        /* Iterate over args */
        for (i = 0; i < DIM(fn_args); i++) {
                const struct fn_args *ap = &fn_args[i];

                IMB_CHACHA20_POLY1305_INIT(mgr, ap->key, ap->ctx, ap->iv, ap->aad, ap->aadl);
                if (unexpected_err(mgr, ap->exp_err, "IMB_CHACHA20_POLY1305_INIT"))
                        return 1;
        }
        return 0;
}

/*
 * @brief Performs direct API invalid param tests for
 * IMB_CHACHA20_POLY1305_ENC_UPDATE */
static int
test_IMB_CHACHA20_POLY1305_ENC_UPDATE(struct IMB_MGR *mgr)
{
        unsigned i = 1;
        const uint8_t key[BUFF_SIZE];
        struct chacha20_poly1305_context_data ctx_s;
        struct chacha20_poly1305_context_data *ctx = &ctx_s;
        uint8_t dst[BUFF_SIZE];
        const uint8_t src[BUFF_SIZE];
        const uint64_t len = 1;
        int seg_err; /* segfault flag */

        seg_err = setjmp(dir_api_param_env);
        if (seg_err) {
                printf("%s: segfault occurred!", __func__);
                return 1;
        }

        struct fn_args {
                const void *key;
                struct chacha20_poly1305_context_data *ctx;
                void *dst;
                const void *src;
                const uint64_t len;
                const IMB_ERR exp_err;
        } fn_args[] = { { NULL, ctx, dst, src, len, IMB_ERR_NULL_KEY },
                        { key, NULL, dst, src, len, IMB_ERR_NULL_CTX },
                        { key, ctx, NULL, src, len, IMB_ERR_NULL_DST },
                        { key, ctx, dst, NULL, len, IMB_ERR_NULL_SRC } };

        /* Iterate over args */
        for (i = 0; i < DIM(fn_args); i++) {
                const struct fn_args *ap = &fn_args[i];

                IMB_CHACHA20_POLY1305_ENC_UPDATE(mgr, ap->key, ap->ctx, ap->dst, ap->src, ap->len);
                if (unexpected_err(mgr, ap->exp_err, "IMB_CHACHA20_POLY1305_ENC_UPDATE"))
                        return 1;
        }
        return 0;
}

/*
 * @brief Performs direct API invalid param tests for
 * IMB_CHACHA20_POLY1305_DEC_UPDATE */
static int
test_IMB_CHACHA20_POLY1305_DEC_UPDATE(struct IMB_MGR *mgr)
{
        unsigned i = 1;
        const uint8_t key[BUFF_SIZE];
        struct chacha20_poly1305_context_data ctx_s;
        struct chacha20_poly1305_context_data *ctx = &ctx_s;
        uint8_t dst[BUFF_SIZE];
        const uint8_t src[BUFF_SIZE];
        const uint64_t len = 1;
        int seg_err; /* segfault flag */

        seg_err = setjmp(dir_api_param_env);
        if (seg_err) {
                printf("%s: segfault occurred!", __func__);
                return 1;
        }

        struct fn_args {
                const void *key;
                struct chacha20_poly1305_context_data *ctx;
                void *dst;
                const void *src;
                const uint64_t len;
                const IMB_ERR exp_err;
        } fn_args[] = { { NULL, ctx, dst, src, len, IMB_ERR_NULL_KEY },
                        { key, NULL, dst, src, len, IMB_ERR_NULL_CTX },
                        { key, ctx, NULL, src, len, IMB_ERR_NULL_DST },
                        { key, ctx, dst, NULL, len, IMB_ERR_NULL_SRC } };

        /* Iterate over args */
        for (i = 0; i < DIM(fn_args); i++) {
                const struct fn_args *ap = &fn_args[i];

                IMB_CHACHA20_POLY1305_DEC_UPDATE(mgr, ap->key, ap->ctx, ap->dst, ap->src, ap->len);
                if (unexpected_err(mgr, ap->exp_err, "IMB_CHACHA20_POLY1305_DEC_UPDATE"))
                        return 1;
        }
        return 0;
}

/*
 * @brief Performs direct API invalid param tests for
 * IMB_CHACHA20_POLY1305_DEC_FINALIZE */
static int
test_IMB_CHACHA20_POLY1305_DEC_FINALIZE(struct IMB_MGR *mgr)
{
        unsigned i = 1;
        struct chacha20_poly1305_context_data ctx_s;
        struct chacha20_poly1305_context_data *ctx = &ctx_s;
        uint8_t tag[BUFF_SIZE];
        const uint64_t tagl = 1;
        int seg_err; /* segfault flag */

        seg_err = setjmp(dir_api_param_env);
        if (seg_err) {
                printf("%s: segfault occurred!", __func__);
                return 1;
        }

        struct fn_args {
                struct chacha20_poly1305_context_data *ctx;
                void *tag;
                const uint64_t tagl;
                const IMB_ERR exp_err;
        } fn_args[] = { { NULL, tag, tagl, IMB_ERR_NULL_CTX },
                        { ctx, NULL, tagl, IMB_ERR_NULL_AUTH },
                        { ctx, tag, 0, IMB_ERR_AUTH_TAG_LEN } };

        /* Iterate over args */
        for (i = 0; i < DIM(fn_args); i++) {
                const struct fn_args *ap = &fn_args[i];

                IMB_CHACHA20_POLY1305_DEC_FINALIZE(mgr, ap->ctx, ap->tag, ap->tagl);
                if (unexpected_err(mgr, ap->exp_err, "IMB_CHACHA20_POLY1305_DEC_FINALIZE"))
                        return 1;
        }
        return 0;
}

int
direct_api_param_test(struct IMB_MGR *mb_mgr)
{
        struct test_suite_context ts;
        int errors = 0, run = 0;

#ifndef DEBUG
#if defined(__linux__)
        sighandler_t handler;
#else
        void *handler;
#endif
#endif
        printf("Extended Invalid Direct API arguments test:\n");
        test_suite_start(&ts, "INVALID-ARGS");
#ifndef DEBUG
        handler = signal(SIGSEGV, seg_handler);

#endif
        if ((mb_mgr->features & IMB_FEATURE_SAFE_PARAM) == 0) {
                printf("SAFE_PARAM feature disabled, "
                       "skipping remaining tests\n");
                goto dir_api_exit;
        }
        errors += test_IMB_AES_KEYEXP_128(mb_mgr);
        run++;

        errors += test_IMB_AES_KEYEXP_192(mb_mgr);
        run++;

        errors += test_IMB_AES_KEYEXP_256(mb_mgr);
        run++;

        errors += test_IMB_AES_CMAC_SUBKEY_GEN_128(mb_mgr);
        run++;

        errors += test_IMB_AES_XCBC_KEYEXP(mb_mgr);
        run++;

        errors += test_IMB_DES_KEYSCHED(mb_mgr);
        run++;

        errors += test_IMB_SHA1_ONE_BLOCK(mb_mgr);
        run++;

        errors += test_IMB_SHA224_ONE_BLOCK(mb_mgr);
        run++;

        errors += test_IMB_SHA256_ONE_BLOCK(mb_mgr);
        run++;

        errors += test_IMB_SHA384_ONE_BLOCK(mb_mgr);
        run++;

        errors += test_IMB_SHA512_ONE_BLOCK(mb_mgr);
        run++;

        errors += test_IMB_MD5_ONE_BLOCK(mb_mgr);
        run++;

        errors += test_IMB_SHA1(mb_mgr);
        run++;

        errors += test_IMB_SHA224(mb_mgr);
        run++;

        errors += test_IMB_SHA256(mb_mgr);
        run++;

        errors += test_IMB_SHA384(mb_mgr);
        run++;

        errors += test_IMB_SHA512(mb_mgr);
        run++;

        errors += test_IMB_AES128_CFB_ONE(mb_mgr);
        run++;

        errors += test_IMB_AES128_GCM_ENC(mb_mgr);
        run++;

        errors += test_IMB_AES192_GCM_ENC(mb_mgr);
        run++;

        errors += test_IMB_AES256_GCM_ENC(mb_mgr);
        run++;

        errors += test_IMB_AES128_GCM_DEC(mb_mgr);
        run++;

        errors += test_IMB_AES192_GCM_DEC(mb_mgr);
        run++;

        errors += test_IMB_AES256_GCM_DEC(mb_mgr);
        run++;

        errors += test_IMB_AES128_GCM_INIT(mb_mgr);
        run++;

        errors += test_IMB_AES192_GCM_INIT(mb_mgr);
        run++;

        errors += test_IMB_AES256_GCM_INIT(mb_mgr);
        run++;

        errors += test_IMB_AES128_GCM_ENC_UPDATE(mb_mgr);
        run++;

        errors += test_IMB_AES192_GCM_ENC_UPDATE(mb_mgr);
        run++;

        errors += test_IMB_AES256_GCM_ENC_UPDATE(mb_mgr);
        run++;

        errors += test_IMB_AES128_GCM_DEC_UPDATE(mb_mgr);
        run++;

        errors += test_IMB_AES192_GCM_DEC_UPDATE(mb_mgr);
        run++;

        errors += test_IMB_AES256_GCM_DEC_UPDATE(mb_mgr);
        run++;

        errors += test_IMB_AES128_GCM_ENC_FINALIZE(mb_mgr);
        run++;

        errors += test_IMB_AES192_GCM_ENC_FINALIZE(mb_mgr);
        run++;

        errors += test_IMB_AES256_GCM_ENC_FINALIZE(mb_mgr);
        run++;

        errors += test_IMB_AES128_GCM_DEC_FINALIZE(mb_mgr);
        run++;

        errors += test_IMB_AES192_GCM_DEC_FINALIZE(mb_mgr);
        run++;

        errors += test_IMB_AES256_GCM_DEC_FINALIZE(mb_mgr);
        run++;

        errors += test_IMB_AES128_GCM_PRE(mb_mgr);
        run++;

        errors += test_IMB_AES192_GCM_PRE(mb_mgr);
        run++;

        errors += test_IMB_AES256_GCM_PRE(mb_mgr);
        run++;

        errors += test_IMB_ZUC_EEA3_1_BUFFER(mb_mgr);
        run++;

        errors += test_IMB_ZUC_EEA3_4_BUFFER(mb_mgr);
        run++;

        errors += test_IMB_ZUC_EEA3_N_BUFFER(mb_mgr);
        run++;

        errors += test_IMB_ZUC_EIA3_1_BUFFER(mb_mgr);
        run++;

        errors += test_IMB_KASUMI_F8_1_BUFFER(mb_mgr);
        run++;

        errors += test_IMB_KASUMI_F8_1_BUFFER_BIT(mb_mgr);
        run++;

        errors += test_IMB_KASUMI_F8_2_BUFFER(mb_mgr);
        run++;

        errors += test_IMB_KASUMI_F8_3_BUFFER(mb_mgr);
        run++;

        errors += test_IMB_KASUMI_F8_4_BUFFER(mb_mgr);
        run++;

        errors += test_IMB_KASUMI_F8_N_BUFFER(mb_mgr);
        run++;

        errors += test_IMB_KASUMI_F9_1_BUFFER(mb_mgr);
        run++;

        errors += test_IMB_KASUMI_F9_1_BUFFER_USER(mb_mgr);
        run++;

        errors += test_IMB_KASUMI_INIT_F8_KEY_SCHED(mb_mgr);
        run++;

        errors += test_IMB_KASUMI_INIT_F9_KEY_SCHED(mb_mgr);
        run++;

        errors += test_IMB_SNOW3G_F8_1_BUFFER_BIT(mb_mgr);
        run++;

        errors += test_IMB_SNOW3G_F8_1_BUFFER(mb_mgr);
        run++;

        errors += test_IMB_SNOW3G_F8_2_BUFFER(mb_mgr);
        run++;

        errors += test_IMB_SNOW3G_F8_4_BUFFER(mb_mgr);
        run++;

        errors += test_IMB_SNOW3G_F8_8_BUFFER(mb_mgr);
        run++;

        errors += test_IMB_SNOW3G_F8_N_BUFFER(mb_mgr);
        run++;

        errors += test_IMB_SNOW3G_F8_8_BUFFER_MULTIKEY(mb_mgr);
        run++;

        errors += test_IMB_SNOW3G_F8_N_BUFFER_MULTIKEY(mb_mgr);
        run++;

        errors += test_IMB_SNOW3G_F9_1_BUFFER(mb_mgr);
        run++;

        errors += test_IMB_SNOW3G_INIT_KEY_SCHED(mb_mgr);
        run++;

        errors += test_IMB_GHASH(mb_mgr);
        run++;

        errors += test_IMB_ZUC_EIA3_N_BUFFER(mb_mgr);
        run++;

        errors += test_IMB_AES128_GCM_INIT_VAR_IV(mb_mgr);
        run++;

        errors += test_IMB_AES192_GCM_INIT_VAR_IV(mb_mgr);
        run++;

        errors += test_IMB_AES256_GCM_INIT_VAR_IV(mb_mgr);
        run++;

        errors += test_IMB_AES128_GMAC_INIT(mb_mgr);
        run++;

        errors += test_IMB_AES192_GMAC_INIT(mb_mgr);
        run++;

        errors += test_IMB_AES256_GMAC_INIT(mb_mgr);
        run++;

        errors += test_IMB_AES128_GMAC_UPDATE(mb_mgr);
        run++;

        errors += test_IMB_AES192_GMAC_UPDATE(mb_mgr);
        run++;

        errors += test_IMB_AES256_GMAC_UPDATE(mb_mgr);
        run++;

        errors += test_IMB_AES128_GMAC_FINALIZE(mb_mgr);
        run++;

        errors += test_IMB_AES192_GMAC_FINALIZE(mb_mgr);
        run++;

        errors += test_IMB_AES256_GMAC_FINALIZE(mb_mgr);
        run++;

        errors += test_IMB_AES_CMAC_SUBKEY_GEN_256(mb_mgr);
        run++;

        errors += test_IMB_GHASH_PRE(mb_mgr);
        run++;

        errors += test_IMB_CRC32_ETHERNET_FCS(mb_mgr);
        run++;

        errors += test_IMB_CRC16_X25(mb_mgr);
        run++;

        errors += test_IMB_CRC32_SCTP(mb_mgr);
        run++;

        errors += test_IMB_CRC24_LTE_A(mb_mgr);
        run++;

        errors += test_IMB_CRC24_LTE_B(mb_mgr);
        run++;

        errors += test_IMB_CRC16_FP_DATA(mb_mgr);
        run++;

        errors += test_IMB_CRC11_FP_HEADER(mb_mgr);
        run++;

        errors += test_IMB_CRC7_FP_HEADER(mb_mgr);
        run++;

        errors += test_IMB_CRC10_IUUP_DATA(mb_mgr);
        run++;

        errors += test_IMB_CRC6_IUUP_HEADER(mb_mgr);
        run++;

        errors += test_IMB_CRC32_WIMAX_OFDMA_DATA(mb_mgr);
        run++;

        errors += test_IMB_CRC8_WIMAX_OFDMA_HCS(mb_mgr);
        run++;

        errors += test_IMB_CHACHA20_POLY1305_INIT(mb_mgr);
        run++;

        errors += test_IMB_CHACHA20_POLY1305_ENC_UPDATE(mb_mgr);
        run++;

        errors += test_IMB_CHACHA20_POLY1305_DEC_UPDATE(mb_mgr);
        run++;

        errors += test_IMB_CHACHA20_POLY1305_DEC_FINALIZE(mb_mgr);
        run++;

        test_suite_update(&ts, run - errors, errors);
dir_api_exit:
        errors = test_suite_end(&ts);
#ifndef DEBUG
        signal(SIGSEGV, handler);
#endif
        return errors;
}
