/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright (c) 2016-2017 Oracle and/or its affiliates. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License.  You can
 * obtain a copy of the License at
 * https://oss.oracle.com/licenses/CDDL+GPL-1.1
 * or LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 *
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at LICENSE.txt.
 *
 * GPL Classpath Exception:
 * Oracle designates this particular file as subject to the "Classpath"
 * exception as provided by Oracle in the GPL Version 2 section of the License
 * file that accompanied this code.
 *
 * Modifications:
 * If applicable, add the following below the License Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyright [year] [name of copyright owner]"
 *
 * Contributor(s):
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */

package com.sun.codemodel;

import org.junit.Test;
import static com.sun.codemodel.JModuleTest.EOL;
import static com.sun.codemodel.JModuleTest.MODULE_NAME;
import static com.sun.codemodel.JModuleTest.normalizeWhiteSpaces;
import static org.junit.Assert.*;

/**
 * Test Java module {@code requires} directive for module dependency.
 * @author Tomas Kraus
 */
public class JRequiresTest extends JTestModuleDirective {

    /**
     * Test of generateModifiers method with all combinations of {@code local) and {@code public) modifiers.
     */
    @Test
    public void testGenerateModifiers() {
        // All possible combinations of 2 boolean arguments has to be tested. They are masked
        // using 2 the least significant bits of byte value so we have to verify masks from 0x00 to 0x03.
        //  * 0x01 masks local
        //  * 0x02 masks public
        for (byte i = 0x00; i < 0x04; i++) {
            // Clean up output for next iteration.
            if (i > 0) {
                reopenOutput();
            }
            final boolean isPublic = (i & 0x01) > 0;
            final boolean isStatic = (i & 0x02) > 0;
            final JRequiresDirective instance = new JRequiresDirective(MODULE_NAME, isPublic, isStatic);
            instance.generateModifiers(jf);
            verifyModifiers(normalizeWhiteSpaces(out.toString()), isPublic, isStatic);
        }
    }

    /**
     * Test of generate method.
     */
    @Test
    public void testGenerate() {
        final JRequiresDirective instance = new JRequiresDirective(MODULE_NAME, false, false);
        instance.generate(jf);
        final String output = normalizeWhiteSpaces(out.toString());
        final StringBuilder sb = new StringBuilder(24);
        sb.append("requires ");
        sb.append(instance.name);
        sb.append(";").append(EOL);
        //System.out.println("LEN: " + sb.length());
        final String check = normalizeWhiteSpaces(sb.toString());
        //System.out.println("OUT: \""+output+"\" -- CHK: \""+check+"\"");
        assertEquals(check, output);
    }

    /**
     * Verify generated modifiers.
     */
    private static void verifyModifiers(final String output, final boolean isPublic, final boolean isStatic) {
        final int len = isPublic ? (isStatic ? 13 : 6) : (isStatic ? 6 : 0);
        final StringBuilder sb = new StringBuilder(len);
        if (isPublic) {
            sb.append("public");
        }
        if (isStatic) {
            if (isPublic) {
                sb.append(' ');
            }
            sb.append("static");
        }
        //System.out.println("verifyModifiers LEN: " + sb.length() + " - " + len);
        final String check = normalizeWhiteSpaces(sb.toString());
        //System.out.println("OUT: \""+output+"\" -- CHK: \""+check+"\"");
        assertEquals(check, output);
    }

}
