/*
 * Copyright (C) 2021 Linux Studio Plugins Project <https://lsp-plug.in/>
 *           (C) 2021 Vladimir Sadovnikov <sadko4u@gmail.com>
 *
 * This file is part of lsp-plugins-shared
 * Created on: 12 мая 2021 г.
 *
 * lsp-plugins-shared is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version.
 *
 * lsp-plugins-shared is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with lsp-plugins-shared. If not, see <https://www.gnu.org/licenses/>.
 */

#ifndef LSP_PLUG_IN_SHARED_ID_COLORS_H_
#define LSP_PLUG_IN_SHARED_ID_COLORS_H_

#define CV_BACKGROUND           0x000000
#define CV_DISABLED             0x444444
#define CV_YELLOW               0xffff00
#define CV_WHITE                0xffffff
#define CV_MAGENTA              0xff00ff
#define CV_SILVER               0xcccccc
#define CV_GRAY                 0x888888
#define CV_MEDIUM_GREEN         0x008800
#define CV_GREEN                0x00ff00
#define CV_RED                  0xff0000
#define CV_MESH                 0x00c0ff
#define CV_LEFT_CHANNEL         0xff0000
#define CV_RIGHT_CHANNEL        0x00ffff
#define CV_MIDDLE_CHANNEL       0x00c0ff
#define CV_SIDE_CHANNEL         0x00cc00
#define CV_LEFT_CHANNEL_IN      0xaa0000
#define CV_RIGHT_CHANNEL_IN     0x00aaaa
#define CV_MIDDLE_CHANNEL_IN    0x0080aa
#define CV_SIDE_CHANNEL_IN      0x008000
#define CV_BRIGHT_GREEN         0x80ff80
#define CV_BRIGHT_MAGENTA       0xff80ff
#define CV_BRIGHT_BLUE          0x8080ff

#endif /* LSP_PLUG_IN_SHARED_ID_COLORS_H_ */
