/*
 * Decompiled with CFR 0.152.
 */
package alt.jiapi.reflect;

import alt.jiapi.file.ConstantPool;
import alt.jiapi.reflect.Instruction;
import alt.jiapi.reflect.InstructionFactory;
import alt.jiapi.reflect.JiapiMethod;
import alt.jiapi.reflect.JiapiRuntimeException;
import alt.jiapi.reflect.TargetInstruction;
import alt.jiapi.reflect.instruction.CPInstruction;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class InstructionList {
    private JiapiMethod declaringMethod;
    ConstantPool constantPool;
    List instructions;
    private boolean modified = false;

    public InstructionList() {
        this.constantPool = new ConstantPool();
        this.instructions = new LinkedList();
    }

    InstructionList(byte[] byteCode, ConstantPool cp) {
        this.constantPool = cp;
        InstructionFactory factory = new InstructionFactory(cp);
        this.instructions = factory.createInstructionList(byteCode);
    }

    private InstructionList(ConstantPool cp, List instructions) {
        this.constantPool = cp;
        this.instructions = instructions;
    }

    InstructionList(ConstantPool cp) {
        this.constantPool = cp;
        this.instructions = new LinkedList();
    }

    public InstructionList createEmptyList() {
        return new InstructionList(this.constantPool);
    }

    public byte[] getBytes() {
        Iterator i = this.instructions.iterator();
        int bSize = 0;
        while (i.hasNext()) {
            bSize += ((Instruction)i.next()).length();
        }
        byte[] bytes = new byte[bSize];
        int bIdx = 0;
        for (Instruction ins : this.instructions) {
            byte[] iBytes = ins.getBytes();
            for (int j = 0; j < iBytes.length; ++j) {
                bytes[bIdx] = iBytes[j];
                ++bIdx;
            }
        }
        this.modified = false;
        return bytes;
    }

    public void add(Instruction i) {
        CPInstruction cpIns;
        ConstantPool cp;
        this.modified = true;
        i.setAttribute("synthetic");
        if (i instanceof CPInstruction && !this.constantPool.equals(cp = (cpIns = (CPInstruction)i).getConstantPool())) {
            cpIns.replaceConstantPool(this.constantPool);
        }
        this.instructions.add(i);
    }

    public void add(InstructionList il) {
        this.modified = true;
        if (il.size() == 0) {
            return;
        }
        for (int i = 0; i < il.size(); ++i) {
            this.add(il.get(i));
        }
    }

    public boolean insert(int idx, Instruction i) {
        CPInstruction cpIns;
        ConstantPool cp;
        this.modified = true;
        i.setAttribute("synthetic");
        if (i instanceof CPInstruction && !this.constantPool.equals(cp = (cpIns = (CPInstruction)i).getConstantPool())) {
            cpIns.replaceConstantPool(this.constantPool);
        }
        return this.instructions.subList(0, idx).add(i);
    }

    public boolean insert(int idx, InstructionList il) {
        this.modified = true;
        if (il.size() == 0) {
            return true;
        }
        for (int i = 0; i < il.size(); ++i) {
            this.insert(idx + i, il.get(i));
        }
        return true;
    }

    public Instruction get(int i) {
        Instruction ins = (Instruction)this.instructions.get(i);
        if (ins instanceof TargetInstruction) {
            return ((TargetInstruction)ins).getTarget();
        }
        return ins;
    }

    public void replace(int idx, Instruction i) {
        if (i == null) {
            throw new NullPointerException("Instruction may not be null");
        }
        this.instructions.set(idx, i);
    }

    public void replace(InstructionList il) {
        this.replace(0, this.size(), il);
    }

    public void replace(int start, int end, InstructionList il) {
        int su2;
        InstructionList __il = this.createView(start, end);
        int su1 = __il.stackUsage();
        if (su1 != (su2 = il.stackUsage())) {
            System.out.println("Replacing ");
            this.print(__il);
            System.out.println("with");
            this.print(il);
            throw new IllegalArgumentException("Cannot replace instruction list; stack usages differ: " + su1 + "(this list), " + su2 + " (other list)");
        }
        Instruction first = (Instruction)__il.instructions.get(0);
        if (first instanceof TargetInstruction) {
            TargetInstruction tIns = (TargetInstruction)first;
            tIns.setTarget(il.get(0));
            il.instructions.set(0, tIns);
        }
        for (int i = 1; i < __il.size(); ++i) {
            if (!(__il.instructions.get(i) instanceof TargetInstruction)) continue;
            throw new IllegalArgumentException("Cannot replace instructions since there are at least one 'target' instruction in it");
        }
        __il.clear();
        __il.add(il);
    }

    public int stackUsage() {
        int su = 0;
        for (int i = 0; i < this.size(); ++i) {
            su += this.get(i).stackUsage();
        }
        return su;
    }

    public int size() {
        return this.instructions.size();
    }

    public int indexOf(Instruction ins) {
        return this.instructions.indexOf(ins);
    }

    public int indexOf(byte opcode) {
        return this.indexOf(new byte[]{opcode}, 0);
    }

    public int indexOf(byte opcode, int fromIndex) {
        return this.indexOf(new byte[]{opcode}, fromIndex);
    }

    public int indexOf(byte[] opcodes, int fromIndex) {
        for (int i = fromIndex; i < this.instructions.size(); ++i) {
            Instruction ins = (Instruction)this.instructions.get(i);
            short opCode = ins.getOpcode();
            for (int j = 0; j < opcodes.length; ++j) {
                if (opcodes[j] != opCode) continue;
                return i;
            }
        }
        return -1;
    }

    int offset(Instruction i) {
        return this.offset(0, i);
    }

    int offset(int start, Instruction ins) {
        int offset = 0;
        for (int i = start; i < this.instructions.size(); ++i) {
            if (this.instructions.get(i).equals(ins)) {
                return offset;
            }
            offset += ((Instruction)this.instructions.get(i)).length();
        }
        throw new JiapiRuntimeException("Isntruction not found; " + ins);
    }

    Instruction instructionAtOffset(short offset) {
        for (Instruction ins : this.instructions) {
            if (ins.getOffset() == offset) {
                return ins;
            }
            if (ins.getOffset() <= offset) continue;
            break;
        }
        return null;
    }

    public String toString() {
        if (this.instructions.size() == 0) {
            return "<empty>";
        }
        StringBuffer sb = new StringBuffer();
        Iterator i = this.instructions.iterator();
        int offset = 0;
        int count = 0;
        while (i.hasNext()) {
            Instruction ins = (Instruction)i.next();
            sb.append("  #");
            sb.append(count);
            if (count < 10) {
                sb.append(' ');
            }
            if (count < 100 && this.size() >= 100) {
                sb.append(' ');
            }
            sb.append(" (");
            sb.append(offset);
            sb.append(")  ");
            sb.append(ins.toString());
            if (i.hasNext()) {
                sb.append('\n');
            }
            ++count;
            offset += ins.length();
        }
        return sb.toString();
    }

    private boolean isModified() {
        return this.modified;
    }

    public void clear() {
        this.instructions.clear();
    }

    public InstructionFactory getInstructionFactory() {
        return new InstructionFactory(this.constantPool);
    }

    public JiapiMethod getDeclaringMethod() {
        return this.declaringMethod;
    }

    void setDeclaringMethod(JiapiMethod jm) {
        this.declaringMethod = jm;
    }

    public InstructionList createView(int start) {
        return this.createView(0, this.instructions.size());
    }

    public InstructionList createView(int start, int end) {
        InstructionList il = new InstructionList(this.constantPool, this.instructions.subList(start, end));
        il.setDeclaringMethod(this.declaringMethod);
        return il;
    }

    void updateOffsets() {
        short offset = 0;
        for (Instruction ins : this.instructions) {
            ins.setOffset(offset);
            offset = (short)(offset + ins.length());
        }
    }

    private void print(InstructionList il) {
        for (int i = 0; i < il.size(); ++i) {
            Instruction ins = il.get(i);
            System.out.println("  #" + i + " " + ins + ", stack-usage: " + ins.stackUsage());
        }
    }

    private Instruction changeLocalVars(Instruction ins) {
        int maxLocals = this.getDeclaringMethod().getMaxLocals();
        InstructionFactory factory = new InstructionFactory();
        switch (ins.getOpcode()) {
            case 42: {
                return factory.aload(maxLocals);
            }
            case 43: {
                return factory.aload(maxLocals + 1);
            }
            case 44: {
                return factory.aload(maxLocals + 2);
            }
            case 45: {
                return factory.aload(maxLocals + 3);
            }
            case 25: {
                byte[] byArray = ins.getBytes();
                byArray[1] = (byte)(byArray[1] + (byte)maxLocals);
                break;
            }
            case 75: {
                return factory.astore(maxLocals);
            }
            case 76: {
                return factory.astore(maxLocals + 1);
            }
            case 77: {
                return factory.astore(maxLocals + 2);
            }
            case 78: {
                return factory.astore(maxLocals + 3);
            }
            case 58: {
                byte[] byArray = ins.getBytes();
                byArray[1] = (byte)(byArray[1] + (byte)maxLocals);
                break;
            }
            case 26: {
                return factory.iload(maxLocals);
            }
            case 27: {
                return factory.iload(maxLocals + 1);
            }
            case 28: {
                return factory.iload(maxLocals + 2);
            }
            case 29: {
                return factory.iload(maxLocals + 3);
            }
            case 21: {
                byte[] byArray = ins.getBytes();
                byArray[1] = (byte)(byArray[1] + (byte)maxLocals);
                break;
            }
            case 59: {
                return factory.istore(maxLocals);
            }
            case 60: {
                return factory.istore(maxLocals + 1);
            }
            case 61: {
                return factory.istore(maxLocals + 2);
            }
            case 62: {
                return factory.istore(maxLocals + 3);
            }
            case 54: {
                byte[] byArray = ins.getBytes();
                byArray[1] = (byte)(byArray[1] + (byte)maxLocals);
                break;
            }
            case 38: {
                return factory.dload(maxLocals);
            }
            case 39: {
                return factory.dload(maxLocals + 1);
            }
            case 40: {
                return factory.dload(maxLocals + 2);
            }
            case 41: {
                return factory.dload(maxLocals + 3);
            }
            case 24: {
                byte[] byArray = ins.getBytes();
                byArray[1] = (byte)(byArray[1] + (byte)maxLocals);
                break;
            }
            case 71: {
                return factory.dstore(maxLocals);
            }
            case 72: {
                return factory.dstore(maxLocals + 1);
            }
            case 73: {
                return factory.dstore(maxLocals + 2);
            }
            case 74: {
                return factory.dstore(maxLocals + 3);
            }
            case 57: {
                byte[] byArray = ins.getBytes();
                byArray[1] = (byte)(byArray[1] + (byte)maxLocals);
                break;
            }
            case 30: {
                return factory.lload(maxLocals);
            }
            case 31: {
                return factory.lload(maxLocals + 1);
            }
            case 32: {
                return factory.lload(maxLocals + 2);
            }
            case 33: {
                return factory.lload(maxLocals + 3);
            }
            case 22: {
                byte[] byArray = ins.getBytes();
                byArray[1] = (byte)(byArray[1] + (byte)maxLocals);
                break;
            }
            case 63: {
                return factory.lstore(maxLocals);
            }
            case 64: {
                return factory.lstore(maxLocals + 1);
            }
            case 65: {
                return factory.lstore(maxLocals + 2);
            }
            case 66: {
                return factory.lstore(maxLocals + 3);
            }
            case 55: {
                byte[] byArray = ins.getBytes();
                byArray[1] = (byte)(byArray[1] + (byte)maxLocals);
                break;
            }
            case 34: {
                return factory.fload(maxLocals);
            }
            case 35: {
                return factory.fload(maxLocals + 1);
            }
            case 36: {
                return factory.fload(maxLocals + 2);
            }
            case 37: {
                return factory.fload(maxLocals + 3);
            }
            case 23: {
                byte[] byArray = ins.getBytes();
                byArray[1] = (byte)(byArray[1] + (byte)maxLocals);
                break;
            }
            case 67: {
                return factory.fstore(maxLocals);
            }
            case 68: {
                return factory.fstore(maxLocals + 1);
            }
            case 69: {
                return factory.fstore(maxLocals + 2);
            }
            case 70: {
                return factory.fstore(maxLocals + 3);
            }
            case 56: {
                byte[] byArray = ins.getBytes();
                byArray[1] = (byte)(byArray[1] + (byte)maxLocals);
            }
        }
        return ins;
    }
}

