/* unblockableCheck.h
 */
#ifndef _UNBLOCKABLECHECK_H
#define _UNBLOCKABLECHECK_H

#include "osl/state/numEffectState.h"
namespace osl
{
  namespace effect_util
  {

    struct UnblockableCheck
    {
      /**
       * target の王に合駒可能でない王手がかかっているかどうか.
       * - 両王手 => 真
       * - unblockable な利きだけ => 真
       * - blockable な利きだけ => 偽
       * - 王手でない => 偽
       */
      static bool isMember(Player target, const NumEffectState& state)
      {
	const Square king_position = state.kingSquare(target);
	Piece attacker_piece;
	if (state.hasEffectAt(alt(target), king_position, attacker_piece))
	{
	  if (attacker_piece == Piece::EMPTY())
	    return true;	// multiple pieces

	  // sigle check
	  const Square from = attacker_piece.square();
	  const EffectContent effect
	    = Ptype_Table.getEffect(attacker_piece.ptypeO(), 
				   from, king_position);
	  return effect.hasUnblockableEffect();
	}
	// no check
	return false;
      }
    };
    
  } // namespace effect_util
} // namespace osl

#endif /* _UNBLOCKABLECHECK_H */
// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
