#include "osl/effect_util/shadowEffect.h"
#include "osl/record/csaString.h"
#include "osl/record/csaRecord.h"

#include <cppunit/TestCase.h>
#include <cppunit/extensions/HelperMacros.h>

using namespace osl;
using namespace osl::effect_util;

class ShadowEffectTest : public CppUnit::TestFixture 
{
  CPPUNIT_TEST_SUITE(ShadowEffectTest);
  CPPUNIT_TEST(testHasEffect);
  CPPUNIT_TEST_SUITE_END();
public:
  void testHasEffect();
};

CPPUNIT_TEST_SUITE_REGISTRATION(ShadowEffectTest);

void ShadowEffectTest::testHasEffect()
{
  {
    NumEffectState state(CsaString(
			   "P1-KY-KE-GI-KI-OU-KI-GI-KE-KY\n"
			   "P2 * -HI *  *  *  *  *  *  * \n"
			   "P3-FU-FU-FU-FU-FU-FU-KA-FU-FU\n"
			   "P4 *  *  *  *  *  * -FU *  * \n"
			   "P5 *  *  *  *  *  *  *  *  * \n"
			   "P6 *  * +FU *  *  *  *  *  * \n"
			   "P7+FU+FU+KA+FU+FU+FU+FU+FU+FU\n"
			   "P8 *  *  *  *  *  *  * +HI * \n"
			   "P9+KY+KE+GI+KI+OU+KI+GI+KE+KY\n"
			   "+\n"
			   ).getInitialState());
    CPPUNIT_ASSERT_EQUAL(false, ShadowEffect::hasEffect
			 (state, Square(8,8), BLACK));
    CPPUNIT_ASSERT_EQUAL(true, ShadowEffect::hasEffect
			 (state, Square(8,8), WHITE));

    CPPUNIT_ASSERT_EQUAL(true, ShadowEffect::hasEffect
			 (state, Square(2,2), BLACK));
    CPPUNIT_ASSERT_EQUAL(false, ShadowEffect::hasEffect
			 (state, Square(2,2), WHITE));
  }
}
// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
