// model-body.mustache

// licenseInfo.mustache

/**
 * Libre Graph API
 * Libre Graph is a free API for cloud collaboration inspired by the MS Graph API.
 *
 * The version of the OpenAPI document: v1.0.4
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

#include "OAIAppRole.h"

#include <QDebug>
#include <QJsonArray>
#include <QJsonDocument>
#include <QObject>

#include "OAIHelpers.h"

namespace OpenAPI {

class OAIAppRolePrivate {
    friend class OAIAppRole;

     QList<QString> allowed_member_types;
     bool allowed_member_types_isSet;
     bool allowed_member_types_isValid;

     QString description;
     bool description_isSet;
     bool description_isValid;

     QString display_name;
     bool display_name_isSet;
     bool display_name_isValid;

     QString id;
     bool id_isSet;
     bool id_isValid;
};

OAIAppRole::OAIAppRole()
    : d_ptr()
{
}

OAIAppRole::OAIAppRole(const OAIAppRole& other)
    : d_ptr(other.d_ptr)
{
}

OAIAppRole::OAIAppRole(QString json)
    : d_ptr(nullptr)
{
    this->fromJson(json);
}

OAIAppRole::~OAIAppRole() = default;

void OAIAppRole::initializeModel() {
    if (d_ptr == nullptr) {
        d_ptr.reset(new OAIAppRolePrivate{});

        Q_D(OAIAppRole);


        d->allowed_member_types_isSet = false;
        d->allowed_member_types_isValid = false;

        d->description_isSet = false;
        d->description_isValid = false;

        d->display_name_isSet = false;
        d->display_name_isValid = false;

        d->id_isSet = false;
        d->id_isValid = false;
    }
}

void OAIAppRole::fromJson(QString jsonString) {
    QByteArray array(jsonString.toUtf8());
    QJsonDocument doc = QJsonDocument::fromJson(array);
    QJsonObject jsonObject = doc.object();
    this->fromJsonObject(jsonObject);
}

void OAIAppRole::fromJsonObject(QJsonObject json) {
    initializeModel();

    Q_D(OAIAppRole);

    d->allowed_member_types_isValid = ::OpenAPI::fromJsonValue(d->allowed_member_types, json[QString("allowedMemberTypes")]);
    d->allowed_member_types_isSet = !json[QString("allowedMemberTypes")].isNull() && d->allowed_member_types_isValid;

    d->description_isValid = ::OpenAPI::fromJsonValue(d->description, json[QString("description")]);
    d->description_isSet = !json[QString("description")].isNull() && d->description_isValid;

    d->display_name_isValid = ::OpenAPI::fromJsonValue(d->display_name, json[QString("displayName")]);
    d->display_name_isSet = !json[QString("displayName")].isNull() && d->display_name_isValid;

    d->id_isValid = ::OpenAPI::fromJsonValue(d->id, json[QString("id")]);
    d->id_isSet = !json[QString("id")].isNull() && d->id_isValid;
}

QString OAIAppRole::asJson() const {
    QJsonObject obj = this->asJsonObject();
    QJsonDocument doc(obj);
    QByteArray bytes = doc.toJson();
    return QString(bytes);
}

QJsonObject OAIAppRole::asJsonObject() const {
    Q_D(const OAIAppRole);
    if(!d){
        return {};
    }
    QJsonObject obj;
    if (d->allowed_member_types.size() > 0) {
        obj.insert(QString("allowedMemberTypes"), ::OpenAPI::toJsonValue(d->allowed_member_types));
    }
    if (d->description_isSet) {
        obj.insert(QString("description"), ::OpenAPI::toJsonValue(d->description));
    }
    if (d->display_name_isSet) {
        obj.insert(QString("displayName"), ::OpenAPI::toJsonValue(d->display_name));
    }
    if (d->id_isSet) {
        obj.insert(QString("id"), ::OpenAPI::toJsonValue(d->id));
    }
    return obj;
}

QList<QString> OAIAppRole::getAllowedMemberTypes() const {
    Q_D(const OAIAppRole);
    if(!d){
        return {};
    }
    return d->allowed_member_types;
}
void OAIAppRole::setAllowedMemberTypes(const QList<QString> &allowed_member_types) {
    Q_D(OAIAppRole);
    Q_ASSERT(d);

    d->allowed_member_types = allowed_member_types;
    d->allowed_member_types_isSet = true;
}

bool OAIAppRole::is_allowed_member_types_Set() const{
    Q_D(const OAIAppRole);
    if(!d){
        return false;
    }

    return d->allowed_member_types_isSet;
}

bool OAIAppRole::is_allowed_member_types_Valid() const{
    Q_D(const OAIAppRole);
    if(!d){
        return false;
    }
    return d->allowed_member_types_isValid;
}

QString OAIAppRole::getDescription() const {
    Q_D(const OAIAppRole);
    if(!d){
        return {};
    }
    return d->description;
}
void OAIAppRole::setDescription(const QString &description) {
    Q_D(OAIAppRole);
    Q_ASSERT(d);

    d->description = description;
    d->description_isSet = true;
}

bool OAIAppRole::is_description_Set() const{
    Q_D(const OAIAppRole);
    if(!d){
        return false;
    }

    return d->description_isSet;
}

bool OAIAppRole::is_description_Valid() const{
    Q_D(const OAIAppRole);
    if(!d){
        return false;
    }
    return d->description_isValid;
}

QString OAIAppRole::getDisplayName() const {
    Q_D(const OAIAppRole);
    if(!d){
        return {};
    }
    return d->display_name;
}
void OAIAppRole::setDisplayName(const QString &display_name) {
    Q_D(OAIAppRole);
    Q_ASSERT(d);

    d->display_name = display_name;
    d->display_name_isSet = true;
}

bool OAIAppRole::is_display_name_Set() const{
    Q_D(const OAIAppRole);
    if(!d){
        return false;
    }

    return d->display_name_isSet;
}

bool OAIAppRole::is_display_name_Valid() const{
    Q_D(const OAIAppRole);
    if(!d){
        return false;
    }
    return d->display_name_isValid;
}

QString OAIAppRole::getId() const {
    Q_D(const OAIAppRole);
    if(!d){
        return {};
    }
    return d->id;
}
void OAIAppRole::setId(const QString &id) {
    Q_D(OAIAppRole);
    Q_ASSERT(d);

    d->id = id;
    d->id_isSet = true;
}

bool OAIAppRole::is_id_Set() const{
    Q_D(const OAIAppRole);
    if(!d){
        return false;
    }

    return d->id_isSet;
}

bool OAIAppRole::is_id_Valid() const{
    Q_D(const OAIAppRole);
    if(!d){
        return false;
    }
    return d->id_isValid;
}

bool OAIAppRole::isSet() const {
    Q_D(const OAIAppRole);
    if(!d){
        return false;
    }
    bool isObjectUpdated = false;
    do {
        if (d->allowed_member_types.size() > 0) {
            isObjectUpdated = true;
            break;
        }

        if (d->description_isSet) {
            isObjectUpdated = true;
            break;
        }

        if (d->display_name_isSet) {
            isObjectUpdated = true;
            break;
        }

        if (d->id_isSet) {
            isObjectUpdated = true;
            break;
        }
    } while (false);
    return isObjectUpdated;
}

bool OAIAppRole::isValid() const {
    Q_D(const OAIAppRole);
    if(!d){
        return false;
    }
    // only required properties are required for the object to be considered valid
    return d->id_isValid && true;
}

} // namespace OpenAPI
