# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.open_gl_render_pass import OpenGLRenderPass


class ValuePass(OpenGLRenderPass):
    r"""
    ValuePass - Renders geometry using the values of a field array as
    fragment colors.
    
    Superclass: OpenGLRenderPass
    
    The output can be used for deferred color mapping. It supports using
    arrays of either point or cell data. The target array can be selected
    by setting an array name/id and a component number. Only opaque
    geometry is supported.
    
    There are two rendering modes available:
    
    * INVERTIBLE_LUT  Encodes array values as RGB data and renders the
      result to the default framebuffer.  It uses a texture as a color
      LUT to map the values to RGB data. Texture size constraints limit
      its precision (currently 12-bit). The implementation of this mode
      is in InternalsInvertible. This option is deprecated now that
      the SGI patent on floating point textures has expired and Mesa and
      other open_gl's always supports it.
    
    * FLOATING_POINT  Renders actual array values as floating point data
      to an internal RGBA32F framebuffer.  This class binds and unbinds
      the framebuffer on each render pass. Resources are allocated on
      demand. When rendering point data values are uploaded to the GPU as
    vertex attributes. When rendering cell data values are uploaded as a
      texture buffer. Custom vertex and fragment shaders are defined in
      order to adjust its behavior for either type of data.
    
    @sa
    RenderPass OpenGLRenderPass
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkValuePass, obj, update, **traits)
    
    def get_float_image_data(self, *args):
        """
        get_float_image_data(self, format:int, width:int, height:int,
            data:Pointer) -> None
        C++: void get_float_image_data(int const format, int const width,
            int const height, void *data)
        Interface to get the rendered image in FLOATING_POINT mode.  Low
        level API, a format for the internal glread_pixels call can be
        specified. 'data' is expected to be allocated and cleaned-up by
        the caller.
        """
        ret = self._wrap_call(self._vtk_obj.GetFloatImageData, *args)
        return ret

    def get_float_image_data_array(self, *args):
        """
        get_float_image_data_array(self, ren:Renderer) -> FloatArray
        C++: FloatArray *get_float_image_data_array(Renderer *ren)
        Interface to get the rendered image in FLOATING_POINT mode. 
        Returns a single component array containing the rendered values.
        \\warning The returned array is owned by this class.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.GetFloatImageDataArray, *my_args)
        return wrap_vtk(ret)

    def _get_float_image_extents(self):
        return self._vtk_obj.GetFloatImageExtents()
    float_image_extents = traits.Property(_get_float_image_extents, desc=\
        r"""
        Interface to get the rendered image in FLOATING_POINT mode. 
        Image extents of the value array.
        """
    )

    def set_input_array_to_process(self, *args):
        """
        set_input_array_to_process(self, fieldAssociation:int, name:str)
            -> None
        C++: void set_input_array_to_process(int fieldAssociation,
            const char *name)
        set_input_array_to_process(self, fieldAssociation:int, fieldId:int)
            -> None
        C++: void set_input_array_to_process(int fieldAssociation,
            int fieldId)"""
        ret = self._wrap_call(self._vtk_obj.SetInputArrayToProcess, *args)
        return ret

    def set_input_component_to_process(self, *args):
        """
        set_input_component_to_process(self, component:int) -> None
        C++: void set_input_component_to_process(int component)"""
        ret = self._wrap_call(self._vtk_obj.SetInputComponentToProcess, *args)
        return ret

    _updateable_traits_ = \
    (('debug', 'GetDebug'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('active_draw_buffers',
    'GetActiveDrawBuffers'), ('object_name', 'GetObjectName'),
    ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['debug', 'global_warning_display', 'active_draw_buffers',
    'object_name'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(ValuePass, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit ValuePass properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View(([], [], ['active_draw_buffers', 'object_name']),
            title='Edit ValuePass properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit ValuePass properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

