/*
 *
 * European Centre for Medium-Range Weather Forecasts: Reading
 * Standard
 *
 * Center: 98
 * Subcenter: 0
 * Parameter table version: 128
 */

TBLE2 ecmwf_128_params[] = {
{1, "Stream function", "m**2 s**-1", "STRF"},
{2, "Velocity potential", "m**2 s**-1", "VPOT"},
{3, "Potential temperature", "K", "PT"},
{4, "Equivalent potential temperature", "K", "EQPT"},
{5, "Saturated equivalent potential temperature", "K", "SEPT"},
{6, "Soil sand fraction", "(0 - 1)", "SSFR"},
{7, "Soil clay fraction", "(0 - 1)", "SCFR"},
{8, "Surface runoff", "m", "SRO"},
{9, "Sub-surface runoff", "m", "SSRO"},
{10, "Wind speed", "m s**-1", "WIND"},
{11, "U component of divergent wind", "m s**-1", "UDVW"},
{12, "V component of divergent wind", "m s**-1", "VDVW"},
{13, "U component of rotational wind", "m s**-1", "URTW"},
{14, "V component of rotational wind", "m s**-1", "VRTW"},
{15, "UV visible albedo for direct radiation", "(0 - 1)", "ALUVP"},
{16, "UV visible albedo for diffuse radiation", "(0 - 1)", "ALUVD"},
{17, "Near IR albedo for direct radiation", "(0 - 1)", "ALNIP"},
{18, "Near IR albedo for diffuse radiation", "(0 - 1)", "ALNID"},
{19, "Clear sky surface UV", "W m**-2 s", "UVCS"},
{20, "Clear sky surface PAR", "W m**-2 s", "PARCS"},
{21, "Unbalanced component of temperature", "K", "UCTP"},
{22, "Unbalanced component of logarithm of surface pressure", "-", "UCLN"},
{23, "Unbalanced component of divergence", "s**-1", "UCDV"},
{26, "Lake cover", "(0 - 1)", "CL"},
{27, "Low vegetation cover", "(0 - 1)", "CVL"},
{28, "High vegetation cover", "(0 - 1)", "CVH"},
{29, "Type of low vegetation", "-", "TVL"},
{30, "Type of high vegetation", "-", "TVH"},
{31, "Sea-ice cover", "(0 - 1)", "CI"},
{32, "Snow albedo", "(0 - 1)", "ASN"},
{33, "Snow density", "kg m**-3", "RSN"},
{34, "Sea surface temperature", "K", "SSTK"},
{35, "Ice surface temperature layer 1", "K", "ISTL1"},
{36, "Ice surface temperature layer 2", "K", "ISTL2"},
{37, "Ice surface temperature layer 3", "K", "ISTL3"},
{38, "Ice surface temperature layer 4", "K", "ISTL4"},
{39, "Volumetric soil water layer 1", "m**3 m**-3", "SWVL1"},
{40, "Volumetric soil water layer 2", "m**3 m**-3", "SWVL2"},
{41, "Volumetric soil water layer 3", "m**3 m**-3", "SWVL3"},
{42, "Volumetric soil water layer 4", "m**3 m**-3", "SWVL4"},
{43, "Soil type", "-", "SLT"},
{44, "Snow evaporation", "m of water", "ES"},
{45, "Snowmelt", "m of water", "SMLT"},
{46, "Solar duration", "s", "SDUR"},
{47, "Direct solar radiation", "w m**-2", "DSRP"},
{48, "Magnitude of surface stress", "N m**-2 s", "MAGSS"},
{49, "10 metre wind gust", "m s**-1", "10FG"},
{50, "Large-scale precipitation fraction", "s", "LSPF"},
{51, "Maximum temperature at 2 metres since last 24 hours", "K", "MX2T24"},
{52, "Minimum temperature at 2 metres since last 24 hours", "K", "MN2T24"},
{53, "Montgomery potential", "m**2 s**-2", "MONT"},
{54, "Pressure", "Pa", "PRES"},
{55, "Mean temperature at 2 metres since last 24 hours", "K", "MEAN2T24"},
{56, "Mean 2 metre dewpoint temperature in past 24 hours", "K", "MN2D24"},
{57, "Downward UV radiation at the surface", "w m**-2 s", "UVB"},
{58, "Photosynthetically active radiation at the surface", "w m**-2 s", "PAR"},
{59, "Convective available potential energy", "J kg**-1", "CAPE"},
{60, "Potential vorticity", "K m**2 kg**-1 s**-1", "PV"},
{62, "Observation count", "-", "OBCT"},
{63, "Start time for skin temperature difference", "s", ""},
{64, "Finish time for skin temperature difference", "s", ""},
{65, "Skin temperature difference", "K", ""},
{66, "Leaf area index, low vegetation", "m**2 / m**2", ""},
{67, "Leaf area index, high vegetation", "m**2 / m**2", ""},
{68, "Minimum stomatal resistance, low vegetation", "s m**-1", ""},
{69, "Minimum stomatal resistance, high vegetation", "s m**-1", ""},
{70, "Biome cover, low vegetation", "(0 - 1)", ""},
{71, "Biome cover, high vegetation", "(0 - 1)", ""},
{72, "Instantaneous surface solar radiation downwards", "w m**-2", "ISSRD"},
{73, "Instantaneous surface thermal radiation downwards", "w m**-2", "ISTRD"},
{74, "Standard deviation of filtered subgrid orography", "m", "SDFOR"},
{75, "Cloud rain water content", "kg kg**-1", "CRWC"},
{76, "Cloud snow water content", "kg kg**-1", "CSWC"},
{77, "Eta-coordinate vertical velocity", "s**-1", "ETADOT"},
{78, "Total column liquid water", "kg m**-2", "TCLW"},
{79, "Total column ice water", "kg m**-2", "TCIW"},
{121, "Maximum temperature at 2 metres since last 6 hours", "K", "MX2T6"},
{122, "Minimum temperature at 2 metres since last 6 hours", "K", "MN2T6"},
{123, "10 metre wind gust in the past 6 hours", "m s**-1", "10FG6"},
{124, "Surface emissivity", "dimensionless", "EMIS"},
{125, "Vertically integrated total energy", "J m**-2", ""},
{126, "Generic parameter for sensitive area prediction", "Various", ""},
{127, "Atmospheric tide", "-", "AT"},
{128, "Budget values", "-", "BV"},
{129, "Geopotential", "m**2 s**-2", "Z"},
{130, "Temperature", "K", "T"},
{131, "U velocity", "m s**-1", "U"},
{132, "V velocity", "m s**-1", "V"},
{133, "Specific humidity", "kg kg**-1", "Q"},
{134, "Surface pressure", "Pa", "SP"},
{135, "Vertical velocity", "Pa s**-1", "W"},
{136, "Total column water", "kg m**-2", "TCW"},
{137, "Total column water vapour", "kg m**-2", "TCWV"},
{138, "Vorticity (relative)", "s**-1", "VO"},
{139, "Soil temperature level 1", "K", "STL1"},
{140, "Soil wetness level 1", "m of water", "SWL1"},
{141, "Snow depth", "m of water equivalent", "SD"},
{142, "Stratiform precipitation (Large-scale precipitation)", "m", "LSP"},
{143, "Convective precipitation", "m", "CP"},
{144, "Snowfall", "m of water equivalent", "SF"},
{145, "Boundary layer dissipation", "W m**-2 s", "BLD"},
{146, "Surface sensible heat flux", "W m**-2 s", "SSHF"},
{147, "Surface latent heat flux", "W m**-2 s", "SLHF"},
{148, "Charnock", "-", "CHNK"},
{149, "Surface net radiation", "W m**-2 s", "SNR"},
{150, "Top net radiation", "-", "TNR"},
{151, "Mean sea level pressure", "Pa", "MSL"},
{152, "Logarithm of surface pressure", "-", "LNSP"},
{153, "Short-wave heating rate", "K", "SWHR"},
{154, "Long-wave heating rate", "K", "LWHR"},
{155, "Divergence", "s**-1", "D"},
{156, "Height", "gpm", "GH"},
{157, "Relative humidity", "%", "R"},
{158, "Tendency of surface pressure", "Pa s**-1", "TSP"},
{159, "Boundary layer height", "m", "BLH"},
{160, "Standard deviation of orography", "-", "SDOR"},
{161, "Anisotropy of sub-gridscale orography", "-", "ISOR"},
{162, "Angle of sub-gridscale orography", "rad", "ANOR"},
{163, "Slope of sub-gridscale orography", "-", "SLOR"},
{164, "Total cloud cover", "(0 - 1)", "TCC"},
{165, "10 metre U wind component", "m s**-1", "10U"},
{166, "10 metre V wind component", "m s**-1", "10V"},
{167, "2 metre temperature", "K", "2T"},
{168, "2 metre dewpoint temperature", "K", "2D"},
{169, "Surface solar radiation downwards", "W m**-2 s", "SSRD"},
{170, "Soil temperature level 2", "K", "STL2"},
{171, "Soil wetness level 2", "m of water", "SWL2"},
{172, "Land-sea mask", "(0 - 1)", "LSM"},
{173, "Surface roughness", "m", "SR"},
{174, "Albedo", "(0 - 1)", "AL"},
{175, "Surface thermal radiation downwards", "W m**-2 s", "STRD"},
{176, "Surface solar radiation", "W m**-2 s", "SSR"},
{177, "Surface thermal radiation", "W m**-2 s", "STR"},
{178, "Top solar radiation", "W m**-2 s", "TSR"},
{179, "Top thermal radiation", "W m**-2 s", "TTR"},
{180, "East-West surface stress", "N m**-2 s", "EWSS"},
{181, "North-South surface stress", "N m**-2 s", "NSSS"},
{182, "Evaporation", "m of water", "E"},
{183, "Soil temperature level 3", "K", "STL3"},
{184, "Soil wetness level 3", "m of water", "SWL3"},
{185, "Convective cloud cover", "(0 - 1)", "CCC"},
{186, "Low cloud cover", "(0 - 1)", "LCC"},
{187, "Medium cloud cover", "(0 - 1)", "MCC"},
{188, "High cloud cover", "(0 - 1)", "HCC"},
{189, "Sunshine duration", "s", "SUND"},
{190, "East-West component of sub-gridscale orographic variance", "m**2", "EWOV"},
{191, "North-South component of sub-gridscale orographic variance", "m**2", "NSOV"},
{192, "North-West/South-East component of sub-gridscale orographic variance", "m**2", "NWOV"},
{193, "North-East/South-West component of sub-gridscale orographic variance", "m**2", "NEOV"},
{194, "Brightness temperature", "K", "BTMP"},
{195, "Latitudinal component of gravity wave stress", "N m**-2 s", "LGWS"},
{196, "Meridional component of gravity wave stress", "N m**-2 s", "MGWS"},
{197, "Gravity wave dissipation", "W m**-2 s", "GWD"},
{198, "Skin reservoir content", "m of water", "SRC"},
{199, "Vegetation fraction", "(0 - 1)", "VEG"},
{200, "Variance of sub-gridscale orography", "m**2", "VSO"},
{201, "Maximum temperature at 2 metres since previous post-processing", "K", "MX2T"},
{202, "Minimum temperature at 2 metres since previous post-processing", "K", "MN2T"},
{203, "Ozone mass mixing ratio", "kg kg**-1", "O3"},
{204, "Precipitation analysis weights", "-", "PAW"},
{205, "Runoff", "m", "RO"},
{206, "Total column ozone", "kg m**-2", "TCO3"},
{207, "10 metre wind speed", "m s**-1", "10SI"},
{208, "Top net solar radiation, clear sky", "W m**-2 s", "TSRC"},
{209, "Top net thermal radiation, clear sky", "W m**-2 s", "TTRC"},
{210, "Surface net solar radiation, clear sky", "W m**-2 s", "SSRC"},
{211, "Surface net thermal radiation, clear sky", "W m**-2 s", "STRC"},
{212, "TOA incident solar radiation", "W m**-2 s", "TISR"},
{213, "Vertically integrated moisture divergence", "kg m**-2", "VIMD"},
{214, "Diabatic heating by radiation", "K", "DHR"},
{215, "Diabatic heating by vertical diffusion", "K", "DHVD"},
{216, "Diabatic heating by cumulus convection", "K", "DHCC"},
{217, "Diabatic heating large-scale condensation", "K", "DHLC"},
{218, "Vertical diffusion of zonal wind", "m s**-1", "VDZW"},
{219, "Vertical diffusion of meridional wind", "m s**-1", "VDMW"},
{220, "East-West gravity wave drag tendency", "m s**-1", "EWGD"},
{221, "North-South gravity wave drag tendency", "m s**-1", "NSGD"},
{222, "Convective tendency of zonal wind", "m s**-1", "CTZW"},
{223, "Convective tendency of meridional wind", "m s**-1", "CTMW"},
{224, "Vertical diffusion of humidity", "kg kg**-1", "VDH"},
{225, "Humidity tendency by cumulus convection", "kg kg**-1", "HTCC"},
{226, "Humidity tendency by large-scale condensation", "kg kg**-1", "HTLC"},
{227, "Change from removal of negative humidity", "kg kg**-1", "CRNH"},
{228, "Total precipitation", "m", "TP"},
{229, "Instantaneous X surface stress", "N m**-2", "IEWS"},
{230, "Instantaneous Y surface stress", "N m**-2", "INSS"},
{231, "Instantaneous surface heat flux", "W m**-2", "ISHF"},
{232, "Instantaneous moisture flux", "kg m**-2 s**-1", "IE"},
{233, "Apparent surface humidity", "kg kg**-1", "ASQ"},
{234, "Logarithm of surface roughness length for heat", "-", "LSRH"},
{235, "Skin temperature", "K", "SKT"},
{236, "Soil temperature level 4", "K", "STL4"},
{237, "Soil wetness level 4", "m", "SWL4"},
{238, "Temperature of snow layer", "K", "TSN"},
{239, "Convective snowfall", "m of water equivalent", "CSF"},
{240, "Large-scale snowfall", "m of water equivalent", "LSF"},
{241, "Accumulated cloud fraction tendency", "(-1 to 1)", "ACF"},
{242, "Accumulated liquid water tendency", "(-1 to 1)", "ALW"},
{243, "Forecast albedo", "(0 - 1)", "FAL"},
{244, "Forecast surface roughness", "m", "FSR"},
{245, "Forecast logarithm of surface roughness for heat", "-", "FLSR"},
{246, "Cloud liquid water content", "kg kg**-1", "CLWC"},
{247, "Cloud ice water content", "kg kg**-1", "CIWC"},
{248, "Cloud cover", "(0 - 1)", "CC"},
{249, "Accumulated ice water tendency", "(-1 to 1)", "AIW"},
{250, "Ice age", "(0 - 1)", "ICE"},
{251, "Adiabatic tendency of temperature", "K", "ATTE"},
{252, "Adiabatic tendency of humidity", "kg kg**-1", "ATHE"},
{253, "Adiabatic tendency of zonal wind", "m s**-1", "ATZE"},
{254, "Adiabatic tendency of meridional wind", "m s**-1", "ATMW"}
};
