/*
 *  Copyright (C) 2004 Mathias Andre <mathias@openbrookes.org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 */

#ifndef __NB_ATTACHMENT_H__
#define __NB_ATTACHMENT_H__

#include <glib.h>
#include <libxml/xmlmemory.h>
#include <libxml/parser.h>

typedef struct _attachment Attachment;

struct _attachment 
{
	gchar * uri;
	gchar * mime_type;
};

/* create and free object */
Attachment	* nb_attachment_new (gchar * uri, gchar * mime_type);
void		nb_attachment_free (Attachment * self);

/* read/write from/to xml doc */
Attachment	* nb_attachment_new_from_xml_doc (xmlDocPtr doc, xmlNodePtr cur);
xmlNodePtr	nb_attachment_get_xml_pointer (Attachment * self, xmlNsPtr ns);

/* check if the uri is still valid */
gboolean	nb_attachment_check (Attachment * self);

#endif 
