// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _ShapeExtend_Explorer_HeaderFile
#define _ShapeExtend_Explorer_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_DefineAlloc_HeaderFile
#include <Standard_DefineAlloc.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

#ifndef _Handle_TopTools_HSequenceOfShape_HeaderFile
#include <Handle_TopTools_HSequenceOfShape.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _TopAbs_ShapeEnum_HeaderFile
#include <TopAbs_ShapeEnum.hxx>
#endif
class Standard_TypeMismatch;
class TopoDS_Shape;
class TopTools_HSequenceOfShape;
class TopTools_ListOfShape;


//! This class is intended to <br>
//! explore shapes and convert different representations <br>
//! (list, sequence, compound) of complex shapes. It provides tools for: <br>
//! - obtaining type of the shapes in context of TopoDS_Compound, <br>
//! - exploring shapes in context of  TopoDS_Compound, <br>
//! - converting different representations of shapes (list, sequence, compound). <br>
class ShapeExtend_Explorer  {
public:

  DEFINE_STANDARD_ALLOC

  //! Creates an object Explorer <br>
  Standard_EXPORT   ShapeExtend_Explorer();
  //! Converts a sequence of Shapes to a Compound <br>
  Standard_EXPORT     TopoDS_Shape CompoundFromSeq(const Handle(TopTools_HSequenceOfShape)& seqval) const;
  //! Converts a Compound to a list of Shapes <br>
//!          if <comp> is not a compound, the list contains only <comp> <br>
//!          if <comp> is Null, the list is empty <br>
//!          if <comp> is a Compound, its sub-shapes are put into the list <br>
//!          then if <expcomp> is True, if a sub-shape is a Compound, it <br>
//!          is not put to the list but its sub-shapes are (recursive) <br>
  Standard_EXPORT     Handle_TopTools_HSequenceOfShape SeqFromCompound(const TopoDS_Shape& comp,const Standard_Boolean expcomp) const;
  //! Converts a Sequence of Shapes to a List of Shapes <br>
//!          <clear> if True (D), commands the list to start from scratch <br>
//!          else, the list is cumulated <br>
  Standard_EXPORT     void ListFromSeq(const Handle(TopTools_HSequenceOfShape)& seqval,TopTools_ListOfShape& lisval,const Standard_Boolean clear = Standard_True) const;
  //! Converts a List of Shapes to a Sequence of Shapes <br>
  Standard_EXPORT     Handle_TopTools_HSequenceOfShape SeqFromList(const TopTools_ListOfShape& lisval) const;
  //! Returns the type of a Shape: true type if <compound> is False <br>
//!          If <compound> is True and <shape> is a Compound, iterates on <br>
//!          its items. If all are of the same type, returns this type. <br>
//!          Else, returns COMPOUND. If it is empty, returns SHAPE <br>
//!          For a Null Shape, returns SHAPE <br>
  Standard_EXPORT     TopAbs_ShapeEnum ShapeType(const TopoDS_Shape& shape,const Standard_Boolean compound) const;
  //! Builds a COMPOUND from the given shape. <br>
//!          It explores the shape level by level, according to the <br>
//!          <explore> argument. If <explore> is False, only COMPOUND <br>
//!          items are explored, else all items are. <br>
//!          The following shapes are added to resulting compound: <br>
//!        - shapes which comply to <type> <br>
//!        - if <type> is WIRE, considers also free edges (and makes wires) <br>
//!        - if <type> is SHELL, considers also free faces (and makes shells) <br>
//!          If <compound> is True, gathers items in compounds which <br>
//!          correspond to starting COMPOUND,SOLID or SHELL containers, or <br>
//!          items directly contained in a Compound <br>
  Standard_EXPORT     TopoDS_Shape SortedCompound(const TopoDS_Shape& shape,const TopAbs_ShapeEnum type,const Standard_Boolean explore,const Standard_Boolean compound) const;
  //! Dispatches starting list of shapes according to their type, <br>
//!          to the appropriate resulting lists <br>
//!          For each of these lists, if it is null, it is firstly created <br>
//!          else, new items are appended to the already existing ones <br>
  Standard_EXPORT     void DispatchList(const Handle(TopTools_HSequenceOfShape)& list,Handle(TopTools_HSequenceOfShape)& vertices,Handle(TopTools_HSequenceOfShape)& edges,Handle(TopTools_HSequenceOfShape)& wires,Handle(TopTools_HSequenceOfShape)& faces,Handle(TopTools_HSequenceOfShape)& shells,Handle(TopTools_HSequenceOfShape)& solids,Handle(TopTools_HSequenceOfShape)& compsols,Handle(TopTools_HSequenceOfShape)& compounds) const;





protected:





private:





};





// other Inline functions and methods (like "C++: function call" methods)


#endif
