// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _StepSelect_WorkLibrary_HeaderFile
#define _StepSelect_WorkLibrary_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_DefineHandle_HeaderFile
#include <Standard_DefineHandle.hxx>
#endif
#ifndef _Handle_StepSelect_WorkLibrary_HeaderFile
#include <Handle_StepSelect_WorkLibrary.hxx>
#endif

#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _IFSelect_WorkLibrary_HeaderFile
#include <IFSelect_WorkLibrary.hxx>
#endif
#ifndef _Standard_CString_HeaderFile
#include <Standard_CString.hxx>
#endif
#ifndef _Handle_Interface_InterfaceModel_HeaderFile
#include <Handle_Interface_InterfaceModel.hxx>
#endif
#ifndef _Handle_Interface_Protocol_HeaderFile
#include <Handle_Interface_Protocol.hxx>
#endif
#ifndef _Handle_Standard_Transient_HeaderFile
#include <Handle_Standard_Transient.hxx>
#endif
#ifndef _Handle_Message_Messenger_HeaderFile
#include <Handle_Message_Messenger.hxx>
#endif
class Interface_InterfaceModel;
class Interface_Protocol;
class IFSelect_ContextWrite;
class Interface_EntityIterator;
class Interface_CopyTool;
class Standard_Transient;
class Message_Messenger;


//! Performs Read and Write a STEP File with a STEP Model <br>
//!           Following the protocols, Copy may be implemented or not <br>
class StepSelect_WorkLibrary : public IFSelect_WorkLibrary {

public:

  //! Creates a STEP WorkLibrary <br>
//!           <copymode> precises whether Copy is implemented or not <br>
  Standard_EXPORT   StepSelect_WorkLibrary(const Standard_Boolean copymode = Standard_True);
  //! Selects a mode to dump entities <br>
//!           0 (D) : prints numbers, then displays table number/label <br>
//!           1 : prints labels, then displays table label/number <br>
//!           2 : prints labels onky <br>
  Standard_EXPORT     void SetDumpLabel(const Standard_Integer mode) ;
  //! Reads a STEP File and returns a STEP Model (into <mod>), <br>
//!           or lets <mod> "Null" in case of Error <br>
//!           Returns 0 if OK, 1 if Read Error, -1 if File not opened <br>
  Standard_EXPORT     Standard_Integer ReadFile(const Standard_CString name,Handle(Interface_InterfaceModel)& model,const Handle(Interface_Protocol)& protocol) const;
  //! Writes a File from a STEP Model <br>
//!           Returns False (and writes no file) if <ctx> does not bring a <br>
//!           STEP Model <br>
  Standard_EXPORT     Standard_Boolean WriteFile(IFSelect_ContextWrite& ctx) const;
  //! Performs the copy of entities from an original model to a new <br>
//!           one. Works according <copymode> : <br>
//!           if True, standard copy is run <br>
//!           else nothing is done and returned value is False <br>
  Standard_EXPORT   virtual  Standard_Boolean CopyModel(const Handle(Interface_InterfaceModel)& original,const Handle(Interface_InterfaceModel)& newmodel,const Interface_EntityIterator& list,Interface_CopyTool& TC) const;
  //! Dumps an entity under STEP form, i.e. as a part of a Step file <br>
//!           Works with a StepDumper. <br>
//!           Level 0 just displays type; level 1 displays the entity itself <br>
//!           and level 2 displays the entity plus its shared ones (one <br>
//!           sub-level : immediately shared entities) <br>
  Standard_EXPORT     void DumpEntity(const Handle(Interface_InterfaceModel)& model,const Handle(Interface_Protocol)& protocol,const Handle(Standard_Transient)& entity,const Handle(Message_Messenger)& S,const Standard_Integer level) const;




  DEFINE_STANDARD_RTTI(StepSelect_WorkLibrary)

protected:




private: 


Standard_Boolean thecopymode;
Standard_Integer thelabmode;


};





// other Inline functions and methods (like "C++: function call" methods)


#endif
