// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _StlMesh_Mesh_HeaderFile
#define _StlMesh_Mesh_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_DefineHandle_HeaderFile
#include <Standard_DefineHandle.hxx>
#endif
#ifndef _Handle_StlMesh_Mesh_HeaderFile
#include <Handle_StlMesh_Mesh.hxx>
#endif

#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _StlMesh_SequenceOfMeshDomain_HeaderFile
#include <StlMesh_SequenceOfMeshDomain.hxx>
#endif
#ifndef _gp_XYZ_HeaderFile
#include <gp_XYZ.hxx>
#endif
#ifndef _MMgt_TShared_HeaderFile
#include <MMgt_TShared.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
class Standard_NegativeValue;
class Standard_NullValue;
class Standard_NoSuchObject;
class gp_XYZ;
class StlMesh_SequenceOfMeshTriangle;
class TColgp_SequenceOfXYZ;


//! Mesh definition.  The mesh contains one or several <br>
//!          domains. Each  mesh   domain  contains a  set   of <br>
//!          triangles. Each domain can have its own deflection <br>
//!          value. <br>
//! <br>
class StlMesh_Mesh : public MMgt_TShared {

public:

  //! Creates an empty mesh. <br>
  Standard_EXPORT   StlMesh_Mesh();
  //! Adds a   new mesh domain.  The  mesh deflection is <br>
//!          defaulted to Confusion from package Precision. <br>
  Standard_EXPORT   virtual  void AddDomain() ;
  //! Adds a new mesh domain. <br>//! Raised if the deflection is lower than zero <br>//! Raised if  the deflection is lower  than Confusion <br>
//!          from package Precision <br>
  Standard_EXPORT   virtual  void AddDomain(const Standard_Real Deflection) ;
  //! Build a triangle with the triplet of vertices (V1, <br>
//!          V2, V3).  This triplet defines  the indexes of the <br>
//!          vertex in the  current domain The coordinates  Xn, <br>
//!          Yn,  Zn  defines   the normal  direction   to  the <br>
//!          triangle.  Returns  the  range of  the triangle in <br>
//!          the current domain. <br>
  Standard_EXPORT   virtual  Standard_Integer AddTriangle(const Standard_Integer V1,const Standard_Integer V2,const Standard_Integer V3,const Standard_Real Xn,const Standard_Real Yn,const Standard_Real Zn) ;
  //! Returns the  range  of the  vertex in the  current <br>
//!          domain. <br>
  Standard_EXPORT   virtual  Standard_Integer AddVertex(const Standard_Real X,const Standard_Real Y,const Standard_Real Z) ;
  //! Returns  the range of   the vertex in  the current <br>
//!          domain.  The current vertex is not inserted in the <br>
//!          mesh if it already exist. <br>
  Standard_EXPORT   virtual  Standard_Integer AddOnlyNewVertex(const Standard_Real X,const Standard_Real Y,const Standard_Real Z) ;
  //! Each  vertex of  the  mesh verifies  the following <br>
//!          relations : <br>
//!          XYZMin.X() <= X <= XYZMax.X() <br>
//!          XYZMin.Y() <= Y <= XYZMax.y() <br>
//!          XYZMin.Z() <= Z <= XYZMax.Z() <br>
  Standard_EXPORT   virtual  void Bounds(gp_XYZ& XYZmax,gp_XYZ& XYZmin) const;
  
  Standard_EXPORT   virtual  void Clear() ;
  //! Returns the deflection of the mesh of the domain <br>
//!          of range <DomainIndex>. <br>//! Raised if <DomainIndex> is lower than 1 or greater <br>
//!          than the number of domains. <br>
  Standard_EXPORT   virtual  Standard_Real Deflection(const Standard_Integer DomainIndex) const;
  
      virtual  Standard_Boolean IsEmpty() const;
  //! Number of domains in the mesh. <br>
      virtual  Standard_Integer NbDomains() const;
  //! Cumulative Number of triangles in the mesh. <br>
        Standard_Integer NbTriangles() const;
  //! Number of  triangles   in  the  domain   of  range <br>
//!          <DomainIndex>. <br>//! Raised if <DomainIndex> is lower than 1 or greater <br>
//!          than the number of domains. <br>
  Standard_EXPORT   virtual  Standard_Integer NbTriangles(const Standard_Integer DomainIndex) const;
  //! Cumulative Number of vertices in the mesh. <br>
      virtual  Standard_Integer NbVertices() const;
  //! Number of vertices in the domain of range <br>
//!          <DomainIndex>. <br>//! Raised if <DomainIndex> is lower than 1 or greater <br>
//!          than the number of domains. <br>
  Standard_EXPORT   virtual  Standard_Integer NbVertices(const Standard_Integer DomainIndex) const;
  //! Returns the set of triangle   of   the  mesh domain   of   range <br>
//!          <DomainIndex>. <br>//! Raised if <DomainIndex> is lower than 1 or greater <br>
//!          than the number of domains. <br>
  Standard_EXPORT   virtual const StlMesh_SequenceOfMeshTriangle& Triangles(const Standard_Integer DomainIndex = 1) const;
  //! Returns  the coordinates   of the  vertices of the <br>
//!          mesh domain   of range <DomainIndex>.   {XV1, YV1, <br>
//!          ZV1, XV2, YV2, ZV2, XV3,.....} <br>//! Raised if <DomainIndex> is lower than 1 or greater <br>
//!          than the number of domains. <br>
  Standard_EXPORT   virtual const TColgp_SequenceOfXYZ& Vertices(const Standard_Integer DomainIndex = 1) const;




  DEFINE_STANDARD_RTTI(StlMesh_Mesh)

protected:


Standard_Integer nbTriangles;
Standard_Integer nbVertices;
StlMesh_SequenceOfMeshDomain domains;
gp_XYZ xyzmax;
gp_XYZ xyzmin;


private: 




};


#include <StlMesh_Mesh.lxx>



// other Inline functions and methods (like "C++: function call" methods)


#endif
