// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _Visual3d_TransientManager_HeaderFile
#define _Visual3d_TransientManager_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_DefineHandle_HeaderFile
#include <Standard_DefineHandle.hxx>
#endif
#ifndef _Handle_Visual3d_TransientManager_HeaderFile
#include <Handle_Visual3d_TransientManager.hxx>
#endif

#ifndef _MMgt_TShared_HeaderFile
#include <MMgt_TShared.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Handle_Visual3d_View_HeaderFile
#include <Handle_Visual3d_View.hxx>
#endif
#ifndef _Handle_Graphic3d_Structure_HeaderFile
#include <Handle_Graphic3d_Structure.hxx>
#endif
class Visual3d_TransientDefinitionError;
class Graphic3d_TransformError;
class Visual3d_View;
class Graphic3d_Structure;


//! This class allows to manage transient graphics <br>
//!      above one View. <br>
//!      A simple way to drawn something very quicly above <br>
//!      a complex scene (Hilighting,Sketching,...) <br>
//!      All transient graphics will be erased at the next <br>
//!      View::BeginDraw(). <br>
//!      If RetainMode is active, <br>
//!      All transient graphics will be kept at the <br>
//!      next View::Update(),Redraw(). The transient graphics <br>
//!      is stored by this object and graphic library, the <br>
//!      graphic managed itself exposure,resizing,... <br>
//!      The method View::ClearDraw() is necessary to erase <br>
//!      all transient graphics. <br>
//!      If RetainMode is deactivate, <br>
//!      All transient graphics will be erased at the <br>
//!      next View::Update(),Redraw(). <br>
//!      Remember that nothing is stored by this object and <br>
//!      graphic library,the application must managed itself <br>
//!      exposure,resizing,... <br>
//!      If double_buffering is activate, <br>
//!      all graphics are drawn in the back buffer and flushed <br>
//!      in the front buffer at the end of drawing but nothing <br>
//!      is done for to separate transient from structured <br>
//!      graphics,the only way to regenerate the structured <br>
//!      view is to Redraw() the view. <br>
//!      If double_buffering is deactivate, <br>
//!      the back buffer is preserved and used for restoring <br>
//!      the front buffer at begin drawing time.I recommend <br>
//!      to use the second way (without DB) if you want <br>
//!      to preserve the graphics and the performances! <br>
class Visual3d_TransientManager : public MMgt_TShared {

public:

  //! Creates a TransientManager <aView>. <br>
  Standard_EXPORT   Visual3d_TransientManager();
  //! Suppress the TransientManager <me>. <br>
  Standard_EXPORT     void Destroy() ;
~Visual3d_TransientManager()
{
  Destroy();
}
  //! Begins any graphics in the view <aView> <br>
//!      Redraw any structured graphics in the back buffer before <br>
//!      if <DoubleBuffer> is TRUE. <br>
//!          Restore the front buffer from the back before <br>
//!      if <DoubleBuffer> is FALSE. <br>
//!      if <RetainMode> is TRUE. <br>
//!          the graphic managed itself exposure,resizing ... <br>
//!      if <RetainMode> is FALSE. <br>
//!          the application must managed itself exposure,resizing ... <br>
//! <br>
//!  Warning: Returns TRUE if transient drawing is enabled in <br>
//!     the associated view. <br>
//!          Returns FALSE ,if nothing works because something <br>
//!     is wrong for the transient principle : <br>
//!     Immediat mode is not implemented depending of the <br>
//!     graphic library used. <br>
//!         MBX,PIXMAP double buffering don't works depending of <br>
//!         the graphic board and the visual of the window supporting <br>
//!         the view. <br>
//!  Warning: No default attributes <br>
//! Raises TransientDefinitionError from Visual3d; <br>
//! if   Drawing is already opened. <br>
//! or   the associated view is not mapped on a window. <br>
  Standard_EXPORT   static  Standard_Integer BeginDraw(const Handle(Visual3d_View)& aView,const Standard_Boolean DoubleBuffer = Standard_False,const Standard_Boolean RetainMode = Standard_False) ;
  //! Flush all graphics to the front buffer. <br>
//!  Synchronize graphics to the screen if <Synchronize> is <br>
//!  TRUE (make becarefull to the performances!). <br>
//!  Raises TransientDefinitionError from Visual3d; <br>
//! if   Drawing is not opened. <br>
  Standard_EXPORT   static  void EndDraw(const Standard_Boolean Synchronize = Standard_False) ;
  //! Clear all transient graphics in the view <aView> <br>
//!         updates a scene if <aFlush> = true <br>
//!  Raises TransientDefinitionError from Visual3d; <br>
//! if   Drawing is already opened. <br>
//! or   the associated view is not mapped on a window. <br>
  Standard_EXPORT   static  void ClearDraw(const Handle(Visual3d_View)& aView,const Standard_Boolean aFlush = Standard_True) ;
  //! Begins any add graphics in the view <aView> <br>
//!          the application must managed itself exposure,resizing ... <br>
//! <br>
//!  Warning: Returns TRUE if transient drawing is enabled in <br>
//!     the associated view. <br>
//!          Returns FALSE ,if nothing works because something <br>
//!     is wrong for the transient principle : <br>
//!     Immediat mode is not implemented depending of the <br>
//!     graphic library used. <br>
//!         MBX,PIXMAP double buffering don't works depending of <br>
//!         the graphic board and the visual of the window supporting <br>
//!         the view. <br>
//!  Warning: No default attributes <br>
//! Raises TransientDefinitionError from Visual3d; <br>
//! if   Drawing is already opened. <br>
//! or   the associated view is not mapped on a window. <br>
  Standard_EXPORT   static  Standard_Integer BeginAddDraw(const Handle(Visual3d_View)& aView) ;
  //! Flush all add graphics to the front buffer. <br>
//! Raises TransientDefinitionError from Visual3d; <br>
//! if   Drawing is not opened. <br>
  Standard_EXPORT   static  void EndAddDraw() ;
  //! Drawn the structure <AStructure>. <br>
//! Raises TransientDefinitionError from Visual3d; <br>
//! if   Drawing is not opened. <br>
  Standard_EXPORT   static  void DrawStructure(const Handle(Graphic3d_Structure)& AStructure) ;



  DEFINE_STANDARD_RTTI(Visual3d_TransientManager)

protected:




private: 




};





// other Inline functions and methods (like "C++: function call" methods)


#endif
