/*################################################################################
# Linux Management Providers (LMP), Simple Identity Management provider package
# Copyright (C) 2007 Frederic Desmons, ETRI <desmons@etri.re.kr, desmons_frederic@yahoo.fr>
# 
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
# 
# Modified by 2009 Khahramon NURIDDINOV, TUIT <qahramon0786@gmail.com>
# Modified by 2009 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr>
################################################################################*/

#include "cmpiOpenDRIM_GroupOnSystem.h"

CMPIObjectPath* Simple_Identity_Management_OpenDRIM_GroupOnSystem_toCMPIObjectPath(const CMPIBroker* broker, const OpenDRIM_GroupOnSystem& instance) {
	_E_;
	Objectpath op(broker, OpenDRIM_GroupOnSystem_classnames[0], OpenDRIM_GroupOnSystem_NAMESPACE);

	if (!instance.OwningElement_isNULL)
		op.addKey("OwningElement", instance.OwningElement);

	if (!instance.OwnedElement_isNULL)
		op.addKey("OwnedElement", instance.OwnedElement);

	_L_;
	return op.getHdl();
}

CMPIInstance* Simple_Identity_Management_OpenDRIM_GroupOnSystem_toCMPIInstance(const CMPIBroker* broker, const OpenDRIM_GroupOnSystem& instance) {
	_E_;
	Objectpath op(broker, Simple_Identity_Management_OpenDRIM_GroupOnSystem_toCMPIObjectPath(broker, instance));
	Instance ci(broker, op);

	_L_;
	return ci.getHdl();
}

void Simple_Identity_Management_OpenDRIM_GroupOnSystem_toCPP(const CMPIBroker* broker, const CMPIObjectPath* ref, OpenDRIM_GroupOnSystem& instance) {
	_E_;
	Objectpath op(broker, (CMPIObjectPath*) ref);

	if (op.getKey("OwnedElement", instance.OwnedElement) == OK)
		instance.OwnedElement_isNULL = false;

	if (op.getKey("OwningElement", instance.OwningElement) == OK)
		instance.OwningElement_isNULL = false;

	_L_;
}

void Simple_Identity_Management_OpenDRIM_GroupOnSystem_toCPP(const CMPIBroker* broker, const CMPIInstance* ci, OpenDRIM_GroupOnSystem& instance) {
	_E_;
	Instance inst(broker, (CMPIInstance*) ci);

	if (inst.getProperty("OwningElement", instance.OwningElement) == OK)
		instance.OwningElement_isNULL = false;

	if (inst.getProperty("OwnedElement", instance.OwnedElement) == OK)
		instance.OwnedElement_isNULL = false;

	_L_;
}

