#!/bin/sh -e

VERSION=$2
TAR=../plexus-resources_$VERSION.orig.tar.gz
DIR=plexus-resources-$VERSION
TAG=$(echo "plexus-resources-$VERSION" | sed -re's/~(alpha|beta)/-\1-/')

svn export http://svn.codehaus.org/plexus/plexus-components/tags/${TAG}/ $DIR
GZIP=--best tar -c -z -f $TAR --exclude '*.jar' --exclude '*.class' $DIR
rm -rf $DIR ../$TAG

# move to directory 'tarballs'
if [ -r .svn/deb-layout ]; then
  . .svn/deb-layout
  mv $TAR $origDir && echo "moved $TAR to $origDir"
fi
