# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum, EnumMeta
from six import with_metaclass

class _CaseInsensitiveEnumMeta(EnumMeta):
    def __getitem__(self, name):
        return super().__getitem__(name.upper())

    def __getattr__(cls, name):
        """Return the enum member matching `name`
        We use __getattr__ instead of descriptors or inserting into the enum
        class' __dict__ in order to support `name` and `value` being both
        properties for enum members (which live in the class' __dict__) and
        enum members themselves.
        """
        try:
            return cls._member_map_[name.upper()]
        except KeyError:
            raise AttributeError(name)


class ProvisioningErrorCode(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Error code of the provisioning failure
    """

    BAD_SOURCE_TYPE = "BadSourceType"
    BAD_PIR_SOURCE = "BadPIRSource"
    BAD_MANAGED_IMAGE_SOURCE = "BadManagedImageSource"
    BAD_SHARED_IMAGE_VERSION_SOURCE = "BadSharedImageVersionSource"
    BAD_CUSTOMIZER_TYPE = "BadCustomizerType"
    UNSUPPORTED_CUSTOMIZER_TYPE = "UnsupportedCustomizerType"
    NO_CUSTOMIZER_SCRIPT = "NoCustomizerScript"
    BAD_DISTRIBUTE_TYPE = "BadDistributeType"
    BAD_SHARED_IMAGE_DISTRIBUTE = "BadSharedImageDistribute"
    SERVER_ERROR = "ServerError"
    OTHER = "Other"

class ProvisioningState(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Provisioning state of the resource
    """

    CREATING = "Creating"
    UPDATING = "Updating"
    SUCCEEDED = "Succeeded"
    FAILED = "Failed"
    DELETING = "Deleting"

class ResourceIdentityType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The type of identity used for the image template. The type 'None' will remove any identities
    from the image template.
    """

    USER_ASSIGNED = "UserAssigned"
    NONE = "None"

class RunState(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """State of the last run
    """

    RUNNING = "Running"
    CANCELING = "Canceling"
    SUCCEEDED = "Succeeded"
    PARTIALLY_SUCCEEDED = "PartiallySucceeded"
    FAILED = "Failed"
    CANCELED = "Canceled"

class RunSubState(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Sub-state of the last run
    """

    QUEUED = "Queued"
    BUILDING = "Building"
    CUSTOMIZING = "Customizing"
    DISTRIBUTING = "Distributing"

class SharedImageStorageAccountType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Storage account type to be used to store the shared image. Omit to use the default
    (Standard_LRS).
    """

    STANDARD_LRS = "Standard_LRS"
    STANDARD_ZRS = "Standard_ZRS"
