# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.resourcehealth.aio import ResourceHealthMgmtClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestResourceHealthMgmtImpactedResourcesOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(ResourceHealthMgmtClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_list_by_subscription_id_and_event_id(self, resource_group):
        response = self.client.impacted_resources.list_by_subscription_id_and_event_id(
            event_tracking_id="str",
            api_version="2023-10-01-preview",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_get(self, resource_group):
        response = await self.client.impacted_resources.get(
            event_tracking_id="str",
            impacted_resource_name="str",
            api_version="2023-10-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_list_by_tenant_id_and_event_id(self, resource_group):
        response = self.client.impacted_resources.list_by_tenant_id_and_event_id(
            event_tracking_id="str",
            api_version="2023-10-01-preview",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_get_by_tenant_id(self, resource_group):
        response = await self.client.impacted_resources.get_by_tenant_id(
            event_tracking_id="str",
            impacted_resource_name="str",
            api_version="2023-10-01-preview",
        )

        # please add some check logic here by yourself
        # ...
