# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.servicelinker import ServiceLinkerManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.live_test_only
class TestServiceLinkerManagementConnectorOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(ServiceLinkerManagementClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_list_dryrun(self, resource_group):
        response = self.client.connector.list_dryrun(
            subscription_id=self.get_settings_value("SUBSCRIPTION_ID"),
            resource_group_name=resource_group.name,
            location=AZURE_LOCATION,
        )
        result = [r for r in response]
        assert result == []


    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_list(self, resource_group):
        response = self.client.connector.list(
            subscription_id=self.get_settings_value("SUBSCRIPTION_ID"),
            resource_group_name=resource_group.name,
            location=AZURE_LOCATION,
        )
        result = [r for r in response]
        assert result == []
